import{s as Cd,n as bd,o as Pd}from"../chunks/scheduler.0219f8bd.js";import{S as Hd,i as wd,g as d,s as r,r as c,A as Md,h as o,f as i,c as u,j as n,u as p,x as s,k as a,y as Qd,a as l,v as f,d as h,t as m,w as T}from"../chunks/index.f61edf3b.js";import{H as $,E as Ad}from"../chunks/EditOnGithub.48fa589f.js";function Nd(su){let _,Kt,gt,jt,y,Dt,L,Ut,k,au="Custom data structures.",Bt,v,nu=`These are only used internally, meaning an end-user shouldn’t
need to access anything here.`,St,x,cu='<li><a href="#module_utils/data-structures">utils/data-structures</a><ul><li><em>static</em><ul><li><a href="#module_utils/data-structures.PriorityQueue">.PriorityQueue</a><ul><li><a href="#new_module_utils/data-structures.PriorityQueue_new"><code>new PriorityQueue(comparator)</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+size"><code>.size</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+isEmpty"><code>.isEmpty()</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+peek"><code>.peek()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+push"><code>.push(...values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+extend"><code>.extend(values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+pop"><code>.pop()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+replace"><code>.replace(value)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+_siftUpFrom"><code>._siftUpFrom(node)</code></a></li></ul></li> <li><a href="#module_utils/data-structures.CharTrie">.CharTrie</a><ul><li><a href="#module_utils/data-structures.CharTrie+extend"><code>.extend(texts)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+push"><code>.push(text)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+commonPrefixSearch"><code>.commonPrefixSearch(text)</code></a></li></ul></li> <li><a href="#module_utils/data-structures.TokenLattice">.TokenLattice</a><ul><li><a href="#new_module_utils/data-structures.TokenLattice_new"><code>new TokenLattice(sentence, bosTokenId, eosTokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+insert"><code>.insert(pos, length, score, tokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+viterbi"><code>.viterbi()</code></a> ⇒ <code>Array.&lt;TokenLatticeNode&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+piece"><code>.piece(node)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokens"><code>.tokens()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokenIds"><code>.tokenIds()</code></a> ⇒ <code>Array</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/data-structures..CharTrieNode">~CharTrieNode</a><ul><li><a href="#new_module_utils/data-structures..CharTrieNode_new"><code>new CharTrieNode(isLeaf, children)</code></a></li> <li><a href="#module_utils/data-structures..CharTrieNode.default"><code>.default()</code></a> ⇒ <code>CharTrieNode</code></li></ul></li> <li><a href="#module_utils/data-structures..TokenLatticeNode">~TokenLatticeNode</a><ul><li><a href="#new_module_utils/data-structures..TokenLatticeNode_new"><code>new TokenLatticeNode(tokenId, nodeId, pos, length, score)</code></a></li> <li><a href="#module_utils/data-structures..TokenLatticeNode+clone"><code>.clone()</code></a> ⇒ <code>TokenLatticeNode</code></li></ul></li></ul></li></ul></li>',Ft,Gt,Ot,C,Vt,b,Wt,P,pu=`Efficient Heap-based Implementation of a Priority Queue.
It uses an array-based binary heap, where the root is at index <code>0</code>, and the
children of node <code>i</code> are located at indices <code>2i + 1</code> and <code>2i + 2</code>, respectively.`,Jt,H,fu="Adapted from the following sources:",Xt,w,hu='<li><a href="https://stackoverflow.com/a/42919752/13989043" rel="nofollow">https://stackoverflow.com/a/42919752/13989043</a> (original)</li> <li><a href="https://github.com/belladoreai/llama-tokenizer-js" rel="nofollow">https://github.com/belladoreai/llama-tokenizer-js</a> (minor improvements)</li>',Yt,M,mu='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Zt,Q,Tu='<li><a href="#module_utils/data-structures.PriorityQueue">.PriorityQueue</a><ul><li><a href="#new_module_utils/data-structures.PriorityQueue_new"><code>new PriorityQueue(comparator)</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+size"><code>.size</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+isEmpty"><code>.isEmpty()</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+peek"><code>.peek()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+push"><code>.push(...values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+extend"><code>.extend(values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+pop"><code>.pop()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+replace"><code>.replace(value)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+_siftUpFrom"><code>._siftUpFrom(node)</code></a></li></ul></li>',ei,ti,ii,A,li,N,ri,q,$u="Create a new PriorityQueue.",ui,E,_u="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>comparator</td><td><code>function</code></td><td><p>Comparator function to determine priority. Defaults to a MaxHeap.</p></td></tr></tbody>",di,oi,si,R,ai,I,ni,g,yu="The size of the queue",ci,z,Lu='<strong>Kind</strong>: instance property of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a>',pi,fi,hi,K,mi,j,Ti,D,ku="Check if the queue is empty.",$i,U,vu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - <code>true</code> if the queue is empty, <code>false</code> otherwise.',_i,yi,Li,B,ki,S,vi,F,xu="Return the element with the highest priority in the queue.",xi,G,Cu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>any</code> - The highest priority element in the queue.',Ci,bi,Pi,O,Hi,V,wi,W,bu="Add one or more elements to the queue.",Mi,J,Pu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>number</code> - The new size of the queue.',Qi,X,Hu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...values</td><td><code>any</code></td><td><p>The values to push into the queue.</p></td></tr></tbody>",Ai,Ni,qi,Y,Ei,Z,Ri,ee,wu="Add multiple elements to the queue.",Ii,te,Mu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>number</code> - The new size of the queue.',gi,ie,Qu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>values</td><td><code>Array.&lt;any&gt;</code></td><td><p>The values to push into the queue.</p></td></tr></tbody>",zi,Ki,ji,le,Di,re,Ui,ue,Au="Remove and return the element with the highest priority in the queue.",Bi,de,Nu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>any</code> - The element with the highest priority in the queue.',Si,Fi,Gi,oe,Oi,se,Vi,ae,qu="Replace the element with the highest priority in the queue with a new value.",Wi,ne,Eu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>*</code> - The replaced value.',Ji,ce,Ru="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>value</td><td><code>*</code></td><td><p>The new value.</p></td></tr></tbody>",Xi,Yi,Zi,pe,el,fe,tl,he,Iu="Helper function to sift up from a given node.",il,me,gu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a>',ll,Te,zu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>node</td><td><code>number</code></td><td><p>The index of the node to start sifting up from.</p></td></tr></tbody>",rl,ul,dl,$e,ol,_e,sl,ye,Ku="A trie structure to efficiently store and search for strings.",al,Le,ju='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',nl,ke,Du='<li><a href="#module_utils/data-structures.CharTrie">.CharTrie</a><ul><li><a href="#module_utils/data-structures.CharTrie+extend"><code>.extend(texts)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+push"><code>.push(text)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+commonPrefixSearch"><code>.commonPrefixSearch(text)</code></a></li></ul></li>',cl,pl,fl,ve,hl,xe,ml,Ce,Uu="Adds one or more <code>texts</code> to the trie.",Tl,be,Bu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',$l,Pe,Su="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>Array.&lt;string&gt;</code></td><td><p>The strings to add to the trie.</p></td></tr></tbody>",_l,yl,Ll,He,kl,we,vl,Me,Fu="Adds text to the trie.",xl,Qe,Gu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',Cl,Ae,Ou="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The string to add to the trie.</p></td></tr></tbody>",bl,Pl,Hl,Ne,wl,qe,Ml,Ee,Vu="Searches the trie for all strings with a common prefix of <code>text</code>.",Ql,Re,Wu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',Al,Ie,Ju="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The common prefix to search for.</p></td></tr></tbody>",Nl,ql,El,ge,Rl,ze,Il,Ke,Xu="A lattice data structure to be used for tokenization.",gl,je,Yu='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',zl,De,Zu='<li><a href="#module_utils/data-structures.TokenLattice">.TokenLattice</a><ul><li><a href="#new_module_utils/data-structures.TokenLattice_new"><code>new TokenLattice(sentence, bosTokenId, eosTokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+insert"><code>.insert(pos, length, score, tokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+viterbi"><code>.viterbi()</code></a> ⇒ <code>Array.&lt;TokenLatticeNode&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+piece"><code>.piece(node)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokens"><code>.tokens()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokenIds"><code>.tokenIds()</code></a> ⇒ <code>Array</code></li></ul></li>',Kl,jl,Dl,Ue,Ul,Be,Bl,Se,ed="Creates a new TokenLattice instance.",Sl,Fe,td="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>sentence</td><td><code>string</code></td><td><p>The input sentence to be tokenized.</p></td> </tr><tr><td>bosTokenId</td><td><code>number</code></td><td><p>The beginning-of-sequence token ID.</p></td> </tr><tr><td>eosTokenId</td><td><code>number</code></td><td><p>The end-of-sequence token ID.</p></td></tr></tbody>",Fl,Gl,Ol,Ge,Vl,Oe,Wl,Ve,id="Inserts a new token node into the token lattice.",Jl,We,ld='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a>',Xl,Je,rd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pos</td><td><code>number</code></td><td><p>The starting position of the token.</p></td> </tr><tr><td>length</td><td><code>number</code></td><td><p>The length of the token.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score of the token.</p></td> </tr><tr><td>tokenId</td><td><code>number</code></td><td><p>The token ID of the token.</p></td></tr></tbody>",Yl,Zl,er,Xe,tr,Ye,ir,Ze,ud="Implements the Viterbi algorithm to compute the most likely sequence of tokens.",lr,et,dd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;TokenLatticeNode&gt;</code> - The array of nodes representing the most likely sequence of tokens.',rr,ur,dr,tt,or,it,sr,lt,od='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>string</code> - The array of nodes representing the most likely sequence of tokens.',ar,rt,sd="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>node</td><td><code>TokenLatticeNode</code></td></tr></tbody>",nr,cr,pr,ut,fr,dt,hr,ot,ad='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array</code> - The array of nodes representing the most likely sequence of tokens.',mr,Tr,$r,st,_r,at,yr,nt,nd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array</code> - The array of nodes representing the most likely sequence of tokens.',Lr,kr,vr,ct,xr,pt,Cr,ft,cd="Represents a node in a character trie.",br,ht,pd='<strong>Kind</strong>: inner class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Pr,mt,fd='<li><a href="#module_utils/data-structures..CharTrieNode">~CharTrieNode</a><ul><li><a href="#new_module_utils/data-structures..CharTrieNode_new"><code>new CharTrieNode(isLeaf, children)</code></a></li> <li><a href="#module_utils/data-structures..CharTrieNode.default"><code>.default()</code></a> ⇒ <code>CharTrieNode</code></li></ul></li>',Hr,wr,Mr,Tt,Qr,$t,Ar,_t,hd="Create a new CharTrieNode.",Nr,yt,md="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>isLeaf</td><td><code>boolean</code></td><td><p>Whether the node is a leaf node or not.</p></td> </tr><tr><td>children</td><td><code>Map.&lt;string, CharTrieNode&gt;</code></td><td><p>A map containing the node&#39;s children, where the key is a character and the value is a <code>CharTrieNode</code>.</p></td></tr></tbody>",qr,Er,Rr,Lt,Ir,kt,gr,vt,Td="Returns a new <code>CharTrieNode</code> instance with default values.",zr,xt,$d='<strong>Kind</strong>: static method of <a href="#module_utils/data-structures..CharTrieNode"><code>CharTrieNode</code></a><br/> <strong>Returns</strong>: <code>CharTrieNode</code> - A new <code>CharTrieNode</code> instance with <code>isLeaf</code> set to <code>false</code> and an empty <code>children</code> map.',Kr,jr,Dr,Ct,Ur,bt,Br,Pt,_d='<strong>Kind</strong>: inner class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Sr,Ht,yd='<li><a href="#module_utils/data-structures..TokenLatticeNode">~TokenLatticeNode</a><ul><li><a href="#new_module_utils/data-structures..TokenLatticeNode_new"><code>new TokenLatticeNode(tokenId, nodeId, pos, length, score)</code></a></li> <li><a href="#module_utils/data-structures..TokenLatticeNode+clone"><code>.clone()</code></a> ⇒ <code>TokenLatticeNode</code></li></ul></li>',Fr,Gr,Or,wt,Vr,Mt,Wr,Qt,Ld="Represents a node in a token lattice for a given sentence.",Jr,At,kd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tokenId</td><td><code>number</code></td><td><p>The ID of the token associated with this node.</p></td> </tr><tr><td>nodeId</td><td><code>number</code></td><td><p>The ID of this node.</p></td> </tr><tr><td>pos</td><td><code>number</code></td><td><p>The starting position of the token in the sentence.</p></td> </tr><tr><td>length</td><td><code>number</code></td><td><p>The length of the token.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score associated with the token.</p></td></tr></tbody>",Xr,Yr,Zr,Nt,eu,qt,tu,Et,vd="Returns a clone of this node.",iu,Rt,xd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures..TokenLatticeNode"><code>TokenLatticeNode</code></a><br/> <strong>Returns</strong>: <code>TokenLatticeNode</code> - A clone of this node.',lu,ru,uu,It,du,zt,ou;return L=new $({props:{title:"utils/data-structures",local:"utilsdata-structures",headingTag:"h1"}}),b=new $({props:{title:"utils/data-structures.PriorityQueue",local:"utilsdata-structurespriorityqueue",headingTag:"h2"}}),N=new $({props:{title:"new PriorityQueue(comparator)",local:"new-priorityqueuecomparator",headingTag:"h3"}}),I=new $({props:{title:"priorityQueue.size",local:"priorityqueuesize",headingTag:"h3"}}),j=new $({props:{title:"priorityQueue.isEmpty() ⇒ <code> boolean </code>",local:"priorityqueueisempty--code-boolean-code",headingTag:"h3"}}),S=new $({props:{title:"priorityQueue.peek() ⇒ <code> any </code>",local:"priorityqueuepeek--code-any-code",headingTag:"h3"}}),V=new $({props:{title:"priorityQueue.push(...values) ⇒ <code> number </code>",local:"priorityqueuepushvalues--code-number-code",headingTag:"h3"}}),Z=new $({props:{title:"priorityQueue.extend(values) ⇒ <code> number </code>",local:"priorityqueueextendvalues--code-number-code",headingTag:"h3"}}),re=new $({props:{title:"priorityQueue.pop() ⇒ <code> any </code>",local:"priorityqueuepop--code-any-code",headingTag:"h3"}}),se=new $({props:{title:"priorityQueue.replace(value) ⇒ <code> * </code>",local:"priorityqueuereplacevalue--code--code",headingTag:"h3"}}),fe=new $({props:{title:"priorityQueue._siftUpFrom(node)",local:"priorityqueuesiftupfromnode",headingTag:"h3"}}),_e=new $({props:{title:"utils/data-structures.CharTrie",local:"utilsdata-structureschartrie",headingTag:"h2"}}),xe=new $({props:{title:"charTrie.extend(texts)",local:"chartrieextendtexts",headingTag:"h3"}}),we=new $({props:{title:"charTrie.push(text)",local:"chartriepushtext",headingTag:"h3"}}),qe=new $({props:{title:"charTrie.commonPrefixSearch(text)",local:"chartriecommonprefixsearchtext",headingTag:"h3"}}),ze=new $({props:{title:"utils/data-structures.TokenLattice",local:"utilsdata-structurestokenlattice",headingTag:"h2"}}),Be=new $({props:{title:"new TokenLattice(sentence, bosTokenId, eosTokenId)",local:"new-tokenlatticesentence-bostokenid-eostokenid",headingTag:"h3"}}),Oe=new $({props:{title:"tokenLattice.insert(pos, length, score, tokenId)",local:"tokenlatticeinsertpos-length-score-tokenid",headingTag:"h3"}}),Ye=new $({props:{title:"tokenLattice.viterbi() ⇒ <code> Array. < TokenLatticeNode > </code>",local:"tokenlatticeviterbi--code-array--tokenlatticenode--code",headingTag:"h3"}}),it=new $({props:{title:"tokenLattice.piece(node) ⇒ <code> string </code>",local:"tokenlatticepiecenode--code-string-code",headingTag:"h3"}}),dt=new $({props:{title:"tokenLattice.tokens() ⇒ <code> Array </code>",local:"tokenlatticetokens--code-array-code",headingTag:"h3"}}),at=new $({props:{title:"tokenLattice.tokenIds() ⇒ <code> Array </code>",local:"tokenlatticetokenids--code-array-code",headingTag:"h3"}}),pt=new $({props:{title:"utils/data-structures~CharTrieNode",local:"utilsdata-structureschartrienode",headingTag:"h2"}}),$t=new $({props:{title:"new CharTrieNode(isLeaf, children)",local:"new-chartrienodeisleaf-children",headingTag:"h3"}}),kt=new $({props:{title:"CharTrieNode.default() ⇒ <code> CharTrieNode </code>",local:"chartrienodedefault--code-chartrienode-code",headingTag:"h3"}}),bt=new $({props:{title:"utils/data-structures~TokenLatticeNode",local:"utilsdata-structurestokenlatticenode",headingTag:"h2"}}),Mt=new $({props:{title:"new TokenLatticeNode(tokenId, nodeId, pos, length, score)",local:"new-tokenlatticenodetokenid-nodeid-pos-length-score",headingTag:"h3"}}),qt=new $({props:{title:"tokenLatticeNode.clone() ⇒ <code> TokenLatticeNode </code>",local:"tokenlatticenodeclone--code-tokenlatticenode-code",headingTag:"h3"}}),It=new Ad({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/api/utils/data-structures.md"}}),{c(){_=d("meta"),Kt=r(),gt=d("p"),jt=r(),y=d("a"),Dt=r(),c(L.$$.fragment),Ut=r(),k=d("p"),k.textContent=au,Bt=r(),v=d("p"),v.textContent=nu,St=r(),x=d("ul"),x.innerHTML=cu,Ft=r(),Gt=d("hr"),Ot=r(),C=d("a"),Vt=r(),c(b.$$.fragment),Wt=r(),P=d("p"),P.innerHTML=pu,Jt=r(),H=d("p"),H.textContent=fu,Xt=r(),w=d("ul"),w.innerHTML=hu,Yt=r(),M=d("p"),M.innerHTML=mu,Zt=r(),Q=d("ul"),Q.innerHTML=Tu,ei=r(),ti=d("hr"),ii=r(),A=d("a"),li=r(),c(N.$$.fragment),ri=r(),q=d("p"),q.textContent=$u,ui=r(),E=d("table"),E.innerHTML=_u,di=r(),oi=d("hr"),si=r(),R=d("a"),ai=r(),c(I.$$.fragment),ni=r(),g=d("p"),g.textContent=yu,ci=r(),z=d("p"),z.innerHTML=Lu,pi=r(),fi=d("hr"),hi=r(),K=d("a"),mi=r(),c(j.$$.fragment),Ti=r(),D=d("p"),D.textContent=ku,$i=r(),U=d("p"),U.innerHTML=vu,_i=r(),yi=d("hr"),Li=r(),B=d("a"),ki=r(),c(S.$$.fragment),vi=r(),F=d("p"),F.textContent=xu,xi=r(),G=d("p"),G.innerHTML=Cu,Ci=r(),bi=d("hr"),Pi=r(),O=d("a"),Hi=r(),c(V.$$.fragment),wi=r(),W=d("p"),W.textContent=bu,Mi=r(),J=d("p"),J.innerHTML=Pu,Qi=r(),X=d("table"),X.innerHTML=Hu,Ai=r(),Ni=d("hr"),qi=r(),Y=d("a"),Ei=r(),c(Z.$$.fragment),Ri=r(),ee=d("p"),ee.textContent=wu,Ii=r(),te=d("p"),te.innerHTML=Mu,gi=r(),ie=d("table"),ie.innerHTML=Qu,zi=r(),Ki=d("hr"),ji=r(),le=d("a"),Di=r(),c(re.$$.fragment),Ui=r(),ue=d("p"),ue.textContent=Au,Bi=r(),de=d("p"),de.innerHTML=Nu,Si=r(),Fi=d("hr"),Gi=r(),oe=d("a"),Oi=r(),c(se.$$.fragment),Vi=r(),ae=d("p"),ae.textContent=qu,Wi=r(),ne=d("p"),ne.innerHTML=Eu,Ji=r(),ce=d("table"),ce.innerHTML=Ru,Xi=r(),Yi=d("hr"),Zi=r(),pe=d("a"),el=r(),c(fe.$$.fragment),tl=r(),he=d("p"),he.textContent=Iu,il=r(),me=d("p"),me.innerHTML=gu,ll=r(),Te=d("table"),Te.innerHTML=zu,rl=r(),ul=d("hr"),dl=r(),$e=d("a"),ol=r(),c(_e.$$.fragment),sl=r(),ye=d("p"),ye.textContent=Ku,al=r(),Le=d("p"),Le.innerHTML=ju,nl=r(),ke=d("ul"),ke.innerHTML=Du,cl=r(),pl=d("hr"),fl=r(),ve=d("a"),hl=r(),c(xe.$$.fragment),ml=r(),Ce=d("p"),Ce.innerHTML=Uu,Tl=r(),be=d("p"),be.innerHTML=Bu,$l=r(),Pe=d("table"),Pe.innerHTML=Su,_l=r(),yl=d("hr"),Ll=r(),He=d("a"),kl=r(),c(we.$$.fragment),vl=r(),Me=d("p"),Me.textContent=Fu,xl=r(),Qe=d("p"),Qe.innerHTML=Gu,Cl=r(),Ae=d("table"),Ae.innerHTML=Ou,bl=r(),Pl=d("hr"),Hl=r(),Ne=d("a"),wl=r(),c(qe.$$.fragment),Ml=r(),Ee=d("p"),Ee.innerHTML=Vu,Ql=r(),Re=d("p"),Re.innerHTML=Wu,Al=r(),Ie=d("table"),Ie.innerHTML=Ju,Nl=r(),ql=d("hr"),El=r(),ge=d("a"),Rl=r(),c(ze.$$.fragment),Il=r(),Ke=d("p"),Ke.textContent=Xu,gl=r(),je=d("p"),je.innerHTML=Yu,zl=r(),De=d("ul"),De.innerHTML=Zu,Kl=r(),jl=d("hr"),Dl=r(),Ue=d("a"),Ul=r(),c(Be.$$.fragment),Bl=r(),Se=d("p"),Se.textContent=ed,Sl=r(),Fe=d("table"),Fe.innerHTML=td,Fl=r(),Gl=d("hr"),Ol=r(),Ge=d("a"),Vl=r(),c(Oe.$$.fragment),Wl=r(),Ve=d("p"),Ve.textContent=id,Jl=r(),We=d("p"),We.innerHTML=ld,Xl=r(),Je=d("table"),Je.innerHTML=rd,Yl=r(),Zl=d("hr"),er=r(),Xe=d("a"),tr=r(),c(Ye.$$.fragment),ir=r(),Ze=d("p"),Ze.textContent=ud,lr=r(),et=d("p"),et.innerHTML=dd,rr=r(),ur=d("hr"),dr=r(),tt=d("a"),or=r(),c(it.$$.fragment),sr=r(),lt=d("p"),lt.innerHTML=od,ar=r(),rt=d("table"),rt.innerHTML=sd,nr=r(),cr=d("hr"),pr=r(),ut=d("a"),fr=r(),c(dt.$$.fragment),hr=r(),ot=d("p"),ot.innerHTML=ad,mr=r(),Tr=d("hr"),$r=r(),st=d("a"),_r=r(),c(at.$$.fragment),yr=r(),nt=d("p"),nt.innerHTML=nd,Lr=r(),kr=d("hr"),vr=r(),ct=d("a"),xr=r(),c(pt.$$.fragment),Cr=r(),ft=d("p"),ft.textContent=cd,br=r(),ht=d("p"),ht.innerHTML=pd,Pr=r(),mt=d("ul"),mt.innerHTML=fd,Hr=r(),wr=d("hr"),Mr=r(),Tt=d("a"),Qr=r(),c($t.$$.fragment),Ar=r(),_t=d("p"),_t.textContent=hd,Nr=r(),yt=d("table"),yt.innerHTML=md,qr=r(),Er=d("hr"),Rr=r(),Lt=d("a"),Ir=r(),c(kt.$$.fragment),gr=r(),vt=d("p"),vt.innerHTML=Td,zr=r(),xt=d("p"),xt.innerHTML=$d,Kr=r(),jr=d("hr"),Dr=r(),Ct=d("a"),Ur=r(),c(bt.$$.fragment),Br=r(),Pt=d("p"),Pt.innerHTML=_d,Sr=r(),Ht=d("ul"),Ht.innerHTML=yd,Fr=r(),Gr=d("hr"),Or=r(),wt=d("a"),Vr=r(),c(Mt.$$.fragment),Wr=r(),Qt=d("p"),Qt.textContent=Ld,Jr=r(),At=d("table"),At.innerHTML=kd,Xr=r(),Yr=d("hr"),Zr=r(),Nt=d("a"),eu=r(),c(qt.$$.fragment),tu=r(),Et=d("p"),Et.textContent=vd,iu=r(),Rt=d("p"),Rt.innerHTML=xd,lu=r(),ru=d("hr"),uu=r(),c(It.$$.fragment),du=r(),zt=d("p"),this.h()},l(e){const t=Md("svelte-u9bgzb",document.head);_=o(t,"META",{name:!0,content:!0}),t.forEach(i),Kt=u(e),gt=o(e,"P",{}),n(gt).forEach(i),jt=u(e),y=o(e,"A",{id:!0,class:!0}),n(y).forEach(i),Dt=u(e),p(L.$$.fragment,e),Ut=u(e),k=o(e,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1aeeeid"&&(k.textContent=au),Bt=u(e),v=o(e,"P",{"data-svelte-h":!0}),s(v)!=="svelte-1r3ntfo"&&(v.textContent=nu),St=u(e),x=o(e,"UL",{"data-svelte-h":!0}),s(x)!=="svelte-qznbo0"&&(x.innerHTML=cu),Ft=u(e),Gt=o(e,"HR",{}),Ot=u(e),C=o(e,"A",{id:!0,class:!0}),n(C).forEach(i),Vt=u(e),p(b.$$.fragment,e),Wt=u(e),P=o(e,"P",{"data-svelte-h":!0}),s(P)!=="svelte-1ux83uj"&&(P.innerHTML=pu),Jt=u(e),H=o(e,"P",{"data-svelte-h":!0}),s(H)!=="svelte-vi2pz9"&&(H.textContent=fu),Xt=u(e),w=o(e,"UL",{"data-svelte-h":!0}),s(w)!=="svelte-qlvgg9"&&(w.innerHTML=hu),Yt=u(e),M=o(e,"P",{"data-svelte-h":!0}),s(M)!=="svelte-1saulos"&&(M.innerHTML=mu),Zt=u(e),Q=o(e,"UL",{"data-svelte-h":!0}),s(Q)!=="svelte-fzyqbp"&&(Q.innerHTML=Tu),ei=u(e),ti=o(e,"HR",{}),ii=u(e),A=o(e,"A",{id:!0,class:!0}),n(A).forEach(i),li=u(e),p(N.$$.fragment,e),ri=u(e),q=o(e,"P",{"data-svelte-h":!0}),s(q)!=="svelte-1dgukb8"&&(q.textContent=$u),ui=u(e),E=o(e,"TABLE",{"data-svelte-h":!0}),s(E)!=="svelte-15lsmj7"&&(E.innerHTML=_u),di=u(e),oi=o(e,"HR",{}),si=u(e),R=o(e,"A",{id:!0,class:!0}),n(R).forEach(i),ai=u(e),p(I.$$.fragment,e),ni=u(e),g=o(e,"P",{"data-svelte-h":!0}),s(g)!=="svelte-19ll7y9"&&(g.textContent=yu),ci=u(e),z=o(e,"P",{"data-svelte-h":!0}),s(z)!=="svelte-1spompf"&&(z.innerHTML=Lu),pi=u(e),fi=o(e,"HR",{}),hi=u(e),K=o(e,"A",{id:!0,class:!0}),n(K).forEach(i),mi=u(e),p(j.$$.fragment,e),Ti=u(e),D=o(e,"P",{"data-svelte-h":!0}),s(D)!=="svelte-iwo0ja"&&(D.textContent=ku),$i=u(e),U=o(e,"P",{"data-svelte-h":!0}),s(U)!=="svelte-usw3zo"&&(U.innerHTML=vu),_i=u(e),yi=o(e,"HR",{}),Li=u(e),B=o(e,"A",{id:!0,class:!0}),n(B).forEach(i),ki=u(e),p(S.$$.fragment,e),vi=u(e),F=o(e,"P",{"data-svelte-h":!0}),s(F)!=="svelte-1g38rzl"&&(F.textContent=xu),xi=u(e),G=o(e,"P",{"data-svelte-h":!0}),s(G)!=="svelte-1jn2os3"&&(G.innerHTML=Cu),Ci=u(e),bi=o(e,"HR",{}),Pi=u(e),O=o(e,"A",{id:!0,class:!0}),n(O).forEach(i),Hi=u(e),p(V.$$.fragment,e),wi=u(e),W=o(e,"P",{"data-svelte-h":!0}),s(W)!=="svelte-1o3p42d"&&(W.textContent=bu),Mi=u(e),J=o(e,"P",{"data-svelte-h":!0}),s(J)!=="svelte-1hty3q7"&&(J.innerHTML=Pu),Qi=u(e),X=o(e,"TABLE",{"data-svelte-h":!0}),s(X)!=="svelte-19plha1"&&(X.innerHTML=Hu),Ai=u(e),Ni=o(e,"HR",{}),qi=u(e),Y=o(e,"A",{id:!0,class:!0}),n(Y).forEach(i),Ei=u(e),p(Z.$$.fragment,e),Ri=u(e),ee=o(e,"P",{"data-svelte-h":!0}),s(ee)!=="svelte-1rf8gmz"&&(ee.textContent=wu),Ii=u(e),te=o(e,"P",{"data-svelte-h":!0}),s(te)!=="svelte-1hty3q7"&&(te.innerHTML=Mu),gi=u(e),ie=o(e,"TABLE",{"data-svelte-h":!0}),s(ie)!=="svelte-txh99d"&&(ie.innerHTML=Qu),zi=u(e),Ki=o(e,"HR",{}),ji=u(e),le=o(e,"A",{id:!0,class:!0}),n(le).forEach(i),Di=u(e),p(re.$$.fragment,e),Ui=u(e),ue=o(e,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-1l3oksc"&&(ue.textContent=Au),Bi=u(e),de=o(e,"P",{"data-svelte-h":!0}),s(de)!=="svelte-vpswb8"&&(de.innerHTML=Nu),Si=u(e),Fi=o(e,"HR",{}),Gi=u(e),oe=o(e,"A",{id:!0,class:!0}),n(oe).forEach(i),Oi=u(e),p(se.$$.fragment,e),Vi=u(e),ae=o(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-7s4t0d"&&(ae.textContent=qu),Wi=u(e),ne=o(e,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-ckytvb"&&(ne.innerHTML=Eu),Ji=u(e),ce=o(e,"TABLE",{"data-svelte-h":!0}),s(ce)!=="svelte-1xv2m9q"&&(ce.innerHTML=Ru),Xi=u(e),Yi=o(e,"HR",{}),Zi=u(e),pe=o(e,"A",{id:!0,class:!0}),n(pe).forEach(i),el=u(e),p(fe.$$.fragment,e),tl=u(e),he=o(e,"P",{"data-svelte-h":!0}),s(he)!=="svelte-hj5sse"&&(he.textContent=Iu),il=u(e),me=o(e,"P",{"data-svelte-h":!0}),s(me)!=="svelte-6p6lmz"&&(me.innerHTML=gu),ll=u(e),Te=o(e,"TABLE",{"data-svelte-h":!0}),s(Te)!=="svelte-fj2fu5"&&(Te.innerHTML=zu),rl=u(e),ul=o(e,"HR",{}),dl=u(e),$e=o(e,"A",{id:!0,class:!0}),n($e).forEach(i),ol=u(e),p(_e.$$.fragment,e),sl=u(e),ye=o(e,"P",{"data-svelte-h":!0}),s(ye)!=="svelte-nklgrc"&&(ye.textContent=Ku),al=u(e),Le=o(e,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-1saulos"&&(Le.innerHTML=ju),nl=u(e),ke=o(e,"UL",{"data-svelte-h":!0}),s(ke)!=="svelte-1yt2jf0"&&(ke.innerHTML=Du),cl=u(e),pl=o(e,"HR",{}),fl=u(e),ve=o(e,"A",{id:!0,class:!0}),n(ve).forEach(i),hl=u(e),p(xe.$$.fragment,e),ml=u(e),Ce=o(e,"P",{"data-svelte-h":!0}),s(Ce)!=="svelte-moeq8l"&&(Ce.innerHTML=Uu),Tl=u(e),be=o(e,"P",{"data-svelte-h":!0}),s(be)!=="svelte-33rax3"&&(be.innerHTML=Bu),$l=u(e),Pe=o(e,"TABLE",{"data-svelte-h":!0}),s(Pe)!=="svelte-18dtsnv"&&(Pe.innerHTML=Su),_l=u(e),yl=o(e,"HR",{}),Ll=u(e),He=o(e,"A",{id:!0,class:!0}),n(He).forEach(i),kl=u(e),p(we.$$.fragment,e),vl=u(e),Me=o(e,"P",{"data-svelte-h":!0}),s(Me)!=="svelte-4q846v"&&(Me.textContent=Fu),xl=u(e),Qe=o(e,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-33rax3"&&(Qe.innerHTML=Gu),Cl=u(e),Ae=o(e,"TABLE",{"data-svelte-h":!0}),s(Ae)!=="svelte-hqwgb9"&&(Ae.innerHTML=Ou),bl=u(e),Pl=o(e,"HR",{}),Hl=u(e),Ne=o(e,"A",{id:!0,class:!0}),n(Ne).forEach(i),wl=u(e),p(qe.$$.fragment,e),Ml=u(e),Ee=o(e,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-bmaw98"&&(Ee.innerHTML=Vu),Ql=u(e),Re=o(e,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-33rax3"&&(Re.innerHTML=Wu),Al=u(e),Ie=o(e,"TABLE",{"data-svelte-h":!0}),s(Ie)!=="svelte-18qxh0x"&&(Ie.innerHTML=Ju),Nl=u(e),ql=o(e,"HR",{}),El=u(e),ge=o(e,"A",{id:!0,class:!0}),n(ge).forEach(i),Rl=u(e),p(ze.$$.fragment,e),Il=u(e),Ke=o(e,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-1xkinx1"&&(Ke.textContent=Xu),gl=u(e),je=o(e,"P",{"data-svelte-h":!0}),s(je)!=="svelte-1saulos"&&(je.innerHTML=Yu),zl=u(e),De=o(e,"UL",{"data-svelte-h":!0}),s(De)!=="svelte-svgbr"&&(De.innerHTML=Zu),Kl=u(e),jl=o(e,"HR",{}),Dl=u(e),Ue=o(e,"A",{id:!0,class:!0}),n(Ue).forEach(i),Ul=u(e),p(Be.$$.fragment,e),Bl=u(e),Se=o(e,"P",{"data-svelte-h":!0}),s(Se)!=="svelte-ziiz62"&&(Se.textContent=ed),Sl=u(e),Fe=o(e,"TABLE",{"data-svelte-h":!0}),s(Fe)!=="svelte-1h8dv5n"&&(Fe.innerHTML=td),Fl=u(e),Gl=o(e,"HR",{}),Ol=u(e),Ge=o(e,"A",{id:!0,class:!0}),n(Ge).forEach(i),Vl=u(e),p(Oe.$$.fragment,e),Wl=u(e),Ve=o(e,"P",{"data-svelte-h":!0}),s(Ve)!=="svelte-1hzq3te"&&(Ve.textContent=id),Jl=u(e),We=o(e,"P",{"data-svelte-h":!0}),s(We)!=="svelte-1bjyh7n"&&(We.innerHTML=ld),Xl=u(e),Je=o(e,"TABLE",{"data-svelte-h":!0}),s(Je)!=="svelte-1a01i2a"&&(Je.innerHTML=rd),Yl=u(e),Zl=o(e,"HR",{}),er=u(e),Xe=o(e,"A",{id:!0,class:!0}),n(Xe).forEach(i),tr=u(e),p(Ye.$$.fragment,e),ir=u(e),Ze=o(e,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-jv0r"&&(Ze.textContent=ud),lr=u(e),et=o(e,"P",{"data-svelte-h":!0}),s(et)!=="svelte-1gfck0d"&&(et.innerHTML=dd),rr=u(e),ur=o(e,"HR",{}),dr=u(e),tt=o(e,"A",{id:!0,class:!0}),n(tt).forEach(i),or=u(e),p(it.$$.fragment,e),sr=u(e),lt=o(e,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-1n9zjoi"&&(lt.innerHTML=od),ar=u(e),rt=o(e,"TABLE",{"data-svelte-h":!0}),s(rt)!=="svelte-6nufyb"&&(rt.innerHTML=sd),nr=u(e),cr=o(e,"HR",{}),pr=u(e),ut=o(e,"A",{id:!0,class:!0}),n(ut).forEach(i),fr=u(e),p(dt.$$.fragment,e),hr=u(e),ot=o(e,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-1oso32i"&&(ot.innerHTML=ad),mr=u(e),Tr=o(e,"HR",{}),$r=u(e),st=o(e,"A",{id:!0,class:!0}),n(st).forEach(i),_r=u(e),p(at.$$.fragment,e),yr=u(e),nt=o(e,"P",{"data-svelte-h":!0}),s(nt)!=="svelte-1oso32i"&&(nt.innerHTML=nd),Lr=u(e),kr=o(e,"HR",{}),vr=u(e),ct=o(e,"A",{id:!0,class:!0}),n(ct).forEach(i),xr=u(e),p(pt.$$.fragment,e),Cr=u(e),ft=o(e,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-1auz3rh"&&(ft.textContent=cd),br=u(e),ht=o(e,"P",{"data-svelte-h":!0}),s(ht)!=="svelte-1p9ver0"&&(ht.innerHTML=pd),Pr=u(e),mt=o(e,"UL",{"data-svelte-h":!0}),s(mt)!=="svelte-4v7sww"&&(mt.innerHTML=fd),Hr=u(e),wr=o(e,"HR",{}),Mr=u(e),Tt=o(e,"A",{id:!0,class:!0}),n(Tt).forEach(i),Qr=u(e),p($t.$$.fragment,e),Ar=u(e),_t=o(e,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-mt1jex"&&(_t.textContent=hd),Nr=u(e),yt=o(e,"TABLE",{"data-svelte-h":!0}),s(yt)!=="svelte-nk427c"&&(yt.innerHTML=md),qr=u(e),Er=o(e,"HR",{}),Rr=u(e),Lt=o(e,"A",{id:!0,class:!0}),n(Lt).forEach(i),Ir=u(e),p(kt.$$.fragment,e),gr=u(e),vt=o(e,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-9cjdkj"&&(vt.innerHTML=Td),zr=u(e),xt=o(e,"P",{"data-svelte-h":!0}),s(xt)!=="svelte-3pigfy"&&(xt.innerHTML=$d),Kr=u(e),jr=o(e,"HR",{}),Dr=u(e),Ct=o(e,"A",{id:!0,class:!0}),n(Ct).forEach(i),Ur=u(e),p(bt.$$.fragment,e),Br=u(e),Pt=o(e,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-1p9ver0"&&(Pt.innerHTML=_d),Sr=u(e),Ht=o(e,"UL",{"data-svelte-h":!0}),s(Ht)!=="svelte-r6qh2h"&&(Ht.innerHTML=yd),Fr=u(e),Gr=o(e,"HR",{}),Or=u(e),wt=o(e,"A",{id:!0,class:!0}),n(wt).forEach(i),Vr=u(e),p(Mt.$$.fragment,e),Wr=u(e),Qt=o(e,"P",{"data-svelte-h":!0}),s(Qt)!=="svelte-vrhdhn"&&(Qt.textContent=Ld),Jr=u(e),At=o(e,"TABLE",{"data-svelte-h":!0}),s(At)!=="svelte-5ahzuq"&&(At.innerHTML=kd),Xr=u(e),Yr=o(e,"HR",{}),Zr=u(e),Nt=o(e,"A",{id:!0,class:!0}),n(Nt).forEach(i),eu=u(e),p(qt.$$.fragment,e),tu=u(e),Et=o(e,"P",{"data-svelte-h":!0}),s(Et)!=="svelte-34g670"&&(Et.textContent=vd),iu=u(e),Rt=o(e,"P",{"data-svelte-h":!0}),s(Rt)!=="svelte-7303j9"&&(Rt.innerHTML=xd),lu=u(e),ru=o(e,"HR",{}),uu=u(e),p(It.$$.fragment,e),du=u(e),zt=o(e,"P",{}),n(zt).forEach(i),this.h()},h(){a(_,"name","hf:doc:metadata"),a(_,"content",qd),a(y,"id","module_utils/data-structures"),a(y,"class","group"),a(C,"id","module_utils/data-structures.PriorityQueue"),a(C,"class","group"),a(A,"id","new_module_utils/data-structures.PriorityQueue_new"),a(A,"class","group"),a(R,"id","module_utils/data-structures.PriorityQueue+size"),a(R,"class","group"),a(K,"id","module_utils/data-structures.PriorityQueue+isEmpty"),a(K,"class","group"),a(B,"id","module_utils/data-structures.PriorityQueue+peek"),a(B,"class","group"),a(O,"id","module_utils/data-structures.PriorityQueue+push"),a(O,"class","group"),a(Y,"id","module_utils/data-structures.PriorityQueue+extend"),a(Y,"class","group"),a(le,"id","module_utils/data-structures.PriorityQueue+pop"),a(le,"class","group"),a(oe,"id","module_utils/data-structures.PriorityQueue+replace"),a(oe,"class","group"),a(pe,"id","module_utils/data-structures.PriorityQueue+_siftUpFrom"),a(pe,"class","group"),a($e,"id","module_utils/data-structures.CharTrie"),a($e,"class","group"),a(ve,"id","module_utils/data-structures.CharTrie+extend"),a(ve,"class","group"),a(He,"id","module_utils/data-structures.CharTrie+push"),a(He,"class","group"),a(Ne,"id","module_utils/data-structures.CharTrie+commonPrefixSearch"),a(Ne,"class","group"),a(ge,"id","module_utils/data-structures.TokenLattice"),a(ge,"class","group"),a(Ue,"id","new_module_utils/data-structures.TokenLattice_new"),a(Ue,"class","group"),a(Ge,"id","module_utils/data-structures.TokenLattice+insert"),a(Ge,"class","group"),a(Xe,"id","module_utils/data-structures.TokenLattice+viterbi"),a(Xe,"class","group"),a(tt,"id","module_utils/data-structures.TokenLattice+piece"),a(tt,"class","group"),a(ut,"id","module_utils/data-structures.TokenLattice+tokens"),a(ut,"class","group"),a(st,"id","module_utils/data-structures.TokenLattice+tokenIds"),a(st,"class","group"),a(ct,"id","module_utils/data-structures..CharTrieNode"),a(ct,"class","group"),a(Tt,"id","new_module_utils/data-structures..CharTrieNode_new"),a(Tt,"class","group"),a(Lt,"id","module_utils/data-structures..CharTrieNode.default"),a(Lt,"class","group"),a(Ct,"id","module_utils/data-structures..TokenLatticeNode"),a(Ct,"class","group"),a(wt,"id","new_module_utils/data-structures..TokenLatticeNode_new"),a(wt,"class","group"),a(Nt,"id","module_utils/data-structures..TokenLatticeNode+clone"),a(Nt,"class","group")},m(e,t){Qd(document.head,_),l(e,Kt,t),l(e,gt,t),l(e,jt,t),l(e,y,t),l(e,Dt,t),f(L,e,t),l(e,Ut,t),l(e,k,t),l(e,Bt,t),l(e,v,t),l(e,St,t),l(e,x,t),l(e,Ft,t),l(e,Gt,t),l(e,Ot,t),l(e,C,t),l(e,Vt,t),f(b,e,t),l(e,Wt,t),l(e,P,t),l(e,Jt,t),l(e,H,t),l(e,Xt,t),l(e,w,t),l(e,Yt,t),l(e,M,t),l(e,Zt,t),l(e,Q,t),l(e,ei,t),l(e,ti,t),l(e,ii,t),l(e,A,t),l(e,li,t),f(N,e,t),l(e,ri,t),l(e,q,t),l(e,ui,t),l(e,E,t),l(e,di,t),l(e,oi,t),l(e,si,t),l(e,R,t),l(e,ai,t),f(I,e,t),l(e,ni,t),l(e,g,t),l(e,ci,t),l(e,z,t),l(e,pi,t),l(e,fi,t),l(e,hi,t),l(e,K,t),l(e,mi,t),f(j,e,t),l(e,Ti,t),l(e,D,t),l(e,$i,t),l(e,U,t),l(e,_i,t),l(e,yi,t),l(e,Li,t),l(e,B,t),l(e,ki,t),f(S,e,t),l(e,vi,t),l(e,F,t),l(e,xi,t),l(e,G,t),l(e,Ci,t),l(e,bi,t),l(e,Pi,t),l(e,O,t),l(e,Hi,t),f(V,e,t),l(e,wi,t),l(e,W,t),l(e,Mi,t),l(e,J,t),l(e,Qi,t),l(e,X,t),l(e,Ai,t),l(e,Ni,t),l(e,qi,t),l(e,Y,t),l(e,Ei,t),f(Z,e,t),l(e,Ri,t),l(e,ee,t),l(e,Ii,t),l(e,te,t),l(e,gi,t),l(e,ie,t),l(e,zi,t),l(e,Ki,t),l(e,ji,t),l(e,le,t),l(e,Di,t),f(re,e,t),l(e,Ui,t),l(e,ue,t),l(e,Bi,t),l(e,de,t),l(e,Si,t),l(e,Fi,t),l(e,Gi,t),l(e,oe,t),l(e,Oi,t),f(se,e,t),l(e,Vi,t),l(e,ae,t),l(e,Wi,t),l(e,ne,t),l(e,Ji,t),l(e,ce,t),l(e,Xi,t),l(e,Yi,t),l(e,Zi,t),l(e,pe,t),l(e,el,t),f(fe,e,t),l(e,tl,t),l(e,he,t),l(e,il,t),l(e,me,t),l(e,ll,t),l(e,Te,t),l(e,rl,t),l(e,ul,t),l(e,dl,t),l(e,$e,t),l(e,ol,t),f(_e,e,t),l(e,sl,t),l(e,ye,t),l(e,al,t),l(e,Le,t),l(e,nl,t),l(e,ke,t),l(e,cl,t),l(e,pl,t),l(e,fl,t),l(e,ve,t),l(e,hl,t),f(xe,e,t),l(e,ml,t),l(e,Ce,t),l(e,Tl,t),l(e,be,t),l(e,$l,t),l(e,Pe,t),l(e,_l,t),l(e,yl,t),l(e,Ll,t),l(e,He,t),l(e,kl,t),f(we,e,t),l(e,vl,t),l(e,Me,t),l(e,xl,t),l(e,Qe,t),l(e,Cl,t),l(e,Ae,t),l(e,bl,t),l(e,Pl,t),l(e,Hl,t),l(e,Ne,t),l(e,wl,t),f(qe,e,t),l(e,Ml,t),l(e,Ee,t),l(e,Ql,t),l(e,Re,t),l(e,Al,t),l(e,Ie,t),l(e,Nl,t),l(e,ql,t),l(e,El,t),l(e,ge,t),l(e,Rl,t),f(ze,e,t),l(e,Il,t),l(e,Ke,t),l(e,gl,t),l(e,je,t),l(e,zl,t),l(e,De,t),l(e,Kl,t),l(e,jl,t),l(e,Dl,t),l(e,Ue,t),l(e,Ul,t),f(Be,e,t),l(e,Bl,t),l(e,Se,t),l(e,Sl,t),l(e,Fe,t),l(e,Fl,t),l(e,Gl,t),l(e,Ol,t),l(e,Ge,t),l(e,Vl,t),f(Oe,e,t),l(e,Wl,t),l(e,Ve,t),l(e,Jl,t),l(e,We,t),l(e,Xl,t),l(e,Je,t),l(e,Yl,t),l(e,Zl,t),l(e,er,t),l(e,Xe,t),l(e,tr,t),f(Ye,e,t),l(e,ir,t),l(e,Ze,t),l(e,lr,t),l(e,et,t),l(e,rr,t),l(e,ur,t),l(e,dr,t),l(e,tt,t),l(e,or,t),f(it,e,t),l(e,sr,t),l(e,lt,t),l(e,ar,t),l(e,rt,t),l(e,nr,t),l(e,cr,t),l(e,pr,t),l(e,ut,t),l(e,fr,t),f(dt,e,t),l(e,hr,t),l(e,ot,t),l(e,mr,t),l(e,Tr,t),l(e,$r,t),l(e,st,t),l(e,_r,t),f(at,e,t),l(e,yr,t),l(e,nt,t),l(e,Lr,t),l(e,kr,t),l(e,vr,t),l(e,ct,t),l(e,xr,t),f(pt,e,t),l(e,Cr,t),l(e,ft,t),l(e,br,t),l(e,ht,t),l(e,Pr,t),l(e,mt,t),l(e,Hr,t),l(e,wr,t),l(e,Mr,t),l(e,Tt,t),l(e,Qr,t),f($t,e,t),l(e,Ar,t),l(e,_t,t),l(e,Nr,t),l(e,yt,t),l(e,qr,t),l(e,Er,t),l(e,Rr,t),l(e,Lt,t),l(e,Ir,t),f(kt,e,t),l(e,gr,t),l(e,vt,t),l(e,zr,t),l(e,xt,t),l(e,Kr,t),l(e,jr,t),l(e,Dr,t),l(e,Ct,t),l(e,Ur,t),f(bt,e,t),l(e,Br,t),l(e,Pt,t),l(e,Sr,t),l(e,Ht,t),l(e,Fr,t),l(e,Gr,t),l(e,Or,t),l(e,wt,t),l(e,Vr,t),f(Mt,e,t),l(e,Wr,t),l(e,Qt,t),l(e,Jr,t),l(e,At,t),l(e,Xr,t),l(e,Yr,t),l(e,Zr,t),l(e,Nt,t),l(e,eu,t),f(qt,e,t),l(e,tu,t),l(e,Et,t),l(e,iu,t),l(e,Rt,t),l(e,lu,t),l(e,ru,t),l(e,uu,t),f(It,e,t),l(e,du,t),l(e,zt,t),ou=!0},p:bd,i(e){ou||(h(L.$$.fragment,e),h(b.$$.fragment,e),h(N.$$.fragment,e),h(I.$$.fragment,e),h(j.$$.fragment,e),h(S.$$.fragment,e),h(V.$$.fragment,e),h(Z.$$.fragment,e),h(re.$$.fragment,e),h(se.$$.fragment,e),h(fe.$$.fragment,e),h(_e.$$.fragment,e),h(xe.$$.fragment,e),h(we.$$.fragment,e),h(qe.$$.fragment,e),h(ze.$$.fragment,e),h(Be.$$.fragment,e),h(Oe.$$.fragment,e),h(Ye.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),h(at.$$.fragment,e),h(pt.$$.fragment,e),h($t.$$.fragment,e),h(kt.$$.fragment,e),h(bt.$$.fragment,e),h(Mt.$$.fragment,e),h(qt.$$.fragment,e),h(It.$$.fragment,e),ou=!0)},o(e){m(L.$$.fragment,e),m(b.$$.fragment,e),m(N.$$.fragment,e),m(I.$$.fragment,e),m(j.$$.fragment,e),m(S.$$.fragment,e),m(V.$$.fragment,e),m(Z.$$.fragment,e),m(re.$$.fragment,e),m(se.$$.fragment,e),m(fe.$$.fragment,e),m(_e.$$.fragment,e),m(xe.$$.fragment,e),m(we.$$.fragment,e),m(qe.$$.fragment,e),m(ze.$$.fragment,e),m(Be.$$.fragment,e),m(Oe.$$.fragment,e),m(Ye.$$.fragment,e),m(it.$$.fragment,e),m(dt.$$.fragment,e),m(at.$$.fragment,e),m(pt.$$.fragment,e),m($t.$$.fragment,e),m(kt.$$.fragment,e),m(bt.$$.fragment,e),m(Mt.$$.fragment,e),m(qt.$$.fragment,e),m(It.$$.fragment,e),ou=!1},d(e){e&&(i(Kt),i(gt),i(jt),i(y),i(Dt),i(Ut),i(k),i(Bt),i(v),i(St),i(x),i(Ft),i(Gt),i(Ot),i(C),i(Vt),i(Wt),i(P),i(Jt),i(H),i(Xt),i(w),i(Yt),i(M),i(Zt),i(Q),i(ei),i(ti),i(ii),i(A),i(li),i(ri),i(q),i(ui),i(E),i(di),i(oi),i(si),i(R),i(ai),i(ni),i(g),i(ci),i(z),i(pi),i(fi),i(hi),i(K),i(mi),i(Ti),i(D),i($i),i(U),i(_i),i(yi),i(Li),i(B),i(ki),i(vi),i(F),i(xi),i(G),i(Ci),i(bi),i(Pi),i(O),i(Hi),i(wi),i(W),i(Mi),i(J),i(Qi),i(X),i(Ai),i(Ni),i(qi),i(Y),i(Ei),i(Ri),i(ee),i(Ii),i(te),i(gi),i(ie),i(zi),i(Ki),i(ji),i(le),i(Di),i(Ui),i(ue),i(Bi),i(de),i(Si),i(Fi),i(Gi),i(oe),i(Oi),i(Vi),i(ae),i(Wi),i(ne),i(Ji),i(ce),i(Xi),i(Yi),i(Zi),i(pe),i(el),i(tl),i(he),i(il),i(me),i(ll),i(Te),i(rl),i(ul),i(dl),i($e),i(ol),i(sl),i(ye),i(al),i(Le),i(nl),i(ke),i(cl),i(pl),i(fl),i(ve),i(hl),i(ml),i(Ce),i(Tl),i(be),i($l),i(Pe),i(_l),i(yl),i(Ll),i(He),i(kl),i(vl),i(Me),i(xl),i(Qe),i(Cl),i(Ae),i(bl),i(Pl),i(Hl),i(Ne),i(wl),i(Ml),i(Ee),i(Ql),i(Re),i(Al),i(Ie),i(Nl),i(ql),i(El),i(ge),i(Rl),i(Il),i(Ke),i(gl),i(je),i(zl),i(De),i(Kl),i(jl),i(Dl),i(Ue),i(Ul),i(Bl),i(Se),i(Sl),i(Fe),i(Fl),i(Gl),i(Ol),i(Ge),i(Vl),i(Wl),i(Ve),i(Jl),i(We),i(Xl),i(Je),i(Yl),i(Zl),i(er),i(Xe),i(tr),i(ir),i(Ze),i(lr),i(et),i(rr),i(ur),i(dr),i(tt),i(or),i(sr),i(lt),i(ar),i(rt),i(nr),i(cr),i(pr),i(ut),i(fr),i(hr),i(ot),i(mr),i(Tr),i($r),i(st),i(_r),i(yr),i(nt),i(Lr),i(kr),i(vr),i(ct),i(xr),i(Cr),i(ft),i(br),i(ht),i(Pr),i(mt),i(Hr),i(wr),i(Mr),i(Tt),i(Qr),i(Ar),i(_t),i(Nr),i(yt),i(qr),i(Er),i(Rr),i(Lt),i(Ir),i(gr),i(vt),i(zr),i(xt),i(Kr),i(jr),i(Dr),i(Ct),i(Ur),i(Br),i(Pt),i(Sr),i(Ht),i(Fr),i(Gr),i(Or),i(wt),i(Vr),i(Wr),i(Qt),i(Jr),i(At),i(Xr),i(Yr),i(Zr),i(Nt),i(eu),i(tu),i(Et),i(iu),i(Rt),i(lu),i(ru),i(uu),i(du),i(zt)),i(_),T(L,e),T(b,e),T(N,e),T(I,e),T(j,e),T(S,e),T(V,e),T(Z,e),T(re,e),T(se,e),T(fe,e),T(_e,e),T(xe,e),T(we,e),T(qe,e),T(ze,e),T(Be,e),T(Oe,e),T(Ye,e),T(it,e),T(dt,e),T(at,e),T(pt,e),T($t,e),T(kt,e),T(bt,e),T(Mt,e),T(qt,e),T(It,e)}}}const qd='{"title":"utils/data-structures","local":"utilsdata-structures","sections":[{"title":"utils/data-structures.PriorityQueue","local":"utilsdata-structurespriorityqueue","sections":[{"title":"new PriorityQueue(comparator)","local":"new-priorityqueuecomparator","sections":[],"depth":3},{"title":"priorityQueue.size","local":"priorityqueuesize","sections":[],"depth":3},{"title":"priorityQueue.isEmpty() ⇒ <code> boolean </code>","local":"priorityqueueisempty--code-boolean-code","sections":[],"depth":3},{"title":"priorityQueue.peek() ⇒ <code> any </code>","local":"priorityqueuepeek--code-any-code","sections":[],"depth":3},{"title":"priorityQueue.push(...values) ⇒ <code> number </code>","local":"priorityqueuepushvalues--code-number-code","sections":[],"depth":3},{"title":"priorityQueue.extend(values) ⇒ <code> number </code>","local":"priorityqueueextendvalues--code-number-code","sections":[],"depth":3},{"title":"priorityQueue.pop() ⇒ <code> any </code>","local":"priorityqueuepop--code-any-code","sections":[],"depth":3},{"title":"priorityQueue.replace(value) ⇒ <code> * </code>","local":"priorityqueuereplacevalue--code--code","sections":[],"depth":3},{"title":"priorityQueue._siftUpFrom(node)","local":"priorityqueuesiftupfromnode","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.CharTrie","local":"utilsdata-structureschartrie","sections":[{"title":"charTrie.extend(texts)","local":"chartrieextendtexts","sections":[],"depth":3},{"title":"charTrie.push(text)","local":"chartriepushtext","sections":[],"depth":3},{"title":"charTrie.commonPrefixSearch(text)","local":"chartriecommonprefixsearchtext","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.TokenLattice","local":"utilsdata-structurestokenlattice","sections":[{"title":"new TokenLattice(sentence, bosTokenId, eosTokenId)","local":"new-tokenlatticesentence-bostokenid-eostokenid","sections":[],"depth":3},{"title":"tokenLattice.insert(pos, length, score, tokenId)","local":"tokenlatticeinsertpos-length-score-tokenid","sections":[],"depth":3},{"title":"tokenLattice.viterbi() ⇒ <code> Array. < TokenLatticeNode > </code>","local":"tokenlatticeviterbi--code-array--tokenlatticenode--code","sections":[],"depth":3},{"title":"tokenLattice.piece(node) ⇒ <code> string </code>","local":"tokenlatticepiecenode--code-string-code","sections":[],"depth":3},{"title":"tokenLattice.tokens() ⇒ <code> Array </code>","local":"tokenlatticetokens--code-array-code","sections":[],"depth":3},{"title":"tokenLattice.tokenIds() ⇒ <code> Array </code>","local":"tokenlatticetokenids--code-array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures~CharTrieNode","local":"utilsdata-structureschartrienode","sections":[{"title":"new CharTrieNode(isLeaf, children)","local":"new-chartrienodeisleaf-children","sections":[],"depth":3},{"title":"CharTrieNode.default() ⇒ <code> CharTrieNode </code>","local":"chartrienodedefault--code-chartrienode-code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures~TokenLatticeNode","local":"utilsdata-structurestokenlatticenode","sections":[{"title":"new TokenLatticeNode(tokenId, nodeId, pos, length, score)","local":"new-tokenlatticenodetokenid-nodeid-pos-length-score","sections":[],"depth":3},{"title":"tokenLatticeNode.clone() ⇒ <code> TokenLatticeNode </code>","local":"tokenlatticenodeclone--code-tokenlatticenode-code","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ed(su){return Pd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zd extends Hd{constructor(_){super(),wd(this,_,Ed,Nd,Cd,{})}}export{zd as component};
