import{s as nt,n as it,o as at}from"../chunks/scheduler.37c15a92.js";import{S as st,i as ot,g as c,s as i,r as s,A as rt,h as u,f as l,c as a,j as et,u as o,x as d,k as tt,y as pt,a as n,v as r,d as p,t as m,w as f}from"../chunks/index.2bf4358c.js";import{C as lt}from"../chunks/CodeBlock.4f5fc1ad.js";import{H as g}from"../chunks/Heading.8ada512a.js";import{E as mt}from"../chunks/EditOnGithub.9958bcdc.js";function ft(Ve){let $,ee,Y,te,h,le,M,Ue="When it comes to deploying and using Large Language Models (LLMs), you have two main options: using API services or running inference locally. Each approach has its own advantages and trade-offs that we’ll explore in this chapter.",ne,v,ie,w,Ne="API-based inference involves making HTTP requests to a service that hosts the model. Popular examples include OpenAI’s GPT API, Anthropic’s Claude API, and Hugging Face’s Inference Endpoints.",ae,T,se,I,qe="<li><p><strong>No Infrastructure Management</strong></p> <ul><li>No need to manage hardware or model deployments</li> <li>Automatic scaling and load balancing</li> <li>Regular model updates and improvements</li></ul></li> <li><p><strong>Cost-effective for Low Volume</strong></p> <ul><li>Pay-per-use pricing</li> <li>No upfront hardware costs</li> <li>No maintenance overhead</li></ul></li> <li><p><strong>Reliability and Availability</strong></p> <ul><li>High uptime guarantees</li> <li>Professional monitoring and support</li> <li>Redundancy and failover handling</li></ul></li>",oe,y,re,b,Re="<li><p><strong>Cost at Scale</strong></p> <ul><li>Can become expensive with high volume</li> <li>Pricing typically per token or request</li> <li>Additional costs for data transfer</li></ul></li> <li><p><strong>Limited Control</strong></p> <ul><li>Fixed model configurations</li> <li>Limited customization options</li> <li>Dependent on provider’s availability</li></ul></li> <li><p><strong>Data Privacy Concerns</strong></p> <ul><li>Data leaves your infrastructure</li> <li>Compliance challenges</li> <li>Vendor lock-in</li></ul></li>",pe,A,me,j,Xe="Local inference involves running the model on your own infrastructure, whether it’s on-premises hardware or cloud instances you control.",fe,J,ce,L,Fe="<li><p><strong>Complete Control</strong></p> <ul><li>Full customization of model parameters</li> <li>Ability to fine-tune and modify models</li> <li>Control over hardware optimization</li></ul></li> <li><p><strong>Data Privacy</strong></p> <ul><li>Data stays within your infrastructure</li> <li>Easier compliance with regulations</li> <li>No dependency on external services</li></ul></li> <li><p><strong>Cost-effective at Scale</strong></p> <ul><li>Fixed infrastructure costs</li> <li>No per-token charges</li> <li>Better economics for high volume</li></ul></li>",ue,C,ge,k,We="<li><p><strong>Infrastructure Management</strong></p> <ul><li>Need to manage hardware resources</li> <li>Responsibility for scaling and reliability</li> <li>Technical expertise required</li></ul></li> <li><p><strong>Upfront Costs</strong></p> <ul><li>Hardware investment needed</li> <li>Setup and maintenance time</li> <li>Operational overhead</li></ul></li> <li><p><strong>Limited Model Access</strong></p> <ul><li>Not all models are open source</li> <li>May need to use smaller models</li> <li>Manual updates and improvements</li></ul></li>",de,x,$e,P,Qe="Consider these factors when deciding between API and local inference:",he,E,Me,H,Se="<li><strong>Low volume</strong>: APIs are often more cost-effective</li> <li><strong>High volume</strong>: Local inference may be cheaper long-term</li>",ve,_,we,B,ze="<li><strong>Limited expertise</strong>: APIs are easier to implement</li> <li><strong>Strong ML team</strong>: Local inference offers more control</li>",Te,Z,Ie,V,De="<li><strong>Sensitive data</strong>: Local inference provides better control</li> <li><strong>Public data</strong>: APIs may be sufficient</li>",ye,U,be,N,Ge="<li><strong>Low latency</strong>: Local inference can be optimized</li> <li><strong>Flexible latency</strong>: APIs work well</li>",Ae,q,je,R,Oe="Many organizations adopt a hybrid approach:",Je,X,Ye="<li><p><strong>Development vs Production</strong></p> <ul><li>Use APIs for development and testing</li> <li>Deploy locally for production workloads</li></ul></li> <li><p><strong>Task-based Selection</strong></p> <ul><li>APIs for non-sensitive, low-volume tasks</li> <li>Local inference for sensitive or high-volume tasks</li></ul></li> <li><p><strong>Fallback Strategy</strong></p> <ul><li>Primary local deployment</li> <li>API fallback for peak loads or failures</li></ul></li>",Le,F,Ce,W,ke,Q,xe,S,Pe,z,Ee,D,He,G,Ke='<li><a href="https://platform.openai.com/docs/api-reference" rel="nofollow">OpenAI API Documentation</a></li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Hugging Face Inference Endpoints</a></li> <li><a href="https://huggingface.co/docs/transformers/installation" rel="nofollow">Local Inference Guide</a></li> <li><a href="https://huggingface.co/blog/inference-endpoints-llm" rel="nofollow">Model Deployment Best Practices</a></li>',_e,O,Be,K,Ze;return h=new g({props:{title:"APIs vs Local Inference",local:"apis-vs-local-inference",headingTag:"h1"}}),v=new g({props:{title:"API-based Inference",local:"api-based-inference",headingTag:"h2"}}),T=new g({props:{title:"Advantages of API-based Inference",local:"advantages-of-api-based-inference",headingTag:"h3"}}),y=new g({props:{title:"Disadvantages of API-based Inference",local:"disadvantages-of-api-based-inference",headingTag:"h3"}}),A=new g({props:{title:"Local Inference",local:"local-inference",headingTag:"h2"}}),J=new g({props:{title:"Advantages of Local Inference",local:"advantages-of-local-inference",headingTag:"h3"}}),C=new g({props:{title:"Disadvantages of Local Inference",local:"disadvantages-of-local-inference",headingTag:"h3"}}),x=new g({props:{title:"Making the Choice",local:"making-the-choice",headingTag:"h2"}}),E=new g({props:{title:"Volume and Scale",local:"volume-and-scale",headingTag:"h3"}}),_=new g({props:{title:"Technical Resources",local:"technical-resources",headingTag:"h3"}}),Z=new g({props:{title:"Data Privacy",local:"data-privacy",headingTag:"h3"}}),U=new g({props:{title:"Performance Requirements",local:"performance-requirements",headingTag:"h3"}}),q=new g({props:{title:"Hybrid Approaches",local:"hybrid-approaches",headingTag:"h2"}}),F=new g({props:{title:"Implementation Examples",local:"implementation-examples",headingTag:"h2"}}),W=new g({props:{title:"API Implementation",local:"api-implementation",headingTag:"h3"}}),Q=new lt({props:{code:"aW1wb3J0JTIwb3BlbmFpJTBBJTBBb3BlbmFpLmFwaV9rZXklMjAlM0QlMjAlMjJ5b3VyLWFwaS1rZXklMjIlMEElMEFkZWYlMjBnZW5lcmF0ZV90ZXh0KHByb21wdCklM0ElMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMG9wZW5haS5DaGF0Q29tcGxldGlvbi5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJncHQtMy41LXR1cmJvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBwcm9tcHQlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS5jb250ZW50",highlighted:`<span class="hljs-keyword">import</span> openai

openai.api_key = <span class="hljs-string">&quot;your-api-key&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_text</span>(<span class="hljs-params">prompt</span>):
    response = openai.ChatCompletion.create(
        model=<span class="hljs-string">&quot;gpt-3.5-turbo&quot;</span>,
        messages=[
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}
        ]
    )
    <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content`,wrap:!1}}),S=new g({props:{title:"Local Implementation",local:"local-implementation",headingTag:"h3"}}),z=new lt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0yLTEuN0ItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTItMS43Qi1JbnN0cnVjdCUyMiklMEElMEFkZWYlMjBnZW5lcmF0ZV90ZXh0KHByb21wdCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_text</span>(<span class="hljs-params">prompt</span>):
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model.generate(**inputs)
    <span class="hljs-keyword">return</span> tokenizer.decode(outputs[<span class="hljs-number">0</span>])`,wrap:!1}}),D=new g({props:{title:"Resources",local:"resources",headingTag:"h2"}}),O=new mt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter12/3.mdx"}}),{c(){$=c("meta"),ee=i(),Y=c("p"),te=i(),s(h.$$.fragment),le=i(),M=c("p"),M.textContent=Ue,ne=i(),s(v.$$.fragment),ie=i(),w=c("p"),w.textContent=Ne,ae=i(),s(T.$$.fragment),se=i(),I=c("ol"),I.innerHTML=qe,oe=i(),s(y.$$.fragment),re=i(),b=c("ol"),b.innerHTML=Re,pe=i(),s(A.$$.fragment),me=i(),j=c("p"),j.textContent=Xe,fe=i(),s(J.$$.fragment),ce=i(),L=c("ol"),L.innerHTML=Fe,ue=i(),s(C.$$.fragment),ge=i(),k=c("ol"),k.innerHTML=We,de=i(),s(x.$$.fragment),$e=i(),P=c("p"),P.textContent=Qe,he=i(),s(E.$$.fragment),Me=i(),H=c("ul"),H.innerHTML=Se,ve=i(),s(_.$$.fragment),we=i(),B=c("ul"),B.innerHTML=ze,Te=i(),s(Z.$$.fragment),Ie=i(),V=c("ul"),V.innerHTML=De,ye=i(),s(U.$$.fragment),be=i(),N=c("ul"),N.innerHTML=Ge,Ae=i(),s(q.$$.fragment),je=i(),R=c("p"),R.textContent=Oe,Je=i(),X=c("ol"),X.innerHTML=Ye,Le=i(),s(F.$$.fragment),Ce=i(),s(W.$$.fragment),ke=i(),s(Q.$$.fragment),xe=i(),s(S.$$.fragment),Pe=i(),s(z.$$.fragment),Ee=i(),s(D.$$.fragment),He=i(),G=c("ul"),G.innerHTML=Ke,_e=i(),s(O.$$.fragment),Be=i(),K=c("p"),this.h()},l(e){const t=rt("svelte-u9bgzb",document.head);$=u(t,"META",{name:!0,content:!0}),t.forEach(l),ee=a(e),Y=u(e,"P",{}),et(Y).forEach(l),te=a(e),o(h.$$.fragment,e),le=a(e),M=u(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-1bqjdpa"&&(M.textContent=Ue),ne=a(e),o(v.$$.fragment,e),ie=a(e),w=u(e,"P",{"data-svelte-h":!0}),d(w)!=="svelte-1c8muye"&&(w.textContent=Ne),ae=a(e),o(T.$$.fragment,e),se=a(e),I=u(e,"OL",{"data-svelte-h":!0}),d(I)!=="svelte-17x89as"&&(I.innerHTML=qe),oe=a(e),o(y.$$.fragment,e),re=a(e),b=u(e,"OL",{"data-svelte-h":!0}),d(b)!=="svelte-p7qtuq"&&(b.innerHTML=Re),pe=a(e),o(A.$$.fragment,e),me=a(e),j=u(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-7ayc3g"&&(j.textContent=Xe),fe=a(e),o(J.$$.fragment,e),ce=a(e),L=u(e,"OL",{"data-svelte-h":!0}),d(L)!=="svelte-xh8k6b"&&(L.innerHTML=Fe),ue=a(e),o(C.$$.fragment,e),ge=a(e),k=u(e,"OL",{"data-svelte-h":!0}),d(k)!=="svelte-g5758r"&&(k.innerHTML=We),de=a(e),o(x.$$.fragment,e),$e=a(e),P=u(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1ifqklg"&&(P.textContent=Qe),he=a(e),o(E.$$.fragment,e),Me=a(e),H=u(e,"UL",{"data-svelte-h":!0}),d(H)!=="svelte-1aevrtk"&&(H.innerHTML=Se),ve=a(e),o(_.$$.fragment,e),we=a(e),B=u(e,"UL",{"data-svelte-h":!0}),d(B)!=="svelte-17p37t5"&&(B.innerHTML=ze),Te=a(e),o(Z.$$.fragment,e),Ie=a(e),V=u(e,"UL",{"data-svelte-h":!0}),d(V)!=="svelte-pe0vkd"&&(V.innerHTML=De),ye=a(e),o(U.$$.fragment,e),be=a(e),N=u(e,"UL",{"data-svelte-h":!0}),d(N)!=="svelte-1j3gi0p"&&(N.innerHTML=Ge),Ae=a(e),o(q.$$.fragment,e),je=a(e),R=u(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-qm0w1e"&&(R.textContent=Oe),Je=a(e),X=u(e,"OL",{"data-svelte-h":!0}),d(X)!=="svelte-mf2v0m"&&(X.innerHTML=Ye),Le=a(e),o(F.$$.fragment,e),Ce=a(e),o(W.$$.fragment,e),ke=a(e),o(Q.$$.fragment,e),xe=a(e),o(S.$$.fragment,e),Pe=a(e),o(z.$$.fragment,e),Ee=a(e),o(D.$$.fragment,e),He=a(e),G=u(e,"UL",{"data-svelte-h":!0}),d(G)!=="svelte-rna28k"&&(G.innerHTML=Ke),_e=a(e),o(O.$$.fragment,e),Be=a(e),K=u(e,"P",{}),et(K).forEach(l),this.h()},h(){tt($,"name","hf:doc:metadata"),tt($,"content",ct)},m(e,t){pt(document.head,$),n(e,ee,t),n(e,Y,t),n(e,te,t),r(h,e,t),n(e,le,t),n(e,M,t),n(e,ne,t),r(v,e,t),n(e,ie,t),n(e,w,t),n(e,ae,t),r(T,e,t),n(e,se,t),n(e,I,t),n(e,oe,t),r(y,e,t),n(e,re,t),n(e,b,t),n(e,pe,t),r(A,e,t),n(e,me,t),n(e,j,t),n(e,fe,t),r(J,e,t),n(e,ce,t),n(e,L,t),n(e,ue,t),r(C,e,t),n(e,ge,t),n(e,k,t),n(e,de,t),r(x,e,t),n(e,$e,t),n(e,P,t),n(e,he,t),r(E,e,t),n(e,Me,t),n(e,H,t),n(e,ve,t),r(_,e,t),n(e,we,t),n(e,B,t),n(e,Te,t),r(Z,e,t),n(e,Ie,t),n(e,V,t),n(e,ye,t),r(U,e,t),n(e,be,t),n(e,N,t),n(e,Ae,t),r(q,e,t),n(e,je,t),n(e,R,t),n(e,Je,t),n(e,X,t),n(e,Le,t),r(F,e,t),n(e,Ce,t),r(W,e,t),n(e,ke,t),r(Q,e,t),n(e,xe,t),r(S,e,t),n(e,Pe,t),r(z,e,t),n(e,Ee,t),r(D,e,t),n(e,He,t),n(e,G,t),n(e,_e,t),r(O,e,t),n(e,Be,t),n(e,K,t),Ze=!0},p:it,i(e){Ze||(p(h.$$.fragment,e),p(v.$$.fragment,e),p(T.$$.fragment,e),p(y.$$.fragment,e),p(A.$$.fragment,e),p(J.$$.fragment,e),p(C.$$.fragment,e),p(x.$$.fragment,e),p(E.$$.fragment,e),p(_.$$.fragment,e),p(Z.$$.fragment,e),p(U.$$.fragment,e),p(q.$$.fragment,e),p(F.$$.fragment,e),p(W.$$.fragment,e),p(Q.$$.fragment,e),p(S.$$.fragment,e),p(z.$$.fragment,e),p(D.$$.fragment,e),p(O.$$.fragment,e),Ze=!0)},o(e){m(h.$$.fragment,e),m(v.$$.fragment,e),m(T.$$.fragment,e),m(y.$$.fragment,e),m(A.$$.fragment,e),m(J.$$.fragment,e),m(C.$$.fragment,e),m(x.$$.fragment,e),m(E.$$.fragment,e),m(_.$$.fragment,e),m(Z.$$.fragment,e),m(U.$$.fragment,e),m(q.$$.fragment,e),m(F.$$.fragment,e),m(W.$$.fragment,e),m(Q.$$.fragment,e),m(S.$$.fragment,e),m(z.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),Ze=!1},d(e){e&&(l(ee),l(Y),l(te),l(le),l(M),l(ne),l(ie),l(w),l(ae),l(se),l(I),l(oe),l(re),l(b),l(pe),l(me),l(j),l(fe),l(ce),l(L),l(ue),l(ge),l(k),l(de),l($e),l(P),l(he),l(Me),l(H),l(ve),l(we),l(B),l(Te),l(Ie),l(V),l(ye),l(be),l(N),l(Ae),l(je),l(R),l(Je),l(X),l(Le),l(Ce),l(ke),l(xe),l(Pe),l(Ee),l(He),l(G),l(_e),l(Be),l(K)),l($),f(h,e),f(v,e),f(T,e),f(y,e),f(A,e),f(J,e),f(C,e),f(x,e),f(E,e),f(_,e),f(Z,e),f(U,e),f(q,e),f(F,e),f(W,e),f(Q,e),f(S,e),f(z,e),f(D,e),f(O,e)}}}const ct='{"title":"APIs vs Local Inference","local":"apis-vs-local-inference","sections":[{"title":"API-based Inference","local":"api-based-inference","sections":[{"title":"Advantages of API-based Inference","local":"advantages-of-api-based-inference","sections":[],"depth":3},{"title":"Disadvantages of API-based Inference","local":"disadvantages-of-api-based-inference","sections":[],"depth":3}],"depth":2},{"title":"Local Inference","local":"local-inference","sections":[{"title":"Advantages of Local Inference","local":"advantages-of-local-inference","sections":[],"depth":3},{"title":"Disadvantages of Local Inference","local":"disadvantages-of-local-inference","sections":[],"depth":3}],"depth":2},{"title":"Making the Choice","local":"making-the-choice","sections":[{"title":"Volume and Scale","local":"volume-and-scale","sections":[],"depth":3},{"title":"Technical Resources","local":"technical-resources","sections":[],"depth":3},{"title":"Data Privacy","local":"data-privacy","sections":[],"depth":3},{"title":"Performance Requirements","local":"performance-requirements","sections":[],"depth":3}],"depth":2},{"title":"Hybrid Approaches","local":"hybrid-approaches","sections":[],"depth":2},{"title":"Implementation Examples","local":"implementation-examples","sections":[{"title":"API Implementation","local":"api-implementation","sections":[],"depth":3},{"title":"Local Implementation","local":"local-implementation","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function ut(Ve){return at(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends st{constructor($){super(),ot(this,$,ut,ft,nt,{})}}export{vt as component};
