import{s as Ll,n as ql,o as Dl}from"../chunks/scheduler.37c15a92.js";import{S as Pl,i as Kl,g as u,s as n,r as i,A as Ol,h as f,f as t,c as a,j as Fl,u as p,x as y,k as Sl,y as et,a as s,v as m,d as r,t as M,w as c}from"../chunks/index.2bf4358c.js";import{C as w}from"../chunks/CodeBlock.4f5fc1ad.js";import{H as o}from"../chunks/Heading.8ada512a.js";import{E as lt}from"../chunks/EditOnGithub.9958bcdc.js";function tt(Bl){let T,ge,he,$e,j,Ue,J,Cl="In this chapter, we’ll explore advanced techniques and best practices for optimizing LLM deployments in production environments. We’ll cover strategies for improving performance, reducing costs, and ensuring reliability at scale.",Ie,h,be,d,Be,g,Ce,$,Al="<li><strong>INT8/FP16 Quantization</strong>: Reduce model size and memory usage</li> <li><strong>Dynamic Quantization</strong>: Apply quantization during inference</li> <li><strong>Calibration</strong>: Optimize quantization for specific use cases</li>",Ae,U,_e,I,ke,b,_l="<li>Remove unnecessary weights</li> <li>Reduce model complexity</li> <li>Maintain performance on key tasks</li>",Ze,B,ze,C,Xe,A,kl="<li><strong>Gradient Checkpointing</strong>: Reduce memory usage during inference</li> <li><strong>Efficient Memory Allocation</strong>: Optimize CUDA memory usage</li> <li><strong>Memory Monitoring</strong>: Track and optimize memory consumption</li>",Ve,_,Ge,k,Re,Z,Zl="<li><strong>Model Parallelism</strong>: Split large models across GPUs</li> <li><strong>Pipeline Parallelism</strong>: Process different stages on different GPUs</li> <li><strong>Load Balancing</strong>: Distribute requests efficiently</li>",ve,z,We,X,Ye,V,zl="<li>Adapt batch sizes based on load</li> <li>Balance latency and throughput</li> <li>Handle variable-length inputs</li>",Ne,G,xe,R,He,v,Xl="<li>Implement priority queues</li> <li>Handle request timeouts</li> <li>Manage resource allocation</li>",Ee,W,Qe,Y,Fe,N,Se,x,Vl="<li>Round-robin distribution</li> <li>Least connections</li> <li>Resource-aware routing</li>",Le,H,qe,E,De,Q,Gl="<li>Monitor server health</li> <li>Handle failover</li> <li>Implement circuit breakers</li>",Pe,F,Ke,S,Oe,L,Rl="<li>Cache common responses</li> <li>Implement cache invalidation</li> <li>Use distributed caching</li>",el,q,ll,D,tl,P,vl="<li>Optimize attention cache</li> <li>Implement cache pruning</li> <li>Monitor cache hit rates</li>",sl,K,nl,O,al,ee,Wl="<li>Latency tracking</li> <li>Throughput monitoring</li> <li>Error rates</li>",il,le,pl,te,ml,se,Yl="<li>GPU utilization</li> <li>Memory usage</li> <li>Network bandwidth</li>",rl,ne,Ml,ae,cl,ie,ol,pe,Nl="<li>Scale based on demand</li> <li>Implement warm-up strategies</li> <li>Handle scale-down gracefully</li>",ul,me,fl,re,yl,Me,xl="<li>Track resource usage</li> <li>Implement budgeting</li> <li>Optimize instance types</li>",Tl,ce,wl,oe,jl,ue,Hl="<li>Implement token budgeting</li> <li>Optimize context lengths</li> <li>Handle rate limiting</li>",Jl,fe,hl,ye,dl,Te,El="<li><p><strong>Gradual Rollout</strong></p> <ul><li>Use canary deployments</li> <li>Implement A/B testing</li> <li>Monitor performance impact</li></ul></li> <li><p><strong>Error Handling</strong></p> <ul><li>Implement retry mechanisms</li> <li>Handle timeouts gracefully</li> <li>Provide fallback responses</li></ul></li> <li><p><strong>Security</strong></p> <ul><li>Implement rate limiting</li> <li>Monitor for abuse</li> <li>Secure API endpoints</li></ul></li>",gl,we,$l,je,Ql='<li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Hugging Face Model Deployment Guide</a></li> <li><a href="https://developer.nvidia.com/triton-inference-server" rel="nofollow">NVIDIA Triton Inference Server</a></li> <li><a href="https://fastapi.tiangolo.com/" rel="nofollow">FastAPI Documentation</a></li> <li><a href="https://redis.io/documentation" rel="nofollow">Redis Documentation</a></li> <li><a href="https://prometheus.io/docs/introduction/overview/" rel="nofollow">Prometheus Monitoring</a></li>',Ul,Je,Il,de,bl;return j=new o({props:{title:"Optimising Deployment Inference",local:"optimising-deployment-inference",headingTag:"h1"}}),h=new o({props:{title:"Performance Optimization Techniques",local:"performance-optimization-techniques",headingTag:"h2"}}),d=new o({props:{title:"1. Model Optimization",local:"1-model-optimization",headingTag:"h3"}}),g=new o({props:{title:"Quantization",local:"quantization",headingTag:"h4"}}),U=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBJTIzJTIwQ29uZmlndXJlJTIwcXVhbnRpemF0aW9uJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRCUyMmZsb2F0MTYlMjIlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTBBKSUwQSUwQSUyMyUyMExvYWQlMjBxdWFudGl6ZWQlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0yLTEuN0ItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

<span class="hljs-comment"># Configure quantization</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=<span class="hljs-string">&quot;float16&quot;</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>
)

<span class="hljs-comment"># Load quantized model</span>
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>,
    quantization_config=quantization_config,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),I=new o({props:{title:"Model Pruning",local:"model-pruning",headingTag:"h4"}}),B=new o({props:{title:"2. Hardware Optimization",local:"2-hardware-optimization",headingTag:"h3"}}),C=new o({props:{title:"GPU Memory Management",local:"gpu-memory-management",headingTag:"h4"}}),_=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEF0b3JjaC5jdWRhLmVtcHR5X2NhY2hlKCklMjAlMjAlMjMlMjBDbGVhciUyMEdQVSUyMGNhY2hlJTBBdG9yY2guY3VkYS5tZW1vcnlfc3VtbWFyeSgpJTIwJTIwJTIzJTIwTW9uaXRvciUyMG1lbW9yeSUyMHVzYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
torch.cuda.empty_cache()  <span class="hljs-comment"># Clear GPU cache</span>
torch.cuda.memory_summary()  <span class="hljs-comment"># Monitor memory usage</span>`,wrap:!1}}),k=new o({props:{title:"Multi-GPU Deployment",local:"multi-gpu-deployment",headingTag:"h4"}}),z=new o({props:{title:"3. Batching Strategies",local:"3-batching-strategies",headingTag:"h3"}}),X=new o({props:{title:"Dynamic Batching",local:"dynamic-batching",headingTag:"h4"}}),G=new w({props:{code:"Y2xhc3MlMjBEeW5hbWljQmF0Y2hlciUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBtYXhfYmF0Y2hfc2l6ZSUzRDMyJTJDJTIwbWF4X3dhaXRfdGltZSUzRDAuMSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnF1ZXVlJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tYXhfYmF0Y2hfc2l6ZSUyMCUzRCUyMG1heF9iYXRjaF9zaXplJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tYXhfd2FpdF90aW1lJTIwJTNEJTIwbWF4X3dhaXRfdGltZSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwYWRkX3JlcXVlc3Qoc2VsZiUyQyUyMHJlcXVlc3QpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5xdWV1ZS5hcHBlbmQocmVxdWVzdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGxlbihzZWxmLnF1ZXVlKSUyMCUzRSUzRCUyMHNlbGYubWF4X2JhdGNoX3NpemUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBhd2FpdCUyMHNlbGYucHJvY2Vzc19iYXRjaCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYXdhaXQlMjBzZWxmLndhaXRfZm9yX2JhdGNoKCk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">DynamicBatcher</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, max_batch_size=<span class="hljs-number">32</span>, max_wait_time=<span class="hljs-number">0.1</span></span>):
        self.queue = []
        self.max_batch_size = max_batch_size
        self.max_wait_time = max_wait_time
    
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add_request</span>(<span class="hljs-params">self, request</span>):
        self.queue.append(request)
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(self.queue) &gt;= self.max_batch_size:
            <span class="hljs-keyword">return</span> <span class="hljs-keyword">await</span> self.process_batch()
        <span class="hljs-keyword">return</span> <span class="hljs-keyword">await</span> self.wait_for_batch()`,wrap:!1}}),R=new o({props:{title:"Request Queuing",local:"request-queuing",headingTag:"h4"}}),W=new o({props:{title:"Deployment Architecture",local:"deployment-architecture",headingTag:"h2"}}),Y=new o({props:{title:"1. Load Balancing",local:"1-load-balancing",headingTag:"h3"}}),N=new o({props:{title:"Request Distribution",local:"request-distribution",headingTag:"h4"}}),H=new w({props:{code:"ZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBGYXN0QVBJJTBBZnJvbSUyMGxvYWRfYmFsYW5jZXIlMjBpbXBvcnQlMjBMb2FkQmFsYW5jZXIlMEElMEFhcHAlMjAlM0QlMjBGYXN0QVBJKCklMEFsYiUyMCUzRCUyMExvYWRCYWxhbmNlciglNUIlMjJzZXJ2ZXIxJTIyJTJDJTIwJTIyc2VydmVyMiUyMiUyQyUyMCUyMnNlcnZlcjMlMjIlNUQpJTBBJTBBJTQwYXBwLnBvc3QoJTIyJTJGZ2VuZXJhdGUlMjIpJTBBYXN5bmMlMjBkZWYlMjBnZW5lcmF0ZShyZXF1ZXN0JTNBJTIwUmVxdWVzdCklM0ElMEElMjAlMjAlMjAlMjBzZXJ2ZXIlMjAlM0QlMjBsYi5nZXRfbmV4dF9zZXJ2ZXIoKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGF3YWl0JTIwc2VydmVyLnByb2Nlc3MocmVxdWVzdCk=",highlighted:`<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI
<span class="hljs-keyword">from</span> load_balancer <span class="hljs-keyword">import</span> LoadBalancer

app = FastAPI()
lb = LoadBalancer([<span class="hljs-string">&quot;server1&quot;</span>, <span class="hljs-string">&quot;server2&quot;</span>, <span class="hljs-string">&quot;server3&quot;</span>])

<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/generate&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">request: Request</span>):
    server = lb.get_next_server()
    <span class="hljs-keyword">return</span> <span class="hljs-keyword">await</span> server.process(request)`,wrap:!1}}),E=new o({props:{title:"Health Checking",local:"health-checking",headingTag:"h4"}}),F=new o({props:{title:"2. Caching Strategies",local:"2-caching-strategies",headingTag:"h3"}}),S=new o({props:{title:"Response Caching",local:"response-caching",headingTag:"h4"}}),q=new w({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMGxydV9jYWNoZSUwQWltcG9ydCUyMHJlZGlzJTBBJTBBcmVkaXNfY2xpZW50JTIwJTNEJTIwcmVkaXMuUmVkaXMoaG9zdCUzRCdsb2NhbGhvc3QnJTJDJTIwcG9ydCUzRDYzNzkpJTBBJTBBJTQwbHJ1X2NhY2hlKG1heHNpemUlM0QxMDAwKSUwQWRlZiUyMGdldF9jYWNoZWRfcmVzcG9uc2UocHJvbXB0JTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBDaGVjayUyMGxvY2FsJTIwY2FjaGUlMjBmaXJzdCUwQSUyMCUyMCUyMCUyMGlmJTIwY2FjaGVkJTIwJTNBJTNEJTIwcmVkaXNfY2xpZW50LmdldChwcm9tcHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwR2VuZXJhdGUlMjBhbmQlMjBjYWNoZSUyMHJlc3BvbnNlJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBnZW5lcmF0ZV9yZXNwb25zZShwcm9tcHQpJTBBJTIwJTIwJTIwJTIwcmVkaXNfY2xpZW50LnNldGV4KHByb21wdCUyQyUyMDM2MDAlMkMlMjByZXNwb25zZSklMjAlMjAlMjMlMjBDYWNoZSUyMGZvciUyMDElMjBob3VyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2U=",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> lru_cache
<span class="hljs-keyword">import</span> redis

redis_client = redis.Redis(host=<span class="hljs-string">&#x27;localhost&#x27;</span>, port=<span class="hljs-number">6379</span>)

<span class="hljs-meta">@lru_cache(<span class="hljs-params">maxsize=<span class="hljs-number">1000</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_cached_response</span>(<span class="hljs-params">prompt: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-comment"># Check local cache first</span>
    <span class="hljs-keyword">if</span> cached := redis_client.get(prompt):
        <span class="hljs-keyword">return</span> cached
    
    <span class="hljs-comment"># Generate and cache response</span>
    response = generate_response(prompt)
    redis_client.setex(prompt, <span class="hljs-number">3600</span>, response)  <span class="hljs-comment"># Cache for 1 hour</span>
    <span class="hljs-keyword">return</span> response`,wrap:!1}}),D=new o({props:{title:"KV Cache Management",local:"kv-cache-management",headingTag:"h4"}}),K=new o({props:{title:"3. Monitoring and Observability",local:"3-monitoring-and-observability",headingTag:"h3"}}),O=new o({props:{title:"Performance Metrics",local:"performance-metrics",headingTag:"h4"}}),le=new w({props:{code:"ZnJvbSUyMHByb21ldGhldXNfY2xpZW50JTIwaW1wb3J0JTIwQ291bnRlciUyQyUyMEhpc3RvZ3JhbSUwQSUwQXJlcXVlc3RzX3RvdGFsJTIwJTNEJTIwQ291bnRlcigncmVxdWVzdHNfdG90YWwnJTJDJTIwJ1RvdGFsJTIwcmVxdWVzdHMlMjBwcm9jZXNzZWQnKSUwQWxhdGVuY3lfc2Vjb25kcyUyMCUzRCUyMEhpc3RvZ3JhbSgnbGF0ZW5jeV9zZWNvbmRzJyUyQyUyMCdSZXF1ZXN0JTIwbGF0ZW5jeScpJTBBJTBBJTQwYXBwLnBvc3QoJTIyJTJGZ2VuZXJhdGUlMjIpJTBBYXN5bmMlMjBkZWYlMjBnZW5lcmF0ZShyZXF1ZXN0JTNBJTIwUmVxdWVzdCklM0ElMEElMjAlMjAlMjAlMjByZXF1ZXN0c190b3RhbC5pbmMoKSUwQSUyMCUyMCUyMCUyMHdpdGglMjBsYXRlbmN5X3NlY29uZHMudGltZSgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYXdhaXQlMjBwcm9jZXNzX3JlcXVlc3QocmVxdWVzdCk=",highlighted:`<span class="hljs-keyword">from</span> prometheus_client <span class="hljs-keyword">import</span> Counter, Histogram

requests_total = Counter(<span class="hljs-string">&#x27;requests_total&#x27;</span>, <span class="hljs-string">&#x27;Total requests processed&#x27;</span>)
latency_seconds = Histogram(<span class="hljs-string">&#x27;latency_seconds&#x27;</span>, <span class="hljs-string">&#x27;Request latency&#x27;</span>)

<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/generate&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">request: Request</span>):
    requests_total.inc()
    <span class="hljs-keyword">with</span> latency_seconds.time():
        <span class="hljs-keyword">return</span> <span class="hljs-keyword">await</span> process_request(request)`,wrap:!1}}),te=new o({props:{title:"Resource Utilization",local:"resource-utilization",headingTag:"h4"}}),ne=new o({props:{title:"Cost Optimization",local:"cost-optimization",headingTag:"h2"}}),ae=new o({props:{title:"1. Resource Scaling",local:"1-resource-scaling",headingTag:"h3"}}),ie=new o({props:{title:"Auto-scaling",local:"auto-scaling",headingTag:"h4"}}),me=new w({props:{code:"Y2xhc3MlMjBBdXRvU2NhbGVyJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG1pbl9pbnN0YW5jZXMlM0QxJTJDJTIwbWF4X2luc3RhbmNlcyUzRDEwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW5zdGFuY2VzJTIwJTNEJTIwbWluX2luc3RhbmNlcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubWluX2luc3RhbmNlcyUyMCUzRCUyMG1pbl9pbnN0YW5jZXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm1heF9pbnN0YW5jZXMlMjAlM0QlMjBtYXhfaW5zdGFuY2VzJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwZGVmJTIwc2NhbGVfYmFzZWRfb25fbG9hZChzZWxmJTJDJTIwY3VycmVudF9sb2FkKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldF9pbnN0YW5jZXMlMjAlM0QlMjBtYXgoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5taW5faW5zdGFuY2VzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWluKHNlbGYubWF4X2luc3RhbmNlcyUyQyUyMGN1cnJlbnRfbG9hZCUyMCUyRiUyRiUyMDEwMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5hZGp1c3RfaW5zdGFuY2VzKHRhcmdldF9pbnN0YW5jZXMp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">AutoScaler</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, min_instances=<span class="hljs-number">1</span>, max_instances=<span class="hljs-number">10</span></span>):
        self.instances = min_instances
        self.min_instances = min_instances
        self.max_instances = max_instances
    
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">scale_based_on_load</span>(<span class="hljs-params">self, current_load</span>):
        target_instances = <span class="hljs-built_in">max</span>(
            self.min_instances,
            <span class="hljs-built_in">min</span>(self.max_instances, current_load // <span class="hljs-number">100</span>)
        )
        self.adjust_instances(target_instances)`,wrap:!1}}),re=new o({props:{title:"Cost Monitoring",local:"cost-monitoring",headingTag:"h4"}}),ce=new o({props:{title:"2. Request Optimization",local:"2-request-optimization",headingTag:"h3"}}),oe=new o({props:{title:"Token Management",local:"token-management",headingTag:"h4"}}),fe=new w({props:{code:"Y2xhc3MlMjBUb2tlbkJ1ZGdldCUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBtYXhfZGFpbHlfdG9rZW5zJTNEMTAwMDAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm1heF9kYWlseV90b2tlbnMlMjAlM0QlMjBtYXhfZGFpbHlfdG9rZW5zJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi51c2VkX3Rva2VucyUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnJlc2V0X3RpbWUlMjAlM0QlMjBkYXRldGltZS5ub3coKSUyMCUyQiUyMHRpbWVkZWx0YShkYXlzJTNEMSklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBkZWYlMjBjYW5fcHJvY2Vzc19yZXF1ZXN0KHNlbGYlMkMlMjB0b2tlbl9jb3VudCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGRhdGV0aW1lLm5vdygpJTIwJTNFJTNEJTIwc2VsZi5yZXNldF90aW1lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi51c2VkX3Rva2VucyUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnJlc2V0X3RpbWUlMjAlM0QlMjBkYXRldGltZS5ub3coKSUyMCUyQiUyMHRpbWVkZWx0YShkYXlzJTNEMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNlbGYudXNlZF90b2tlbnMlMjAlMkIlMjB0b2tlbl9jb3VudCUyMCUzQyUzRCUyMHNlbGYubWF4X2RhaWx5X3Rva2VucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYudXNlZF90b2tlbnMlMjAlMkIlM0QlMjB0b2tlbl9jb3VudCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFRydWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBGYWxzZQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">TokenBudget</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, max_daily_tokens=<span class="hljs-number">1000000</span></span>):
        self.max_daily_tokens = max_daily_tokens
        self.used_tokens = <span class="hljs-number">0</span>
        self.reset_time = datetime.now() + timedelta(days=<span class="hljs-number">1</span>)
    
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">can_process_request</span>(<span class="hljs-params">self, token_count</span>):
        <span class="hljs-keyword">if</span> datetime.now() &gt;= self.reset_time:
            self.used_tokens = <span class="hljs-number">0</span>
            self.reset_time = datetime.now() + timedelta(days=<span class="hljs-number">1</span>)
        
        <span class="hljs-keyword">if</span> self.used_tokens + token_count &lt;= self.max_daily_tokens:
            self.used_tokens += token_count
            <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>
        <span class="hljs-keyword">return</span> <span class="hljs-literal">False</span>`,wrap:!1}}),ye=new o({props:{title:"Best Practices",local:"best-practices",headingTag:"h2"}}),we=new o({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Je=new lt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter12/6.mdx"}}),{c(){T=u("meta"),ge=n(),he=u("p"),$e=n(),i(j.$$.fragment),Ue=n(),J=u("p"),J.textContent=Cl,Ie=n(),i(h.$$.fragment),be=n(),i(d.$$.fragment),Be=n(),i(g.$$.fragment),Ce=n(),$=u("ul"),$.innerHTML=Al,Ae=n(),i(U.$$.fragment),_e=n(),i(I.$$.fragment),ke=n(),b=u("ul"),b.innerHTML=_l,Ze=n(),i(B.$$.fragment),ze=n(),i(C.$$.fragment),Xe=n(),A=u("ul"),A.innerHTML=kl,Ve=n(),i(_.$$.fragment),Ge=n(),i(k.$$.fragment),Re=n(),Z=u("ul"),Z.innerHTML=Zl,ve=n(),i(z.$$.fragment),We=n(),i(X.$$.fragment),Ye=n(),V=u("ul"),V.innerHTML=zl,Ne=n(),i(G.$$.fragment),xe=n(),i(R.$$.fragment),He=n(),v=u("ul"),v.innerHTML=Xl,Ee=n(),i(W.$$.fragment),Qe=n(),i(Y.$$.fragment),Fe=n(),i(N.$$.fragment),Se=n(),x=u("ul"),x.innerHTML=Vl,Le=n(),i(H.$$.fragment),qe=n(),i(E.$$.fragment),De=n(),Q=u("ul"),Q.innerHTML=Gl,Pe=n(),i(F.$$.fragment),Ke=n(),i(S.$$.fragment),Oe=n(),L=u("ul"),L.innerHTML=Rl,el=n(),i(q.$$.fragment),ll=n(),i(D.$$.fragment),tl=n(),P=u("ul"),P.innerHTML=vl,sl=n(),i(K.$$.fragment),nl=n(),i(O.$$.fragment),al=n(),ee=u("ul"),ee.innerHTML=Wl,il=n(),i(le.$$.fragment),pl=n(),i(te.$$.fragment),ml=n(),se=u("ul"),se.innerHTML=Yl,rl=n(),i(ne.$$.fragment),Ml=n(),i(ae.$$.fragment),cl=n(),i(ie.$$.fragment),ol=n(),pe=u("ul"),pe.innerHTML=Nl,ul=n(),i(me.$$.fragment),fl=n(),i(re.$$.fragment),yl=n(),Me=u("ul"),Me.innerHTML=xl,Tl=n(),i(ce.$$.fragment),wl=n(),i(oe.$$.fragment),jl=n(),ue=u("ul"),ue.innerHTML=Hl,Jl=n(),i(fe.$$.fragment),hl=n(),i(ye.$$.fragment),dl=n(),Te=u("ol"),Te.innerHTML=El,gl=n(),i(we.$$.fragment),$l=n(),je=u("ul"),je.innerHTML=Ql,Ul=n(),i(Je.$$.fragment),Il=n(),de=u("p"),this.h()},l(e){const l=Ol("svelte-u9bgzb",document.head);T=f(l,"META",{name:!0,content:!0}),l.forEach(t),ge=a(e),he=f(e,"P",{}),Fl(he).forEach(t),$e=a(e),p(j.$$.fragment,e),Ue=a(e),J=f(e,"P",{"data-svelte-h":!0}),y(J)!=="svelte-10z5z6t"&&(J.textContent=Cl),Ie=a(e),p(h.$$.fragment,e),be=a(e),p(d.$$.fragment,e),Be=a(e),p(g.$$.fragment,e),Ce=a(e),$=f(e,"UL",{"data-svelte-h":!0}),y($)!=="svelte-183tfqf"&&($.innerHTML=Al),Ae=a(e),p(U.$$.fragment,e),_e=a(e),p(I.$$.fragment,e),ke=a(e),b=f(e,"UL",{"data-svelte-h":!0}),y(b)!=="svelte-1mbj0i"&&(b.innerHTML=_l),Ze=a(e),p(B.$$.fragment,e),ze=a(e),p(C.$$.fragment,e),Xe=a(e),A=f(e,"UL",{"data-svelte-h":!0}),y(A)!=="svelte-cvbsjs"&&(A.innerHTML=kl),Ve=a(e),p(_.$$.fragment,e),Ge=a(e),p(k.$$.fragment,e),Re=a(e),Z=f(e,"UL",{"data-svelte-h":!0}),y(Z)!=="svelte-99nurg"&&(Z.innerHTML=Zl),ve=a(e),p(z.$$.fragment,e),We=a(e),p(X.$$.fragment,e),Ye=a(e),V=f(e,"UL",{"data-svelte-h":!0}),y(V)!=="svelte-xq28os"&&(V.innerHTML=zl),Ne=a(e),p(G.$$.fragment,e),xe=a(e),p(R.$$.fragment,e),He=a(e),v=f(e,"UL",{"data-svelte-h":!0}),y(v)!=="svelte-tu1y0s"&&(v.innerHTML=Xl),Ee=a(e),p(W.$$.fragment,e),Qe=a(e),p(Y.$$.fragment,e),Fe=a(e),p(N.$$.fragment,e),Se=a(e),x=f(e,"UL",{"data-svelte-h":!0}),y(x)!=="svelte-dvs095"&&(x.innerHTML=Vl),Le=a(e),p(H.$$.fragment,e),qe=a(e),p(E.$$.fragment,e),De=a(e),Q=f(e,"UL",{"data-svelte-h":!0}),y(Q)!=="svelte-1y4x04h"&&(Q.innerHTML=Gl),Pe=a(e),p(F.$$.fragment,e),Ke=a(e),p(S.$$.fragment,e),Oe=a(e),L=f(e,"UL",{"data-svelte-h":!0}),y(L)!=="svelte-1xy9kbo"&&(L.innerHTML=Rl),el=a(e),p(q.$$.fragment,e),ll=a(e),p(D.$$.fragment,e),tl=a(e),P=f(e,"UL",{"data-svelte-h":!0}),y(P)!=="svelte-uhzq06"&&(P.innerHTML=vl),sl=a(e),p(K.$$.fragment,e),nl=a(e),p(O.$$.fragment,e),al=a(e),ee=f(e,"UL",{"data-svelte-h":!0}),y(ee)!=="svelte-wxrhdb"&&(ee.innerHTML=Wl),il=a(e),p(le.$$.fragment,e),pl=a(e),p(te.$$.fragment,e),ml=a(e),se=f(e,"UL",{"data-svelte-h":!0}),y(se)!=="svelte-dw11bs"&&(se.innerHTML=Yl),rl=a(e),p(ne.$$.fragment,e),Ml=a(e),p(ae.$$.fragment,e),cl=a(e),p(ie.$$.fragment,e),ol=a(e),pe=f(e,"UL",{"data-svelte-h":!0}),y(pe)!=="svelte-l74z18"&&(pe.innerHTML=Nl),ul=a(e),p(me.$$.fragment,e),fl=a(e),p(re.$$.fragment,e),yl=a(e),Me=f(e,"UL",{"data-svelte-h":!0}),y(Me)!=="svelte-7ar454"&&(Me.innerHTML=xl),Tl=a(e),p(ce.$$.fragment,e),wl=a(e),p(oe.$$.fragment,e),jl=a(e),ue=f(e,"UL",{"data-svelte-h":!0}),y(ue)!=="svelte-knq7sa"&&(ue.innerHTML=Hl),Jl=a(e),p(fe.$$.fragment,e),hl=a(e),p(ye.$$.fragment,e),dl=a(e),Te=f(e,"OL",{"data-svelte-h":!0}),y(Te)!=="svelte-hnak97"&&(Te.innerHTML=El),gl=a(e),p(we.$$.fragment,e),$l=a(e),je=f(e,"UL",{"data-svelte-h":!0}),y(je)!=="svelte-ln4kj"&&(je.innerHTML=Ql),Ul=a(e),p(Je.$$.fragment,e),Il=a(e),de=f(e,"P",{}),Fl(de).forEach(t),this.h()},h(){Sl(T,"name","hf:doc:metadata"),Sl(T,"content",st)},m(e,l){et(document.head,T),s(e,ge,l),s(e,he,l),s(e,$e,l),m(j,e,l),s(e,Ue,l),s(e,J,l),s(e,Ie,l),m(h,e,l),s(e,be,l),m(d,e,l),s(e,Be,l),m(g,e,l),s(e,Ce,l),s(e,$,l),s(e,Ae,l),m(U,e,l),s(e,_e,l),m(I,e,l),s(e,ke,l),s(e,b,l),s(e,Ze,l),m(B,e,l),s(e,ze,l),m(C,e,l),s(e,Xe,l),s(e,A,l),s(e,Ve,l),m(_,e,l),s(e,Ge,l),m(k,e,l),s(e,Re,l),s(e,Z,l),s(e,ve,l),m(z,e,l),s(e,We,l),m(X,e,l),s(e,Ye,l),s(e,V,l),s(e,Ne,l),m(G,e,l),s(e,xe,l),m(R,e,l),s(e,He,l),s(e,v,l),s(e,Ee,l),m(W,e,l),s(e,Qe,l),m(Y,e,l),s(e,Fe,l),m(N,e,l),s(e,Se,l),s(e,x,l),s(e,Le,l),m(H,e,l),s(e,qe,l),m(E,e,l),s(e,De,l),s(e,Q,l),s(e,Pe,l),m(F,e,l),s(e,Ke,l),m(S,e,l),s(e,Oe,l),s(e,L,l),s(e,el,l),m(q,e,l),s(e,ll,l),m(D,e,l),s(e,tl,l),s(e,P,l),s(e,sl,l),m(K,e,l),s(e,nl,l),m(O,e,l),s(e,al,l),s(e,ee,l),s(e,il,l),m(le,e,l),s(e,pl,l),m(te,e,l),s(e,ml,l),s(e,se,l),s(e,rl,l),m(ne,e,l),s(e,Ml,l),m(ae,e,l),s(e,cl,l),m(ie,e,l),s(e,ol,l),s(e,pe,l),s(e,ul,l),m(me,e,l),s(e,fl,l),m(re,e,l),s(e,yl,l),s(e,Me,l),s(e,Tl,l),m(ce,e,l),s(e,wl,l),m(oe,e,l),s(e,jl,l),s(e,ue,l),s(e,Jl,l),m(fe,e,l),s(e,hl,l),m(ye,e,l),s(e,dl,l),s(e,Te,l),s(e,gl,l),m(we,e,l),s(e,$l,l),s(e,je,l),s(e,Ul,l),m(Je,e,l),s(e,Il,l),s(e,de,l),bl=!0},p:ql,i(e){bl||(r(j.$$.fragment,e),r(h.$$.fragment,e),r(d.$$.fragment,e),r(g.$$.fragment,e),r(U.$$.fragment,e),r(I.$$.fragment,e),r(B.$$.fragment,e),r(C.$$.fragment,e),r(_.$$.fragment,e),r(k.$$.fragment,e),r(z.$$.fragment,e),r(X.$$.fragment,e),r(G.$$.fragment,e),r(R.$$.fragment,e),r(W.$$.fragment,e),r(Y.$$.fragment,e),r(N.$$.fragment,e),r(H.$$.fragment,e),r(E.$$.fragment,e),r(F.$$.fragment,e),r(S.$$.fragment,e),r(q.$$.fragment,e),r(D.$$.fragment,e),r(K.$$.fragment,e),r(O.$$.fragment,e),r(le.$$.fragment,e),r(te.$$.fragment,e),r(ne.$$.fragment,e),r(ae.$$.fragment,e),r(ie.$$.fragment,e),r(me.$$.fragment,e),r(re.$$.fragment,e),r(ce.$$.fragment,e),r(oe.$$.fragment,e),r(fe.$$.fragment,e),r(ye.$$.fragment,e),r(we.$$.fragment,e),r(Je.$$.fragment,e),bl=!0)},o(e){M(j.$$.fragment,e),M(h.$$.fragment,e),M(d.$$.fragment,e),M(g.$$.fragment,e),M(U.$$.fragment,e),M(I.$$.fragment,e),M(B.$$.fragment,e),M(C.$$.fragment,e),M(_.$$.fragment,e),M(k.$$.fragment,e),M(z.$$.fragment,e),M(X.$$.fragment,e),M(G.$$.fragment,e),M(R.$$.fragment,e),M(W.$$.fragment,e),M(Y.$$.fragment,e),M(N.$$.fragment,e),M(H.$$.fragment,e),M(E.$$.fragment,e),M(F.$$.fragment,e),M(S.$$.fragment,e),M(q.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(O.$$.fragment,e),M(le.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(me.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(oe.$$.fragment,e),M(fe.$$.fragment,e),M(ye.$$.fragment,e),M(we.$$.fragment,e),M(Je.$$.fragment,e),bl=!1},d(e){e&&(t(ge),t(he),t($e),t(Ue),t(J),t(Ie),t(be),t(Be),t(Ce),t($),t(Ae),t(_e),t(ke),t(b),t(Ze),t(ze),t(Xe),t(A),t(Ve),t(Ge),t(Re),t(Z),t(ve),t(We),t(Ye),t(V),t(Ne),t(xe),t(He),t(v),t(Ee),t(Qe),t(Fe),t(Se),t(x),t(Le),t(qe),t(De),t(Q),t(Pe),t(Ke),t(Oe),t(L),t(el),t(ll),t(tl),t(P),t(sl),t(nl),t(al),t(ee),t(il),t(pl),t(ml),t(se),t(rl),t(Ml),t(cl),t(ol),t(pe),t(ul),t(fl),t(yl),t(Me),t(Tl),t(wl),t(jl),t(ue),t(Jl),t(hl),t(dl),t(Te),t(gl),t($l),t(je),t(Ul),t(Il),t(de)),t(T),c(j,e),c(h,e),c(d,e),c(g,e),c(U,e),c(I,e),c(B,e),c(C,e),c(_,e),c(k,e),c(z,e),c(X,e),c(G,e),c(R,e),c(W,e),c(Y,e),c(N,e),c(H,e),c(E,e),c(F,e),c(S,e),c(q,e),c(D,e),c(K,e),c(O,e),c(le,e),c(te,e),c(ne,e),c(ae,e),c(ie,e),c(me,e),c(re,e),c(ce,e),c(oe,e),c(fe,e),c(ye,e),c(we,e),c(Je,e)}}}const st='{"title":"Optimising Deployment Inference","local":"optimising-deployment-inference","sections":[{"title":"Performance Optimization Techniques","local":"performance-optimization-techniques","sections":[{"title":"1. Model Optimization","local":"1-model-optimization","sections":[{"title":"Quantization","local":"quantization","sections":[],"depth":4},{"title":"Model Pruning","local":"model-pruning","sections":[],"depth":4}],"depth":3},{"title":"2. Hardware Optimization","local":"2-hardware-optimization","sections":[{"title":"GPU Memory Management","local":"gpu-memory-management","sections":[],"depth":4},{"title":"Multi-GPU Deployment","local":"multi-gpu-deployment","sections":[],"depth":4}],"depth":3},{"title":"3. Batching Strategies","local":"3-batching-strategies","sections":[{"title":"Dynamic Batching","local":"dynamic-batching","sections":[],"depth":4},{"title":"Request Queuing","local":"request-queuing","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Deployment Architecture","local":"deployment-architecture","sections":[{"title":"1. Load Balancing","local":"1-load-balancing","sections":[{"title":"Request Distribution","local":"request-distribution","sections":[],"depth":4},{"title":"Health Checking","local":"health-checking","sections":[],"depth":4}],"depth":3},{"title":"2. Caching Strategies","local":"2-caching-strategies","sections":[{"title":"Response Caching","local":"response-caching","sections":[],"depth":4},{"title":"KV Cache Management","local":"kv-cache-management","sections":[],"depth":4}],"depth":3},{"title":"3. Monitoring and Observability","local":"3-monitoring-and-observability","sections":[{"title":"Performance Metrics","local":"performance-metrics","sections":[],"depth":4},{"title":"Resource Utilization","local":"resource-utilization","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Cost Optimization","local":"cost-optimization","sections":[{"title":"1. Resource Scaling","local":"1-resource-scaling","sections":[{"title":"Auto-scaling","local":"auto-scaling","sections":[],"depth":4},{"title":"Cost Monitoring","local":"cost-monitoring","sections":[],"depth":4}],"depth":3},{"title":"2. Request Optimization","local":"2-request-optimization","sections":[{"title":"Token Management","local":"token-management","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Best Practices","local":"best-practices","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function nt(Bl){return Dl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mt extends Pl{constructor(T){super(),Kl(this,T,nt,tt,Ll,{})}}export{Mt as component};
