import{s as Gl,n as Rl,o as Bl}from"../chunks/scheduler.a2b4ca8e.js";import{S as Nl,i as ql,g as o,s,r as p,A as zl,h as i,f as a,c as l,j as Ee,u as c,x as r,k as Se,l as xl,y as U,a as n,v as d,d as m,t as u,w as h}from"../chunks/index.f6e1d51d.js";import{D as us}from"../chunks/Docstring.e7c4afb2.js";import{C as M}from"../chunks/CodeBlock.9607aa3b.js";import{H as f,E as Xl}from"../chunks/EditOnGithub.d27dc01b.js";function El(Ts){let y,We,Qe,Ae,J,He,v,gs="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",Le,C,_s=`Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts/sft.py</code></a>.
Experimental support for Vision Language Models is also included in the example <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/vsft_llava.py" rel="nofollow"><code>examples/scripts/vsft_llava.py</code></a>.`,Ye,k,De,F,bs=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,Oe,I,Pe,$,Us="Make sure to pass the correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",Ke,Z,ws="You can also construct a model outside of the trainer and pass it as follows:",ta,x,ea,G,js='The above snippets will use the default training arguments from the <a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTConfig">SFTConfig</a> class. If you want to modify the defaults pass in your modification to the <code>SFTConfig</code> constructor and pass them to the trainer via the <code>args</code> argument.',aa,R,na,B,sa,N,Js=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,la,q,oa,z,vs="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",ia,X,ra,E,Cs="Make sure to have a <code>pad_token_id</code> which is different from <code>eos_token_id</code> which can result in the model not properly predicting EOS (End of Sentence) tokens during generation.",pa,S,ca,Q,ks="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending on whether they have context or not. For example:",da,V,ma,W,Fs="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",ua,A,Is="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",ha,H,$s="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",Ma,L,fa,Y,Zs="To solve this, you can tokenize the <code>response_template</code> with the same context as in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",ya,D,Ta,O,ga,P,xs=`Adding special tokens to a language model is crucial for training chat models. These tokens are added between the different roles in a conversation, such as the user, assistant, and system and help the model recognize the structure and flow of a conversation. This setup is essential for enabling the model to generate coherent and contextually appropriate responses in a chat environment.
The <code>setup_chat_format()</code> function in <code>trl</code> easily sets up a model and tokenizer for conversational AI tasks. This function:`,_a,K,Gs='<li>Adds special tokens to the tokenizer, e.g. <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code>, to indicate the start and end of a conversation.</li> <li>Resizes the model’s embedding layer to accommodate the new tokens.</li> <li>Sets the <code>chat_template</code> of the tokenizer, which is used to format the input data into a chat-like format. The default is <code>chatml</code> from OpenAI.</li> <li><em>optionally</em> you can pass <code>resize_to_multiple_of</code> to resize the embedding layer to a multiple of the <code>resize_to_multiple_of</code> argument, e.g. 64. If you want to see more formats being supported in the future, please open a GitHub issue on <a href="https://github.com/huggingface/trl" rel="nofollow">trl</a></li>',ba,tt,Ua,et,Rs="With our model and tokenizer set up, we can now fine-tune our model on a conversational dataset. Below is an example of how a dataset can be formatted for fine-tuning.",wa,at,ja,nt,Bs='The <a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports popular dataset formats. This allows you to pass the dataset to the trainer without any pre-processing directly. The following formats are supported:',Ja,st,Ns="<li>conversational format</li>",va,lt,Ca,ot,qs="<li>instruction format</li>",ka,it,Fa,rt,zs='If your dataset uses one of the above formats, you can directly pass it to the trainer without pre-processing. The <a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> will then format the dataset for you using the defined format from the model’s tokenizer with the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#templates-for-chat-models" rel="nofollow">apply_chat_template</a> method.',Ia,pt,$a,ct,Xs="If the dataset is not in one of those format you can either preprocess the dataset to match the formatting or pass a formatting function to the SFTTrainer to do it for you. Let’s have a look.",Za,dt,xa,mt,Es=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,Ga,ut,Ra,ht,Ss="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",Ba,Mt,Na,ft,Qs='To properly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example of how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',qa,yt,za,Tt,Vs='<a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTConfig">SFTConfig</a> constructor.',Xa,gt,Ea,_t,Ws=`Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.
If you don’t want to pack your <code>eval_dataset</code>, you can pass <code>eval_packing=False</code> to the <code>SFTConfig</code> init method.`,Sa,bt,Qa,Ut,As="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",Va,wt,Wa,jt,Hs='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTConfig">SFTConfig</a> constructor. Please refer to that class’ signature for more information.',Aa,Jt,Ha,vt,Ls='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTConfig">SFTConfig</a>. For example, if you want to load a model in a different precision, analogous to',La,Ct,Ya,kt,Ys="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",Da,Ft,Oa,It,Ds="We also support tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",Pa,$t,Ka,Zt,Os="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",tn,xt,en,Gt,Ps="For that, you need to first load your 8 bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",an,Rt,nn,Bt,sn,Nt,Ks=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,ln,qt,on,zt,tl=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,rn,Xt,pn,Et,el="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",cn,St,dn,Qt,al="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",mn,Vt,un,Wt,nl="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",hn,At,sl="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",Mn,Ht,ll="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",fn,Lt,yn,Yt,ol="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",Tn,Dt,gn,Ot,il="And add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when calling <code>from_pretrained</code>:",_n,Pt,bn,Kt,rl=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,Un,te,pl="In contrast to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",wn,ee,jn,ae,cl="We included a utility function to create your model.",Jn,T,ne,hs,Ne,dl="Arguments which define the model and tokenizer to load.",vn,se,Cn,le,kn,oe,ml='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',Fn,ie,ul="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",In,w,hl='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',$n,re,Ml="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTConfig</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",Zn,pe,xn,ce,fl='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',Gn,j,yl='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',Rn,de,Tl='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',Bn,me,Nn,ue,gl='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks on 1x A100 listed below:',qn,he,_l="<thead><tr><th>1 A100 40GB</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>Code Llama 34b</td> <td>Slim Orca</td> <td>1x</td> <td>1.01x</td> <td><strong>1.94x</strong></td> <td>-22.7%</td></tr> <tr><td>Llama-2 7b</td> <td>Slim Orca</td> <td>1x</td> <td>0.96x</td> <td><strong>1.87x</strong></td> <td>-39.3%</td></tr> <tr><td>Mistral 7b</td> <td>Slim Orca</td> <td>1x</td> <td>1.17x</td> <td><strong>1.88x</strong></td> <td>-65.9%</td></tr> <tr><td>Tiny Llama 1.1b</td> <td>Alpaca</td> <td>1x</td> <td>1.55x</td> <td><strong>2.74x</strong></td> <td>-57.8%</td></tr></tbody>",zn,Me,bl='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',Xn,fe,En,ye,Ul='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',Sn,Te,Qn,ge,wl="Pay attention to the following best practices when training a model with that trainer:",Vn,_e,jl='<li><a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide a default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',Wn,be,An,Ue,Jl='Trainer (and thus SFTTrainer) supports multi-GPU training. If you run your script with <code>python script.py</code> it will default to using DP as the strategy, which may be <a href="https://github.com/huggingface/trl/issues/1303" rel="nofollow">slower than expected</a>. To use DDP (which is generally recommended, see <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_many?select-gpu=Accelerate#data-parallelism" rel="nofollow">here</a> for more info) you must launch the script with <code>python -m torch.distributed.launch script.py</code> or <code>accelerate launch script.py</code>. For DDP to work you must also check the following:',Hn,we,vl='<li>If you’re using gradient_checkpointing, add the following to the TrainingArguments: <code>gradient_checkpointing_kwargs={&#39;use_reentrant&#39;:False}</code> (more info <a href="https://github.com/huggingface/transformers/issues/26969" rel="nofollow">here</a></li> <li>Ensure that the model is placed on the correct device:</li>',Ln,je,Yn,Je,Dn,ve,Cl="You may experience some issues with GPTQ Quantization after completing training. Lowering <code>gradient_accumulation_steps</code> to <code>4</code> will resolve most issues during the quantization process to GPTQ format.",On,Ce,Pn,g,ke,Ms,qe,kl=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,Kn,Fe,ts,_,Ie,fs,ze,Fl="Initialize SFTConfig.",es,$e,as,Ze,Il="In the SFTTrainer we smartly support <code>datasets.IterableDataset</code> in addition to other style datasets. This is useful if you are using large corpora that you do not want to save all to disk. The data will be tokenized and processed on the fly, even when packing is enabled.",ns,xe,$l="Additionally, in the SFTTrainer, we support pre-tokenized datasets if they are <code>datasets.Dataset</code> or <code>datasets.IterableDataset</code>. In other words, if such a dataset has a column of <code>input_ids</code>, no further processing (tokenization or packing) will be done, and the dataset will be used as-is. This can be useful if you have pretokenized your dataset outside of this script and want to re-use it directly.",ss,Ge,ls,b,Re,ys,Xe,Zl=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,os,Be,is,Ve,rs;return J=new f({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),k=new f({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),I=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXNmdF9jb25maWclMjAlM0QlMjBTRlRDb25maWcoJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMiUyRnRtcCUyMiUyQyUwQSklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEc2Z0X2NvbmZpZyUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

sft_config = SFTConfig(
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
    output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config,
)
trainer.train()`,wrap:!1}}),x=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBJTBBc2Z0X2NvbmZpZyUyMCUzRCUyMFNGVENvbmZpZyhvdXRwdXRfZGlyJTNEJTIyJTJGdG1wJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEc2Z0X2NvbmZpZyUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

sft_config = SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=sft_config,
)

trainer.train()`,wrap:!1}}),R=new f({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),B=new f({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),q=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRDb25maWclMkMlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEU0ZUQ29uZmlnKG91dHB1dF9kaXIlM0QlMjIlMkZ0bXAlMjIpJTJDJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGluZ19mdW5jJTNEZm9ybWF0dGluZ19wcm9tcHRzX2Z1bmMlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0b3IlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>),
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),X=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRDb25maWclMkMlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RTRlRDb25maWcob3V0cHV0X2RpciUzRCUyMiUyRnRtcCUyMiklMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>),
    train_dataset=dataset,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),S=new f({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),V=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),L=new M({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCk=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)',wrap:!1}}),D=new M({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),O=new f({props:{title:"Add Special Tokens for Chat Format",local:"add-special-tokens-for-chat-format",headingTag:"h3"}}),tt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEElMjMlMjBTZXQlMjB1cCUyMHRoZSUyMGNoYXQlMjBmb3JtYXQlMjB3aXRoJTIwZGVmYXVsdCUyMCdjaGF0bWwnJTIwZm9ybWF0JTBBbW9kZWwlMkMlMjB0b2tlbml6ZXIlMjAlM0QlMjBzZXR1cF9jaGF0X2Zvcm1hdChtb2RlbCUyQyUyMHRva2VuaXplciklMEE=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-comment"># Set up the chat format with default &#x27;chatml&#x27; format</span>
model, tokenizer = setup_chat_format(model, tokenizer)
`,wrap:!1}}),at=new f({props:{title:"Dataset format support",local:"dataset-format-support",headingTag:"h3"}}),lt=new M({props:{code:"JTdCJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGhlbHBmdWwlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMi4uLiUyMiU3RCU1RCU3RCUwQSU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBoZWxwZnVsJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwd3JvdGUlMjAnUm9tZW8lMjBhbmQlMjBKdWxpZXQnJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIuLi4lMjIlN0QlNUQlN0QlMEElN0IlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwaGVscGZ1bCUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMGZhciUyMGlzJTIwdGhlJTIwTW9vbiUyMGZyb20lMjBFYXJ0aCUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyLi4uJTIyJTdEJTVEJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What&#x27;s the capital of France?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Who wrote &#x27;Romeo and Juliet&#x27;?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How far is the Moon from Earth?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),it=new M({props:{code:"JTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyJTNDcHJvbXB0JTIwdGV4dCUzRSUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlM0NpZGVhbCUyMGdlbmVyYXRlZCUyMHRleHQlM0UlMjIlN0QlMEElN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjIlM0Nwcm9tcHQlMjB0ZXh0JTNFJTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCUyMiUzQ2lkZWFsJTIwZ2VuZXJhdGVkJTIwdGV4dCUzRSUyMiU3RCUwQSU3QiUyMnByb21wdCUyMiUzQSUyMCUyMiUzQ3Byb21wdCUyMHRleHQlM0UlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTNDaWRlYWwlMjBnZW5lcmF0ZWQlMjB0ZXh0JTNFJTIyJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),pt=new M({props:{code:"JTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

...

<span class="hljs-comment"># load jsonl dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=<span class="hljs-string">&quot;path/to/dataset.jsonl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-comment"># load dataset from the HuggingFace Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;philschmid/dolly-15k-oai-style&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

...

sft_config = STFConfig(packing=<span class="hljs-literal">True</span>)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    args=sft_config,
    train_dataset=dataset,
)`,wrap:!1}}),dt=new f({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),ut=new M({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),Mt=new M({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    args=sft_config,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),yt=new f({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),gt=new M({props:{code:"JTBB",highlighted:`...
sft_config = SFTConfig(packing=<span class="hljs-literal">True</span>, dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config
)

trainer.train()`,wrap:!1}}),bt=new f({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),wt=new M({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEFzZnRfY29uZmlnJTIwJTNEJTIwU1RGQ29uZmlnKHBhY2tpbmclM0RUcnVlKSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RzZnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGluZ19mdW5jJTNEZm9ybWF0dGluZ19mdW5jJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

sft_config = STFConfig(packing=<span class="hljs-literal">True</span>)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),Jt=new f({props:{title:"Control over the pretrained model",local:"control-over-the-pretrained-model",headingTag:"h3"}}),Ct=new M({props:{code:"JTBBJTBB",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)

...

sft_config = SFTConfig(
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: <span class="hljs-string">&quot;bfloat16&quot;</span>,
    },
    output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config,
)

trainer.train()`,wrap:!1}}),Ft=new f({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),$t=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1uZW8tMTI1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRFNGVENvbmZpZyhvdXRwdXRfZGlyJTNEJTIyJTJGdG1wJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>),
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),xt=new f({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),Rt=new M({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=STFConfig(),
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),Bt=new f({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),qt=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),Xt=new f({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),St=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),Vt=new M({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),Lt=new f({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),Dt=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),Pt=new M({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTBBKQ==",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>
)`,wrap:!1}}),ee=new f({props:{title:"Using model creation utility",local:"trl.ModelConfig",headingTag:"h3"}}),ne=new us({props:{name:"class trl.ModelConfig",anchor:"trl.ModelConfig",parameters:[{name:"model_name_or_path",val:": Optional = None"},{name:"model_revision",val:": str = 'main'"},{name:"torch_dtype",val:": Optional = None"},{name:"trust_remote_code",val:": bool = False"},{name:"attn_implementation",val:": Optional = None"},{name:"use_peft",val:": bool = False"},{name:"lora_r",val:": Optional = 16"},{name:"lora_alpha",val:": Optional = 32"},{name:"lora_dropout",val:": Optional = 0.05"},{name:"lora_target_modules",val:": Optional = None"},{name:"lora_modules_to_save",val:": Optional = None"},{name:"lora_task_type",val:": str = 'CAUSAL_LM'"},{name:"load_in_8bit",val:": bool = False"},{name:"load_in_4bit",val:": bool = False"},{name:"bnb_4bit_quant_type",val:": Optional = 'nf4'"},{name:"use_bnb_nested_quant",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1753/trl/trainer/model_config.py#L7"}}),se=new M({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyME1vZGVsQ29uZmlnJTJDJTIwU0ZUVHJhaW5lciUyQyUyMGdldF9rYml0X2RldmljZV9tYXAlMkMlMjBnZXRfcGVmdF9jb25maWclMkMlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyUwQW1vZGVsX2NvbmZpZyUyMCUzRCUyME1vZGVsQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWVfb3JfcGF0aCUzRCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMEElMjAlMjAlMjAlMjBhdHRuX2ltcGxlbWVudGF0aW9uJTNETm9uZSUyQyUyMCUyMyUyMG9yJTIwJTIyZmxhc2hfYXR0ZW50aW9uXzIlMjIlMEEpJTBBdG9yY2hfZHR5cGUlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwbW9kZWxfY29uZmlnLnRvcmNoX2R0eXBlJTBBJTIwJTIwJTIwJTIwaWYlMjBtb2RlbF9jb25maWcudG9yY2hfZHR5cGUlMjBpbiUyMCU1QiUyMmF1dG8lMjIlMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwZWxzZSUyMGdldGF0dHIodG9yY2glMkMlMjBtb2RlbF9jb25maWcudG9yY2hfZHR5cGUpJTBBKSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyhtb2RlbF9jb25maWcpJTBBbW9kZWxfa3dhcmdzJTIwJTNEJTIwZGljdCglMEElMjAlMjAlMjAlMjByZXZpc2lvbiUzRG1vZGVsX2NvbmZpZy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEbW9kZWxfY29uZmlnLnRydXN0X3JlbW90ZV9jb2RlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRG1vZGVsX2NvbmZpZy5hdHRuX2ltcGxlbWVudGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaF9kdHlwZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzREZhbHNlJTIwaWYlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjBlbHNlJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RnZXRfa2JpdF9kZXZpY2VfbWFwKCklMjBpZiUyMHF1YW50aXphdGlvbl9jb25maWclMjBpcyUyMG5vdCUyME5vbmUlMjBlbHNlJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NvbmZpZy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMjAqKm1vZGVsX2t3YXJncyklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsX2NvbmZpZy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGdldF9wZWZ0X2NvbmZpZyhtb2RlbF9jb25maWcpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> ModelConfig, SFTTrainer, get_kbit_device_map, get_peft_config, get_quantization_config
model_config = ModelConfig(
    model_name_or_path=<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
    attn_implementation=<span class="hljs-literal">None</span>, <span class="hljs-comment"># or &quot;flash_attention_2&quot;</span>
)
torch_dtype = (
    model_config.torch_dtype
    <span class="hljs-keyword">if</span> model_config.torch_dtype <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;auto&quot;</span>, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">else</span> <span class="hljs-built_in">getattr</span>(torch, model_config.torch_dtype)
)
quantization_config = get_quantization_config(model_config)
model_kwargs = <span class="hljs-built_in">dict</span>(
    revision=model_config.model_revision,
    trust_remote_code=model_config.trust_remote_code,
    attn_implementation=model_config.attn_implementation,
    torch_dtype=torch_dtype,
    use_cache=<span class="hljs-literal">False</span> <span class="hljs-keyword">if</span> training_args.gradient_checkpointing <span class="hljs-keyword">else</span> <span class="hljs-literal">True</span>,
    device_map=get_kbit_device_map() <span class="hljs-keyword">if</span> quantization_config <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
    quantization_config=quantization_config,
)
model = AutoModelForCausalLM.from_pretrained(model_config.model_name_or_path, **model_kwargs)
trainer = SFTTrainer(
    ...,
    model=model_config.model_name_or_path,
    peft_config=get_peft_config(model_config),
)`,wrap:!1}}),le=new f({props:{title:"Enhance the model’s performances using NEFTune",local:"enhance-the-models-performances-using-neftune",headingTag:"h3"}}),pe=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNURkNvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXNmdF9jb25maWclMjAlM0QlMjBTVEZDb25maWcoJTBBJTIwJTIwJTIwJTIwbmVmdHVuZV9ub2lzZV9hbHBoYSUzRDUlMkMlMEEpJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHNmdF9jb25maWclMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> STFConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

sft_config = STFConfig(
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config,
)
trainer.train()`,wrap:!1}}),me=new f({props:{title:"Accelerate fine-tuning 2x using unsloth",local:"accelerate-fine-tuning-2x-using-unsloth",headingTag:"h3"}}),fe=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwU0ZUQ29uZmlnJTJDJTIwU0ZUVHJhaW5lciUwQWZyb20lMjB1bnNsb3RoJTIwaW1wb3J0JTIwRmFzdExhbmd1YWdlTW9kZWwlMEElMEFtYXhfc2VxX2xlbmd0aCUyMCUzRCUyMDIwNDglMjAlMjMlMjBTdXBwb3J0cyUyMGF1dG9tYXRpYyUyMFJvUEUlMjBTY2FsaW5nJTJDJTIwc28lMjBjaG9vc2UlMjBhbnklMjBudW1iZXIlMEElMEElMjMlMjBMb2FkJTIwbW9kZWwlMEFtb2RlbCUyQyUyMHRva2VuaXplciUyMCUzRCUyMEZhc3RMYW5ndWFnZU1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJTIydW5zbG90aCUyRm1pc3RyYWwtN2IlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0ROb25lJTJDJTIwJTIwJTIzJTIwTm9uZSUyMGZvciUyMGF1dG8lMjBkZXRlY3Rpb24uJTIwRmxvYXQxNiUyMGZvciUyMFRlc2xhJTIwVDQlMkMlMjBWMTAwJTJDJTIwQmZsb2F0MTYlMjBmb3IlMjBBbXBlcmUlMkIlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwJTIwJTIzJTIwVXNlJTIwNGJpdCUyMHF1YW50aXphdGlvbiUyMHRvJTIwcmVkdWNlJTIwbWVtb3J5JTIwdXNhZ2UuJTIwQ2FuJTIwYmUlMjBGYWxzZSUwQSUyMCUyMCUyMCUyMCUyMyUyMHRva2VuJTIwJTNEJTIwJTIyaGZfLi4uJTIyJTJDJTIwJTIzJTIwdXNlJTIwb25lJTIwaWYlMjB1c2luZyUyMGdhdGVkJTIwbW9kZWxzJTIwbGlrZSUyMG1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWhmJTBBKSUwQSUwQSUyMyUyMERvJTIwbW9kZWwlMjBwYXRjaGluZyUyMGFuZCUyMGFkZCUyMGZhc3QlMjBMb1JBJTIwd2VpZ2h0cyUwQW1vZGVsJTIwJTNEJTIwRmFzdExhbmd1YWdlTW9kZWwuZ2V0X3BlZnRfbW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnFfcHJvaiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmtfcHJvaiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZfcHJvaiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9fcHJvaiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmdhdGVfcHJvaiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVwX3Byb2olMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkb3duX3Byb2olMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwJTJDJTIwJTIwJTIzJTIwRHJvcG91dCUyMCUzRCUyMDAlMjBpcyUyMGN1cnJlbnRseSUyMG9wdGltaXplZCUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTIwJTIwJTIzJTIwQmlhcyUyMCUzRCUyMCUyMm5vbmUlMjIlMjBpcyUyMGN1cnJlbnRseSUyMG9wdGltaXplZCUwQSUyMCUyMCUyMCUyMHVzZV9ncmFkaWVudF9jaGVja3BvaW50aW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJhbmRvbV9zdGF0ZSUzRDM0MDclMkMlMEEpJTBBJTBBYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyLiUyRm91dHB1dCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkYXRhc2V0X3RleHRfZmllbGQlM0QlMjJ0ZXh0JTIyJTJDJTBBKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name=<span class="hljs-string">&quot;unsloth/mistral-7b&quot;</span>,
    max_seq_length=max_seq_length,
    dtype=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r=<span class="hljs-number">16</span>,
    target_modules=[
        <span class="hljs-string">&quot;q_proj&quot;</span>,
        <span class="hljs-string">&quot;k_proj&quot;</span>,
        <span class="hljs-string">&quot;v_proj&quot;</span>,
        <span class="hljs-string">&quot;o_proj&quot;</span>,
        <span class="hljs-string">&quot;gate_proj&quot;</span>,
        <span class="hljs-string">&quot;up_proj&quot;</span>,
        <span class="hljs-string">&quot;down_proj&quot;</span>,
    ],
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0</span>,  <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,  <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing=<span class="hljs-literal">True</span>,
    random_state=<span class="hljs-number">3407</span>,
)

args = SFTConfig(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    max_seq_length=max_seq_length,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
)

trainer = SFTTrainer(
    model=model,
    args=args,
    train_dataset=dataset,
)
trainer.train()`,wrap:!1}}),Te=new f({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),be=new f({props:{title:"Multi-GPU Training",local:"multi-gpu-training",headingTag:"h2"}}),je=new M({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEFkZXZpY2Vfc3RyaW5nJTIwJTNEJTIwUGFydGlhbFN0YXRlKCkucHJvY2Vzc19pbmRleCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlN0InJyUzQWRldmljZV9zdHJpbmclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
device_string = PartialState().process_index
model = AutoModelForCausalLM.from_pretrained(
     ...
    device_map={<span class="hljs-string">&#x27;&#x27;</span>:device_string}
)`,wrap:!1}}),Je=new f({props:{title:"GPTQ Conversion",local:"gptq-conversion",headingTag:"h2"}}),Ce=new f({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),ke=new us({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": Optional = False"},{name:"formatting_func",val:": Optional = None"},{name:"max_seq_length",val:": Optional = None"},{name:"infinite",val:": Optional = None"},{name:"num_of_sequences",val:": Optional = 1024"},{name:"chars_per_token",val:": Optional = 3.6"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"},{name:"eval_packing",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTConfig">SFTConfig</a>) &#x2014;
The arguments to tweak for training. Will default to a basic instance of <a href="/docs/trl/pr_1753/en/sft_trainer#trl.SFTConfig">SFTConfig</a> with the <code>output_dir</code>
set to a directory named <em>tmp_trainer</em> in the current directory if not provided.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/vr_1753/trl/trainer/sft_trainer.py#L58"}}),Fe=new f({props:{title:"SFTConfig",local:"trl.SFTConfig",headingTag:"h2"}}),Ie=new us({props:{name:"class trl.SFTConfig",anchor:"trl.SFTConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": Optional = False"},{name:"max_seq_length",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"},{name:"eval_packing",val:": Optional = None"},{name:"num_of_sequences",val:": Optional = 1024"},{name:"chars_per_token",val:": Optional = 3.6"}],parametersDescription:[{anchor:"trl.SFTConfig.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument. Defaults to None.`,name:"dataset_text_field"},{anchor:"trl.SFTConfig.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset. Defaults to False.`,name:"packing"},{anchor:"trl.SFTConfig.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automatically creating the Dataset. Defaults to min of the smaller of the <code>tokenizer.model_max_length</code> and <code>1024</code>.`,name:"max_seq_length"},{anchor:"trl.SFTConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTConfig.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTConfig.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instruction
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
dataset_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when creating packed or non-packed datasets
eval_packing &#x2014; (<code>Optional[bool]</code>, <em>optional</em>):
Whether to pack the eval dataset as well. Defaults to <code>packing</code> if <code>None</code> is passed.`,name:"neftune_noise_alpha"},{anchor:"trl.SFTConfig.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTConfig.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"}],source:"https://github.com/huggingface/trl/blob/vr_1753/trl/trainer/sft_config.py#L20"}}),$e=new f({props:{title:"Datasets",local:"datasets",headingTag:"h2"}}),Ge=new f({props:{title:"ConstantLengthDataset",local:"trl.trainer.ConstantLengthDataset",headingTag:"h3"}}),Re=new us({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"tokenizer",val:""},{name:"dataset",val:""},{name:"dataset_text_field",val:" = None"},{name:"formatting_func",val:" = None"},{name:"infinite",val:" = False"},{name:"seq_length",val:" = 1024"},{name:"num_of_sequences",val:" = 1024"},{name:"chars_per_token",val:" = 3.6"},{name:"eos_token_id",val:" = 0"},{name:"shuffle",val:" = True"},{name:"append_concat_token",val:" = True"},{name:"add_special_tokens",val:" = True"}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
Name of the field in the dataset that contains the text. Used only if <code>formatting_func</code> is <code>None</code>.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <strong>optional</strong>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as <code>&quot;### Question: {question} ### Answer: {answer}&quot;</code>`,name:"formatting_func"},{anchor:"trl.trainer.ConstantLengthDataset.infinite",description:`<strong>infinite</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True the iterator is reset after dataset reaches end else stops.`,name:"infinite"},{anchor:"trl.trainer.ConstantLengthDataset.seq_length",description:`<strong>seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Length of token sequences to return.`,name:"seq_length"},{anchor:"trl.trainer.ConstantLengthDataset.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of token sequences to keep in buffer.`,name:"num_of_sequences"},{anchor:"trl.trainer.ConstantLengthDataset.chars_per_token",description:`<strong>chars_per_token</strong> (<code>int</code>, <em>optional</em>, defaults to <code>3.6</code>) &#x2014;
Number of characters per token used to estimate number of tokens in text buffer.`,name:"chars_per_token"},{anchor:"trl.trainer.ConstantLengthDataset.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Id of the end of sequence token if the passed tokenizer does not have an EOS token.`,name:"eos_token_id"},{anchor:"trl.trainer.ConstantLengthDataset.shuffle",description:`<strong>shuffle</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
Shuffle the examples before they are returned`,name:"shuffle"},{anchor:"trl.trainer.ConstantLengthDataset.append_concat_token",description:`<strong>append_concat_token</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
If true, appends <code>eos_token_id</code> at the end of each sample being packed.`,name:"append_concat_token"},{anchor:"trl.trainer.ConstantLengthDataset.add_special_tokens",description:`<strong>add_special_tokens</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
If true, tokenizers adds special tokens to each sample being packed.`,name:"add_special_tokens"}],source:"https://github.com/huggingface/trl/blob/vr_1753/trl/trainer/utils.py#L413"}}),Be=new Xl({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/sft_trainer.mdx"}}),{c(){y=o("meta"),We=s(),Qe=o("p"),Ae=s(),p(J.$$.fragment),He=s(),v=o("p"),v.textContent=gs,Le=s(),C=o("p"),C.innerHTML=_s,Ye=s(),p(k.$$.fragment),De=s(),F=o("p"),F.innerHTML=bs,Oe=s(),p(I.$$.fragment),Pe=s(),$=o("p"),$.innerHTML=Us,Ke=s(),Z=o("p"),Z.textContent=ws,ta=s(),p(x.$$.fragment),ea=s(),G=o("p"),G.innerHTML=js,aa=s(),p(R.$$.fragment),na=s(),p(B.$$.fragment),sa=s(),N=o("p"),N.innerHTML=Js,la=s(),p(q.$$.fragment),oa=s(),z=o("p"),z.innerHTML=vs,ia=s(),p(X.$$.fragment),ra=s(),E=o("p"),E.innerHTML=Cs,pa=s(),p(S.$$.fragment),ca=s(),Q=o("p"),Q.innerHTML=ks,da=s(),p(V.$$.fragment),ma=s(),W=o("p"),W.innerHTML=Fs,ua=s(),A=o("ul"),A.innerHTML=Is,ha=s(),H=o("p"),H.innerHTML=$s,Ma=s(),p(L.$$.fragment),fa=s(),Y=o("p"),Y.innerHTML=Zs,ya=s(),p(D.$$.fragment),Ta=s(),p(O.$$.fragment),ga=s(),P=o("p"),P.innerHTML=xs,_a=s(),K=o("ul"),K.innerHTML=Gs,ba=s(),p(tt.$$.fragment),Ua=s(),et=o("p"),et.textContent=Rs,wa=s(),p(at.$$.fragment),ja=s(),nt=o("p"),nt.innerHTML=Bs,Ja=s(),st=o("ul"),st.innerHTML=Ns,va=s(),p(lt.$$.fragment),Ca=s(),ot=o("ul"),ot.innerHTML=qs,ka=s(),p(it.$$.fragment),Fa=s(),rt=o("p"),rt.innerHTML=zs,Ia=s(),p(pt.$$.fragment),$a=s(),ct=o("p"),ct.textContent=Xs,Za=s(),p(dt.$$.fragment),xa=s(),mt=o("p"),mt.innerHTML=Es,Ga=s(),p(ut.$$.fragment),Ra=s(),ht=o("p"),ht.innerHTML=Ss,Ba=s(),p(Mt.$$.fragment),Na=s(),ft=o("p"),ft.innerHTML=Qs,qa=s(),p(yt.$$.fragment),za=s(),Tt=o("p"),Tt.innerHTML=Vs,Xa=s(),p(gt.$$.fragment),Ea=s(),_t=o("p"),_t.innerHTML=Ws,Sa=s(),p(bt.$$.fragment),Qa=s(),Ut=o("p"),Ut.innerHTML=As,Va=s(),p(wt.$$.fragment),Wa=s(),jt=o("p"),jt.innerHTML=Hs,Aa=s(),p(Jt.$$.fragment),Ha=s(),vt=o("p"),vt.innerHTML=Ls,La=s(),p(Ct.$$.fragment),Ya=s(),kt=o("p"),kt.innerHTML=Ys,Da=s(),p(Ft.$$.fragment),Oa=s(),It=o("p"),It.textContent=Ds,Pa=s(),p($t.$$.fragment),Ka=s(),Zt=o("p"),Zt.innerHTML=Os,tn=s(),p(xt.$$.fragment),en=s(),Gt=o("p"),Gt.innerHTML=Ps,an=s(),p(Rt.$$.fragment),nn=s(),p(Bt.$$.fragment),sn=s(),Nt=o("p"),Nt.textContent=Ks,ln=s(),p(qt.$$.fragment),on=s(),zt=o("p"),zt.textContent=tl,rn=s(),p(Xt.$$.fragment),pn=s(),Et=o("p"),Et.innerHTML=el,cn=s(),p(St.$$.fragment),dn=s(),Qt=o("p"),Qt.innerHTML=al,mn=s(),p(Vt.$$.fragment),un=s(),Wt=o("p"),Wt.innerHTML=nl,hn=s(),At=o("p"),At.textContent=sl,Mn=s(),Ht=o("table"),Ht.innerHTML=ll,fn=s(),p(Lt.$$.fragment),yn=s(),Yt=o("p"),Yt.innerHTML=ol,Tn=s(),p(Dt.$$.fragment),gn=s(),Ot=o("p"),Ot.innerHTML=il,_n=s(),p(Pt.$$.fragment),bn=s(),Kt=o("p"),Kt.textContent=rl,Un=s(),te=o("p"),te.textContent=pl,wn=s(),p(ee.$$.fragment),jn=s(),ae=o("p"),ae.textContent=cl,Jn=s(),T=o("div"),p(ne.$$.fragment),hs=s(),Ne=o("p"),Ne.textContent=dl,vn=s(),p(se.$$.fragment),Cn=s(),p(le.$$.fragment),kn=s(),oe=o("p"),oe.innerHTML=ml,Fn=s(),ie=o("blockquote"),ie.innerHTML=ul,In=s(),w=o("div"),w.innerHTML=hl,$n=s(),re=o("p"),re.innerHTML=Ml,Zn=s(),p(pe.$$.fragment),xn=s(),ce=o("p"),ce.innerHTML=fl,Gn=s(),j=o("div"),j.innerHTML=yl,Rn=s(),de=o("p"),de.innerHTML=Tl,Bn=s(),p(me.$$.fragment),Nn=s(),ue=o("p"),ue.innerHTML=gl,qn=s(),he=o("table"),he.innerHTML=_l,zn=s(),Me=o("p"),Me.innerHTML=bl,Xn=s(),p(fe.$$.fragment),En=s(),ye=o("p"),ye.innerHTML=Ul,Sn=s(),p(Te.$$.fragment),Qn=s(),ge=o("p"),ge.textContent=wl,Vn=s(),_e=o("ul"),_e.innerHTML=jl,Wn=s(),p(be.$$.fragment),An=s(),Ue=o("p"),Ue.innerHTML=Jl,Hn=s(),we=o("ul"),we.innerHTML=vl,Ln=s(),p(je.$$.fragment),Yn=s(),p(Je.$$.fragment),Dn=s(),ve=o("p"),ve.innerHTML=Cl,On=s(),p(Ce.$$.fragment),Pn=s(),g=o("div"),p(ke.$$.fragment),Ms=s(),qe=o("p"),qe.innerHTML=kl,Kn=s(),p(Fe.$$.fragment),ts=s(),_=o("div"),p(Ie.$$.fragment),fs=s(),ze=o("p"),ze.textContent=Fl,es=s(),p($e.$$.fragment),as=s(),Ze=o("p"),Ze.innerHTML=Il,ns=s(),xe=o("p"),xe.innerHTML=$l,ss=s(),p(Ge.$$.fragment),ls=s(),b=o("div"),p(Re.$$.fragment),ys=s(),Xe=o("p"),Xe.textContent=Zl,os=s(),p(Be.$$.fragment),is=s(),Ve=o("p"),this.h()},l(t){const e=zl("svelte-u9bgzb",document.head);y=i(e,"META",{name:!0,content:!0}),e.forEach(a),We=l(t),Qe=i(t,"P",{}),Ee(Qe).forEach(a),Ae=l(t),c(J.$$.fragment,t),He=l(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-o839x3"&&(v.textContent=gs),Le=l(t),C=i(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1apqcwz"&&(C.innerHTML=_s),Ye=l(t),c(k.$$.fragment,t),De=l(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1lqe7bw"&&(F.innerHTML=bs),Oe=l(t),c(I.$$.fragment,t),Pe=l(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-4l7u4"&&($.innerHTML=Us),Ke=l(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-ulikv8"&&(Z.textContent=ws),ta=l(t),c(x.$$.fragment,t),ea=l(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-z9ot7v"&&(G.innerHTML=js),aa=l(t),c(R.$$.fragment,t),na=l(t),c(B.$$.fragment,t),sa=l(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-13sbeoj"&&(N.innerHTML=Js),la=l(t),c(q.$$.fragment,t),oa=l(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1a743rp"&&(z.innerHTML=vs),ia=l(t),c(X.$$.fragment,t),ra=l(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-rjhq4r"&&(E.innerHTML=Cs),pa=l(t),c(S.$$.fragment,t),ca=l(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-12zdtxn"&&(Q.innerHTML=ks),da=l(t),c(V.$$.fragment,t),ma=l(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-xlwe87"&&(W.innerHTML=Fs),ua=l(t),A=i(t,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-1enki0k"&&(A.innerHTML=Is),ha=l(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-14yxh0m"&&(H.innerHTML=$s),Ma=l(t),c(L.$$.fragment,t),fa=l(t),Y=i(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-hvnyie"&&(Y.innerHTML=Zs),ya=l(t),c(D.$$.fragment,t),Ta=l(t),c(O.$$.fragment,t),ga=l(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1ccg0zx"&&(P.innerHTML=xs),_a=l(t),K=i(t,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-ebt5re"&&(K.innerHTML=Gs),ba=l(t),c(tt.$$.fragment,t),Ua=l(t),et=i(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1hmfl2q"&&(et.textContent=Rs),wa=l(t),c(at.$$.fragment,t),ja=l(t),nt=i(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1u4b1bt"&&(nt.innerHTML=Bs),Ja=l(t),st=i(t,"UL",{"data-svelte-h":!0}),r(st)!=="svelte-5iwuvk"&&(st.innerHTML=Ns),va=l(t),c(lt.$$.fragment,t),Ca=l(t),ot=i(t,"UL",{"data-svelte-h":!0}),r(ot)!=="svelte-23l1e6"&&(ot.innerHTML=qs),ka=l(t),c(it.$$.fragment,t),Fa=l(t),rt=i(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-exrw33"&&(rt.innerHTML=zs),Ia=l(t),c(pt.$$.fragment,t),$a=l(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-145h0zs"&&(ct.textContent=Xs),Za=l(t),c(dt.$$.fragment,t),xa=l(t),mt=i(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-cqsf2h"&&(mt.innerHTML=Es),Ga=l(t),c(ut.$$.fragment,t),Ra=l(t),ht=i(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-l25vq0"&&(ht.innerHTML=Ss),Ba=l(t),c(Mt.$$.fragment,t),Na=l(t),ft=i(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-j2xlt3"&&(ft.innerHTML=Qs),qa=l(t),c(yt.$$.fragment,t),za=l(t),Tt=i(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-8j9axs"&&(Tt.innerHTML=Vs),Xa=l(t),c(gt.$$.fragment,t),Ea=l(t),_t=i(t,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-t5o0mn"&&(_t.innerHTML=Ws),Sa=l(t),c(bt.$$.fragment,t),Qa=l(t),Ut=i(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-iejqw3"&&(Ut.innerHTML=As),Va=l(t),c(wt.$$.fragment,t),Wa=l(t),jt=i(t,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1eaj4lq"&&(jt.innerHTML=Hs),Aa=l(t),c(Jt.$$.fragment,t),Ha=l(t),vt=i(t,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-q729ra"&&(vt.innerHTML=Ls),La=l(t),c(Ct.$$.fragment,t),Ya=l(t),kt=i(t,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-1su7aih"&&(kt.innerHTML=Ys),Da=l(t),c(Ft.$$.fragment,t),Oa=l(t),It=i(t,"P",{"data-svelte-h":!0}),r(It)!=="svelte-9vpjkk"&&(It.textContent=Ds),Pa=l(t),c($t.$$.fragment,t),Ka=l(t),Zt=i(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-pwdaav"&&(Zt.innerHTML=Os),tn=l(t),c(xt.$$.fragment,t),en=l(t),Gt=i(t,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-11pydf"&&(Gt.innerHTML=Ps),an=l(t),c(Rt.$$.fragment,t),nn=l(t),c(Bt.$$.fragment,t),sn=l(t),Nt=i(t,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-fyvvsj"&&(Nt.textContent=Ks),ln=l(t),c(qt.$$.fragment,t),on=l(t),zt=i(t,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-yypgof"&&(zt.textContent=tl),rn=l(t),c(Xt.$$.fragment,t),pn=l(t),Et=i(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-yugu96"&&(Et.innerHTML=el),cn=l(t),c(St.$$.fragment,t),dn=l(t),Qt=i(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-1qms4cl"&&(Qt.innerHTML=al),mn=l(t),c(Vt.$$.fragment,t),un=l(t),Wt=i(t,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-qe5zfz"&&(Wt.innerHTML=nl),hn=l(t),At=i(t,"P",{"data-svelte-h":!0}),r(At)!=="svelte-69u1rz"&&(At.textContent=sl),Mn=l(t),Ht=i(t,"TABLE",{"data-svelte-h":!0}),r(Ht)!=="svelte-8fq96j"&&(Ht.innerHTML=ll),fn=l(t),c(Lt.$$.fragment,t),yn=l(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-1rqlm78"&&(Yt.innerHTML=ol),Tn=l(t),c(Dt.$$.fragment,t),gn=l(t),Ot=i(t,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-14s96xo"&&(Ot.innerHTML=il),_n=l(t),c(Pt.$$.fragment,t),bn=l(t),Kt=i(t,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-vfpk19"&&(Kt.textContent=rl),Un=l(t),te=i(t,"P",{"data-svelte-h":!0}),r(te)!=="svelte-162zeem"&&(te.textContent=pl),wn=l(t),c(ee.$$.fragment,t),jn=l(t),ae=i(t,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-u9yx96"&&(ae.textContent=cl),Jn=l(t),T=i(t,"DIV",{class:!0});var ps=Ee(T);c(ne.$$.fragment,ps),hs=l(ps),Ne=i(ps,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-fghgxx"&&(Ne.textContent=dl),ps.forEach(a),vn=l(t),c(se.$$.fragment,t),Cn=l(t),c(le.$$.fragment,t),kn=l(t),oe=i(t,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-6trhkk"&&(oe.innerHTML=ml),Fn=l(t),ie=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(ie)!=="svelte-1ejl1pl"&&(ie.innerHTML=ul),In=l(t),w=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(w)!=="svelte-1wkjgyb"&&(w.innerHTML=hl),$n=l(t),re=i(t,"P",{"data-svelte-h":!0}),r(re)!=="svelte-15c39pv"&&(re.innerHTML=Ml),Zn=l(t),c(pe.$$.fragment,t),xn=l(t),ce=i(t,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-sqj12"&&(ce.innerHTML=fl),Gn=l(t),j=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(j)!=="svelte-a1m5gi"&&(j.innerHTML=yl),Rn=l(t),de=i(t,"P",{"data-svelte-h":!0}),r(de)!=="svelte-rwofnh"&&(de.innerHTML=Tl),Bn=l(t),c(me.$$.fragment,t),Nn=l(t),ue=i(t,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1q1m1nw"&&(ue.innerHTML=gl),qn=l(t),he=i(t,"TABLE",{"data-svelte-h":!0}),r(he)!=="svelte-lj2wpp"&&(he.innerHTML=_l),zn=l(t),Me=i(t,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1p74c9x"&&(Me.innerHTML=bl),Xn=l(t),c(fe.$$.fragment,t),En=l(t),ye=i(t,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1o18rwj"&&(ye.innerHTML=Ul),Sn=l(t),c(Te.$$.fragment,t),Qn=l(t),ge=i(t,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-g801h1"&&(ge.textContent=wl),Vn=l(t),_e=i(t,"UL",{"data-svelte-h":!0}),r(_e)!=="svelte-uw1tu5"&&(_e.innerHTML=jl),Wn=l(t),c(be.$$.fragment,t),An=l(t),Ue=i(t,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-s3xf41"&&(Ue.innerHTML=Jl),Hn=l(t),we=i(t,"UL",{"data-svelte-h":!0}),r(we)!=="svelte-19jsxq"&&(we.innerHTML=vl),Ln=l(t),c(je.$$.fragment,t),Yn=l(t),c(Je.$$.fragment,t),Dn=l(t),ve=i(t,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-xofzi2"&&(ve.innerHTML=Cl),On=l(t),c(Ce.$$.fragment,t),Pn=l(t),g=i(t,"DIV",{class:!0});var cs=Ee(g);c(ke.$$.fragment,cs),Ms=l(cs),qe=i(cs,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-14oyph8"&&(qe.innerHTML=kl),cs.forEach(a),Kn=l(t),c(Fe.$$.fragment,t),ts=l(t),_=i(t,"DIV",{class:!0});var ds=Ee(_);c(Ie.$$.fragment,ds),fs=l(ds),ze=i(ds,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-yl69cr"&&(ze.textContent=Fl),ds.forEach(a),es=l(t),c($e.$$.fragment,t),as=l(t),Ze=i(t,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-16l6c3u"&&(Ze.innerHTML=Il),ns=l(t),xe=i(t,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-k5kqyl"&&(xe.innerHTML=$l),ss=l(t),c(Ge.$$.fragment,t),ls=l(t),b=i(t,"DIV",{class:!0});var ms=Ee(b);c(Re.$$.fragment,ms),ys=l(ms),Xe=i(ms,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1dlriq1"&&(Xe.textContent=Zl),ms.forEach(a),os=l(t),c(Be.$$.fragment,t),is=l(t),Ve=i(t,"P",{}),Ee(Ve).forEach(a),this.h()},h(){Se(y,"name","hf:doc:metadata"),Se(y,"content",Sl),Se(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),xl(w,"text-align","center"),xl(j,"text-align","center"),Se(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Se(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Se(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){U(document.head,y),n(t,We,e),n(t,Qe,e),n(t,Ae,e),d(J,t,e),n(t,He,e),n(t,v,e),n(t,Le,e),n(t,C,e),n(t,Ye,e),d(k,t,e),n(t,De,e),n(t,F,e),n(t,Oe,e),d(I,t,e),n(t,Pe,e),n(t,$,e),n(t,Ke,e),n(t,Z,e),n(t,ta,e),d(x,t,e),n(t,ea,e),n(t,G,e),n(t,aa,e),d(R,t,e),n(t,na,e),d(B,t,e),n(t,sa,e),n(t,N,e),n(t,la,e),d(q,t,e),n(t,oa,e),n(t,z,e),n(t,ia,e),d(X,t,e),n(t,ra,e),n(t,E,e),n(t,pa,e),d(S,t,e),n(t,ca,e),n(t,Q,e),n(t,da,e),d(V,t,e),n(t,ma,e),n(t,W,e),n(t,ua,e),n(t,A,e),n(t,ha,e),n(t,H,e),n(t,Ma,e),d(L,t,e),n(t,fa,e),n(t,Y,e),n(t,ya,e),d(D,t,e),n(t,Ta,e),d(O,t,e),n(t,ga,e),n(t,P,e),n(t,_a,e),n(t,K,e),n(t,ba,e),d(tt,t,e),n(t,Ua,e),n(t,et,e),n(t,wa,e),d(at,t,e),n(t,ja,e),n(t,nt,e),n(t,Ja,e),n(t,st,e),n(t,va,e),d(lt,t,e),n(t,Ca,e),n(t,ot,e),n(t,ka,e),d(it,t,e),n(t,Fa,e),n(t,rt,e),n(t,Ia,e),d(pt,t,e),n(t,$a,e),n(t,ct,e),n(t,Za,e),d(dt,t,e),n(t,xa,e),n(t,mt,e),n(t,Ga,e),d(ut,t,e),n(t,Ra,e),n(t,ht,e),n(t,Ba,e),d(Mt,t,e),n(t,Na,e),n(t,ft,e),n(t,qa,e),d(yt,t,e),n(t,za,e),n(t,Tt,e),n(t,Xa,e),d(gt,t,e),n(t,Ea,e),n(t,_t,e),n(t,Sa,e),d(bt,t,e),n(t,Qa,e),n(t,Ut,e),n(t,Va,e),d(wt,t,e),n(t,Wa,e),n(t,jt,e),n(t,Aa,e),d(Jt,t,e),n(t,Ha,e),n(t,vt,e),n(t,La,e),d(Ct,t,e),n(t,Ya,e),n(t,kt,e),n(t,Da,e),d(Ft,t,e),n(t,Oa,e),n(t,It,e),n(t,Pa,e),d($t,t,e),n(t,Ka,e),n(t,Zt,e),n(t,tn,e),d(xt,t,e),n(t,en,e),n(t,Gt,e),n(t,an,e),d(Rt,t,e),n(t,nn,e),d(Bt,t,e),n(t,sn,e),n(t,Nt,e),n(t,ln,e),d(qt,t,e),n(t,on,e),n(t,zt,e),n(t,rn,e),d(Xt,t,e),n(t,pn,e),n(t,Et,e),n(t,cn,e),d(St,t,e),n(t,dn,e),n(t,Qt,e),n(t,mn,e),d(Vt,t,e),n(t,un,e),n(t,Wt,e),n(t,hn,e),n(t,At,e),n(t,Mn,e),n(t,Ht,e),n(t,fn,e),d(Lt,t,e),n(t,yn,e),n(t,Yt,e),n(t,Tn,e),d(Dt,t,e),n(t,gn,e),n(t,Ot,e),n(t,_n,e),d(Pt,t,e),n(t,bn,e),n(t,Kt,e),n(t,Un,e),n(t,te,e),n(t,wn,e),d(ee,t,e),n(t,jn,e),n(t,ae,e),n(t,Jn,e),n(t,T,e),d(ne,T,null),U(T,hs),U(T,Ne),n(t,vn,e),d(se,t,e),n(t,Cn,e),d(le,t,e),n(t,kn,e),n(t,oe,e),n(t,Fn,e),n(t,ie,e),n(t,In,e),n(t,w,e),n(t,$n,e),n(t,re,e),n(t,Zn,e),d(pe,t,e),n(t,xn,e),n(t,ce,e),n(t,Gn,e),n(t,j,e),n(t,Rn,e),n(t,de,e),n(t,Bn,e),d(me,t,e),n(t,Nn,e),n(t,ue,e),n(t,qn,e),n(t,he,e),n(t,zn,e),n(t,Me,e),n(t,Xn,e),d(fe,t,e),n(t,En,e),n(t,ye,e),n(t,Sn,e),d(Te,t,e),n(t,Qn,e),n(t,ge,e),n(t,Vn,e),n(t,_e,e),n(t,Wn,e),d(be,t,e),n(t,An,e),n(t,Ue,e),n(t,Hn,e),n(t,we,e),n(t,Ln,e),d(je,t,e),n(t,Yn,e),d(Je,t,e),n(t,Dn,e),n(t,ve,e),n(t,On,e),d(Ce,t,e),n(t,Pn,e),n(t,g,e),d(ke,g,null),U(g,Ms),U(g,qe),n(t,Kn,e),d(Fe,t,e),n(t,ts,e),n(t,_,e),d(Ie,_,null),U(_,fs),U(_,ze),n(t,es,e),d($e,t,e),n(t,as,e),n(t,Ze,e),n(t,ns,e),n(t,xe,e),n(t,ss,e),d(Ge,t,e),n(t,ls,e),n(t,b,e),d(Re,b,null),U(b,ys),U(b,Xe),n(t,os,e),d(Be,t,e),n(t,is,e),n(t,Ve,e),rs=!0},p:Rl,i(t){rs||(m(J.$$.fragment,t),m(k.$$.fragment,t),m(I.$$.fragment,t),m(x.$$.fragment,t),m(R.$$.fragment,t),m(B.$$.fragment,t),m(q.$$.fragment,t),m(X.$$.fragment,t),m(S.$$.fragment,t),m(V.$$.fragment,t),m(L.$$.fragment,t),m(D.$$.fragment,t),m(O.$$.fragment,t),m(tt.$$.fragment,t),m(at.$$.fragment,t),m(lt.$$.fragment,t),m(it.$$.fragment,t),m(pt.$$.fragment,t),m(dt.$$.fragment,t),m(ut.$$.fragment,t),m(Mt.$$.fragment,t),m(yt.$$.fragment,t),m(gt.$$.fragment,t),m(bt.$$.fragment,t),m(wt.$$.fragment,t),m(Jt.$$.fragment,t),m(Ct.$$.fragment,t),m(Ft.$$.fragment,t),m($t.$$.fragment,t),m(xt.$$.fragment,t),m(Rt.$$.fragment,t),m(Bt.$$.fragment,t),m(qt.$$.fragment,t),m(Xt.$$.fragment,t),m(St.$$.fragment,t),m(Vt.$$.fragment,t),m(Lt.$$.fragment,t),m(Dt.$$.fragment,t),m(Pt.$$.fragment,t),m(ee.$$.fragment,t),m(ne.$$.fragment,t),m(se.$$.fragment,t),m(le.$$.fragment,t),m(pe.$$.fragment,t),m(me.$$.fragment,t),m(fe.$$.fragment,t),m(Te.$$.fragment,t),m(be.$$.fragment,t),m(je.$$.fragment,t),m(Je.$$.fragment,t),m(Ce.$$.fragment,t),m(ke.$$.fragment,t),m(Fe.$$.fragment,t),m(Ie.$$.fragment,t),m($e.$$.fragment,t),m(Ge.$$.fragment,t),m(Re.$$.fragment,t),m(Be.$$.fragment,t),rs=!0)},o(t){u(J.$$.fragment,t),u(k.$$.fragment,t),u(I.$$.fragment,t),u(x.$$.fragment,t),u(R.$$.fragment,t),u(B.$$.fragment,t),u(q.$$.fragment,t),u(X.$$.fragment,t),u(S.$$.fragment,t),u(V.$$.fragment,t),u(L.$$.fragment,t),u(D.$$.fragment,t),u(O.$$.fragment,t),u(tt.$$.fragment,t),u(at.$$.fragment,t),u(lt.$$.fragment,t),u(it.$$.fragment,t),u(pt.$$.fragment,t),u(dt.$$.fragment,t),u(ut.$$.fragment,t),u(Mt.$$.fragment,t),u(yt.$$.fragment,t),u(gt.$$.fragment,t),u(bt.$$.fragment,t),u(wt.$$.fragment,t),u(Jt.$$.fragment,t),u(Ct.$$.fragment,t),u(Ft.$$.fragment,t),u($t.$$.fragment,t),u(xt.$$.fragment,t),u(Rt.$$.fragment,t),u(Bt.$$.fragment,t),u(qt.$$.fragment,t),u(Xt.$$.fragment,t),u(St.$$.fragment,t),u(Vt.$$.fragment,t),u(Lt.$$.fragment,t),u(Dt.$$.fragment,t),u(Pt.$$.fragment,t),u(ee.$$.fragment,t),u(ne.$$.fragment,t),u(se.$$.fragment,t),u(le.$$.fragment,t),u(pe.$$.fragment,t),u(me.$$.fragment,t),u(fe.$$.fragment,t),u(Te.$$.fragment,t),u(be.$$.fragment,t),u(je.$$.fragment,t),u(Je.$$.fragment,t),u(Ce.$$.fragment,t),u(ke.$$.fragment,t),u(Fe.$$.fragment,t),u(Ie.$$.fragment,t),u($e.$$.fragment,t),u(Ge.$$.fragment,t),u(Re.$$.fragment,t),u(Be.$$.fragment,t),rs=!1},d(t){t&&(a(We),a(Qe),a(Ae),a(He),a(v),a(Le),a(C),a(Ye),a(De),a(F),a(Oe),a(Pe),a($),a(Ke),a(Z),a(ta),a(ea),a(G),a(aa),a(na),a(sa),a(N),a(la),a(oa),a(z),a(ia),a(ra),a(E),a(pa),a(ca),a(Q),a(da),a(ma),a(W),a(ua),a(A),a(ha),a(H),a(Ma),a(fa),a(Y),a(ya),a(Ta),a(ga),a(P),a(_a),a(K),a(ba),a(Ua),a(et),a(wa),a(ja),a(nt),a(Ja),a(st),a(va),a(Ca),a(ot),a(ka),a(Fa),a(rt),a(Ia),a($a),a(ct),a(Za),a(xa),a(mt),a(Ga),a(Ra),a(ht),a(Ba),a(Na),a(ft),a(qa),a(za),a(Tt),a(Xa),a(Ea),a(_t),a(Sa),a(Qa),a(Ut),a(Va),a(Wa),a(jt),a(Aa),a(Ha),a(vt),a(La),a(Ya),a(kt),a(Da),a(Oa),a(It),a(Pa),a(Ka),a(Zt),a(tn),a(en),a(Gt),a(an),a(nn),a(sn),a(Nt),a(ln),a(on),a(zt),a(rn),a(pn),a(Et),a(cn),a(dn),a(Qt),a(mn),a(un),a(Wt),a(hn),a(At),a(Mn),a(Ht),a(fn),a(yn),a(Yt),a(Tn),a(gn),a(Ot),a(_n),a(bn),a(Kt),a(Un),a(te),a(wn),a(jn),a(ae),a(Jn),a(T),a(vn),a(Cn),a(kn),a(oe),a(Fn),a(ie),a(In),a(w),a($n),a(re),a(Zn),a(xn),a(ce),a(Gn),a(j),a(Rn),a(de),a(Bn),a(Nn),a(ue),a(qn),a(he),a(zn),a(Me),a(Xn),a(En),a(ye),a(Sn),a(Qn),a(ge),a(Vn),a(_e),a(Wn),a(An),a(Ue),a(Hn),a(we),a(Ln),a(Yn),a(Dn),a(ve),a(On),a(Pn),a(g),a(Kn),a(ts),a(_),a(es),a(as),a(Ze),a(ns),a(xe),a(ss),a(ls),a(b),a(os),a(is),a(Ve)),a(y),h(J,t),h(k,t),h(I,t),h(x,t),h(R,t),h(B,t),h(q,t),h(X,t),h(S,t),h(V,t),h(L,t),h(D,t),h(O,t),h(tt,t),h(at,t),h(lt,t),h(it,t),h(pt,t),h(dt,t),h(ut,t),h(Mt,t),h(yt,t),h(gt,t),h(bt,t),h(wt,t),h(Jt,t),h(Ct,t),h(Ft,t),h($t,t),h(xt,t),h(Rt,t),h(Bt,t),h(qt,t),h(Xt,t),h(St,t),h(Vt,t),h(Lt,t),h(Dt,t),h(Pt,t),h(ee,t),h(ne),h(se,t),h(le,t),h(pe,t),h(me,t),h(fe,t),h(Te,t),h(be,t),h(je,t),h(Je,t),h(Ce,t),h(ke),h(Fe,t),h(Ie),h($e,t),h(Ge,t),h(Re),h(Be,t)}}}const Sl='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Add Special Tokens for Chat Format","local":"add-special-tokens-for-chat-format","sections":[],"depth":3},{"title":"Dataset format support","local":"dataset-format-support","sections":[],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"control-over-the-pretrained-model","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Using model creation utility","local":"trl.ModelConfig","sections":[],"depth":3},{"title":"Enhance the model’s performances using NEFTune","local":"enhance-the-models-performances-using-neftune","sections":[],"depth":3},{"title":"Accelerate fine-tuning 2x using unsloth","local":"accelerate-fine-tuning-2x-using-unsloth","sections":[],"depth":3}],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"Multi-GPU Training","local":"multi-gpu-training","sections":[],"depth":2},{"title":"GPTQ Conversion","local":"gptq-conversion","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"SFTConfig","local":"trl.SFTConfig","sections":[],"depth":2},{"title":"Datasets","local":"datasets","sections":[{"title":"ConstantLengthDataset","local":"trl.trainer.ConstantLengthDataset","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ql(Ts){return Bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yl extends Nl{constructor(y){super(),ql(this,y,Ql,El,Gl,{})}}export{Yl as component};
