import{s as il,o as al,n as sl}from"../chunks/scheduler.7b8d42e8.js";import{S as ol,i as Ml,g as s,s as i,r as p,A as pl,h as o,f as l,c as a,j as ll,u as r,x as M,k as nl,y as rl,a as n,v as m,d,t as c,w as y}from"../chunks/index.8a4d5423.js";import{T as ml}from"../chunks/Tip.8a16d533.js";import{C as T}from"../chunks/CodeBlock.f81140b4.js";import{H as J,E as dl}from"../chunks/EditOnGithub.838f2538.js";function cl(bt){let u,j="If not specified, <code>load_in_8bit</code> will be set to <code>True</code> by default when models larger than 1 billion parameters are exported to the OpenVINO format (with <code>export=True</code>). You can disable it with <code>load_in_8bit=False</code>.";return{c(){u=s("p"),u.innerHTML=j},l(h){u=o(h,"P",{"data-svelte-h":!0}),M(u)!=="svelte-pe94ru"&&(u.innerHTML=j)},m(h,jt){n(h,u,jt)},p:sl,d(h){h&&l(u)}}}function yl(bt){let u,j,h,jt,w,ft,b,Ce='🤗 Optimum Intel provides an <code>openvino</code> package that enables you to apply a variety of model compression methods such as quantization, pruning, on many models hosted on the 🤗 hub using the <a href="https://docs.openvino.ai/2024/openvino-workflow/model-optimization.html" rel="nofollow">NNCF</a> framework.',Ct,f,gt,C,ge="Quantization is a technique to reduce the computational and memory costs of running inference by representing the weights and / or the activations with lower precision data types like 8-bit or 4-bit.",Zt,g,It,Z,Ze="Quantization can be applied on the model’s Linear, Convolutional and Embedding layers, enabling the loading of large models on memory-limited devices. For example, when applying 8-bit quantization, the resulting model will be x4 smaller than its fp32 counterpart. For 4-bit quantization, the reduction in memory could theoretically reach x8, but is closer to x6 in practice.",vt,I,Wt,v,Ie="For the 8-bit weight quantization you can set <code>load_in_8bit=True</code> to load your model’s weights in 8-bit:",Vt,W,zt,U,Gt,V,ve="You can also provide a <code>quantization_config</code> instead to specify additional optimization parameters.",Rt,z,At,G,We="For the 4-bit weight quantization, you need a <code>quantization_config</code> to define the optimization parameters, for example:",Bt,R,Xt,A,Ve="You can tune quantization parameters to achieve a better performance accuracy trade-off as follows:",kt,B,qt,X,ze='By default the quantization scheme will be <a href="https://github.com/openvinotoolkit/nncf/blob/develop/docs/usage/training_time_compression/other_algorithms/LegacyQuantization.md#asymmetric-quantization" rel="nofollow">asymmetric</a>, to make it <a href="https://github.com/openvinotoolkit/nncf/blob/develop/docs/usage/training_time_compression/other_algorithms/LegacyQuantization.md#symmetric-quantization" rel="nofollow">symmetric</a> you can add <code>sym=True</code>.',Qt,k,Ge="For 4-bit quantization you can also specify the following arguments in the quantization configuration :",_t,q,Re="<li>The <code>group_size</code> parameter will define the group size to use for quantization, <code>-1</code> it will results in per-column quantization.</li> <li>The <code>ratio</code> parameter controls the ratio between 4-bit and 8-bit quantization. If set to 0.9, it means that 90% of the layers will be quantized to <code>int4</code> while 10% will be quantized to <code>int8</code>.</li>",Ft,Q,Ae="Smaller <code>group_size</code> and <code>ratio</code> values usually improve accuracy at the sacrifice of the model size and inference latency.",Et,_,$t,F,Be=`When applying post-training static quantization, both the weights and the activations are quantized.
To apply quantization on the activations, an additional calibration step is needed which consists in feeding a <code>calibration_dataset</code> to the network in order to estimate the quantization activations parameters.`,Nt,E,Xe="Here is how to apply static quantization on a fine-tuned DistilBERT given your own <code>calibration_dataset</code>:",Ht,$,Yt,N,ke="The calibration dataset can also be created easily using your <code>OVQuantizer</code>:",xt,H,St,Y,qe="The <code>quantize()</code> method applies post-training static quantization and export the resulting quantized model to the OpenVINO Intermediate Representation (IR). The resulting graph is represented with two files: an XML file describing the network topology and a binary file describing the weights. The resulting model can be run on any target Intel device.",Lt,x,Ot,S,Qe=`Traditional optimization methods like post-training 8-bit quantization do not work well for Stable Diffusion (SD) models and can lead to poor generation results. On the other hand, weight compression does not improve performance significantly when applied to Stable Diffusion models, as the size of activations is comparable to weights.
The U-Net component takes up most of the overall execution time of the pipeline. Thus, optimizing just this one component can bring substantial benefits in terms of inference speed while keeping acceptable accuracy without fine-tuning. Quantizing the rest of the diffusion pipeline does not significantly improve inference performance but could potentially lead to substantial accuracy degradation.
Therefore, the proposal is to apply quantization in <em>hybrid mode</em> for the U-Net model and weight-only quantization for the rest of the pipeline components :`,Dt,L,_e="<li>U-Net : quantization applied on both the weights and activations</li> <li>The text encoder, VAE encoder / decoder : quantization applied on the weights</li>",Pt,O,Fe="The hybrid mode involves the quantization of weights in MatMul and Embedding layers, and activations of other layers, facilitating accuracy preservation post-optimization while reducing the model size.",Kt,D,Ee="The <code>quantization_config</code> is utilized to define optimization parameters for optimizing the SD pipeline. To enable hybrid quantization, specify the quantization dataset in the <code>quantization_config</code>. If the dataset is not defined, weight-only quantization will be applied on all components.",te,P,ee,K,$e='For more details, please refer to the corresponding NNCF <a href="https://github.com/openvinotoolkit/nncf/blob/develop/docs/usage/post_training_compression/weights_compression/Usage.md" rel="nofollow">documentation</a>.',le,tt,ne,et,Ne="Apart from optimizing a model after training like post-training quantization above, <code>optimum.openvino</code> also provides optimization methods during training, namely Quantization-Aware Training (QAT) and Joint Pruning, Quantization and Distillation (JPQD).",ie,lt,ae,nt,He="QAT simulates the effects of quantization during training, in order to alleviate its effects on the model’s accuracy. It is recommended in the case where post-training quantization results in high accuracy degradation. Here is an example on how to fine-tune a DistilBERT on the sst-2 task while applying quantization aware training (QAT).",se,it,oe,at,Me,st,Ye="Other than quantization, compression methods like pruning and distillation are common in further improving the task performance and efficiency. Structured pruning slims a model for lower computational demands while distillation leverages knowledge of a teacher, usually, larger model to improve model prediction. Combining these methods with quantization can result in optimized model with significant efficiency improvement while enjoying good task accuracy retention. In <code>optimum.openvino</code>, <code>OVTrainer</code> provides the capability to jointly prune, quantize and distill a model during training. Following is an example on how to perform the optimization on BERT-base for the sst-2 task.",pe,ot,xe='First, we create a config dictionary to specify the target algorithms. As <code>optimum.openvino</code> relies on NNCF as backend, the config format follows NNCF specifications (see <a href="https://github.com/openvinotoolkit/nncf/blob/develop/docs/usage/training_time_compression/other_algorithms" rel="nofollow">here</a>). In the example config below, we specify pruning and quantization in a list of compression with thier hyperparameters. The pruning method closely resembles the work of <a href="https://arxiv.org/pdf/2109.04838.pdf" rel="nofollow">Lagunas et al., 2021, Block Pruning For Faster Transformers</a> whereas the quantization refers to QAT. With this configuration, the model under optimization will be initialized with pruning and quantization operators at the beginning of the training.',re,Mt,me,pt,Se='<p>Known limitation: Current structured pruning with movement sparsity only supports <em>BERT, Wav2vec2 and Swin</em> family of models. See <a href="https://github.com/openvinotoolkit/nncf/blob/develop/nncf/experimental/torch/sparsity/movement/MovementSparsity.md" rel="nofollow">here</a> for more information.</p>',de,rt,Le="Once we have the config ready, we can start develop the training pipeline like the snippet below. Since we are customizing joint compression with config above, notice that <code>OVConfig</code> is initialized with config dictionary (JSON parsing to python dictionary is skipped for brevity). As for distillation, users are required to load the teacher model, it is just like a normal model loading with transformers API. <code>OVTrainingArguments</code> extends transformers’ <code>TrainingArguments</code> with distillation hyperparameters, i.e. distillation weightage and temperature for ease of use. The snippet below shows how we load a teacher model and create training arguments with <code>OVTrainingArguments</code>. Subsequently, the teacher model, with the instantiated <code>OVConfig</code> and <code>OVTrainingArguments</code> are fed to <code>OVTrainer</code>. Voila! that is all we need, the rest of the pipeline is identical to native transformers training.",ce,mt,ye,dt,Oe='More on the description and how to configure movement sparsity, see NNCF documentation <a href="https://github.com/openvinotoolkit/nncf/blob/develop/nncf/experimental/torch/sparsity/movement/MovementSparsity.md" rel="nofollow">here</a>.',ue,ct,De='More on available algorithms in NNCF, see documentation <a href="https://github.com/openvinotoolkit/nncf/tree/develop/docs/usage/training_time_compression/other_algorithms" rel="nofollow">here</a>.',he,yt,Pe='For complete JPQD scripts, please refer to examples provided <a href="https://github.com/huggingface/optimum-intel/tree/main/examples/openvino" rel="nofollow">here</a>.',Je,ut,Ke='Quantization-Aware Training (QAT) and knowledge distillation can also be combined in order to optimize Stable Diffusion models while maintaining accuracy. For more details, take a look at this <a href="https://huggingface.co/blog/train-optimize-sd-intel" rel="nofollow">blog post</a>.',Te,ht,Ue,Jt,tl='After applying quantization on our model, we can then easily load it with our <code>OVModelFor&lt;Task&gt;</code> classes and perform inference with OpenVINO Runtime using the Transformers <a href="https://huggingface.co/docs/transformers/main/en/main_classes/pipelines" rel="nofollow">pipelines</a>.',je,Tt,we,Ut,be,wt,fe;return w=new J({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),f=new J({props:{title:"Post-training",local:"post-training",headingTag:"h2"}}),g=new J({props:{title:"Weight-only quantization",local:"weight-only-quantization",headingTag:"h3"}}),I=new J({props:{title:"8-bit",local:"8-bit",headingTag:"h4"}}),W=new T({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVk1vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmhlbGVuYWklMkZncHQyLW92JTIyJTBBbW9kZWwlMjAlM0QlMjBPVk1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSklMEElMEElMjMlMjBTYXZlcyUyMHRoZSUyMGludDglMjBtb2RlbCUyMHRoYXQlMjB3aWxsJTIwYmUlMjB4NCUyMHNtYWxsZXIlMjB0aGFuJTIwaXRzJTIwZnAzMiUyMGNvdW50ZXJwYXJ0JTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHNhdmluZ19kaXJlY3Rvcnkp",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVModelForCausalLM

model_id = <span class="hljs-string">&quot;helenai/gpt2-ov&quot;</span>
model = OVModelForCausalLM.from_pretrained(model_id, load_in_8bit=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Saves the int8 model that will be x4 smaller than its fp32 counterpart</span>
model.save_pretrained(saving_directory)`,wrap:!1}}),U=new ml({props:{warning:!0,$$slots:{default:[cl]},$$scope:{ctx:bt}}}),z=new J({props:{title:"4-bit",local:"4-bit",headingTag:"h4"}}),R=new T({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVk1vZGVsRm9yQ2F1c2FsTE0lMkMlMjBPVldlaWdodFF1YW50aXphdGlvbkNvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBPVldlaWdodFF1YW50aXphdGlvbkNvbmZpZyhiaXRzJTNENCklMEFtb2RlbCUyMCUzRCUyME9WTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVModelForCausalLM, OVWeightQuantizationConfig

quantization_config = OVWeightQuantizationConfig(bits=<span class="hljs-number">4</span>)
model = OVModelForCausalLM.from_pretrained(model_id, quantization_config=quantization_config)`,wrap:!1}}),B=new T({props:{code:"cXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyME9WV2VpZ2h0UXVhbnRpemF0aW9uQ29uZmlnKGJpdHMlM0Q0JTJDJTIwc3ltJTNERmFsc2UlMkMlMjByYXRpbyUzRDAuOCUyQyUyMGRhdGFzZXQlM0QlMjJwdGIlMjIp",highlighted:'quantization_config = OVWeightQuantizationConfig(bits=<span class="hljs-number">4</span>, sym=<span class="hljs-literal">False</span>, ratio=<span class="hljs-number">0.8</span>, dataset=<span class="hljs-string">&quot;ptb&quot;</span>)',wrap:!1}}),_=new J({props:{title:"Static quantization",local:"static-quantization",headingTag:"h3"}}),$=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5pbnRlbCUyMGltcG9ydCUyME9WUXVhbnRpemVyJTJDJTIwT1ZNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBPVkNvbmZpZyUyQyUyME9WUXVhbnRpemF0aW9uQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUwQW1vZGVsJTIwJTNEJTIwT1ZNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBUaGUlMjBkaXJlY3RvcnklMjB3aGVyZSUyMHRoZSUyMHF1YW50aXplZCUyMG1vZGVsJTIwd2lsbCUyMGJlJTIwc2F2ZWQlMEFzYXZlX2RpciUyMCUzRCUyMCUyMnB0cV9tb2RlbCUyMiUwQSUwQXF1YW50aXplciUyMCUzRCUyME9WUXVhbnRpemVyLmZyb21fcHJldHJhaW5lZChtb2RlbCklMEElMEElMjMlMjBBcHBseSUyMHN0YXRpYyUyMHF1YW50aXphdGlvbiUyMGFuZCUyMGV4cG9ydCUyMHRoZSUyMHJlc3VsdGluZyUyMHF1YW50aXplZCUyMG1vZGVsJTIwdG8lMjBPcGVuVklOTyUyMElSJTIwZm9ybWF0JTBBb3ZfY29uZmlnJTIwJTNEJTIwT1ZDb25maWcocXVhbnRpemF0aW9uX2NvbmZpZyUzRE9WUXVhbnRpemF0aW9uQ29uZmlnKCkpJTBBcXVhbnRpemVyLnF1YW50aXplKG92X2NvbmZpZyUzRG92X2NvbmZpZyUyQyUyMGNhbGlicmF0aW9uX2RhdGFzZXQlM0RjYWxpYnJhdGlvbl9kYXRhc2V0JTJDJTIwc2F2ZV9kaXJlY3RvcnklM0RzYXZlX2RpciklMEElMjMlMjBTYXZlJTIwdGhlJTIwdG9rZW5pemVyJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZChzYXZlX2Rpcik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVQuantizer, OVModelForSequenceClassification, OVConfig, OVQuantizationConfig

model_id = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
model = OVModelForSequenceClassification.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
tokenizer = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-comment"># The directory where the quantized model will be saved</span>
save_dir = <span class="hljs-string">&quot;ptq_model&quot;</span>

quantizer = OVQuantizer.from_pretrained(model)

<span class="hljs-comment"># Apply static quantization and export the resulting quantized model to OpenVINO IR format</span>
ov_config = OVConfig(quantization_config=OVQuantizationConfig())
quantizer.quantize(ov_config=ov_config, calibration_dataset=calibration_dataset, save_directory=save_dir)
<span class="hljs-comment"># Save the tokenizer</span>
tokenizer.save_pretrained(save_dir)`,wrap:!1}}),H=new T({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEFkZWYlMjBwcmVwcm9jZXNzX2Z1bmN0aW9uKGV4YW1wbGVzJTJDJTIwdG9rZW5pemVyKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplcihleGFtcGxlcyU1QiUyMnNlbnRlbmNlJTIyJTVEJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjBtYXhfbGVuZ3RoJTNEMTI4JTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwY2FsaWJyYXRpb24lMjBkYXRhc2V0JTIwdXNlZCUyMHRvJTIwcGVyZm9ybSUyMHN0YXRpYyUyMHF1YW50aXphdGlvbiUwQWNhbGlicmF0aW9uX2RhdGFzZXQlMjAlM0QlMjBxdWFudGl6ZXIuZ2V0X2NhbGlicmF0aW9uX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyZ2x1ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfY29uZmlnX25hbWUlM0QlMjJzc3QyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcHJlcHJvY2Vzc19mdW5jdGlvbiUzRHBhcnRpYWwocHJlcHJvY2Vzc19mdW5jdGlvbiUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMkMlMEElMjAlMjAlMjAlMjBudW1fc2FtcGxlcyUzRDMwMCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples, tokenizer</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;sentence&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=<span class="hljs-number">128</span>, truncation=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Create the calibration dataset used to perform static quantization</span>
calibration_dataset = quantizer.get_calibration_dataset(
    <span class="hljs-string">&quot;glue&quot;</span>,
    dataset_config_name=<span class="hljs-string">&quot;sst2&quot;</span>,
    preprocess_function=partial(preprocess_function, tokenizer=tokenizer),
    num_samples=<span class="hljs-number">300</span>,
    dataset_split=<span class="hljs-string">&quot;train&quot;</span>,
)`,wrap:!1}}),x=new J({props:{title:"Hybrid quantization",local:"hybrid-quantization",headingTag:"h3"}}),P=new T({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwT1ZXZWlnaHRRdWFudGl6YXRpb25Db25maWclMEElMEFtb2RlbCUyMCUzRCUyME9WU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RPVldlaWdodFF1YW50aXphdGlvbkNvbmZpZyhiaXRzJTNEOCUyQyUyMGRhdGFzZXQlM0QlMjJjb25jZXB0dWFsX2NhcHRpb25zJTIyKSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionPipeline, OVWeightQuantizationConfig

model = OVStableDiffusionPipeline.from_pretrained(
    model_id,
    export=<span class="hljs-literal">True</span>,
    quantization_config=OVWeightQuantizationConfig(bits=<span class="hljs-number">8</span>, dataset=<span class="hljs-string">&quot;conceptual_captions&quot;</span>),
)`,wrap:!1}}),tt=new J({props:{title:"Training-time",local:"training-time",headingTag:"h2"}}),lt=new J({props:{title:"Quantization-Aware Training (QAT)",local:"quantization-aware-training-qat",headingTag:"h3"}}),it=new T({props:{code:"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",highlighted:`  import evaluate
  import numpy as np
  from transformers import (
      AutoModelForSequenceClassification,
      AutoTokenizer,
      TrainingArguments,
      default_data_collator,
  )
  from datasets import load_dataset
<span class="hljs-deletion">- from transformers import Trainer</span>
<span class="hljs-addition">+ from optimum.intel import OVConfig, OVTrainer, OVModelForSequenceClassification</span>

  model_id = &quot;distilbert-base-uncased-finetuned-sst-2-english&quot;
  model = AutoModelForSequenceClassification.from_pretrained(model_id)
  tokenizer = AutoTokenizer.from_pretrained(model_id)
  # The directory where the quantized model will be saved
  save_dir = &quot;qat_model&quot;
  dataset = load_dataset(&quot;glue&quot;, &quot;sst2&quot;)
  dataset = dataset.map(
      lambda examples: tokenizer(examples[&quot;sentence&quot;], padding=True), batched=True
  )
  metric = evaluate.load(&quot;glue&quot;, &quot;sst2&quot;)

  def compute_metrics(eval_preds):
      preds = np.argmax(eval_preds.predictions, axis=1)
      return metric.compute(predictions=preds, references=eval_preds.label_ids)

  # Load the default quantization configuration detailing the quantization we wish to apply
<span class="hljs-addition">+ ov_config = OVConfig()</span>

<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = OVTrainer(</span>
      model=model,
      args=TrainingArguments(save_dir, num_train_epochs=1.0, do_train=True, do_eval=True),
      train_dataset=dataset[&quot;train&quot;].select(range(300)),
      eval_dataset=dataset[&quot;validation&quot;],
      compute_metrics=compute_metrics,
      tokenizer=tokenizer,
      data_collator=default_data_collator,
<span class="hljs-addition">+     ov_config=ov_config,</span>
<span class="hljs-addition">+     task=&quot;text-classification&quot;,</span>
)

  # Train the model while applying quantization
  train_result = trainer.train()
  metrics = trainer.evaluate()
  # Export the quantized model to OpenVINO IR format and save it
  trainer.save_model()

  # Load the resulting quantized model
<span class="hljs-deletion">- model = AutoModelForSequenceClassification.from_pretrained(save_dir)</span>
<span class="hljs-addition">+ model = OVModelForSequenceClassification.from_pretrained(save_dir)</span>`,wrap:!1}}),at=new J({props:{title:"Joint Pruning, Quantization and Distillation (JPQD)",local:"joint-pruning-quantization-and-distillation-jpqd",headingTag:"h3"}}),Mt=new T({props:{code:"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",highlighted:`compression_config = [
    {
        <span class="hljs-string">&quot;compression&quot;</span>:
        {
        <span class="hljs-string">&quot;algorithm&quot;</span>:  <span class="hljs-string">&quot;movement_sparsity&quot;</span>,
        <span class="hljs-string">&quot;params&quot;</span>: {
            <span class="hljs-string">&quot;warmup_start_epoch&quot;</span>:  <span class="hljs-number">1</span>,
            <span class="hljs-string">&quot;warmup_end_epoch&quot;</span>:    <span class="hljs-number">4</span>,
            <span class="hljs-string">&quot;importance_regularization_factor&quot;</span>:  <span class="hljs-number">0.01</span>,
            <span class="hljs-string">&quot;enable_structured_masking&quot;</span>:  <span class="hljs-literal">True</span>
        },
        <span class="hljs-string">&quot;sparse_structure_by_scopes&quot;</span>: [
            {<span class="hljs-string">&quot;mode&quot;</span>:  <span class="hljs-string">&quot;block&quot;</span>,   <span class="hljs-string">&quot;sparse_factors&quot;</span>: [<span class="hljs-number">32</span>, <span class="hljs-number">32</span>], <span class="hljs-string">&quot;target_scopes&quot;</span>: <span class="hljs-string">&quot;{re}.*BertAttention.*&quot;</span>},
            {<span class="hljs-string">&quot;mode&quot;</span>:  <span class="hljs-string">&quot;per_dim&quot;</span>, <span class="hljs-string">&quot;axis&quot;</span>:  <span class="hljs-number">0</span>,                 <span class="hljs-string">&quot;target_scopes&quot;</span>: <span class="hljs-string">&quot;{re}.*BertIntermediate.*&quot;</span>},
            {<span class="hljs-string">&quot;mode&quot;</span>:  <span class="hljs-string">&quot;per_dim&quot;</span>, <span class="hljs-string">&quot;axis&quot;</span>:  <span class="hljs-number">1</span>,                 <span class="hljs-string">&quot;target_scopes&quot;</span>: <span class="hljs-string">&quot;{re}.*BertOutput.*&quot;</span>},
        ],
        <span class="hljs-string">&quot;ignored_scopes&quot;</span>: [<span class="hljs-string">&quot;{re}.*NNCFEmbedding&quot;</span>, <span class="hljs-string">&quot;{re}.*pooler.*&quot;</span>, <span class="hljs-string">&quot;{re}.*LayerNorm.*&quot;</span>]
        }
    },
    {
        <span class="hljs-string">&quot;algorithm&quot;</span>: <span class="hljs-string">&quot;quantization&quot;</span>,
        <span class="hljs-string">&quot;weights&quot;</span>: {<span class="hljs-string">&quot;mode&quot;</span>: <span class="hljs-string">&quot;symmetric&quot;</span>}
        <span class="hljs-string">&quot;activations&quot;</span>: { <span class="hljs-string">&quot;mode&quot;</span>: <span class="hljs-string">&quot;symmetric&quot;</span>},
    }
]`,wrap:!1}}),mt=new T({props:{code:"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",highlighted:`<span class="hljs-deletion">- from transformers import Trainer, TrainingArguments</span>
<span class="hljs-addition">+ from optimum.intel import OVConfig, OVTrainer, OVTrainingArguments</span>

  # Load teacher model
<span class="hljs-addition">+ teacher_model = AutoModelForSequenceClassification.from_pretrained(teacher_model_or_path)</span>

<span class="hljs-deletion">- ov_config = OVConfig()</span>
<span class="hljs-addition">+ ov_config = OVConfig(compression=compression_config)</span>

  trainer = OVTrainer(
      model=model,
<span class="hljs-addition">+     teacher_model=teacher_model,</span>
<span class="hljs-deletion">-     args=TrainingArguments(save_dir, num_train_epochs=1.0, do_train=True, do_eval=True),</span>
<span class="hljs-addition">+     args=OVTrainingArguments(save_dir, num_train_epochs=1.0, do_train=True, do_eval=True, distillation_temperature=3, distillation_weight=0.9),</span>
      train_dataset=dataset[&quot;train&quot;].select(range(300)),
      eval_dataset=dataset[&quot;validation&quot;],
      compute_metrics=compute_metrics,
      tokenizer=tokenizer,
      data_collator=default_data_collator,
<span class="hljs-addition">+     ov_config=ov_config,</span>
      task=&quot;text-classification&quot;,
  )

  # Train the model like usual, internally the training is applied with pruning, quantization and distillation
  train_result = trainer.train()
  metrics = trainer.evaluate()
  # Export the quantized model to OpenVINO IR format and save it
  trainer.save_model()`,wrap:!1}}),ht=new J({props:{title:"Inference with Transformers pipeline",local:"inference-with-transformers-pipeline",headingTag:"h2"}}),Tt=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVk1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyaGVsZW5haSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoLW92LWludDglMjIlMEFvdl9tb2RlbCUyMCUzRCUyME9WTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFjbHNfcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG92X21vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXRleHQlMjAlM0QlMjAlMjJIZSdzJTIwYSUyMGRyZWFkZnVsJTIwbWFnaWNpYW4uJTIyJTBBb3V0cHV0cyUyMCUzRCUyMGNsc19waXBlKHRleHQpJTBBJTBBJTVCJTdCJ2xhYmVsJyUzQSUyMCdORUdBVElWRSclMkMlMjAnc2NvcmUnJTNBJTIwMC45ODQwMTk1MTc4OTg1NTk2JTdEJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVModelForSequenceClassification

model_id = <span class="hljs-string">&quot;helenai/distilbert-base-uncased-finetuned-sst-2-english-ov-int8&quot;</span>
ov_model = OVModelForSequenceClassification.from_pretrained(model_id)
tokenizer = AutoTokenizer.from_pretrained(model_id)
cls_pipe = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=ov_model, tokenizer=tokenizer)
text = <span class="hljs-string">&quot;He&#x27;s a dreadful magician.&quot;</span>
outputs = cls_pipe(text)

[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9840195178985596</span>}]`,wrap:!1}}),Ut=new dl({props:{source:"https://github.com/huggingface/optimum-intel/blob/main/docs/source/optimization_ov.mdx"}}),{c(){u=s("meta"),j=i(),h=s("p"),jt=i(),p(w.$$.fragment),ft=i(),b=s("p"),b.innerHTML=Ce,Ct=i(),p(f.$$.fragment),gt=i(),C=s("p"),C.textContent=ge,Zt=i(),p(g.$$.fragment),It=i(),Z=s("p"),Z.textContent=Ze,vt=i(),p(I.$$.fragment),Wt=i(),v=s("p"),v.innerHTML=Ie,Vt=i(),p(W.$$.fragment),zt=i(),p(U.$$.fragment),Gt=i(),V=s("p"),V.innerHTML=ve,Rt=i(),p(z.$$.fragment),At=i(),G=s("p"),G.innerHTML=We,Bt=i(),p(R.$$.fragment),Xt=i(),A=s("p"),A.textContent=Ve,kt=i(),p(B.$$.fragment),qt=i(),X=s("p"),X.innerHTML=ze,Qt=i(),k=s("p"),k.textContent=Ge,_t=i(),q=s("ul"),q.innerHTML=Re,Ft=i(),Q=s("p"),Q.innerHTML=Ae,Et=i(),p(_.$$.fragment),$t=i(),F=s("p"),F.innerHTML=Be,Nt=i(),E=s("p"),E.innerHTML=Xe,Ht=i(),p($.$$.fragment),Yt=i(),N=s("p"),N.innerHTML=ke,xt=i(),p(H.$$.fragment),St=i(),Y=s("p"),Y.innerHTML=qe,Lt=i(),p(x.$$.fragment),Ot=i(),S=s("p"),S.innerHTML=Qe,Dt=i(),L=s("ul"),L.innerHTML=_e,Pt=i(),O=s("p"),O.textContent=Fe,Kt=i(),D=s("p"),D.innerHTML=Ee,te=i(),p(P.$$.fragment),ee=i(),K=s("p"),K.innerHTML=$e,le=i(),p(tt.$$.fragment),ne=i(),et=s("p"),et.innerHTML=Ne,ie=i(),p(lt.$$.fragment),ae=i(),nt=s("p"),nt.textContent=He,se=i(),p(it.$$.fragment),oe=i(),p(at.$$.fragment),Me=i(),st=s("p"),st.innerHTML=Ye,pe=i(),ot=s("p"),ot.innerHTML=xe,re=i(),p(Mt.$$.fragment),me=i(),pt=s("blockquote"),pt.innerHTML=Se,de=i(),rt=s("p"),rt.innerHTML=Le,ce=i(),p(mt.$$.fragment),ye=i(),dt=s("p"),dt.innerHTML=Oe,ue=i(),ct=s("p"),ct.innerHTML=De,he=i(),yt=s("p"),yt.innerHTML=Pe,Je=i(),ut=s("p"),ut.innerHTML=Ke,Te=i(),p(ht.$$.fragment),Ue=i(),Jt=s("p"),Jt.innerHTML=tl,je=i(),p(Tt.$$.fragment),we=i(),p(Ut.$$.fragment),be=i(),wt=s("p"),this.h()},l(t){const e=pl("svelte-u9bgzb",document.head);u=o(e,"META",{name:!0,content:!0}),e.forEach(l),j=a(t),h=o(t,"P",{}),ll(h).forEach(l),jt=a(t),r(w.$$.fragment,t),ft=a(t),b=o(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-8ulnqi"&&(b.innerHTML=Ce),Ct=a(t),r(f.$$.fragment,t),gt=a(t),C=o(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1bioojp"&&(C.textContent=ge),Zt=a(t),r(g.$$.fragment,t),It=a(t),Z=o(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-17xp9b"&&(Z.textContent=Ze),vt=a(t),r(I.$$.fragment,t),Wt=a(t),v=o(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-e2n41n"&&(v.innerHTML=Ie),Vt=a(t),r(W.$$.fragment,t),zt=a(t),r(U.$$.fragment,t),Gt=a(t),V=o(t,"P",{"data-svelte-h":!0}),M(V)!=="svelte-du2akt"&&(V.innerHTML=ve),Rt=a(t),r(z.$$.fragment,t),At=a(t),G=o(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-18hlgn"&&(G.innerHTML=We),Bt=a(t),r(R.$$.fragment,t),Xt=a(t),A=o(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1oj65vk"&&(A.textContent=Ve),kt=a(t),r(B.$$.fragment,t),qt=a(t),X=o(t,"P",{"data-svelte-h":!0}),M(X)!=="svelte-11zrdex"&&(X.innerHTML=ze),Qt=a(t),k=o(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1edxsd4"&&(k.textContent=Ge),_t=a(t),q=o(t,"UL",{"data-svelte-h":!0}),M(q)!=="svelte-1xdcez2"&&(q.innerHTML=Re),Ft=a(t),Q=o(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1pvf0nk"&&(Q.innerHTML=Ae),Et=a(t),r(_.$$.fragment,t),$t=a(t),F=o(t,"P",{"data-svelte-h":!0}),M(F)!=="svelte-gw3851"&&(F.innerHTML=Be),Nt=a(t),E=o(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1ai8283"&&(E.innerHTML=Xe),Ht=a(t),r($.$$.fragment,t),Yt=a(t),N=o(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1bmrgi2"&&(N.innerHTML=ke),xt=a(t),r(H.$$.fragment,t),St=a(t),Y=o(t,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-10u63fg"&&(Y.innerHTML=qe),Lt=a(t),r(x.$$.fragment,t),Ot=a(t),S=o(t,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1r5icyl"&&(S.innerHTML=Qe),Dt=a(t),L=o(t,"UL",{"data-svelte-h":!0}),M(L)!=="svelte-5q7f0v"&&(L.innerHTML=_e),Pt=a(t),O=o(t,"P",{"data-svelte-h":!0}),M(O)!=="svelte-5c3t0d"&&(O.textContent=Fe),Kt=a(t),D=o(t,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1vn2n7x"&&(D.innerHTML=Ee),te=a(t),r(P.$$.fragment,t),ee=a(t),K=o(t,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1w2f7fi"&&(K.innerHTML=$e),le=a(t),r(tt.$$.fragment,t),ne=a(t),et=o(t,"P",{"data-svelte-h":!0}),M(et)!=="svelte-ab5c1g"&&(et.innerHTML=Ne),ie=a(t),r(lt.$$.fragment,t),ae=a(t),nt=o(t,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-1626xdj"&&(nt.textContent=He),se=a(t),r(it.$$.fragment,t),oe=a(t),r(at.$$.fragment,t),Me=a(t),st=o(t,"P",{"data-svelte-h":!0}),M(st)!=="svelte-1sp2b30"&&(st.innerHTML=Ye),pe=a(t),ot=o(t,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-l7z26h"&&(ot.innerHTML=xe),re=a(t),r(Mt.$$.fragment,t),me=a(t),pt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(pt)!=="svelte-1j5v3fq"&&(pt.innerHTML=Se),de=a(t),rt=o(t,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-171x1zg"&&(rt.innerHTML=Le),ce=a(t),r(mt.$$.fragment,t),ye=a(t),dt=o(t,"P",{"data-svelte-h":!0}),M(dt)!=="svelte-1vt32xa"&&(dt.innerHTML=Oe),ue=a(t),ct=o(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-a4jin4"&&(ct.innerHTML=De),he=a(t),yt=o(t,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-gmp9t8"&&(yt.innerHTML=Pe),Je=a(t),ut=o(t,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-1601gu"&&(ut.innerHTML=Ke),Te=a(t),r(ht.$$.fragment,t),Ue=a(t),Jt=o(t,"P",{"data-svelte-h":!0}),M(Jt)!=="svelte-wihqf3"&&(Jt.innerHTML=tl),je=a(t),r(Tt.$$.fragment,t),we=a(t),r(Ut.$$.fragment,t),be=a(t),wt=o(t,"P",{}),ll(wt).forEach(l),this.h()},h(){nl(u,"name","hf:doc:metadata"),nl(u,"content",ul)},m(t,e){rl(document.head,u),n(t,j,e),n(t,h,e),n(t,jt,e),m(w,t,e),n(t,ft,e),n(t,b,e),n(t,Ct,e),m(f,t,e),n(t,gt,e),n(t,C,e),n(t,Zt,e),m(g,t,e),n(t,It,e),n(t,Z,e),n(t,vt,e),m(I,t,e),n(t,Wt,e),n(t,v,e),n(t,Vt,e),m(W,t,e),n(t,zt,e),m(U,t,e),n(t,Gt,e),n(t,V,e),n(t,Rt,e),m(z,t,e),n(t,At,e),n(t,G,e),n(t,Bt,e),m(R,t,e),n(t,Xt,e),n(t,A,e),n(t,kt,e),m(B,t,e),n(t,qt,e),n(t,X,e),n(t,Qt,e),n(t,k,e),n(t,_t,e),n(t,q,e),n(t,Ft,e),n(t,Q,e),n(t,Et,e),m(_,t,e),n(t,$t,e),n(t,F,e),n(t,Nt,e),n(t,E,e),n(t,Ht,e),m($,t,e),n(t,Yt,e),n(t,N,e),n(t,xt,e),m(H,t,e),n(t,St,e),n(t,Y,e),n(t,Lt,e),m(x,t,e),n(t,Ot,e),n(t,S,e),n(t,Dt,e),n(t,L,e),n(t,Pt,e),n(t,O,e),n(t,Kt,e),n(t,D,e),n(t,te,e),m(P,t,e),n(t,ee,e),n(t,K,e),n(t,le,e),m(tt,t,e),n(t,ne,e),n(t,et,e),n(t,ie,e),m(lt,t,e),n(t,ae,e),n(t,nt,e),n(t,se,e),m(it,t,e),n(t,oe,e),m(at,t,e),n(t,Me,e),n(t,st,e),n(t,pe,e),n(t,ot,e),n(t,re,e),m(Mt,t,e),n(t,me,e),n(t,pt,e),n(t,de,e),n(t,rt,e),n(t,ce,e),m(mt,t,e),n(t,ye,e),n(t,dt,e),n(t,ue,e),n(t,ct,e),n(t,he,e),n(t,yt,e),n(t,Je,e),n(t,ut,e),n(t,Te,e),m(ht,t,e),n(t,Ue,e),n(t,Jt,e),n(t,je,e),m(Tt,t,e),n(t,we,e),m(Ut,t,e),n(t,be,e),n(t,wt,e),fe=!0},p(t,[e]){const el={};e&2&&(el.$$scope={dirty:e,ctx:t}),U.$set(el)},i(t){fe||(d(w.$$.fragment,t),d(f.$$.fragment,t),d(g.$$.fragment,t),d(I.$$.fragment,t),d(W.$$.fragment,t),d(U.$$.fragment,t),d(z.$$.fragment,t),d(R.$$.fragment,t),d(B.$$.fragment,t),d(_.$$.fragment,t),d($.$$.fragment,t),d(H.$$.fragment,t),d(x.$$.fragment,t),d(P.$$.fragment,t),d(tt.$$.fragment,t),d(lt.$$.fragment,t),d(it.$$.fragment,t),d(at.$$.fragment,t),d(Mt.$$.fragment,t),d(mt.$$.fragment,t),d(ht.$$.fragment,t),d(Tt.$$.fragment,t),d(Ut.$$.fragment,t),fe=!0)},o(t){c(w.$$.fragment,t),c(f.$$.fragment,t),c(g.$$.fragment,t),c(I.$$.fragment,t),c(W.$$.fragment,t),c(U.$$.fragment,t),c(z.$$.fragment,t),c(R.$$.fragment,t),c(B.$$.fragment,t),c(_.$$.fragment,t),c($.$$.fragment,t),c(H.$$.fragment,t),c(x.$$.fragment,t),c(P.$$.fragment,t),c(tt.$$.fragment,t),c(lt.$$.fragment,t),c(it.$$.fragment,t),c(at.$$.fragment,t),c(Mt.$$.fragment,t),c(mt.$$.fragment,t),c(ht.$$.fragment,t),c(Tt.$$.fragment,t),c(Ut.$$.fragment,t),fe=!1},d(t){t&&(l(j),l(h),l(jt),l(ft),l(b),l(Ct),l(gt),l(C),l(Zt),l(It),l(Z),l(vt),l(Wt),l(v),l(Vt),l(zt),l(Gt),l(V),l(Rt),l(At),l(G),l(Bt),l(Xt),l(A),l(kt),l(qt),l(X),l(Qt),l(k),l(_t),l(q),l(Ft),l(Q),l(Et),l($t),l(F),l(Nt),l(E),l(Ht),l(Yt),l(N),l(xt),l(St),l(Y),l(Lt),l(Ot),l(S),l(Dt),l(L),l(Pt),l(O),l(Kt),l(D),l(te),l(ee),l(K),l(le),l(ne),l(et),l(ie),l(ae),l(nt),l(se),l(oe),l(Me),l(st),l(pe),l(ot),l(re),l(me),l(pt),l(de),l(rt),l(ce),l(ye),l(dt),l(ue),l(ct),l(he),l(yt),l(Je),l(ut),l(Te),l(Ue),l(Jt),l(je),l(we),l(be),l(wt)),l(u),y(w,t),y(f,t),y(g,t),y(I,t),y(W,t),y(U,t),y(z,t),y(R,t),y(B,t),y(_,t),y($,t),y(H,t),y(x,t),y(P,t),y(tt,t),y(lt,t),y(it,t),y(at,t),y(Mt,t),y(mt,t),y(ht,t),y(Tt,t),y(Ut,t)}}}const ul='{"title":"Optimization","local":"optimization","sections":[{"title":"Post-training","local":"post-training","sections":[{"title":"Weight-only quantization","local":"weight-only-quantization","sections":[{"title":"8-bit","local":"8-bit","sections":[],"depth":4},{"title":"4-bit","local":"4-bit","sections":[],"depth":4}],"depth":3},{"title":"Static quantization","local":"static-quantization","sections":[],"depth":3},{"title":"Hybrid quantization","local":"hybrid-quantization","sections":[],"depth":3}],"depth":2},{"title":"Training-time","local":"training-time","sections":[{"title":"Quantization-Aware Training (QAT)","local":"quantization-aware-training-qat","sections":[],"depth":3},{"title":"Joint Pruning, Quantization and Distillation (JPQD)","local":"joint-pruning-quantization-and-distillation-jpqd","sections":[],"depth":3}],"depth":2},{"title":"Inference with Transformers pipeline","local":"inference-with-transformers-pipeline","sections":[],"depth":2}],"depth":1}';function hl(bt){return al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bl extends ol{constructor(u){super(),Ml(this,u,hl,yl,il,{})}}export{bl as component};
