import{s as na,n as aa,o as sa}from"../chunks/scheduler.65852ee5.js";import{S as ia,i as oa,g as i,s as a,r as m,A as pa,h as o,f as l,c as s,j as ea,u as r,x as p,k as la,y as ma,a as n,v as d,d as M,t as u,w as y}from"../chunks/index.aa74147d.js";import{D as ra,C as h}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as f,E as da}from"../chunks/EditOnGithub.4eda6a96.js";function Ma(en){let c,me,oe,re,w,de,b,Me,g,ln='<em>Authored by: <a href="https://github.com/peremartra" rel="nofollow">Pere Martra</a></em>',ue,j,nn="In this notebook we are introducing how to apply prompt tuning with the PEFT library to a pre-trained model.",ye,T,an='For a complete list of models compatible with PEFT refer to their <a href="https://huggingface.co/docs/peft/main/en/index#supported-methods" rel="nofollow">documentation</a>.',he,J,sn="A short sample of models available to be trained with PEFT includes Bloom, Llama, GPT-J, GPT-2, BERT, and more. Hugging Face is working hard to add more models to the library.",fe,U,ce,$,on="It’s an Additive Fine-Tuning technique for models. This means that we WILL NOT MODIFY ANY WEIGHTS OF THE ORIGINAL MODEL. You might be wondering, how are we going to perform Fine-Tuning then? Well, we will train additional layers that are added to the model. That’s why it’s called an Additive technique.",we,_,pn="Considering it’s an Additive technique and its name is Prompt-Tuning, it seems clear that the layers we’re going to add and train are related to the prompt.",be,C,mn='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/Martra_Figure_5_Prompt_Tuning.jpg" alt="Prompt_Tuning_Diagram"/>',ge,Z,rn="We are creating a type of superprompt by enabling a model to enhance a portion of the prompt with its acquired knowledge. However, that particular section of the prompt cannot be translated into natural language. <strong>It’s as if we’ve mastered expressing ourselves in embeddings and generating highly effective prompts.</strong>",je,G,dn="In each training cycle, the only weights that can be modified to minimize the loss function are those integrated into the prompt.",Te,v,Mn="The primary consequence of this technique is that the number of parameters to train is genuinely small. However, we encounter a second, perhaps more significant consequence, namely that, <strong>since we do not modify the weights of the pretrained model, it does not alter its behavior or forget any information it has previously learned.</strong>",Je,X,un="The training is faster and more cost-effective. Moreover, we can train various models, and during inference time, we only need to load one foundational model along with the new smaller trained models because the weights of the original model have not been altered",Ue,W,$e,k,yn="We are going to train two different models using two datasets, each with just one pre-trained model from the Bloom family. One model will be trained with a dataset of prompts, while the other will use a dataset of inspirational sentences. We will compare the results for the same question from both models before and after training.",_e,B,hn="Additionally, we’ll explore how to load both models with only one copy of the foundational model in memory.",Ce,R,Ze,I,fn="This library contains the Hugging Face implementation of various Fine-Tuning techniques, including Prompt Tuning",Ge,V,ve,x,Xe,F,cn="From the transformers library, we import the necessary classes to instantiate the model and the tokenizer.",We,H,ke,Y,Be,z,wn="Bloom is one of the smallest and smartest models available for training with the PEFT Library using Prompt Tuning. You can choose any model from the Bloom Family, and I encourage you to try at least two of them to observe the differences.",Re,A,bn="I’m opting for the smallest one to minimize training time and avoid memory issues in Colab.",Ie,Q,Ve,N,xe,E,Fe,S,gn="If you want to achieve more varied and original generations, uncomment the parameters: temperature, top_p, and do_sample, in <em>model.generate</em> below",He,P,jn="With the default configuration, the model’s responses remain consistent across calls.",Ye,q,ze,L,Tn="As we want to have two different trained models, I will create two distinct prompts.",Ae,D,Jn="The first model will be trained with a dataset containing prompts, and the second one with a dataset of motivational sentences.",Qe,K,Un="The first model will receive the prompt “I want you to act as a motivational coach.” and the second model will receive “There are two nice things that should matter to you:”",Ne,O,$n="But first, I’m going to collect some results from the model without Fine-Tuning.",Ee,tt,Se,et,_n=`["I want you to act as a motivational coach.  Don't be afraid of being challenged."]
`,Pe,lt,qe,nt,Cn=`['There are two nice things that should matter to you: the price and quality of your product.']
`,Le,at,Zn="Both answers are more or less correct. Any of the Bloom models is pre-trained and can generate sentences accurately and sensibly. Let’s see if, after training, the responses are either equal or more accurately generated.",De,st,Ke,it,Gn="The Datasets useds are:",Oe,ot,vn='<li><a href="https://huggingface.co/datasets/fka/awesome-chatgpt-prompts" rel="nofollow">https://huggingface.co/datasets/fka/awesome-chatgpt-prompts</a></li> <li><a href="https://huggingface.co/datasets/Abirate/english_quotes" rel="nofollow">https://huggingface.co/datasets/Abirate/english_quotes</a></li>',tl,pt,el,mt,ll,rt,nl,dt,al,Mt,Xn=`&#123;'act': ['Linux Terminal'], 'prompt': ['I want you to act as a linux terminal. I will type commands and you will reply with what the terminal should show. I want you to only reply with the terminal output inside one unique code block, and nothing else. do not write explanations. do not type commands unless I instruct you to do so. when i need to tell you something in english, i will do so by putting text inside curly brackets &#123;like this}. my first command is pwd'], 'input_ids': [[44, 4026, 1152, 427, 1769, 661, 267, 104105, 28434, 17, 473, 2152, 4105, 49123, 530, 1152, 2152, 57502, 1002, 3595, 368, 28434, 3403, 6460, 17, 473, 4026, 1152, 427, 3804, 57502, 1002, 368, 28434, 10014, 14652, 2592, 19826, 4400, 10973, 15, 530, 16915, 4384, 17, 727, 1130, 11602, 184637, 17, 727, 1130, 4105, 49123, 35262, 473, 32247, 1152, 427, 727, 1427, 17, 3262, 707, 3423, 427, 13485, 1152, 7747, 361, 170205, 15, 707, 2152, 727, 1427, 1331, 55385, 5484, 14652, 6291, 999, 117805, 731, 29726, 1119, 96, 17, 2670, 3968, 9361, 632, 269, 42512]], 'attention_mask': [[1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]]}
`,sl,ut,il,yt,ol,ht,pl,ft,ml,ct,Wn=`API docs:
<a href="https://huggingface.co/docs/peft/main/en/package_reference/tuners#peft.PromptTuningConfig" rel="nofollow">https://huggingface.co/docs/peft/main/en/package_reference/tuners#peft.PromptTuningConfig</a>`,rl,wt,kn="We can use the same configuration for both models to be trained.",dl,bt,Ml,gt,ul,jt,Bn="We will create two identical prompt tuning models using the same pre-trained model and the same config.",yl,Tt,hl,Jt,Rn=`trainable params: 4,096 || all params: 559,218,688 || trainable%: 0.0007324504863471229
None
`,fl,Ut,cl,$t,In=`trainable params: 4,096 || all params: 559,218,688 || trainable%: 0.0007324504863471229
None
`,wl,_t,Vn="<strong>That’s amazing: did you see the reduction in trainable parameters? We are going to train a 0.001% of the paramaters available.</strong>",bl,Ct,xn="Now we are going to create the training arguments, and we will use the same configuration in both trainings.",gl,Zt,jl,Gt,Tl,vt,Fn="We need to indicate the directory containing the model when creating the TrainingArguments.",Jl,Xt,Ul,Wt,$l,kt,Hn="We will create the trainer Object, one for each model to train.",_l,Bt,Cl,Rt,Zl,It,Gl,Vt,Yn="In less than 10 minutes (CPU time in a M1 Pro) we trained 2 different models, with two different missions with a same foundational model as a base.",vl,xt,Xl,Ft,zn="We are going to save the models. These models are ready to be used, as long as we have the pre-trained model from which they were created in memory.",Wl,Ht,kl,Yt,Bl,zt,An="You can load the model from the path that you have saved to before, and ask the model to generate text based on our input before!",Rl,At,Il,Qt,Vl,Nt,Qn=`['I want you to act as a motivational coach.  You will be helping students learn how they can improve their performance in the classroom and at school.']
`,xl,Et,Nn="If we compare both answers something changed.",Fl,St,En="<li><strong><em>Pretrained Model:</em></strong> <em>I want you to act as a motivational coach.  Don’t be afraid of being challenged.</em></li> <li><strong><em>Fine-Tuned Model:</em></strong> <em>I want you to act as a motivational coach.  You can use this method if you’re feeling anxious about your.</em></li>",Hl,Pt,Sn="We have to keep in mind that we have only trained the model for a few minutes, but they have been enough to obtain a response closer to what we were looking for.",Yl,qt,zl,Lt,Al,Dt,Pn=`['There are two nice things that should matter to you: the weather and your health.']
`,Ql,Kt,qn="With the second model we have a similar result.",Nl,Ot,Ln="<li><strong>Pretrained Model:</strong> <em>There are two nice things that should matter to you: the price and quality of your product.</em></li> <li><strong>Fine-Tuned Model:</strong> <em>There are two nice things that should matter to you: the weather and your health.</em></li>",El,te,Sl,ee,Dn="Prompt Tuning is an amazing technique that can save us hours of training and a significant amount of money. In the notebook, we have trained two models in just a few minutes, and we can have both models in memory, providing service to different clients.",Pl,le,Kn="If you want to try different combinations and models, the notebook is ready to use another model from the Bloom family.",ql,ne,On="You can change the number of epochs to train, the number of virtual tokens, and the model in the third cell. However, there are many configurations to change. If you’re looking for a good exercise, you can replace the random initialization of the virtual tokens with a fixed value.",Ll,ae,ta="<em>The responses of the Fine-Tuned models may vary every time we train them. I’ve pasted the results of one of my trainings, but the actual results may differ.</em>",Dl,se,Kl,ie,Ol,pe,tn;return w=new ra({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/fix-broken-link/notebooks/en/prompt_tuning_peft.ipynb"}]}}),b=new f({props:{title:"Prompt Tuning With PEFT.",local:"prompt-tuning-with-peft",headingTag:"h1"}}),U=new f({props:{title:"Brief introduction to Prompt Tuning.",local:"brief-introduction-to-prompt-tuning",headingTag:"h2"}}),W=new f({props:{title:"What are we going to do in the notebook?",local:"what-are-we-going-to-do-in-the-notebook",headingTag:"h2"}}),R=new f({props:{title:"Loading the PEFT Library",local:"loading-the-peft-library",headingTag:"h2"}}),V=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHBlZnQlM0QlM0QwLjguMg==",highlighted:'!pip install -q peft==<span class="hljs-number">0.8</span><span class="hljs-number">.2</span>',wrap:!1}}),x=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTNEJTNEMi4xNC41",highlighted:'!pip install -q datasets==<span class="hljs-number">2.14</span><span class="hljs-number">.5</span>',wrap:!1}}),H=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplcg==",highlighted:'<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer',wrap:!1}}),Y=new f({props:{title:"Loading the model and the tokenizers.",local:"loading-the-model-and-the-tokenizers",headingTag:"h3"}}),Q=new h({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiUwQSUyMyUyMG1vZGVsX25hbWUlM0QlMjJiaWdzY2llbmNlJTJGYmxvb20tMWIxJTIyJTBBTlVNX1ZJUlRVQUxfVE9LRU5TJTIwJTNEJTIwNCUwQU5VTV9FUE9DSFMlMjAlM0QlMjA2",highlighted:`model_name = <span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>
<span class="hljs-comment"># model_name=&quot;bigscience/bloom-1b1&quot;</span>
NUM_VIRTUAL_TOKENS = <span class="hljs-number">4</span>
NUM_EPOCHS = <span class="hljs-number">6</span>`,wrap:!1}}),N=new h({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEFmb3VuZGF0aW9uYWxfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`tokenizer = AutoTokenizer.from_pretrained(model_name)
foundational_model = AutoModelForCausalLM.from_pretrained(model_name, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),E=new f({props:{title:"Inference with the pre trained bloom model",local:"inference-with-the-pre-trained-bloom-model",headingTag:"h2"}}),q=new h({props:{code:"JTIzJTIwdGhpcyUyMGZ1bmN0aW9uJTIwcmV0dXJucyUyMHRoZSUyMG91dHB1dHMlMjBmcm9tJTIwdGhlJTIwbW9kZWwlMjByZWNlaXZlZCUyQyUyMGFuZCUyMGlucHV0cy4lMEFkZWYlMjBnZXRfb3V0cHV0cyhtb2RlbCUyQyUyMGlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAwKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9pZHMlM0RpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUzRGlucHV0cyU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0RtYXhfbmV3X3Rva2VucyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHRlbXBlcmF0dXJlJTNEMC4yJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwdG9wX3AlM0QwLjk1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcGV0aXRpb25fcGVuYWx0eSUzRDEuNSUyQyUyMCUyMCUyMyUyMEF2b2lkJTIwcmVwZXRpdGlvbi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlYXJseV9zdG9wcGluZyUzRFRydWUlMkMlMjAlMjAlMjMlMjBUaGUlMjBtb2RlbCUyMGNhbiUyMHN0b3AlMjBiZWZvcmUlMjByZWFjaCUyMHRoZSUyMG1heF9sZW5ndGglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZW9zX3Rva2VuX2lkJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dHM=",highlighted:`<span class="hljs-comment"># this function returns the outputs from the model received, and inputs.</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_outputs</span>(<span class="hljs-params">model, inputs, max_new_tokens=<span class="hljs-number">100</span></span>):
    outputs = model.generate(
        input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
        attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
        max_new_tokens=max_new_tokens,
        <span class="hljs-comment"># temperature=0.2,</span>
        <span class="hljs-comment"># top_p=0.95,</span>
        <span class="hljs-comment"># do_sample=True,</span>
        repetition_penalty=<span class="hljs-number">1.5</span>,  <span class="hljs-comment"># Avoid repetition.</span>
        early_stopping=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># The model can stop before reach the max_length</span>
        eos_token_id=tokenizer.eos_token_id,
    )
    <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),tt=new h({props:{code:"aW5wdXRfcHJvbXB0JTIwJTNEJTIwdG9rZW5pemVyKCUyMkklMjB3YW50JTIweW91JTIwdG8lMjBhY3QlMjBhcyUyMGElMjBtb3RpdmF0aW9uYWwlMjBjb2FjaC4lMjAlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWZvdW5kYXRpb25hbF9vdXRwdXRzX3Byb21wdCUyMCUzRCUyMGdldF9vdXRwdXRzKGZvdW5kYXRpb25hbF9tb2RlbCUyQyUyMGlucHV0X3Byb21wdCUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShmb3VuZGF0aW9uYWxfb3V0cHV0c19wcm9tcHQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = tokenizer(<span class="hljs-string">&quot;I want you to act as a motivational coach. &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>foundational_outputs_prompt = get_outputs(foundational_model, input_prompt, max_new_tokens=<span class="hljs-number">50</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(foundational_outputs_prompt, skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),lt=new h({props:{code:"aW5wdXRfc2VudGVuY2VzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZXJlJTIwYXJlJTIwdHdvJTIwbmljZSUyMHRoaW5ncyUyMHRoYXQlMjBzaG91bGQlMjBtYXR0ZXIlMjB0byUyMHlvdSUzQSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZm91bmRhdGlvbmFsX291dHB1dHNfc2VudGVuY2UlMjAlM0QlMjBnZXRfb3V0cHV0cyhmb3VuZGF0aW9uYWxfbW9kZWwlMkMlMjBpbnB1dF9zZW50ZW5jZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUwKSUwQSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoZm91bmRhdGlvbmFsX291dHB1dHNfc2VudGVuY2UlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>input_sentences = tokenizer(<span class="hljs-string">&quot;There are two nice things that should matter to you:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>foundational_outputs_sentence = get_outputs(foundational_model, input_sentences, max_new_tokens=<span class="hljs-number">50</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(foundational_outputs_sentence, skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),st=new f({props:{title:"Preparing the Datasets",local:"preparing-the-datasets",headingTag:"h2"}}),pt=new h({props:{code:"aW1wb3J0JTIwb3MlMEElMEElMjMlMjBvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIy",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># os.environ[&quot;TOKENIZERS_PARALLELISM&quot;] = &quot;false&quot;</span>`,wrap:!1}}),mt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldF9wcm9tcHQlMjAlM0QlMjAlMjJma2ElMkZhd2Vzb21lLWNoYXRncHQtcHJvbXB0cyUyMiUwQSUwQSUyMyUyMENyZWF0ZSUyMHRoZSUyMERhdGFzZXQlMjB0byUyMGNyZWF0ZSUyMHByb21wdHMuJTBBZGF0YV9wcm9tcHQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9wcm9tcHQpJTBBZGF0YV9wcm9tcHQlMjAlM0QlMjBkYXRhX3Byb21wdC5tYXAobGFtYmRhJTIwc2FtcGxlcyUzQSUyMHRva2VuaXplcihzYW1wbGVzJTVCJTIycHJvbXB0JTIyJTVEKSUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQXRyYWluX3NhbXBsZV9wcm9tcHQlMjAlM0QlMjBkYXRhX3Byb21wdCU1QiUyMnRyYWluJTIyJTVELnNlbGVjdChyYW5nZSg1MCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset_prompt = <span class="hljs-string">&quot;fka/awesome-chatgpt-prompts&quot;</span>

<span class="hljs-comment"># Create the Dataset to create prompts.</span>
data_prompt = load_dataset(dataset_prompt)
data_prompt = data_prompt.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> samples: tokenizer(samples[<span class="hljs-string">&quot;prompt&quot;</span>]), batched=<span class="hljs-literal">True</span>)
train_sample_prompt = data_prompt[<span class="hljs-string">&quot;train&quot;</span>].select(<span class="hljs-built_in">range</span>(<span class="hljs-number">50</span>))`,wrap:!1}}),rt=new h({props:{code:"ZGlzcGxheSh0cmFpbl9zYW1wbGVfcHJvbXB0KQ==",highlighted:"display(train_sample_prompt)",wrap:!1}}),dt=new h({props:{code:"cHJpbnQodHJhaW5fc2FtcGxlX3Byb21wdCU1QiUzQTElNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(train_sample_prompt[:<span class="hljs-number">1</span>])',wrap:!1}}),ut=new h({props:{code:"ZGF0YXNldF9zZW50ZW5jZXMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyQWJpcmF0ZSUyRmVuZ2xpc2hfcXVvdGVzJTIyKSUwQSUwQWRhdGFfc2VudGVuY2VzJTIwJTNEJTIwZGF0YXNldF9zZW50ZW5jZXMubWFwKGxhbWJkYSUyMHNhbXBsZXMlM0ElMjB0b2tlbml6ZXIoc2FtcGxlcyU1QiUyMnF1b3RlJTIyJTVEKSUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQXRyYWluX3NhbXBsZV9zZW50ZW5jZXMlMjAlM0QlMjBkYXRhX3NlbnRlbmNlcyU1QiUyMnRyYWluJTIyJTVELnNlbGVjdChyYW5nZSgyNSkpJTBBdHJhaW5fc2FtcGxlX3NlbnRlbmNlcyUyMCUzRCUyMHRyYWluX3NhbXBsZV9zZW50ZW5jZXMucmVtb3ZlX2NvbHVtbnMoJTVCJTIyYXV0aG9yJTIyJTJDJTIwJTIydGFncyUyMiU1RCk=",highlighted:`dataset_sentences = load_dataset(<span class="hljs-string">&quot;Abirate/english_quotes&quot;</span>)

data_sentences = dataset_sentences.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> samples: tokenizer(samples[<span class="hljs-string">&quot;quote&quot;</span>]), batched=<span class="hljs-literal">True</span>)
train_sample_sentences = data_sentences[<span class="hljs-string">&quot;train&quot;</span>].select(<span class="hljs-built_in">range</span>(<span class="hljs-number">25</span>))
train_sample_sentences = train_sample_sentences.remove_columns([<span class="hljs-string">&quot;author&quot;</span>, <span class="hljs-string">&quot;tags&quot;</span>])`,wrap:!1}}),yt=new h({props:{code:"ZGlzcGxheSh0cmFpbl9zYW1wbGVfc2VudGVuY2VzKQ==",highlighted:"display(train_sample_sentences)",wrap:!1}}),ht=new f({props:{title:"Fine-Tuning.",local:"fine-tuning",headingTag:"h2"}}),ft=new f({props:{title:"PEFT configurations",local:"peft-configurations",headingTag:"h3"}}),bt=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUyQyUyMFByb21wdFR1bmluZ0NvbmZpZyUyQyUyMFRhc2tUeXBlJTJDJTIwUHJvbXB0VHVuaW5nSW5pdCUwQSUwQWdlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwUHJvbXB0VHVuaW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRFRhc2tUeXBlLkNBVVNBTF9MTSUyQyUyMCUyMCUyMyUyMFRoaXMlMjB0eXBlJTIwaW5kaWNhdGVzJTIwdGhlJTIwbW9kZWwlMjB3aWxsJTIwZ2VuZXJhdGUlMjB0ZXh0LiUwQSUyMCUyMCUyMCUyMHByb21wdF90dW5pbmdfaW5pdCUzRFByb21wdFR1bmluZ0luaXQuUkFORE9NJTJDJTIwJTIwJTIzJTIwVGhlJTIwYWRkZWQlMjB2aXJ0dWFsJTIwdG9rZW5zJTIwYXJlJTIwaW5pdGlhbGl6YWQlMjB3aXRoJTIwcmFuZG9tJTIwbnVtYmVycyUwQSUyMCUyMCUyMCUyMG51bV92aXJ0dWFsX3Rva2VucyUzRE5VTV9WSVJUVUFMX1RPS0VOUyUyQyUyMCUyMCUyMyUyME51bWJlciUyMG9mJTIwdmlydHVhbCUyMHRva2VucyUyMHRvJTIwYmUlMjBhZGRlZCUyMGFuZCUyMHRyYWluZWQuJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyX25hbWVfb3JfcGF0aCUzRG1vZGVsX25hbWUlMkMlMjAlMjAlMjMlMjBUaGUlMjBwcmUtdHJhaW5lZCUyMG1vZGVsLiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, PromptTuningConfig, TaskType, PromptTuningInit

generation_config = PromptTuningConfig(
    task_type=TaskType.CAUSAL_LM,  <span class="hljs-comment"># This type indicates the model will generate text.</span>
    prompt_tuning_init=PromptTuningInit.RANDOM,  <span class="hljs-comment"># The added virtual tokens are initializad with random numbers</span>
    num_virtual_tokens=NUM_VIRTUAL_TOKENS,  <span class="hljs-comment"># Number of virtual tokens to be added and trained.</span>
    tokenizer_name_or_path=model_name,  <span class="hljs-comment"># The pre-trained model.</span>
)`,wrap:!1}}),gt=new f({props:{title:"Creating two Prompt Tuning Models.",local:"creating-two-prompt-tuning-models",headingTag:"h3"}}),Tt=new h({props:{code:"cGVmdF9tb2RlbF9wcm9tcHQlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChmb3VuZGF0aW9uYWxfbW9kZWwlMkMlMjBnZW5lcmF0aW9uX2NvbmZpZyklMEFwcmludChwZWZ0X21vZGVsX3Byb21wdC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>peft_model_prompt = get_peft_model(foundational_model, generation_config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(peft_model_prompt.print_trainable_parameters())`,wrap:!1}}),Ut=new h({props:{code:"cGVmdF9tb2RlbF9zZW50ZW5jZXMlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChmb3VuZGF0aW9uYWxfbW9kZWwlMkMlMjBnZW5lcmF0aW9uX2NvbmZpZyklMEFwcmludChwZWZ0X21vZGVsX3NlbnRlbmNlcy5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>peft_model_sentences = get_peft_model(foundational_model, generation_config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(peft_model_sentences.print_trainable_parameters())`,wrap:!1}}),Zt=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBJTBBZGVmJTIwY3JlYXRlX3RyYWluaW5nX2FyZ3VtZW50cyhwYXRoJTJDJTIwbGVhcm5pbmdfcmF0ZSUzRDAuMDAzNSUyQyUyMGVwb2NocyUzRDYpJTNBJTBBJTIwJTIwJTIwJTIwdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0RwYXRoJTJDJTIwJTIwJTIzJTIwV2hlcmUlMjB0aGUlMjBtb2RlbCUyMHByZWRpY3Rpb25zJTIwYW5kJTIwY2hlY2twb2ludHMlMjB3aWxsJTIwYmUlMjB3cml0dGVuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdXNlX2NwdSUzRFRydWUlMkMlMjAlMjAlMjMlMjBUaGlzJTIwaXMlMjBuZWNlc3NhcnklMjBmb3IlMjBDUFUlMjBjbHVzdGVycy4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdXRvX2ZpbmRfYmF0Y2hfc2l6ZSUzRFRydWUlMkMlMjAlMjAlMjMlMjBGaW5kJTIwYSUyMHN1aXRhYmxlJTIwYmF0Y2glMjBzaXplJTIwdGhhdCUyMHdpbGwlMjBmaXQlMjBpbnRvJTIwbWVtb3J5JTIwYXV0b21hdGljYWxseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0RsZWFybmluZ19yYXRlJTJDJTIwJTIwJTIzJTIwSGlnaGVyJTIwbGVhcm5pbmclMjByYXRlJTIwdGhhbiUyMGZ1bGwlMjBGaW5lLVR1bmluZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0RlcG9jaHMlMkMlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhaW5pbmdfYXJncw==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_training_arguments</span>(<span class="hljs-params">path, learning_rate=<span class="hljs-number">0.0035</span>, epochs=<span class="hljs-number">6</span></span>):
    training_args = TrainingArguments(
        output_dir=path,  <span class="hljs-comment"># Where the model predictions and checkpoints will be written</span>
        use_cpu=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># This is necessary for CPU clusters.</span>
        auto_find_batch_size=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Find a suitable batch size that will fit into memory automatically</span>
        learning_rate=learning_rate,  <span class="hljs-comment"># Higher learning rate than full Fine-Tuning</span>
        num_train_epochs=epochs,
    )
    <span class="hljs-keyword">return</span> training_args`,wrap:!1}}),Gt=new h({props:{code:"aW1wb3J0JTIwb3MlMEElMEF3b3JraW5nX2RpciUyMCUzRCUyMCUyMi4lMkYlMjIlMEElMEElMjMlMjBJcyUyMGJlc3QlMjB0byUyMHN0b3JlJTIwdGhlJTIwbW9kZWxzJTIwaW4lMjBzZXBhcmF0ZSUyMGZvbGRlcnMuJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwZGlyZWN0b3JpZXMlMjB3aGVyZSUyMHRvJTIwc3RvcmUlMjB0aGUlMjBtb2RlbHMuJTBBb3V0cHV0X2RpcmVjdG9yeV9wcm9tcHQlMjAlM0QlMjBvcy5wYXRoLmpvaW4od29ya2luZ19kaXIlMkMlMjAlMjJwZWZ0X291dHB1dHNfcHJvbXB0JTIyKSUwQW91dHB1dF9kaXJlY3Rvcnlfc2VudGVuY2VzJTIwJTNEJTIwb3MucGF0aC5qb2luKHdvcmtpbmdfZGlyJTJDJTIwJTIycGVmdF9vdXRwdXRzX3NlbnRlbmNlcyUyMiklMEElMEElMjMlMjBKdXN0JTIwY3JlYXRpbmclMjB0aGUlMjBkaXJlY3RvcmlzJTIwaWYlMjBub3QlMjBleGlzdC4lMEFpZiUyMG5vdCUyMG9zLnBhdGguZXhpc3RzKHdvcmtpbmdfZGlyKSUzQSUwQSUyMCUyMCUyMCUyMG9zLm1rZGlyKHdvcmtpbmdfZGlyKSUwQWlmJTIwbm90JTIwb3MucGF0aC5leGlzdHMob3V0cHV0X2RpcmVjdG9yeV9wcm9tcHQpJTNBJTBBJTIwJTIwJTIwJTIwb3MubWtkaXIob3V0cHV0X2RpcmVjdG9yeV9wcm9tcHQpJTBBaWYlMjBub3QlMjBvcy5wYXRoLmV4aXN0cyhvdXRwdXRfZGlyZWN0b3J5X3NlbnRlbmNlcyklM0ElMEElMjAlMjAlMjAlMjBvcy5ta2RpcihvdXRwdXRfZGlyZWN0b3J5X3NlbnRlbmNlcyk=",highlighted:`<span class="hljs-keyword">import</span> os

working_dir = <span class="hljs-string">&quot;./&quot;</span>

<span class="hljs-comment"># Is best to store the models in separate folders.</span>
<span class="hljs-comment"># Create the name of the directories where to store the models.</span>
output_directory_prompt = os.path.join(working_dir, <span class="hljs-string">&quot;peft_outputs_prompt&quot;</span>)
output_directory_sentences = os.path.join(working_dir, <span class="hljs-string">&quot;peft_outputs_sentences&quot;</span>)

<span class="hljs-comment"># Just creating the directoris if not exist.</span>
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(working_dir):
    os.mkdir(working_dir)
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(output_directory_prompt):
    os.mkdir(output_directory_prompt)
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(output_directory_sentences):
    os.mkdir(output_directory_sentences)`,wrap:!1}}),Xt=new h({props:{code:"dHJhaW5pbmdfYXJnc19wcm9tcHQlMjAlM0QlMjBjcmVhdGVfdHJhaW5pbmdfYXJndW1lbnRzKG91dHB1dF9kaXJlY3RvcnlfcHJvbXB0JTJDJTIwMC4wMDMlMkMlMjBOVU1fRVBPQ0hTKSUwQXRyYWluaW5nX2FyZ3Nfc2VudGVuY2VzJTIwJTNEJTIwY3JlYXRlX3RyYWluaW5nX2FyZ3VtZW50cyhvdXRwdXRfZGlyZWN0b3J5X3NlbnRlbmNlcyUyQyUyMDAuMDAzJTJDJTIwTlVNX0VQT0NIUyk=",highlighted:`training_args_prompt = create_training_arguments(output_directory_prompt, <span class="hljs-number">0.003</span>, NUM_EPOCHS)
training_args_sentences = create_training_arguments(output_directory_sentences, <span class="hljs-number">0.003</span>, NUM_EPOCHS)`,wrap:!1}}),Wt=new f({props:{title:"Train",local:"train",headingTag:"h2"}}),Bt=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMkMlMjBEYXRhQ29sbGF0b3JGb3JMYW5ndWFnZU1vZGVsaW5nJTBBJTBBJTBBZGVmJTIwY3JlYXRlX3RyYWluZXIobW9kZWwlMkMlMjB0cmFpbmluZ19hcmdzJTJDJTIwdHJhaW5fZGF0YXNldCklM0ElMEElMjAlMjAlMjAlMjB0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTIwJTIwJTIzJTIwV2UlMjBwYXNzJTIwaW4lMjB0aGUlMjBQRUZUJTIwdmVyc2lvbiUyMG9mJTIwdGhlJTIwZm91bmRhdGlvbiUyMG1vZGVsJTJDJTIwYmxvb216LTU2ME0lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMCUyMCUyMyUyMFRoZSUyMGFyZ3MlMjBmb3IlMjB0aGUlMjB0cmFpbmluZy4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUyMCUyMCUyMyUyMFRoZSUyMGRhdGFzZXQlMjB1c2VkJTIwdG8lMjB0eXJhaW4lMjB0aGUlMjBtb2RlbC4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNERGF0YUNvbGxhdG9yRm9yTGFuZ3VhZ2VNb2RlbGluZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMjAlMjAlMjMlMjBtbG0lM0RGYWxzZSUyMGluZGljYXRlcyUyMG5vdCUyMHRvJTIwdXNlJTIwbWFza2VkJTIwbGFuZ3VhZ2UlMjBtb2RlbGluZyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0cmFpbmVy",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer, DataCollatorForLanguageModeling


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_trainer</span>(<span class="hljs-params">model, training_args, train_dataset</span>):
    trainer = Trainer(
        model=model,  <span class="hljs-comment"># We pass in the PEFT version of the foundation model, bloomz-560M</span>
        args=training_args,  <span class="hljs-comment"># The args for the training.</span>
        train_dataset=train_dataset,  <span class="hljs-comment"># The dataset used to tyrain the model.</span>
        data_collator=DataCollatorForLanguageModeling(
            tokenizer, mlm=<span class="hljs-literal">False</span>
        ),  <span class="hljs-comment"># mlm=False indicates not to use masked language modeling</span>
    )
    <span class="hljs-keyword">return</span> trainer`,wrap:!1}}),Rt=new h({props:{code:"JTIzJTIwVHJhaW5pbmclMjBmaXJzdCUyMG1vZGVsLiUwQXRyYWluZXJfcHJvbXB0JTIwJTNEJTIwY3JlYXRlX3RyYWluZXIocGVmdF9tb2RlbF9wcm9tcHQlMkMlMjB0cmFpbmluZ19hcmdzX3Byb21wdCUyQyUyMHRyYWluX3NhbXBsZV9wcm9tcHQpJTBBdHJhaW5lcl9wcm9tcHQudHJhaW4oKQ==",highlighted:`<span class="hljs-comment"># Training first model.</span>
trainer_prompt = create_trainer(peft_model_prompt, training_args_prompt, train_sample_prompt)
trainer_prompt.train()`,wrap:!1}}),It=new h({props:{code:"JTIzJTIwVHJhaW5pbmclMjBzZWNvbmQlMjBtb2RlbC4lMEF0cmFpbmVyX3NlbnRlbmNlcyUyMCUzRCUyMGNyZWF0ZV90cmFpbmVyKHBlZnRfbW9kZWxfc2VudGVuY2VzJTJDJTIwdHJhaW5pbmdfYXJnc19zZW50ZW5jZXMlMkMlMjB0cmFpbl9zYW1wbGVfc2VudGVuY2VzKSUwQXRyYWluZXJfc2VudGVuY2VzLnRyYWluKCk=",highlighted:`<span class="hljs-comment"># Training second model.</span>
trainer_sentences = create_trainer(peft_model_sentences, training_args_sentences, train_sample_sentences)
trainer_sentences.train()`,wrap:!1}}),xt=new f({props:{title:"Save models",local:"save-models",headingTag:"h2"}}),Ht=new h({props:{code:"dHJhaW5lcl9wcm9tcHQubW9kZWwuc2F2ZV9wcmV0cmFpbmVkKG91dHB1dF9kaXJlY3RvcnlfcHJvbXB0KSUwQXRyYWluZXJfc2VudGVuY2VzLm1vZGVsLnNhdmVfcHJldHJhaW5lZChvdXRwdXRfZGlyZWN0b3J5X3NlbnRlbmNlcyk=",highlighted:`trainer_prompt.model.save_pretrained(output_directory_prompt)
trainer_sentences.model.save_pretrained(output_directory_sentences)`,wrap:!1}}),Yt=new f({props:{title:"Inference",local:"inference",headingTag:"h2"}}),At=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFsb2FkZWRfbW9kZWxfcHJvbXB0JTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBmb3VuZGF0aW9uYWxfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyZWN0b3J5X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMGRldmljZV9tYXAlM0QnYXV0byclMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmFibGUlM0RGYWxzZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

loaded_model_prompt = PeftModel.from_pretrained(
    foundational_model,
    output_directory_prompt,
    <span class="hljs-comment"># device_map=&#x27;auto&#x27;,</span>
    is_trainable=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),Qt=new h({props:{code:"bG9hZGVkX21vZGVsX3Byb21wdF9vdXRwdXRzJTIwJTNEJTIwZ2V0X291dHB1dHMobG9hZGVkX21vZGVsX3Byb21wdCUyQyUyMGlucHV0X3Byb21wdCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGxvYWRlZF9tb2RlbF9wcm9tcHRfb3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>loaded_model_prompt_outputs = get_outputs(loaded_model_prompt, input_prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(loaded_model_prompt_outputs, skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),qt=new h({props:{code:"bG9hZGVkX21vZGVsX3Byb21wdC5sb2FkX2FkYXB0ZXIob3V0cHV0X2RpcmVjdG9yeV9zZW50ZW5jZXMlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJxdW90ZXMlMjIpJTBBbG9hZGVkX21vZGVsX3Byb21wdC5zZXRfYWRhcHRlciglMjJxdW90ZXMlMjIp",highlighted:`loaded_model_prompt.load_adapter(output_directory_sentences, adapter_name=<span class="hljs-string">&quot;quotes&quot;</span>)
loaded_model_prompt.set_adapter(<span class="hljs-string">&quot;quotes&quot;</span>)`,wrap:!1}}),Lt=new h({props:{code:"bG9hZGVkX21vZGVsX3NlbnRlbmNlc19vdXRwdXRzJTIwJTNEJTIwZ2V0X291dHB1dHMobG9hZGVkX21vZGVsX3Byb21wdCUyQyUyMGlucHV0X3NlbnRlbmNlcyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGxvYWRlZF9tb2RlbF9zZW50ZW5jZXNfb3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>loaded_model_sentences_outputs = get_outputs(loaded_model_prompt, input_sentences)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(loaded_model_sentences_outputs, skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),te=new f({props:{title:"Conclusion",local:"conclusion",headingTag:"h1"}}),se=new h({props:{code:"",highlighted:"",wrap:!1}}),ie=new da({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/prompt_tuning_peft.md"}}),{c(){c=i("meta"),me=a(),oe=i("p"),re=a(),m(w.$$.fragment),de=a(),m(b.$$.fragment),Me=a(),g=i("p"),g.innerHTML=ln,ue=a(),j=i("p"),j.textContent=nn,ye=a(),T=i("p"),T.innerHTML=an,he=a(),J=i("p"),J.textContent=sn,fe=a(),m(U.$$.fragment),ce=a(),$=i("p"),$.textContent=on,we=a(),_=i("p"),_.textContent=pn,be=a(),C=i("p"),C.innerHTML=mn,ge=a(),Z=i("p"),Z.innerHTML=rn,je=a(),G=i("p"),G.textContent=dn,Te=a(),v=i("p"),v.innerHTML=Mn,Je=a(),X=i("p"),X.textContent=un,Ue=a(),m(W.$$.fragment),$e=a(),k=i("p"),k.textContent=yn,_e=a(),B=i("p"),B.textContent=hn,Ce=a(),m(R.$$.fragment),Ze=a(),I=i("p"),I.textContent=fn,Ge=a(),m(V.$$.fragment),ve=a(),m(x.$$.fragment),Xe=a(),F=i("p"),F.textContent=cn,We=a(),m(H.$$.fragment),ke=a(),m(Y.$$.fragment),Be=a(),z=i("p"),z.textContent=wn,Re=a(),A=i("p"),A.textContent=bn,Ie=a(),m(Q.$$.fragment),Ve=a(),m(N.$$.fragment),xe=a(),m(E.$$.fragment),Fe=a(),S=i("p"),S.innerHTML=gn,He=a(),P=i("p"),P.textContent=jn,Ye=a(),m(q.$$.fragment),ze=a(),L=i("p"),L.textContent=Tn,Ae=a(),D=i("p"),D.textContent=Jn,Qe=a(),K=i("p"),K.textContent=Un,Ne=a(),O=i("p"),O.textContent=$n,Ee=a(),m(tt.$$.fragment),Se=a(),et=i("pre"),et.textContent=_n,Pe=a(),m(lt.$$.fragment),qe=a(),nt=i("pre"),nt.textContent=Cn,Le=a(),at=i("p"),at.textContent=Zn,De=a(),m(st.$$.fragment),Ke=a(),it=i("p"),it.textContent=Gn,Oe=a(),ot=i("ul"),ot.innerHTML=vn,tl=a(),m(pt.$$.fragment),el=a(),m(mt.$$.fragment),ll=a(),m(rt.$$.fragment),nl=a(),m(dt.$$.fragment),al=a(),Mt=i("pre"),Mt.textContent=Xn,sl=a(),m(ut.$$.fragment),il=a(),m(yt.$$.fragment),ol=a(),m(ht.$$.fragment),pl=a(),m(ft.$$.fragment),ml=a(),ct=i("p"),ct.innerHTML=Wn,rl=a(),wt=i("p"),wt.textContent=kn,dl=a(),m(bt.$$.fragment),Ml=a(),m(gt.$$.fragment),ul=a(),jt=i("p"),jt.textContent=Bn,yl=a(),m(Tt.$$.fragment),hl=a(),Jt=i("pre"),Jt.textContent=Rn,fl=a(),m(Ut.$$.fragment),cl=a(),$t=i("pre"),$t.textContent=In,wl=a(),_t=i("p"),_t.innerHTML=Vn,bl=a(),Ct=i("p"),Ct.textContent=xn,gl=a(),m(Zt.$$.fragment),jl=a(),m(Gt.$$.fragment),Tl=a(),vt=i("p"),vt.textContent=Fn,Jl=a(),m(Xt.$$.fragment),Ul=a(),m(Wt.$$.fragment),$l=a(),kt=i("p"),kt.textContent=Hn,_l=a(),m(Bt.$$.fragment),Cl=a(),m(Rt.$$.fragment),Zl=a(),m(It.$$.fragment),Gl=a(),Vt=i("p"),Vt.textContent=Yn,vl=a(),m(xt.$$.fragment),Xl=a(),Ft=i("p"),Ft.textContent=zn,Wl=a(),m(Ht.$$.fragment),kl=a(),m(Yt.$$.fragment),Bl=a(),zt=i("p"),zt.textContent=An,Rl=a(),m(At.$$.fragment),Il=a(),m(Qt.$$.fragment),Vl=a(),Nt=i("pre"),Nt.textContent=Qn,xl=a(),Et=i("p"),Et.textContent=Nn,Fl=a(),St=i("ul"),St.innerHTML=En,Hl=a(),Pt=i("p"),Pt.textContent=Sn,Yl=a(),m(qt.$$.fragment),zl=a(),m(Lt.$$.fragment),Al=a(),Dt=i("pre"),Dt.textContent=Pn,Ql=a(),Kt=i("p"),Kt.textContent=qn,Nl=a(),Ot=i("ul"),Ot.innerHTML=Ln,El=a(),m(te.$$.fragment),Sl=a(),ee=i("p"),ee.textContent=Dn,Pl=a(),le=i("p"),le.textContent=Kn,ql=a(),ne=i("p"),ne.textContent=On,Ll=a(),ae=i("p"),ae.innerHTML=ta,Dl=a(),m(se.$$.fragment),Kl=a(),m(ie.$$.fragment),Ol=a(),pe=i("p"),this.h()},l(t){const e=pa("svelte-u9bgzb",document.head);c=o(e,"META",{name:!0,content:!0}),e.forEach(l),me=s(t),oe=o(t,"P",{}),ea(oe).forEach(l),re=s(t),r(w.$$.fragment,t),de=s(t),r(b.$$.fragment,t),Me=s(t),g=o(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-zhrrkz"&&(g.innerHTML=ln),ue=s(t),j=o(t,"P",{"data-svelte-h":!0}),p(j)!=="svelte-g1kap"&&(j.textContent=nn),ye=s(t),T=o(t,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1ls58cl"&&(T.innerHTML=an),he=s(t),J=o(t,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1456rmz"&&(J.textContent=sn),fe=s(t),r(U.$$.fragment,t),ce=s(t),$=o(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-18lzvav"&&($.textContent=on),we=s(t),_=o(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-45uy3i"&&(_.textContent=pn),be=s(t),C=o(t,"P",{"data-svelte-h":!0}),p(C)!=="svelte-18z3ipt"&&(C.innerHTML=mn),ge=s(t),Z=o(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-qc7sdd"&&(Z.innerHTML=rn),je=s(t),G=o(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1p5jk0l"&&(G.textContent=dn),Te=s(t),v=o(t,"P",{"data-svelte-h":!0}),p(v)!=="svelte-10sha4z"&&(v.innerHTML=Mn),Je=s(t),X=o(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1ny096o"&&(X.textContent=un),Ue=s(t),r(W.$$.fragment,t),$e=s(t),k=o(t,"P",{"data-svelte-h":!0}),p(k)!=="svelte-j7tmb1"&&(k.textContent=yn),_e=s(t),B=o(t,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1m9d1jc"&&(B.textContent=hn),Ce=s(t),r(R.$$.fragment,t),Ze=s(t),I=o(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-hohwow"&&(I.textContent=fn),Ge=s(t),r(V.$$.fragment,t),ve=s(t),r(x.$$.fragment,t),Xe=s(t),F=o(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-z28z6b"&&(F.textContent=cn),We=s(t),r(H.$$.fragment,t),ke=s(t),r(Y.$$.fragment,t),Be=s(t),z=o(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-nnqgws"&&(z.textContent=wn),Re=s(t),A=o(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1bfibd0"&&(A.textContent=bn),Ie=s(t),r(Q.$$.fragment,t),Ve=s(t),r(N.$$.fragment,t),xe=s(t),r(E.$$.fragment,t),Fe=s(t),S=o(t,"P",{"data-svelte-h":!0}),p(S)!=="svelte-12ic4qe"&&(S.innerHTML=gn),He=s(t),P=o(t,"P",{"data-svelte-h":!0}),p(P)!=="svelte-f1cbgc"&&(P.textContent=jn),Ye=s(t),r(q.$$.fragment,t),ze=s(t),L=o(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-ohj6o9"&&(L.textContent=Tn),Ae=s(t),D=o(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1q35fmx"&&(D.textContent=Jn),Qe=s(t),K=o(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1o3evl6"&&(K.textContent=Un),Ne=s(t),O=o(t,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1kirzpz"&&(O.textContent=$n),Ee=s(t),r(tt.$$.fragment,t),Se=s(t),et=o(t,"PRE",{"data-svelte-h":!0}),p(et)!=="svelte-j0gwzs"&&(et.textContent=_n),Pe=s(t),r(lt.$$.fragment,t),qe=s(t),nt=o(t,"PRE",{"data-svelte-h":!0}),p(nt)!=="svelte-156di1e"&&(nt.textContent=Cn),Le=s(t),at=o(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1uwz1x1"&&(at.textContent=Zn),De=s(t),r(st.$$.fragment,t),Ke=s(t),it=o(t,"P",{"data-svelte-h":!0}),p(it)!=="svelte-t6xz5y"&&(it.textContent=Gn),Oe=s(t),ot=o(t,"UL",{"data-svelte-h":!0}),p(ot)!=="svelte-q7foik"&&(ot.innerHTML=vn),tl=s(t),r(pt.$$.fragment,t),el=s(t),r(mt.$$.fragment,t),ll=s(t),r(rt.$$.fragment,t),nl=s(t),r(dt.$$.fragment,t),al=s(t),Mt=o(t,"PRE",{"data-svelte-h":!0}),p(Mt)!=="svelte-19qaqk6"&&(Mt.textContent=Xn),sl=s(t),r(ut.$$.fragment,t),il=s(t),r(yt.$$.fragment,t),ol=s(t),r(ht.$$.fragment,t),pl=s(t),r(ft.$$.fragment,t),ml=s(t),ct=o(t,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-dosxno"&&(ct.innerHTML=Wn),rl=s(t),wt=o(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-199aanp"&&(wt.textContent=kn),dl=s(t),r(bt.$$.fragment,t),Ml=s(t),r(gt.$$.fragment,t),ul=s(t),jt=o(t,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-1d6c0z"&&(jt.textContent=Bn),yl=s(t),r(Tt.$$.fragment,t),hl=s(t),Jt=o(t,"PRE",{"data-svelte-h":!0}),p(Jt)!=="svelte-1j4ogfu"&&(Jt.textContent=Rn),fl=s(t),r(Ut.$$.fragment,t),cl=s(t),$t=o(t,"PRE",{"data-svelte-h":!0}),p($t)!=="svelte-1j4ogfu"&&($t.textContent=In),wl=s(t),_t=o(t,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-1ypb27x"&&(_t.innerHTML=Vn),bl=s(t),Ct=o(t,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-1awt1kq"&&(Ct.textContent=xn),gl=s(t),r(Zt.$$.fragment,t),jl=s(t),r(Gt.$$.fragment,t),Tl=s(t),vt=o(t,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-brx99y"&&(vt.textContent=Fn),Jl=s(t),r(Xt.$$.fragment,t),Ul=s(t),r(Wt.$$.fragment,t),$l=s(t),kt=o(t,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-nidd2f"&&(kt.textContent=Hn),_l=s(t),r(Bt.$$.fragment,t),Cl=s(t),r(Rt.$$.fragment,t),Zl=s(t),r(It.$$.fragment,t),Gl=s(t),Vt=o(t,"P",{"data-svelte-h":!0}),p(Vt)!=="svelte-mfp794"&&(Vt.textContent=Yn),vl=s(t),r(xt.$$.fragment,t),Xl=s(t),Ft=o(t,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-cdfxhl"&&(Ft.textContent=zn),Wl=s(t),r(Ht.$$.fragment,t),kl=s(t),r(Yt.$$.fragment,t),Bl=s(t),zt=o(t,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-1m1edcj"&&(zt.textContent=An),Rl=s(t),r(At.$$.fragment,t),Il=s(t),r(Qt.$$.fragment,t),Vl=s(t),Nt=o(t,"PRE",{"data-svelte-h":!0}),p(Nt)!=="svelte-17c65rx"&&(Nt.textContent=Qn),xl=s(t),Et=o(t,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-1wnq88c"&&(Et.textContent=Nn),Fl=s(t),St=o(t,"UL",{"data-svelte-h":!0}),p(St)!=="svelte-mfh99e"&&(St.innerHTML=En),Hl=s(t),Pt=o(t,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-1i1i2t5"&&(Pt.textContent=Sn),Yl=s(t),r(qt.$$.fragment,t),zl=s(t),r(Lt.$$.fragment,t),Al=s(t),Dt=o(t,"PRE",{"data-svelte-h":!0}),p(Dt)!=="svelte-1h21gmq"&&(Dt.textContent=Pn),Ql=s(t),Kt=o(t,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-1shp62p"&&(Kt.textContent=qn),Nl=s(t),Ot=o(t,"UL",{"data-svelte-h":!0}),p(Ot)!=="svelte-111al67"&&(Ot.innerHTML=Ln),El=s(t),r(te.$$.fragment,t),Sl=s(t),ee=o(t,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1cb43mv"&&(ee.textContent=Dn),Pl=s(t),le=o(t,"P",{"data-svelte-h":!0}),p(le)!=="svelte-6kx7bz"&&(le.textContent=Kn),ql=s(t),ne=o(t,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-108kauw"&&(ne.textContent=On),Ll=s(t),ae=o(t,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-pbb6ov"&&(ae.innerHTML=ta),Dl=s(t),r(se.$$.fragment,t),Kl=s(t),r(ie.$$.fragment,t),Ol=s(t),pe=o(t,"P",{}),ea(pe).forEach(l),this.h()},h(){la(c,"name","hf:doc:metadata"),la(c,"content",ua)},m(t,e){ma(document.head,c),n(t,me,e),n(t,oe,e),n(t,re,e),d(w,t,e),n(t,de,e),d(b,t,e),n(t,Me,e),n(t,g,e),n(t,ue,e),n(t,j,e),n(t,ye,e),n(t,T,e),n(t,he,e),n(t,J,e),n(t,fe,e),d(U,t,e),n(t,ce,e),n(t,$,e),n(t,we,e),n(t,_,e),n(t,be,e),n(t,C,e),n(t,ge,e),n(t,Z,e),n(t,je,e),n(t,G,e),n(t,Te,e),n(t,v,e),n(t,Je,e),n(t,X,e),n(t,Ue,e),d(W,t,e),n(t,$e,e),n(t,k,e),n(t,_e,e),n(t,B,e),n(t,Ce,e),d(R,t,e),n(t,Ze,e),n(t,I,e),n(t,Ge,e),d(V,t,e),n(t,ve,e),d(x,t,e),n(t,Xe,e),n(t,F,e),n(t,We,e),d(H,t,e),n(t,ke,e),d(Y,t,e),n(t,Be,e),n(t,z,e),n(t,Re,e),n(t,A,e),n(t,Ie,e),d(Q,t,e),n(t,Ve,e),d(N,t,e),n(t,xe,e),d(E,t,e),n(t,Fe,e),n(t,S,e),n(t,He,e),n(t,P,e),n(t,Ye,e),d(q,t,e),n(t,ze,e),n(t,L,e),n(t,Ae,e),n(t,D,e),n(t,Qe,e),n(t,K,e),n(t,Ne,e),n(t,O,e),n(t,Ee,e),d(tt,t,e),n(t,Se,e),n(t,et,e),n(t,Pe,e),d(lt,t,e),n(t,qe,e),n(t,nt,e),n(t,Le,e),n(t,at,e),n(t,De,e),d(st,t,e),n(t,Ke,e),n(t,it,e),n(t,Oe,e),n(t,ot,e),n(t,tl,e),d(pt,t,e),n(t,el,e),d(mt,t,e),n(t,ll,e),d(rt,t,e),n(t,nl,e),d(dt,t,e),n(t,al,e),n(t,Mt,e),n(t,sl,e),d(ut,t,e),n(t,il,e),d(yt,t,e),n(t,ol,e),d(ht,t,e),n(t,pl,e),d(ft,t,e),n(t,ml,e),n(t,ct,e),n(t,rl,e),n(t,wt,e),n(t,dl,e),d(bt,t,e),n(t,Ml,e),d(gt,t,e),n(t,ul,e),n(t,jt,e),n(t,yl,e),d(Tt,t,e),n(t,hl,e),n(t,Jt,e),n(t,fl,e),d(Ut,t,e),n(t,cl,e),n(t,$t,e),n(t,wl,e),n(t,_t,e),n(t,bl,e),n(t,Ct,e),n(t,gl,e),d(Zt,t,e),n(t,jl,e),d(Gt,t,e),n(t,Tl,e),n(t,vt,e),n(t,Jl,e),d(Xt,t,e),n(t,Ul,e),d(Wt,t,e),n(t,$l,e),n(t,kt,e),n(t,_l,e),d(Bt,t,e),n(t,Cl,e),d(Rt,t,e),n(t,Zl,e),d(It,t,e),n(t,Gl,e),n(t,Vt,e),n(t,vl,e),d(xt,t,e),n(t,Xl,e),n(t,Ft,e),n(t,Wl,e),d(Ht,t,e),n(t,kl,e),d(Yt,t,e),n(t,Bl,e),n(t,zt,e),n(t,Rl,e),d(At,t,e),n(t,Il,e),d(Qt,t,e),n(t,Vl,e),n(t,Nt,e),n(t,xl,e),n(t,Et,e),n(t,Fl,e),n(t,St,e),n(t,Hl,e),n(t,Pt,e),n(t,Yl,e),d(qt,t,e),n(t,zl,e),d(Lt,t,e),n(t,Al,e),n(t,Dt,e),n(t,Ql,e),n(t,Kt,e),n(t,Nl,e),n(t,Ot,e),n(t,El,e),d(te,t,e),n(t,Sl,e),n(t,ee,e),n(t,Pl,e),n(t,le,e),n(t,ql,e),n(t,ne,e),n(t,Ll,e),n(t,ae,e),n(t,Dl,e),d(se,t,e),n(t,Kl,e),d(ie,t,e),n(t,Ol,e),n(t,pe,e),tn=!0},p:aa,i(t){tn||(M(w.$$.fragment,t),M(b.$$.fragment,t),M(U.$$.fragment,t),M(W.$$.fragment,t),M(R.$$.fragment,t),M(V.$$.fragment,t),M(x.$$.fragment,t),M(H.$$.fragment,t),M(Y.$$.fragment,t),M(Q.$$.fragment,t),M(N.$$.fragment,t),M(E.$$.fragment,t),M(q.$$.fragment,t),M(tt.$$.fragment,t),M(lt.$$.fragment,t),M(st.$$.fragment,t),M(pt.$$.fragment,t),M(mt.$$.fragment,t),M(rt.$$.fragment,t),M(dt.$$.fragment,t),M(ut.$$.fragment,t),M(yt.$$.fragment,t),M(ht.$$.fragment,t),M(ft.$$.fragment,t),M(bt.$$.fragment,t),M(gt.$$.fragment,t),M(Tt.$$.fragment,t),M(Ut.$$.fragment,t),M(Zt.$$.fragment,t),M(Gt.$$.fragment,t),M(Xt.$$.fragment,t),M(Wt.$$.fragment,t),M(Bt.$$.fragment,t),M(Rt.$$.fragment,t),M(It.$$.fragment,t),M(xt.$$.fragment,t),M(Ht.$$.fragment,t),M(Yt.$$.fragment,t),M(At.$$.fragment,t),M(Qt.$$.fragment,t),M(qt.$$.fragment,t),M(Lt.$$.fragment,t),M(te.$$.fragment,t),M(se.$$.fragment,t),M(ie.$$.fragment,t),tn=!0)},o(t){u(w.$$.fragment,t),u(b.$$.fragment,t),u(U.$$.fragment,t),u(W.$$.fragment,t),u(R.$$.fragment,t),u(V.$$.fragment,t),u(x.$$.fragment,t),u(H.$$.fragment,t),u(Y.$$.fragment,t),u(Q.$$.fragment,t),u(N.$$.fragment,t),u(E.$$.fragment,t),u(q.$$.fragment,t),u(tt.$$.fragment,t),u(lt.$$.fragment,t),u(st.$$.fragment,t),u(pt.$$.fragment,t),u(mt.$$.fragment,t),u(rt.$$.fragment,t),u(dt.$$.fragment,t),u(ut.$$.fragment,t),u(yt.$$.fragment,t),u(ht.$$.fragment,t),u(ft.$$.fragment,t),u(bt.$$.fragment,t),u(gt.$$.fragment,t),u(Tt.$$.fragment,t),u(Ut.$$.fragment,t),u(Zt.$$.fragment,t),u(Gt.$$.fragment,t),u(Xt.$$.fragment,t),u(Wt.$$.fragment,t),u(Bt.$$.fragment,t),u(Rt.$$.fragment,t),u(It.$$.fragment,t),u(xt.$$.fragment,t),u(Ht.$$.fragment,t),u(Yt.$$.fragment,t),u(At.$$.fragment,t),u(Qt.$$.fragment,t),u(qt.$$.fragment,t),u(Lt.$$.fragment,t),u(te.$$.fragment,t),u(se.$$.fragment,t),u(ie.$$.fragment,t),tn=!1},d(t){t&&(l(me),l(oe),l(re),l(de),l(Me),l(g),l(ue),l(j),l(ye),l(T),l(he),l(J),l(fe),l(ce),l($),l(we),l(_),l(be),l(C),l(ge),l(Z),l(je),l(G),l(Te),l(v),l(Je),l(X),l(Ue),l($e),l(k),l(_e),l(B),l(Ce),l(Ze),l(I),l(Ge),l(ve),l(Xe),l(F),l(We),l(ke),l(Be),l(z),l(Re),l(A),l(Ie),l(Ve),l(xe),l(Fe),l(S),l(He),l(P),l(Ye),l(ze),l(L),l(Ae),l(D),l(Qe),l(K),l(Ne),l(O),l(Ee),l(Se),l(et),l(Pe),l(qe),l(nt),l(Le),l(at),l(De),l(Ke),l(it),l(Oe),l(ot),l(tl),l(el),l(ll),l(nl),l(al),l(Mt),l(sl),l(il),l(ol),l(pl),l(ml),l(ct),l(rl),l(wt),l(dl),l(Ml),l(ul),l(jt),l(yl),l(hl),l(Jt),l(fl),l(cl),l($t),l(wl),l(_t),l(bl),l(Ct),l(gl),l(jl),l(Tl),l(vt),l(Jl),l(Ul),l($l),l(kt),l(_l),l(Cl),l(Zl),l(Gl),l(Vt),l(vl),l(Xl),l(Ft),l(Wl),l(kl),l(Bl),l(zt),l(Rl),l(Il),l(Vl),l(Nt),l(xl),l(Et),l(Fl),l(St),l(Hl),l(Pt),l(Yl),l(zl),l(Al),l(Dt),l(Ql),l(Kt),l(Nl),l(Ot),l(El),l(Sl),l(ee),l(Pl),l(le),l(ql),l(ne),l(Ll),l(ae),l(Dl),l(Kl),l(Ol),l(pe)),l(c),y(w,t),y(b,t),y(U,t),y(W,t),y(R,t),y(V,t),y(x,t),y(H,t),y(Y,t),y(Q,t),y(N,t),y(E,t),y(q,t),y(tt,t),y(lt,t),y(st,t),y(pt,t),y(mt,t),y(rt,t),y(dt,t),y(ut,t),y(yt,t),y(ht,t),y(ft,t),y(bt,t),y(gt,t),y(Tt,t),y(Ut,t),y(Zt,t),y(Gt,t),y(Xt,t),y(Wt,t),y(Bt,t),y(Rt,t),y(It,t),y(xt,t),y(Ht,t),y(Yt,t),y(At,t),y(Qt,t),y(qt,t),y(Lt,t),y(te,t),y(se,t),y(ie,t)}}}const ua='{"title":"Prompt Tuning With PEFT.","local":"prompt-tuning-with-peft","sections":[{"title":"Brief introduction to Prompt Tuning.","local":"brief-introduction-to-prompt-tuning","sections":[],"depth":2},{"title":"What are we going to do in the notebook?","local":"what-are-we-going-to-do-in-the-notebook","sections":[],"depth":2},{"title":"Loading the PEFT Library","local":"loading-the-peft-library","sections":[{"title":"Loading the model and the tokenizers.","local":"loading-the-model-and-the-tokenizers","sections":[],"depth":3}],"depth":2},{"title":"Inference with the pre trained bloom model","local":"inference-with-the-pre-trained-bloom-model","sections":[],"depth":2},{"title":"Preparing the Datasets","local":"preparing-the-datasets","sections":[],"depth":2},{"title":"Fine-Tuning.","local":"fine-tuning","sections":[{"title":"PEFT configurations","local":"peft-configurations","sections":[],"depth":3},{"title":"Creating two Prompt Tuning Models.","local":"creating-two-prompt-tuning-models","sections":[],"depth":3}],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2},{"title":"Save models","local":"save-models","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function ya(en){return sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ba extends ia{constructor(c){super(),oa(this,c,ya,Ma,na,{})}}export{ba as component};
