import{s as Ke,n as Pe,o as Oe}from"../chunks/scheduler.39a43cde.js";import{S as tl,i as el,g as i,s as a,r as M,A as ll,h as o,f as l,c as n,j as De,u as r,x as p,k as fe,y as sl,a as s,v as d,d as c,t as u,w as h}from"../chunks/index.23ec2204.js";import{D as al,C as y}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as mt,E as nl}from"../chunks/EditOnGithub.f2d09226.js";function il(be){let m,Tt,wt,Ut,T,ft,U,bt,f,je='<em>Authored by: <a href="https://huggingface.co/davidberenstein1957" rel="nofollow">David Berenstein</a> and <a href="https://huggingface.co/sdiazlor" rel="nofollow">Sara Han Díaz</a></em>',jt,b,ge="Suggestions are a wonderful way to make things easier and faster for your annotation team. These preselected options will make the labeling process more efficient, as they will only need to correct the suggestions. In this example, we will demonstrate how to implement a zero-shot approach using SetFit to get some initial suggestions for a dataset in Argilla that combines two text classification tasks that include a <code>LabelQuestion</code> and a <code>MultiLabelQuestion</code>.",gt,j,Ie='<a href="https://github.com/argilla-io/argilla" rel="nofollow">Argilla</a> is an open-source data curation platform, designed to enhance the development of both small and large language models (LLMs). Using Argilla, everyone can build robust language models through faster data curation using both human and machine feedback. So, it provides support for each step in the MLOps cycle, from data labeling to model monitoring.',It,g,Ce="Feedback is a crucial part of the data curation process and Argilla also provides a way to manage and visualize it, so that the curated data can be later used to improve a language model. In this tutorial, we will show a real example of how to make our annotators’ job easier by providing them with suggestions. To achieve this, you will learn how to train zero-shot sentiment and topic classifiers using SetFit and then use them to suggest labels for the dataset.",Ct,I,$e="In this tutorial, we will follow these steps:",$t,C,Ze="<li>Create a dataset in Argilla.</li> <li>Train the zero-shot classifiers using SetFit.</li> <li>Get suggestions for the dataset using the trained classifiers.</li> <li>Visualize the suggestions in Argilla.</li>",Zt,$,Ge="Let’s get started!",Gt,Z,kt,G,ke='For this tutorial, you will need to have an Argilla server running. If you don’t have one already, check out our <a href="https://docs.argilla.io/en/latest/getting_started/quickstart.html" rel="nofollow">Quickstart</a> or <a href="https://docs.argilla.io/en/latest/getting_started/quickstart_installation.html" rel="nofollow">Installation</a> pages. Once you do, complete the following steps:',Wt,k,We="<li>Install the Argilla client and the required third-party libraries using <code>pip</code>:</li>",Bt,W,vt,w,Be="<li>Make the necessary imports:</li>",Rt,B,_t,J,ve="<li>If you are running Argilla using the Docker quickstart image or Hugging Face Spaces, you need to init the Argilla client with the <code>URL</code> and <code>API_KEY</code>:</li>",qt,v,Vt,R,Re='If you’re running a private Hugging Face Space, you will also need to set the <a href="https://huggingface.co/settings/tokens" rel="nofollow">HF_TOKEN</a> as follows:',Ft,_,Nt,q,xt,V,_e='In this example, we will load the <a href="https://huggingface.co/datasets/banking77" rel="nofollow">banking77</a> dataset, a popular open-source dataset that has customer requests in the banking domain.',Ht,F,Yt,N,qe='Argilla works with the <code>FeedbackDataset</code>, which easily enables you to create a dataset and manage the data and feedback. The <code>FeedbackDataset</code> has first to be configured by indicating the two main components (although more can be added): the <em>fields</em> where the data to be annotated will be added and the <em>questions</em> for the annotators. For more information about the <code>FeedbackDataset</code> and the optional components, check the <a href="https://docs.argilla.io/en/latest/practical_guides/create_update_dataset/create_dataset.html" rel="nofollow">Argilla documentation</a> and our <a href="https://docs.argilla.io/en/latest/tutorials_and_integrations/tutorials/tutorials.html" rel="nofollow">end-to-end tutorials</a>.',Xt,x,Ve='<p>You can also create one straight away using the <a href="https://docs.argilla.io/en/latest/practical_guides/create_update_dataset/create_dataset.html#task-templates" rel="nofollow">default Templates</a>.</p>',St,H,Fe="In this case, we will configure a custom dataset with two different questions so that we can work with two text classification tasks at the same time. We will load the original labels of this dataset to make a multi-label classification of the topics mentioned in the request and we will also set up a question to classify the sentiment of the request as either “positive”, “neutral” or “negative”.",At,Y,zt,X,Et,S,Ne='Now we will use the data we loaded and the labels and questions we configured for our dataset to train a zero-shot text classification model for each of the questions in our dataset. As mentioned in previous sections, we will use the <a href="https://github.com/huggingface/setfit" rel="nofollow">SetFit</a> framework for few-shot fine-tuning of Sentence Transformers in both classifiers. In addition, the model we will use is <a href="https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2" rel="nofollow">all-MiniLM-L6-v2</a>, a sentence embedding model fine-tuned on a 1B sentence pairs dataset using a contrastive objective.',Qt,A,Lt,z,Dt,E,Kt,Q,Pt,L,xe="Once the training step is over, we can make predictions over our data.",Ot,D,te,K,ee,P,le,O,se,tt,He="With the data and the predictions we have produced, now we can build records (each of the data items that will be annotated by the annotator team) that include the suggestions from our models. In the case of the <code>LabelQuestion</code> we will use the label that received the highest probability score and for the <code>MultiLabelQuestion</code> we will include all labels with a score above a certain threshold. In this case, we decided to go for <code>2/len(labels)</code>, but you can experiment with your data and decide to go for a more restrictive or more lenient threshold.",ae,et,Ye="<p>Note that more lenient thresholds (closer or equal to <code>1/len(labels)</code>) will suggest more labels and restrictive thresholds (between 2 and 3) will select fewer (or no) labels.</p>",ne,lt,ie,st,oe,at,Xe="Once we are happy with the result, we can add the records to the dataset that we configured above. Finally, to visualize it and start annotating, you need to push it to Argilla. This means adding your dataset to the running Argilla server and making it available for the annotators.",pe,nt,Me,it,re,ot,Se="This is how the UI will look like with the suggestions from our models:",de,pt,Ae='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/snapshot_setfit_suggestions.png" alt="Feedback Task dataset with suggestions made using SetFit"/>',ce,Mt,ze='Optionally, you can also save and load your <code>FeedbackDataset</code> into the Hugging Face Hub. Refer to the <a href="https://docs.argilla.io/en/latest/practical_guides/export_dataset.html" rel="nofollow">documentation</a> for more information on how to do this.',ue,rt,he,dt,ye,ct,Ee="In this tutorial, we have covered how to add suggestions to a Feedback Task dataset using a zero-shot approach with the SetFit library. This will help with the efficiency of the labelling process by lowering the number of decisions and edits that the annotation team must make.",me,ut,Qe="To learn more about SetFit check out these links:",we,ht,Le='<li><a href="https://docs.argilla.io/en/latest/tutorials_and_integrations/tutorials/tutorials.html" rel="nofollow">More Argilla tutorials</a></li> <li><a href="https://github.com/huggingface/setfit" rel="nofollow">SetFit repo on GitHub</a></li> <li><a href="https://huggingface.co/docs/setfit/index" rel="nofollow">SetFit documentation</a></li>',Je,yt,Te,Jt,Ue;return T=new al({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/updated_notebook_dependencies/notebooks/en/labelling_feedback_setfit.ipynb"}]}}),U=new mt({props:{title:"Suggestions for Data Annotation with SetFit in Zero-shot Text Classification",local:"suggestions-for-data-annotation-with-setfit-in-zero-shot-text-classification",headingTag:"h1"}}),Z=new mt({props:{title:"Setup",local:"setup",headingTag:"h2"}}),W=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjBhcmdpbGxhJTIwc2V0Zml0",highlighted:"!pip install argilla setfit",wrap:!1}}),B=new y({props:{code:"aW1wb3J0JTIwYXJnaWxsYSUyMGFzJTIwcmclMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwc2V0Zml0JTIwaW1wb3J0JTIwZ2V0X3RlbXBsYXRlZF9kYXRhc2V0JTBBZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTJDJTIwU2V0Rml0VHJhaW5lcg==",highlighted:`<span class="hljs-keyword">import</span> argilla <span class="hljs-keyword">as</span> rg
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> get_templated_dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, SetFitTrainer`,wrap:!1}}),v=new y({props:{code:"JTIzJTIwUmVwbGFjZSUyMGFwaV91cmwlMjB3aXRoJTIwdGhlJTIwdXJsJTIwdG8lMjB5b3VyJTIwSEYlMjBTcGFjZXMlMjBVUkwlMjBpZiUyMHVzaW5nJTIwU3BhY2VzJTBBJTIzJTIwUmVwbGFjZSUyMGFwaV9rZXklMjBpZiUyMHlvdSUyMGNvbmZpZ3VyZWQlMjBhJTIwY3VzdG9tJTIwQVBJJTIwa2V5JTBBcmcuaW5pdChhcGlfdXJsJTNEJTIyaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTY5MDAlMjIlMkMlMjBhcGlfa2V5JTNEJTIyYWRtaW4uYXBpa2V5JTIyJTJDJTIwd29ya3NwYWNlJTNEJTIyYWRtaW4lMjIp",highlighted:`<span class="hljs-comment"># Replace api_url with the url to your HF Spaces URL if using Spaces</span>
<span class="hljs-comment"># Replace api_key if you configured a custom API key</span>
rg.init(api_url=<span class="hljs-string">&quot;http://localhost:6900&quot;</span>, api_key=<span class="hljs-string">&quot;admin.apikey&quot;</span>, workspace=<span class="hljs-string">&quot;admin&quot;</span>)`,wrap:!1}}),_=new y({props:{code:"JTIzJTIwJTIzJTIwU2V0JTIwdGhlJTIwSEZfVE9LRU4lMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTBBJTIzJTIwaW1wb3J0JTIwb3MlMEElMjMlMjBvcy5lbnZpcm9uJTVCJ0hGX1RPS0VOJyU1RCUyMCUzRCUyMCUyMnlvdXItaGYtdG9rZW4lMjIlMEElMEElMjMlMjAlMjMlMjBSZXBsYWNlJTIwYXBpX3VybCUyMHdpdGglMjB0aGUlMjB1cmwlMjB0byUyMHlvdXIlMjBIRiUyMFNwYWNlcyUyMFVSTCUwQSUyMyUyMCUyMyUyMFJlcGxhY2UlMjBhcGlfa2V5JTIwaWYlMjB5b3UlMjBjb25maWd1cmVkJTIwYSUyMGN1c3RvbSUyMEFQSSUyMGtleSUwQSUyMyUyMHJnLmluaXQoJTBBJTIzJTIwJTIwJTIwJTIwJTIwYXBpX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGJTVCeW91ci1vd25lci1uYW1lJTVELSU1QnlvdXJfc3BhY2VfbmFtZSU1RC5oZi5zcGFjZSUyMiUyQyUwQSUyMyUyMCUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjJhZG1pbi5hcGlrZXklMjIlMkMlMEElMjMlMjAlMjAlMjAlMjAlMjB3b3Jrc3BhY2UlM0QlMjJhZG1pbiUyMiUyQyUwQSUyMyUyMCUyMCUyMCUyMCUyMGV4dHJhX2hlYWRlcnMlM0QlN0IlMjJBdXRob3JpemF0aW9uJTIyJTNBJTIwZiUyMkJlYXJlciUyMCU3Qm9zLmVudmlyb24lNUInSEZfVE9LRU4nJTVEJTdEJTIyJTdEJTJDJTBBJTIzJTIwKQ==",highlighted:`<span class="hljs-comment"># # Set the HF_TOKEN environment variable</span>
<span class="hljs-comment"># import os</span>
<span class="hljs-comment"># os.environ[&#x27;HF_TOKEN&#x27;] = &quot;your-hf-token&quot;</span>

<span class="hljs-comment"># # Replace api_url with the url to your HF Spaces URL</span>
<span class="hljs-comment"># # Replace api_key if you configured a custom API key</span>
<span class="hljs-comment"># rg.init(</span>
<span class="hljs-comment">#     api_url=&quot;https://[your-owner-name]-[your_space_name].hf.space&quot;,</span>
<span class="hljs-comment">#     api_key=&quot;admin.apikey&quot;,</span>
<span class="hljs-comment">#     workspace=&quot;admin&quot;,</span>
<span class="hljs-comment">#     extra_headers={&quot;Authorization&quot;: f&quot;Bearer {os.environ[&#x27;HF_TOKEN&#x27;]}&quot;},</span>
<span class="hljs-comment"># )</span>`,wrap:!1}}),q=new mt({props:{title:"Configure the dataset",local:"configure-the-dataset",headingTag:"h2"}}),F=new y({props:{code:"ZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZiYW5raW5nNzclMjIlMkMlMjBzcGxpdCUzRCUyMnRlc3QlMjIp",highlighted:'data = load_dataset(<span class="hljs-string">&quot;PolyAI/banking77&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)',wrap:!1}}),Y=new y({props:{code:"ZGF0YXNldCUyMCUzRCUyMHJnLkZlZWRiYWNrRGF0YXNldCglMEElMjAlMjAlMjAlMjBmaWVsZHMlM0QlNUJyZy5UZXh0RmllbGQobmFtZSUzRCUyMnRleHQlMjIpJTVEJTJDJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb25zJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmcuTXVsdGlMYWJlbFF1ZXN0aW9uKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5hbWUlM0QlMjJ0b3BpY3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCUyMlNlbGVjdCUyMHRoZSUyMHRvcGljKHMpJTIwb2YlMjB0aGUlMjByZXF1ZXN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNEZGF0YS5pbmZvLmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMlMkMlMjAlMjAlMjMlMjB0aGVzZSUyMGFyZSUyMHRoZSUyMG9yaWdpbmFsJTIwbGFiZWxzJTIwcHJlc2VudCUyMGluJTIwdGhlJTIwZGF0YXNldCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpc2libGVfbGFiZWxzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmcuTGFiZWxRdWVzdGlvbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEJTIyc2VudGltZW50JTIyJTJDJTIwdGl0bGUlM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBzZW50aW1lbnQlMjBvZiUyMHRoZSUyMG1lc3NhZ2UlM0YlMjIlMkMlMjBsYWJlbHMlM0QlNUIlMjJwb3NpdGl2ZSUyMiUyQyUyMCUyMm5ldXRyYWwlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEEp",highlighted:`dataset = rg.FeedbackDataset(
    fields=[rg.TextField(name=<span class="hljs-string">&quot;text&quot;</span>)],
    questions=[
        rg.MultiLabelQuestion(
            name=<span class="hljs-string">&quot;topics&quot;</span>,
            title=<span class="hljs-string">&quot;Select the topic(s) of the request&quot;</span>,
            labels=data.info.features[<span class="hljs-string">&quot;label&quot;</span>].names,  <span class="hljs-comment"># these are the original labels present in the dataset</span>
            visible_labels=<span class="hljs-number">10</span>,
        ),
        rg.LabelQuestion(
            name=<span class="hljs-string">&quot;sentiment&quot;</span>, title=<span class="hljs-string">&quot;What is the sentiment of the message?&quot;</span>, labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;neutral&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>]
        ),
    ],
)`,wrap:!1}}),X=new mt({props:{title:"Train the models",local:"train-the-models",headingTag:"h2"}}),A=new y({props:{code:"ZGVmJTIwdHJhaW5fbW9kZWwocXVlc3Rpb25fbmFtZSUyQyUyMHRlbXBsYXRlJTJDJTIwbXVsdGlfbGFiZWwlM0RGYWxzZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBidWlsZCUyMGElMjB0cmFpbmluZyUyMGRhdGFzZXQlMjB0aGF0JTIwdXNlcyUyMHRoZSUyMGxhYmVscyUyMG9mJTIwYSUyMHNwZWNpZmljJTIwcXVlc3Rpb24lMjBpbiUyMG91ciUyMEFyZ2lsbGElMjBkYXRhc2V0JTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUyMCUzRCUyMGdldF90ZW1wbGF0ZWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYW5kaWRhdGVfbGFiZWxzJTNEZGF0YXNldC5xdWVzdGlvbl9ieV9uYW1lKHF1ZXN0aW9uX25hbWUpLmxhYmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsZV9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbXBsYXRlJTNEdGVtcGxhdGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtdWx0aV9sYWJlbCUzRG11bHRpX2xhYmVsJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwdXNpbmclMjB0aGUlMjB0cmFpbmluZyUyMGRhdGFzZXQlMjB3ZSUyMGp1c3QlMjBidWlsdCUwQSUyMCUyMCUyMCUyMGlmJTIwbXVsdGlfbGFiZWwlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMFNldEZpdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJhbGwtTWluaUxNLUw2LXYyJTIyJTJDJTIwbXVsdGlfdGFyZ2V0X3N0cmF0ZWd5JTNEJTIyb25lLXZzLXJlc3QlMjIpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwU2V0Rml0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBJTBBJTIwJTIwJTIwJTIwdHJhaW5lciUyMCUzRCUyMFNldEZpdFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0KSUwQSUyMCUyMCUyMCUyMHRyYWluZXIudHJhaW4oKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1vZGVs",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">train_model</span>(<span class="hljs-params">question_name, template, multi_label=<span class="hljs-literal">False</span></span>):
    <span class="hljs-comment"># build a training dataset that uses the labels of a specific question in our Argilla dataset</span>
    train_dataset = get_templated_dataset(
        candidate_labels=dataset.question_by_name(question_name).labels,
        sample_size=<span class="hljs-number">8</span>,
        template=template,
        multi_label=multi_label,
    )

    <span class="hljs-comment"># train a model using the training dataset we just built</span>
    <span class="hljs-keyword">if</span> multi_label:
        model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;all-MiniLM-L6-v2&quot;</span>, multi_target_strategy=<span class="hljs-string">&quot;one-vs-rest&quot;</span>)
    <span class="hljs-keyword">else</span>:
        model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;all-MiniLM-L6-v2&quot;</span>)

    trainer = SetFitTrainer(model=model, train_dataset=train_dataset)
    trainer.train()
    <span class="hljs-keyword">return</span> model`,wrap:!1}}),z=new y({props:{code:"dG9waWNfbW9kZWwlMjAlM0QlMjB0cmFpbl9tb2RlbChxdWVzdGlvbl9uYW1lJTNEJTIydG9waWNzJTIyJTJDJTIwdGVtcGxhdGUlM0QlMjJUaGUlMjBjdXN0b21lciUyMHJlcXVlc3QlMjBpcyUyMGFib3V0JTIwJTdCJTdEJTIyJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:'topic_model = train_model(question_name=<span class="hljs-string">&quot;topics&quot;</span>, template=<span class="hljs-string">&quot;The customer request is about {}&quot;</span>, multi_label=<span class="hljs-literal">True</span>)',wrap:!1}}),E=new y({props:{code:"c2VudGltZW50X21vZGVsJTIwJTNEJTIwdHJhaW5fbW9kZWwocXVlc3Rpb25fbmFtZSUzRCUyMnNlbnRpbWVudCUyMiUyQyUyMHRlbXBsYXRlJTNEJTIyVGhpcyUyMG1lc3NhZ2UlMjBpcyUyMCU3QiU3RCUyMiUyQyUyMG11bHRpX2xhYmVsJTNERmFsc2Up",highlighted:'sentiment_model = train_model(question_name=<span class="hljs-string">&quot;sentiment&quot;</span>, template=<span class="hljs-string">&quot;This message is {}&quot;</span>, multi_label=<span class="hljs-literal">False</span>)',wrap:!1}}),Q=new mt({props:{title:"Make predictions",local:"make-predictions",headingTag:"h2"}}),D=new y({props:{code:"ZGVmJTIwZ2V0X3ByZWRpY3Rpb25zKHRleHRzJTJDJTIwbW9kZWwlMkMlMjBxdWVzdGlvbl9uYW1lKSUzQSUwQSUyMCUyMCUyMCUyMHByb2JhcyUyMCUzRCUyMG1vZGVsLnByZWRpY3RfcHJvYmEodGV4dHMlMkMlMjBhc19udW1weSUzRFRydWUpJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwZGF0YXNldC5xdWVzdGlvbl9ieV9uYW1lKHF1ZXN0aW9uX25hbWUpLmxhYmVscyUwQSUyMCUyMCUyMCUyMGZvciUyMHByZWQlMjBpbiUyMHByb2JhcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHlpZWxkJTIwJTVCJTdCJTIybGFiZWwlMjIlM0ElMjBsYWJlbCUyQyUyMCUyMnNjb3JlJTIyJTNBJTIwc2NvcmUlN0QlMjBmb3IlMjBsYWJlbCUyQyUyMHNjb3JlJTIwaW4lMjB6aXAobGFiZWxzJTJDJTIwcHJlZCklNUQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_predictions</span>(<span class="hljs-params">texts, model, question_name</span>):
    probas = model.predict_proba(texts, as_numpy=<span class="hljs-literal">True</span>)
    labels = dataset.question_by_name(question_name).labels
    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> probas:
        <span class="hljs-keyword">yield</span> [{<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score} <span class="hljs-keyword">for</span> label, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(labels, pred)]`,wrap:!1}}),K=new y({props:{code:"ZGF0YSUyMCUzRCUyMGRhdGEubWFwKCUwQSUyMCUyMCUyMCUyMGxhbWJkYSUyMGJhdGNoJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG9waWNzJTIyJTNBJTIwbGlzdChnZXRfcHJlZGljdGlvbnMoYmF0Y2glNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwdG9waWNfbW9kZWwlMkMlMjAlMjJ0b3BpY3MlMjIpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNlbnRpbWVudCUyMiUzQSUyMGxpc3QoZ2V0X3ByZWRpY3Rpb25zKGJhdGNoJTVCJTIydGV4dCUyMiU1RCUyQyUyMHNlbnRpbWVudF9tb2RlbCUyQyUyMCUyMnNlbnRpbWVudCUyMikpJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEEp",highlighted:`data = data.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> batch: {
        <span class="hljs-string">&quot;topics&quot;</span>: <span class="hljs-built_in">list</span>(get_predictions(batch[<span class="hljs-string">&quot;text&quot;</span>], topic_model, <span class="hljs-string">&quot;topics&quot;</span>)),
        <span class="hljs-string">&quot;sentiment&quot;</span>: <span class="hljs-built_in">list</span>(get_predictions(batch[<span class="hljs-string">&quot;text&quot;</span>], sentiment_model, <span class="hljs-string">&quot;sentiment&quot;</span>)),
    },
    batched=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),P=new y({props:{code:"ZGF0YS50b19wYW5kYXMoKS5oZWFkKCk=",highlighted:"data.to_pandas().head()",wrap:!1}}),O=new mt({props:{title:"Build records and push",local:"build-records-and-push",headingTag:"h2"}}),lt=new y({props:{code:"ZGVmJTIwYWRkX3N1Z2dlc3Rpb25zKHJlY29yZCklM0ElMEElMjAlMjAlMjAlMjBzdWdnZXN0aW9ucyUyMCUzRCUyMCU1QiU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGdldCUyMGxhYmVsJTIwd2l0aCUyMG1heCUyMHNjb3JlJTIwZm9yJTIwc2VudGltZW50JTIwcXVlc3Rpb24lMEElMjAlMjAlMjAlMjBzZW50aW1lbnQlMjAlM0QlMjBtYXgocmVjb3JkJTVCJTIyc2VudGltZW50JTIyJTVEJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMHglNUIlMjJzY29yZSUyMiU1RCklNUIlMjJsYWJlbCUyMiU1RCUwQSUyMCUyMCUyMCUyMHN1Z2dlc3Rpb25zLmFwcGVuZCglN0IlMjJxdWVzdGlvbl9uYW1lJTIyJTNBJTIwJTIyc2VudGltZW50JTIyJTJDJTIwJTIydmFsdWUlMjIlM0ElMjBzZW50aW1lbnQlN0QpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwZ2V0JTIwYWxsJTIwbGFiZWxzJTIwYWJvdmUlMjBhJTIwdGhyZXNob2xkJTIwZm9yJTIwdG9waWNzJTIwcXVlc3Rpb25zJTBBJTIwJTIwJTIwJTIwdGhyZXNob2xkJTIwJTNEJTIwMiUyMCUyRiUyMGxlbihkYXRhc2V0LnF1ZXN0aW9uX2J5X25hbWUoJTIydG9waWNzJTIyKS5sYWJlbHMpJTBBJTIwJTIwJTIwJTIwdG9waWNzJTIwJTNEJTIwJTVCbGFiZWwlNUIlMjJsYWJlbCUyMiU1RCUyMGZvciUyMGxhYmVsJTIwaW4lMjByZWNvcmQlNUIlMjJ0b3BpY3MlMjIlNUQlMjBpZiUyMGxhYmVsJTVCJTIyc2NvcmUlMjIlNUQlMjAlM0UlM0QlMjB0aHJlc2hvbGQlNUQlMEElMjAlMjAlMjAlMjAlMjMlMjBhcHBseSUyMHRoZSUyMHN1Z2dlc3Rpb24lMjBvbmx5JTIwaWYlMjBhdCUyMGxlYXN0JTIwb25lJTIwbGFiZWwlMjB3YXMlMjBvdmVyJTIwdGhlJTIwdGhyZXNob2xkJTBBJTIwJTIwJTIwJTIwaWYlMjB0b3BpY3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdWdnZXN0aW9ucy5hcHBlbmQoJTdCJTIycXVlc3Rpb25fbmFtZSUyMiUzQSUyMCUyMnRvcGljcyUyMiUyQyUyMCUyMnZhbHVlJTIyJTNBJTIwdG9waWNzJTdEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHN1Z2dlc3Rpb25z",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_suggestions</span>(<span class="hljs-params">record</span>):
    suggestions = []

    <span class="hljs-comment"># get label with max score for sentiment question</span>
    sentiment = <span class="hljs-built_in">max</span>(record[<span class="hljs-string">&quot;sentiment&quot;</span>], key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;score&quot;</span>])[<span class="hljs-string">&quot;label&quot;</span>]
    suggestions.append({<span class="hljs-string">&quot;question_name&quot;</span>: <span class="hljs-string">&quot;sentiment&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: sentiment})

    <span class="hljs-comment"># get all labels above a threshold for topics questions</span>
    threshold = <span class="hljs-number">2</span> / <span class="hljs-built_in">len</span>(dataset.question_by_name(<span class="hljs-string">&quot;topics&quot;</span>).labels)
    topics = [label[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> record[<span class="hljs-string">&quot;topics&quot;</span>] <span class="hljs-keyword">if</span> label[<span class="hljs-string">&quot;score&quot;</span>] &gt;= threshold]
    <span class="hljs-comment"># apply the suggestion only if at least one label was over the threshold</span>
    <span class="hljs-keyword">if</span> topics:
        suggestions.append({<span class="hljs-string">&quot;question_name&quot;</span>: <span class="hljs-string">&quot;topics&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: topics})
    <span class="hljs-keyword">return</span> suggestions`,wrap:!1}}),st=new y({props:{code:"cmVjb3JkcyUyMCUzRCUyMCU1QnJnLkZlZWRiYWNrUmVjb3JkKGZpZWxkcyUzRCU3QiUyMnRleHQlMjIlM0ElMjByZWNvcmQlNUIlMjJ0ZXh0JTIyJTVEJTdEJTJDJTIwc3VnZ2VzdGlvbnMlM0RhZGRfc3VnZ2VzdGlvbnMocmVjb3JkKSklMjBmb3IlMjByZWNvcmQlMjBpbiUyMGRhdGElNUQ=",highlighted:'records = [rg.FeedbackRecord(fields={<span class="hljs-string">&quot;text&quot;</span>: record[<span class="hljs-string">&quot;text&quot;</span>]}, suggestions=add_suggestions(record)) <span class="hljs-keyword">for</span> record <span class="hljs-keyword">in</span> data]',wrap:!1}}),nt=new y({props:{code:"ZGF0YXNldC5hZGRfcmVjb3JkcyhyZWNvcmRzKQ==",highlighted:"dataset.add_records(records)",wrap:!1}}),it=new y({props:{code:"ZGF0YXNldC5wdXNoX3RvX2FyZ2lsbGEoJTIyc2V0Zml0X3R1dG9yaWFsJTIyJTJDJTIwd29ya3NwYWNlJTNEJTIyYWRtaW4lMjIp",highlighted:'dataset.push_to_argilla(<span class="hljs-string">&quot;setfit_tutorial&quot;</span>, workspace=<span class="hljs-string">&quot;admin&quot;</span>)',wrap:!1}}),rt=new y({props:{code:"JTIzJTIwUHVzaCUyMHRvJTIwSHVnZ2luZ0ZhY2UlMjBIdWIlMEFkYXRhc2V0LnB1c2hfdG9faHVnZ2luZ2ZhY2UoJTIyYXJnaWxsYSUyRm15LWRhdGFzZXQlMjIpJTBBJTBBJTIzJTIwTG9hZCUyMGElMjBwdWJsaWMlMjBkYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMHJnLkZlZWRiYWNrRGF0YXNldC5mcm9tX2h1Z2dpbmdmYWNlKCUyMmFyZ2lsbGElMkZteS1kYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-comment"># Push to HuggingFace Hub</span>
dataset.push_to_huggingface(<span class="hljs-string">&quot;argilla/my-dataset&quot;</span>)

<span class="hljs-comment"># Load a public dataset</span>
dataset = rg.FeedbackDataset.from_huggingface(<span class="hljs-string">&quot;argilla/my-dataset&quot;</span>)`,wrap:!1}}),dt=new mt({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),yt=new nl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/labelling_feedback_setfit.md"}}),{c(){m=i("meta"),Tt=a(),wt=i("p"),Ut=a(),M(T.$$.fragment),ft=a(),M(U.$$.fragment),bt=a(),f=i("p"),f.innerHTML=je,jt=a(),b=i("p"),b.innerHTML=ge,gt=a(),j=i("p"),j.innerHTML=Ie,It=a(),g=i("p"),g.textContent=Ce,Ct=a(),I=i("p"),I.textContent=$e,$t=a(),C=i("ul"),C.innerHTML=Ze,Zt=a(),$=i("p"),$.textContent=Ge,Gt=a(),M(Z.$$.fragment),kt=a(),G=i("p"),G.innerHTML=ke,Wt=a(),k=i("ol"),k.innerHTML=We,Bt=a(),M(W.$$.fragment),vt=a(),w=i("ol"),w.innerHTML=Be,Rt=a(),M(B.$$.fragment),_t=a(),J=i("ol"),J.innerHTML=ve,qt=a(),M(v.$$.fragment),Vt=a(),R=i("p"),R.innerHTML=Re,Ft=a(),M(_.$$.fragment),Nt=a(),M(q.$$.fragment),xt=a(),V=i("p"),V.innerHTML=_e,Ht=a(),M(F.$$.fragment),Yt=a(),N=i("p"),N.innerHTML=qe,Xt=a(),x=i("blockquote"),x.innerHTML=Ve,St=a(),H=i("p"),H.textContent=Fe,At=a(),M(Y.$$.fragment),zt=a(),M(X.$$.fragment),Et=a(),S=i("p"),S.innerHTML=Ne,Qt=a(),M(A.$$.fragment),Lt=a(),M(z.$$.fragment),Dt=a(),M(E.$$.fragment),Kt=a(),M(Q.$$.fragment),Pt=a(),L=i("p"),L.textContent=xe,Ot=a(),M(D.$$.fragment),te=a(),M(K.$$.fragment),ee=a(),M(P.$$.fragment),le=a(),M(O.$$.fragment),se=a(),tt=i("p"),tt.innerHTML=He,ae=a(),et=i("blockquote"),et.innerHTML=Ye,ne=a(),M(lt.$$.fragment),ie=a(),M(st.$$.fragment),oe=a(),at=i("p"),at.textContent=Xe,pe=a(),M(nt.$$.fragment),Me=a(),M(it.$$.fragment),re=a(),ot=i("p"),ot.textContent=Se,de=a(),pt=i("p"),pt.innerHTML=Ae,ce=a(),Mt=i("p"),Mt.innerHTML=ze,ue=a(),M(rt.$$.fragment),he=a(),M(dt.$$.fragment),ye=a(),ct=i("p"),ct.textContent=Ee,me=a(),ut=i("p"),ut.textContent=Qe,we=a(),ht=i("ul"),ht.innerHTML=Le,Je=a(),M(yt.$$.fragment),Te=a(),Jt=i("p"),this.h()},l(t){const e=ll("svelte-u9bgzb",document.head);m=o(e,"META",{name:!0,content:!0}),e.forEach(l),Tt=n(t),wt=o(t,"P",{}),De(wt).forEach(l),Ut=n(t),r(T.$$.fragment,t),ft=n(t),r(U.$$.fragment,t),bt=n(t),f=o(t,"P",{"data-svelte-h":!0}),p(f)!=="svelte-gisfdz"&&(f.innerHTML=je),jt=n(t),b=o(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1dz42to"&&(b.innerHTML=ge),gt=n(t),j=o(t,"P",{"data-svelte-h":!0}),p(j)!=="svelte-21fq77"&&(j.innerHTML=Ie),It=n(t),g=o(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-atsz3u"&&(g.textContent=Ce),Ct=n(t),I=o(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-r5bgoa"&&(I.textContent=$e),$t=n(t),C=o(t,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-16uywrv"&&(C.innerHTML=Ze),Zt=n(t),$=o(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-4b3xjd"&&($.textContent=Ge),Gt=n(t),r(Z.$$.fragment,t),kt=n(t),G=o(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1hkgjtm"&&(G.innerHTML=ke),Wt=n(t),k=o(t,"OL",{"data-svelte-h":!0}),p(k)!=="svelte-1qu2uq8"&&(k.innerHTML=We),Bt=n(t),r(W.$$.fragment,t),vt=n(t),w=o(t,"OL",{start:!0,"data-svelte-h":!0}),p(w)!=="svelte-1y23822"&&(w.innerHTML=Be),Rt=n(t),r(B.$$.fragment,t),_t=n(t),J=o(t,"OL",{start:!0,"data-svelte-h":!0}),p(J)!=="svelte-11nyzgu"&&(J.innerHTML=ve),qt=n(t),r(v.$$.fragment,t),Vt=n(t),R=o(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-4j07p0"&&(R.innerHTML=Re),Ft=n(t),r(_.$$.fragment,t),Nt=n(t),r(q.$$.fragment,t),xt=n(t),V=o(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-vlotaw"&&(V.innerHTML=_e),Ht=n(t),r(F.$$.fragment,t),Yt=n(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-atufst"&&(N.innerHTML=qe),Xt=n(t),x=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),p(x)!=="svelte-18sj5fs"&&(x.innerHTML=Ve),St=n(t),H=o(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1k9g5h3"&&(H.textContent=Fe),At=n(t),r(Y.$$.fragment,t),zt=n(t),r(X.$$.fragment,t),Et=n(t),S=o(t,"P",{"data-svelte-h":!0}),p(S)!=="svelte-11ucwkl"&&(S.innerHTML=Ne),Qt=n(t),r(A.$$.fragment,t),Lt=n(t),r(z.$$.fragment,t),Dt=n(t),r(E.$$.fragment,t),Kt=n(t),r(Q.$$.fragment,t),Pt=n(t),L=o(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-16dkxgg"&&(L.textContent=xe),Ot=n(t),r(D.$$.fragment,t),te=n(t),r(K.$$.fragment,t),ee=n(t),r(P.$$.fragment,t),le=n(t),r(O.$$.fragment,t),se=n(t),tt=o(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-48tsq2"&&(tt.innerHTML=He),ae=n(t),et=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),p(et)!=="svelte-1czb8wa"&&(et.innerHTML=Ye),ne=n(t),r(lt.$$.fragment,t),ie=n(t),r(st.$$.fragment,t),oe=n(t),at=o(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1w71etx"&&(at.textContent=Xe),pe=n(t),r(nt.$$.fragment,t),Me=n(t),r(it.$$.fragment,t),re=n(t),ot=o(t,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-st0f7l"&&(ot.textContent=Se),de=n(t),pt=o(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-v1akw9"&&(pt.innerHTML=Ae),ce=n(t),Mt=o(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-1usvkct"&&(Mt.innerHTML=ze),ue=n(t),r(rt.$$.fragment,t),he=n(t),r(dt.$$.fragment,t),ye=n(t),ct=o(t,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-1o4v66q"&&(ct.textContent=Ee),me=n(t),ut=o(t,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-qybims"&&(ut.textContent=Qe),we=n(t),ht=o(t,"UL",{"data-svelte-h":!0}),p(ht)!=="svelte-1wx6c4r"&&(ht.innerHTML=Le),Je=n(t),r(yt.$$.fragment,t),Te=n(t),Jt=o(t,"P",{}),De(Jt).forEach(l),this.h()},h(){fe(m,"name","hf:doc:metadata"),fe(m,"content",ol),fe(w,"start","2"),fe(J,"start","3")},m(t,e){sl(document.head,m),s(t,Tt,e),s(t,wt,e),s(t,Ut,e),d(T,t,e),s(t,ft,e),d(U,t,e),s(t,bt,e),s(t,f,e),s(t,jt,e),s(t,b,e),s(t,gt,e),s(t,j,e),s(t,It,e),s(t,g,e),s(t,Ct,e),s(t,I,e),s(t,$t,e),s(t,C,e),s(t,Zt,e),s(t,$,e),s(t,Gt,e),d(Z,t,e),s(t,kt,e),s(t,G,e),s(t,Wt,e),s(t,k,e),s(t,Bt,e),d(W,t,e),s(t,vt,e),s(t,w,e),s(t,Rt,e),d(B,t,e),s(t,_t,e),s(t,J,e),s(t,qt,e),d(v,t,e),s(t,Vt,e),s(t,R,e),s(t,Ft,e),d(_,t,e),s(t,Nt,e),d(q,t,e),s(t,xt,e),s(t,V,e),s(t,Ht,e),d(F,t,e),s(t,Yt,e),s(t,N,e),s(t,Xt,e),s(t,x,e),s(t,St,e),s(t,H,e),s(t,At,e),d(Y,t,e),s(t,zt,e),d(X,t,e),s(t,Et,e),s(t,S,e),s(t,Qt,e),d(A,t,e),s(t,Lt,e),d(z,t,e),s(t,Dt,e),d(E,t,e),s(t,Kt,e),d(Q,t,e),s(t,Pt,e),s(t,L,e),s(t,Ot,e),d(D,t,e),s(t,te,e),d(K,t,e),s(t,ee,e),d(P,t,e),s(t,le,e),d(O,t,e),s(t,se,e),s(t,tt,e),s(t,ae,e),s(t,et,e),s(t,ne,e),d(lt,t,e),s(t,ie,e),d(st,t,e),s(t,oe,e),s(t,at,e),s(t,pe,e),d(nt,t,e),s(t,Me,e),d(it,t,e),s(t,re,e),s(t,ot,e),s(t,de,e),s(t,pt,e),s(t,ce,e),s(t,Mt,e),s(t,ue,e),d(rt,t,e),s(t,he,e),d(dt,t,e),s(t,ye,e),s(t,ct,e),s(t,me,e),s(t,ut,e),s(t,we,e),s(t,ht,e),s(t,Je,e),d(yt,t,e),s(t,Te,e),s(t,Jt,e),Ue=!0},p:Pe,i(t){Ue||(c(T.$$.fragment,t),c(U.$$.fragment,t),c(Z.$$.fragment,t),c(W.$$.fragment,t),c(B.$$.fragment,t),c(v.$$.fragment,t),c(_.$$.fragment,t),c(q.$$.fragment,t),c(F.$$.fragment,t),c(Y.$$.fragment,t),c(X.$$.fragment,t),c(A.$$.fragment,t),c(z.$$.fragment,t),c(E.$$.fragment,t),c(Q.$$.fragment,t),c(D.$$.fragment,t),c(K.$$.fragment,t),c(P.$$.fragment,t),c(O.$$.fragment,t),c(lt.$$.fragment,t),c(st.$$.fragment,t),c(nt.$$.fragment,t),c(it.$$.fragment,t),c(rt.$$.fragment,t),c(dt.$$.fragment,t),c(yt.$$.fragment,t),Ue=!0)},o(t){u(T.$$.fragment,t),u(U.$$.fragment,t),u(Z.$$.fragment,t),u(W.$$.fragment,t),u(B.$$.fragment,t),u(v.$$.fragment,t),u(_.$$.fragment,t),u(q.$$.fragment,t),u(F.$$.fragment,t),u(Y.$$.fragment,t),u(X.$$.fragment,t),u(A.$$.fragment,t),u(z.$$.fragment,t),u(E.$$.fragment,t),u(Q.$$.fragment,t),u(D.$$.fragment,t),u(K.$$.fragment,t),u(P.$$.fragment,t),u(O.$$.fragment,t),u(lt.$$.fragment,t),u(st.$$.fragment,t),u(nt.$$.fragment,t),u(it.$$.fragment,t),u(rt.$$.fragment,t),u(dt.$$.fragment,t),u(yt.$$.fragment,t),Ue=!1},d(t){t&&(l(Tt),l(wt),l(Ut),l(ft),l(bt),l(f),l(jt),l(b),l(gt),l(j),l(It),l(g),l(Ct),l(I),l($t),l(C),l(Zt),l($),l(Gt),l(kt),l(G),l(Wt),l(k),l(Bt),l(vt),l(w),l(Rt),l(_t),l(J),l(qt),l(Vt),l(R),l(Ft),l(Nt),l(xt),l(V),l(Ht),l(Yt),l(N),l(Xt),l(x),l(St),l(H),l(At),l(zt),l(Et),l(S),l(Qt),l(Lt),l(Dt),l(Kt),l(Pt),l(L),l(Ot),l(te),l(ee),l(le),l(se),l(tt),l(ae),l(et),l(ne),l(ie),l(oe),l(at),l(pe),l(Me),l(re),l(ot),l(de),l(pt),l(ce),l(Mt),l(ue),l(he),l(ye),l(ct),l(me),l(ut),l(we),l(ht),l(Je),l(Te),l(Jt)),l(m),h(T,t),h(U,t),h(Z,t),h(W,t),h(B,t),h(v,t),h(_,t),h(q,t),h(F,t),h(Y,t),h(X,t),h(A,t),h(z,t),h(E,t),h(Q,t),h(D,t),h(K,t),h(P,t),h(O,t),h(lt,t),h(st,t),h(nt,t),h(it,t),h(rt,t),h(dt,t),h(yt,t)}}}const ol='{"title":"Suggestions for Data Annotation with SetFit in Zero-shot Text Classification","local":"suggestions-for-data-annotation-with-setfit-in-zero-shot-text-classification","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Configure the dataset","local":"configure-the-dataset","sections":[],"depth":2},{"title":"Train the models","local":"train-the-models","sections":[],"depth":2},{"title":"Make predictions","local":"make-predictions","sections":[],"depth":2},{"title":"Build records and push","local":"build-records-and-push","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function pl(be){return Oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ul extends tl{constructor(m){super(),el(this,m,pl,il,Ke,{})}}export{ul as component};
