import{s as wl,n as gl,o as Tl}from"../chunks/scheduler.65852ee5.js";import{S as Jl,i as vl,g as i,s,r as p,A as Ul,h as o,f as l,c as a,j as yl,u as m,x as r,k as Ml,y as $l,a as n,v as d,d as u,t as h,w as c}from"../chunks/index.aa74147d.js";import{D as jl,C as b}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as Je,E as xl}from"../chunks/EditOnGithub.4eda6a96.js";function Gl(_t){let f,$e,ve,je,y,xe,M,Ge,w,It='<em>Authored by: <a href="https://github.com/MKhalusova" rel="nofollow">Maria Khalusova</a></em>',ke,g,Ht='This notebook demonstrates how you can quickly build a RAG (Retrieval Augmented Generation) for a project’s GitHub issues using <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a> model, and LangChain.',Ce,T,Rt="<strong>What is RAG?</strong>",Be,J,Wt="RAG is a popular approach to address the issue of a powerful LLM not being aware of specific content due to said content not being in its training data, or hallucinating even when it has seen it before. Such specific content may be proprietary, sensitive, or, as in this example, recent and updated often.",Ze,v,Xt="If your data is static and doesn’t change regularly, you may consider fine-tuning a large model. In many cases, however, fine-tuning can be costly, and, when done repeatedly (e.g. to address data drift), leads to “model shift”. This is when the model’s behavior changes in ways that are not desirable.",_e,U,Nt="<strong>RAG (Retrieval Augmented Generation)</strong> does not require model fine-tuning. Instead, RAG works by providing an LLM with additional context that is retrieved from relevant data so that it can generate a better-informed response.",Ie,$,Vt="Here’s a quick illustration:",He,j,Ft='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/rag-diagram.png" alt="RAG diagram"/>',Re,x,zt="<li><p>The external data is converted into embedding vectors with a separate embeddings model, and the vectors are kept in a database. Embeddings models are typically small, so updating the embedding vectors on a regular basis is faster, cheaper, and easier than fine-tuning a model.</p></li> <li><p>At the same time, the fact that fine-tuning is not required gives you the freedom to swap your LLM for a more powerful one when it becomes available, or switch to a smaller distilled version, should you need faster inference.</p></li>",We,G,Lt="Let’s illustrate building a RAG using an open-source LLM, embeddings model, and LangChain.",Xe,k,St="First, install the required dependencies:",Ne,C,Ve,B,Fe,Z,ze,_,Le,I,qt='In this example, we’ll load all of the issues (both open and closed) from <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT library’s repo</a>.',Se,H,Et='First, you need to acquire a <a href="https://github.com/settings/tokens?type=beta" rel="nofollow">GitHub personal access token</a> to access the GitHub API.',qe,R,Ee,W,Qt='Next, we’ll load all of the issues in the <a href="https://github.com/huggingface/peft" rel="nofollow">huggingface/peft</a> repo:',Qe,X,At="<li>By default, pull requests are considered issues as well, here we chose to exclude them from data with by setting <code>include_prs=False</code></li> <li>Setting <code>state = &quot;all&quot;</code> means we will load both open and closed issues.</li>",Ae,N,Ye,V,Yt="The content of individual GitHub issues may be longer than what an embedding model can take as input. If we want to embed all of the available content, we need to chunk the documents into appropriately sized pieces.",Pe,F,Pt='The most common and straightforward approach to chunking is to define a fixed size of chunks and whether there should be any overlap between them. Keeping some overlap between chunks allows us to preserve some semantic context between the chunks. The recommended splitter for generic text is the <a href="https://python.langchain.com/docs/modules/data_connection/document_transformers/recursive_text_splitter" rel="nofollow">RecursiveCharacterTextSplitter</a>, and that’s what we’ll use here.',De,z,Ke,L,Oe,S,Dt="Now that the docs are all of the appropriate size, we can create a database with their embeddings.",et,q,Kt='To create document chunk embeddings we’ll use the <code>HuggingFaceEmbeddings</code> and the <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-base-en-v1.5</code></a> embeddings model. There are many other embeddings models available on the Hub, and you can keep an eye on the best performing ones by checking the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">Massive Text Embedding Benchmark (MTEB) Leaderboard</a>.',tt,E,Ot="To create the vector database, we’ll use <code>FAISS</code>, a library developed by Facebook AI. This library offers efficient similarity search and clustering of dense vectors, which is what we need here. FAISS is currently one of the most used libraries for NN search in massive datasets.",lt,Q,el="We’ll access both the embeddings model and FAISS via LangChain API.",nt,A,st,Y,tl="We need a way to return(retrieve) the documents given an unstructured query. For that, we’ll use the <code>as_retriever</code> method using the <code>db</code> as a backbone:",at,P,ll="<li><code>search_type=&quot;similarity&quot;</code> means we want to perform similarity search between the query and documents</li> <li><code>search_kwargs={&#39;k&#39;: 4}</code> instructs the retriever to return top 4 results.</li>",it,D,ot,K,nl="The vector database and retriever are now set up, next we need to set up the next piece of the chain - the model.",rt,O,pt,ee,sl='For this example, we chose <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a>, a small but powerful model.',mt,te,al='With many models being released every week, you may want to substitute this model to the latest and greatest. The best way to keep track of open source LLMs is to check the <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open-source LLM leaderboard</a>.',dt,le,il="To make inference faster, we will load the quantized version of the model:",ut,ne,ht,se,ct,ae,ol="Finally, we have all the pieces we need to set up the LLM chain.",bt,ie,rl="First, create a text_generation pipeline using the loaded model and its tokenizer.",ft,oe,pl="Next, create a prompt template - this should follow the format of the model, so if you substitute the model checkpoint, make sure to use the appropriate formatting.",yt,re,Mt,pe,ml="Note: <em>You can also use <code>tokenizer.apply_chat_template</code> to convert a list of messages (as dicts: <code>{&#39;role&#39;: &#39;user&#39;, &#39;content&#39;: &#39;(...)&#39;}</code>) into a string with the appropriate chat format.</em>",wt,me,dl="Finally, we need to combine the <code>llm_chain</code> with the retriever to create a RAG chain. We pass the original question through to the final generation step, as well as the retrieved context docs:",gt,de,Tt,ue,Jt,he,ul="Let’s see the difference RAG makes in generating answers to the library-specific questions.",vt,ce,Ut,be,hl="First, let’s see what kind of answer we can get with just the model itself, no context added:",$t,fe,jt,ye,cl=`As you can see, the model interpreted the question as one about physical computer adapters, while in the context of PEFT, “adapters” refer to LoRA adapters.
Let’s see if adding context from GitHub issues helps the model give a more relevant answer:`,xt,Me,Gt,we,bl="As we can see, the added context, really helps the exact same model, provide a much more relevant and informed answer to the library-specific question.",kt,ge,fl="Notably, combining multiple adapters for inference has been added to the library, and one can find this information in the documentation, so for the next iteration of this RAG it may be worth including documentation embeddings.",Ct,Te,Bt,Ue,Zt;return y=new jl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/fix-broken-link/notebooks/en/rag_zephyr_langchain.ipynb"}]}}),M=new Je({props:{title:"Simple RAG for GitHub issues using Hugging Face Zephyr and LangChain",local:"simple-rag-for-github-issues-using-hugging-face-zephyr-and-langchain",headingTag:"h1"}}),C=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMHRyYW5zZm9ybWVycyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWdwdQ==",highlighted:"!pip install -q torch transformers accelerate bitsandbytes transformers sentence-transformers faiss-gpu",wrap:!1}}),B=new b({props:{code:"JTIzJTIwSWYlMjBydW5uaW5nJTIwaW4lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMG1heSUyMG5lZWQlMjB0byUyMHJ1biUyMHRoaXMlMjBjZWxsJTIwdG8lMjBtYWtlJTIwc3VyZSUyMHlvdSdyZSUyMHVzaW5nJTIwVVRGLTglMjBsb2NhbGUlMjB0byUyMGluc3RhbGwlMjBMYW5nQ2hhaW4lMEFpbXBvcnQlMjBsb2NhbGUlMEElMEFsb2NhbGUuZ2V0cHJlZmVycmVkZW5jb2RpbmclMjAlM0QlMjBsYW1iZGElM0ElMjAlMjJVVEYtOCUyMg==",highlighted:`<span class="hljs-comment"># If running in Google Colab, you may need to run this cell to make sure you&#x27;re using UTF-8 locale to install LangChain</span>
<span class="hljs-keyword">import</span> locale

locale.getpreferredencoding = <span class="hljs-keyword">lambda</span>: <span class="hljs-string">&quot;UTF-8&quot;</span>`,wrap:!1}}),Z=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGxhbmdjaGFpbiUyMGxhbmdjaGFpbi1jb21tdW5pdHk=",highlighted:"!pip install -q langchain langchain-community",wrap:!1}}),_=new Je({props:{title:"Prepare the data",local:"prepare-the-data",headingTag:"h2"}}),R=new b({props:{code:"ZnJvbSUyMGdldHBhc3MlMjBpbXBvcnQlMjBnZXRwYXNzJTBBJTBBQUNDRVNTX1RPS0VOJTIwJTNEJTIwZ2V0cGFzcyglMjJZT1VSX0dJVEhVQl9QRVJTT05BTF9UT0tFTiUyMik=",highlighted:`<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass

ACCESS_TOKEN = getpass(<span class="hljs-string">&quot;YOUR_GITHUB_PERSONAL_TOKEN&quot;</span>)`,wrap:!1}}),N=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2N1bWVudF9sb2FkZXJzJTIwaW1wb3J0JTIwR2l0SHViSXNzdWVzTG9hZGVyJTBBJTBBbG9hZGVyJTIwJTNEJTIwR2l0SHViSXNzdWVzTG9hZGVyKHJlcG8lM0QlMjJodWdnaW5nZmFjZSUyRnBlZnQlMjIlMkMlMjBhY2Nlc3NfdG9rZW4lM0RBQ0NFU1NfVE9LRU4lMkMlMjBpbmNsdWRlX3BycyUzREZhbHNlJTJDJTIwc3RhdGUlM0QlMjJhbGwlMjIpJTBBJTBBZG9jcyUyMCUzRCUyMGxvYWRlci5sb2FkKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.document_loaders <span class="hljs-keyword">import</span> GitHubIssuesLoader

loader = GitHubIssuesLoader(repo=<span class="hljs-string">&quot;huggingface/peft&quot;</span>, access_token=ACCESS_TOKEN, include_prs=<span class="hljs-literal">False</span>, state=<span class="hljs-string">&quot;all&quot;</span>)

docs = loader.load()`,wrap:!1}}),z=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUxMiUyQyUyMGNodW5rX292ZXJsYXAlM0QzMCklMEElMEFjaHVua2VkX2RvY3MlMjAlM0QlMjBzcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoZG9jcyk=",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter

splitter = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">30</span>)

chunked_docs = splitter.split_documents(docs)`,wrap:!1}}),L=new Je({props:{title:"Create the embeddings + retriever",local:"create-the-embeddings--retriever",headingTag:"h2"}}),A=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW4uZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyUwQSUwQWRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoY2h1bmtlZF9kb2NzJTJDJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLWJhc2UtZW4tdjEuNSUyMikp",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

db = FAISS.from_documents(chunked_docs, HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-base-en-v1.5&quot;</span>))`,wrap:!1}}),D=new b({props:{code:"cmV0cmlldmVyJTIwJTNEJTIwZGIuYXNfcmV0cmlldmVyKHNlYXJjaF90eXBlJTNEJTIyc2ltaWxhcml0eSUyMiUyQyUyMHNlYXJjaF9rd2FyZ3MlM0QlN0IlMjJrJTIyJTNBJTIwNCU3RCk=",highlighted:'retriever = db.as_retriever(search_type=<span class="hljs-string">&quot;similarity&quot;</span>, search_kwargs={<span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">4</span>})',wrap:!1}}),O=new Je({props:{title:"Load quantized model",local:"load-quantized-model",headingTag:"h2"}}),ne=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiUwQSUwQWJuYl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9jb25maWcpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>, bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(model_name)`,wrap:!1}}),se=new Je({props:{title:"Setup the LLM chain",local:"setup-the-llm-chain",headingTag:"h2"}}),re=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5sbG1zJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VQaXBlbGluZSUwQWZyb20lMjBsYW5nY2hhaW4ucHJvbXB0cyUyMGltcG9ydCUyMFByb21wdFRlbXBsYXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm91dHB1dF9wYXJzZXJzJTIwaW1wb3J0JTIwU3RyT3V0cHV0UGFyc2VyJTBBJTBBdGV4dF9nZW5lcmF0aW9uX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDAwJTJDJTBBKSUwQSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlUGlwZWxpbmUocGlwZWxpbmUlM0R0ZXh0X2dlbmVyYXRpb25fcGlwZWxpbmUpJTBBJTBBcHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIyJTIyJTBBJTNDJTdDc3lzdGVtJTdDJTNFJTBBQW5zd2VyJTIwdGhlJTIwcXVlc3Rpb24lMjBiYXNlZCUyMG9uJTIweW91ciUyMGtub3dsZWRnZS4lMjBVc2UlMjB0aGUlMjBmb2xsb3dpbmclMjBjb250ZXh0JTIwdG8lMjBoZWxwJTNBJTBBJTBBJTdCY29udGV4dCU3RCUwQSUwQSUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBJTdCcXVlc3Rpb24lN0QlMEElM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBJTBBJTIwJTIyJTIyJTIyJTBBJTBBcHJvbXB0JTIwJTNEJTIwUHJvbXB0VGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwaW5wdXRfdmFyaWFibGVzJTNEJTVCJTIyY29udGV4dCUyMiUyQyUyMCUyMnF1ZXN0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGxhdGUlM0Rwcm9tcHRfdGVtcGxhdGUlMkMlMEEpJTBBJTBBbGxtX2NoYWluJTIwJTNEJTIwcHJvbXB0JTIwJTdDJTIwbGxtJTIwJTdDJTIwU3RyT3V0cHV0UGFyc2VyKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.llms <span class="hljs-keyword">import</span> HuggingFacePipeline
<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> PromptTemplate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> langchain_core.output_parsers <span class="hljs-keyword">import</span> StrOutputParser

text_generation_pipeline = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    temperature=<span class="hljs-number">0.2</span>,
    do_sample=<span class="hljs-literal">True</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">True</span>,
    max_new_tokens=<span class="hljs-number">400</span>,
)

llm = HuggingFacePipeline(pipeline=text_generation_pipeline)

prompt_template = <span class="hljs-string">&quot;&quot;&quot;
&lt;|system|&gt;
Answer the question based on your knowledge. Use the following context to help:

{context}

&lt;/s&gt;
&lt;|user|&gt;
{question}
&lt;/s&gt;
&lt;|assistant|&gt;

 &quot;&quot;&quot;</span>

prompt = PromptTemplate(
    input_variables=[<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>],
    template=prompt_template,
)

llm_chain = prompt | llm | StrOutputParser()`,wrap:!1}}),de=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb3JlLnJ1bm5hYmxlcyUyMGltcG9ydCUyMFJ1bm5hYmxlUGFzc3Rocm91Z2glMEElMEFyZXRyaWV2ZXIlMjAlM0QlMjBkYi5hc19yZXRyaWV2ZXIoKSUwQSUwQXJhZ19jaGFpbiUyMCUzRCUyMCU3QiUyMmNvbnRleHQlMjIlM0ElMjByZXRyaWV2ZXIlMkMlMjAlMjJxdWVzdGlvbiUyMiUzQSUyMFJ1bm5hYmxlUGFzc3Rocm91Z2goKSU3RCUyMCU3QyUyMGxsbV9jaGFpbg==",highlighted:`<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnablePassthrough

retriever = db.as_retriever()

rag_chain = {<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()} | llm_chain`,wrap:!1}}),ue=new Je({props:{title:"Compare the results",local:"compare-the-results",headingTag:"h2"}}),ce=new b({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJIb3clMjBkbyUyMHlvdSUyMGNvbWJpbmUlMjBtdWx0aXBsZSUyMGFkYXB0ZXJzJTNGJTIy",highlighted:'question = <span class="hljs-string">&quot;How do you combine multiple adapters?&quot;</span>',wrap:!1}}),fe=new b({props:{code:"bGxtX2NoYWluLmludm9rZSglN0IlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBxdWVzdGlvbiU3RCk=",highlighted:'llm_chain.invoke({<span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>: question})',wrap:!1}}),Me=new b({props:{code:"cmFnX2NoYWluLmludm9rZShxdWVzdGlvbik=",highlighted:"rag_chain.invoke(question)",wrap:!1}}),Te=new xl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_zephyr_langchain.md"}}),{c(){f=i("meta"),$e=s(),ve=i("p"),je=s(),p(y.$$.fragment),xe=s(),p(M.$$.fragment),Ge=s(),w=i("p"),w.innerHTML=It,ke=s(),g=i("p"),g.innerHTML=Ht,Ce=s(),T=i("p"),T.innerHTML=Rt,Be=s(),J=i("p"),J.textContent=Wt,Ze=s(),v=i("p"),v.textContent=Xt,_e=s(),U=i("p"),U.innerHTML=Nt,Ie=s(),$=i("p"),$.textContent=Vt,He=s(),j=i("p"),j.innerHTML=Ft,Re=s(),x=i("ul"),x.innerHTML=zt,We=s(),G=i("p"),G.textContent=Lt,Xe=s(),k=i("p"),k.textContent=St,Ne=s(),p(C.$$.fragment),Ve=s(),p(B.$$.fragment),Fe=s(),p(Z.$$.fragment),ze=s(),p(_.$$.fragment),Le=s(),I=i("p"),I.innerHTML=qt,Se=s(),H=i("p"),H.innerHTML=Et,qe=s(),p(R.$$.fragment),Ee=s(),W=i("p"),W.innerHTML=Qt,Qe=s(),X=i("ul"),X.innerHTML=At,Ae=s(),p(N.$$.fragment),Ye=s(),V=i("p"),V.textContent=Yt,Pe=s(),F=i("p"),F.innerHTML=Pt,De=s(),p(z.$$.fragment),Ke=s(),p(L.$$.fragment),Oe=s(),S=i("p"),S.textContent=Dt,et=s(),q=i("p"),q.innerHTML=Kt,tt=s(),E=i("p"),E.innerHTML=Ot,lt=s(),Q=i("p"),Q.textContent=el,nt=s(),p(A.$$.fragment),st=s(),Y=i("p"),Y.innerHTML=tl,at=s(),P=i("ul"),P.innerHTML=ll,it=s(),p(D.$$.fragment),ot=s(),K=i("p"),K.textContent=nl,rt=s(),p(O.$$.fragment),pt=s(),ee=i("p"),ee.innerHTML=sl,mt=s(),te=i("p"),te.innerHTML=al,dt=s(),le=i("p"),le.textContent=il,ut=s(),p(ne.$$.fragment),ht=s(),p(se.$$.fragment),ct=s(),ae=i("p"),ae.textContent=ol,bt=s(),ie=i("p"),ie.textContent=rl,ft=s(),oe=i("p"),oe.textContent=pl,yt=s(),p(re.$$.fragment),Mt=s(),pe=i("p"),pe.innerHTML=ml,wt=s(),me=i("p"),me.innerHTML=dl,gt=s(),p(de.$$.fragment),Tt=s(),p(ue.$$.fragment),Jt=s(),he=i("p"),he.textContent=ul,vt=s(),p(ce.$$.fragment),Ut=s(),be=i("p"),be.textContent=hl,$t=s(),p(fe.$$.fragment),jt=s(),ye=i("p"),ye.textContent=cl,xt=s(),p(Me.$$.fragment),Gt=s(),we=i("p"),we.textContent=bl,kt=s(),ge=i("p"),ge.textContent=fl,Ct=s(),p(Te.$$.fragment),Bt=s(),Ue=i("p"),this.h()},l(e){const t=Ul("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),$e=a(e),ve=o(e,"P",{}),yl(ve).forEach(l),je=a(e),m(y.$$.fragment,e),xe=a(e),m(M.$$.fragment,e),Ge=a(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-26mfp8"&&(w.innerHTML=It),ke=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1ef5fle"&&(g.innerHTML=Ht),Ce=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1ty8bu"&&(T.innerHTML=Rt),Be=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-7wteio"&&(J.textContent=Wt),Ze=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1x9vu2c"&&(v.textContent=Xt),_e=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-14i5lt5"&&(U.innerHTML=Nt),Ie=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-5qqm02"&&($.textContent=Vt),He=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1c1z86r"&&(j.innerHTML=Ft),Re=a(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-8anxeq"&&(x.innerHTML=zt),We=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-r4q734"&&(G.textContent=Lt),Xe=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1f3oki6"&&(k.textContent=St),Ne=a(e),m(C.$$.fragment,e),Ve=a(e),m(B.$$.fragment,e),Fe=a(e),m(Z.$$.fragment,e),ze=a(e),m(_.$$.fragment,e),Le=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1htvfcb"&&(I.innerHTML=qt),Se=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1y7zwpt"&&(H.innerHTML=Et),qe=a(e),m(R.$$.fragment,e),Ee=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1sitgme"&&(W.innerHTML=Qt),Qe=a(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-ktvuvk"&&(X.innerHTML=At),Ae=a(e),m(N.$$.fragment,e),Ye=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-oungvg"&&(V.textContent=Yt),Pe=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-jsadt6"&&(F.innerHTML=Pt),De=a(e),m(z.$$.fragment,e),Ke=a(e),m(L.$$.fragment,e),Oe=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1ng4z3s"&&(S.textContent=Dt),et=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-z63x34"&&(q.innerHTML=Kt),tt=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1hq28ne"&&(E.innerHTML=Ot),lt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1n2sms8"&&(Q.textContent=el),nt=a(e),m(A.$$.fragment,e),st=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-140j4it"&&(Y.innerHTML=tl),at=a(e),P=o(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-hejw60"&&(P.innerHTML=ll),it=a(e),m(D.$$.fragment,e),ot=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-4c9ypi"&&(K.textContent=nl),rt=a(e),m(O.$$.fragment,e),pt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1fynfov"&&(ee.innerHTML=sl),mt=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-gklra8"&&(te.innerHTML=al),dt=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1bs26eu"&&(le.textContent=il),ut=a(e),m(ne.$$.fragment,e),ht=a(e),m(se.$$.fragment,e),ct=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-dvcewb"&&(ae.textContent=ol),bt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-8iwm5k"&&(ie.textContent=rl),ft=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-qz9rvk"&&(oe.textContent=pl),yt=a(e),m(re.$$.fragment,e),Mt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-15zr00j"&&(pe.innerHTML=ml),wt=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1plvon"&&(me.innerHTML=dl),gt=a(e),m(de.$$.fragment,e),Tt=a(e),m(ue.$$.fragment,e),Jt=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1m90it0"&&(he.textContent=ul),vt=a(e),m(ce.$$.fragment,e),Ut=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1m8rs90"&&(be.textContent=hl),$t=a(e),m(fe.$$.fragment,e),jt=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-10i2mx0"&&(ye.textContent=cl),xt=a(e),m(Me.$$.fragment,e),Gt=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1gvzgod"&&(we.textContent=bl),kt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-rlk7jz"&&(ge.textContent=fl),Ct=a(e),m(Te.$$.fragment,e),Bt=a(e),Ue=o(e,"P",{}),yl(Ue).forEach(l),this.h()},h(){Ml(f,"name","hf:doc:metadata"),Ml(f,"content",kl)},m(e,t){$l(document.head,f),n(e,$e,t),n(e,ve,t),n(e,je,t),d(y,e,t),n(e,xe,t),d(M,e,t),n(e,Ge,t),n(e,w,t),n(e,ke,t),n(e,g,t),n(e,Ce,t),n(e,T,t),n(e,Be,t),n(e,J,t),n(e,Ze,t),n(e,v,t),n(e,_e,t),n(e,U,t),n(e,Ie,t),n(e,$,t),n(e,He,t),n(e,j,t),n(e,Re,t),n(e,x,t),n(e,We,t),n(e,G,t),n(e,Xe,t),n(e,k,t),n(e,Ne,t),d(C,e,t),n(e,Ve,t),d(B,e,t),n(e,Fe,t),d(Z,e,t),n(e,ze,t),d(_,e,t),n(e,Le,t),n(e,I,t),n(e,Se,t),n(e,H,t),n(e,qe,t),d(R,e,t),n(e,Ee,t),n(e,W,t),n(e,Qe,t),n(e,X,t),n(e,Ae,t),d(N,e,t),n(e,Ye,t),n(e,V,t),n(e,Pe,t),n(e,F,t),n(e,De,t),d(z,e,t),n(e,Ke,t),d(L,e,t),n(e,Oe,t),n(e,S,t),n(e,et,t),n(e,q,t),n(e,tt,t),n(e,E,t),n(e,lt,t),n(e,Q,t),n(e,nt,t),d(A,e,t),n(e,st,t),n(e,Y,t),n(e,at,t),n(e,P,t),n(e,it,t),d(D,e,t),n(e,ot,t),n(e,K,t),n(e,rt,t),d(O,e,t),n(e,pt,t),n(e,ee,t),n(e,mt,t),n(e,te,t),n(e,dt,t),n(e,le,t),n(e,ut,t),d(ne,e,t),n(e,ht,t),d(se,e,t),n(e,ct,t),n(e,ae,t),n(e,bt,t),n(e,ie,t),n(e,ft,t),n(e,oe,t),n(e,yt,t),d(re,e,t),n(e,Mt,t),n(e,pe,t),n(e,wt,t),n(e,me,t),n(e,gt,t),d(de,e,t),n(e,Tt,t),d(ue,e,t),n(e,Jt,t),n(e,he,t),n(e,vt,t),d(ce,e,t),n(e,Ut,t),n(e,be,t),n(e,$t,t),d(fe,e,t),n(e,jt,t),n(e,ye,t),n(e,xt,t),d(Me,e,t),n(e,Gt,t),n(e,we,t),n(e,kt,t),n(e,ge,t),n(e,Ct,t),d(Te,e,t),n(e,Bt,t),n(e,Ue,t),Zt=!0},p:gl,i(e){Zt||(u(y.$$.fragment,e),u(M.$$.fragment,e),u(C.$$.fragment,e),u(B.$$.fragment,e),u(Z.$$.fragment,e),u(_.$$.fragment,e),u(R.$$.fragment,e),u(N.$$.fragment,e),u(z.$$.fragment,e),u(L.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(ne.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(ce.$$.fragment,e),u(fe.$$.fragment,e),u(Me.$$.fragment,e),u(Te.$$.fragment,e),Zt=!0)},o(e){h(y.$$.fragment,e),h(M.$$.fragment,e),h(C.$$.fragment,e),h(B.$$.fragment,e),h(Z.$$.fragment,e),h(_.$$.fragment,e),h(R.$$.fragment,e),h(N.$$.fragment,e),h(z.$$.fragment,e),h(L.$$.fragment,e),h(A.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(ce.$$.fragment,e),h(fe.$$.fragment,e),h(Me.$$.fragment,e),h(Te.$$.fragment,e),Zt=!1},d(e){e&&(l($e),l(ve),l(je),l(xe),l(Ge),l(w),l(ke),l(g),l(Ce),l(T),l(Be),l(J),l(Ze),l(v),l(_e),l(U),l(Ie),l($),l(He),l(j),l(Re),l(x),l(We),l(G),l(Xe),l(k),l(Ne),l(Ve),l(Fe),l(ze),l(Le),l(I),l(Se),l(H),l(qe),l(Ee),l(W),l(Qe),l(X),l(Ae),l(Ye),l(V),l(Pe),l(F),l(De),l(Ke),l(Oe),l(S),l(et),l(q),l(tt),l(E),l(lt),l(Q),l(nt),l(st),l(Y),l(at),l(P),l(it),l(ot),l(K),l(rt),l(pt),l(ee),l(mt),l(te),l(dt),l(le),l(ut),l(ht),l(ct),l(ae),l(bt),l(ie),l(ft),l(oe),l(yt),l(Mt),l(pe),l(wt),l(me),l(gt),l(Tt),l(Jt),l(he),l(vt),l(Ut),l(be),l($t),l(jt),l(ye),l(xt),l(Gt),l(we),l(kt),l(ge),l(Ct),l(Bt),l(Ue)),l(f),c(y,e),c(M,e),c(C,e),c(B,e),c(Z,e),c(_,e),c(R,e),c(N,e),c(z,e),c(L,e),c(A,e),c(D,e),c(O,e),c(ne,e),c(se,e),c(re,e),c(de,e),c(ue,e),c(ce,e),c(fe,e),c(Me,e),c(Te,e)}}}const kl='{"title":"Simple RAG for GitHub issues using Hugging Face Zephyr and LangChain","local":"simple-rag-for-github-issues-using-hugging-face-zephyr-and-langchain","sections":[{"title":"Prepare the data","local":"prepare-the-data","sections":[],"depth":2},{"title":"Create the embeddings + retriever","local":"create-the-embeddings--retriever","sections":[],"depth":2},{"title":"Load quantized model","local":"load-quantized-model","sections":[],"depth":2},{"title":"Setup the LLM chain","local":"setup-the-llm-chain","sections":[],"depth":2},{"title":"Compare the results","local":"compare-the-results","sections":[],"depth":2}],"depth":1}';function Cl(_t){return Tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hl extends Jl{constructor(f){super(),vl(this,f,Cl,Gl,wl,{})}}export{Hl as component};
