import{s as Ke,o as tl,n as el}from"../chunks/scheduler.f6b352c8.js";import{S as ll,i as nl,g as a,s,r as u,m as Me,A as sl,h as o,f as l,c as i,j as mt,u as c,x as r,n as me,k as $e,y as p,a as n,v as M,d as m,t as d,w as h}from"../chunks/index.b90df637.js";import{T as il}from"../chunks/Tip.366d2e6e.js";import{Y as al}from"../chunks/Youtube.cfd99961.js";import{C as Jt}from"../chunks/CodeBlock.e5718f9d.js";import{H as g,E as ol}from"../chunks/index.46a12c71.js";function rl($t){let y,U="Gradio is a popular Python library for quickly creating customizable web interfaces for machine learning models.";return{c(){y=a("p"),y.textContent=U},l(w){y=o(w,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1fohhj1"&&(y.textContent=U)},m(w,dt){n(w,y,dt)},p:el,d(w){w&&l(y)}}}function pl($t){let y,U,w,dt,I,Ut,b,Ue="We’ve now explored the core concepts of the MCP protocol and how to implement an MCP Servers and Clients. In this section, we’re going to make things slightly easier by using Gradio to create an MCP Server!",It,T,bt,j,jt,x,Ie="Gradio allows developers to create UIs for their models with just a few lines of Python code. It’s particularly useful for:",xt,G,be="<li>Creating demos and prototypes</li> <li>Sharing models with non-technical users</li> <li>Testing and debugging model behavior</li>",Gt,P,je="With the addition of MCP support, Gradio now offers a straightforward way to expose AI model capabilities through the standardized MCP protocol.",Pt,S,xe="Combining Gradio with MCP allows you to create both human-friendly interfaces and AI-accessible tools with minimal code. But best of all, Gradio is already well-used by the AI community, so you can use it to share your MCP Servers with others.",St,B,Bt,_,Ge="To use Gradio with MCP support, you’ll need to install Gradio with the MCP extra:",_t,H,Ht,E,Pe="You’ll also need an LLM application that supports tool calling using the MCP protocol, such as Cursor ( known as “MCP Hosts”).",Et,V,Vt,R,Se="Let’s walk through a basic example of creating an MCP Server using Gradio:",Rt,k,kt,L,Be="With this setup, your letter counter function is now accessible through:",Lt,A,_e="<li>A traditional Gradio web interface for direct human interaction</li> <li>An MCP Server that can be connected to compatible clients</li>",At,q,He="The MCP server will be accessible at:",qt,Q,Qt,W,Ee="The application itself will still be accessible and it looks like this:",Wt,Z,Ve='<img src="https://huggingface.co/datasets/mcp-course/images/resolve/main/unit1/7.png" alt="Gradio MCP Server"/>',Zt,Y,Yt,z,Re="When you set <code>mcp_server=True</code> in <code>launch()</code>, several things happen:",zt,N,ke="<li>Gradio functions are automatically converted to MCP Tools</li> <li>Input components map to tool argument schemas</li> <li>Output components determine the response format</li> <li>The Gradio server now also listens for MCP protocol messages</li> <li>JSON-RPC over HTTP+SSE is set up for client-server communication</li>",Nt,X,Xt,F,Le="<li><p><strong>Tool Conversion</strong>: Each API endpoint in your Gradio app is automatically converted into an MCP tool with a corresponding name, description, and input schema. To view the tools and schemas, visit <code>http://your-server:port/gradio_api/mcp/schema</code> or go to the “View API” link in the footer of your Gradio app, and then click on “MCP”.</p></li> <li><p><strong>Environment Variable Support</strong>: There are two ways to enable the MCP server functionality:</p></li>",Ft,J,C,de,ht,Ae="mcp_server",he,yt,qe="launch()",ye,O,fe,ft,we,D,Ot,v,Qe='<li><p><strong>File Handling</strong>: The server automatically handles file data conversions, including:</p> <ul><li>Converting base64-encoded strings to file data</li> <li>Processing image files and returning them in the correct format</li> <li>Managing temporary file storage</li></ul> <p>It is <strong>strongly</strong> recommended that input images and files be passed as full URLs (“http://…” or “https://…”) as MCP Clients do not always handle local files correctly.</p></li> <li><p><strong>Hosted MCP Servers on 🤗 Spaces</strong>: You can publish your Gradio application for free on Hugging Face Spaces, which will allow you to have a free hosted MCP server. Here’s an example of such a Space: <a href="https://huggingface.co/spaces/abidlabs/mcp-tools" rel="nofollow">https://huggingface.co/spaces/abidlabs/mcp-tools</a></p></li>',Dt,K,Kt,f,wt,We="<p><strong>Type Hints and Docstrings</strong>: Ensure you provide type hints and valid docstrings for your functions. The docstring should include an “Args:” block with indented parameter names.</p>",Ce,Ct,Ze="<p><strong>String Inputs</strong>: When in doubt, accept input arguments as <code>str</code> and convert them to the desired type inside the function.</p>",ge,tt,gt,Ye="<strong>SSE Support</strong>: Some MCP Hosts don’t support SSE-based MCP Servers. In those cases, you can use <code>mcp-remote</code>:",Te,et,Je,Tt,ze="<p><strong>Restart</strong>: If you encounter connection issues, try restarting both your MCP Client and MCP Server.</p>",te,lt,ee,nt,Ne="You can share your MCP Server by publishing your Gradio app to Hugging Face Spaces. The video below shows how to create a Hugging Face Space.",le,st,ne,it,Xe="Now, you can share your MCP Server with others by sharing your Hugging Face Space.",se,at,ie,ot,Fe="Gradio’s integration with MCP provides an accessible entry point to the MCP ecosystem. By leveraging Gradio’s simplicity and adding MCP’s standardization, developers can quickly create both human-friendly interfaces and AI-accessible tools with minimal code.",ae,rt,Oe="As we progress through this course, we’ll explore more sophisticated MCP implementations, but Gradio offers an excellent starting point for understanding and experimenting with the protocol.",oe,pt,De="In the next unit, we’ll dive deeper into building MCP applications, focusing on setting up development environments, exploring SDKs, and implementing more advanced MCP Servers and Clients.",re,ut,pe,vt,ue;return I=new g({props:{title:"Gradio MCP Integration",local:"gradio-mcp-integration",headingTag:"h1"}}),T=new il({props:{$$slots:{default:[rl]},$$scope:{ctx:$t}}}),j=new g({props:{title:"Introduction to Gradio",local:"introduction-to-gradio",headingTag:"h2"}}),B=new g({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),H=new Jt({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMmdyYWRpbyU1Qm1jcCU1RCUyMg==",highlighted:'pip install <span class="hljs-string">&quot;gradio[mcp]&quot;</span>',wrap:!1}}),V=new g({props:{title:"Creating an MCP Server with Gradio",local:"creating-an-mcp-server-with-gradio",headingTag:"h2"}}),k=new Jt({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlZiUyMGxldHRlcl9jb3VudGVyKHdvcmQlM0ElMjBzdHIlMkMlMjBsZXR0ZXIlM0ElMjBzdHIpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMENvdW50JTIwdGhlJTIwbnVtYmVyJTIwb2YlMjBvY2N1cnJlbmNlcyUyMG9mJTIwYSUyMGxldHRlciUyMGluJTIwYSUyMHdvcmQlMjBvciUyMHRleHQuJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdvcmQlMjAoc3RyKSUzQSUyMFRoZSUyMGlucHV0JTIwdGV4dCUyMHRvJTIwc2VhcmNoJTIwdGhyb3VnaCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxldHRlciUyMChzdHIpJTNBJTIwVGhlJTIwbGV0dGVyJTIwdG8lMjBzZWFyY2glMjBmb3IlMEElMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW50JTNBJTIwVGhlJTIwbnVtYmVyJTIwb2YlMjB0aW1lcyUyMHRoZSUyMGxldHRlciUyMGFwcGVhcnMlMjBpbiUyMHRoZSUyMHRleHQlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjB3b3JkJTIwJTNEJTIwd29yZC5sb3dlcigpJTBBJTIwJTIwJTIwJTIwbGV0dGVyJTIwJTNEJTIwbGV0dGVyLmxvd2VyKCklMEElMjAlMjAlMjAlMjBjb3VudCUyMCUzRCUyMHdvcmQuY291bnQobGV0dGVyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNvdW50JTBBJTBBJTIzJTIwQ3JlYXRlJTIwYSUyMHN0YW5kYXJkJTIwR3JhZGlvJTIwaW50ZXJmYWNlJTBBZGVtbyUyMCUzRCUyMGdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRGxldHRlcl9jb3VudGVyJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEJTVCJTIydGV4dGJveCUyMiUyQyUyMCUyMnRleHRib3glMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIybnVtYmVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjJMZXR0ZXIlMjBDb3VudGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJFbnRlciUyMHRleHQlMjBhbmQlMjBhJTIwbGV0dGVyJTIwdG8lMjBjb3VudCUyMGhvdyUyMG1hbnklMjB0aW1lcyUyMHRoZSUyMGxldHRlciUyMGFwcGVhcnMlMjBpbiUyMHRoZSUyMHRleHQuJTIyJTBBKSUwQSUwQSUyMyUyMExhdW5jaCUyMGJvdGglMjB0aGUlMjBHcmFkaW8lMjB3ZWIlMjBpbnRlcmZhY2UlMjBhbmQlMjB0aGUlMjBNQ1AlMjBzZXJ2ZXIlMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBkZW1vLmxhdW5jaChtY3Bfc2VydmVyJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

<span class="hljs-keyword">def</span> <span class="hljs-title function_">letter_counter</span>(<span class="hljs-params">word: <span class="hljs-built_in">str</span>, letter: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Count the number of occurrences of a letter in a word or text.

    Args:
        word (str): The input text to search through
        letter (str): The letter to search for

    Returns:
        int: The number of times the letter appears in the text
    &quot;&quot;&quot;</span>
    word = word.lower()
    letter = letter.lower()
    count = word.count(letter)
    <span class="hljs-keyword">return</span> count

<span class="hljs-comment"># Create a standard Gradio interface</span>
demo = gr.Interface(
    fn=letter_counter,
    inputs=[<span class="hljs-string">&quot;textbox&quot;</span>, <span class="hljs-string">&quot;textbox&quot;</span>],
    outputs=<span class="hljs-string">&quot;number&quot;</span>,
    title=<span class="hljs-string">&quot;Letter Counter&quot;</span>,
    description=<span class="hljs-string">&quot;Enter text and a letter to count how many times the letter appears in the text.&quot;</span>
)

<span class="hljs-comment"># Launch both the Gradio web interface and the MCP server</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    demo.launch(mcp_server=<span class="hljs-literal">True</span>)`,wrap:!1}}),Q=new Jt({props:{code:"aHR0cCUzQSUyRiUyRnlvdXItc2VydmVyJTNBcG9ydCUyRmdyYWRpb19hcGklMkZtY3AlMkZzc2U=",highlighted:'http:<span class="hljs-regexp">//y</span>our-server:port<span class="hljs-regexp">/gradio_api/m</span>cp/sse',wrap:!1}}),Y=new g({props:{title:"How It Works Behind the Scenes",local:"how-it-works-behind-the-scenes",headingTag:"h2"}}),X=new g({props:{title:"Key Features of the Gradio <> MCP Integration",local:"key-features-of-the-gradio--mcp-integration",headingTag:"h2"}}),O=new Jt({props:{code:"ZGVtby5sYXVuY2gobWNwX3NlcnZlciUzRFRydWUp",highlighted:'demo.launch(mcp_server=<span class="hljs-literal">True</span>)',wrap:!1}}),D=new Jt({props:{code:"ZXhwb3J0JTIwR1JBRElPX01DUF9TRVJWRVIlM0RUcnVl",highlighted:'<span class="hljs-built_in">export</span> GRADIO_MCP_SERVER=True',wrap:!1}}),K=new g({props:{title:"Troubleshooting Tips",local:"troubleshooting-tips",headingTag:"h2"}}),et=new Jt({props:{code:"JTdCJTBBJTIwJTIwJTIybWNwU2VydmVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbW1hbmQlMjIlM0ElMjAlMjJucHglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJhcmdzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWNwLXJlbW90ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHAlM0ElMkYlMkZ5b3VyLXNlcnZlciUzQXBvcnQlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3NlJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;mcpServers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradio&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;npx&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;mcp-remote&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-string">&quot;http://your-server:port/gradio_api/mcp/sse&quot;</span>
      <span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),lt=new g({props:{title:"Share your MCP Server",local:"share-your-mcp-server",headingTag:"h2"}}),st=new al({props:{id:"3bSVKNKb_PY"}}),at=new g({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),ut=new ol({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit1/gradio-mcp.mdx"}}),{c(){y=a("meta"),U=s(),w=a("p"),dt=s(),u(I.$$.fragment),Ut=s(),b=a("p"),b.textContent=Ue,It=s(),u(T.$$.fragment),bt=s(),u(j.$$.fragment),jt=s(),x=a("p"),x.textContent=Ie,xt=s(),G=a("ul"),G.innerHTML=be,Gt=s(),P=a("p"),P.textContent=je,Pt=s(),S=a("p"),S.textContent=xe,St=s(),u(B.$$.fragment),Bt=s(),_=a("p"),_.textContent=Ge,_t=s(),u(H.$$.fragment),Ht=s(),E=a("p"),E.textContent=Pe,Et=s(),u(V.$$.fragment),Vt=s(),R=a("p"),R.textContent=Se,Rt=s(),u(k.$$.fragment),kt=s(),L=a("p"),L.textContent=Be,Lt=s(),A=a("ol"),A.innerHTML=_e,At=s(),q=a("p"),q.textContent=He,qt=s(),u(Q.$$.fragment),Qt=s(),W=a("p"),W.textContent=Ee,Wt=s(),Z=a("p"),Z.innerHTML=Ve,Zt=s(),u(Y.$$.fragment),Yt=s(),z=a("p"),z.innerHTML=Re,zt=s(),N=a("ol"),N.innerHTML=ke,Nt=s(),u(X.$$.fragment),Xt=s(),F=a("ol"),F.innerHTML=Le,Ft=s(),J=a("ul"),C=a("li"),de=Me("Using the "),ht=a("code"),ht.textContent=Ae,he=Me(" parameter in "),yt=a("code"),yt.textContent=qe,ye=Me(`:
	`),u(O.$$.fragment),fe=s(),ft=a("li"),we=Me(`Using environment variables:
	`),u(D.$$.fragment),Ot=s(),v=a("ol"),v.innerHTML=Qe,Dt=s(),u(K.$$.fragment),Kt=s(),f=a("ol"),wt=a("li"),wt.innerHTML=We,Ce=s(),Ct=a("li"),Ct.innerHTML=Ze,ge=s(),tt=a("li"),gt=a("p"),gt.innerHTML=Ye,Te=s(),u(et.$$.fragment),Je=s(),Tt=a("li"),Tt.innerHTML=ze,te=s(),u(lt.$$.fragment),ee=s(),nt=a("p"),nt.textContent=Ne,le=s(),u(st.$$.fragment),ne=s(),it=a("p"),it.textContent=Xe,se=s(),u(at.$$.fragment),ie=s(),ot=a("p"),ot.textContent=Fe,ae=s(),rt=a("p"),rt.textContent=Oe,oe=s(),pt=a("p"),pt.textContent=De,re=s(),u(ut.$$.fragment),pe=s(),vt=a("p"),this.h()},l(t){const e=sl("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(l),U=i(t),w=o(t,"P",{}),mt(w).forEach(l),dt=i(t),c(I.$$.fragment,t),Ut=i(t),b=o(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-rdhuvt"&&(b.textContent=Ue),It=i(t),c(T.$$.fragment,t),bt=i(t),c(j.$$.fragment,t),jt=i(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-14z9p62"&&(x.textContent=Ie),xt=i(t),G=o(t,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-99ur3v"&&(G.innerHTML=be),Gt=i(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-lf8duq"&&(P.textContent=je),Pt=i(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-y0ievc"&&(S.textContent=xe),St=i(t),c(B.$$.fragment,t),Bt=i(t),_=o(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1rbj74u"&&(_.textContent=Ge),_t=i(t),c(H.$$.fragment,t),Ht=i(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-mcgcva"&&(E.textContent=Pe),Et=i(t),c(V.$$.fragment,t),Vt=i(t),R=o(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-o78qi8"&&(R.textContent=Se),Rt=i(t),c(k.$$.fragment,t),kt=i(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-ee2pfb"&&(L.textContent=Be),Lt=i(t),A=o(t,"OL",{"data-svelte-h":!0}),r(A)!=="svelte-fibcta"&&(A.innerHTML=_e),At=i(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-7cf1ja"&&(q.textContent=He),qt=i(t),c(Q.$$.fragment,t),Qt=i(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-u4oo7k"&&(W.textContent=Ee),Wt=i(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-d00s62"&&(Z.innerHTML=Ve),Zt=i(t),c(Y.$$.fragment,t),Yt=i(t),z=o(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-b8hwz2"&&(z.innerHTML=Re),zt=i(t),N=o(t,"OL",{"data-svelte-h":!0}),r(N)!=="svelte-17ymzc7"&&(N.innerHTML=ke),Nt=i(t),c(X.$$.fragment,t),Xt=i(t),F=o(t,"OL",{"data-svelte-h":!0}),r(F)!=="svelte-kixwhi"&&(F.innerHTML=Le),Ft=i(t),J=o(t,"UL",{});var ct=mt(J);C=o(ct,"LI",{});var Mt=mt(C);de=me(Mt,"Using the "),ht=o(Mt,"CODE",{"data-svelte-h":!0}),r(ht)!=="svelte-1ljym0q"&&(ht.textContent=Ae),he=me(Mt," parameter in "),yt=o(Mt,"CODE",{"data-svelte-h":!0}),r(yt)!=="svelte-bu21s"&&(yt.textContent=qe),ye=me(Mt,`:
	`),c(O.$$.fragment,Mt),Mt.forEach(l),fe=i(ct),ft=o(ct,"LI",{});var ve=mt(ft);we=me(ve,`Using environment variables:
	`),c(D.$$.fragment,ve),ve.forEach(l),ct.forEach(l),Ot=i(t),v=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(v)!=="svelte-1w0fnl0"&&(v.innerHTML=Qe),Dt=i(t),c(K.$$.fragment,t),Kt=i(t),f=o(t,"OL",{});var $=mt(f);wt=o($,"LI",{"data-svelte-h":!0}),r(wt)!=="svelte-gfnyis"&&(wt.innerHTML=We),Ce=i($),Ct=o($,"LI",{"data-svelte-h":!0}),r(Ct)!=="svelte-tgtknq"&&(Ct.innerHTML=Ze),ge=i($),tt=o($,"LI",{});var ce=mt(tt);gt=o(ce,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1euh74t"&&(gt.innerHTML=Ye),Te=i(ce),c(et.$$.fragment,ce),ce.forEach(l),Je=i($),Tt=o($,"LI",{"data-svelte-h":!0}),r(Tt)!=="svelte-17e8f8t"&&(Tt.innerHTML=ze),$.forEach(l),te=i(t),c(lt.$$.fragment,t),ee=i(t),nt=o(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1713vuh"&&(nt.textContent=Ne),le=i(t),c(st.$$.fragment,t),ne=i(t),it=o(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-7f2lmd"&&(it.textContent=Xe),se=i(t),c(at.$$.fragment,t),ie=i(t),ot=o(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1cuj4qg"&&(ot.textContent=Fe),ae=i(t),rt=o(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-16ly6vm"&&(rt.textContent=Oe),oe=i(t),pt=o(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-lsux7c"&&(pt.textContent=De),re=i(t),c(ut.$$.fragment,t),pe=i(t),vt=o(t,"P",{}),mt(vt).forEach(l),this.h()},h(){$e(y,"name","hf:doc:metadata"),$e(y,"content",ul),$e(v,"start","3")},m(t,e){p(document.head,y),n(t,U,e),n(t,w,e),n(t,dt,e),M(I,t,e),n(t,Ut,e),n(t,b,e),n(t,It,e),M(T,t,e),n(t,bt,e),M(j,t,e),n(t,jt,e),n(t,x,e),n(t,xt,e),n(t,G,e),n(t,Gt,e),n(t,P,e),n(t,Pt,e),n(t,S,e),n(t,St,e),M(B,t,e),n(t,Bt,e),n(t,_,e),n(t,_t,e),M(H,t,e),n(t,Ht,e),n(t,E,e),n(t,Et,e),M(V,t,e),n(t,Vt,e),n(t,R,e),n(t,Rt,e),M(k,t,e),n(t,kt,e),n(t,L,e),n(t,Lt,e),n(t,A,e),n(t,At,e),n(t,q,e),n(t,qt,e),M(Q,t,e),n(t,Qt,e),n(t,W,e),n(t,Wt,e),n(t,Z,e),n(t,Zt,e),M(Y,t,e),n(t,Yt,e),n(t,z,e),n(t,zt,e),n(t,N,e),n(t,Nt,e),M(X,t,e),n(t,Xt,e),n(t,F,e),n(t,Ft,e),n(t,J,e),p(J,C),p(C,de),p(C,ht),p(C,he),p(C,yt),p(C,ye),M(O,C,null),p(J,fe),p(J,ft),p(ft,we),M(D,ft,null),n(t,Ot,e),n(t,v,e),n(t,Dt,e),M(K,t,e),n(t,Kt,e),n(t,f,e),p(f,wt),p(f,Ce),p(f,Ct),p(f,ge),p(f,tt),p(tt,gt),p(tt,Te),M(et,tt,null),p(f,Je),p(f,Tt),n(t,te,e),M(lt,t,e),n(t,ee,e),n(t,nt,e),n(t,le,e),M(st,t,e),n(t,ne,e),n(t,it,e),n(t,se,e),M(at,t,e),n(t,ie,e),n(t,ot,e),n(t,ae,e),n(t,rt,e),n(t,oe,e),n(t,pt,e),n(t,re,e),M(ut,t,e),n(t,pe,e),n(t,vt,e),ue=!0},p(t,[e]){const ct={};e&2&&(ct.$$scope={dirty:e,ctx:t}),T.$set(ct)},i(t){ue||(m(I.$$.fragment,t),m(T.$$.fragment,t),m(j.$$.fragment,t),m(B.$$.fragment,t),m(H.$$.fragment,t),m(V.$$.fragment,t),m(k.$$.fragment,t),m(Q.$$.fragment,t),m(Y.$$.fragment,t),m(X.$$.fragment,t),m(O.$$.fragment,t),m(D.$$.fragment,t),m(K.$$.fragment,t),m(et.$$.fragment,t),m(lt.$$.fragment,t),m(st.$$.fragment,t),m(at.$$.fragment,t),m(ut.$$.fragment,t),ue=!0)},o(t){d(I.$$.fragment,t),d(T.$$.fragment,t),d(j.$$.fragment,t),d(B.$$.fragment,t),d(H.$$.fragment,t),d(V.$$.fragment,t),d(k.$$.fragment,t),d(Q.$$.fragment,t),d(Y.$$.fragment,t),d(X.$$.fragment,t),d(O.$$.fragment,t),d(D.$$.fragment,t),d(K.$$.fragment,t),d(et.$$.fragment,t),d(lt.$$.fragment,t),d(st.$$.fragment,t),d(at.$$.fragment,t),d(ut.$$.fragment,t),ue=!1},d(t){t&&(l(U),l(w),l(dt),l(Ut),l(b),l(It),l(bt),l(jt),l(x),l(xt),l(G),l(Gt),l(P),l(Pt),l(S),l(St),l(Bt),l(_),l(_t),l(Ht),l(E),l(Et),l(Vt),l(R),l(Rt),l(kt),l(L),l(Lt),l(A),l(At),l(q),l(qt),l(Qt),l(W),l(Wt),l(Z),l(Zt),l(Yt),l(z),l(zt),l(N),l(Nt),l(Xt),l(F),l(Ft),l(J),l(Ot),l(v),l(Dt),l(Kt),l(f),l(te),l(ee),l(nt),l(le),l(ne),l(it),l(se),l(ie),l(ot),l(ae),l(rt),l(oe),l(pt),l(re),l(pe),l(vt)),l(y),h(I,t),h(T,t),h(j,t),h(B,t),h(H,t),h(V,t),h(k,t),h(Q,t),h(Y,t),h(X,t),h(O),h(D),h(K,t),h(et),h(lt,t),h(st,t),h(at,t),h(ut,t)}}}const ul='{"title":"Gradio MCP Integration","local":"gradio-mcp-integration","sections":[{"title":"Introduction to Gradio","local":"introduction-to-gradio","sections":[],"depth":2},{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Creating an MCP Server with Gradio","local":"creating-an-mcp-server-with-gradio","sections":[],"depth":2},{"title":"How It Works Behind the Scenes","local":"how-it-works-behind-the-scenes","sections":[],"depth":2},{"title":"Key Features of the Gradio <> MCP Integration","local":"key-features-of-the-gradio--mcp-integration","sections":[],"depth":2},{"title":"Troubleshooting Tips","local":"troubleshooting-tips","sections":[],"depth":2},{"title":"Share your MCP Server","local":"share-your-mcp-server","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function cl($t){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wl extends ll{constructor(y){super(),nl(this,y,cl,pl,Ke,{})}}export{wl as component};
