import{s as ia,n as sa,o as ma}from"../chunks/scheduler.85c25b89.js";import{S as da,i as pa,g as r,s as l,r as c,A as ca,h as i,f as t,c as o,j as ae,u as _,x as d,k as te,l as _a,y as s,a as n,v as u,d as f,t as h,w as v}from"../chunks/index.c9bcf812.js";import{D as Re}from"../chunks/Docstring.46c9d080.js";import{C as ra}from"../chunks/CodeBlock.94efc595.js";import{H as W,E as ua}from"../chunks/EditOnGithub.ec73e7c7.js";function fa(Ae){let w,oe,ne,re,y,ie,x,Ve="TRL supports custom reward modeling for anyone to perform reward modeling on their dataset and model.",se,N,qe='Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/reward_modeling.py" rel="nofollow"><code>examples/scripts/reward_modeling.py</code></a>.',me,k,de,O,We='The <a href="/docs/trl/pr_1769/en/trainer#trl.RewardTrainer">RewardTrainer</a> expects a very specific format for the dataset since the model will be trained on pairs of examples to predict which of the two is preferred. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',pe,b,De='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',ce,C,Ge="Therefore the final dataset object should contain two 4 entries at least if you use the default <code>RewardDataCollatorWithPadding</code> data collator. The entries should be named:",_e,F,Ze="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",ue,M,fe,R,Se=`After preparing your dataset, you can use the <a href="/docs/trl/pr_1769/en/trainer#trl.RewardTrainer">RewardTrainer</a> in the same way as the <code>Trainer</code> class from 🤗 Transformers.
You should pass an <code>AutoModelForSequenceClassification</code> model to the <a href="/docs/trl/pr_1769/en/trainer#trl.RewardTrainer">RewardTrainer</a>, along with a <a href="/docs/trl/pr_1769/en/trainer#trl.RewardConfig">RewardConfig</a> which configures the hyperparameters of the training.`,he,j,ve,L,Xe='Just pass a <code>peft_config</code> in the keyword arguments of <a href="/docs/trl/pr_1769/en/trainer#trl.RewardTrainer">RewardTrainer</a>, and the trainer should automatically take care of converting the model into a PEFT model!',ge,J,we,U,be,H,Ye='As in the <a href="https://huggingface.co/papers/2307.09288" rel="nofollow">Llama 2 paper</a>, you can add a margin to the loss by adding a <code>margin</code> column to the dataset. The reward collator will automatically pass it through and the loss will be computed accordingly.',Te,I,$e,z,ye,g,P,je,D,Qe='RewardConfig collects all training arguments related to the <a href="/docs/trl/pr_1769/en/trainer#trl.RewardTrainer">RewardTrainer</a> class.',Le,G,Ke=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,xe,B,Ne,m,E,Je,Z,ea=`The RewardTrainer can be used to train your custom Reward Model. It is a subclass of the
<code>transformers.Trainer</code> class and inherits all of its attributes and methods. It is recommended to use
an <code>AutoModelForSequenceClassification</code> as the reward model. The reward model should be trained on a dataset
of paired examples, where each example is a tuple of two sequences. The reward model should be trained to
predict which example in the pair is more relevant to the task at hand.`,Ue,S,aa=`The reward trainer expects a very specific format for the dataset. The dataset should contain two 4 entries at least
if you don’t use the default <code>RewardDataCollatorWithPadding</code> data collator. The entries should be named`,He,X,ta="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",Ie,Y,na=`Optionally, you can also pass a <code>margin</code> entry to the dataset. This entry should contain the margin used to modulate the
loss of the reward model as outlined in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/</a>.
If you don’t pass a margin, no margin will be used.`,ze,T,A,Pe,Q,la="Concatenate the chosen and rejected inputs into a single tensor.",Be,$,V,Ee,K,oa="Visualize the reward model logits prediction",ke,q,Oe,le,Ce;return y=new W({props:{title:"Reward Modeling",local:"reward-modeling",headingTag:"h1"}}),k=new W({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),M=new W({props:{title:"Using the RewardTrainer",local:"using-the-rewardtrainer",headingTag:"h2"}}),j=new W({props:{title:"Leveraging 🤗 PEFT to train a reward model",local:"leveraging--peft-to-train-a-reward-model",headingTag:"h3"}}),J=new ra({props:{code:"JTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, TaskType
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> RewardTrainer, RewardConfig

model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
peft_config = LoraConfig(
    task_type=TaskType.SEQ_CLS,
    inference_mode=<span class="hljs-literal">False</span>,
    r=<span class="hljs-number">8</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
)

...

trainer = RewardTrainer(
    model=model,
    args=training_args,
    tokenizer=tokenizer,
    train_dataset=dataset,
    peft_config=peft_config,
)

trainer.train()
`,wrap:!1}}),U=new W({props:{title:"Adding a margin to the loss",local:"adding-a-margin-to-the-loss",headingTag:"h3"}}),I=new ra({props:{code:"ZGVmJTIwYWRkX21hcmdpbihyb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQXNzdW1lJTIweW91JTIwaGF2ZSUyMGElMjBzY29yZV9jaG9zZW4lMjBhbmQlMjBzY29yZV9yZWplY3RlZCUyMGNvbHVtbnMlMjB0aGF0JTIweW91JTIwd2FudCUyMHRvJTIwdXNlJTIwdG8lMjBjb21wdXRlJTIwdGhlJTIwbWFyZ2luJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJ21hcmdpbiclM0ElMjByb3clNUInc2NvcmVfY2hvc2VuJyU1RCUyMC0lMjByb3clNUInc2NvcmVfcmVqZWN0ZWQnJTVEJTdEJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGFkZF9tYXJnaW4p",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_margin</span>(<span class="hljs-params">row</span>):
    <span class="hljs-comment"># Assume you have a score_chosen and score_rejected columns that you want to use to compute the margin</span>
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&#x27;margin&#x27;</span>: row[<span class="hljs-string">&#x27;score_chosen&#x27;</span>] - row[<span class="hljs-string">&#x27;score_rejected&#x27;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(add_margin)`,wrap:!1}}),z=new W({props:{title:"RewardConfig",local:"trl.RewardConfig",headingTag:"h2"}}),P=new Re({props:{name:"class trl.RewardConfig",anchor:"trl.RewardConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"max_length",val:": Optional = None"},{name:"concatenate_forward_flag",val:": Optional = False"}],parametersDescription:[{anchor:"trl.RewardConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.RewardConfig.gradient_checkpointing",description:`<strong>gradient_checkpointing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, use gradient checkpointing to save memory at the expense of slower backward pass.`,name:"gradient_checkpointing"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/reward_config.py#L21"}}),B=new W({props:{title:"RewardTrainer",local:"trl.RewardTrainer",headingTag:"h2"}}),E=new Re({props:{name:"class trl.RewardTrainer",anchor:"trl.RewardTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/reward_trainer.py#L39"}}),A=new Re({props:{name:"concatenated_inputs",anchor:"trl.RewardTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/reward_trainer.py#L219",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),V=new Re({props:{name:"visualize_samples",anchor:"trl.RewardTrainer.visualize_samples",parameters:[{name:"num_print_samples",val:": int"}],parametersDescription:[{anchor:"trl.RewardTrainer.visualize_samples.num_print_samples",description:`<strong>num_print_samples</strong> (<code>int</code>, defaults to <code>4</code>) &#x2014;
The number of samples to print. Set to <code>-1</code> to print all samples.`,name:"num_print_samples"}],source:"https://github.com/huggingface/trl/blob/vr_1769/trl/trainer/reward_trainer.py#L350"}}),q=new ua({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/reward_trainer.mdx"}}),{c(){w=r("meta"),oe=l(),ne=r("p"),re=l(),c(y.$$.fragment),ie=l(),x=r("p"),x.textContent=Ve,se=l(),N=r("p"),N.innerHTML=qe,me=l(),c(k.$$.fragment),de=l(),O=r("p"),O.innerHTML=We,pe=l(),b=r("div"),b.innerHTML=De,ce=l(),C=r("p"),C.innerHTML=Ge,_e=l(),F=r("ul"),F.innerHTML=Ze,ue=l(),c(M.$$.fragment),fe=l(),R=r("p"),R.innerHTML=Se,he=l(),c(j.$$.fragment),ve=l(),L=r("p"),L.innerHTML=Xe,ge=l(),c(J.$$.fragment),we=l(),c(U.$$.fragment),be=l(),H=r("p"),H.innerHTML=Ye,Te=l(),c(I.$$.fragment),$e=l(),c(z.$$.fragment),ye=l(),g=r("div"),c(P.$$.fragment),je=l(),D=r("p"),D.innerHTML=Qe,Le=l(),G=r("p"),G.innerHTML=Ke,xe=l(),c(B.$$.fragment),Ne=l(),m=r("div"),c(E.$$.fragment),Je=l(),Z=r("p"),Z.innerHTML=ea,Ue=l(),S=r("p"),S.innerHTML=aa,He=l(),X=r("ul"),X.innerHTML=ta,Ie=l(),Y=r("p"),Y.innerHTML=na,ze=l(),T=r("div"),c(A.$$.fragment),Pe=l(),Q=r("p"),Q.textContent=la,Be=l(),$=r("div"),c(V.$$.fragment),Ee=l(),K=r("p"),K.textContent=oa,ke=l(),c(q.$$.fragment),Oe=l(),le=r("p"),this.h()},l(e){const a=ca("svelte-u9bgzb",document.head);w=i(a,"META",{name:!0,content:!0}),a.forEach(t),oe=o(e),ne=i(e,"P",{}),ae(ne).forEach(t),re=o(e),_(y.$$.fragment,e),ie=o(e),x=i(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-wgcft"&&(x.textContent=Ve),se=o(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-19du5x9"&&(N.innerHTML=qe),me=o(e),_(k.$$.fragment,e),de=o(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-15o3dm1"&&(O.innerHTML=We),pe=o(e),b=i(e,"DIV",{style:!0,"data-svelte-h":!0}),d(b)!=="svelte-z15c7z"&&(b.innerHTML=De),ce=o(e),C=i(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-u17vu1"&&(C.innerHTML=Ge),_e=o(e),F=i(e,"UL",{"data-svelte-h":!0}),d(F)!=="svelte-1ytuxgw"&&(F.innerHTML=Ze),ue=o(e),_(M.$$.fragment,e),fe=o(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-zyk5e"&&(R.innerHTML=Se),he=o(e),_(j.$$.fragment,e),ve=o(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-raal1i"&&(L.innerHTML=Xe),ge=o(e),_(J.$$.fragment,e),we=o(e),_(U.$$.fragment,e),be=o(e),H=i(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-175anp9"&&(H.innerHTML=Ye),Te=o(e),_(I.$$.fragment,e),$e=o(e),_(z.$$.fragment,e),ye=o(e),g=i(e,"DIV",{class:!0});var ee=ae(g);_(P.$$.fragment,ee),je=o(ee),D=i(ee,"P",{"data-svelte-h":!0}),d(D)!=="svelte-12bspjw"&&(D.innerHTML=Qe),Le=o(ee),G=i(ee,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1xl7jqc"&&(G.innerHTML=Ke),ee.forEach(t),xe=o(e),_(B.$$.fragment,e),Ne=o(e),m=i(e,"DIV",{class:!0});var p=ae(m);_(E.$$.fragment,p),Je=o(p),Z=i(p,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-qafafj"&&(Z.innerHTML=ea),Ue=o(p),S=i(p,"P",{"data-svelte-h":!0}),d(S)!=="svelte-bkmbwh"&&(S.innerHTML=aa),He=o(p),X=i(p,"UL",{"data-svelte-h":!0}),d(X)!=="svelte-1ytuxgw"&&(X.innerHTML=ta),Ie=o(p),Y=i(p,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-18tbp4c"&&(Y.innerHTML=na),ze=o(p),T=i(p,"DIV",{class:!0});var Fe=ae(T);_(A.$$.fragment,Fe),Pe=o(Fe),Q=i(Fe,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1cvsgkk"&&(Q.textContent=la),Fe.forEach(t),Be=o(p),$=i(p,"DIV",{class:!0});var Me=ae($);_(V.$$.fragment,Me),Ee=o(Me),K=i(Me,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1g38ldc"&&(K.textContent=oa),Me.forEach(t),p.forEach(t),ke=o(e),_(q.$$.fragment,e),Oe=o(e),le=i(e,"P",{}),ae(le).forEach(t),this.h()},h(){te(w,"name","hf:doc:metadata"),te(w,"content",ha),_a(b,"text-align","center"),te(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),te(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),te($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),te(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){s(document.head,w),n(e,oe,a),n(e,ne,a),n(e,re,a),u(y,e,a),n(e,ie,a),n(e,x,a),n(e,se,a),n(e,N,a),n(e,me,a),u(k,e,a),n(e,de,a),n(e,O,a),n(e,pe,a),n(e,b,a),n(e,ce,a),n(e,C,a),n(e,_e,a),n(e,F,a),n(e,ue,a),u(M,e,a),n(e,fe,a),n(e,R,a),n(e,he,a),u(j,e,a),n(e,ve,a),n(e,L,a),n(e,ge,a),u(J,e,a),n(e,we,a),u(U,e,a),n(e,be,a),n(e,H,a),n(e,Te,a),u(I,e,a),n(e,$e,a),u(z,e,a),n(e,ye,a),n(e,g,a),u(P,g,null),s(g,je),s(g,D),s(g,Le),s(g,G),n(e,xe,a),u(B,e,a),n(e,Ne,a),n(e,m,a),u(E,m,null),s(m,Je),s(m,Z),s(m,Ue),s(m,S),s(m,He),s(m,X),s(m,Ie),s(m,Y),s(m,ze),s(m,T),u(A,T,null),s(T,Pe),s(T,Q),s(m,Be),s(m,$),u(V,$,null),s($,Ee),s($,K),n(e,ke,a),u(q,e,a),n(e,Oe,a),n(e,le,a),Ce=!0},p:sa,i(e){Ce||(f(y.$$.fragment,e),f(k.$$.fragment,e),f(M.$$.fragment,e),f(j.$$.fragment,e),f(J.$$.fragment,e),f(U.$$.fragment,e),f(I.$$.fragment,e),f(z.$$.fragment,e),f(P.$$.fragment,e),f(B.$$.fragment,e),f(E.$$.fragment,e),f(A.$$.fragment,e),f(V.$$.fragment,e),f(q.$$.fragment,e),Ce=!0)},o(e){h(y.$$.fragment,e),h(k.$$.fragment,e),h(M.$$.fragment,e),h(j.$$.fragment,e),h(J.$$.fragment,e),h(U.$$.fragment,e),h(I.$$.fragment,e),h(z.$$.fragment,e),h(P.$$.fragment,e),h(B.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(V.$$.fragment,e),h(q.$$.fragment,e),Ce=!1},d(e){e&&(t(oe),t(ne),t(re),t(ie),t(x),t(se),t(N),t(me),t(de),t(O),t(pe),t(b),t(ce),t(C),t(_e),t(F),t(ue),t(fe),t(R),t(he),t(ve),t(L),t(ge),t(we),t(be),t(H),t(Te),t($e),t(ye),t(g),t(xe),t(Ne),t(m),t(ke),t(Oe),t(le)),t(w),v(y,e),v(k,e),v(M,e),v(j,e),v(J,e),v(U,e),v(I,e),v(z,e),v(P),v(B,e),v(E),v(A),v(V),v(q,e)}}}const ha='{"title":"Reward Modeling","local":"reward-modeling","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Using the RewardTrainer","local":"using-the-rewardtrainer","sections":[{"title":"Leveraging 🤗 PEFT to train a reward model","local":"leveraging--peft-to-train-a-reward-model","sections":[],"depth":3},{"title":"Adding a margin to the loss","local":"adding-a-margin-to-the-loss","sections":[],"depth":3}],"depth":2},{"title":"RewardConfig","local":"trl.RewardConfig","sections":[],"depth":2},{"title":"RewardTrainer","local":"trl.RewardTrainer","sections":[],"depth":2}],"depth":1}';function va(Ae){return ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ya extends da{constructor(w){super(),pa(this,w,va,fa,ia,{})}}export{ya as component};
