import{s as Qt,n as wt,o as Ct}from"../chunks/scheduler.6062bdaf.js";import{S as Pt,i as Dt,g as r,s as a,r as c,A as Nt,h as s,f as o,c as i,j as f,u,x as E,k as x,y as e,a as b,v as l,d as p,t as g,w as _}from"../chunks/index.4bca734e.js";import{D as M}from"../chunks/Docstring.d7918b6d.js";import{H as Rt,E as Ft}from"../chunks/EditOnGithub.74ab2baa.js";function Lt(bt){let h,j,A,S,y,B,R,J,n,Q,rt,U,zt="Handles the ONNX Runtime quantization process for models shared on huggingface.co/models.",st,z,w,mt,H,vt="Computes the quantization ranges.",dt,v,C,ct,I,Tt="Performs the calibration step and computes the quantization ranges.",ut,T,P,lt,k,$t="Instantiates a <code>ORTQuantizer</code> from an ONNX model file or an <code>ORTModel</code>.",pt,$,D,gt,W,Ot="Creates the calibration <code>datasets.Dataset</code> to use for the post-training static quantization calibration step.",_t,O,N,ht,V,qt="Performs the calibration step and collects the quantization ranges without computing them.",ft,q,F,xt,G,yt="Quantizes a model given the optimization specifications defined in <code>quantization_config</code>.",K,L,Y,X,Z;return y=new Rt({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),R=new Rt({props:{title:"ORTQuantizer",local:"optimum.onnxruntime.ORTQuantizer",headingTag:"h2"}}),Q=new M({props:{name:"class optimum.onnxruntime.ORTQuantizer",anchor:"optimum.onnxruntime.ORTQuantizer",parameters:[{name:"onnx_model_path",val:": Path"},{name:"config",val:": typing.Optional[ForwardRef('PretrainedConfig')] = None"}],source:"https://github.com/huggingface/optimum/blob/vr_1918/optimum/onnxruntime/quantization.py#L83"}}),w=new M({props:{name:"compute_ranges",anchor:"optimum.onnxruntime.ORTQuantizer.compute_ranges",parameters:[],source:"https://github.com/huggingface/optimum/blob/vr_1918/optimum/onnxruntime/quantization.py#L261",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary mapping the nodes name to their quantization ranges.</p>
`}}),C=new M({props:{name:"fit",anchor:"optimum.onnxruntime.ORTQuantizer.fit",parameters:[{name:"dataset",val:": Dataset"},{name:"calibration_config",val:": CalibrationConfig"},{name:"onnx_augmented_model_name",val:": typing.Union[str, pathlib.Path] = 'augmented_model.onnx'"},{name:"operators_to_quantize",val:": typing.Optional[typing.List[str]] = None"},{name:"batch_size",val:": int = 1"},{name:"use_external_data_format",val:": bool = False"},{name:"use_gpu",val:": bool = False"},{name:"force_symmetric_range",val:": bool = False"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTQuantizer.fit.dataset",description:`<strong>dataset</strong> (<code>Dataset</code>) &#x2014;
The dataset to use when performing the calibration step.`,name:"dataset"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.calibration_config",description:`<strong>calibration_config</strong> (<code>~CalibrationConfig</code>) &#x2014;
The configuration containing the parameters related to the calibration step.`,name:"calibration_config"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.onnx_augmented_model_name",description:`<strong>onnx_augmented_model_name</strong> (<code>Union[str, Path]</code>, defaults to <code>&quot;augmented_model.onnx&quot;</code>) &#x2014;
The path used to save the augmented model used to collect the quantization ranges.`,name:"onnx_augmented_model_name"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
List of the operators types to quantize.`,name:"operators_to_quantize"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The batch size to use when collecting the quantization ranges values.`,name:"batch_size"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.use_external_data_format",description:`<strong>use_external_data_format</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use external data format to store model which size is &gt;= 2Gb.`,name:"use_external_data_format"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.use_gpu",description:`<strong>use_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the GPU when collecting the quantization ranges values.`,name:"use_gpu"},{anchor:"optimum.onnxruntime.ORTQuantizer.fit.force_symmetric_range",description:`<strong>force_symmetric_range</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to make the quantization ranges symmetric.`,name:"force_symmetric_range"}],source:"https://github.com/huggingface/optimum/blob/vr_1918/optimum/onnxruntime/quantization.py#L157",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary mapping the nodes name to their quantization ranges.</p>
`}}),P=new M({props:{name:"from_pretrained",anchor:"optimum.onnxruntime.ORTQuantizer.from_pretrained",parameters:[{name:"model_or_path",val:": typing.Union[ForwardRef('ORTModel'), str, pathlib.Path]"},{name:"file_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTQuantizer.from_pretrained.model_or_path",description:`<strong>model_or_path</strong> (<code>Union[ORTModel, str, Path]</code>) &#x2014;
Can be either:<ul>
<li>A path to a saved exported ONNX Intermediate Representation (IR) model, e.g., \`./my_model_directory/.</li>
<li>Or an <code>ORTModelForXX</code> class, e.g., <code>ORTModelForQuestionAnswering</code>.</li>
</ul>`,name:"model_or_path"},{anchor:"optimum.onnxruntime.ORTQuantizer.from_pretrained.file_name(Optional[str],",description:`<strong>file_name(<code>Optional[str]</code>,</strong> defaults to <code>None</code>) &#x2014;
Overwrites the default model file name from <code>&quot;model.onnx&quot;</code> to <code>file_name</code>.
This allows you to load different model files from the same repository or directory.`,name:"file_name(Optional[str],"}],source:"https://github.com/huggingface/optimum/blob/vr_1918/optimum/onnxruntime/quantization.py#L110",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of <code>ORTQuantizer</code>.</p>
`}}),D=new M({props:{name:"get_calibration_dataset",anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset",parameters:[{name:"dataset_name",val:": str"},{name:"num_samples",val:": int = 100"},{name:"dataset_config_name",val:": typing.Optional[str] = None"},{name:"dataset_split",val:": typing.Optional[str] = None"},{name:"preprocess_function",val:": typing.Optional[typing.Callable] = None"},{name:"preprocess_batch",val:": bool = True"},{name:"seed",val:": int = 2016"},{name:"use_auth_token",val:": bool = False"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>) &#x2014;
The dataset repository name on the Hugging Face Hub or path to a local directory containing data files
to load to use for the calibration step.`,name:"dataset_name"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.num_samples",description:`<strong>num_samples</strong> (<code>int</code>, defaults to 100) &#x2014;
The maximum number of samples composing the calibration dataset.`,name:"num_samples"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.dataset_config_name",description:`<strong>dataset_config_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The name of the dataset configuration.`,name:"dataset_config_name"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.dataset_split",description:`<strong>dataset_split</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
Which split of the dataset to use to perform the calibration step.`,name:"dataset_split"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.preprocess_function",description:`<strong>preprocess_function</strong> (<code>Optional[Callable]</code>, defaults to <code>None</code>) &#x2014;
Processing function to apply to each example after loading dataset.`,name:"preprocess_function"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.preprocess_batch",description:`<strong>preprocess_batch</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether the <code>preprocess_function</code> should be batched.`,name:"preprocess_batch"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.seed",description:`<strong>seed</strong> (<code>int</code>, defaults to 2016) &#x2014;
The random seed to use when shuffling the calibration dataset.`,name:"seed"},{anchor:"optimum.onnxruntime.ORTQuantizer.get_calibration_dataset.use_auth_token",description:`<strong>use_auth_token</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the token generated when running <code>transformers-cli login</code> (necessary for some datasets
like ImageNet).`,name:"use_auth_token"}],source:"https://github.com/huggingface/optimum/blob/vr_1918/optimum/onnxruntime/quantization.py#L418",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The calibration <code>datasets.Dataset</code> to use for the post-training static quantization calibration
step.</p>
`}}),N=new M({props:{name:"partial_fit",anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit",parameters:[{name:"dataset",val:": Dataset"},{name:"calibration_config",val:": CalibrationConfig"},{name:"onnx_augmented_model_name",val:": typing.Union[str, pathlib.Path] = 'augmented_model.onnx'"},{name:"operators_to_quantize",val:": typing.Optional[typing.List[str]] = None"},{name:"batch_size",val:": int = 1"},{name:"use_external_data_format",val:": bool = False"},{name:"use_gpu",val:": bool = False"},{name:"force_symmetric_range",val:": bool = False"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.dataset",description:`<strong>dataset</strong> (<code>Dataset</code>) &#x2014;
The dataset to use when performing the calibration step.`,name:"dataset"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.calibration_config",description:`<strong>calibration_config</strong> (<code>CalibrationConfig</code>) &#x2014;
The configuration containing the parameters related to the calibration step.`,name:"calibration_config"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.onnx_augmented_model_name",description:`<strong>onnx_augmented_model_name</strong> (<code>Union[str, Path]</code>, defaults to <code>&quot;augmented_model.onnx&quot;</code>) &#x2014;
The path used to save the augmented model used to collect the quantization ranges.`,name:"onnx_augmented_model_name"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
List of the operators types to quantize.`,name:"operators_to_quantize"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The batch size to use when collecting the quantization ranges values.`,name:"batch_size"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.use_external_data_format",description:`<strong>use_external_data_format</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether uto se external data format to store model which size is &gt;= 2Gb.`,name:"use_external_data_format"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.use_gpu",description:`<strong>use_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the GPU when collecting the quantization ranges values.`,name:"use_gpu"},{anchor:"optimum.onnxruntime.ORTQuantizer.partial_fit.force_symmetric_range",description:`<strong>force_symmetric_range</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to make the quantization ranges symmetric.`,name:"force_symmetric_range"}],source:"https://github.com/huggingface/optimum/blob/vr_1918/optimum/onnxruntime/quantization.py#L211"}}),F=new M({props:{name:"quantize",anchor:"optimum.onnxruntime.ORTQuantizer.quantize",parameters:[{name:"quantization_config",val:": QuantizationConfig"},{name:"save_dir",val:": typing.Union[str, pathlib.Path]"},{name:"file_suffix",val:": typing.Optional[str] = 'quantized'"},{name:"calibration_tensors_range",val:": typing.Union[typing.Dict[str, typing.Tuple[float, float]], NoneType] = None"},{name:"use_external_data_format",val:": bool = False"},{name:"preprocessor",val:": typing.Optional[optimum.onnxruntime.preprocessors.quantization.QuantizationPreprocessor] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTQuantizer.quantize.quantization_config",description:`<strong>quantization_config</strong> (<code>QuantizationConfig</code>) &#x2014;
The configuration containing the parameters related to quantization.`,name:"quantization_config"},{anchor:"optimum.onnxruntime.ORTQuantizer.quantize.save_dir",description:`<strong>save_dir</strong> (<code>Union[str, Path]</code>) &#x2014;
The directory where the quantized model should be saved.`,name:"save_dir"},{anchor:"optimum.onnxruntime.ORTQuantizer.quantize.file_suffix",description:`<strong>file_suffix</strong> (<code>Optional[str]</code>, defaults to <code>&quot;quantized&quot;</code>) &#x2014;
The file_suffix used to save the quantized model.`,name:"file_suffix"},{anchor:"optimum.onnxruntime.ORTQuantizer.quantize.calibration_tensors_range",description:`<strong>calibration_tensors_range</strong> (<code>Optional[Dict[str, Tuple[float, float]]]</code>, defaults to <code>None</code>) &#x2014;
The dictionary mapping the nodes name to their quantization ranges, used and required only when applying static quantization.`,name:"calibration_tensors_range"},{anchor:"optimum.onnxruntime.ORTQuantizer.quantize.use_external_data_format",description:`<strong>use_external_data_format</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use external data format to store model which size is &gt;= 2Gb.`,name:"use_external_data_format"},{anchor:"optimum.onnxruntime.ORTQuantizer.quantize.preprocessor",description:`<strong>preprocessor</strong> (<code>Optional[QuantizationPreprocessor]</code>, defaults to <code>None</code>) &#x2014;
The preprocessor to use to collect the nodes to include or exclude from quantization.`,name:"preprocessor"}],source:"https://github.com/huggingface/optimum/blob/vr_1918/optimum/onnxruntime/quantization.py#L280",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The path of the resulting quantized model.</p>
`}}),L=new Ft({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/onnxruntime/package_reference/quantization.mdx"}}),{c(){h=r("meta"),j=a(),A=r("p"),S=a(),c(y.$$.fragment),B=a(),c(R.$$.fragment),J=a(),n=r("div"),c(Q.$$.fragment),rt=a(),U=r("p"),U.textContent=zt,st=a(),z=r("div"),c(w.$$.fragment),mt=a(),H=r("p"),H.textContent=vt,dt=a(),v=r("div"),c(C.$$.fragment),ct=a(),I=r("p"),I.textContent=Tt,ut=a(),T=r("div"),c(P.$$.fragment),lt=a(),k=r("p"),k.innerHTML=$t,pt=a(),$=r("div"),c(D.$$.fragment),gt=a(),W=r("p"),W.innerHTML=Ot,_t=a(),O=r("div"),c(N.$$.fragment),ht=a(),V=r("p"),V.textContent=qt,ft=a(),q=r("div"),c(F.$$.fragment),xt=a(),G=r("p"),G.innerHTML=yt,K=a(),c(L.$$.fragment),Y=a(),X=r("p"),this.h()},l(t){const d=Nt("svelte-u9bgzb",document.head);h=s(d,"META",{name:!0,content:!0}),d.forEach(o),j=i(t),A=s(t,"P",{}),f(A).forEach(o),S=i(t),u(y.$$.fragment,t),B=i(t),u(R.$$.fragment,t),J=i(t),n=s(t,"DIV",{class:!0});var m=f(n);u(Q.$$.fragment,m),rt=i(m),U=s(m,"P",{"data-svelte-h":!0}),E(U)!=="svelte-1tiz3jr"&&(U.textContent=zt),st=i(m),z=s(m,"DIV",{class:!0});var tt=f(z);u(w.$$.fragment,tt),mt=i(tt),H=s(tt,"P",{"data-svelte-h":!0}),E(H)!=="svelte-1183xvy"&&(H.textContent=vt),tt.forEach(o),dt=i(m),v=s(m,"DIV",{class:!0});var et=f(v);u(C.$$.fragment,et),ct=i(et),I=s(et,"P",{"data-svelte-h":!0}),E(I)!=="svelte-1tzjvze"&&(I.textContent=Tt),et.forEach(o),ut=i(m),T=s(m,"DIV",{class:!0});var nt=f(T);u(P.$$.fragment,nt),lt=i(nt),k=s(nt,"P",{"data-svelte-h":!0}),E(k)!=="svelte-p4e5on"&&(k.innerHTML=$t),nt.forEach(o),pt=i(m),$=s(m,"DIV",{class:!0});var ot=f($);u(D.$$.fragment,ot),gt=i(ot),W=s(ot,"P",{"data-svelte-h":!0}),E(W)!=="svelte-1xfi4es"&&(W.innerHTML=Ot),ot.forEach(o),_t=i(m),O=s(m,"DIV",{class:!0});var at=f(O);u(N.$$.fragment,at),ht=i(at),V=s(at,"P",{"data-svelte-h":!0}),E(V)!=="svelte-g6p4yh"&&(V.textContent=qt),at.forEach(o),ft=i(m),q=s(m,"DIV",{class:!0});var it=f(q);u(F.$$.fragment,it),xt=i(it),G=s(it,"P",{"data-svelte-h":!0}),E(G)!=="svelte-4dslow"&&(G.innerHTML=yt),it.forEach(o),m.forEach(o),K=i(t),u(L.$$.fragment,t),Y=i(t),X=s(t,"P",{}),f(X).forEach(o),this.h()},h(){x(h,"name","hf:doc:metadata"),x(h,"content",Et),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,d){e(document.head,h),b(t,j,d),b(t,A,d),b(t,S,d),l(y,t,d),b(t,B,d),l(R,t,d),b(t,J,d),b(t,n,d),l(Q,n,null),e(n,rt),e(n,U),e(n,st),e(n,z),l(w,z,null),e(z,mt),e(z,H),e(n,dt),e(n,v),l(C,v,null),e(v,ct),e(v,I),e(n,ut),e(n,T),l(P,T,null),e(T,lt),e(T,k),e(n,pt),e(n,$),l(D,$,null),e($,gt),e($,W),e(n,_t),e(n,O),l(N,O,null),e(O,ht),e(O,V),e(n,ft),e(n,q),l(F,q,null),e(q,xt),e(q,G),b(t,K,d),l(L,t,d),b(t,Y,d),b(t,X,d),Z=!0},p:wt,i(t){Z||(p(y.$$.fragment,t),p(R.$$.fragment,t),p(Q.$$.fragment,t),p(w.$$.fragment,t),p(C.$$.fragment,t),p(P.$$.fragment,t),p(D.$$.fragment,t),p(N.$$.fragment,t),p(F.$$.fragment,t),p(L.$$.fragment,t),Z=!0)},o(t){g(y.$$.fragment,t),g(R.$$.fragment,t),g(Q.$$.fragment,t),g(w.$$.fragment,t),g(C.$$.fragment,t),g(P.$$.fragment,t),g(D.$$.fragment,t),g(N.$$.fragment,t),g(F.$$.fragment,t),g(L.$$.fragment,t),Z=!1},d(t){t&&(o(j),o(A),o(S),o(B),o(J),o(n),o(K),o(Y),o(X)),o(h),_(y,t),_(R,t),_(Q),_(w),_(C),_(P),_(D),_(N),_(F),_(L,t)}}}const Et='{"title":"Quantization","local":"quantization","sections":[{"title":"ORTQuantizer","local":"optimum.onnxruntime.ORTQuantizer","sections":[],"depth":2}],"depth":1}';function Mt(bt){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wt extends Pt{constructor(h){super(),Dt(this,h,Mt,Lt,Qt,{})}}export{Wt as component};
