import{s as ct,o as dt,n as ut}from"../chunks/scheduler.25b97de1.js";import{S as gt,i as ft,g as p,s as l,r,A as wt,h as i,f as s,c as n,j as ht,u as h,x as o,k as ae,y as vt,a,v as c,d,t as u,w as g}from"../chunks/index.d9030fc9.js";import{T as yt}from"../chunks/Tip.baa67368.js";import{C as w}from"../chunks/CodeBlock.e6cd0d95.js";import{H as Le,E as jt}from"../chunks/EditOnGithub.91d95064.js";function bt(le){let m,M='Check the <a href="https://huggingface.co/tasks/depth-estimation" rel="nofollow">Depth Estimation</a> task page to view all compatible architectures and checkpoints.';return{c(){m=p("p"),m.innerHTML=M},l(f){m=i(f,"P",{"data-svelte-h":!0}),o(m)!=="svelte-vf0won"&&(m.innerHTML=M)},m(f,te){a(f,m,te)},p:ut,d(f){f&&s(m)}}}function Mt(le){let m,M,f,te,$,ne,T,Ye=`Monocular depth estimation is a computer vision task that involves predicting the depth information of a scene from a
single image. In other words, it is the process of estimating the distance of objects in a scene from
a single camera viewpoint.`,pe,J,Ee=`Monocular depth estimation has various applications, including 3D reconstruction, augmented reality, autonomous driving,
and robotics. It is a challenging task as it requires the model to understand the complex relationships between objects
in the scene and the corresponding depth information, which can be affected by factors such as lighting conditions,
occlusion, and texture.`,ie,k,Qe="There are two main depth estimation categories:",oe,_,Se="<li><p><strong>Absolute depth estimation</strong>: This task variant aims to provide exact depth measurements from the camera. The term is used interchangeably with metric depth estimation, where depth is provided in precise measurements in meters or feet. Absolute depth estimation models output depth maps with numerical values that represent real-world distances.</p></li> <li><p><strong>Relative depth estimation</strong>: Relative depth estimation aims to predict the depth order of objects or points in a scene without providing the precise measurements. These models output a depth map that indicates which parts of the scene are closer or farther relative to each other without the actual distances to A and B.</p></li>",me,x,Xe='In this guide, we will see how to infer with <a href="https://huggingface.co/depth-anything/Depth-Anything-V2-Large" rel="nofollow">Depth Anything V2</a>, a state-of-the-art zero-shot relative depth estimation model, and <a href="https://huggingface.co/docs/transformers/main/en/model_doc/zoedepth" rel="nofollow">ZoeDepth</a>, an absolute depth estimation model.',re,v,he,U,qe="Before we begin, we need to install the latest version of Transformers:",ce,Z,de,C,ue,W,Pe=`The simplest way to try out inference with a model supporting depth estimation is to use the corresponding <a href="/docs/transformers/pr_30690/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>.
Instantiate a pipeline from a <a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>:`,ge,G,fe,B,Ae="Next, choose an image to analyze:",we,R,ve,y,De='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg" alt="Photo of a bee"/>',ye,H,Ke="Pass the image to the pipeline.",je,z,be,I,Oe=`The pipeline returns a dictionary with two entries. The first one, called <code>predicted_depth</code>, is a tensor with the values
being the depth expressed in meters for each pixel.
The second one, <code>depth</code>, is a PIL image that visualizes the depth estimation result.`,Me,N,et="Let’s take a look at the visualized result:",$e,V,Te,j,tt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-visualization.png" alt="Depth estimation visualization"/>',Je,F,ke,L,st="Now that you’ve seen how to use the depth estimation pipeline, let’s see how we can replicate the same result by hand.",_e,Y,at=`Start by loading the model and associated processor from a <a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>.
Here we’ll use the same checkpoint as before:`,xe,E,Ue,Q,lt=`Prepare the image input for the model using the <code>image_processor</code> that will take care of the necessary image transformations
such as resizing and normalization:`,Ze,S,Ce,X,nt="Pass the prepared inputs through the model:",We,q,Ge,P,pt="Let’s post-process and visualize the results.",Be,A,it="We need to pad and then resize the outputs so that predicted depth map has the same dimension as the original image. After resizing we will remove the padded regions from the depth.",Re,D,He,K,ot='We can now visualize the results (the function below is taken from the <a href="https://github.com/GaussianObject/GaussianObject/blob/ad6629efadb57902d5f8bc0fa562258029a4bdf1/pred_monodepth.py#L11" rel="nofollow">GaussianObject</a> framework).',ze,O,Ie,b,mt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-visualization-zoe.png" alt="Depth estimation visualization"/>',Ne,ee,Ve,se,Fe;return $=new Le({props:{title:"Monocular depth estimation",local:"monocular-depth-estimation",headingTag:"h1"}}),v=new yt({props:{$$slots:{default:[bt]},$$scope:{ctx:le}}}),Z=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwLVUlMjB0cmFuc2Zvcm1lcnM=",highlighted:"pip install -q -U transformers",wrap:!1}}),C=new Le({props:{title:"Depth estimation pipeline",local:"depth-estimation-pipeline",headingTag:"h2"}}),G=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJkZXB0aC1hbnl0aGluZyUyRkRlcHRoLUFueXRoaW5nLVYyLWJhc2UtaGYlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiUyQyUyMG1vZGVsJTNEY2hlY2twb2ludCUyQyUyMGRldmljZSUzRGRldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;depth-anything/Depth-Anything-V2-base-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=checkpoint, device=device)`,wrap:!1}}),R=new w({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZiZWUuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),z=new w({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBwaXBlKGltYWdlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = pipe(image)',wrap:!1}}),V=new w({props:{code:"cHJlZGljdGlvbnMlNUIlMjJkZXB0aCUyMiU1RA==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>predictions[<span class="hljs-string">&quot;depth&quot;</span>]',wrap:!1}}),F=new Le({props:{title:"Depth estimation inference by hand",local:"depth-estimation-inference-by-hand",headingTag:"h2"}}),E=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJJbnRlbCUyRnpvZWRlcHRoLW55dS1raXR0aSUyMiUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCkudG8oZGV2aWNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;Intel/zoedepth-nyu-kitti&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(checkpoint).to(device)`,wrap:!1}}),S=new w({props:{code:"cGl4ZWxfdmFsdWVzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVzLnRvKGRldmljZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values.to(device)',wrap:!1}}),q=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(pixel_values)`,wrap:!1}}),D=new w({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2gubm4uZnVuY3Rpb25hbCUyMGFzJTIwRiUwQSUwQXByZWRpY3RlZF9kZXB0aCUyMCUzRCUyMG91dHB1dHMucHJlZGljdGVkX2RlcHRoLnVuc3F1ZWV6ZShkaW0lM0QxKSUwQWhlaWdodCUyQyUyMHdpZHRoJTIwJTNEJTIwcGl4ZWxfdmFsdWVzLnNoYXBlJTVCMiUzQSU1RCUwQSUwQWhlaWdodF9wYWRkaW5nX2ZhY3RvciUyMCUzRCUyMHdpZHRoX3BhZGRpbmdfZmFjdG9yJTIwJTNEJTIwMyUwQXBhZF9oJTIwJTNEJTIwaW50KG5wLnNxcnQoaGVpZ2h0JTJGMiklMjAqJTIwaGVpZ2h0X3BhZGRpbmdfZmFjdG9yKSUwQXBhZF93JTIwJTNEJTIwaW50KG5wLnNxcnQod2lkdGglMkYyKSUyMColMjB3aWR0aF9wYWRkaW5nX2ZhY3RvciklMEElMEFpZiUyMHByZWRpY3RlZF9kZXB0aC5zaGFwZSU1Qi0yJTNBJTVEJTIwISUzRCUyMHBpeGVsX3ZhbHVlcy5zaGFwZSU1Qi0yJTNBJTVEJTNBJTBBJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwRi5pbnRlcnBvbGF0ZShwcmVkaWN0ZWRfZGVwdGglMkMlMjBzaXplJTNEJTIwKGhlaWdodCUyQyUyMHdpZHRoKSUyQyUyMG1vZGUlM0QnYmljdWJpYyclMkMlMjBhbGlnbl9jb3JuZXJzJTNERmFsc2UpJTBBJTBBaWYlMjBwYWRfaCUyMCUzRSUyMDAlM0ElMEFpZiUyMHBhZF93JTIwJTNFJTIwMCUzQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = outputs.predicted_depth.unsqueeze(dim=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>height, width = pixel_values.shape[<span class="hljs-number">2</span>:]

<span class="hljs-meta">&gt;&gt;&gt; </span>height_padding_factor = width_padding_factor = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pad_h = <span class="hljs-built_in">int</span>(np.sqrt(height/<span class="hljs-number">2</span>) * height_padding_factor)
<span class="hljs-meta">&gt;&gt;&gt; </span>pad_w = <span class="hljs-built_in">int</span>(np.sqrt(width/<span class="hljs-number">2</span>) * width_padding_factor)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> predicted_depth.shape[-<span class="hljs-number">2</span>:] != pixel_values.shape[-<span class="hljs-number">2</span>:]:
<span class="hljs-meta">&gt;&gt;&gt; </span>   predicted_depth = F.interpolate(predicted_depth, size= (height, width), mode=<span class="hljs-string">&#x27;bicubic&#x27;</span>, align_corners=<span class="hljs-literal">False</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> pad_h &gt; <span class="hljs-number">0</span>:
     predicted_depth = predicted_depth[:, :, pad_h:-pad_h,:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> pad_w &gt; <span class="hljs-number">0</span>:
     predicted_depth = predicted_depth[:, :, :, pad_w:-pad_w]`,wrap:!1}}),O=new w({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBcmVzdWx0JTIwJTNEJTIwY29sb3JpemUocHJlZGljdGVkX2RlcHRoLmNwdSgpLnNxdWVlemUoKS5udW1weSgpKSUwQUltYWdlLmZyb21hcnJheShyZXN1bHQp",highlighted:`<span class="hljs-keyword">import</span> matplotlib

<span class="hljs-keyword">def</span> <span class="hljs-title function_">colorize</span>(<span class="hljs-params">value, vmin=<span class="hljs-literal">None</span>, vmax=<span class="hljs-literal">None</span>, cmap=<span class="hljs-string">&#x27;gray_r&#x27;</span>, invalid_val=-<span class="hljs-number">99</span>, invalid_mask=<span class="hljs-literal">None</span>, background_color=(<span class="hljs-params"><span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">255</span></span>), gamma_corrected=<span class="hljs-literal">False</span>, value_transform=<span class="hljs-literal">None</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;Converts a depth map to a color image.

    Args:
        value (torch.Tensor, numpy.ndarray): Input depth map. Shape: (H, W) or (1, H, W) or (1, 1, H, W). All singular dimensions are squeezed
        vmin (float, optional): vmin-valued entries are mapped to start color of cmap. If None, value.min() is used. Defaults to None.
        vmax (float, optional):  vmax-valued entries are mapped to end color of cmap. If None, value.max() is used. Defaults to None.
        cmap (str, optional): matplotlib colormap to use. Defaults to &#x27;magma_r&#x27;.
        invalid_val (int, optional): Specifies value of invalid pixels that should be colored as &#x27;background_color&#x27;. Defaults to -99.
        invalid_mask (numpy.ndarray, optional): Boolean mask for invalid regions. Defaults to None.
        background_color (tuple[int], optional): 4-tuple RGB color to give to invalid pixels. Defaults to (128, 128, 128, 255).
        gamma_corrected (bool, optional): Apply gamma correction to colored image. Defaults to False.
        value_transform (Callable, optional): Apply transform function to valid pixels before coloring. Defaults to None.

    Returns:
        numpy.ndarray, dtype - uint8: Colored depth map. Shape: (H, W, 4)
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, torch.Tensor):
        value = value.detach().cpu().numpy()

    value = value.squeeze()
    <span class="hljs-keyword">if</span> invalid_mask <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        invalid_mask = value == invalid_val
    mask = np.logical_not(invalid_mask)

    <span class="hljs-comment"># normalize</span>
    vmin = np.percentile(value[mask],<span class="hljs-number">2</span>) <span class="hljs-keyword">if</span> vmin <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> vmin
    vmax = np.percentile(value[mask],<span class="hljs-number">85</span>) <span class="hljs-keyword">if</span> vmax <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> vmax
    <span class="hljs-keyword">if</span> vmin != vmax:
        value = (value - vmin) / (vmax - vmin)  <span class="hljs-comment"># vmin..vmax</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-comment"># Avoid 0-division</span>
        value = value * <span class="hljs-number">0.</span>

    <span class="hljs-comment"># squeeze last dim if it exists</span>
    <span class="hljs-comment"># grey out the invalid values</span>

    value[invalid_mask] = np.nan
    cmapper = matplotlib.colormaps.get_cmap(cmap)
    <span class="hljs-keyword">if</span> value_transform:
        value = value_transform(value)
        <span class="hljs-comment"># value = value / value.max()</span>
    value = cmapper(value, <span class="hljs-built_in">bytes</span>=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># (nxmx4)</span>

    <span class="hljs-comment"># img = value[:, :, :]</span>
    img = value[...]
    img[invalid_mask] = background_color

    <span class="hljs-comment">#     return img.transpose((2, 0, 1))</span>
    <span class="hljs-keyword">if</span> gamma_corrected:
        <span class="hljs-comment"># gamma correction</span>
        img = img / <span class="hljs-number">255</span>
        img = np.power(img, <span class="hljs-number">2.2</span>)
        img = img * <span class="hljs-number">255</span>
        img = img.astype(np.uint8)
    <span class="hljs-keyword">return</span> img

<span class="hljs-meta">&gt;&gt;&gt; </span>result = colorize(predicted_depth.cpu().squeeze().numpy())
<span class="hljs-meta">&gt;&gt;&gt; </span>Image.fromarray(result)`,wrap:!1}}),ee=new jt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/monocular_depth_estimation.md"}}),{c(){m=p("meta"),M=l(),f=p("p"),te=l(),r($.$$.fragment),ne=l(),T=p("p"),T.textContent=Ye,pe=l(),J=p("p"),J.textContent=Ee,ie=l(),k=p("p"),k.textContent=Qe,oe=l(),_=p("ul"),_.innerHTML=Se,me=l(),x=p("p"),x.innerHTML=Xe,re=l(),r(v.$$.fragment),he=l(),U=p("p"),U.textContent=qe,ce=l(),r(Z.$$.fragment),de=l(),r(C.$$.fragment),ue=l(),W=p("p"),W.innerHTML=Pe,ge=l(),r(G.$$.fragment),fe=l(),B=p("p"),B.textContent=Ae,we=l(),r(R.$$.fragment),ve=l(),y=p("div"),y.innerHTML=De,ye=l(),H=p("p"),H.textContent=Ke,je=l(),r(z.$$.fragment),be=l(),I=p("p"),I.innerHTML=Oe,Me=l(),N=p("p"),N.textContent=et,$e=l(),r(V.$$.fragment),Te=l(),j=p("div"),j.innerHTML=tt,Je=l(),r(F.$$.fragment),ke=l(),L=p("p"),L.textContent=st,_e=l(),Y=p("p"),Y.innerHTML=at,xe=l(),r(E.$$.fragment),Ue=l(),Q=p("p"),Q.innerHTML=lt,Ze=l(),r(S.$$.fragment),Ce=l(),X=p("p"),X.textContent=nt,We=l(),r(q.$$.fragment),Ge=l(),P=p("p"),P.textContent=pt,Be=l(),A=p("p"),A.textContent=it,Re=l(),r(D.$$.fragment),He=l(),K=p("p"),K.innerHTML=ot,ze=l(),r(O.$$.fragment),Ie=l(),b=p("div"),b.innerHTML=mt,Ne=l(),r(ee.$$.fragment),Ve=l(),se=p("p"),this.h()},l(e){const t=wt("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(s),M=n(e),f=i(e,"P",{}),ht(f).forEach(s),te=n(e),h($.$$.fragment,e),ne=n(e),T=i(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1elgt0a"&&(T.textContent=Ye),pe=n(e),J=i(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-szef6f"&&(J.textContent=Ee),ie=n(e),k=i(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1evxf27"&&(k.textContent=Qe),oe=n(e),_=i(e,"UL",{"data-svelte-h":!0}),o(_)!=="svelte-1l3knez"&&(_.innerHTML=Se),me=n(e),x=i(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-9hlqcm"&&(x.innerHTML=Xe),re=n(e),h(v.$$.fragment,e),he=n(e),U=i(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-n2hqrn"&&(U.textContent=qe),ce=n(e),h(Z.$$.fragment,e),de=n(e),h(C.$$.fragment,e),ue=n(e),W=i(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1f86hik"&&(W.innerHTML=Pe),ge=n(e),h(G.$$.fragment,e),fe=n(e),B=i(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-wuz5lr"&&(B.textContent=Ae),we=n(e),h(R.$$.fragment,e),ve=n(e),y=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-6n7vnz"&&(y.innerHTML=De),ye=n(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-mcr1tn"&&(H.textContent=Ke),je=n(e),h(z.$$.fragment,e),be=n(e),I=i(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1jckqfu"&&(I.innerHTML=Oe),Me=n(e),N=i(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1dzpyfr"&&(N.textContent=et),$e=n(e),h(V.$$.fragment,e),Te=n(e),j=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-43wxxb"&&(j.innerHTML=tt),Je=n(e),h(F.$$.fragment,e),ke=n(e),L=i(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1u79cc9"&&(L.textContent=st),_e=n(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1r8mctn"&&(Y.innerHTML=at),xe=n(e),h(E.$$.fragment,e),Ue=n(e),Q=i(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-hhrw3"&&(Q.innerHTML=lt),Ze=n(e),h(S.$$.fragment,e),Ce=n(e),X=i(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1yk8q0z"&&(X.textContent=nt),We=n(e),h(q.$$.fragment,e),Ge=n(e),P=i(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-e3gnzr"&&(P.textContent=pt),Be=n(e),A=i(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-10z56um"&&(A.textContent=it),Re=n(e),h(D.$$.fragment,e),He=n(e),K=i(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-i8h4hx"&&(K.innerHTML=ot),ze=n(e),h(O.$$.fragment,e),Ie=n(e),b=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-18ny996"&&(b.innerHTML=mt),Ne=n(e),h(ee.$$.fragment,e),Ve=n(e),se=i(e,"P",{}),ht(se).forEach(s),this.h()},h(){ae(m,"name","hf:doc:metadata"),ae(m,"content",$t),ae(y,"class","flex justify-center"),ae(j,"class","flex justify-center"),ae(b,"class","flex justify-center")},m(e,t){vt(document.head,m),a(e,M,t),a(e,f,t),a(e,te,t),c($,e,t),a(e,ne,t),a(e,T,t),a(e,pe,t),a(e,J,t),a(e,ie,t),a(e,k,t),a(e,oe,t),a(e,_,t),a(e,me,t),a(e,x,t),a(e,re,t),c(v,e,t),a(e,he,t),a(e,U,t),a(e,ce,t),c(Z,e,t),a(e,de,t),c(C,e,t),a(e,ue,t),a(e,W,t),a(e,ge,t),c(G,e,t),a(e,fe,t),a(e,B,t),a(e,we,t),c(R,e,t),a(e,ve,t),a(e,y,t),a(e,ye,t),a(e,H,t),a(e,je,t),c(z,e,t),a(e,be,t),a(e,I,t),a(e,Me,t),a(e,N,t),a(e,$e,t),c(V,e,t),a(e,Te,t),a(e,j,t),a(e,Je,t),c(F,e,t),a(e,ke,t),a(e,L,t),a(e,_e,t),a(e,Y,t),a(e,xe,t),c(E,e,t),a(e,Ue,t),a(e,Q,t),a(e,Ze,t),c(S,e,t),a(e,Ce,t),a(e,X,t),a(e,We,t),c(q,e,t),a(e,Ge,t),a(e,P,t),a(e,Be,t),a(e,A,t),a(e,Re,t),c(D,e,t),a(e,He,t),a(e,K,t),a(e,ze,t),c(O,e,t),a(e,Ie,t),a(e,b,t),a(e,Ne,t),c(ee,e,t),a(e,Ve,t),a(e,se,t),Fe=!0},p(e,[t]){const rt={};t&2&&(rt.$$scope={dirty:t,ctx:e}),v.$set(rt)},i(e){Fe||(d($.$$.fragment,e),d(v.$$.fragment,e),d(Z.$$.fragment,e),d(C.$$.fragment,e),d(G.$$.fragment,e),d(R.$$.fragment,e),d(z.$$.fragment,e),d(V.$$.fragment,e),d(F.$$.fragment,e),d(E.$$.fragment,e),d(S.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),Fe=!0)},o(e){u($.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(C.$$.fragment,e),u(G.$$.fragment,e),u(R.$$.fragment,e),u(z.$$.fragment,e),u(V.$$.fragment,e),u(F.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(q.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),Fe=!1},d(e){e&&(s(M),s(f),s(te),s(ne),s(T),s(pe),s(J),s(ie),s(k),s(oe),s(_),s(me),s(x),s(re),s(he),s(U),s(ce),s(de),s(ue),s(W),s(ge),s(fe),s(B),s(we),s(ve),s(y),s(ye),s(H),s(je),s(be),s(I),s(Me),s(N),s($e),s(Te),s(j),s(Je),s(ke),s(L),s(_e),s(Y),s(xe),s(Ue),s(Q),s(Ze),s(Ce),s(X),s(We),s(Ge),s(P),s(Be),s(A),s(Re),s(He),s(K),s(ze),s(Ie),s(b),s(Ne),s(Ve),s(se)),s(m),g($,e),g(v,e),g(Z,e),g(C,e),g(G,e),g(R,e),g(z,e),g(V,e),g(F,e),g(E,e),g(S,e),g(q,e),g(D,e),g(O,e),g(ee,e)}}}const $t='{"title":"Monocular depth estimation","local":"monocular-depth-estimation","sections":[{"title":"Depth estimation pipeline","local":"depth-estimation-pipeline","sections":[],"depth":2},{"title":"Depth estimation inference by hand","local":"depth-estimation-inference-by-hand","sections":[],"depth":2}],"depth":1}';function Tt(le){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zt extends gt{constructor(m){super(),ft(this,m,Tt,Mt,ct,{})}}export{Zt as component};
