import{s as Vo,o as Xo,n as B}from"../chunks/scheduler.25b97de1.js";import{S as So,i as Qo,g as c,s as r,r as f,A as Yo,h as p,f as i,c as l,j as N,u as g,x as h,k as L,y as a,a as m,v as _,d as b,t as y,w as T}from"../chunks/index.d9030fc9.js";import{T as ot}from"../chunks/Tip.baa67368.js";import{D as Y}from"../chunks/Docstring.e257edda.js";import{C as st}from"../chunks/CodeBlock.e6cd0d95.js";import{E as nt}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as A,E as Po}from"../chunks/EditOnGithub.91d95064.js";function Eo(k){let t,u=`Falcon models were initially added to the Hugging Face Hub as custom code checkpoints. However, Falcon is now fully
supported in the Transformers library. If you fine-tuned a model from a custom code checkpoint, we recommend converting
your checkpoint to the new in-library format, as this should give significant improvements to stability and
performance, especially for generation, as well as removing the need to use <code>trust_remote_code=True</code>!`;return{c(){t=c("p"),t.innerHTML=u},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-9k32i0"&&(t.innerHTML=u)},m(s,d){m(s,t,d)},p:B,d(s){s&&i(t)}}}function Ao(k){let t,u="Example:",s,d,w;return d=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZhbGNvbk1vZGVsJTJDJTIwRmFsY29uQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMHNtYWxsJTIwKDItbGF5ZXIpJTIwRmFsY29uJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBGYWxjb25Db25maWcobnVtX2hpZGRlbl9sYXllcnMlM0QyKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBzbWFsbCUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEZhbGNvbk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FalconModel, FalconConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a small (2-layer) Falcon configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = FalconConfig(num_hidden_layers=<span class="hljs-number">2</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the small configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,s=r(),f(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),s=l(o),g(d.$$.fragment,o)},m(o,v){m(o,t,v),m(o,s,v),_(d,o,v),w=!0},p:B,i(o){w||(b(d.$$.fragment,o),w=!0)},o(o){y(d.$$.fragment,o),w=!1},d(o){o&&(i(t),i(s)),T(d,o)}}}function Oo(k){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=u},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(s,d){m(s,t,d)},p:B,d(s){s&&i(t)}}}function Do(k){let t,u="Example:",s,d,w;return d=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGYWxjb25Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiklMEFtb2RlbCUyMCUzRCUyMEZhbGNvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJSb2NrZXRrbmlnaHQxJTJGZmFsY29uLXJ3LTFiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FalconModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconModel.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,s=r(),f(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),s=l(o),g(d.$$.fragment,o)},m(o,v){m(o,t,v),m(o,s,v),_(d,o,v),w=!0},p:B,i(o){w||(b(d.$$.fragment,o),w=!0)},o(o){y(d.$$.fragment,o),w=!1},d(o){o&&(i(t),i(s)),T(d,o)}}}function Ko(k){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=u},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(s,d){m(s,t,d)},p:B,d(s){s&&i(t)}}}function en(k){let t,u="Example:",s,d,w;return d=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEZhbGNvbkZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiklMEFtb2RlbCUyMCUzRCUyMEZhbGNvbkZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJSb2NrZXRrbmlnaHQxJTJGZmFsY29uLXJ3LTFiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FalconForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconForCausalLM.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,s=r(),f(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),s=l(o),g(d.$$.fragment,o)},m(o,v){m(o,t,v),m(o,s,v),_(d,o,v),w=!0},p:B,i(o){w||(b(d.$$.fragment,o),w=!0)},o(o){y(d.$$.fragment,o),w=!1},d(o){o&&(i(t),i(s)),T(d,o)}}}function tn(k){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=u},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(s,d){m(s,t,d)},p:B,d(s){s&&i(t)}}}function on(k){let t,u="Example of single-label classification:",s,d,w;return d=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEZhbGNvbkZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJSb2NrZXRrbmlnaHQxJTJGZmFsY29uLXJ3LTFiJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmFsY29uRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWQlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KCkuaXRlbSgpJTBBJTBBJTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwRmFsY29uRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FalconForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,s=r(),f(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-ykxpe4"&&(t.textContent=u),s=l(o),g(d.$$.fragment,o)},m(o,v){m(o,t,v),m(o,s,v),_(d,o,v),w=!0},p:B,i(o){w||(b(d.$$.fragment,o),w=!0)},o(o){y(d.$$.fragment,o),w=!1},d(o){o&&(i(t),i(s)),T(d,o)}}}function nn(k){let t,u="Example of multi-label classification:",s,d,w;return d=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEZhbGNvbkZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJSb2NrZXRrbmlnaHQxJTJGZmFsY29uLXJ3LTFiJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmFsY29uRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiUyQyUyMHByb2JsZW1fdHlwZSUzRCUyMm11bHRpX2xhYmVsX2NsYXNzaWZpY2F0aW9uJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZHMlMjAlM0QlMjB0b3JjaC5hcmFuZ2UoMCUyQyUyMGxvZ2l0cy5zaGFwZSU1Qi0xJTVEKSU1QnRvcmNoLnNpZ21vaWQobG9naXRzKS5zcXVlZXplKGRpbSUzRDApJTIwJTNFJTIwMC41JTVEJTBBJTBBJTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwRmFsY29uRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FalconForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,s=r(),f(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1l8e32d"&&(t.textContent=u),s=l(o),g(d.$$.fragment,o)},m(o,v){m(o,t,v),m(o,s,v),_(d,o,v),w=!0},p:B,i(o){w||(b(d.$$.fragment,o),w=!0)},o(o){y(d.$$.fragment,o),w=!1},d(o){o&&(i(t),i(s)),T(d,o)}}}function sn(k){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=u},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(s,d){m(s,t,d)},p:B,d(s){s&&i(t)}}}function an(k){let t,u="Example:",s,d,w;return d=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGYWxjb25Gb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJSb2NrZXRrbmlnaHQxJTJGZmFsY29uLXJ3LTFiJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmFsY29uRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySHVnZ2luZ0ZhY2UlMjBpcyUyMGElMjBjb21wYW55JTIwYmFzZWQlMjBpbiUyMFBhcmlzJTIwYW5kJTIwTmV3JTIwWW9yayUyMiUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKSUwQSUwQSUyMyUyME5vdGUlMjB0aGF0JTIwdG9rZW5zJTIwYXJlJTIwY2xhc3NpZmllZCUyMHJhdGhlciUyMHRoZW4lMjBpbnB1dCUyMHdvcmRzJTIwd2hpY2glMjBtZWFucyUyMHRoYXQlMEElMjMlMjB0aGVyZSUyMG1pZ2h0JTIwYmUlMjBtb3JlJTIwcHJlZGljdGVkJTIwdG9rZW4lMjBjbGFzc2VzJTIwdGhhbiUyMHdvcmRzLiUwQSUyMyUyME11bHRpcGxlJTIwdG9rZW4lMjBjbGFzc2VzJTIwbWlnaHQlMjBhY2NvdW50JTIwZm9yJTIwdGhlJTIwc2FtZSUyMHdvcmQlMEFwcmVkaWN0ZWRfdG9rZW5zX2NsYXNzZXMlMjAlM0QlMjAlNUJtb2RlbC5jb25maWcuaWQybGFiZWwlNUJ0Lml0ZW0oKSU1RCUyMGZvciUyMHQlMjBpbiUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlNUIwJTVEJTVEJTBBJTBBbGFiZWxzJTIwJTNEJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FalconForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconForTokenClassification.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=c("p"),t.textContent=u,s=r(),f(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),s=l(o),g(d.$$.fragment,o)},m(o,v){m(o,t,v),m(o,s,v),_(d,o,v),w=!0},p:B,i(o){w||(b(d.$$.fragment,o),w=!0)},o(o){y(d.$$.fragment,o),w=!1},d(o){o&&(i(t),i(s)),T(d,o)}}}function rn(k){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=u},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(s,d){m(s,t,d)},p:B,d(s){s&&i(t)}}}function ln(k){let t,u,s,d,w,o,v,rt,de,ho=`Falcon is a class of causal decoder-only models built by <a href="https://www.tii.ae/" rel="nofollow">TII</a>. The largest Falcon checkpoints
have been trained on &gt;=1T tokens of text, with a particular emphasis on the <a href="https://arxiv.org/abs/2306.01116" rel="nofollow">RefinedWeb</a>
corpus. They are made available under the Apache 2.0 license.`,lt,ce,fo=`Falcon’s architecture is modern and optimized for inference, with multi-query attention and support for efficient
attention variants like <code>FlashAttention</code>. Both ‘base’ models trained only as causal language models as well as
‘instruct’ models that have received further fine-tuning are available.`,it,pe,go=`Falcon models are (as of 2023) some of the largest and most powerful open-source language models,
and consistently rank highly in the <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">OpenLLM leaderboard</a>.`,dt,me,ct,O,pt,ue,_o=`You can convert custom code checkpoints to full Transformers checkpoints using the <code>convert_custom_code_checkpoint.py</code>
script located in the
<a href="https://github.com/huggingface/transformers/tree/main/src/transformers/models/falcon" rel="nofollow">Falcon model directory</a>
of the Transformers library. To use this script, simply call it with
<code>python convert_custom_code_checkpoint.py --checkpoint_dir my_model</code>. This will convert your checkpoint in-place, and
you can immediately load it from the directory afterwards with e.g. <code>from_pretrained()</code>. If your model hasn’t been
uploaded to the Hub, we recommend making a backup before attempting the conversion, just in case!`,mt,he,ut,z,fe,Ct,Ie,bo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconModel">FalconModel</a>. It is used to instantiate a Falcon
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/tiiuae/falcon-7b" rel="nofollow">tiiuae/falcon-7b</a> architecture.`,xt,Ue,yo=`Configuration objects inherit from <a href="/docs/transformers/pr_27501/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_27501/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Jt,D,ht,ge,ft,$,_e,jt,We,To="The bare Falcon Model transformer outputting raw hidden-states without any specific head on top.",zt,Ze,wo=`This model inherits from <a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,It,qe,vo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ut,G,be,Wt,Ne,ko='The <a href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconModel">FalconModel</a> forward method, overrides the <code>__call__</code> special method.',Zt,K,qt,ee,gt,ye,_t,C,Te,Nt,Le,Mo="The Falcon Model transformer with a language modeling head on top (linear layer with weights tied to the input embeddings).",Lt,Ge,Fo=`This model inherits from <a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,Gt,Re,$o=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Rt,R,we,Ht,He,Co='The <a href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconForCausalLM">FalconForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Bt,te,Vt,oe,bt,ve,yt,M,ke,Xt,Be,xo="The Falcon Model transformer with a sequence classification head on top (linear layer).",St,Ve,Jo=`<a href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconForSequenceClassification">FalconForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-1) do.`,Qt,Xe,jo=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,Yt,Se,zo=`This model inherits from <a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,Pt,Qe,Io=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Et,j,Me,At,Ye,Uo='The <a href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconForSequenceClassification">FalconForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Ot,ne,Dt,se,Kt,ae,Tt,Fe,wt,x,$e,eo,Pe,Wo=`Falcon Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,to,Ee,Zo=`This model inherits from <a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,oo,Ae,qo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,no,H,Ce,so,Oe,No='The <a href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconForTokenClassification">FalconForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',ao,re,ro,le,vt,xe,kt,J,Je,lo,De,Lo=`The Falcon Model transformer with a span classification head on top for extractive question-answering tasks like
SQuAD (a linear layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,io,Ke,Go=`This model inherits from <a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,co,et,Ro=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,po,P,je,mo,tt,Ho='The <a href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconForQuestionAnswering">FalconForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',uo,ie,Mt,ze,Ft,at,$t;return w=new A({props:{title:"Falcon",local:"falcon",headingTag:"h1"}}),v=new A({props:{title:"Overview",local:"overview",headingTag:"h2"}}),me=new A({props:{title:"Converting custom checkpoints",local:"converting-custom-checkpoints",headingTag:"h2"}}),O=new ot({props:{$$slots:{default:[Eo]},$$scope:{ctx:k}}}),he=new A({props:{title:"FalconConfig",local:"transformers.FalconConfig",headingTag:"h2"}}),fe=new Y({props:{name:"class transformers.FalconConfig",anchor:"transformers.FalconConfig",parameters:[{name:"vocab_size",val:" = 65024"},{name:"hidden_size",val:" = 4544"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 71"},{name:"num_ln_in_parallel_attn",val:" = None"},{name:"layer_norm_epsilon",val:" = 1e-05"},{name:"initializer_range",val:" = 0.02"},{name:"use_cache",val:" = True"},{name:"hidden_dropout",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"num_kv_heads",val:" = None"},{name:"alibi",val:" = False"},{name:"new_decoder_architecture",val:" = False"},{name:"multi_query",val:" = True"},{name:"parallel_attn",val:" = True"},{name:"bias",val:" = False"},{name:"max_position_embeddings",val:" = 2048"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"bos_token_id",val:" = 11"},{name:"eos_token_id",val:" = 11"},{name:"ffn_hidden_size",val:" = None"},{name:"activation",val:" = 'gelu'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FalconConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 65024) &#x2014;
Vocabulary size of the Falcon model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconModel">FalconModel</a>`,name:"vocab_size"},{anchor:"transformers.FalconConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4544) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.FalconConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.FalconConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 71) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.FalconConfig.num_ln_in_parallel_attn",description:`<strong>num_ln_in_parallel_attn</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Set to 2 if separate layer norms are to be used for the MLP and the attention output when using parallel
attention, otherwise, 1.`,name:"num_ln_in_parallel_attn"},{anchor:"transformers.FalconConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_epsilon"},{anchor:"transformers.FalconConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.FalconConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model should return the last key/values attentions (not used by all models). Only relevant if
<code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.FalconConfig.hidden_dropout",description:`<strong>hidden_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for MLP layers.`,name:"hidden_dropout"},{anchor:"transformers.FalconConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for attention layers.`,name:"attention_dropout"},{anchor:"transformers.FalconConfig.num_kv_heads",description:`<strong>num_kv_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of key-value heads to use per attention layer. If unset, defaults to the same value as
<code>num_attention_heads</code>.`,name:"num_kv_heads"},{anchor:"transformers.FalconConfig.alibi",description:`<strong>alibi</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use ALiBi positional biases during self-attention.`,name:"alibi"},{anchor:"transformers.FalconConfig.new_decoder_architecture",description:`<strong>new_decoder_architecture</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use the new (Falcon-40B) decoder architecture. If <code>True</code>, the <code>multi_query</code> and <code>parallel_attn</code>
arguments are ignored, as the new decoder always uses parallel attention.`,name:"new_decoder_architecture"},{anchor:"transformers.FalconConfig.multi_query",description:`<strong>multi_query</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use multi-query attention in the decoder. Ignored when <code>new_decoder_architecture</code> is <code>True</code>.`,name:"multi_query"},{anchor:"transformers.FalconConfig.parallel_attn",description:`<strong>parallel_attn</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to compute attention in parallel with the feedforward layer. If False, they are consecutive
instead, as in the original Transformer architecture. Ignored when <code>new_decoder_architecture</code> is <code>True</code>.`,name:"parallel_attn"},{anchor:"transformers.FalconConfig.bias",description:`<strong>bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use bias on Linear layers.`,name:"bias"},{anchor:"transformers.FalconConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with, when <code>alibi</code> is <code>False</code>. Pretrained
Falcon models with RoPE support up to 2048 tokens.`,name:"max_position_embeddings"},{anchor:"transformers.FalconConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.FalconConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. Currently supports two scaling
strategies: linear and dynamic. Their scaling factor must be a float greater than 1. The expected format is
<code>{&quot;type&quot;: strategy name, &quot;factor&quot;: scaling factor}</code>. When using this flag, don&#x2019;t update
<code>max_position_embeddings</code> to the expected new maximum. See the following thread for more information on how
these scaling strategies behave:
<a href="https://www.reddit.com/r/LocalLLaMA/comments/14mrgpr/dynamically_scaled_rope_further_increases/" rel="nofollow">https://www.reddit.com/r/LocalLLaMA/comments/14mrgpr/dynamically_scaled_rope_further_increases/</a>. This is an
experimental feature, subject to breaking API changes in future versions.`,name:"rope_scaling"},{anchor:"transformers.FalconConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 11) &#x2014;
The id of the &#x201C;beginning-of-sequence&#x201D; token.`,name:"bos_token_id"},{anchor:"transformers.FalconConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 11) &#x2014;
The id of the &#x201C;end-of-sequence&#x201D; token.`,name:"eos_token_id"},{anchor:"transformers.FalconConfig.ffn_hidden_size",description:`<strong>ffn_hidden_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The hidden size of the feedforward layer in the Transformer decoder.
defaults to 4x hidden dim`,name:"ffn_hidden_size"},{anchor:"transformers.FalconConfig.activation",description:`<strong>activation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used in the feedforward layer.`,name:"activation"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/models/falcon/configuration_falcon.py#L24"}}),D=new nt({props:{anchor:"transformers.FalconConfig.example",$$slots:{default:[Ao]},$$scope:{ctx:k}}}),ge=new A({props:{title:"FalconModel",local:"transformers.FalconModel",headingTag:"h2"}}),_e=new Y({props:{name:"class transformers.FalconModel",anchor:"transformers.FalconModel",parameters:[{name:"config",val:": FalconConfig"}],parametersDescription:[{anchor:"transformers.FalconModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/models/falcon/modeling_falcon.py#L969"}}),be=new Y({props:{name:"forward",anchor:"transformers.FalconModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FalconModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_27501/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_27501/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_27501/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FalconModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.num_hidden_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.FalconModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FalconModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.FalconModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.FalconModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.FalconModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FalconModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FalconModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FalconModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/models/falcon/modeling_falcon.py#L1003",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconConfig"
>FalconConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new ot({props:{$$slots:{default:[Oo]},$$scope:{ctx:k}}}),ee=new nt({props:{anchor:"transformers.FalconModel.forward.example",$$slots:{default:[Do]},$$scope:{ctx:k}}}),ye=new A({props:{title:"FalconForCausalLM",local:"transformers.FalconForCausalLM",headingTag:"h2"}}),Te=new Y({props:{name:"class transformers.FalconForCausalLM",anchor:"transformers.FalconForCausalLM",parameters:[{name:"config",val:": FalconConfig"}],parametersDescription:[{anchor:"transformers.FalconForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/models/falcon/modeling_falcon.py#L1181"}}),we=new Y({props:{name:"forward",anchor:"transformers.FalconForCausalLM.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FalconForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_27501/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_27501/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_27501/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FalconForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.num_hidden_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.FalconForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FalconForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.FalconForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.FalconForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.FalconForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FalconForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FalconForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FalconForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.FalconForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/models/falcon/modeling_falcon.py#L1246",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconConfig"
>FalconConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new ot({props:{$$slots:{default:[Ko]},$$scope:{ctx:k}}}),oe=new nt({props:{anchor:"transformers.FalconForCausalLM.forward.example",$$slots:{default:[en]},$$scope:{ctx:k}}}),ve=new A({props:{title:"FalconForSequenceClassification",local:"transformers.FalconForSequenceClassification",headingTag:"h2"}}),ke=new Y({props:{name:"class transformers.FalconForSequenceClassification",anchor:"transformers.FalconForSequenceClassification",parameters:[{name:"config",val:": FalconConfig"}],parametersDescription:[{anchor:"transformers.FalconForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/models/falcon/modeling_falcon.py#L1340"}}),Me=new Y({props:{name:"forward",anchor:"transformers.FalconForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FalconForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_27501/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_27501/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_27501/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FalconForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.num_hidden_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.FalconForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FalconForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.FalconForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.FalconForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.FalconForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FalconForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FalconForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FalconForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.FalconForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/models/falcon/modeling_falcon.py#L1365",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconConfig"
>FalconConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ne=new ot({props:{$$slots:{default:[tn]},$$scope:{ctx:k}}}),se=new nt({props:{anchor:"transformers.FalconForSequenceClassification.forward.example",$$slots:{default:[on]},$$scope:{ctx:k}}}),ae=new nt({props:{anchor:"transformers.FalconForSequenceClassification.forward.example-2",$$slots:{default:[nn]},$$scope:{ctx:k}}}),Fe=new A({props:{title:"FalconForTokenClassification",local:"transformers.FalconForTokenClassification",headingTag:"h2"}}),$e=new Y({props:{name:"class transformers.FalconForTokenClassification",anchor:"transformers.FalconForTokenClassification",parameters:[{name:"config",val:": FalconConfig"}],parametersDescription:[{anchor:"transformers.FalconForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/models/falcon/modeling_falcon.py#L1467"}}),Ce=new Y({props:{name:"forward",anchor:"transformers.FalconForTokenClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FalconForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_27501/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_27501/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_27501/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FalconForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.num_hidden_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.FalconForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FalconForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.FalconForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.FalconForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.FalconForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FalconForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FalconForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FalconForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.FalconForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/models/falcon/modeling_falcon.py#L1492",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconConfig"
>FalconConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),re=new ot({props:{$$slots:{default:[sn]},$$scope:{ctx:k}}}),le=new nt({props:{anchor:"transformers.FalconForTokenClassification.forward.example",$$slots:{default:[an]},$$scope:{ctx:k}}}),xe=new A({props:{title:"FalconForQuestionAnswering",local:"transformers.FalconForQuestionAnswering",headingTag:"h2"}}),Je=new Y({props:{name:"class transformers.FalconForQuestionAnswering",anchor:"transformers.FalconForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.FalconForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_27501/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/models/falcon/modeling_falcon.py#L1556"}}),je=new Y({props:{name:"forward",anchor:"transformers.FalconForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"start_positions",val:": Optional = None"},{name:"end_positions",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FalconForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_27501/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_27501/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_27501/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FalconForQuestionAnswering.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.num_hidden_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.FalconForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FalconForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.FalconForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.FalconForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.FalconForQuestionAnswering.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FalconForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FalconForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FalconForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.FalconForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.FalconForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/models/falcon/modeling_falcon.py#L1572"}}),ie=new ot({props:{$$slots:{default:[rn]},$$scope:{ctx:k}}}),ze=new Po({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/falcon.md"}}),{c(){t=c("meta"),u=r(),s=c("p"),d=r(),f(w.$$.fragment),o=r(),f(v.$$.fragment),rt=r(),de=c("p"),de.innerHTML=ho,lt=r(),ce=c("p"),ce.innerHTML=fo,it=r(),pe=c("p"),pe.innerHTML=go,dt=r(),f(me.$$.fragment),ct=r(),f(O.$$.fragment),pt=r(),ue=c("p"),ue.innerHTML=_o,mt=r(),f(he.$$.fragment),ut=r(),z=c("div"),f(fe.$$.fragment),Ct=r(),Ie=c("p"),Ie.innerHTML=bo,xt=r(),Ue=c("p"),Ue.innerHTML=yo,Jt=r(),f(D.$$.fragment),ht=r(),f(ge.$$.fragment),ft=r(),$=c("div"),f(_e.$$.fragment),jt=r(),We=c("p"),We.textContent=To,zt=r(),Ze=c("p"),Ze.innerHTML=wo,It=r(),qe=c("p"),qe.innerHTML=vo,Ut=r(),G=c("div"),f(be.$$.fragment),Wt=r(),Ne=c("p"),Ne.innerHTML=ko,Zt=r(),f(K.$$.fragment),qt=r(),f(ee.$$.fragment),gt=r(),f(ye.$$.fragment),_t=r(),C=c("div"),f(Te.$$.fragment),Nt=r(),Le=c("p"),Le.textContent=Mo,Lt=r(),Ge=c("p"),Ge.innerHTML=Fo,Gt=r(),Re=c("p"),Re.innerHTML=$o,Rt=r(),R=c("div"),f(we.$$.fragment),Ht=r(),He=c("p"),He.innerHTML=Co,Bt=r(),f(te.$$.fragment),Vt=r(),f(oe.$$.fragment),bt=r(),f(ve.$$.fragment),yt=r(),M=c("div"),f(ke.$$.fragment),Xt=r(),Be=c("p"),Be.textContent=xo,St=r(),Ve=c("p"),Ve.innerHTML=Jo,Qt=r(),Xe=c("p"),Xe.innerHTML=jo,Yt=r(),Se=c("p"),Se.innerHTML=zo,Pt=r(),Qe=c("p"),Qe.innerHTML=Io,Et=r(),j=c("div"),f(Me.$$.fragment),At=r(),Ye=c("p"),Ye.innerHTML=Uo,Ot=r(),f(ne.$$.fragment),Dt=r(),f(se.$$.fragment),Kt=r(),f(ae.$$.fragment),Tt=r(),f(Fe.$$.fragment),wt=r(),x=c("div"),f($e.$$.fragment),eo=r(),Pe=c("p"),Pe.textContent=Wo,to=r(),Ee=c("p"),Ee.innerHTML=Zo,oo=r(),Ae=c("p"),Ae.innerHTML=qo,no=r(),H=c("div"),f(Ce.$$.fragment),so=r(),Oe=c("p"),Oe.innerHTML=No,ao=r(),f(re.$$.fragment),ro=r(),f(le.$$.fragment),vt=r(),f(xe.$$.fragment),kt=r(),J=c("div"),f(Je.$$.fragment),lo=r(),De=c("p"),De.innerHTML=Lo,io=r(),Ke=c("p"),Ke.innerHTML=Go,co=r(),et=c("p"),et.innerHTML=Ro,po=r(),P=c("div"),f(je.$$.fragment),mo=r(),tt=c("p"),tt.innerHTML=Ho,uo=r(),f(ie.$$.fragment),Mt=r(),f(ze.$$.fragment),Ft=r(),at=c("p"),this.h()},l(e){const n=Yo("svelte-u9bgzb",document.head);t=p(n,"META",{name:!0,content:!0}),n.forEach(i),u=l(e),s=p(e,"P",{}),N(s).forEach(i),d=l(e),g(w.$$.fragment,e),o=l(e),g(v.$$.fragment,e),rt=l(e),de=p(e,"P",{"data-svelte-h":!0}),h(de)!=="svelte-10avqgm"&&(de.innerHTML=ho),lt=l(e),ce=p(e,"P",{"data-svelte-h":!0}),h(ce)!=="svelte-yb5860"&&(ce.innerHTML=fo),it=l(e),pe=p(e,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-nzqfj1"&&(pe.innerHTML=go),dt=l(e),g(me.$$.fragment,e),ct=l(e),g(O.$$.fragment,e),pt=l(e),ue=p(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-1ct6uvq"&&(ue.innerHTML=_o),mt=l(e),g(he.$$.fragment,e),ut=l(e),z=p(e,"DIV",{class:!0});var V=N(z);g(fe.$$.fragment,V),Ct=l(V),Ie=p(V,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-1fr101c"&&(Ie.innerHTML=bo),xt=l(V),Ue=p(V,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-w18d2z"&&(Ue.innerHTML=yo),Jt=l(V),g(D.$$.fragment,V),V.forEach(i),ht=l(e),g(ge.$$.fragment,e),ft=l(e),$=p(e,"DIV",{class:!0});var I=N($);g(_e.$$.fragment,I),jt=l(I),We=p(I,"P",{"data-svelte-h":!0}),h(We)!=="svelte-13ll91i"&&(We.textContent=To),zt=l(I),Ze=p(I,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-1jlorl"&&(Ze.innerHTML=wo),It=l(I),qe=p(I,"P",{"data-svelte-h":!0}),h(qe)!=="svelte-hswkmf"&&(qe.innerHTML=vo),Ut=l(I),G=p(I,"DIV",{class:!0});var X=N(G);g(be.$$.fragment,X),Wt=l(X),Ne=p(X,"P",{"data-svelte-h":!0}),h(Ne)!=="svelte-izvl4v"&&(Ne.innerHTML=ko),Zt=l(X),g(K.$$.fragment,X),qt=l(X),g(ee.$$.fragment,X),X.forEach(i),I.forEach(i),gt=l(e),g(ye.$$.fragment,e),_t=l(e),C=p(e,"DIV",{class:!0});var U=N(C);g(Te.$$.fragment,U),Nt=l(U),Le=p(U,"P",{"data-svelte-h":!0}),h(Le)!=="svelte-88v1u6"&&(Le.textContent=Mo),Lt=l(U),Ge=p(U,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-1jlorl"&&(Ge.innerHTML=Fo),Gt=l(U),Re=p(U,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-hswkmf"&&(Re.innerHTML=$o),Rt=l(U),R=p(U,"DIV",{class:!0});var S=N(R);g(we.$$.fragment,S),Ht=l(S),He=p(S,"P",{"data-svelte-h":!0}),h(He)!=="svelte-15814p3"&&(He.innerHTML=Co),Bt=l(S),g(te.$$.fragment,S),Vt=l(S),g(oe.$$.fragment,S),S.forEach(i),U.forEach(i),bt=l(e),g(ve.$$.fragment,e),yt=l(e),M=p(e,"DIV",{class:!0});var F=N(M);g(ke.$$.fragment,F),Xt=l(F),Be=p(F,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-n3dntd"&&(Be.textContent=xo),St=l(F),Ve=p(F,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-eyfmr"&&(Ve.innerHTML=Jo),Qt=l(F),Xe=p(F,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-10ugs3m"&&(Xe.innerHTML=jo),Yt=l(F),Se=p(F,"P",{"data-svelte-h":!0}),h(Se)!=="svelte-1jlorl"&&(Se.innerHTML=zo),Pt=l(F),Qe=p(F,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-hswkmf"&&(Qe.innerHTML=Io),Et=l(F),j=p(F,"DIV",{class:!0});var W=N(j);g(Me.$$.fragment,W),At=l(W),Ye=p(W,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-1wlbpr3"&&(Ye.innerHTML=Uo),Ot=l(W),g(ne.$$.fragment,W),Dt=l(W),g(se.$$.fragment,W),Kt=l(W),g(ae.$$.fragment,W),W.forEach(i),F.forEach(i),Tt=l(e),g(Fe.$$.fragment,e),wt=l(e),x=p(e,"DIV",{class:!0});var Z=N(x);g($e.$$.fragment,Z),eo=l(Z),Pe=p(Z,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-1g0l4i2"&&(Pe.textContent=Wo),to=l(Z),Ee=p(Z,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-1jlorl"&&(Ee.innerHTML=Zo),oo=l(Z),Ae=p(Z,"P",{"data-svelte-h":!0}),h(Ae)!=="svelte-hswkmf"&&(Ae.innerHTML=qo),no=l(Z),H=p(Z,"DIV",{class:!0});var Q=N(H);g(Ce.$$.fragment,Q),so=l(Q),Oe=p(Q,"P",{"data-svelte-h":!0}),h(Oe)!=="svelte-sshtlp"&&(Oe.innerHTML=No),ao=l(Q),g(re.$$.fragment,Q),ro=l(Q),g(le.$$.fragment,Q),Q.forEach(i),Z.forEach(i),vt=l(e),g(xe.$$.fragment,e),kt=l(e),J=p(e,"DIV",{class:!0});var q=N(J);g(Je.$$.fragment,q),lo=l(q),De=p(q,"P",{"data-svelte-h":!0}),h(De)!=="svelte-1uae4ge"&&(De.innerHTML=Lo),io=l(q),Ke=p(q,"P",{"data-svelte-h":!0}),h(Ke)!=="svelte-1jlorl"&&(Ke.innerHTML=Go),co=l(q),et=p(q,"P",{"data-svelte-h":!0}),h(et)!=="svelte-hswkmf"&&(et.innerHTML=Ro),po=l(q),P=p(q,"DIV",{class:!0});var E=N(P);g(je.$$.fragment,E),mo=l(E),tt=p(E,"P",{"data-svelte-h":!0}),h(tt)!=="svelte-g32a6z"&&(tt.innerHTML=Ho),uo=l(E),g(ie.$$.fragment,E),E.forEach(i),q.forEach(i),Mt=l(e),g(ze.$$.fragment,e),Ft=l(e),at=p(e,"P",{}),N(at).forEach(i),this.h()},h(){L(t,"name","hf:doc:metadata"),L(t,"content",dn),L(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){a(document.head,t),m(e,u,n),m(e,s,n),m(e,d,n),_(w,e,n),m(e,o,n),_(v,e,n),m(e,rt,n),m(e,de,n),m(e,lt,n),m(e,ce,n),m(e,it,n),m(e,pe,n),m(e,dt,n),_(me,e,n),m(e,ct,n),_(O,e,n),m(e,pt,n),m(e,ue,n),m(e,mt,n),_(he,e,n),m(e,ut,n),m(e,z,n),_(fe,z,null),a(z,Ct),a(z,Ie),a(z,xt),a(z,Ue),a(z,Jt),_(D,z,null),m(e,ht,n),_(ge,e,n),m(e,ft,n),m(e,$,n),_(_e,$,null),a($,jt),a($,We),a($,zt),a($,Ze),a($,It),a($,qe),a($,Ut),a($,G),_(be,G,null),a(G,Wt),a(G,Ne),a(G,Zt),_(K,G,null),a(G,qt),_(ee,G,null),m(e,gt,n),_(ye,e,n),m(e,_t,n),m(e,C,n),_(Te,C,null),a(C,Nt),a(C,Le),a(C,Lt),a(C,Ge),a(C,Gt),a(C,Re),a(C,Rt),a(C,R),_(we,R,null),a(R,Ht),a(R,He),a(R,Bt),_(te,R,null),a(R,Vt),_(oe,R,null),m(e,bt,n),_(ve,e,n),m(e,yt,n),m(e,M,n),_(ke,M,null),a(M,Xt),a(M,Be),a(M,St),a(M,Ve),a(M,Qt),a(M,Xe),a(M,Yt),a(M,Se),a(M,Pt),a(M,Qe),a(M,Et),a(M,j),_(Me,j,null),a(j,At),a(j,Ye),a(j,Ot),_(ne,j,null),a(j,Dt),_(se,j,null),a(j,Kt),_(ae,j,null),m(e,Tt,n),_(Fe,e,n),m(e,wt,n),m(e,x,n),_($e,x,null),a(x,eo),a(x,Pe),a(x,to),a(x,Ee),a(x,oo),a(x,Ae),a(x,no),a(x,H),_(Ce,H,null),a(H,so),a(H,Oe),a(H,ao),_(re,H,null),a(H,ro),_(le,H,null),m(e,vt,n),_(xe,e,n),m(e,kt,n),m(e,J,n),_(Je,J,null),a(J,lo),a(J,De),a(J,io),a(J,Ke),a(J,co),a(J,et),a(J,po),a(J,P),_(je,P,null),a(P,mo),a(P,tt),a(P,uo),_(ie,P,null),m(e,Mt,n),_(ze,e,n),m(e,Ft,n),m(e,at,n),$t=!0},p(e,[n]){const V={};n&2&&(V.$$scope={dirty:n,ctx:e}),O.$set(V);const I={};n&2&&(I.$$scope={dirty:n,ctx:e}),D.$set(I);const X={};n&2&&(X.$$scope={dirty:n,ctx:e}),K.$set(X);const U={};n&2&&(U.$$scope={dirty:n,ctx:e}),ee.$set(U);const S={};n&2&&(S.$$scope={dirty:n,ctx:e}),te.$set(S);const F={};n&2&&(F.$$scope={dirty:n,ctx:e}),oe.$set(F);const W={};n&2&&(W.$$scope={dirty:n,ctx:e}),ne.$set(W);const Z={};n&2&&(Z.$$scope={dirty:n,ctx:e}),se.$set(Z);const Q={};n&2&&(Q.$$scope={dirty:n,ctx:e}),ae.$set(Q);const q={};n&2&&(q.$$scope={dirty:n,ctx:e}),re.$set(q);const E={};n&2&&(E.$$scope={dirty:n,ctx:e}),le.$set(E);const Bo={};n&2&&(Bo.$$scope={dirty:n,ctx:e}),ie.$set(Bo)},i(e){$t||(b(w.$$.fragment,e),b(v.$$.fragment,e),b(me.$$.fragment,e),b(O.$$.fragment,e),b(he.$$.fragment,e),b(fe.$$.fragment,e),b(D.$$.fragment,e),b(ge.$$.fragment,e),b(_e.$$.fragment,e),b(be.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(ye.$$.fragment,e),b(Te.$$.fragment,e),b(we.$$.fragment,e),b(te.$$.fragment,e),b(oe.$$.fragment,e),b(ve.$$.fragment,e),b(ke.$$.fragment,e),b(Me.$$.fragment,e),b(ne.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(Fe.$$.fragment,e),b($e.$$.fragment,e),b(Ce.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(xe.$$.fragment,e),b(Je.$$.fragment,e),b(je.$$.fragment,e),b(ie.$$.fragment,e),b(ze.$$.fragment,e),$t=!0)},o(e){y(w.$$.fragment,e),y(v.$$.fragment,e),y(me.$$.fragment,e),y(O.$$.fragment,e),y(he.$$.fragment,e),y(fe.$$.fragment,e),y(D.$$.fragment,e),y(ge.$$.fragment,e),y(_e.$$.fragment,e),y(be.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(ye.$$.fragment,e),y(Te.$$.fragment,e),y(we.$$.fragment,e),y(te.$$.fragment,e),y(oe.$$.fragment,e),y(ve.$$.fragment,e),y(ke.$$.fragment,e),y(Me.$$.fragment,e),y(ne.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(Fe.$$.fragment,e),y($e.$$.fragment,e),y(Ce.$$.fragment,e),y(re.$$.fragment,e),y(le.$$.fragment,e),y(xe.$$.fragment,e),y(Je.$$.fragment,e),y(je.$$.fragment,e),y(ie.$$.fragment,e),y(ze.$$.fragment,e),$t=!1},d(e){e&&(i(u),i(s),i(d),i(o),i(rt),i(de),i(lt),i(ce),i(it),i(pe),i(dt),i(ct),i(pt),i(ue),i(mt),i(ut),i(z),i(ht),i(ft),i($),i(gt),i(_t),i(C),i(bt),i(yt),i(M),i(Tt),i(wt),i(x),i(vt),i(kt),i(J),i(Mt),i(Ft),i(at)),i(t),T(w,e),T(v,e),T(me,e),T(O,e),T(he,e),T(fe),T(D),T(ge,e),T(_e),T(be),T(K),T(ee),T(ye,e),T(Te),T(we),T(te),T(oe),T(ve,e),T(ke),T(Me),T(ne),T(se),T(ae),T(Fe,e),T($e),T(Ce),T(re),T(le),T(xe,e),T(Je),T(je),T(ie),T(ze,e)}}}const dn='{"title":"Falcon","local":"falcon","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Converting custom checkpoints","local":"converting-custom-checkpoints","sections":[],"depth":2},{"title":"FalconConfig","local":"transformers.FalconConfig","sections":[],"depth":2},{"title":"FalconModel","local":"transformers.FalconModel","sections":[],"depth":2},{"title":"FalconForCausalLM","local":"transformers.FalconForCausalLM","sections":[],"depth":2},{"title":"FalconForSequenceClassification","local":"transformers.FalconForSequenceClassification","sections":[],"depth":2},{"title":"FalconForTokenClassification","local":"transformers.FalconForTokenClassification","sections":[],"depth":2},{"title":"FalconForQuestionAnswering","local":"transformers.FalconForQuestionAnswering","sections":[],"depth":2}],"depth":1}';function cn(k){return Xo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bn extends So{constructor(t){super(),Qo(this,t,cn,ln,Vo,{})}}export{bn as component};
