import{s as Jl,o as fl,n as bl}from"../chunks/scheduler.25b97de1.js";import{S as Tl,i as Ul,g as p,s as t,r as o,A as Cl,h as i,f as n,c as e,j as yl,u as c,x as r,k as kn,y as Il,a as l,v as h,d as j,t as d,w as m}from"../chunks/index.d9030fc9.js";import{T as _l}from"../chunks/Tip.baa67368.js";import{C as M}from"../chunks/CodeBlock.e6cd0d95.js";import{D as kl}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as y,E as Zl}from"../chunks/EditOnGithub.91d95064.js";function vl(Ds){let g,J='To see all architectures and checkpoints compatible with this task, we recommend checking the <a href="https://huggingface.co/tasks/image-to-text" rel="nofollow">task-page</a>';return{c(){g=p("p"),g.innerHTML=J},l(x){g=i(x,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1nrnqa3"&&(g.innerHTML=J)},m(x,Ls){l(x,g,Ls)},p:bl,d(x){x&&n(g)}}}function Rl(Ds){let g,J,x,Ls,f,Ks,b,Os,T,Zn=`Document Question Answering, also referred to as Document Visual Question Answering, is a task that involves providing
answers to questions posed about document images. The input to models supporting this task is typically a combination of an image and
a question, and the output is an answer expressed in natural language. These models utilize multiple modalities, including
text, the positions of words (bounding boxes), and the image itself.`,sa,U,vn="This guide illustrates how to:",aa,C,Rn='<li>Fine-tune <a href="../model_doc/layoutlmv2">LayoutLMv2</a> on the <a href="https://huggingface.co/datasets/nielsr/docvqa_1200_examples_donut" rel="nofollow">DocVQA dataset</a>.</li> <li>Use your fine-tuned model for inference.</li>',na,u,la,I,Xn=`LayoutLMv2 solves the document question-answering task by adding a question-answering head on top of the final hidden
states of the tokens, to predict the positions of the start and end tokens of the
answer. In other words, the problem is treated as extractive question answering: given the context, extract which piece
of information answers the question. The context comes from the output of an OCR engine, here it is Google’s Tesseract.`,ta,_,An="Before you begin, make sure you have all the necessary libraries installed. LayoutLMv2 depends on detectron2, torchvision and tesseract.",ea,k,pa,Z,ia,v,ra,R,$n="Once you have installed all of the dependencies, restart your runtime.",oa,X,Gn=`We encourage you to share your model with the community. Log in to your Hugging Face account to upload it to the 🤗 Hub.
When prompted, enter your token to log in:`,ca,A,ha,$,Bn="Let’s define some global variables.",ja,G,da,B,ma,W,Wn=`In this guide we use a small sample of preprocessed DocVQA that you can find on 🤗 Hub. If you’d like to use the full
DocVQA dataset, you can register and download it on <a href="https://rrc.cvc.uab.es/?ch=17" rel="nofollow">DocVQA homepage</a>. If you do so, to
proceed with this guide check out <a href="https://huggingface.co/docs/datasets/loading#local-and-remote-files" rel="nofollow">how to load files into a 🤗 dataset</a>.`,Ma,N,ga,V,Nn=`As you can see, the dataset is split into train and test sets already. Take a look at a random example to familiarize
yourself with the features.`,xa,Q,ua,F,Vn="Here’s what the individual fields represent:",wa,E,Qn="<li><code>id</code>: the example’s id</li> <li><code>image</code>: a PIL.Image.Image object containing the document image</li> <li><code>query</code>: the question string - natural language asked question, in several languages</li> <li><code>answers</code>: a list of correct answers provided by human annotators</li> <li><code>words</code> and <code>bounding_boxes</code>: the results of OCR, which we will not use here</li> <li><code>answer</code>: an answer matched by a different model which we will not use here</li>",ya,z,Fn=`Let’s leave only English questions, and drop the <code>answer</code> feature which appears to contain predictions by another model.
We’ll also take the first of the answers from the set provided by the annotators. Alternatively, you can randomly sample it.`,Ja,q,fa,Y,En=`Note that the LayoutLMv2 checkpoint that we use in this guide has been trained with <code>max_position_embeddings = 512</code> (you can
find this information in the <a href="https://huggingface.co/microsoft/layoutlmv2-base-uncased/blob/main/config.json#L18" rel="nofollow">checkpoint’s <code>config.json</code> file</a>).
We can truncate the examples but to avoid the situation where the answer might be at the end of a large document and end up truncated,
here we’ll remove the few examples where the embedding is likely to end up longer than 512.
If most of the documents in your dataset are long, you can implement a sliding window strategy - check out <a href="https://github.com/huggingface/notebooks/blob/main/examples/question_answering.ipynb" rel="nofollow">this notebook</a> for details.`,ba,H,Ta,S,zn=`At this point let’s also remove the OCR features from this dataset. These are a result of OCR for fine-tuning a different
model. They would still require some processing if we wanted to use them, as they do not match the input requirements
of the model we use in this guide. Instead, we can use the <a href="/docs/transformers/pr_28533/en/model_doc/layoutlmv2#transformers.LayoutLMv2Processor">LayoutLMv2Processor</a> on the original data for both OCR and
tokenization. This way we’ll get the inputs that match model’s expected input. If you want to process images manually,
check out the <a href="../model_doc/layoutlmv2"><code>LayoutLMv2</code> model documentation</a> to learn what input format the model expects.`,Ua,L,Ca,P,qn="Finally, the data exploration won’t be complete if we don’t peek at an image example.",Ia,D,_a,w,Yn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/docvqa_example.jpg" alt="DocVQA Image Example"/>',ka,K,Za,O,Hn=`The Document Question Answering task is a multimodal task, and you need to make sure that the inputs from each modality
are preprocessed according to the model’s expectations. Let’s start by loading the <a href="/docs/transformers/pr_28533/en/model_doc/layoutlmv2#transformers.LayoutLMv2Processor">LayoutLMv2Processor</a>, which internally combines an image processor that can handle image data and a tokenizer that can encode text data.`,va,ss,Ra,as,Xa,ns,Sn=`First, let’s prepare the document images for the model with the help of the <code>image_processor</code> from the processor.
By default, image processor resizes the images to 224x224, makes sure they have the correct order of color channels,
applies OCR with tesseract to get words and normalized bounding boxes. In this tutorial, all of these defaults are exactly what we need.
Write a function that applies the default image processing to a batch of images and returns the results of OCR.`,Aa,ls,$a,ts,Ln='To apply this preprocessing to the entire dataset in a fast way, use <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a>.',Ga,es,Ba,ps,Wa,is,Pn=`Once we have applied OCR to the images, we need to encode the text part of the dataset to prepare it for the model.
This involves converting the words and boxes that we got in the previous step to token-level <code>input_ids</code>, <code>attention_mask</code>,
<code>token_type_ids</code> and <code>bbox</code>. For preprocessing text, we’ll need the <code>tokenizer</code> from the processor.`,Na,rs,Va,os,Dn=`On top of the preprocessing mentioned above, we also need to add the labels for the model. For <code>xxxForQuestionAnswering</code> models
in 🤗 Transformers, the labels consist of the <code>start_positions</code> and <code>end_positions</code>, indicating which token is at the
start and which token is at the end of the answer.`,Qa,cs,Kn="Let’s start with that. Define a helper function that can find a sublist (the answer split into words) in a larger list (the words list).",Fa,hs,On=`This function will take two lists as input, <code>words_list</code> and <code>answer_list</code>. It will then iterate over the <code>words_list</code> and check
if the current word in the <code>words_list</code> (words_list[i]) is equal to the first word of answer_list (answer_list[0]) and if
the sublist of <code>words_list</code> starting from the current word and of the same length as <code>answer_list</code> is equal <code>to answer_list</code>.
If this condition is true, it means that a match has been found, and the function will record the match, its starting index (idx),
and its ending index (idx + len(answer_list) - 1). If more than one match was found, the function will return only the first one.
If no match is found, the function returns (<code>None</code>, 0, and 0).`,Ea,js,za,ds,sl="To illustrate how this function finds the position of the answer, let’s use it on an example:",qa,ms,Ya,Ms,al="Once examples are encoded, however, they will look like this:",Ha,gs,Sa,xs,nl="We’ll need to find the position of the answer in the encoded input.",La,us,ll=`<li><code>token_type_ids</code> tells us which tokens are part of the question, and which ones are part of the document’s words.</li> <li><code>tokenizer.cls_token_id</code> will help find the special token at the beginning of the input.</li> <li><code>word_ids</code> will help match the answer found in the original <code>words</code> to the same answer in the full encoded input and determine
the start/end position of the answer in the encoded input.</li>`,Pa,ws,tl="With that in mind, let’s create a function to encode a batch of examples in the dataset:",Da,ys,Ka,Js,el="Now that we have this preprocessing function, we can encode the entire dataset:",Oa,fs,sn,bs,pl="Let’s check what the features of the encoded dataset look like:",an,Ts,nn,Us,ln,Cs,il=`Evaluation for document question answering requires a significant amount of postprocessing. To avoid taking up too much
of your time, this guide skips the evaluation step. The <a href="/docs/transformers/pr_28533/en/main_classes/trainer#transformers.Trainer">Trainer</a> still calculates the evaluation loss during training so
you’re not completely in the dark about your model’s performance. Extractive question answering is typically evaluated using F1/exact match.
If you’d like to implement it yourself, check out the <a href="https://huggingface.co/course/chapter7/7?fw=pt#postprocessing" rel="nofollow">Question Answering chapter</a>
of the Hugging Face course for inspiration.`,tn,Is,en,_s,rl=`Congratulations! You’ve successfully navigated the toughest part of this guide and now you are ready to train your own model.
Training involves the following steps:`,pn,ks,ol='<li>Load the model with <a href="/docs/transformers/pr_28533/en/model_doc/auto#transformers.AutoModelForDocumentQuestionAnswering">AutoModelForDocumentQuestionAnswering</a> using the same checkpoint as in the preprocessing.</li> <li>Define your training hyperparameters in <a href="/docs/transformers/pr_28533/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.</li> <li>Define a function to batch examples together, here the <a href="/docs/transformers/pr_28533/en/main_classes/data_collator#transformers.DefaultDataCollator">DefaultDataCollator</a> will do just fine</li> <li>Pass the training arguments to <a href="/docs/transformers/pr_28533/en/main_classes/trainer#transformers.Trainer">Trainer</a> along with the model, dataset, and data collator.</li> <li>Call <a href="/docs/transformers/pr_28533/en/main_classes/trainer#transformers.Trainer.train">train()</a> to finetune your model.</li>',rn,Zs,on,vs,cl=`In the <a href="/docs/transformers/pr_28533/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> use <code>output_dir</code> to specify where to save your model, and configure hyperparameters as you see fit.
If you wish to share your model with the community, set <code>push_to_hub</code> to <code>True</code> (you must be signed in to Hugging Face to upload your model).
In this case the <code>output_dir</code> will also be the name of the repo where your model checkpoint will be pushed.`,cn,Rs,hn,Xs,hl="Define a simple data collator to batch examples together.",jn,As,dn,$s,jl='Finally, bring everything together, and call <a href="/docs/transformers/pr_28533/en/main_classes/trainer#transformers.Trainer.train">train()</a>:',mn,Gs,Mn,Bs,dl="To add the final model to 🤗 Hub, create a model card and call <code>push_to_hub</code>:",gn,Ws,xn,Ns,un,Vs,ml=`Now that you have finetuned a LayoutLMv2 model, and uploaded it to the 🤗 Hub, you can use it for inference. The simplest
way to try out your finetuned model for inference is to use it in a <a href="/docs/transformers/pr_28533/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a>.`,wn,Qs,Ml="Let’s take an example:",yn,Fs,Jn,Es,gl=`Next, instantiate a pipeline for
document question answering with your model, and pass the image + question combination to it.`,fn,zs,bn,qs,xl="You can also manually replicate the results of the pipeline if you’d like:",Tn,Ys,ul=`<li>Take an image and a question, prepare them for the model using the processor from your model.</li> <li>Forward the result or preprocessing through the model.</li> <li>The model returns <code>start_logits</code> and <code>end_logits</code>, which indicate which token is at the start of the answer and
which token is at the end of the answer. Both have shape (batch_size, sequence_length).</li> <li>Take an argmax on the last dimension of both the <code>start_logits</code> and <code>end_logits</code> to get the predicted <code>start_idx</code> and <code>end_idx</code>.</li> <li>Decode the answer with the tokenizer.</li>`,Un,Hs,Cn,Ss,In,Ps,_n;return f=new y({props:{title:"Document Question Answering",local:"document-question-answering",headingTag:"h1"}}),b=new kl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/document_question_answering.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/document_question_answering.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/document_question_answering.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/document_question_answering.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/document_question_answering.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/document_question_answering.ipynb"}]}}),u=new _l({props:{$$slots:{default:[vl]},$$scope:{ctx:Ds}}}),k=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwZGF0YXNldHM=",highlighted:"pip install -q transformers datasets",wrap:!1}}),Z=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZmYWNlYm9va3Jlc2VhcmNoJTJGZGV0ZWN0cm9uMi5naXQnJTBBcGlwJTIwaW5zdGFsbCUyMHRvcmNodmlzaW9u",highlighted:`pip install <span class="hljs-string">&#x27;git+https://github.com/facebookresearch/detectron2.git&#x27;</span>
pip install torchvision`,wrap:!1}}),v=new M({props:{code:"c3VkbyUyMGFwdCUyMGluc3RhbGwlMjB0ZXNzZXJhY3Qtb2NyJTBBcGlwJTIwaW5zdGFsbCUyMC1xJTIwcHl0ZXNzZXJhY3Q=",highlighted:`sudo apt install tesseract-ocr
pip install -q pytesseract`,wrap:!1}}),A=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),G=new M({props:{code:"bW9kZWxfY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRmxheW91dGxtdjItYmFzZS11bmNhc2VkJTIyJTBBYmF0Y2hfc2l6ZSUyMCUzRCUyMDQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;microsoft/layoutlmv2-base-uncased&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">4</span>`,wrap:!1}}),B=new y({props:{title:"Load the data",local:"load-the-data",headingTag:"h2"}}),N=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJuaWVsc3IlMkZkb2N2cWFfMTIwMF9leGFtcGxlcyUyMiklMEFkYXRhc2V0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;nielsr/docvqa_1200_examples&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;id&#x27;</span>, <span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;query&#x27;</span>, <span class="hljs-string">&#x27;answers&#x27;</span>, <span class="hljs-string">&#x27;words&#x27;</span>, <span class="hljs-string">&#x27;bounding_boxes&#x27;</span>, <span class="hljs-string">&#x27;answer&#x27;</span>],
        num_rows: <span class="hljs-number">1000</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;id&#x27;</span>, <span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;query&#x27;</span>, <span class="hljs-string">&#x27;answers&#x27;</span>, <span class="hljs-string">&#x27;words&#x27;</span>, <span class="hljs-string">&#x27;bounding_boxes&#x27;</span>, <span class="hljs-string">&#x27;answer&#x27;</span>],
        num_rows: <span class="hljs-number">200</span>
    })
})`,wrap:!1}}),Q=new M({props:{code:"ZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELmZlYXR1cmVz",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;train&quot;</span>].features',wrap:!1}}),q=new M({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZSUzQSUyMCU3QiUyMnF1ZXN0aW9uJTIyJTNBJTIwZXhhbXBsZSU1QiUyMnF1ZXJ5JTIyJTVEJTVCJTIyZW4lMjIlNUQlN0QlMkMlMjByZW1vdmVfY29sdW1ucyUzRCU1QiUyMnF1ZXJ5JTIyJTVEKSUwQXVwZGF0ZWRfZGF0YXNldCUyMCUzRCUyMHVwZGF0ZWRfZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwbGFtYmRhJTIwZXhhbXBsZSUzQSUyMCU3QiUyMmFuc3dlciUyMiUzQSUyMGV4YW1wbGUlNUIlMjJhbnN3ZXJzJTIyJTVEJTVCMCU1RCU3RCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIyYW5zd2VyJTIyJTJDJTIwJTIyYW5zd2VycyUyMiU1RCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> example: {<span class="hljs-string">&quot;question&quot;</span>: example[<span class="hljs-string">&quot;query&quot;</span>][<span class="hljs-string">&quot;en&quot;</span>]}, remove_columns=[<span class="hljs-string">&quot;query&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = updated_dataset.<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>    <span class="hljs-keyword">lambda</span> example: {<span class="hljs-string">&quot;answer&quot;</span>: example[<span class="hljs-string">&quot;answers&quot;</span>][<span class="hljs-number">0</span>]}, remove_columns=[<span class="hljs-string">&quot;answer&quot;</span>, <span class="hljs-string">&quot;answers&quot;</span>]
<span class="hljs-meta">... </span>)`,wrap:!1}}),H=new M({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwdXBkYXRlZF9kYXRhc2V0LmZpbHRlcihsYW1iZGElMjB4JTNBJTIwbGVuKHglNUIlMjJ3b3JkcyUyMiU1RCklMjAlMkIlMjBsZW4oeCU1QiUyMnF1ZXN0aW9uJTIyJTVELnNwbGl0KCkpJTIwJTNDJTIwNTEyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = updated_dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">len</span>(x[<span class="hljs-string">&quot;words&quot;</span>]) + <span class="hljs-built_in">len</span>(x[<span class="hljs-string">&quot;question&quot;</span>].split()) &lt; <span class="hljs-number">512</span>)',wrap:!1}}),L=new M({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwdXBkYXRlZF9kYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCUyMndvcmRzJTIyKSUwQXVwZGF0ZWRfZGF0YXNldCUyMCUzRCUyMHVwZGF0ZWRfZGF0YXNldC5yZW1vdmVfY29sdW1ucyglMjJib3VuZGluZ19ib3hlcyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = updated_dataset.remove_columns(<span class="hljs-string">&quot;words&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = updated_dataset.remove_columns(<span class="hljs-string">&quot;bounding_boxes&quot;</span>)`,wrap:!1}}),D=new M({props:{code:"dXBkYXRlZF9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlNUIxMSU1RCU1QiUyMmltYWdlJTIyJTVE",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">11</span>][<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),K=new y({props:{title:"Preprocess the data",local:"preprocess-the-data",headingTag:"h2"}}),ss=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(model_checkpoint)`,wrap:!1}}),as=new y({props:{title:"Preprocessing document images",local:"preprocessing-document-images",headingTag:"h3"}}),ls=new M({props:{code:"aW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29yLmltYWdlX3Byb2Nlc3NvciUwQSUwQSUwQWRlZiUyMGdldF9vY3Jfd29yZHNfYW5kX2JveGVzKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QmltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwZW5jb2RlZF9pbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzKSUwQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIyaW1hZ2UlMjIlNUQlMjAlM0QlMjBlbmNvZGVkX2lucHV0cy5waXhlbF92YWx1ZXMlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMndvcmRzJTIyJTVEJTIwJTNEJTIwZW5jb2RlZF9pbnB1dHMud29yZHMlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMmJveGVzJTIyJTVEJTIwJTNEJTIwZW5jb2RlZF9pbnB1dHMuYm94ZXMlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBleGFtcGxlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = processor.image_processor


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_ocr_words_and_boxes</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    images = [image.convert(<span class="hljs-string">&quot;RGB&quot;</span>) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    encoded_inputs = image_processor(images)

<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;image&quot;</span>] = encoded_inputs.pixel_values
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;words&quot;</span>] = encoded_inputs.words
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;boxes&quot;</span>] = encoded_inputs.boxes

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),es=new M({props:{code:"ZGF0YXNldF93aXRoX29jciUyMCUzRCUyMHVwZGF0ZWRfZGF0YXNldC5tYXAoZ2V0X29jcl93b3Jkc19hbmRfYm94ZXMlMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0QyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_with_ocr = updated_dataset.<span class="hljs-built_in">map</span>(get_ocr_words_and_boxes, batched=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">2</span>)',wrap:!1}}),ps=new y({props:{title:"Preprocessing text data",local:"preprocessing-text-data",headingTag:"h3"}}),rs=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = processor.tokenizer',wrap:!1}}),js=new M({props:{code:"ZGVmJTIwc3ViZmluZGVyKHdvcmRzX2xpc3QlMkMlMjBhbnN3ZXJfbGlzdCklM0ElMEElMjAlMjAlMjAlMjBtYXRjaGVzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwc3RhcnRfaW5kaWNlcyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGVuZF9pbmRpY2VzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaWR4JTJDJTIwaSUyMGluJTIwZW51bWVyYXRlKHJhbmdlKGxlbih3b3Jkc19saXN0KSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjB3b3Jkc19saXN0JTVCaSU1RCUyMCUzRCUzRCUyMGFuc3dlcl9saXN0JTVCMCU1RCUyMGFuZCUyMHdvcmRzX2xpc3QlNUJpJTIwJTNBJTIwaSUyMCUyQiUyMGxlbihhbnN3ZXJfbGlzdCklNUQlMjAlM0QlM0QlMjBhbnN3ZXJfbGlzdCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1hdGNoZXMuYXBwZW5kKGFuc3dlcl9saXN0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXJ0X2luZGljZXMuYXBwZW5kKGlkeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmRfaW5kaWNlcy5hcHBlbmQoaWR4JTIwJTJCJTIwbGVuKGFuc3dlcl9saXN0KSUyMC0lMjAxKSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF0Y2hlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMG1hdGNoZXMlNUIwJTVEJTJDJTIwc3RhcnRfaW5kaWNlcyU1QjAlNUQlMkMlMjBlbmRfaW5kaWNlcyU1QjAlNUQlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwTm9uZSUyQyUyMDAlMkMlMjAw",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">subfinder</span>(<span class="hljs-params">words_list, answer_list</span>):
<span class="hljs-meta">... </span>    matches = []
<span class="hljs-meta">... </span>    start_indices = []
<span class="hljs-meta">... </span>    end_indices = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> idx, i <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(<span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(words_list))):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> words_list[i] == answer_list[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> words_list[i : i + <span class="hljs-built_in">len</span>(answer_list)] == answer_list:
<span class="hljs-meta">... </span>            matches.append(answer_list)
<span class="hljs-meta">... </span>            start_indices.append(idx)
<span class="hljs-meta">... </span>            end_indices.append(idx + <span class="hljs-built_in">len</span>(answer_list) - <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> matches:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> matches[<span class="hljs-number">0</span>], start_indices[<span class="hljs-number">0</span>], end_indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>`,wrap:!1}}),ms=new M({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXRfd2l0aF9vY3IlNUIlMjJ0cmFpbiUyMiU1RCU1QjElNUQlMEF3b3JkcyUyMCUzRCUyMCU1QndvcmQubG93ZXIoKSUyMGZvciUyMHdvcmQlMjBpbiUyMGV4YW1wbGUlNUIlMjJ3b3JkcyUyMiU1RCU1RCUwQW1hdGNoJTJDJTIwd29yZF9pZHhfc3RhcnQlMkMlMjB3b3JkX2lkeF9lbmQlMjAlM0QlMjBzdWJmaW5kZXIod29yZHMlMkMlMjBleGFtcGxlJTVCJTIyYW5zd2VyJTIyJTVELmxvd2VyKCkuc3BsaXQoKSklMEFwcmludCglMjJRdWVzdGlvbiUzQSUyMCUyMiUyQyUyMGV4YW1wbGUlNUIlMjJxdWVzdGlvbiUyMiU1RCklMEFwcmludCglMjJXb3JkcyUzQSUyMiUyQyUyMHdvcmRzKSUwQXByaW50KCUyMkFuc3dlciUzQSUyMCUyMiUyQyUyMGV4YW1wbGUlNUIlMjJhbnN3ZXIlMjIlNUQpJTBBcHJpbnQoJTIyc3RhcnRfaW5kZXglMjIlMkMlMjB3b3JkX2lkeF9zdGFydCklMEFwcmludCglMjJlbmRfaW5kZXglMjIlMkMlMjB3b3JkX2lkeF9lbmQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset_with_ocr[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>words = [word.lower() <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> example[<span class="hljs-string">&quot;words&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">match</span>, word_idx_start, word_idx_end = subfinder(words, example[<span class="hljs-string">&quot;answer&quot;</span>].lower().split())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Question: &quot;</span>, example[<span class="hljs-string">&quot;question&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Words:&quot;</span>, words)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Answer: &quot;</span>, example[<span class="hljs-string">&quot;answer&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;start_index&quot;</span>, word_idx_start)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;end_index&quot;</span>, word_idx_end)
Question:  Who <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span>  cc <span class="hljs-keyword">in</span> this letter?
Words: [<span class="hljs-string">&#x27;wie&#x27;</span>, <span class="hljs-string">&#x27;baw&#x27;</span>, <span class="hljs-string">&#x27;brown&#x27;</span>, <span class="hljs-string">&#x27;&amp;&#x27;</span>, <span class="hljs-string">&#x27;williamson&#x27;</span>, <span class="hljs-string">&#x27;tobacco&#x27;</span>, <span class="hljs-string">&#x27;corporation&#x27;</span>, <span class="hljs-string">&#x27;research&#x27;</span>, <span class="hljs-string">&#x27;&amp;&#x27;</span>, <span class="hljs-string">&#x27;development&#x27;</span>, <span class="hljs-string">&#x27;internal&#x27;</span>, <span class="hljs-string">&#x27;correspondence&#x27;</span>, <span class="hljs-string">&#x27;to:&#x27;</span>, <span class="hljs-string">&#x27;r.&#x27;</span>, <span class="hljs-string">&#x27;h.&#x27;</span>, <span class="hljs-string">&#x27;honeycutt&#x27;</span>, <span class="hljs-string">&#x27;ce:&#x27;</span>, <span class="hljs-string">&#x27;t.f.&#x27;</span>, <span class="hljs-string">&#x27;riehl&#x27;</span>, <span class="hljs-string">&#x27;from:&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;c.j.&#x27;</span>, <span class="hljs-string">&#x27;cook&#x27;</span>, <span class="hljs-string">&#x27;date:&#x27;</span>, <span class="hljs-string">&#x27;may&#x27;</span>, <span class="hljs-string">&#x27;8,&#x27;</span>, <span class="hljs-string">&#x27;1995&#x27;</span>, <span class="hljs-string">&#x27;subject:&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;existing&#x27;</span>, <span class="hljs-string">&#x27;brainstorming&#x27;</span>, <span class="hljs-string">&#x27;ideas/483&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;major&#x27;</span>, <span class="hljs-string">&#x27;function&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;product&#x27;</span>, <span class="hljs-string">&#x27;innovation&#x27;</span>, <span class="hljs-string">&#x27;graup&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;develop&#x27;</span>, <span class="hljs-string">&#x27;marketable&#x27;</span>, <span class="hljs-string">&#x27;nove!&#x27;</span>, <span class="hljs-string">&#x27;products&#x27;</span>, <span class="hljs-string">&#x27;that&#x27;</span>, <span class="hljs-string">&#x27;would&#x27;</span>, <span class="hljs-string">&#x27;be&#x27;</span>, <span class="hljs-string">&#x27;profitable&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;manufacture&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;sell.&#x27;</span>, <span class="hljs-string">&#x27;novel&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;defined&#x27;</span>, <span class="hljs-string">&#x27;as:&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;new&#x27;</span>, <span class="hljs-string">&#x27;kind,&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;different&#x27;</span>, <span class="hljs-string">&#x27;from&#x27;</span>, <span class="hljs-string">&#x27;anything&#x27;</span>, <span class="hljs-string">&#x27;seen&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;known&#x27;</span>, <span class="hljs-string">&#x27;before.&#x27;</span>, <span class="hljs-string">&#x27;innovation&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;defined&#x27;</span>, <span class="hljs-string">&#x27;as:&#x27;</span>, <span class="hljs-string">&#x27;something&#x27;</span>, <span class="hljs-string">&#x27;new&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;different&#x27;</span>, <span class="hljs-string">&#x27;introduced;&#x27;</span>, <span class="hljs-string">&#x27;act&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;innovating;&#x27;</span>, <span class="hljs-string">&#x27;introduction&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;new&#x27;</span>, <span class="hljs-string">&#x27;things&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;methods.&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;products&#x27;</span>, <span class="hljs-string">&#x27;may&#x27;</span>, <span class="hljs-string">&#x27;incorporate&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;latest&#x27;</span>, <span class="hljs-string">&#x27;technologies,&#x27;</span>, <span class="hljs-string">&#x27;materials&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;know-how&#x27;</span>, <span class="hljs-string">&#x27;available&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;give&#x27;</span>, <span class="hljs-string">&#x27;then&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;unique&#x27;</span>, <span class="hljs-string">&#x27;taste&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;look.&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;first&#x27;</span>, <span class="hljs-string">&#x27;task&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;product&#x27;</span>, <span class="hljs-string">&#x27;innovation&#x27;</span>, <span class="hljs-string">&#x27;group&#x27;</span>, <span class="hljs-string">&#x27;was&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;assemble,&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;categorize&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;list&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;existing&#x27;</span>, <span class="hljs-string">&#x27;brainstorming&#x27;</span>, <span class="hljs-string">&#x27;ideas.&#x27;</span>, <span class="hljs-string">&#x27;ideas&#x27;</span>, <span class="hljs-string">&#x27;were&#x27;</span>, <span class="hljs-string">&#x27;grouped&#x27;</span>, <span class="hljs-string">&#x27;into&#x27;</span>, <span class="hljs-string">&#x27;two&#x27;</span>, <span class="hljs-string">&#x27;major&#x27;</span>, <span class="hljs-string">&#x27;categories&#x27;</span>, <span class="hljs-string">&#x27;labeled&#x27;</span>, <span class="hljs-string">&#x27;appearance&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;taste/aroma.&#x27;</span>, <span class="hljs-string">&#x27;these&#x27;</span>, <span class="hljs-string">&#x27;categories&#x27;</span>, <span class="hljs-string">&#x27;are&#x27;</span>, <span class="hljs-string">&#x27;used&#x27;</span>, <span class="hljs-string">&#x27;for&#x27;</span>, <span class="hljs-string">&#x27;novel&#x27;</span>, <span class="hljs-string">&#x27;products&#x27;</span>, <span class="hljs-string">&#x27;that&#x27;</span>, <span class="hljs-string">&#x27;may&#x27;</span>, <span class="hljs-string">&#x27;differ&#x27;</span>, <span class="hljs-string">&#x27;from&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;visual&#x27;</span>, <span class="hljs-string">&#x27;and/or&#x27;</span>, <span class="hljs-string">&#x27;taste/aroma&#x27;</span>, <span class="hljs-string">&#x27;point&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;view&#x27;</span>, <span class="hljs-string">&#x27;compared&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;canventional&#x27;</span>, <span class="hljs-string">&#x27;cigarettes.&#x27;</span>, <span class="hljs-string">&#x27;other&#x27;</span>, <span class="hljs-string">&#x27;categories&#x27;</span>, <span class="hljs-string">&#x27;include&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;combination&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;above,&#x27;</span>, <span class="hljs-string">&#x27;filters,&#x27;</span>, <span class="hljs-string">&#x27;packaging&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;brand&#x27;</span>, <span class="hljs-string">&#x27;extensions.&#x27;</span>, <span class="hljs-string">&#x27;appearance&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;category&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;used&#x27;</span>, <span class="hljs-string">&#x27;for&#x27;</span>, <span class="hljs-string">&#x27;novel&#x27;</span>, <span class="hljs-string">&#x27;cigarette&#x27;</span>, <span class="hljs-string">&#x27;constructions&#x27;</span>, <span class="hljs-string">&#x27;that&#x27;</span>, <span class="hljs-string">&#x27;yield&#x27;</span>, <span class="hljs-string">&#x27;visually&#x27;</span>, <span class="hljs-string">&#x27;different&#x27;</span>, <span class="hljs-string">&#x27;products&#x27;</span>, <span class="hljs-string">&#x27;with&#x27;</span>, <span class="hljs-string">&#x27;minimal&#x27;</span>, <span class="hljs-string">&#x27;changes&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;smoke&#x27;</span>, <span class="hljs-string">&#x27;chemistry&#x27;</span>, <span class="hljs-string">&#x27;two&#x27;</span>, <span class="hljs-string">&#x27;cigarettes&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;cne.&#x27;</span>, <span class="hljs-string">&#x27;emulti-plug&#x27;</span>, <span class="hljs-string">&#x27;te&#x27;</span>, <span class="hljs-string">&#x27;build&#x27;</span>, <span class="hljs-string">&#x27;yaur&#x27;</span>, <span class="hljs-string">&#x27;awn&#x27;</span>, <span class="hljs-string">&#x27;cigarette.&#x27;</span>, <span class="hljs-string">&#x27;eswitchable&#x27;</span>, <span class="hljs-string">&#x27;menthol&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;non&#x27;</span>, <span class="hljs-string">&#x27;menthol&#x27;</span>, <span class="hljs-string">&#x27;cigarette.&#x27;</span>, <span class="hljs-string">&#x27;*cigarettes&#x27;</span>, <span class="hljs-string">&#x27;with&#x27;</span>, <span class="hljs-string">&#x27;interspaced&#x27;</span>, <span class="hljs-string">&#x27;perforations&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;enable&#x27;</span>, <span class="hljs-string">&#x27;smoker&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;separate&#x27;</span>, <span class="hljs-string">&#x27;unburned&#x27;</span>, <span class="hljs-string">&#x27;section&#x27;</span>, <span class="hljs-string">&#x27;for&#x27;</span>, <span class="hljs-string">&#x27;future&#x27;</span>, <span class="hljs-string">&#x27;smoking.&#x27;</span>, <span class="hljs-string">&#x27;«short&#x27;</span>, <span class="hljs-string">&#x27;cigarette,&#x27;</span>, <span class="hljs-string">&#x27;tobacco&#x27;</span>, <span class="hljs-string">&#x27;section&#x27;</span>, <span class="hljs-string">&#x27;30&#x27;</span>, <span class="hljs-string">&#x27;mm.&#x27;</span>, <span class="hljs-string">&#x27;«extremely&#x27;</span>, <span class="hljs-string">&#x27;fast&#x27;</span>, <span class="hljs-string">&#x27;buming&#x27;</span>, <span class="hljs-string">&#x27;cigarette.&#x27;</span>, <span class="hljs-string">&#x27;«novel&#x27;</span>, <span class="hljs-string">&#x27;cigarette&#x27;</span>, <span class="hljs-string">&#x27;constructions&#x27;</span>, <span class="hljs-string">&#x27;that&#x27;</span>, <span class="hljs-string">&#x27;permit&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;significant&#x27;</span>, <span class="hljs-string">&#x27;reduction&#x27;</span>, <span class="hljs-string">&#x27;iretobacco&#x27;</span>, <span class="hljs-string">&#x27;weight&#x27;</span>, <span class="hljs-string">&#x27;while&#x27;</span>, <span class="hljs-string">&#x27;maintaining&#x27;</span>, <span class="hljs-string">&#x27;smoking&#x27;</span>, <span class="hljs-string">&#x27;mechanics&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;visual&#x27;</span>, <span class="hljs-string">&#x27;characteristics.&#x27;</span>, <span class="hljs-string">&#x27;higher&#x27;</span>, <span class="hljs-string">&#x27;basis&#x27;</span>, <span class="hljs-string">&#x27;weight&#x27;</span>, <span class="hljs-string">&#x27;paper:&#x27;</span>, <span class="hljs-string">&#x27;potential&#x27;</span>, <span class="hljs-string">&#x27;reduction&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;tobacco&#x27;</span>, <span class="hljs-string">&#x27;weight.&#x27;</span>, <span class="hljs-string">&#x27;«more&#x27;</span>, <span class="hljs-string">&#x27;rigid&#x27;</span>, <span class="hljs-string">&#x27;tobacco&#x27;</span>, <span class="hljs-string">&#x27;column;&#x27;</span>, <span class="hljs-string">&#x27;stiffing&#x27;</span>, <span class="hljs-string">&#x27;agent&#x27;</span>, <span class="hljs-string">&#x27;for&#x27;</span>, <span class="hljs-string">&#x27;tobacco;&#x27;</span>, <span class="hljs-string">&#x27;e.g.&#x27;</span>, <span class="hljs-string">&#x27;starch&#x27;</span>, <span class="hljs-string">&#x27;*colored&#x27;</span>, <span class="hljs-string">&#x27;tow&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;cigarette&#x27;</span>, <span class="hljs-string">&#x27;papers;&#x27;</span>, <span class="hljs-string">&#x27;seasonal&#x27;</span>, <span class="hljs-string">&#x27;promotions,&#x27;</span>, <span class="hljs-string">&#x27;e.g.&#x27;</span>, <span class="hljs-string">&#x27;pastel&#x27;</span>, <span class="hljs-string">&#x27;colored&#x27;</span>, <span class="hljs-string">&#x27;cigarettes&#x27;</span>, <span class="hljs-string">&#x27;for&#x27;</span>, <span class="hljs-string">&#x27;easter&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;an&#x27;</span>, <span class="hljs-string">&#x27;ebony&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;ivory&#x27;</span>, <span class="hljs-string">&#x27;brand&#x27;</span>, <span class="hljs-string">&#x27;containing&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;mixture&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;all&#x27;</span>, <span class="hljs-string">&#x27;black&#x27;</span>, <span class="hljs-string">&#x27;(black&#x27;</span>, <span class="hljs-string">&#x27;paper&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;tow)&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;ail&#x27;</span>, <span class="hljs-string">&#x27;white&#x27;</span>, <span class="hljs-string">&#x27;cigarettes.&#x27;</span>, <span class="hljs-string">&#x27;499150498&#x27;</span>]
Answer:  T.F. Riehl
start_index <span class="hljs-number">17</span>
end_index <span class="hljs-number">18</span>`,wrap:!1}}),gs=new M({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIoZXhhbXBsZSU1QiUyMnF1ZXN0aW9uJTIyJTVEJTJDJTIwZXhhbXBsZSU1QiUyMndvcmRzJTIyJTVEJTJDJTIwZXhhbXBsZSU1QiUyMmJveGVzJTIyJTVEKSUwQXRva2VuaXplci5kZWNvZGUoZW5jb2RpbmclNUIlMjJpbnB1dF9pZHMlMjIlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(example[<span class="hljs-string">&quot;question&quot;</span>], example[<span class="hljs-string">&quot;words&quot;</span>], example[<span class="hljs-string">&quot;boxes&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(encoding[<span class="hljs-string">&quot;input_ids&quot;</span>])
[CLS] who <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> cc <span class="hljs-keyword">in</span> this letter? [SEP] wie baw brown &amp; williamson tobacco corporation research &amp; development ...`,wrap:!1}}),ys=new M({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_dataset</span>(<span class="hljs-params">examples, max_length=<span class="hljs-number">512</span></span>):
<span class="hljs-meta">... </span>    questions = examples[<span class="hljs-string">&quot;question&quot;</span>]
<span class="hljs-meta">... </span>    words = examples[<span class="hljs-string">&quot;words&quot;</span>]
<span class="hljs-meta">... </span>    boxes = examples[<span class="hljs-string">&quot;boxes&quot;</span>]
<span class="hljs-meta">... </span>    answers = examples[<span class="hljs-string">&quot;answer&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># encode the batch of examples and initialize the start_positions and end_positions</span>
<span class="hljs-meta">... </span>    encoding = tokenizer(questions, words, boxes, max_length=max_length, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    start_positions = []
<span class="hljs-meta">... </span>    end_positions = []

<span class="hljs-meta">... </span>    <span class="hljs-comment"># loop through the examples in the batch</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(questions)):
<span class="hljs-meta">... </span>        cls_index = encoding[<span class="hljs-string">&quot;input_ids&quot;</span>][i].index(tokenizer.cls_token_id)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># find the position of the answer in example&#x27;s words</span>
<span class="hljs-meta">... </span>        words_example = [word.lower() <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> words[i]]
<span class="hljs-meta">... </span>        answer = answers[i]
<span class="hljs-meta">... </span>        <span class="hljs-keyword">match</span>, word_idx_start, word_idx_end = subfinder(words_example, answer.lower().split())

<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-keyword">match</span>:
<span class="hljs-meta">... </span>            <span class="hljs-comment"># if match is found, use \`token_type_ids\` to find where words start in the encoding</span>
<span class="hljs-meta">... </span>            token_type_ids = encoding[<span class="hljs-string">&quot;token_type_ids&quot;</span>][i]
<span class="hljs-meta">... </span>            token_start_index = <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>            <span class="hljs-keyword">while</span> token_type_ids[token_start_index] != <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                token_start_index += <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>            token_end_index = <span class="hljs-built_in">len</span>(encoding[<span class="hljs-string">&quot;input_ids&quot;</span>][i]) - <span class="hljs-number">1</span>
<span class="hljs-meta">... </span>            <span class="hljs-keyword">while</span> token_type_ids[token_end_index] != <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                token_end_index -= <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>            word_ids = encoding.word_ids(i)[token_start_index : token_end_index + <span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>            start_position = cls_index
<span class="hljs-meta">... </span>            end_position = cls_index

<span class="hljs-meta">... </span>            <span class="hljs-comment"># loop over word_ids and increase \`token_start_index\` until it matches the answer position in words</span>
<span class="hljs-meta">... </span>            <span class="hljs-comment"># once it matches, save the \`token_start_index\` as the \`start_position\` of the answer in the encoding</span>
<span class="hljs-meta">... </span>            <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span> <span class="hljs-keyword">in</span> word_ids:
<span class="hljs-meta">... </span>                <span class="hljs-keyword">if</span> <span class="hljs-built_in">id</span> == word_idx_start:
<span class="hljs-meta">... </span>                    start_position = token_start_index
<span class="hljs-meta">... </span>                <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>                    token_start_index += <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>            <span class="hljs-comment"># similarly loop over \`word_ids\` starting from the end to find the \`end_position\` of the answer</span>
<span class="hljs-meta">... </span>            <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span> <span class="hljs-keyword">in</span> word_ids[::-<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>                <span class="hljs-keyword">if</span> <span class="hljs-built_in">id</span> == word_idx_end:
<span class="hljs-meta">... </span>                    end_position = token_end_index
<span class="hljs-meta">... </span>                <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>                    token_end_index -= <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>            start_positions.append(start_position)
<span class="hljs-meta">... </span>            end_positions.append(end_position)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>            start_positions.append(cls_index)
<span class="hljs-meta">... </span>            end_positions.append(cls_index)

<span class="hljs-meta">... </span>    encoding[<span class="hljs-string">&quot;image&quot;</span>] = examples[<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">... </span>    encoding[<span class="hljs-string">&quot;start_positions&quot;</span>] = start_positions
<span class="hljs-meta">... </span>    encoding[<span class="hljs-string">&quot;end_positions&quot;</span>] = end_positions

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> encoding`,wrap:!1}}),fs=new M({props:{code:"ZW5jb2RlZF90cmFpbl9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldF93aXRoX29jciU1QiUyMnRyYWluJTIyJTVELm1hcCglMEElMjAlMjAlMjAlMjBlbmNvZGVfZGF0YXNldCUyQyUyMGJhdGNoZWQlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRDIlMkMlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXRfd2l0aF9vY3IlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXMlMEEpJTBBZW5jb2RlZF90ZXN0X2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0X3dpdGhfb2NyJTVCJTIydGVzdCUyMiU1RC5tYXAoJTBBJTIwJTIwJTIwJTIwZW5jb2RlX2RhdGFzZXQlMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0QyJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0RkYXRhc2V0X3dpdGhfb2NyJTVCJTIydGVzdCUyMiU1RC5jb2x1bW5fbmFtZXMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_train_dataset = dataset_with_ocr[<span class="hljs-string">&quot;train&quot;</span>].<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>    encode_dataset, batched=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">2</span>, remove_columns=dataset_with_ocr[<span class="hljs-string">&quot;train&quot;</span>].column_names
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_test_dataset = dataset_with_ocr[<span class="hljs-string">&quot;test&quot;</span>].<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>    encode_dataset, batched=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">2</span>, remove_columns=dataset_with_ocr[<span class="hljs-string">&quot;test&quot;</span>].column_names
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ts=new M({props:{code:"ZW5jb2RlZF90cmFpbl9kYXRhc2V0LmZlYXR1cmVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_train_dataset.features
{<span class="hljs-string">&#x27;image&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=<span class="hljs-type">Sequence</span>(feature=<span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;uint8&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int8&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;attention_mask&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int8&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;bbox&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=<span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;start_positions&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;end_positions&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),Us=new y({props:{title:"Evaluation",local:"evaluation",headingTag:"h2"}}),Is=new y({props:{title:"Train",local:"train",headingTag:"h2"}}),Zs=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmclMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(model_checkpoint)`,wrap:!1}}),Rs=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBJTIzJTIwUkVQTEFDRSUyMFRISVMlMjBXSVRIJTIwWU9VUiUyMFJFUE8lMjBJRCUwQXJlcG9faWQlMjAlM0QlMjAlMjJNYXJpYUslMkZsYXlvdXRsbXYyLWJhc2UtdW5jYXNlZF9maW5ldHVuZWRfZG9jdnFhJTIyJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QyMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNENWUtNSUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfdG90YWxfbGltaXQlM0QyJTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX3VudXNlZF9jb2x1bW5zJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># REPLACE THIS WITH YOUR REPO ID</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;MariaK/layoutlmv2-base-uncased_finetuned_docvqa&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=repo_id,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    eval_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),As=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator()`,wrap:!1}}),Gs=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RlbmNvZGVkX3RyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RlbmNvZGVkX3Rlc3RfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    train_dataset=encoded_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=encoded_test_dataset,
<span class="hljs-meta">... </span>    tokenizer=processor,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),Ws=new M({props:{code:"dHJhaW5lci5jcmVhdGVfbW9kZWxfY2FyZCgpJTBBdHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.create_model_card()
<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()`,wrap:!1}}),Ns=new y({props:{title:"Inference",local:"inference",headingTag:"h2"}}),Fs=new M({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMiU1RCUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QiUyMnF1ZXJ5JTIyJTVEJTVCJTIyZW4lMjIlNUQlMEFpbWFnZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJpbWFnZSUyMiU1RCUwQXByaW50KHF1ZXN0aW9uKSUwQXByaW50KGV4YW1wbGUlNUIlMjJhbnN3ZXJzJTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">2</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&quot;query&quot;</span>][<span class="hljs-string">&quot;en&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = example[<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(question)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(example[<span class="hljs-string">&quot;answers&quot;</span>])
<span class="hljs-string">&#x27;Who is ‘presiding’ TRRF GENERAL SESSION (PART 1)?&#x27;</span>
[<span class="hljs-string">&#x27;TRRF Vice President&#x27;</span>, <span class="hljs-string">&#x27;lee a. waller&#x27;</span>]`,wrap:!1}}),zs=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcWFfcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZSglMjJkb2N1bWVudC1xdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMk1hcmlhSyUyRmxheW91dGxtdjItYmFzZS11bmNhc2VkX2ZpbmV0dW5lZF9kb2N2cWElMjIpJTBBcWFfcGlwZWxpbmUoaW1hZ2UlMkMlMjBxdWVzdGlvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>qa_pipeline = pipeline(<span class="hljs-string">&quot;document-question-answering&quot;</span>, model=<span class="hljs-string">&quot;MariaK/layoutlmv2-base-uncased_finetuned_docvqa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>qa_pipeline(image, question)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9949808120727539</span>,
  <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Lee A. Waller&#x27;</span>,
  <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">55</span>,
  <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">57</span>}]`,wrap:!1}}),Hs=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGbGF5b3V0bG12Mi1iYXNlLXVuY2FzZWRfZmluZXR1bmVkX2RvY3ZxYSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMk1hcmlhSyUyRmxheW91dGxtdjItYmFzZS11bmNhc2VkX2ZpbmV0dW5lZF9kb2N2cWElMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSUyQyUyMHF1ZXN0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKiplbmNvZGluZyklMEElMjAlMjAlMjAlMjBzdGFydF9sb2dpdHMlMjAlM0QlMjBvdXRwdXRzLnN0YXJ0X2xvZ2l0cyUwQSUyMCUyMCUyMCUyMGVuZF9sb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmVuZF9sb2dpdHMlMEElMjAlMjAlMjAlMjBwcmVkaWN0ZWRfc3RhcnRfaWR4JTIwJTNEJTIwc3RhcnRfbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2VuZF9pZHglMjAlM0QlMjBlbmRfbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBJTBBcHJvY2Vzc29yLnRva2VuaXplci5kZWNvZGUoZW5jb2RpbmcuaW5wdXRfaWRzLnNxdWVlemUoKSU1QnByZWRpY3RlZF9zdGFydF9pZHglMjAlM0ElMjBwcmVkaWN0ZWRfZW5kX2lkeCUyMCUyQiUyMDElNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;MariaK/layoutlmv2-base-uncased_finetuned_docvqa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;MariaK/layoutlmv2-base-uncased_finetuned_docvqa&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    encoding = processor(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>), question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>    outputs = model(**encoding)
<span class="hljs-meta">... </span>    start_logits = outputs.start_logits
<span class="hljs-meta">... </span>    end_logits = outputs.end_logits
<span class="hljs-meta">... </span>    predicted_start_idx = start_logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">... </span>    predicted_end_idx = end_logits.argmax(-<span class="hljs-number">1</span>).item()

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.tokenizer.decode(encoding.input_ids.squeeze()[predicted_start_idx : predicted_end_idx + <span class="hljs-number">1</span>])
<span class="hljs-string">&#x27;lee a. waller&#x27;</span>`,wrap:!1}}),Ss=new Zl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/document_question_answering.md"}}),{c(){g=p("meta"),J=t(),x=p("p"),Ls=t(),o(f.$$.fragment),Ks=t(),o(b.$$.fragment),Os=t(),T=p("p"),T.textContent=Zn,sa=t(),U=p("p"),U.textContent=vn,aa=t(),C=p("ul"),C.innerHTML=Rn,na=t(),o(u.$$.fragment),la=t(),I=p("p"),I.textContent=Xn,ta=t(),_=p("p"),_.textContent=An,ea=t(),o(k.$$.fragment),pa=t(),o(Z.$$.fragment),ia=t(),o(v.$$.fragment),ra=t(),R=p("p"),R.textContent=$n,oa=t(),X=p("p"),X.textContent=Gn,ca=t(),o(A.$$.fragment),ha=t(),$=p("p"),$.textContent=Bn,ja=t(),o(G.$$.fragment),da=t(),o(B.$$.fragment),ma=t(),W=p("p"),W.innerHTML=Wn,Ma=t(),o(N.$$.fragment),ga=t(),V=p("p"),V.textContent=Nn,xa=t(),o(Q.$$.fragment),ua=t(),F=p("p"),F.textContent=Vn,wa=t(),E=p("ul"),E.innerHTML=Qn,ya=t(),z=p("p"),z.innerHTML=Fn,Ja=t(),o(q.$$.fragment),fa=t(),Y=p("p"),Y.innerHTML=En,ba=t(),o(H.$$.fragment),Ta=t(),S=p("p"),S.innerHTML=zn,Ua=t(),o(L.$$.fragment),Ca=t(),P=p("p"),P.textContent=qn,Ia=t(),o(D.$$.fragment),_a=t(),w=p("div"),w.innerHTML=Yn,ka=t(),o(K.$$.fragment),Za=t(),O=p("p"),O.innerHTML=Hn,va=t(),o(ss.$$.fragment),Ra=t(),o(as.$$.fragment),Xa=t(),ns=p("p"),ns.innerHTML=Sn,Aa=t(),o(ls.$$.fragment),$a=t(),ts=p("p"),ts.innerHTML=Ln,Ga=t(),o(es.$$.fragment),Ba=t(),o(ps.$$.fragment),Wa=t(),is=p("p"),is.innerHTML=Pn,Na=t(),o(rs.$$.fragment),Va=t(),os=p("p"),os.innerHTML=Dn,Qa=t(),cs=p("p"),cs.textContent=Kn,Fa=t(),hs=p("p"),hs.innerHTML=On,Ea=t(),o(js.$$.fragment),za=t(),ds=p("p"),ds.textContent=sl,qa=t(),o(ms.$$.fragment),Ya=t(),Ms=p("p"),Ms.textContent=al,Ha=t(),o(gs.$$.fragment),Sa=t(),xs=p("p"),xs.textContent=nl,La=t(),us=p("ul"),us.innerHTML=ll,Pa=t(),ws=p("p"),ws.textContent=tl,Da=t(),o(ys.$$.fragment),Ka=t(),Js=p("p"),Js.textContent=el,Oa=t(),o(fs.$$.fragment),sn=t(),bs=p("p"),bs.textContent=pl,an=t(),o(Ts.$$.fragment),nn=t(),o(Us.$$.fragment),ln=t(),Cs=p("p"),Cs.innerHTML=il,tn=t(),o(Is.$$.fragment),en=t(),_s=p("p"),_s.textContent=rl,pn=t(),ks=p("ul"),ks.innerHTML=ol,rn=t(),o(Zs.$$.fragment),on=t(),vs=p("p"),vs.innerHTML=cl,cn=t(),o(Rs.$$.fragment),hn=t(),Xs=p("p"),Xs.textContent=hl,jn=t(),o(As.$$.fragment),dn=t(),$s=p("p"),$s.innerHTML=jl,mn=t(),o(Gs.$$.fragment),Mn=t(),Bs=p("p"),Bs.innerHTML=dl,gn=t(),o(Ws.$$.fragment),xn=t(),o(Ns.$$.fragment),un=t(),Vs=p("p"),Vs.innerHTML=ml,wn=t(),Qs=p("p"),Qs.textContent=Ml,yn=t(),o(Fs.$$.fragment),Jn=t(),Es=p("p"),Es.textContent=gl,fn=t(),o(zs.$$.fragment),bn=t(),qs=p("p"),qs.textContent=xl,Tn=t(),Ys=p("ol"),Ys.innerHTML=ul,Un=t(),o(Hs.$$.fragment),Cn=t(),o(Ss.$$.fragment),In=t(),Ps=p("p"),this.h()},l(s){const a=Cl("svelte-u9bgzb",document.head);g=i(a,"META",{name:!0,content:!0}),a.forEach(n),J=e(s),x=i(s,"P",{}),yl(x).forEach(n),Ls=e(s),c(f.$$.fragment,s),Ks=e(s),c(b.$$.fragment,s),Os=e(s),T=i(s,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1c1m6de"&&(T.textContent=Zn),sa=e(s),U=i(s,"P",{"data-svelte-h":!0}),r(U)!=="svelte-ku8orh"&&(U.textContent=vn),aa=e(s),C=i(s,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-1g8eree"&&(C.innerHTML=Rn),na=e(s),c(u.$$.fragment,s),la=e(s),I=i(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1svbrv5"&&(I.textContent=Xn),ta=e(s),_=i(s,"P",{"data-svelte-h":!0}),r(_)!=="svelte-17fjxql"&&(_.textContent=An),ea=e(s),c(k.$$.fragment,s),pa=e(s),c(Z.$$.fragment,s),ia=e(s),c(v.$$.fragment,s),ra=e(s),R=i(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-hsz112"&&(R.textContent=$n),oa=e(s),X=i(s,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1yqpblu"&&(X.textContent=Gn),ca=e(s),c(A.$$.fragment,s),ha=e(s),$=i(s,"P",{"data-svelte-h":!0}),r($)!=="svelte-1us2g34"&&($.textContent=Bn),ja=e(s),c(G.$$.fragment,s),da=e(s),c(B.$$.fragment,s),ma=e(s),W=i(s,"P",{"data-svelte-h":!0}),r(W)!=="svelte-xkaeyi"&&(W.innerHTML=Wn),Ma=e(s),c(N.$$.fragment,s),ga=e(s),V=i(s,"P",{"data-svelte-h":!0}),r(V)!=="svelte-18ggx10"&&(V.textContent=Nn),xa=e(s),c(Q.$$.fragment,s),ua=e(s),F=i(s,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1fi388d"&&(F.textContent=Vn),wa=e(s),E=i(s,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-12b5dxa"&&(E.innerHTML=Qn),ya=e(s),z=i(s,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1h0f0qo"&&(z.innerHTML=Fn),Ja=e(s),c(q.$$.fragment,s),fa=e(s),Y=i(s,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-x5p0j2"&&(Y.innerHTML=En),ba=e(s),c(H.$$.fragment,s),Ta=e(s),S=i(s,"P",{"data-svelte-h":!0}),r(S)!=="svelte-hd32bb"&&(S.innerHTML=zn),Ua=e(s),c(L.$$.fragment,s),Ca=e(s),P=i(s,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1vy80t"&&(P.textContent=qn),Ia=e(s),c(D.$$.fragment,s),_a=e(s),w=i(s,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-q63tj1"&&(w.innerHTML=Yn),ka=e(s),c(K.$$.fragment,s),Za=e(s),O=i(s,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1ef5e0f"&&(O.innerHTML=Hn),va=e(s),c(ss.$$.fragment,s),Ra=e(s),c(as.$$.fragment,s),Xa=e(s),ns=i(s,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-1u7369n"&&(ns.innerHTML=Sn),Aa=e(s),c(ls.$$.fragment,s),$a=e(s),ts=i(s,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-1um3786"&&(ts.innerHTML=Ln),Ga=e(s),c(es.$$.fragment,s),Ba=e(s),c(ps.$$.fragment,s),Wa=e(s),is=i(s,"P",{"data-svelte-h":!0}),r(is)!=="svelte-dfarfe"&&(is.innerHTML=Pn),Na=e(s),c(rs.$$.fragment,s),Va=e(s),os=i(s,"P",{"data-svelte-h":!0}),r(os)!=="svelte-12sojfo"&&(os.innerHTML=Dn),Qa=e(s),cs=i(s,"P",{"data-svelte-h":!0}),r(cs)!=="svelte-1kkerbo"&&(cs.textContent=Kn),Fa=e(s),hs=i(s,"P",{"data-svelte-h":!0}),r(hs)!=="svelte-1wppb4o"&&(hs.innerHTML=On),Ea=e(s),c(js.$$.fragment,s),za=e(s),ds=i(s,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-19pibjd"&&(ds.textContent=sl),qa=e(s),c(ms.$$.fragment,s),Ya=e(s),Ms=i(s,"P",{"data-svelte-h":!0}),r(Ms)!=="svelte-19lp6r8"&&(Ms.textContent=al),Ha=e(s),c(gs.$$.fragment,s),Sa=e(s),xs=i(s,"P",{"data-svelte-h":!0}),r(xs)!=="svelte-1tk94l"&&(xs.textContent=nl),La=e(s),us=i(s,"UL",{"data-svelte-h":!0}),r(us)!=="svelte-zfehno"&&(us.innerHTML=ll),Pa=e(s),ws=i(s,"P",{"data-svelte-h":!0}),r(ws)!=="svelte-701rvg"&&(ws.textContent=tl),Da=e(s),c(ys.$$.fragment,s),Ka=e(s),Js=i(s,"P",{"data-svelte-h":!0}),r(Js)!=="svelte-1ori799"&&(Js.textContent=el),Oa=e(s),c(fs.$$.fragment,s),sn=e(s),bs=i(s,"P",{"data-svelte-h":!0}),r(bs)!=="svelte-upxsp"&&(bs.textContent=pl),an=e(s),c(Ts.$$.fragment,s),nn=e(s),c(Us.$$.fragment,s),ln=e(s),Cs=i(s,"P",{"data-svelte-h":!0}),r(Cs)!=="svelte-18jxegk"&&(Cs.innerHTML=il),tn=e(s),c(Is.$$.fragment,s),en=e(s),_s=i(s,"P",{"data-svelte-h":!0}),r(_s)!=="svelte-10f6ay"&&(_s.textContent=rl),pn=e(s),ks=i(s,"UL",{"data-svelte-h":!0}),r(ks)!=="svelte-35zjwq"&&(ks.innerHTML=ol),rn=e(s),c(Zs.$$.fragment,s),on=e(s),vs=i(s,"P",{"data-svelte-h":!0}),r(vs)!=="svelte-1tj9c7q"&&(vs.innerHTML=cl),cn=e(s),c(Rs.$$.fragment,s),hn=e(s),Xs=i(s,"P",{"data-svelte-h":!0}),r(Xs)!=="svelte-1gq6t8w"&&(Xs.textContent=hl),jn=e(s),c(As.$$.fragment,s),dn=e(s),$s=i(s,"P",{"data-svelte-h":!0}),r($s)!=="svelte-173vn5o"&&($s.innerHTML=jl),mn=e(s),c(Gs.$$.fragment,s),Mn=e(s),Bs=i(s,"P",{"data-svelte-h":!0}),r(Bs)!=="svelte-gilssp"&&(Bs.innerHTML=dl),gn=e(s),c(Ws.$$.fragment,s),xn=e(s),c(Ns.$$.fragment,s),un=e(s),Vs=i(s,"P",{"data-svelte-h":!0}),r(Vs)!=="svelte-1cscx5v"&&(Vs.innerHTML=ml),wn=e(s),Qs=i(s,"P",{"data-svelte-h":!0}),r(Qs)!=="svelte-1wtngfz"&&(Qs.textContent=Ml),yn=e(s),c(Fs.$$.fragment,s),Jn=e(s),Es=i(s,"P",{"data-svelte-h":!0}),r(Es)!=="svelte-mcchgg"&&(Es.textContent=gl),fn=e(s),c(zs.$$.fragment,s),bn=e(s),qs=i(s,"P",{"data-svelte-h":!0}),r(qs)!=="svelte-o6117l"&&(qs.textContent=xl),Tn=e(s),Ys=i(s,"OL",{"data-svelte-h":!0}),r(Ys)!=="svelte-19rdijs"&&(Ys.innerHTML=ul),Un=e(s),c(Hs.$$.fragment,s),Cn=e(s),c(Ss.$$.fragment,s),In=e(s),Ps=i(s,"P",{}),yl(Ps).forEach(n),this.h()},h(){kn(g,"name","hf:doc:metadata"),kn(g,"content",Xl),kn(w,"class","flex justify-center")},m(s,a){Il(document.head,g),l(s,J,a),l(s,x,a),l(s,Ls,a),h(f,s,a),l(s,Ks,a),h(b,s,a),l(s,Os,a),l(s,T,a),l(s,sa,a),l(s,U,a),l(s,aa,a),l(s,C,a),l(s,na,a),h(u,s,a),l(s,la,a),l(s,I,a),l(s,ta,a),l(s,_,a),l(s,ea,a),h(k,s,a),l(s,pa,a),h(Z,s,a),l(s,ia,a),h(v,s,a),l(s,ra,a),l(s,R,a),l(s,oa,a),l(s,X,a),l(s,ca,a),h(A,s,a),l(s,ha,a),l(s,$,a),l(s,ja,a),h(G,s,a),l(s,da,a),h(B,s,a),l(s,ma,a),l(s,W,a),l(s,Ma,a),h(N,s,a),l(s,ga,a),l(s,V,a),l(s,xa,a),h(Q,s,a),l(s,ua,a),l(s,F,a),l(s,wa,a),l(s,E,a),l(s,ya,a),l(s,z,a),l(s,Ja,a),h(q,s,a),l(s,fa,a),l(s,Y,a),l(s,ba,a),h(H,s,a),l(s,Ta,a),l(s,S,a),l(s,Ua,a),h(L,s,a),l(s,Ca,a),l(s,P,a),l(s,Ia,a),h(D,s,a),l(s,_a,a),l(s,w,a),l(s,ka,a),h(K,s,a),l(s,Za,a),l(s,O,a),l(s,va,a),h(ss,s,a),l(s,Ra,a),h(as,s,a),l(s,Xa,a),l(s,ns,a),l(s,Aa,a),h(ls,s,a),l(s,$a,a),l(s,ts,a),l(s,Ga,a),h(es,s,a),l(s,Ba,a),h(ps,s,a),l(s,Wa,a),l(s,is,a),l(s,Na,a),h(rs,s,a),l(s,Va,a),l(s,os,a),l(s,Qa,a),l(s,cs,a),l(s,Fa,a),l(s,hs,a),l(s,Ea,a),h(js,s,a),l(s,za,a),l(s,ds,a),l(s,qa,a),h(ms,s,a),l(s,Ya,a),l(s,Ms,a),l(s,Ha,a),h(gs,s,a),l(s,Sa,a),l(s,xs,a),l(s,La,a),l(s,us,a),l(s,Pa,a),l(s,ws,a),l(s,Da,a),h(ys,s,a),l(s,Ka,a),l(s,Js,a),l(s,Oa,a),h(fs,s,a),l(s,sn,a),l(s,bs,a),l(s,an,a),h(Ts,s,a),l(s,nn,a),h(Us,s,a),l(s,ln,a),l(s,Cs,a),l(s,tn,a),h(Is,s,a),l(s,en,a),l(s,_s,a),l(s,pn,a),l(s,ks,a),l(s,rn,a),h(Zs,s,a),l(s,on,a),l(s,vs,a),l(s,cn,a),h(Rs,s,a),l(s,hn,a),l(s,Xs,a),l(s,jn,a),h(As,s,a),l(s,dn,a),l(s,$s,a),l(s,mn,a),h(Gs,s,a),l(s,Mn,a),l(s,Bs,a),l(s,gn,a),h(Ws,s,a),l(s,xn,a),h(Ns,s,a),l(s,un,a),l(s,Vs,a),l(s,wn,a),l(s,Qs,a),l(s,yn,a),h(Fs,s,a),l(s,Jn,a),l(s,Es,a),l(s,fn,a),h(zs,s,a),l(s,bn,a),l(s,qs,a),l(s,Tn,a),l(s,Ys,a),l(s,Un,a),h(Hs,s,a),l(s,Cn,a),h(Ss,s,a),l(s,In,a),l(s,Ps,a),_n=!0},p(s,[a]){const wl={};a&2&&(wl.$$scope={dirty:a,ctx:s}),u.$set(wl)},i(s){_n||(j(f.$$.fragment,s),j(b.$$.fragment,s),j(u.$$.fragment,s),j(k.$$.fragment,s),j(Z.$$.fragment,s),j(v.$$.fragment,s),j(A.$$.fragment,s),j(G.$$.fragment,s),j(B.$$.fragment,s),j(N.$$.fragment,s),j(Q.$$.fragment,s),j(q.$$.fragment,s),j(H.$$.fragment,s),j(L.$$.fragment,s),j(D.$$.fragment,s),j(K.$$.fragment,s),j(ss.$$.fragment,s),j(as.$$.fragment,s),j(ls.$$.fragment,s),j(es.$$.fragment,s),j(ps.$$.fragment,s),j(rs.$$.fragment,s),j(js.$$.fragment,s),j(ms.$$.fragment,s),j(gs.$$.fragment,s),j(ys.$$.fragment,s),j(fs.$$.fragment,s),j(Ts.$$.fragment,s),j(Us.$$.fragment,s),j(Is.$$.fragment,s),j(Zs.$$.fragment,s),j(Rs.$$.fragment,s),j(As.$$.fragment,s),j(Gs.$$.fragment,s),j(Ws.$$.fragment,s),j(Ns.$$.fragment,s),j(Fs.$$.fragment,s),j(zs.$$.fragment,s),j(Hs.$$.fragment,s),j(Ss.$$.fragment,s),_n=!0)},o(s){d(f.$$.fragment,s),d(b.$$.fragment,s),d(u.$$.fragment,s),d(k.$$.fragment,s),d(Z.$$.fragment,s),d(v.$$.fragment,s),d(A.$$.fragment,s),d(G.$$.fragment,s),d(B.$$.fragment,s),d(N.$$.fragment,s),d(Q.$$.fragment,s),d(q.$$.fragment,s),d(H.$$.fragment,s),d(L.$$.fragment,s),d(D.$$.fragment,s),d(K.$$.fragment,s),d(ss.$$.fragment,s),d(as.$$.fragment,s),d(ls.$$.fragment,s),d(es.$$.fragment,s),d(ps.$$.fragment,s),d(rs.$$.fragment,s),d(js.$$.fragment,s),d(ms.$$.fragment,s),d(gs.$$.fragment,s),d(ys.$$.fragment,s),d(fs.$$.fragment,s),d(Ts.$$.fragment,s),d(Us.$$.fragment,s),d(Is.$$.fragment,s),d(Zs.$$.fragment,s),d(Rs.$$.fragment,s),d(As.$$.fragment,s),d(Gs.$$.fragment,s),d(Ws.$$.fragment,s),d(Ns.$$.fragment,s),d(Fs.$$.fragment,s),d(zs.$$.fragment,s),d(Hs.$$.fragment,s),d(Ss.$$.fragment,s),_n=!1},d(s){s&&(n(J),n(x),n(Ls),n(Ks),n(Os),n(T),n(sa),n(U),n(aa),n(C),n(na),n(la),n(I),n(ta),n(_),n(ea),n(pa),n(ia),n(ra),n(R),n(oa),n(X),n(ca),n(ha),n($),n(ja),n(da),n(ma),n(W),n(Ma),n(ga),n(V),n(xa),n(ua),n(F),n(wa),n(E),n(ya),n(z),n(Ja),n(fa),n(Y),n(ba),n(Ta),n(S),n(Ua),n(Ca),n(P),n(Ia),n(_a),n(w),n(ka),n(Za),n(O),n(va),n(Ra),n(Xa),n(ns),n(Aa),n($a),n(ts),n(Ga),n(Ba),n(Wa),n(is),n(Na),n(Va),n(os),n(Qa),n(cs),n(Fa),n(hs),n(Ea),n(za),n(ds),n(qa),n(Ya),n(Ms),n(Ha),n(Sa),n(xs),n(La),n(us),n(Pa),n(ws),n(Da),n(Ka),n(Js),n(Oa),n(sn),n(bs),n(an),n(nn),n(ln),n(Cs),n(tn),n(en),n(_s),n(pn),n(ks),n(rn),n(on),n(vs),n(cn),n(hn),n(Xs),n(jn),n(dn),n($s),n(mn),n(Mn),n(Bs),n(gn),n(xn),n(un),n(Vs),n(wn),n(Qs),n(yn),n(Jn),n(Es),n(fn),n(bn),n(qs),n(Tn),n(Ys),n(Un),n(Cn),n(In),n(Ps)),n(g),m(f,s),m(b,s),m(u,s),m(k,s),m(Z,s),m(v,s),m(A,s),m(G,s),m(B,s),m(N,s),m(Q,s),m(q,s),m(H,s),m(L,s),m(D,s),m(K,s),m(ss,s),m(as,s),m(ls,s),m(es,s),m(ps,s),m(rs,s),m(js,s),m(ms,s),m(gs,s),m(ys,s),m(fs,s),m(Ts,s),m(Us,s),m(Is,s),m(Zs,s),m(Rs,s),m(As,s),m(Gs,s),m(Ws,s),m(Ns,s),m(Fs,s),m(zs,s),m(Hs,s),m(Ss,s)}}}const Xl='{"title":"Document Question Answering","local":"document-question-answering","sections":[{"title":"Load the data","local":"load-the-data","sections":[],"depth":2},{"title":"Preprocess the data","local":"preprocess-the-data","sections":[{"title":"Preprocessing document images","local":"preprocessing-document-images","sections":[],"depth":3},{"title":"Preprocessing text data","local":"preprocessing-text-data","sections":[],"depth":3}],"depth":2},{"title":"Evaluation","local":"evaluation","sections":[],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Al(Ds){return fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ql extends Tl{constructor(g){super(),Ul(this,g,Al,Rl,Jl,{})}}export{Ql as component};
