import{s as Uo,o as Fo,n as xt}from"../chunks/scheduler.25b97de1.js";import{S as Jo,i as Eo,g as l,s as n,r as f,A as Po,h as i,f as o,c as s,j as z,u,x as c,k as q,y as a,a as r,v as h,d as _,t as g,w as k}from"../chunks/index.d9030fc9.js";import{T as jo}from"../chunks/Tip.baa67368.js";import{D as U}from"../chunks/Docstring.ffac8efa.js";import{C as Se}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Io}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as Ve,E as Ho}from"../chunks/EditOnGithub.91d95064.js";function Wo(F){let d,$="The <code>Llama2</code> family models, on which Code Llama is based, were trained using <code>bfloat16</code>, but the original inference uses <code>float16</code>. Let’s look at the different precisions:",m,b,w="<li><code>float32</code>: PyTorch convention on model initialization is to load models in <code>float32</code>, no matter with which <code>dtype</code> the model weights were stored. <code>transformers</code> also follows this convention for consistency with PyTorch. This will be picked by default. If you want the <code>AutoModel</code> API to load the checkpoints with the storage weights type, you must specify <code>torch_dtype=&quot;auto&quot;</code>, e.g. <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>.</li> <li><code>bfloat16</code>: Code Llama was trained with this precision, so we recommend using it for further training or fine-tuning.</li> <li><code>float16</code>: We recommend running inference using this precision, as it’s usually faster than <code>bfloat16</code>, and evaluation metrics show no discernible degradation with respect to <code>bfloat16</code>. You can also run inference using <code>bfloat16</code>, and we recommend you check inference results with both <code>float16</code> and <code>bfloat16</code> after fine-tuning.</li>",v,x,G="As mentioned above, the <code>dtype</code> of the storage weights is mostly irrelevant unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using. The reason is that the model will first be downloaded (using the <code>dtype</code> of the checkpoints online) and then will be casted to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>). If there is a specified <code>torch_dtype</code>, it will be used instead.";return{c(){d=l("p"),d.innerHTML=$,m=n(),b=l("ul"),b.innerHTML=w,v=n(),x=l("p"),x.innerHTML=G},l(T){d=i(T,"P",{"data-svelte-h":!0}),c(d)!=="svelte-8yf686"&&(d.innerHTML=$),m=s(T),b=i(T,"UL",{"data-svelte-h":!0}),c(b)!=="svelte-1f9e2ui"&&(b.innerHTML=w),v=s(T),x=i(T,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1bzil5i"&&(x.innerHTML=G)},m(T,P){r(T,d,P),r(T,m,P),r(T,b,P),r(T,v,P),r(T,x,P)},p:xt,d(T){T&&(o(d),o(m),o(b),o(v),o(x))}}}function No(F){let d,$=`Code Llama has the same architecture as the <code>Llama2</code> models, refer to <a href="llama2">Llama2’s documentation page</a> for the API reference.
Find Code Llama tokenizer reference below.`;return{c(){d=l("p"),d.innerHTML=$},l(m){d=i(m,"P",{"data-svelte-h":!0}),c(d)!=="svelte-1buct0x"&&(d.innerHTML=$)},m(m,b){r(m,d,b)},p:xt,d(m){m&&o(d)}}}function Ro(F){let d,$="sequence pair mask has the following format:",m,b,w;return b=new Se({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`,wrap:!1}}),{c(){d=l("p"),d.textContent=$,m=n(),f(b.$$.fragment)},l(v){d=i(v,"P",{"data-svelte-h":!0}),c(d)!=="svelte-16klr56"&&(d.textContent=$),m=s(v),u(b.$$.fragment,v)},m(v,x){r(v,d,x),r(v,m,x),h(b,v,x),w=!0},p:xt,i(v){w||(_(b.$$.fragment,v),w=!0)},o(v){g(b.$$.fragment,v),w=!1},d(v){v&&(o(d),o(m)),k(b,v)}}}function Zo(F){let d,$;return d=new Se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvZGVMbGFtYVRva2VuaXplckZhc3QlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBDb2RlTGxhbWFUb2tlbml6ZXJGYXN0LmZyb21fcHJldHJhaW5lZCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGxhbWEtdG9rZW5pemVyJTIyKSUwQXRva2VuaXplci5lbmNvZGUoJTIySGVsbG8lMjB0aGlzJTIwaXMlMjBhJTIwdGVzdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CodeLlamaTokenizerFast

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CodeLlamaTokenizerFast.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/llama-tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.encode(<span class="hljs-string">&quot;Hello this is a test&quot;</span>)
[<span class="hljs-number">1</span>, <span class="hljs-number">15043</span>, <span class="hljs-number">445</span>, <span class="hljs-number">338</span>, <span class="hljs-number">263</span>, <span class="hljs-number">1243</span>]`,wrap:!1}}),{c(){f(d.$$.fragment)},l(m){u(d.$$.fragment,m)},m(m,b){h(d,m,b),$=!0},p:xt,i(m){$||(_(d.$$.fragment,m),$=!0)},o(m){g(d.$$.fragment,m),$=!1},d(m){k(d,m)}}}function Bo(F){let d,$,m,b,w,v,x,G,T,P='The Code Llama model was proposed in <a href="https://ai.meta.com/research/publications/code-llama-open-foundation-models-for-code/" rel="nofollow">Code Llama: Open Foundation Models for Code</a> by Baptiste Rozière, Jonas Gehring, Fabian Gloeckle, Sten Sootla, Itai Gat, Xiaoqing Ellen Tan, Yossi Adi, Jingyu Liu, Tal Remez, Jérémy Rapin, Artyom Kozhevnikov, Ivan Evtimov, Joanna Bitton, Manish Bhatt, Cristian Canton Ferrer, Aaron Grattafiori, Wenhan Xiong, Alexandre Défossez, Jade Copet, Faisal Azhar, Hugo Touvron, Louis Martin, Nicolas Usunier, Thomas Scialom, Gabriel Synnaeve.',Xe,V,Kt="The abstract from the paper is the following:",Qe,S,eo="<em>We release Code Llama, a family of large language models for code based on Llama 2 providing state-of-the-art performance among open models, infilling capabilities, support for large input contexts, and zero-shot instruction following ability for programming tasks. We provide multiple flavors to cover a wide range of applications: foundation models (Code Llama), Python specializations (Code Llama - Python), and instruction-following models (Code Llama - Instruct) with 7B, 13B and 34B parameters each. All models are trained on sequences of 16k tokens and show improvements on inputs with up to 100k tokens. 7B and 13B Code Llama and Code Llama - Instruct variants support infilling based on surrounding content. Code Llama reaches state-of-the-art performance among open models on several code benchmarks, with scores of up to 53% and 55% on HumanEval and MBPP, respectively. Notably, Code Llama - Python 7B outperforms Llama 2 70B on HumanEval and MBPP, and all our models outperform every other publicly available model on MultiPL-E. We release Code Llama under a permissive license that allows for both research and commercial use.</em>",Ye,X,to='Check out all Code Llama model checkpoints <a href="https://huggingface.co/models?search=code_llama" rel="nofollow">here</a> and the officially released ones in the <a href="https://huggingface.co/meta-llama" rel="nofollow">Meta Llama org</a>.',Oe,Q,oo='This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">ArthurZucker</a>. The original code of the authors can be found <a href="https://github.com/facebookresearch/llama" rel="nofollow">here</a>.',Ke,Y,et,H,tt,O,no="Tips:",ot,K,so="<li>The infilling task is supported out of the box. You should be using the <code>tokenizer.fill_token</code> where you want your input to be filled.</li> <li>The model conversion script is the same as for the <code>Llama2</code> family:</li>",nt,ee,ao="Here is a sample usage:",st,te,at,oe,ro=`Note that executing the script requires enough CPU RAM to host the whole model in float16 precision (even if the biggest versions
come in several checkpoints they each contain a part of each weight of the model, so we need to load them all in RAM).`,rt,ne,lo="After conversion, the model and tokenizer can be loaded via:",lt,se,it,ae,io="If you only want the infilled part:",dt,re,ct,le,co='Under the hood, the tokenizer <a href="https://huggingface.co/docs/transformers/main/model_doc/code_llama#transformers.CodeLlamaTokenizer.fill_token" rel="nofollow">automatically splits by <code>&lt;FILL_ME&gt;</code></a> to create a formatted input string that follows <a href="https://github.com/facebookresearch/codellama/blob/cb51c14ec761370ba2e2bc351374a79265d0465e/llama/generation.py#L402" rel="nofollow">the original training pattern</a>. This is more robust than preparing the pattern yourself: it avoids pitfalls, such as token glueing, that are very hard to debug.  To see how much CPU and GPU memory you need for this model or others, try <a href="https://huggingface.co/spaces/hf-accelerate/model-memory-usage" rel="nofollow">this calculator</a> which can help determine that value.',mt,ie,mo='The LLaMA tokenizer is a BPE model based on <a href="https://github.com/google/sentencepiece" rel="nofollow">sentencepiece</a>. One quirk of sentencepiece is that when decoding a sequence, if the first token is the start of the word (e.g. “Banana”), the tokenizer does not prepend the prefix space to the string.',pt,W,ft,de,ut,L,ce,Lt,Le,po=`Construct a CodeLlama tokenizer. Based on byte-level Byte-Pair-Encoding. The default padding token is unset as
there is no padding token in the original model.`,$t,$e,fo=`The default configuration match that of
<a href="https://huggingface.co/meta-llama/CodeLlama-7b-Instruct-hf/blob/main/tokenizer_config.json" rel="nofollow">codellama/CodeLlama-7b-Instruct-hf</a>
which supports prompt infilling.`,Ct,Ce,me,wt,N,pe,Mt,we,uo=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,zt,j,fe,qt,Me,ho="Creates a mask from the two sequences passed to be used in a sequence-pair classification task. An ALBERT",jt,R,It,ze,_o="if token_ids_1 is None, only returns the first portion of the mask (0s).",Ut,Z,ue,Ft,qe,go="Save the vocabulary and special tokens file to a directory.",ht,he,_t,p,_e,Jt,je,ko="Construct a Llama tokenizer. Based on byte-level Byte-Pair-Encoding.",Et,Ie,bo="This uses notably ByteFallback and no normalization.",Pt,B,Ht,Ue,vo=`If you want to change the <code>bos_token</code> or the <code>eos_token</code>, make sure to specify them when initializing the model, or
call <code>tokenizer.update_post_processor()</code> to make sure that the post-processing is correctly done (otherwise the
values of the first token and final token of an encoded sequence will not be correct). For more details, checkout
[post-processors] (<a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">https://huggingface.co/docs/tokenizers/api/post-processors</a>) documentation.`,Wt,Fe,yo=`This tokenizer inherits from <a href="/docs/transformers/pr_30690/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods. The default configuration match that of
<a href="https://huggingface.co/meta-llama/CodeLlama-7b-Instruct-hf/blob/main/tokenizer_config.json" rel="nofollow">meta-llama/CodeLlama-7b-Instruct-hf</a>
which supports prompt infilling.`,Nt,M,ge,Rt,Je,To=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. The special tokens depend on calling set_lang.`,Zt,Ee,xo="An NLLB sequence has the following format, where <code>X</code> represents the sequence:",Bt,Pe,Lo="<li><code>input_ids</code> (for encoder) <code>X [eos, src_lang_code]</code></li> <li><code>decoder_input_ids</code>: (for decoder) <code>X [eos, tgt_lang_code]</code></li>",At,He,$o=`BOS is never used. Pairs of sequences are not the expected use case, but they will be handled without a
separator.`,Dt,A,ke,Gt,We,Co=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> or <code>encode_plus</code> methods.`,Vt,J,be,St,Ne,wo=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,Xt,Re,Mo="Should be overridden in a subclass if the model has a special way of building those.",Qt,D,ve,Yt,Ze,zo="Updates the underlying post processor with the current <code>bos_token</code> and <code>eos_token</code>.",Ot,Be,ye,gt,Te,kt,De,bt;return w=new Ve({props:{title:"CodeLlama",local:"codellama",headingTag:"h1"}}),x=new Ve({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Y=new Ve({props:{title:"Usage tips and examples",local:"usage-tips-and-examples",headingTag:"h2"}}),H=new jo({props:{warning:!0,$$slots:{default:[Wo]},$$scope:{ctx:F}}}),te=new Se({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbGxhbWElMkZjb252ZXJ0X2xsYW1hX3dlaWdodHNfdG9faGYucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWlucHV0X2RpciUyMCUyRnBhdGglMkZ0byUyRmRvd25sb2FkZWQlMkZsbGFtYSUyRndlaWdodHMlMjAtLW1vZGVsX3NpemUlMjA3QiUyMC0tb3V0cHV0X2RpciUyMCUyRm91dHB1dCUyRnBhdGg=",highlighted:`python src/transformers/models/llama/convert_llama_weights_to_hf.py \\
    --input_dir /path/to/downloaded/llama/weights --model_size 7B --output_dir /output/path`,wrap:!1}}),se=new Se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hRm9yQ2F1c2FsTE0lMkMlMjBDb2RlTGxhbWFUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBDb2RlTGxhbWFUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZDb2RlTGxhbWEtN2ItaGYlMjIpJTBBbW9kZWwlMjAlM0QlMjBMbGFtYUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGQ29kZUxsYW1hLTdiLWhmJTIyKSUwQVBST01QVCUyMCUzRCUyMCcnJ2RlZiUyMHJlbW92ZV9ub25fYXNjaWkocyUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTIwJTNDRklMTF9NRSUzRSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3VsdCUwQScnJyUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplcihQUk9NUFQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCklMEElMEFmaWxsaW5nJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTVCJTNBJTJDJTIwaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUzQSU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlMjAlM0QlMjBUcnVlKSU1QjAlNUQlMEFwcmludChQUk9NUFQucmVwbGFjZSglMjIlM0NGSUxMX01FJTNFJTIyJTJDJTIwZmlsbGluZykp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaForCausalLM, CodeLlamaTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CodeLlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/CodeLlama-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/CodeLlama-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>PROMPT = <span class="hljs-string">&#x27;&#x27;&#x27;def remove_non_ascii(s: str) -&gt; str:
<span class="hljs-meta">... </span>    &quot;&quot;&quot; &lt;FILL_ME&gt;
<span class="hljs-meta">... </span>    return result
<span class="hljs-meta">... </span>&#x27;&#x27;&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(PROMPT, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(input_ids, max_new_tokens=<span class="hljs-number">128</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>filling = tokenizer.batch_decode(generated_ids[:, input_ids.shape[<span class="hljs-number">1</span>]:], skip_special_tokens = <span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(PROMPT.replace(<span class="hljs-string">&quot;&lt;FILL_ME&gt;&quot;</span>, filling))
<span class="hljs-keyword">def</span> <span class="hljs-title function_">remove_non_ascii</span>(<span class="hljs-params">s: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot; Remove non-ASCII characters from a string.
&lt;BLANKLINE&gt;
    Args:
        s: The string to remove non-ASCII characters from.
&lt;BLANKLINE&gt;
    Returns:
        The string with non-ASCII characters removed.
    &quot;&quot;&quot;</span>
    result = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> s:
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">ord</span>(c) &lt; <span class="hljs-number">128</span>:
            result += c
    <span class="hljs-keyword">return</span> result
&lt;BLANKLINE&gt;`,wrap:!1}}),re=new Se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkNtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZDb2RlTGxhbWEtN2ItaGYlMjIlMkN0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEFnZW5lcmF0b3IoJ2RlZiUyMHJlbW92ZV9ub25fYXNjaWkocyUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTVDbiUyMCUyMCUyMCUyMCUyMiUyMiUyMiUyMCUzQ0ZJTExfTUUlM0UlNUNuJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzdWx0JyUyQyUyMG1heF9uZXdfdG9rZW5zJTIwJTNEJTIwMTI4KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>,model=<span class="hljs-string">&quot;meta-llama/CodeLlama-7b-hf&quot;</span>,torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&#x27;def remove_non_ascii(s: str) -&gt; str:\\n    &quot;&quot;&quot; &lt;FILL_ME&gt;\\n    return result&#x27;</span>, max_new_tokens = <span class="hljs-number">128</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;def remove_non_ascii(s: str) -&gt; str:\\n    &quot;&quot;&quot; &lt;FILL_ME&gt;\\n    return resultRemove non-ASCII characters from a string. &quot;&quot;&quot;\\n    result = &quot;&quot;\\n    for c in s:\\n        if ord(c) &lt; 128:\\n            result += c&#x27;</span>}]`,wrap:!1}}),W=new jo({props:{$$slots:{default:[No]},$$scope:{ctx:F}}}),de=new Ve({props:{title:"CodeLlamaTokenizer",local:"transformers.CodeLlamaTokenizer",headingTag:"h2"}}),ce=new U({props:{name:"class transformers.CodeLlamaTokenizer",anchor:"transformers.CodeLlamaTokenizer",parameters:[{name:"vocab_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"prefix_token",val:" = '▁<PRE>'"},{name:"middle_token",val:" = '▁<MID>'"},{name:"suffix_token",val:" = '▁<SUF>'"},{name:"eot_token",val:" = '▁<EOT>'"},{name:"fill_token",val:" = '<FILL_ME>'"},{name:"suffix_first",val:" = False"},{name:"sp_model_kwargs",val:": Optional = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"additional_special_tokens",val:" = None"},{name:"use_default_system_prompt",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.CodeLlamaTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.CodeLlamaTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.CodeLlamaTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.CodeLlamaTokenizer.prefix_token",description:`<strong>prefix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;PRE&gt;&quot;</code>) &#x2014;
Prefix token used for infilling.`,name:"prefix_token"},{anchor:"transformers.CodeLlamaTokenizer.middle_token",description:`<strong>middle_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;MID&gt;&quot;</code>) &#x2014;
Middle token used for infilling.`,name:"middle_token"},{anchor:"transformers.CodeLlamaTokenizer.suffix_token",description:`<strong>suffix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;SUF&gt;&quot;</code>) &#x2014;
Suffix token used for infilling.`,name:"suffix_token"},{anchor:"transformers.CodeLlamaTokenizer.eot_token",description:`<strong>eot_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;EOT&gt;&quot;</code>) &#x2014;
End of text token used for infilling.`,name:"eot_token"},{anchor:"transformers.CodeLlamaTokenizer.fill_token",description:`<strong>fill_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;FILL_ME&gt;&quot;</code>) &#x2014;
The token used to split the input between the prefix and suffix.`,name:"fill_token"},{anchor:"transformers.CodeLlamaTokenizer.suffix_first",description:`<strong>suffix_first</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the input prompt and suffix should be formatted with the suffix first.`,name:"suffix_first"},{anchor:"transformers.CodeLlamaTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.CodeLlamaTokenizer.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a beginning of sequence token at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.CodeLlamaTokenizer.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an end of sequence token at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.CodeLlamaTokenizer.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to clean up the tokenization spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.CodeLlamaTokenizer.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.CodeLlamaTokenizer.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"}],source:"https://github.com/huggingface/transformers/blob/vr_30690/src/transformers/models/code_llama/tokenization_code_llama.py#L49"}}),me=new U({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CodeLlamaTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30690/src/transformers/models/code_llama/tokenization_code_llama.py#L357"}}),pe=new U({props:{name:"get_special_tokens_mask",anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_30690/src/transformers/models/code_llama/tokenization_code_llama.py#L369",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),fe=new U({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_30690/src/transformers/models/code_llama/tokenization_code_llama.py#L407",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),R=new Io({props:{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[Ro]},$$scope:{ctx:F}}}),ue=new U({props:{name:"save_vocabulary",anchor:"transformers.CodeLlamaTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:""},{name:"filename_prefix",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
The directory in which to save the vocabulary.`,name:"save_directory"}],source:"https://github.com/huggingface/transformers/blob/vr_30690/src/transformers/models/code_llama/tokenization_code_llama.py#L329",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Paths to the files saved.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple(str)</code></p>
`}}),he=new Ve({props:{title:"CodeLlamaTokenizerFast",local:"transformers.CodeLlamaTokenizerFast",headingTag:"h2"}}),_e=new U({props:{name:"class transformers.CodeLlamaTokenizerFast",anchor:"transformers.CodeLlamaTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"prefix_token",val:" = '▁<PRE>'"},{name:"middle_token",val:" = '▁<MID>'"},{name:"suffix_token",val:" = '▁<SUF>'"},{name:"eot_token",val:" = '▁<EOT>'"},{name:"fill_token",val:" = '<FILL_ME>'"},{name:"additional_special_tokens",val:" = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a .model extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.CodeLlamaTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/huggingface/tokenizers" rel="nofollow">tokenizers</a> file (generally has a .json extension) that
contains everything needed to load the tokenizer.`,name:"tokenizer_file"},{anchor:"transformers.CodeLlamaTokenizerFast.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Wether to cleanup spaces after decoding, cleanup consists in removing potential artifacts like extra
spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.CodeLlamaTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.CodeLlamaTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.prefix_token",description:`<strong>prefix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;PRE&gt;&quot;</code>) &#x2014;
Prefix token used for infilling.`,name:"prefix_token"},{anchor:"transformers.CodeLlamaTokenizerFast.middle_token",description:`<strong>middle_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;MID&gt;&quot;</code>) &#x2014;
Middle token used for infilling.`,name:"middle_token"},{anchor:"transformers.CodeLlamaTokenizerFast.suffix_token",description:`<strong>suffix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;SUF&gt;&quot;</code>) &#x2014;
Suffix token used for infilling.`,name:"suffix_token"},{anchor:"transformers.CodeLlamaTokenizerFast.eot_token",description:`<strong>eot_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;EOT&gt;&quot;</code>) &#x2014;
End of text token used for infilling.`,name:"eot_token"},{anchor:"transformers.CodeLlamaTokenizerFast.fill_token",description:`<strong>fill_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;FILL_ME&gt;&quot;</code>) &#x2014;
The token used to split the input between the prefix and suffix.`,name:"fill_token"},{anchor:"transformers.CodeLlamaTokenizerFast.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.CodeLlamaTokenizerFast.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a beginning of sequence token at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an end of sequence token at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"}],source:"https://github.com/huggingface/transformers/blob/vr_30690/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L52"}}),B=new Io({props:{anchor:"transformers.CodeLlamaTokenizerFast.example",$$slots:{default:[Zo]},$$scope:{ctx:F}}}),ge=new U({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_30690/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L352",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ke=new U({props:{name:"get_special_tokens_mask",anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of ids of the second sequence.`,name:"token_ids_1"},{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_30690/src/transformers/tokenization_utils_base.py#L4016",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]</p>
`}}),be=new U({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_30690/src/transformers/tokenization_utils_base.py#L3539",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ve=new U({props:{name:"update_post_processor",anchor:"transformers.CodeLlamaTokenizerFast.update_post_processor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30690/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L179"}}),ye=new U({props:{name:"save_vocabulary",anchor:"transformers.CodeLlamaTokenizerFast.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30690/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L333"}}),Te=new Ho({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/code_llama.md"}}),{c(){d=l("meta"),$=n(),m=l("p"),b=n(),f(w.$$.fragment),v=n(),f(x.$$.fragment),G=n(),T=l("p"),T.innerHTML=P,Xe=n(),V=l("p"),V.textContent=Kt,Qe=n(),S=l("p"),S.innerHTML=eo,Ye=n(),X=l("p"),X.innerHTML=to,Oe=n(),Q=l("p"),Q.innerHTML=oo,Ke=n(),f(Y.$$.fragment),et=n(),f(H.$$.fragment),tt=n(),O=l("p"),O.textContent=no,ot=n(),K=l("ul"),K.innerHTML=so,nt=n(),ee=l("p"),ee.textContent=ao,st=n(),f(te.$$.fragment),at=n(),oe=l("p"),oe.textContent=ro,rt=n(),ne=l("p"),ne.textContent=lo,lt=n(),f(se.$$.fragment),it=n(),ae=l("p"),ae.textContent=io,dt=n(),f(re.$$.fragment),ct=n(),le=l("p"),le.innerHTML=co,mt=n(),ie=l("p"),ie.innerHTML=mo,pt=n(),f(W.$$.fragment),ft=n(),f(de.$$.fragment),ut=n(),L=l("div"),f(ce.$$.fragment),Lt=n(),Le=l("p"),Le.textContent=po,$t=n(),$e=l("p"),$e.innerHTML=fo,Ct=n(),Ce=l("div"),f(me.$$.fragment),wt=n(),N=l("div"),f(pe.$$.fragment),Mt=n(),we=l("p"),we.innerHTML=uo,zt=n(),j=l("div"),f(fe.$$.fragment),qt=n(),Me=l("p"),Me.textContent=ho,jt=n(),f(R.$$.fragment),It=n(),ze=l("p"),ze.textContent=_o,Ut=n(),Z=l("div"),f(ue.$$.fragment),Ft=n(),qe=l("p"),qe.textContent=go,ht=n(),f(he.$$.fragment),_t=n(),p=l("div"),f(_e.$$.fragment),Jt=n(),je=l("p"),je.textContent=ko,Et=n(),Ie=l("p"),Ie.textContent=bo,Pt=n(),f(B.$$.fragment),Ht=n(),Ue=l("p"),Ue.innerHTML=vo,Wt=n(),Fe=l("p"),Fe.innerHTML=yo,Nt=n(),M=l("div"),f(ge.$$.fragment),Rt=n(),Je=l("p"),Je.textContent=To,Zt=n(),Ee=l("p"),Ee.innerHTML=xo,Bt=n(),Pe=l("ul"),Pe.innerHTML=Lo,At=n(),He=l("p"),He.textContent=$o,Dt=n(),A=l("div"),f(ke.$$.fragment),Gt=n(),We=l("p"),We.innerHTML=Co,Vt=n(),J=l("div"),f(be.$$.fragment),St=n(),Ne=l("p"),Ne.innerHTML=wo,Xt=n(),Re=l("p"),Re.textContent=Mo,Qt=n(),D=l("div"),f(ve.$$.fragment),Yt=n(),Ze=l("p"),Ze.innerHTML=zo,Ot=n(),Be=l("div"),f(ye.$$.fragment),gt=n(),f(Te.$$.fragment),kt=n(),De=l("p"),this.h()},l(e){const t=Po("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(o),$=s(e),m=i(e,"P",{}),z(m).forEach(o),b=s(e),u(w.$$.fragment,e),v=s(e),u(x.$$.fragment,e),G=s(e),T=i(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-1s05gbs"&&(T.innerHTML=P),Xe=s(e),V=i(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-vfdo9a"&&(V.textContent=Kt),Qe=s(e),S=i(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-mbr49z"&&(S.innerHTML=eo),Ye=s(e),X=i(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-6hejhf"&&(X.innerHTML=to),Oe=s(e),Q=i(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-z5ta87"&&(Q.innerHTML=oo),Ke=s(e),u(Y.$$.fragment,e),et=s(e),u(H.$$.fragment,e),tt=s(e),O=i(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-axv494"&&(O.textContent=no),ot=s(e),K=i(e,"UL",{"data-svelte-h":!0}),c(K)!=="svelte-qxctvz"&&(K.innerHTML=so),nt=s(e),ee=i(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1fo4g0o"&&(ee.textContent=ao),st=s(e),u(te.$$.fragment,e),at=s(e),oe=i(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-1ovdf29"&&(oe.textContent=ro),rt=s(e),ne=i(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-b5pwv6"&&(ne.textContent=lo),lt=s(e),u(se.$$.fragment,e),it=s(e),ae=i(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-cm0lfz"&&(ae.textContent=io),dt=s(e),u(re.$$.fragment,e),ct=s(e),le=i(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-xefpq6"&&(le.innerHTML=co),mt=s(e),ie=i(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-qunt86"&&(ie.innerHTML=mo),pt=s(e),u(W.$$.fragment,e),ft=s(e),u(de.$$.fragment,e),ut=s(e),L=i(e,"DIV",{class:!0});var C=z(L);u(ce.$$.fragment,C),Lt=s(C),Le=i(C,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-1vmwvh5"&&(Le.textContent=po),$t=s(C),$e=i(C,"P",{"data-svelte-h":!0}),c($e)!=="svelte-1a4a72p"&&($e.innerHTML=fo),Ct=s(C),Ce=i(C,"DIV",{class:!0});var Ge=z(Ce);u(me.$$.fragment,Ge),Ge.forEach(o),wt=s(C),N=i(C,"DIV",{class:!0});var xe=z(N);u(pe.$$.fragment,xe),Mt=s(xe),we=i(xe,"P",{"data-svelte-h":!0}),c(we)!=="svelte-1f4f5kp"&&(we.innerHTML=uo),xe.forEach(o),zt=s(C),j=i(C,"DIV",{class:!0});var I=z(j);u(fe.$$.fragment,I),qt=s(I),Me=i(I,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-13bfd60"&&(Me.textContent=ho),jt=s(I),u(R.$$.fragment,I),It=s(I),ze=i(I,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-wtrslu"&&(ze.textContent=_o),I.forEach(o),Ut=s(C),Z=i(C,"DIV",{class:!0});var vt=z(Z);u(ue.$$.fragment,vt),Ft=s(vt),qe=i(vt,"P",{"data-svelte-h":!0}),c(qe)!=="svelte-1slb66l"&&(qe.textContent=go),vt.forEach(o),C.forEach(o),ht=s(e),u(he.$$.fragment,e),_t=s(e),p=i(e,"DIV",{class:!0});var y=z(p);u(_e.$$.fragment,y),Jt=s(y),je=i(y,"P",{"data-svelte-h":!0}),c(je)!=="svelte-15tdcz8"&&(je.textContent=ko),Et=s(y),Ie=i(y,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-llhmpa"&&(Ie.textContent=bo),Pt=s(y),u(B.$$.fragment,y),Ht=s(y),Ue=i(y,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-cnb6q1"&&(Ue.innerHTML=vo),Wt=s(y),Fe=i(y,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-1cdizjq"&&(Fe.innerHTML=yo),Nt=s(y),M=i(y,"DIV",{class:!0});var E=z(M);u(ge.$$.fragment,E),Rt=s(E),Je=i(E,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-1vll0v2"&&(Je.textContent=To),Zt=s(E),Ee=i(E,"P",{"data-svelte-h":!0}),c(Ee)!=="svelte-90np8u"&&(Ee.innerHTML=xo),Bt=s(E),Pe=i(E,"UL",{"data-svelte-h":!0}),c(Pe)!=="svelte-mlrsks"&&(Pe.innerHTML=Lo),At=s(E),He=i(E,"P",{"data-svelte-h":!0}),c(He)!=="svelte-46aam0"&&(He.textContent=$o),E.forEach(o),Dt=s(y),A=i(y,"DIV",{class:!0});var yt=z(A);u(ke.$$.fragment,yt),Gt=s(yt),We=i(yt,"P",{"data-svelte-h":!0}),c(We)!=="svelte-1wmjg8a"&&(We.innerHTML=Co),yt.forEach(o),Vt=s(y),J=i(y,"DIV",{class:!0});var Ae=z(J);u(be.$$.fragment,Ae),St=s(Ae),Ne=i(Ae,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-zj1vf1"&&(Ne.innerHTML=wo),Xt=s(Ae),Re=i(Ae,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-9vptpw"&&(Re.textContent=Mo),Ae.forEach(o),Qt=s(y),D=i(y,"DIV",{class:!0});var Tt=z(D);u(ve.$$.fragment,Tt),Yt=s(Tt),Ze=i(Tt,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-nfci2w"&&(Ze.innerHTML=zo),Tt.forEach(o),Ot=s(y),Be=i(y,"DIV",{class:!0});var qo=z(Be);u(ye.$$.fragment,qo),qo.forEach(o),y.forEach(o),gt=s(e),u(Te.$$.fragment,e),kt=s(e),De=i(e,"P",{}),z(De).forEach(o),this.h()},h(){q(d,"name","hf:doc:metadata"),q(d,"content",Ao),q(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,d),r(e,$,t),r(e,m,t),r(e,b,t),h(w,e,t),r(e,v,t),h(x,e,t),r(e,G,t),r(e,T,t),r(e,Xe,t),r(e,V,t),r(e,Qe,t),r(e,S,t),r(e,Ye,t),r(e,X,t),r(e,Oe,t),r(e,Q,t),r(e,Ke,t),h(Y,e,t),r(e,et,t),h(H,e,t),r(e,tt,t),r(e,O,t),r(e,ot,t),r(e,K,t),r(e,nt,t),r(e,ee,t),r(e,st,t),h(te,e,t),r(e,at,t),r(e,oe,t),r(e,rt,t),r(e,ne,t),r(e,lt,t),h(se,e,t),r(e,it,t),r(e,ae,t),r(e,dt,t),h(re,e,t),r(e,ct,t),r(e,le,t),r(e,mt,t),r(e,ie,t),r(e,pt,t),h(W,e,t),r(e,ft,t),h(de,e,t),r(e,ut,t),r(e,L,t),h(ce,L,null),a(L,Lt),a(L,Le),a(L,$t),a(L,$e),a(L,Ct),a(L,Ce),h(me,Ce,null),a(L,wt),a(L,N),h(pe,N,null),a(N,Mt),a(N,we),a(L,zt),a(L,j),h(fe,j,null),a(j,qt),a(j,Me),a(j,jt),h(R,j,null),a(j,It),a(j,ze),a(L,Ut),a(L,Z),h(ue,Z,null),a(Z,Ft),a(Z,qe),r(e,ht,t),h(he,e,t),r(e,_t,t),r(e,p,t),h(_e,p,null),a(p,Jt),a(p,je),a(p,Et),a(p,Ie),a(p,Pt),h(B,p,null),a(p,Ht),a(p,Ue),a(p,Wt),a(p,Fe),a(p,Nt),a(p,M),h(ge,M,null),a(M,Rt),a(M,Je),a(M,Zt),a(M,Ee),a(M,Bt),a(M,Pe),a(M,At),a(M,He),a(p,Dt),a(p,A),h(ke,A,null),a(A,Gt),a(A,We),a(p,Vt),a(p,J),h(be,J,null),a(J,St),a(J,Ne),a(J,Xt),a(J,Re),a(p,Qt),a(p,D),h(ve,D,null),a(D,Yt),a(D,Ze),a(p,Ot),a(p,Be),h(ye,Be,null),r(e,gt,t),h(Te,e,t),r(e,kt,t),r(e,De,t),bt=!0},p(e,[t]){const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),H.$set(C);const Ge={};t&2&&(Ge.$$scope={dirty:t,ctx:e}),W.$set(Ge);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:e}),R.$set(xe);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),B.$set(I)},i(e){bt||(_(w.$$.fragment,e),_(x.$$.fragment,e),_(Y.$$.fragment,e),_(H.$$.fragment,e),_(te.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(W.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(fe.$$.fragment,e),_(R.$$.fragment,e),_(ue.$$.fragment,e),_(he.$$.fragment,e),_(_e.$$.fragment,e),_(B.$$.fragment,e),_(ge.$$.fragment,e),_(ke.$$.fragment,e),_(be.$$.fragment,e),_(ve.$$.fragment,e),_(ye.$$.fragment,e),_(Te.$$.fragment,e),bt=!0)},o(e){g(w.$$.fragment,e),g(x.$$.fragment,e),g(Y.$$.fragment,e),g(H.$$.fragment,e),g(te.$$.fragment,e),g(se.$$.fragment,e),g(re.$$.fragment,e),g(W.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(fe.$$.fragment,e),g(R.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(_e.$$.fragment,e),g(B.$$.fragment,e),g(ge.$$.fragment,e),g(ke.$$.fragment,e),g(be.$$.fragment,e),g(ve.$$.fragment,e),g(ye.$$.fragment,e),g(Te.$$.fragment,e),bt=!1},d(e){e&&(o($),o(m),o(b),o(v),o(G),o(T),o(Xe),o(V),o(Qe),o(S),o(Ye),o(X),o(Oe),o(Q),o(Ke),o(et),o(tt),o(O),o(ot),o(K),o(nt),o(ee),o(st),o(at),o(oe),o(rt),o(ne),o(lt),o(it),o(ae),o(dt),o(ct),o(le),o(mt),o(ie),o(pt),o(ft),o(ut),o(L),o(ht),o(_t),o(p),o(gt),o(kt),o(De)),o(d),k(w,e),k(x,e),k(Y,e),k(H,e),k(te,e),k(se,e),k(re,e),k(W,e),k(de,e),k(ce),k(me),k(pe),k(fe),k(R),k(ue),k(he,e),k(_e),k(B),k(ge),k(ke),k(be),k(ve),k(ye),k(Te,e)}}}const Ao='{"title":"CodeLlama","local":"codellama","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips and examples","local":"usage-tips-and-examples","sections":[],"depth":2},{"title":"CodeLlamaTokenizer","local":"transformers.CodeLlamaTokenizer","sections":[],"depth":2},{"title":"CodeLlamaTokenizerFast","local":"transformers.CodeLlamaTokenizerFast","sections":[],"depth":2}],"depth":1}';function Do(F){return Fo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ko extends Jo{constructor(d){super(),Eo(this,d,Do,Bo,Uo,{})}}export{Ko as component};
