import{s as pt,o as ht,n as Ze}from"../chunks/scheduler.25b97de1.js";import{S as mt,i as ut,g as c,s as a,r as p,A as ft,h as l,f as n,c as r,j as I,u as h,x as _,k as P,y as s,a as d,v as m,d as u,t as f,w as g}from"../chunks/index.d9030fc9.js";import{T as po}from"../chunks/Tip.baa67368.js";import{D as Z}from"../chunks/Docstring.ffac8efa.js";import{C as Uo}from"../chunks/CodeBlock.e6cd0d95.js";import{E as lt}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as B,E as gt}from"../chunks/EditOnGithub.91d95064.js";function _t(M){let t,b;return t=new Uo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN0YXJjb2RlcjJNb2RlbCUyQyUyMFN0YXJjb2RlcjJDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3RhcmNvZGVyMiUyMDdCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFN0YXJjb2RlcjJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBTdGFyY29kZXIyJTIwN0IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFN0YXJjb2RlcjJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Starcoder2Model, Starcoder2Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Starcoder2 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Starcoder2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Starcoder2 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Starcoder2Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){p(t.$$.fragment)},l(i){h(t.$$.fragment,i)},m(i,y){m(t,i,y),b=!0},p:Ze,i(i){b||(u(t.$$.fragment,i),b=!0)},o(i){f(t.$$.fragment,i),b=!1},d(i){g(t,i)}}}function bt(M){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=b},l(i){t=l(i,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(i,y){d(i,t,y)},p:Ze,d(i){i&&n(t)}}}function yt(M){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=b},l(i){t=l(i,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(i,y){d(i,t,y)},p:Ze,d(i){i&&n(t)}}}function vt(M){let t,b="Example:",i,y,x;return y=new Uo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTdGFyY29kZXIyRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMFN0YXJjb2RlcjJGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRnN0YXJjb2RlcjItN2IlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRnN0YXJjb2RlcjItN2IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySGV5JTJDJTIwYXJlJTIweW91JTIwY29uc2Npb3VzJTNGJTIwQ2FuJTIweW91JTIwdGFsayUyMHRvJTIwbWUlM0YlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cy5pbnB1dF9pZHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Starcoder2ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Starcoder2ForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=b,i=a(),p(y.$$.fragment)},l(v){t=l(v,"P",{"data-svelte-h":!0}),_(t)!=="svelte-11lpom8"&&(t.textContent=b),i=r(v),h(y.$$.fragment,v)},m(v,L){d(v,t,L),d(v,i,L),m(y,v,L),x=!0},p:Ze,i(v){x||(u(y.$$.fragment,v),x=!0)},o(v){f(y.$$.fragment,v),x=!1},d(v){v&&(n(t),n(i)),g(y,v)}}}function kt(M){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=b},l(i){t=l(i,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(i,y){d(i,t,y)},p:Ze,d(i){i&&n(t)}}}function Tt(M){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=b},l(i){t=l(i,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(i,y){d(i,t,y)},p:Ze,d(i){i&&n(t)}}}function wt(M){let t,b,i,y,x,v,L,Re,D,Zo='StarCoder2 is a family of open LLMs for code and comes in 3 different sizes with 3B, 7B and 15B parameters. The flagship StarCoder2-15B model is trained on over 4 trillion tokens and 600+ programming languages from The Stack v2. All models use Grouped Query Attention, a context window of 16,384 tokens with a sliding window attention of 4,096 tokens, and were trained using the Fill-in-the-Middle objective. The models have been released with the paper <a href="https://arxiv.org/abs/2402.19173" rel="nofollow">StarCoder 2 and The Stack v2: The Next Generation</a> by Anton Lozhkov, Raymond Li, Loubna Ben Allal, Federico Cassano, Joel Lamy-Poirier, Nouamane Tazi, Ao Tang, Dmytro Pykhtar, Jiawei Liu, Yuxiang Wei, Tianyang Liu, Max Tian, Denis Kocetkov, Arthur Zucker, Younes Belkada, Zijian Wang, Qian Liu, Dmitry Abulkhanov, Indraneil Paul, Zhuang Li, Wen-Ding Li, Megan Risdal, Jia Li, Jian Zhu, Terry Yue Zhuo, Evgenii Zheltonozhskii, Nii Osae Osae Dade, Wenhao Yu, Lucas Krauß, Naman Jain, Yixuan Su, Xuanli He, Manan Dey, Edoardo Abati, Yekun Chai, Niklas Muennighoff, Xiangru Tang, Muhtasham Oblokulov, Christopher Akiki, Marc Marone, Chenghao Mou, Mayank Mishra, Alex Gu, Binyuan Hui, Tri Dao, Armel Zebaze, Olivier Dehaene, Nicolas Patry, Canwen Xu, Julian McAuley, Han Hu, Torsten Scholak, Sebastien Paquet, Jennifer Robinson, Carolyn Jane Anderson, Nicolas Chapados, Mostofa Patwary, Nima Tajbakhsh, Yacine Jernite, Carlos Muñoz Ferrandis, Lingming Zhang, Sean Hughes, Thomas Wolf, Arjun Guha, Leandro von Werra, and Harm de Vries.',Oe,Y,Bo="The abstract of the paper is the following:",Ee,R,ke,Ro="The BigCode project, an open-scientific collaboration focused on the responsible development of Large Language Models for Code (Code LLMs), introduces StarCoder2. In partnership with Software Heritage (SWH), we build The Stack v2 on top of the digital commons of their source code archive. Alongside the SWH repositories spanning 619 programming languages, we carefully select other high-quality data sources, such as GitHub pull requests, Kaggle notebooks, and code documentation. This results in a training set that is 4x larger than the first StarCoder dataset. We train StarCoder2 models with 3B, 7B, and 15B parameters on 3.3 to 4.3 trillion tokens and thoroughly evaluate them on a comprehensive set of Code LLM benchmarks. We find that our small model, StarCoder2-3B, outperforms other Code LLMs of similar size on most benchmarks, and also outperforms StarCoderBase-15B. Our large model, StarCoder2- 15B, significantly outperforms other models of comparable size. In addition, it matches or outperforms CodeLlama-34B, a model more than twice its size. Although DeepSeekCoder- 33B is the best-performing model at code completion for high-resource languages, we find that StarCoder2-15B outperforms it on math and code reasoning benchmarks, as well as several low-resource languages. We make the model weights available under an OpenRAIL license and ensure full transparency regarding the training data by releasing the SoftWare Heritage persistent IDentifiers (SWHIDs) of the source code data.",ho,Q,Ge,K,Oo='The models are licensed under the <a href="https://huggingface.co/spaces/bigcode/bigcode-model-license-agreement" rel="nofollow">BigCode OpenRAIL-M v1 license agreement</a>.',Ae,ee,Xe,oe,Eo='The StarCoder2 models can be found in the <a href="https://huggingface.co/collections/bigcode/starcoder2-65de6da6e87db3383572be1a" rel="nofollow">HuggingFace hub</a>. You can find some examples for inference and fine-tuning in StarCoder2’s <a href="https://github.com/bigcode-project/starcoder2" rel="nofollow">GitHub repo</a>.',Ve,te,Go="These ready-to-use checkpoints can be downloaded and used via the HuggingFace Hub:",De,ne,Ye,ae,Qe,S,re,mo,Te,Ao=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30803/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a>. It is used to instantiate a
Starcoder2 model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/bigcode/starcoder2-7b" rel="nofollow">bigcode/starcoder2-7b</a> model.`,uo,we,Xo=`Configuration objects inherit from <a href="/docs/transformers/pr_30803/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30803/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,fo,O,Ke,se,eo,T,ie,go,Me,Vo=`The bare Starcoder2 Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,_o,$e,Do=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,bo,Se,Yo="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>Starcoder2DecoderLayer</code>",yo,j,de,vo,Ce,Qo='The <a href="/docs/transformers/pr_30803/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a> forward method, overrides the <code>__call__</code> special method.',ko,E,oo,ce,to,H,le,To,z,pe,wo,xe,Ko='The <a href="/docs/transformers/pr_30803/en/model_doc/starcoder2#transformers.Starcoder2ForCausalLM">Starcoder2ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Mo,G,$o,A,no,he,ao,k,me,So,ze,et="The Starcoder2 Model transformer with a sequence classification head on top (linear layer).",Co,Ie,ot=`<a href="/docs/transformers/pr_30803/en/model_doc/starcoder2#transformers.Starcoder2ForSequenceClassification">Starcoder2ForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,xo,Le,tt=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,zo,qe,nt=`This model inherits from <a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Io,Fe,at=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Lo,J,ue,qo,Pe,rt='The <a href="/docs/transformers/pr_30803/en/model_doc/starcoder2#transformers.Starcoder2ForSequenceClassification">Starcoder2ForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Fo,X,ro,fe,so,w,ge,Po,je,st=`The Starcoder2 Model transformer with a token classification head on top (a linear layer on top of the hidden-states
output) e.g. for Named-Entity-Recognition (NER) tasks.`,jo,Je,it=`This model inherits from <a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Jo,Ne,dt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,No,N,_e,Wo,We,ct='The <a href="/docs/transformers/pr_30803/en/model_doc/starcoder2#transformers.Starcoder2ForTokenClassification">Starcoder2ForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',Ho,V,io,be,co,Be,lo;return x=new B({props:{title:"Starcoder2",local:"starcoder2",headingTag:"h1"}}),L=new B({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Q=new B({props:{title:"License",local:"license",headingTag:"h2"}}),ee=new B({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ne=new Uo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ2NvZGUlMkZzdGFyY29kZXIyLTdiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRnN0YXJjb2RlcjItN2IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZGVmJTIwcHJpbnRfaGVsbG9fd29ybGQoKSUzQSUyMiUwQSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUJwcm9tcHQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;def print_hello_world():&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">10</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;def print_hello_world():\\n    print(&quot;Hello World!&quot;)\\n\\ndef print&#x27;</span>`,wrap:!1}}),ae=new B({props:{title:"Starcoder2Config",local:"transformers.Starcoder2Config",headingTag:"h2"}}),re=new Z({props:{name:"class transformers.Starcoder2Config",anchor:"transformers.Starcoder2Config",parameters:[{name:"vocab_size",val:" = 49152"},{name:"hidden_size",val:" = 3072"},{name:"intermediate_size",val:" = 12288"},{name:"num_hidden_layers",val:" = 30"},{name:"num_attention_heads",val:" = 24"},{name:"num_key_value_heads",val:" = 2"},{name:"hidden_act",val:" = 'gelu_pytorch_tanh'"},{name:"max_position_embeddings",val:" = 4096"},{name:"initializer_range",val:" = 0.018042"},{name:"norm_epsilon",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"bos_token_id",val:" = 50256"},{name:"eos_token_id",val:" = 50256"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"sliding_window",val:" = None"},{name:"attention_dropout",val:" = 0.0"},{name:"residual_dropout",val:" = 0.0"},{name:"embedding_dropout",val:" = 0.0"},{name:"use_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Starcoder2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49152) &#x2014;
Vocabulary size of the Starcoder2 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30803/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a>`,name:"vocab_size"},{anchor:"transformers.Starcoder2Config.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.Starcoder2Config.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 12288) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.Starcoder2Config.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 30) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Starcoder2Config.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Starcoder2Config.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to <code>8</code>.`,name:"num_key_value_heads"},{anchor:"transformers.Starcoder2Config.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_pytorch_tanh&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.Starcoder2Config.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model might ever be used with. Starcoder2&#x2019;s sliding window attention
allows sequence of up to 4096*32 tokens.`,name:"max_position_embeddings"},{anchor:"transformers.Starcoder2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Starcoder2Config.norm_epsilon",description:`<strong>norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
Epsilon value for the layer norm`,name:"norm_epsilon"},{anchor:"transformers.Starcoder2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.Starcoder2Config.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 50256) &#x2014;
The id of the &#x201C;beginning-of-sequence&#x201D; token.`,name:"bos_token_id"},{anchor:"transformers.Starcoder2Config.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 50256) &#x2014;
The id of the &#x201C;end-of-sequence&#x201D; token.`,name:"eos_token_id"},{anchor:"transformers.Starcoder2Config.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.Starcoder2Config.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"},{anchor:"transformers.Starcoder2Config.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Sliding window attention window size. If not specified, will default to <code>None</code> (no sliding window).`,name:"sliding_window"},{anchor:"transformers.Starcoder2Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Starcoder2Config.residual_dropout",description:`<strong>residual_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Residual connection dropout value.`,name:"residual_dropout"},{anchor:"transformers.Starcoder2Config.embedding_dropout",description:`<strong>embedding_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Embedding dropout.`,name:"embedding_dropout"},{anchor:"transformers.Starcoder2Config.use_bias",description:`<strong>use_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias term on linear layers of the model.`,name:"use_bias"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/starcoder2/configuration_starcoder2.py#L25"}}),O=new lt({props:{anchor:"transformers.Starcoder2Config.example",$$slots:{default:[_t]},$$scope:{ctx:M}}}),se=new B({props:{title:"Starcoder2Model",local:"transformers.Starcoder2Model",headingTag:"h2"}}),ie=new Z({props:{name:"class transformers.Starcoder2Model",anchor:"transformers.Starcoder2Model",parameters:[{name:"config",val:": Starcoder2Config"}],parametersDescription:[{anchor:"transformers.Starcoder2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30803/en/model_doc/starcoder2#transformers.Starcoder2Config">Starcoder2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; Starcoder2Config`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/starcoder2/modeling_starcoder2.py#L769"}}),de=new Z({props:{name:"forward",anchor:"transformers.Starcoder2Model.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Starcoder2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2Model.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30803/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Starcoder2Model.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/starcoder2/modeling_starcoder2.py#L804"}}),E=new po({props:{$$slots:{default:[bt]},$$scope:{ctx:M}}}),ce=new B({props:{title:"Starcoder2ForCausalLM",local:"transformers.Starcoder2ForCausalLM",headingTag:"h2"}}),le=new Z({props:{name:"class transformers.Starcoder2ForCausalLM",anchor:"transformers.Starcoder2ForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/starcoder2/modeling_starcoder2.py#L1077"}}),pe=new Z({props:{name:"forward",anchor:"transformers.Starcoder2ForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"},{name:"num_logits_to_keep",val:": int = 0"}],parametersDescription:[{anchor:"transformers.Starcoder2ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2ForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30803/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Starcoder2ForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>num_logits_to_keep (<code>int</code>, <em>optional</em>):
Calculate logits for the last <code>num_logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/starcoder2/modeling_starcoder2.py#L1107",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30803/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30803/en/model_doc/starcoder2#transformers.Starcoder2Config"
>Starcoder2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30803/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),G=new po({props:{$$slots:{default:[yt]},$$scope:{ctx:M}}}),A=new lt({props:{anchor:"transformers.Starcoder2ForCausalLM.forward.example",$$slots:{default:[vt]},$$scope:{ctx:M}}}),he=new B({props:{title:"Starcoder2ForSequenceClassification",local:"transformers.Starcoder2ForSequenceClassification",headingTag:"h2"}}),me=new Z({props:{name:"class transformers.Starcoder2ForSequenceClassification",anchor:"transformers.Starcoder2ForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Starcoder2ForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30803/en/model_doc/starcoder2#transformers.Starcoder2Config">Starcoder2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/starcoder2/modeling_starcoder2.py#L1281"}}),ue=new Z({props:{name:"forward",anchor:"transformers.Starcoder2ForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Union = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Starcoder2ForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30803/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/starcoder2/modeling_starcoder2.py#L1313"}}),X=new po({props:{$$slots:{default:[kt]},$$scope:{ctx:M}}}),fe=new B({props:{title:"Starcoder2ForTokenClassification",local:"transformers.Starcoder2ForTokenClassification",headingTag:"h2"}}),ge=new Z({props:{name:"class transformers.Starcoder2ForTokenClassification",anchor:"transformers.Starcoder2ForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Starcoder2ForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30803/en/model_doc/starcoder2#transformers.Starcoder2Config">Starcoder2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/starcoder2/modeling_starcoder2.py#L1405"}}),_e=new Z({props:{name:"forward",anchor:"transformers.Starcoder2ForTokenClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Starcoder2ForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30803/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/starcoder2/modeling_starcoder2.py#L1436"}}),V=new po({props:{$$slots:{default:[Tt]},$$scope:{ctx:M}}}),be=new gt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/starcoder2.md"}}),{c(){t=c("meta"),b=a(),i=c("p"),y=a(),p(x.$$.fragment),v=a(),p(L.$$.fragment),Re=a(),D=c("p"),D.innerHTML=Zo,Oe=a(),Y=c("p"),Y.textContent=Bo,Ee=a(),R=c("blockquote"),ke=c("p"),ke.textContent=Ro,ho=a(),p(Q.$$.fragment),Ge=a(),K=c("p"),K.innerHTML=Oo,Ae=a(),p(ee.$$.fragment),Xe=a(),oe=c("p"),oe.innerHTML=Eo,Ve=a(),te=c("p"),te.textContent=Go,De=a(),p(ne.$$.fragment),Ye=a(),p(ae.$$.fragment),Qe=a(),S=c("div"),p(re.$$.fragment),mo=a(),Te=c("p"),Te.innerHTML=Ao,uo=a(),we=c("p"),we.innerHTML=Xo,fo=a(),p(O.$$.fragment),Ke=a(),p(se.$$.fragment),eo=a(),T=c("div"),p(ie.$$.fragment),go=a(),Me=c("p"),Me.innerHTML=Vo,_o=a(),$e=c("p"),$e.innerHTML=Do,bo=a(),Se=c("p"),Se.innerHTML=Yo,yo=a(),j=c("div"),p(de.$$.fragment),vo=a(),Ce=c("p"),Ce.innerHTML=Qo,ko=a(),p(E.$$.fragment),oo=a(),p(ce.$$.fragment),to=a(),H=c("div"),p(le.$$.fragment),To=a(),z=c("div"),p(pe.$$.fragment),wo=a(),xe=c("p"),xe.innerHTML=Ko,Mo=a(),p(G.$$.fragment),$o=a(),p(A.$$.fragment),no=a(),p(he.$$.fragment),ao=a(),k=c("div"),p(me.$$.fragment),So=a(),ze=c("p"),ze.textContent=et,Co=a(),Ie=c("p"),Ie.innerHTML=ot,xo=a(),Le=c("p"),Le.innerHTML=tt,zo=a(),qe=c("p"),qe.innerHTML=nt,Io=a(),Fe=c("p"),Fe.innerHTML=at,Lo=a(),J=c("div"),p(ue.$$.fragment),qo=a(),Pe=c("p"),Pe.innerHTML=rt,Fo=a(),p(X.$$.fragment),ro=a(),p(fe.$$.fragment),so=a(),w=c("div"),p(ge.$$.fragment),Po=a(),je=c("p"),je.textContent=st,jo=a(),Je=c("p"),Je.innerHTML=it,Jo=a(),Ne=c("p"),Ne.innerHTML=dt,No=a(),N=c("div"),p(_e.$$.fragment),Wo=a(),We=c("p"),We.innerHTML=ct,Ho=a(),p(V.$$.fragment),io=a(),p(be.$$.fragment),co=a(),Be=c("p"),this.h()},l(e){const o=ft("svelte-u9bgzb",document.head);t=l(o,"META",{name:!0,content:!0}),o.forEach(n),b=r(e),i=l(e,"P",{}),I(i).forEach(n),y=r(e),h(x.$$.fragment,e),v=r(e),h(L.$$.fragment,e),Re=r(e),D=l(e,"P",{"data-svelte-h":!0}),_(D)!=="svelte-1n8n0dk"&&(D.innerHTML=Zo),Oe=r(e),Y=l(e,"P",{"data-svelte-h":!0}),_(Y)!=="svelte-wu27l3"&&(Y.textContent=Bo),Ee=r(e),R=l(e,"BLOCKQUOTE",{});var ye=I(R);ke=l(ye,"P",{"data-svelte-h":!0}),_(ke)!=="svelte-1cdgnq1"&&(ke.textContent=Ro),ho=r(ye),h(Q.$$.fragment,ye),ye.forEach(n),Ge=r(e),K=l(e,"P",{"data-svelte-h":!0}),_(K)!=="svelte-1289i3b"&&(K.innerHTML=Oo),Ae=r(e),h(ee.$$.fragment,e),Xe=r(e),oe=l(e,"P",{"data-svelte-h":!0}),_(oe)!=="svelte-1gol27n"&&(oe.innerHTML=Eo),Ve=r(e),te=l(e,"P",{"data-svelte-h":!0}),_(te)!=="svelte-a5tlwb"&&(te.textContent=Go),De=r(e),h(ne.$$.fragment,e),Ye=r(e),h(ae.$$.fragment,e),Qe=r(e),S=l(e,"DIV",{class:!0});var q=I(S);h(re.$$.fragment,q),mo=r(q),Te=l(q,"P",{"data-svelte-h":!0}),_(Te)!=="svelte-1ape0qz"&&(Te.innerHTML=Ao),uo=r(q),we=l(q,"P",{"data-svelte-h":!0}),_(we)!=="svelte-ur2kjj"&&(we.innerHTML=Xo),fo=r(q),h(O.$$.fragment,q),q.forEach(n),Ke=r(e),h(se.$$.fragment,e),eo=r(e),T=l(e,"DIV",{class:!0});var C=I(T);h(ie.$$.fragment,C),go=r(C),Me=l(C,"P",{"data-svelte-h":!0}),_(Me)!=="svelte-1w3ngtb"&&(Me.innerHTML=Vo),_o=r(C),$e=l(C,"P",{"data-svelte-h":!0}),_($e)!=="svelte-hswkmf"&&($e.innerHTML=Do),bo=r(C),Se=l(C,"P",{"data-svelte-h":!0}),_(Se)!=="svelte-1inq57c"&&(Se.innerHTML=Yo),yo=r(C),j=l(C,"DIV",{class:!0});var U=I(j);h(de.$$.fragment,U),vo=r(U),Ce=l(U,"P",{"data-svelte-h":!0}),_(Ce)!=="svelte-n0vsqo"&&(Ce.innerHTML=Qo),ko=r(U),h(E.$$.fragment,U),U.forEach(n),C.forEach(n),oo=r(e),h(ce.$$.fragment,e),to=r(e),H=l(e,"DIV",{class:!0});var ve=I(H);h(le.$$.fragment,ve),To=r(ve),z=l(ve,"DIV",{class:!0});var F=I(z);h(pe.$$.fragment,F),wo=r(F),xe=l(F,"P",{"data-svelte-h":!0}),_(xe)!=="svelte-nko3sg"&&(xe.innerHTML=Ko),Mo=r(F),h(G.$$.fragment,F),$o=r(F),h(A.$$.fragment,F),F.forEach(n),ve.forEach(n),no=r(e),h(he.$$.fragment,e),ao=r(e),k=l(e,"DIV",{class:!0});var $=I(k);h(me.$$.fragment,$),So=r($),ze=l($,"P",{"data-svelte-h":!0}),_(ze)!=="svelte-pjsk7t"&&(ze.textContent=et),Co=r($),Ie=l($,"P",{"data-svelte-h":!0}),_(Ie)!=="svelte-1kksd4p"&&(Ie.innerHTML=ot),xo=r($),Le=l($,"P",{"data-svelte-h":!0}),_(Le)!=="svelte-10ugs3m"&&(Le.innerHTML=tt),zo=r($),qe=l($,"P",{"data-svelte-h":!0}),_(qe)!=="svelte-jmt3ug"&&(qe.innerHTML=nt),Io=r($),Fe=l($,"P",{"data-svelte-h":!0}),_(Fe)!=="svelte-hswkmf"&&(Fe.innerHTML=at),Lo=r($),J=l($,"DIV",{class:!0});var He=I(J);h(ue.$$.fragment,He),qo=r(He),Pe=l(He,"P",{"data-svelte-h":!0}),_(Pe)!=="svelte-3b7wj8"&&(Pe.innerHTML=rt),Fo=r(He),h(X.$$.fragment,He),He.forEach(n),$.forEach(n),ro=r(e),h(fe.$$.fragment,e),so=r(e),w=l(e,"DIV",{class:!0});var W=I(w);h(ge.$$.fragment,W),Po=r(W),je=l(W,"P",{"data-svelte-h":!0}),_(je)!=="svelte-cif3t8"&&(je.textContent=st),jo=r(W),Je=l(W,"P",{"data-svelte-h":!0}),_(Je)!=="svelte-jmt3ug"&&(Je.innerHTML=it),Jo=r(W),Ne=l(W,"P",{"data-svelte-h":!0}),_(Ne)!=="svelte-hswkmf"&&(Ne.innerHTML=dt),No=r(W),N=l(W,"DIV",{class:!0});var Ue=I(N);h(_e.$$.fragment,Ue),Wo=r(Ue),We=l(Ue,"P",{"data-svelte-h":!0}),_(We)!=="svelte-pv3wvm"&&(We.innerHTML=ct),Ho=r(Ue),h(V.$$.fragment,Ue),Ue.forEach(n),W.forEach(n),io=r(e),h(be.$$.fragment,e),co=r(e),Be=l(e,"P",{}),I(Be).forEach(n),this.h()},h(){P(t,"name","hf:doc:metadata"),P(t,"content",Mt),P(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){s(document.head,t),d(e,b,o),d(e,i,o),d(e,y,o),m(x,e,o),d(e,v,o),m(L,e,o),d(e,Re,o),d(e,D,o),d(e,Oe,o),d(e,Y,o),d(e,Ee,o),d(e,R,o),s(R,ke),s(R,ho),m(Q,R,null),d(e,Ge,o),d(e,K,o),d(e,Ae,o),m(ee,e,o),d(e,Xe,o),d(e,oe,o),d(e,Ve,o),d(e,te,o),d(e,De,o),m(ne,e,o),d(e,Ye,o),m(ae,e,o),d(e,Qe,o),d(e,S,o),m(re,S,null),s(S,mo),s(S,Te),s(S,uo),s(S,we),s(S,fo),m(O,S,null),d(e,Ke,o),m(se,e,o),d(e,eo,o),d(e,T,o),m(ie,T,null),s(T,go),s(T,Me),s(T,_o),s(T,$e),s(T,bo),s(T,Se),s(T,yo),s(T,j),m(de,j,null),s(j,vo),s(j,Ce),s(j,ko),m(E,j,null),d(e,oo,o),m(ce,e,o),d(e,to,o),d(e,H,o),m(le,H,null),s(H,To),s(H,z),m(pe,z,null),s(z,wo),s(z,xe),s(z,Mo),m(G,z,null),s(z,$o),m(A,z,null),d(e,no,o),m(he,e,o),d(e,ao,o),d(e,k,o),m(me,k,null),s(k,So),s(k,ze),s(k,Co),s(k,Ie),s(k,xo),s(k,Le),s(k,zo),s(k,qe),s(k,Io),s(k,Fe),s(k,Lo),s(k,J),m(ue,J,null),s(J,qo),s(J,Pe),s(J,Fo),m(X,J,null),d(e,ro,o),m(fe,e,o),d(e,so,o),d(e,w,o),m(ge,w,null),s(w,Po),s(w,je),s(w,jo),s(w,Je),s(w,Jo),s(w,Ne),s(w,No),s(w,N),m(_e,N,null),s(N,Wo),s(N,We),s(N,Ho),m(V,N,null),d(e,io,o),m(be,e,o),d(e,co,o),d(e,Be,o),lo=!0},p(e,[o]){const ye={};o&2&&(ye.$$scope={dirty:o,ctx:e}),O.$set(ye);const q={};o&2&&(q.$$scope={dirty:o,ctx:e}),E.$set(q);const C={};o&2&&(C.$$scope={dirty:o,ctx:e}),G.$set(C);const U={};o&2&&(U.$$scope={dirty:o,ctx:e}),A.$set(U);const ve={};o&2&&(ve.$$scope={dirty:o,ctx:e}),X.$set(ve);const F={};o&2&&(F.$$scope={dirty:o,ctx:e}),V.$set(F)},i(e){lo||(u(x.$$.fragment,e),u(L.$$.fragment,e),u(Q.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(de.$$.fragment,e),u(E.$$.fragment,e),u(ce.$$.fragment,e),u(le.$$.fragment,e),u(pe.$$.fragment,e),u(G.$$.fragment,e),u(A.$$.fragment,e),u(he.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(X.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(_e.$$.fragment,e),u(V.$$.fragment,e),u(be.$$.fragment,e),lo=!0)},o(e){f(x.$$.fragment,e),f(L.$$.fragment,e),f(Q.$$.fragment,e),f(ee.$$.fragment,e),f(ne.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(O.$$.fragment,e),f(se.$$.fragment,e),f(ie.$$.fragment,e),f(de.$$.fragment,e),f(E.$$.fragment,e),f(ce.$$.fragment,e),f(le.$$.fragment,e),f(pe.$$.fragment,e),f(G.$$.fragment,e),f(A.$$.fragment,e),f(he.$$.fragment,e),f(me.$$.fragment,e),f(ue.$$.fragment,e),f(X.$$.fragment,e),f(fe.$$.fragment,e),f(ge.$$.fragment,e),f(_e.$$.fragment,e),f(V.$$.fragment,e),f(be.$$.fragment,e),lo=!1},d(e){e&&(n(b),n(i),n(y),n(v),n(Re),n(D),n(Oe),n(Y),n(Ee),n(R),n(Ge),n(K),n(Ae),n(Xe),n(oe),n(Ve),n(te),n(De),n(Ye),n(Qe),n(S),n(Ke),n(eo),n(T),n(oo),n(to),n(H),n(no),n(ao),n(k),n(ro),n(so),n(w),n(io),n(co),n(Be)),n(t),g(x,e),g(L,e),g(Q),g(ee,e),g(ne,e),g(ae,e),g(re),g(O),g(se,e),g(ie),g(de),g(E),g(ce,e),g(le),g(pe),g(G),g(A),g(he,e),g(me),g(ue),g(X),g(fe,e),g(ge),g(_e),g(V),g(be,e)}}}const Mt='{"title":"Starcoder2","local":"starcoder2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"License","local":"license","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Starcoder2Config","local":"transformers.Starcoder2Config","sections":[],"depth":2},{"title":"Starcoder2Model","local":"transformers.Starcoder2Model","sections":[],"depth":2},{"title":"Starcoder2ForCausalLM","local":"transformers.Starcoder2ForCausalLM","sections":[],"depth":2},{"title":"Starcoder2ForSequenceClassification","local":"transformers.Starcoder2ForSequenceClassification","sections":[],"depth":2},{"title":"Starcoder2ForTokenClassification","local":"transformers.Starcoder2ForTokenClassification","sections":[],"depth":2}],"depth":1}';function $t(M){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends mt{constructor(t){super(),ut(this,t,$t,wt,pt,{})}}export{Ft as component};
