import{s as Jt,o as jt,n as Ye}from"../chunks/scheduler.8c3d61f6.js";import{S as Ut,i as Zt,g as l,s as i,r as h,A as Ht,h as d,f as o,c as s,j as k,u as g,x as m,k as z,y as c,a as n,v as f,d as _,t as b,w as v}from"../chunks/index.da70eac4.js";import{T as Ct}from"../chunks/Tip.1d9b8c37.js";import{D as B}from"../chunks/Docstring.6b390b9a.js";import{C as Wt}from"../chunks/CodeBlock.00a903b3.js";import{E as It}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as ue,E as Bt}from"../chunks/EditOnGithub.1e64e623.js";function Et(D){let a,w='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines. Also, to know more about reducing the memory usage of this pipeline, refer to the [“Reduce memory usage”] section <a href="../../using-diffusers/svd#reduce-memory-usage">here</a>.';return{c(){a=l("p"),a.innerHTML=w},l(p){a=d(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-12x7hfk"&&(a.innerHTML=w)},m(p,u){n(p,a,u)},p:Ye,d(p){p&&o(a)}}}function Rt(D){let a,w=`Marigold pipelines were designed and tested only with <code>DDIMScheduler</code> and <code>LCMScheduler</code>.
Depending on the scheduler, the number of inference steps required to get reliable predictions varies, and there is no universal value that works best across schedulers.
Because of that, the default value of <code>num_inference_steps</code> in the <code>__call__</code> method of the pipeline is set to <code>None</code> (see the API reference).
Unless set explicitly, its value will be taken from the checkpoint configuration <code>model_index.json</code>.
This is done to ensure high-quality predictions when calling the pipeline with just the <code>image</code> argument.`;return{c(){a=l("p"),a.innerHTML=w},l(p){a=d(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-1dhjd7u"&&(a.innerHTML=w)},m(p,u){n(p,a,u)},p:Ye,d(p){p&&o(a)}}}function Ot(D){let a,w="Examples:",p,u,M;return u=new Wt({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLWxjbS12MS0wJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBkaWZmdXNlcnMudXRpbHMubG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRm1hcmlnb2xkbW9ub2RlcHRoLmdpdGh1Yi5pbyUyRmltYWdlcyUyRmVpbnN0ZWluLmpwZyUyMiklMEFkZXB0aCUyMCUzRCUyMHBpcGUoaW1hZ2UpJTBBJTBBdmlzJTIwJTNEJTIwcGlwZS5pbWFnZV9wcm9jZXNzb3IudmlzdWFsaXplX2RlcHRoKGRlcHRoLnByZWRpY3Rpb24pJTBBdmlzJTVCMCU1RC5zYXZlKCUyMmVpbnN0ZWluX2RlcHRoLnBuZyUyMiklMEElMEFkZXB0aF8xNmJpdCUyMCUzRCUyMHBpcGUuaW1hZ2VfcHJvY2Vzc29yLmV4cG9ydF9kZXB0aF90b18xNmJpdF9wbmcoZGVwdGgucHJlZGljdGlvbiklMEFkZXB0aF8xNmJpdCU1QjAlNUQuc2F2ZSglMjJlaW5zdGVpbl9kZXB0aF8xNmJpdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> diffusers
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;prs-eth/marigold-depth-lcm-v1-0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = pipe(image)

<span class="hljs-meta">&gt;&gt;&gt; </span>vis = pipe.image_processor.visualize_depth(depth.prediction)
<span class="hljs-meta">&gt;&gt;&gt; </span>vis[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_depth.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>depth_16bit = pipe.image_processor.export_depth_to_16bit_png(depth.prediction)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth_16bit[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_depth_16bit.png&quot;</span>)`,wrap:!1}}),{c(){a=l("p"),a.textContent=w,p=i(),h(u.$$.fragment)},l(r){a=d(r,"P",{"data-svelte-h":!0}),m(a)!=="svelte-kvfsh7"&&(a.textContent=w),p=s(r),g(u.$$.fragment,r)},m(r,y){n(r,a,y),n(r,p,y),f(u,r,y),M=!0},p:Ye,i(r){M||(_(u.$$.fragment,r),M=!0)},o(r){b(u.$$.fragment,r),M=!1},d(r){r&&(o(a),o(p)),v(u,r)}}}function Ft(D){let a,w="Examples:",p,u,M;return u=new Wt({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkTm9ybWFsc1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJwcnMtZXRoJTJGbWFyaWdvbGQtbm9ybWFscy1sY20tdjAtMSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwZGlmZnVzZXJzLnV0aWxzLmxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZtYXJpZ29sZG1vbm9kZXB0aC5naXRodWIuaW8lMkZpbWFnZXMlMkZlaW5zdGVpbi5qcGclMjIpJTBBbm9ybWFscyUyMCUzRCUyMHBpcGUoaW1hZ2UpJTBBJTBBdmlzJTIwJTNEJTIwcGlwZS5pbWFnZV9wcm9jZXNzb3IudmlzdWFsaXplX25vcm1hbHMobm9ybWFscy5wcmVkaWN0aW9uKSUwQXZpcyU1QjAlNUQuc2F2ZSglMjJlaW5zdGVpbl9ub3JtYWxzLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> diffusers
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = diffusers.MarigoldNormalsPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;prs-eth/marigold-normals-lcm-v0-1&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>normals = pipe(image)

<span class="hljs-meta">&gt;&gt;&gt; </span>vis = pipe.image_processor.visualize_normals(normals.prediction)
<span class="hljs-meta">&gt;&gt;&gt; </span>vis[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_normals.png&quot;</span>)`,wrap:!1}}),{c(){a=l("p"),a.textContent=w,p=i(),h(u.$$.fragment)},l(r){a=d(r,"P",{"data-svelte-h":!0}),m(a)!=="svelte-kvfsh7"&&(a.textContent=w),p=s(r),g(u.$$.fragment,r)},m(r,y){n(r,a,y),n(r,p,y),f(u,r,y),M=!0},p:Ye,i(r){M||(_(u.$$.fragment,r),M=!0)},o(r){b(u.$$.fragment,r),M=!1},d(r){r&&(o(a),o(p)),v(u,r)}}}function At(D){let a,w,p,u,M,r,y,ht='<img src="https://marigoldmonodepth.github.io/images/teaser_collage_compressed.jpg" alt="marigold"/>',Te,E,gt=`Marigold was proposed in <a href="https://huggingface.co/papers/2312.02145" rel="nofollow">Repurposing Diffusion-Based Image Generators for Monocular Depth Estimation</a>, a CVPR 2024 Oral paper by <a href="http://www.kebingxin.com/" rel="nofollow">Bingxin Ke</a>, <a href="https://www.obukhov.ai/" rel="nofollow">Anton Obukhov</a>, <a href="https://shengyuh.github.io/" rel="nofollow">Shengyu Huang</a>, <a href="https://nandometzger.github.io/" rel="nofollow">Nando Metzger</a>, <a href="https://rcdaudt.github.io/" rel="nofollow">Rodrigo Caye Daudt</a>, and <a href="https://scholar.google.com/citations?user=FZuNgqIAAAAJ&amp;hl=en" rel="nofollow">Konrad Schindler</a>.
The idea is to repurpose the rich generative prior of Text-to-Image Latent Diffusion Models (LDMs) for traditional computer vision tasks.
Initially, this idea was explored to fine-tune Stable Diffusion for Monocular Depth Estimation, as shown in the teaser above.
Later,`,Pe,R,ft='<li><a href="https://tianfwang.github.io/" rel="nofollow">Tianfu Wang</a> trained the first Latent Consistency Model (LCM) of Marigold, which unlocked fast single-step inference;</li> <li><a href="https://www.linkedin.com/in/kevin-qu-b3417621b/?locale=en_US" rel="nofollow">Kevin Qu</a> extended the approach to Surface Normals Estimation;</li> <li><a href="https://www.obukhov.ai/" rel="nofollow">Anton Obukhov</a> contributed the pipelines and documentation into diffusers (enabled and supported by <a href="https://yiyixuxu.github.io/" rel="nofollow">YiYi Xu</a> and <a href="https://sayak.dev/" rel="nofollow">Sayak Paul</a>).</li>',De,O,_t="The abstract from the paper is:",Ne,F,bt='<em>Monocular depth estimation is a fundamental computer vision task. Recovering 3D depth from a single image is geometrically ill-posed and requires scene understanding, so it is not surprising that the rise of deep learning has led to a breakthrough. The impressive progress of monocular depth estimators has mirrored the growth in model capacity, from relatively modest CNNs to large Transformer architectures. Still, monocular depth estimators tend to struggle when presented with images with unfamiliar content and layout, since their knowledge of the visual world is restricted by the data seen during training, and challenged by zero-shot generalization to new domains. This motivates us to explore whether the extensive priors captured in recent generative diffusion models can enable better, more generalizable depth estimation. We introduce Marigold, a method for affine-invariant monocular depth estimation that is derived from Stable Diffusion and retains its rich prior knowledge. The estimator can be fine-tuned in a couple of days on a single GPU using only synthetic training data. It delivers state-of-the-art performance across a wide range of datasets, including over 20% performance gains in specific cases. Project page: <a href="https://marigoldmonodepth.github.io" rel="nofollow">https://marigoldmonodepth.github.io</a>.</em>',qe,A,ke,G,vt=`Each pipeline supports one Computer Vision task, which takes an input RGB image as input and produces a <em>prediction</em> of the modality of interest, such as a depth map of the input image.
Currently, the following tasks are implemented:`,ze,S,Mt='<thead><tr><th>Pipeline</th> <th>Predicted Modalities</th> <th align="center">Demos</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_depth.py" rel="nofollow">MarigoldDepthPipeline</a></td> <td><a href="https://en.wikipedia.org/wiki/Depth_map" rel="nofollow">Depth</a>, <a href="https://en.wikipedia.org/wiki/Binocular_disparity" rel="nofollow">Disparity</a></td> <td align="center"><a href="https://huggingface.co/spaces/prs-eth/marigold-lcm" rel="nofollow">Fast Demo (LCM)</a>, <a href="https://huggingface.co/spaces/prs-eth/marigold" rel="nofollow">Slow Original Demo (DDIM)</a></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_normals.py" rel="nofollow">MarigoldNormalsPipeline</a></td> <td><a href="https://en.wikipedia.org/wiki/Normal_mapping" rel="nofollow">Surface normals</a></td> <td align="center"><a href="https://huggingface.co/spaces/prs-eth/marigold-normals-lcm" rel="nofollow">Fast Demo (LCM)</a></td></tr></tbody>',Le,V,Ce,X,wt='The original checkpoints can be found under the <a href="https://huggingface.co/prs-eth/" rel="nofollow">PRS-ETH</a> Hugging Face organization.',Ie,W,We,J,Je,Y,yt='See also Marigold <a href="marigold_usage">usage examples</a>.',je,Q,Ue,x,K,Qe,me,xt='Pipeline for monocular depth estimation using the Marigold method: <a href="https://marigoldmonodepth.github.io" rel="nofollow">https://marigoldmonodepth.github.io</a>.',Ke,he,$t=`This model inherits from <a href="/docs/diffusers/pr_6247/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,et,N,ee,tt,ge,Tt="Function invoked when calling the pipeline.",ot,j,nt,U,te,it,fe,Pt=`Ensembles the depth maps represented by the <code>depth</code> tensor with expected shape <code>(B, 1, H, W)</code>, where B is the
number of ensemble members for a given prediction of size <code>(H x W)</code>. Even though the function is designed for
depth maps, it can also be used with disparity maps as long as the input tensor values are non-negative. The
alignment happens when the predictions have one or more degrees of freedom, that is when they are either
affine-invariant (<code>scale_invariant=True</code> and <code>shift_invariant=True</code>), or just scale-invariant (only
<code>scale_invariant=True</code>). For absolute predictions (<code>scale_invariant=False</code> and <code>shift_invariant=False</code>)
alignment is skipped and only ensembling is performed.`,Ze,oe,He,$,ne,st,_e,Dt='Pipeline for monocular normals estimation using the Marigold method: <a href="https://marigoldmonodepth.github.io" rel="nofollow">https://marigoldmonodepth.github.io</a>.',at,be,Nt=`This model inherits from <a href="/docs/diffusers/pr_6247/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,rt,q,ie,lt,ve,qt="Function invoked when calling the pipeline.",dt,Z,ct,H,se,pt,Me,kt=`Ensembles the normals maps represented by the <code>normals</code> tensor with expected shape <code>(B, 3, H, W)</code>, where B is
the number of ensemble members for a given prediction of size <code>(H x W)</code>.`,Be,ae,Ee,L,re,ut,we,zt="Output class for Marigold monocular depth prediction pipeline.",Re,le,Oe,C,de,mt,ye,Lt="Output class for Marigold monocular normals prediction pipeline.",Fe,ce,Ae,$e,Ge;return M=new ue({props:{title:"Marigold Pipelines for Computer Vision Tasks",local:"marigold-pipelines-for-computer-vision-tasks",headingTag:"h1"}}),A=new ue({props:{title:"Available Pipelines",local:"available-pipelines",headingTag:"h2"}}),V=new ue({props:{title:"Available Checkpoints",local:"available-checkpoints",headingTag:"h2"}}),W=new Ct({props:{$$slots:{default:[Et]},$$scope:{ctx:D}}}),J=new Ct({props:{warning:!0,$$slots:{default:[Rt]},$$scope:{ctx:D}}}),Q=new ue({props:{title:"MarigoldDepthPipeline",local:"diffusers.MarigoldDepthPipeline",headingTag:"h2"}}),K=new B({props:{name:"class diffusers.MarigoldDepthPipeline",anchor:"diffusers.MarigoldDepthPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"vae",val:": AutoencoderKL"},{name:"scheduler",val:": Union"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"prediction_type",val:": Optional = None"},{name:"scale_invariant",val:": Optional = True"},{name:"shift_invariant",val:": Optional = True"},{name:"default_denoising_steps",val:": Optional = None"},{name:"default_processing_resolution",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.MarigoldDepthPipeline.unet",description:`<strong>unet</strong> (<code>UNet2DConditionModel</code>) &#x2014;
Conditional U-Net to denoise the depth latent, conditioned on image latent.`,name:"unet"},{anchor:"diffusers.MarigoldDepthPipeline.vae",description:`<strong>vae</strong> (<code>AutoencoderKL</code>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images and predictions to and from latent
representations.`,name:"vae"},{anchor:"diffusers.MarigoldDepthPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDIMScheduler</code> or <code>LCMScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.MarigoldDepthPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Text-encoder, for empty text embedding.`,name:"text_encoder"},{anchor:"diffusers.MarigoldDepthPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
CLIP tokenizer.`,name:"tokenizer"},{anchor:"diffusers.MarigoldDepthPipeline.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of predictions made by the model.`,name:"prediction_type"},{anchor:"diffusers.MarigoldDepthPipeline.scale_invariant",description:`<strong>scale_invariant</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A model property specifying whether the predicted depth maps are scale-invariant. This value must be set in
the model config. When used together with the <code>shift_invariant=True</code> flag, the model is also called
&#x201C;affine-invariant&#x201D;. NB: overriding this value is not supported.`,name:"scale_invariant"},{anchor:"diffusers.MarigoldDepthPipeline.shift_invariant",description:`<strong>shift_invariant</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A model property specifying whether the predicted depth maps are shift-invariant. This value must be set in
the model config. When used together with the <code>scale_invariant=True</code> flag, the model is also called
&#x201C;affine-invariant&#x201D;. NB: overriding this value is not supported.`,name:"shift_invariant"},{anchor:"diffusers.MarigoldDepthPipeline.default_denoising_steps",description:`<strong>default_denoising_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of denoising diffusion steps that are required to produce a prediction of reasonable
quality with the given model. This value must be set in the model config. When the pipeline is called
without explicitly setting <code>num_inference_steps</code>, the default value is used. This is required to ensure
reasonable results with various model flavors compatible with the pipeline, such as those relying on very
short denoising schedules (<code>LCMScheduler</code>) and those with full diffusion schedules (<code>DDIMScheduler</code>).`,name:"default_denoising_steps"},{anchor:"diffusers.MarigoldDepthPipeline.default_processing_resolution",description:`<strong>default_processing_resolution</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The recommended value of the <code>processing_resolution</code> parameter of the pipeline. This value must be set in
the model config. When the pipeline is called without explicitly setting <code>processing_resolution</code>, the
default value is used. This is required to ensure reasonable results with various model flavors trained
with varying optimal processing resolution values.`,name:"default_processing_resolution"}],source:"https://github.com/huggingface/diffusers/blob/vr_6247/src/diffusers/pipelines/marigold/pipeline_marigold_depth.py#L96"}}),ee=new B({props:{name:"__call__",anchor:"diffusers.MarigoldDepthPipeline.__call__",parameters:[{name:"image",val:": Union"},{name:"num_inference_steps",val:": Optional = None"},{name:"ensemble_size",val:": int = 1"},{name:"processing_resolution",val:": Optional = None"},{name:"match_input_resolution",val:": bool = True"},{name:"resample_method_input",val:": str = 'bilinear'"},{name:"resample_method_output",val:": str = 'bilinear'"},{name:"batch_size",val:": int = 1"},{name:"ensembling_kwargs",val:": Optional = None"},{name:"latents",val:": Union = None"},{name:"generator",val:": Union = None"},{name:"output_type",val:": str = 'np'"},{name:"output_uncertainty",val:": bool = False"},{name:"output_latent",val:": bool = False"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.MarigoldDepthPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>), &#x2014;
<code>List[torch.Tensor]</code>: An input image or images used as an input for the depth estimation task. For
arrays and tensors, the expected value range is between <code>[0, 1]</code>. Passing a batch of images is possible
by providing a four-dimensional array or a tensor. Additionally, a list of images of two- or
three-dimensional arrays or tensors can be passed. In the latter case, all list elements must have the
same width and height.`,name:"image"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of denoising diffusion steps during inference. The default value <code>None</code> results in automatic
selection. The number of steps should be at least 10 with the full Marigold models, and between 1 and 4
for Marigold-LCM models.`,name:"num_inference_steps"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.ensemble_size",description:`<strong>ensemble_size</strong> (<code>int</code>, defaults to <code>1</code>) &#x2014;
Number of ensemble predictions. Recommended values are 5 and higher for better precision, or 1 for
faster inference.`,name:"ensemble_size"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.processing_resolution",description:`<strong>processing_resolution</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Effective processing resolution. When set to <code>0</code>, matches the larger input image dimension. This
produces crisper predictions, but may also lead to the overall loss of global context. The default
value <code>None</code> resolves to the optimal value from the model config.`,name:"processing_resolution"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.match_input_resolution",description:`<strong>match_input_resolution</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When enabled, the output prediction is resized to match the input dimensions. When disabled, the longer
side of the output will equal to <code>processing_resolution</code>.`,name:"match_input_resolution"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.resample_method_input",description:`<strong>resample_method_input</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;bilinear&quot;</code>) &#x2014;
Resampling method used to resize input images to <code>processing_resolution</code>. The accepted values are:
<code>&quot;nearest&quot;</code>, <code>&quot;nearest-exact&quot;</code>, <code>&quot;bilinear&quot;</code>, <code>&quot;bicubic&quot;</code>, or <code>&quot;area&quot;</code>.`,name:"resample_method_input"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.resample_method_output",description:`<strong>resample_method_output</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;bilinear&quot;</code>) &#x2014;
Resampling method used to resize output predictions to match the input resolution. The accepted values
are <code>&quot;nearest&quot;</code>, <code>&quot;nearest-exact&quot;</code>, <code>&quot;bilinear&quot;</code>, <code>&quot;bicubic&quot;</code>, or <code>&quot;area&quot;</code>.`,name:"resample_method_output"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Batch size; only matters when setting <code>ensemble_size</code> or passing a tensor of images.`,name:"batch_size"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.ensembling_kwargs",description:`<strong>ensembling_kwargs</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Extra dictionary with arguments for precise ensembling control. The following options are available:<ul>
<li>reduction (<code>str</code>, <em>optional</em>, defaults to <code>&quot;median&quot;</code>): Defines the ensembling function applied in
every pixel location, can be either <code>&quot;median&quot;</code> or <code>&quot;mean&quot;</code>.</li>
<li>regularizer_strength (<code>float</code>, <em>optional</em>, defaults to <code>0.02</code>): Strength of the regularizer that
pulls the aligned predictions to the unit range from 0 to 1.</li>
<li>max_iter (<code>int</code>, <em>optional</em>, defaults to <code>2</code>): Maximum number of the alignment solver steps. Refer to
<code>scipy.optimize.minimize</code> function, <code>options</code> argument.</li>
<li>tol (<code>float</code>, <em>optional</em>, defaults to <code>1e-3</code>): Alignment solver tolerance. The solver stops when the
tolerance is reached.</li>
<li>max_res (<code>int</code>, <em>optional</em>, defaults to <code>None</code>): Resolution at which the alignment is performed;
<code>None</code> matches the <code>processing_resolution</code>.</li>
</ul>`,name:"ensembling_kwargs"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, or <code>List[torch.Tensor]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Latent noise tensors to replace the random initialization. These can be taken from the previous
function call&#x2019;s output.`,name:"latents"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, or <code>List[torch.Generator]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Random number generator object to ensure reproducibility.`,name:"generator"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
Preferred format of the output&#x2019;s <code>prediction</code> and the optional <code>uncertainty</code> fields. The accepted
values are: <code>&quot;np&quot;</code> (numpy array) or <code>&quot;pt&quot;</code> (torch tensor).`,name:"output_type"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.output_uncertainty",description:`<strong>output_uncertainty</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When enabled, the output&#x2019;s <code>uncertainty</code> field contains the predictive uncertainty map, provided that
the <code>ensemble_size</code> argument is set to a value above 2.`,name:"output_uncertainty"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.output_latent",description:`<strong>output_latent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When enabled, the output&#x2019;s <code>latent</code> field contains the latent codes corresponding to the predictions
within the ensemble. These codes can be saved, modified, and used for subsequent calls with the
<code>latents</code> argument.`,name:"output_latent"},{anchor:"diffusers.MarigoldDepthPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_6247/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldDepthOutput">MarigoldDepthOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/vr_6247/src/diffusers/pipelines/marigold/pipeline_marigold_depth.py#L333",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_6247/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldDepthOutput"
>MarigoldDepthOutput</a> is returned, otherwise a
<code>tuple</code> is returned where the first element is the prediction, the second element is the uncertainty
(or <code>None</code>), and the third is the latent (or <code>None</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_6247/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldDepthOutput"
>MarigoldDepthOutput</a> or <code>tuple</code></p>
`}}),j=new It({props:{anchor:"diffusers.MarigoldDepthPipeline.__call__.example",$$slots:{default:[Ot]},$$scope:{ctx:D}}}),te=new B({props:{name:"ensemble_depth",anchor:"diffusers.MarigoldDepthPipeline.ensemble_depth",parameters:[{name:"depth",val:": Tensor"},{name:"scale_invariant",val:": bool = True"},{name:"shift_invariant",val:": bool = True"},{name:"output_uncertainty",val:": bool = False"},{name:"reduction",val:": str = 'median'"},{name:"regularizer_strength",val:": float = 0.02"},{name:"max_iter",val:": int = 2"},{name:"tol",val:": float = 0.001"},{name:"max_res",val:": int = 1024"}],parametersDescription:[{anchor:"diffusers.MarigoldDepthPipeline.ensemble_depth.depth",description:`<strong>depth</strong> (<code>torch.Tensor</code>) &#x2014;
Input ensemble depth maps.`,name:"depth"},{anchor:"diffusers.MarigoldDepthPipeline.ensemble_depth.scale_invariant",description:`<strong>scale_invariant</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to treat predictions as scale-invariant.`,name:"scale_invariant"},{anchor:"diffusers.MarigoldDepthPipeline.ensemble_depth.shift_invariant",description:`<strong>shift_invariant</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to treat predictions as shift-invariant.`,name:"shift_invariant"},{anchor:"diffusers.MarigoldDepthPipeline.ensemble_depth.output_uncertainty",description:`<strong>output_uncertainty</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to output uncertainty map.`,name:"output_uncertainty"},{anchor:"diffusers.MarigoldDepthPipeline.ensemble_depth.reduction",description:`<strong>reduction</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;median&quot;</code>) &#x2014;
Reduction method used to ensemble aligned predictions. The accepted values are: <code>&quot;mean&quot;</code> and
<code>&quot;median&quot;</code>.`,name:"reduction"},{anchor:"diffusers.MarigoldDepthPipeline.ensemble_depth.regularizer_strength",description:`<strong>regularizer_strength</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.02</code>) &#x2014;
Strength of the regularizer that pulls the aligned predictions to the unit range from 0 to 1.`,name:"regularizer_strength"},{anchor:"diffusers.MarigoldDepthPipeline.ensemble_depth.max_iter",description:`<strong>max_iter</strong> (<code>int</code>, <em>optional</em>, defaults to <code>2</code>) &#x2014;
Maximum number of the alignment solver steps. Refer to <code>scipy.optimize.minimize</code> function, <code>options</code>
argument.`,name:"max_iter"},{anchor:"diffusers.MarigoldDepthPipeline.ensemble_depth.tol",description:`<strong>tol</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1e-3</code>) &#x2014;
Alignment solver tolerance. The solver stops when the tolerance is reached.`,name:"tol"},{anchor:"diffusers.MarigoldDepthPipeline.ensemble_depth.max_res",description:`<strong>max_res</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Resolution at which the alignment is performed; <code>None</code> matches the <code>processing_resolution</code>.`,name:"max_res"}],source:"https://github.com/huggingface/diffusers/blob/vr_6247/src/diffusers/pipelines/marigold/pipeline_marigold_depth.py#L659",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>(1, 1, H, W)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of aligned and ensembled depth maps and optionally a tensor of uncertainties of the same shape</p>
`}}),oe=new ue({props:{title:"MarigoldNormalsPipeline",local:"diffusers.MarigoldNormalsPipeline",headingTag:"h2"}}),ne=new B({props:{name:"class diffusers.MarigoldNormalsPipeline",anchor:"diffusers.MarigoldNormalsPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"vae",val:": AutoencoderKL"},{name:"scheduler",val:": Union"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"prediction_type",val:": Optional = None"},{name:"use_full_z_range",val:": Optional = True"},{name:"default_denoising_steps",val:": Optional = None"},{name:"default_processing_resolution",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.MarigoldNormalsPipeline.unet",description:`<strong>unet</strong> (<code>UNet2DConditionModel</code>) &#x2014;
Conditional U-Net to denoise the normals latent, conditioned on image latent.`,name:"unet"},{anchor:"diffusers.MarigoldNormalsPipeline.vae",description:`<strong>vae</strong> (<code>AutoencoderKL</code>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images and predictions to and from latent
representations.`,name:"vae"},{anchor:"diffusers.MarigoldNormalsPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDIMScheduler</code> or <code>LCMScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.MarigoldNormalsPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Text-encoder, for empty text embedding.`,name:"text_encoder"},{anchor:"diffusers.MarigoldNormalsPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
CLIP tokenizer.`,name:"tokenizer"},{anchor:"diffusers.MarigoldNormalsPipeline.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Type of predictions made by the model.`,name:"prediction_type"},{anchor:"diffusers.MarigoldNormalsPipeline.use_full_z_range",description:`<strong>use_full_z_range</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the normals predicted by this model utilize the full range of the Z dimension, or only its positive
half.`,name:"use_full_z_range"},{anchor:"diffusers.MarigoldNormalsPipeline.default_denoising_steps",description:`<strong>default_denoising_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of denoising diffusion steps that are required to produce a prediction of reasonable
quality with the given model. This value must be set in the model config. When the pipeline is called
without explicitly setting <code>num_inference_steps</code>, the default value is used. This is required to ensure
reasonable results with various model flavors compatible with the pipeline, such as those relying on very
short denoising schedules (<code>LCMScheduler</code>) and those with full diffusion schedules (<code>DDIMScheduler</code>).`,name:"default_denoising_steps"},{anchor:"diffusers.MarigoldNormalsPipeline.default_processing_resolution",description:`<strong>default_processing_resolution</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The recommended value of the <code>processing_resolution</code> parameter of the pipeline. This value must be set in
the model config. When the pipeline is called without explicitly setting <code>processing_resolution</code>, the
default value is used. This is required to ensure reasonable results with various model flavors trained
with varying optimal processing resolution values.`,name:"default_processing_resolution"}],source:"https://github.com/huggingface/diffusers/blob/vr_6247/src/diffusers/pipelines/marigold/pipeline_marigold_normals.py#L91"}}),ie=new B({props:{name:"__call__",anchor:"diffusers.MarigoldNormalsPipeline.__call__",parameters:[{name:"image",val:": Union"},{name:"num_inference_steps",val:": Optional = None"},{name:"ensemble_size",val:": int = 1"},{name:"processing_resolution",val:": Optional = None"},{name:"match_input_resolution",val:": bool = True"},{name:"resample_method_input",val:": str = 'bilinear'"},{name:"resample_method_output",val:": str = 'bilinear'"},{name:"batch_size",val:": int = 1"},{name:"ensembling_kwargs",val:": Optional = None"},{name:"latents",val:": Union = None"},{name:"generator",val:": Union = None"},{name:"output_type",val:": str = 'np'"},{name:"output_uncertainty",val:": bool = False"},{name:"output_latent",val:": bool = False"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.MarigoldNormalsPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>), &#x2014;
<code>List[torch.Tensor]</code>: An input image or images used as an input for the normals estimation task. For
arrays and tensors, the expected value range is between <code>[0, 1]</code>. Passing a batch of images is possible
by providing a four-dimensional array or a tensor. Additionally, a list of images of two- or
three-dimensional arrays or tensors can be passed. In the latter case, all list elements must have the
same width and height.`,name:"image"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of denoising diffusion steps during inference. The default value <code>None</code> results in automatic
selection. The number of steps should be at least 10 with the full Marigold models, and between 1 and 4
for Marigold-LCM models.`,name:"num_inference_steps"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.ensemble_size",description:`<strong>ensemble_size</strong> (<code>int</code>, defaults to <code>1</code>) &#x2014;
Number of ensemble predictions. Recommended values are 5 and higher for better precision, or 1 for
faster inference.`,name:"ensemble_size"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.processing_resolution",description:`<strong>processing_resolution</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Effective processing resolution. When set to <code>0</code>, matches the larger input image dimension. This
produces crisper predictions, but may also lead to the overall loss of global context. The default
value <code>None</code> resolves to the optimal value from the model config.`,name:"processing_resolution"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.match_input_resolution",description:`<strong>match_input_resolution</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When enabled, the output prediction is resized to match the input dimensions. When disabled, the longer
side of the output will equal to <code>processing_resolution</code>.`,name:"match_input_resolution"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.resample_method_input",description:`<strong>resample_method_input</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;bilinear&quot;</code>) &#x2014;
Resampling method used to resize input images to <code>processing_resolution</code>. The accepted values are:
<code>&quot;nearest&quot;</code>, <code>&quot;nearest-exact&quot;</code>, <code>&quot;bilinear&quot;</code>, <code>&quot;bicubic&quot;</code>, or <code>&quot;area&quot;</code>.`,name:"resample_method_input"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.resample_method_output",description:`<strong>resample_method_output</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;bilinear&quot;</code>) &#x2014;
Resampling method used to resize output predictions to match the input resolution. The accepted values
are <code>&quot;nearest&quot;</code>, <code>&quot;nearest-exact&quot;</code>, <code>&quot;bilinear&quot;</code>, <code>&quot;bicubic&quot;</code>, or <code>&quot;area&quot;</code>.`,name:"resample_method_output"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Batch size; only matters when setting <code>ensemble_size</code> or passing a tensor of images.`,name:"batch_size"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.ensembling_kwargs",description:`<strong>ensembling_kwargs</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Extra dictionary with arguments for precise ensembling control. The following options are available:<ul>
<li>reduction (<code>str</code>, <em>optional</em>, defaults to <code>&quot;closest&quot;</code>): Defines the ensembling function applied in
every pixel location, can be either <code>&quot;closest&quot;</code> or <code>&quot;mean&quot;</code>.</li>
</ul>`,name:"ensembling_kwargs"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Latent noise tensors to replace the random initialization. These can be taken from the previous
function call&#x2019;s output.`,name:"latents"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, or <code>List[torch.Generator]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Random number generator object to ensure reproducibility.`,name:"generator"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
Preferred format of the output&#x2019;s <code>prediction</code> and the optional <code>uncertainty</code> fields. The accepted
values are: <code>&quot;np&quot;</code> (numpy array) or <code>&quot;pt&quot;</code> (torch tensor).`,name:"output_type"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.output_uncertainty",description:`<strong>output_uncertainty</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When enabled, the output&#x2019;s <code>uncertainty</code> field contains the predictive uncertainty map, provided that
the <code>ensemble_size</code> argument is set to a value above 2.`,name:"output_uncertainty"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.output_latent",description:`<strong>output_latent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When enabled, the output&#x2019;s <code>latent</code> field contains the latent codes corresponding to the predictions
within the ensemble. These codes can be saved, modified, and used for subsequent calls with the
<code>latents</code> argument.`,name:"output_latent"},{anchor:"diffusers.MarigoldNormalsPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_6247/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldDepthOutput">MarigoldDepthOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/vr_6247/src/diffusers/pipelines/marigold/pipeline_marigold_normals.py#L317",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_6247/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldNormalsOutput"
>MarigoldNormalsOutput</a> is returned, otherwise a
<code>tuple</code> is returned where the first element is the prediction, the second element is the uncertainty
(or <code>None</code>), and the third is the latent (or <code>None</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_6247/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldNormalsOutput"
>MarigoldNormalsOutput</a> or <code>tuple</code></p>
`}}),Z=new It({props:{anchor:"diffusers.MarigoldNormalsPipeline.__call__.example",$$slots:{default:[Ft]},$$scope:{ctx:D}}}),se=new B({props:{name:"ensemble_normals",anchor:"diffusers.MarigoldNormalsPipeline.ensemble_normals",parameters:[{name:"normals",val:": Tensor"},{name:"output_uncertainty",val:": bool"},{name:"reduction",val:": str = 'closest'"}],parametersDescription:[{anchor:"diffusers.MarigoldNormalsPipeline.ensemble_normals.normals",description:`<strong>normals</strong> (<code>torch.Tensor</code>) &#x2014;
Input ensemble normals maps.`,name:"normals"},{anchor:"diffusers.MarigoldNormalsPipeline.ensemble_normals.output_uncertainty",description:`<strong>output_uncertainty</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to output uncertainty map.`,name:"output_uncertainty"},{anchor:"diffusers.MarigoldNormalsPipeline.ensemble_normals.reduction",description:`<strong>reduction</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;closest&quot;</code>) &#x2014;
Reduction method used to ensemble aligned predictions. The accepted values are: <code>&quot;closest&quot;</code> and
<code>&quot;mean&quot;</code>.`,name:"reduction"}],source:"https://github.com/huggingface/diffusers/blob/vr_6247/src/diffusers/pipelines/marigold/pipeline_marigold_normals.py#L646",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of aligned and ensembled normals maps with shape <code>(1, 3, H, W)</code> and optionally a tensor of
uncertainties of shape <code>(1, 1, H, W)</code>.</p>
`}}),ae=new ue({props:{title:"MarigoldDepthOutput",local:"diffusers.pipelines.marigold.MarigoldDepthOutput",headingTag:"h2"}}),re=new B({props:{name:"class diffusers.pipelines.marigold.MarigoldDepthOutput",anchor:"diffusers.pipelines.marigold.MarigoldDepthOutput",parameters:[{name:"prediction",val:": Union"},{name:"uncertainty",val:": Union"},{name:"latent",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.marigold.MarigoldDepthOutput.prediction",description:`<strong>prediction</strong> (<code>np.ndarray</code>, <code>torch.Tensor</code>) &#x2014;
Predicted depth maps with values in the range [0, 1]. The shape is always $numimages 	imes 1 	imes height
imes width$, regardless of whether the images were passed as a 4D array or a list.`,name:"prediction"},{anchor:"diffusers.pipelines.marigold.MarigoldDepthOutput.uncertainty",description:`<strong>uncertainty</strong> (<code>None</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>) &#x2014;
Uncertainty maps computed from the ensemble, with values in the range [0, 1]. The shape is $numimages
imes 1 	imes height 	imes width$.`,name:"uncertainty"},{anchor:"diffusers.pipelines.marigold.MarigoldDepthOutput.latent",description:`<strong>latent</strong> (<code>None</code>, <code>torch.Tensor</code>) &#x2014;
Latent features corresponding to the predictions, compatible with the <code>latents</code> argument of the pipeline.
The shape is $numimages * numensemble 	imes 4 	imes latentheight 	imes latentwidth$.`,name:"latent"}],source:"https://github.com/huggingface/diffusers/blob/vr_6247/src/diffusers/pipelines/marigold/pipeline_marigold_depth.py#L74"}}),le=new ue({props:{title:"MarigoldNormalsOutput",local:"diffusers.pipelines.marigold.MarigoldNormalsOutput",headingTag:"h2"}}),de=new B({props:{name:"class diffusers.pipelines.marigold.MarigoldNormalsOutput",anchor:"diffusers.pipelines.marigold.MarigoldNormalsOutput",parameters:[{name:"prediction",val:": Union"},{name:"uncertainty",val:": Union"},{name:"latent",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.marigold.MarigoldNormalsOutput.prediction",description:`<strong>prediction</strong> (<code>np.ndarray</code>, <code>torch.Tensor</code>) &#x2014;
Predicted normals with values in the range [-1, 1]. The shape is always $numimages 	imes 3 	imes height
imes width$, regardless of whether the images were passed as a 4D array or a list.`,name:"prediction"},{anchor:"diffusers.pipelines.marigold.MarigoldNormalsOutput.uncertainty",description:`<strong>uncertainty</strong> (<code>None</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>) &#x2014;
Uncertainty maps computed from the ensemble, with values in the range [0, 1]. The shape is $numimages
imes 1 	imes height 	imes width$.`,name:"uncertainty"},{anchor:"diffusers.pipelines.marigold.MarigoldNormalsOutput.latent",description:`<strong>latent</strong> (<code>None</code>, <code>torch.Tensor</code>) &#x2014;
Latent features corresponding to the predictions, compatible with the <code>latents</code> argument of the pipeline.
The shape is $numimages * numensemble 	imes 4 	imes latentheight 	imes latentwidth$.`,name:"latent"}],source:"https://github.com/huggingface/diffusers/blob/vr_6247/src/diffusers/pipelines/marigold/pipeline_marigold_normals.py#L69"}}),ce=new Bt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/marigold.md"}}),{c(){a=l("meta"),w=i(),p=l("p"),u=i(),h(M.$$.fragment),r=i(),y=l("p"),y.innerHTML=ht,Te=i(),E=l("p"),E.innerHTML=gt,Pe=i(),R=l("ul"),R.innerHTML=ft,De=i(),O=l("p"),O.textContent=_t,Ne=i(),F=l("p"),F.innerHTML=bt,qe=i(),h(A.$$.fragment),ke=i(),G=l("p"),G.innerHTML=vt,ze=i(),S=l("table"),S.innerHTML=Mt,Le=i(),h(V.$$.fragment),Ce=i(),X=l("p"),X.innerHTML=wt,Ie=i(),h(W.$$.fragment),We=i(),h(J.$$.fragment),Je=i(),Y=l("p"),Y.innerHTML=yt,je=i(),h(Q.$$.fragment),Ue=i(),x=l("div"),h(K.$$.fragment),Qe=i(),me=l("p"),me.innerHTML=xt,Ke=i(),he=l("p"),he.innerHTML=$t,et=i(),N=l("div"),h(ee.$$.fragment),tt=i(),ge=l("p"),ge.textContent=Tt,ot=i(),h(j.$$.fragment),nt=i(),U=l("div"),h(te.$$.fragment),it=i(),fe=l("p"),fe.innerHTML=Pt,Ze=i(),h(oe.$$.fragment),He=i(),$=l("div"),h(ne.$$.fragment),st=i(),_e=l("p"),_e.innerHTML=Dt,at=i(),be=l("p"),be.innerHTML=Nt,rt=i(),q=l("div"),h(ie.$$.fragment),lt=i(),ve=l("p"),ve.textContent=qt,dt=i(),h(Z.$$.fragment),ct=i(),H=l("div"),h(se.$$.fragment),pt=i(),Me=l("p"),Me.innerHTML=kt,Be=i(),h(ae.$$.fragment),Ee=i(),L=l("div"),h(re.$$.fragment),ut=i(),we=l("p"),we.textContent=zt,Re=i(),h(le.$$.fragment),Oe=i(),C=l("div"),h(de.$$.fragment),mt=i(),ye=l("p"),ye.textContent=Lt,Fe=i(),h(ce.$$.fragment),Ae=i(),$e=l("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);a=d(t,"META",{name:!0,content:!0}),t.forEach(o),w=s(e),p=d(e,"P",{}),k(p).forEach(o),u=s(e),g(M.$$.fragment,e),r=s(e),y=d(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-1musivh"&&(y.innerHTML=ht),Te=s(e),E=d(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1dfiaml"&&(E.innerHTML=gt),Pe=s(e),R=d(e,"UL",{"data-svelte-h":!0}),m(R)!=="svelte-w0a4ms"&&(R.innerHTML=ft),De=s(e),O=d(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1cwsb16"&&(O.textContent=_t),Ne=s(e),F=d(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1ycg63a"&&(F.innerHTML=bt),qe=s(e),g(A.$$.fragment,e),ke=s(e),G=d(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-mg9rv6"&&(G.innerHTML=vt),ze=s(e),S=d(e,"TABLE",{"data-svelte-h":!0}),m(S)!=="svelte-1v9cy9r"&&(S.innerHTML=Mt),Le=s(e),g(V.$$.fragment,e),Ce=s(e),X=d(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1gkve0a"&&(X.innerHTML=wt),Ie=s(e),g(W.$$.fragment,e),We=s(e),g(J.$$.fragment,e),Je=s(e),Y=d(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-13eijh7"&&(Y.innerHTML=yt),je=s(e),g(Q.$$.fragment,e),Ue=s(e),x=d(e,"DIV",{class:!0});var T=k(x);g(K.$$.fragment,T),Qe=s(T),me=d(T,"P",{"data-svelte-h":!0}),m(me)!=="svelte-41emwn"&&(me.innerHTML=xt),Ke=s(T),he=d(T,"P",{"data-svelte-h":!0}),m(he)!=="svelte-m73k2u"&&(he.innerHTML=$t),et=s(T),N=d(T,"DIV",{class:!0});var I=k(N);g(ee.$$.fragment,I),tt=s(I),ge=d(I,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-typ793"&&(ge.textContent=Tt),ot=s(I),g(j.$$.fragment,I),I.forEach(o),nt=s(T),U=d(T,"DIV",{class:!0});var pe=k(U);g(te.$$.fragment,pe),it=s(pe),fe=d(pe,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-3ecgzi"&&(fe.innerHTML=Pt),pe.forEach(o),T.forEach(o),Ze=s(e),g(oe.$$.fragment,e),He=s(e),$=d(e,"DIV",{class:!0});var P=k($);g(ne.$$.fragment,P),st=s(P),_e=d(P,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-13lumts"&&(_e.innerHTML=Dt),at=s(P),be=d(P,"P",{"data-svelte-h":!0}),m(be)!=="svelte-m73k2u"&&(be.innerHTML=Nt),rt=s(P),q=d(P,"DIV",{class:!0});var xe=k(q);g(ie.$$.fragment,xe),lt=s(xe),ve=d(xe,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-typ793"&&(ve.textContent=qt),dt=s(xe),g(Z.$$.fragment,xe),xe.forEach(o),ct=s(P),H=d(P,"DIV",{class:!0});var Se=k(H);g(se.$$.fragment,Se),pt=s(Se),Me=d(Se,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1sqp0ub"&&(Me.innerHTML=kt),Se.forEach(o),P.forEach(o),Be=s(e),g(ae.$$.fragment,e),Ee=s(e),L=d(e,"DIV",{class:!0});var Ve=k(L);g(re.$$.fragment,Ve),ut=s(Ve),we=d(Ve,"P",{"data-svelte-h":!0}),m(we)!=="svelte-zmov3r"&&(we.textContent=zt),Ve.forEach(o),Re=s(e),g(le.$$.fragment,e),Oe=s(e),C=d(e,"DIV",{class:!0});var Xe=k(C);g(de.$$.fragment,Xe),mt=s(Xe),ye=d(Xe,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1msg7gm"&&(ye.textContent=Lt),Xe.forEach(o),Fe=s(e),g(ce.$$.fragment,e),Ae=s(e),$e=d(e,"P",{}),k($e).forEach(o),this.h()},h(){z(a,"name","hf:doc:metadata"),z(a,"content",Gt),z(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,a),n(e,w,t),n(e,p,t),n(e,u,t),f(M,e,t),n(e,r,t),n(e,y,t),n(e,Te,t),n(e,E,t),n(e,Pe,t),n(e,R,t),n(e,De,t),n(e,O,t),n(e,Ne,t),n(e,F,t),n(e,qe,t),f(A,e,t),n(e,ke,t),n(e,G,t),n(e,ze,t),n(e,S,t),n(e,Le,t),f(V,e,t),n(e,Ce,t),n(e,X,t),n(e,Ie,t),f(W,e,t),n(e,We,t),f(J,e,t),n(e,Je,t),n(e,Y,t),n(e,je,t),f(Q,e,t),n(e,Ue,t),n(e,x,t),f(K,x,null),c(x,Qe),c(x,me),c(x,Ke),c(x,he),c(x,et),c(x,N),f(ee,N,null),c(N,tt),c(N,ge),c(N,ot),f(j,N,null),c(x,nt),c(x,U),f(te,U,null),c(U,it),c(U,fe),n(e,Ze,t),f(oe,e,t),n(e,He,t),n(e,$,t),f(ne,$,null),c($,st),c($,_e),c($,at),c($,be),c($,rt),c($,q),f(ie,q,null),c(q,lt),c(q,ve),c(q,dt),f(Z,q,null),c($,ct),c($,H),f(se,H,null),c(H,pt),c(H,Me),n(e,Be,t),f(ae,e,t),n(e,Ee,t),n(e,L,t),f(re,L,null),c(L,ut),c(L,we),n(e,Re,t),f(le,e,t),n(e,Oe,t),n(e,C,t),f(de,C,null),c(C,mt),c(C,ye),n(e,Fe,t),f(ce,e,t),n(e,Ae,t),n(e,$e,t),Ge=!0},p(e,[t]){const T={};t&2&&(T.$$scope={dirty:t,ctx:e}),W.$set(T);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),J.$set(I);const pe={};t&2&&(pe.$$scope={dirty:t,ctx:e}),j.$set(pe);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),Z.$set(P)},i(e){Ge||(_(M.$$.fragment,e),_(A.$$.fragment,e),_(V.$$.fragment,e),_(W.$$.fragment,e),_(J.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(j.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(ie.$$.fragment,e),_(Z.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),Ge=!0)},o(e){b(M.$$.fragment,e),b(A.$$.fragment,e),b(V.$$.fragment,e),b(W.$$.fragment,e),b(J.$$.fragment,e),b(Q.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(j.$$.fragment,e),b(te.$$.fragment,e),b(oe.$$.fragment,e),b(ne.$$.fragment,e),b(ie.$$.fragment,e),b(Z.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(de.$$.fragment,e),b(ce.$$.fragment,e),Ge=!1},d(e){e&&(o(w),o(p),o(u),o(r),o(y),o(Te),o(E),o(Pe),o(R),o(De),o(O),o(Ne),o(F),o(qe),o(ke),o(G),o(ze),o(S),o(Le),o(Ce),o(X),o(Ie),o(We),o(Je),o(Y),o(je),o(Ue),o(x),o(Ze),o(He),o($),o(Be),o(Ee),o(L),o(Re),o(Oe),o(C),o(Fe),o(Ae),o($e)),o(a),v(M,e),v(A,e),v(V,e),v(W,e),v(J,e),v(Q,e),v(K),v(ee),v(j),v(te),v(oe,e),v(ne),v(ie),v(Z),v(se),v(ae,e),v(re),v(le,e),v(de),v(ce,e)}}}const Gt='{"title":"Marigold Pipelines for Computer Vision Tasks","local":"marigold-pipelines-for-computer-vision-tasks","sections":[{"title":"Available Pipelines","local":"available-pipelines","sections":[],"depth":2},{"title":"Available Checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"MarigoldDepthPipeline","local":"diffusers.MarigoldDepthPipeline","sections":[],"depth":2},{"title":"MarigoldNormalsPipeline","local":"diffusers.MarigoldNormalsPipeline","sections":[],"depth":2},{"title":"MarigoldDepthOutput","local":"diffusers.pipelines.marigold.MarigoldDepthOutput","sections":[],"depth":2},{"title":"MarigoldNormalsOutput","local":"diffusers.pipelines.marigold.MarigoldNormalsOutput","sections":[],"depth":2}],"depth":1}';function St(D){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oo extends Ut{constructor(a){super(),Zt(this,a,St,At,Jt,{})}}export{oo as component};
