import{s as is,o as ps,n as cs}from"../chunks/scheduler.0219f8bd.js";import{S as rs,i as Ms,g as M,s as n,r as U,A as ms,h as m,f as l,c as o,j as ns,u as T,x as J,k as os,y as ws,a as t,v as h,d,t as j,w as b}from"../chunks/index.f61edf3b.js";import{T as ys}from"../chunks/Tip.5d1e3ef4.js";import{C as q}from"../chunks/CodeBlock.38e566ae.js";import{H as O,E as us}from"../chunks/EditOnGithub.48fa589f.js";function Js(B){let i,f=`<br/>
As of October 2024, global WebGPU support is around 70% (according to <a href="https://caniuse.com/webgpu" rel="nofollow">caniuse.com</a>), meaning some users may not be able to use the API.`,w,r,y="If the following demos do not work in your browser, you may need to enable it using a feature flag:",u,p,Q='<li>Firefox: with the <code>dom.webgpu.enabled</code> flag (see <a href="https://developer.mozilla.org/en-US/docs/Mozilla/Firefox/Experimental_features#:~:text=tested%20by%20Firefox.-,WebGPU%20API,-The%20WebGPU%20API" rel="nofollow">here</a>).</li> <li>Safari: with the <code>WebGPU</code> feature flag (see <a href="https://webkit.org/blog/14879/webgpu-now-available-for-testing-in-safari-technology-preview/" rel="nofollow">here</a>).</li> <li>Older Chromium browsers (on Windows, macOS, Linux): with the <code>enable-unsafe-webgpu</code> flag (see <a href="https://developer.chrome.com/docs/web-platform/webgpu/troubleshooting-tips" rel="nofollow">here</a>).</li>';return{c(){i=M("p"),i.innerHTML=f,w=n(),r=M("p"),r.textContent=y,u=n(),p=M("ul"),p.innerHTML=Q},l(a){i=m(a,"P",{"data-svelte-h":!0}),J(i)!=="svelte-1iuesxc"&&(i.innerHTML=f),w=o(a),r=m(a,"P",{"data-svelte-h":!0}),J(r)!=="svelte-mcs3ta"&&(r.textContent=y),u=o(a),p=m(a,"UL",{"data-svelte-h":!0}),J(p)!=="svelte-ty8cnp"&&(p.innerHTML=Q)},m(a,c){t(a,i,c),t(a,w,c),t(a,r,c),t(a,u,c),t(a,p,c)},p:cs,d(a){a&&(l(i),l(w),l(r),l(u),l(p))}}}function Us(B){let i,f,w,r,y,u,p,Q='WebGPU is a new web standard for accelerated graphics and compute. The <a href="https://developer.mozilla.org/en-US/docs/Web/API/WebGPU_API" rel="nofollow">API</a> enables web developers to use the underlying system’s GPU to carry out high-performance computations directly in the browser. WebGPU is the successor to <a href="https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API" rel="nofollow">WebGL</a> and provides significantly better performance, because it allows for more direct interaction with modern GPUs. Lastly, it supports general-purpose GPU computations, which makes it just perfect for machine learning!',a,c,R,g,E,I,K='Thanks to our collaboration with <a href="https://www.npmjs.com/package/onnxruntime-web" rel="nofollow">ONNX Runtime Web</a>, enabling WebGPU acceleration is as simple as setting <code>device: &#39;webgpu&#39;</code> when loading a model. Let’s see some examples!',z,W,ss='<strong>Example:</strong> Compute text embeddings on WebGPU (<a href="https://v2.scrimba.com/s06a2smeej" rel="nofollow">demo</a>)',A,k,H,N,es='<strong>Example:</strong> Perform automatic speech recognition with OpenAI whisper on WebGPU (<a href="https://v2.scrimba.com/s0oi76h82g" rel="nofollow">demo</a>)',V,G,S,C,ls='<strong>Example:</strong> Perform image classification with MobileNetV4 on WebGPU (<a href="https://v2.scrimba.com/s0fv2uab1t" rel="nofollow">demo</a>)',_,v,L,Z,P,Y,ts="Due to the experimental nature of the WebGPU API, especially in non-Chromium browsers, you may",F,x,D,$,X;return y=new O({props:{title:"Running models on WebGPU",local:"running-models-on-webgpu",headingTag:"h1"}}),c=new ys({props:{warning:!0,$$slots:{default:[Js]},$$scope:{ctx:B}}}),g=new O({props:{title:"Usage in Transformers.js v3",local:"usage-in-transformersjs-v3",headingTag:"h2"}}),k=new q({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMjIlM0IlMEElMEElMkYlMkYlMjBDcmVhdGUlMjBhJTIwZmVhdHVyZS1leHRyYWN0aW9uJTIwcGlwZWxpbmUlMEFjb25zdCUyMGV4dHJhY3RvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIyZmVhdHVyZS1leHRyYWN0aW9uJTIyJTJDJTBBJTIwJTIwJTIybWl4ZWRicmVhZC1haSUyRm14YmFpLWVtYmVkLXhzbWFsbC12MSUyMiUyQyUwQSUyMCUyMCU3QiUyMGRldmljZSUzQSUyMCUyMndlYmdwdSUyMiUyMCU3RCUyQyUwQSU3RCklM0IlMEElMEElMkYlMkYlMjBDb21wdXRlJTIwZW1iZWRkaW5ncyUwQWNvbnN0JTIwdGV4dHMlMjAlM0QlMjAlNUIlMjJIZWxsbyUyMHdvcmxkISUyMiUyQyUyMCUyMlRoaXMlMjBpcyUyMGFuJTIwZXhhbXBsZSUyMHNlbnRlbmNlLiUyMiU1RCUzQiUwQWNvbnN0JTIwZW1iZWRkaW5ncyUyMCUzRCUyMGF3YWl0JTIwZXh0cmFjdG9yKHRleHRzJTJDJTIwJTdCJTIwcG9vbGluZyUzQSUyMCUyMm1lYW4lMjIlMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQWNvbnNvbGUubG9nKGVtYmVkZGluZ3MudG9saXN0KCkpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTVCLTAuMDE2OTg2MTgzODIyMTU1JTJDJTIwMC4wMzIyODY5NjgwODIxODk1NiUyQyUyMC0wLjAwMTM2MzA5NjY0MjMwNzkzNzElMkMlMjAuLi4lMjAlNUQlMkMlMEElMkYlMkYlMjAlMjAlMjAlNUIwLjA5MDUwNDgyNTExNTIwMzg2JTJDJTIwMC4wNzIwNzM4Njk0MDcxNzY5NyUyQyUyMDAuMDU3NjI3NDk5MTAzNTQ2MTQlMkMlMjAuLi4lMjAlNUQlMkMlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/transformers&quot;</span>;

<span class="hljs-comment">// Create a feature-extraction pipeline</span>
<span class="hljs-keyword">const</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(
  <span class="hljs-string">&quot;feature-extraction&quot;</span>,
  <span class="hljs-string">&quot;mixedbread-ai/mxbai-embed-xsmall-v1&quot;</span>,
  { <span class="hljs-attr">device</span>: <span class="hljs-string">&quot;webgpu&quot;</span> },
});

<span class="hljs-comment">// Compute embeddings</span>
<span class="hljs-keyword">const</span> texts = [<span class="hljs-string">&quot;Hello world!&quot;</span>, <span class="hljs-string">&quot;This is an example sentence.&quot;</span>];
<span class="hljs-keyword">const</span> embeddings = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(texts, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&quot;mean&quot;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(embeddings.<span class="hljs-title function_">tolist</span>());
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   [-0.016986183822155, 0.03228696808218956, -0.0013630966423079371, ... ],</span>
<span class="hljs-comment">//   [0.09050482511520386, 0.07207386940717697, 0.05762749910354614, ... ],</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),G=new q({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMjIlM0IlMEElMEElMkYlMkYlMjBDcmVhdGUlMjBhdXRvbWF0aWMlMjBzcGVlY2glMjByZWNvZ25pdGlvbiUyMHBpcGVsaW5lJTBBY29uc3QlMjB0cmFuc2NyaWJlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUwQSUyMCUyMCUyMm9ubngtY29tbXVuaXR5JTJGd2hpc3Blci10aW55LmVuJTIyJTJDJTBBJTIwJTIwJTdCJTIwZGV2aWNlJTNBJTIwJTIyd2ViZ3B1JTIyJTIwJTdEJTJDJTBBKSUzQiUwQSUwQSUyRiUyRiUyMFRyYW5zY3JpYmUlMjBhdWRpbyUyMGZyb20lMjBhJTIwVVJMJTBBY29uc3QlMjB1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGamZrLndhdiUyMiUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwpJTNCJTBBY29uc29sZS5sb2cob3V0cHV0KSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAnJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJyUyMCU3RA==",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/transformers&quot;</span>;

<span class="hljs-comment">// Create automatic speech recognition pipeline</span>
<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(
  <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
  <span class="hljs-string">&quot;onnx-community/whisper-tiny.en&quot;</span>,
  { <span class="hljs-attr">device</span>: <span class="hljs-string">&quot;webgpu&quot;</span> },
);

<span class="hljs-comment">// Transcribe audio from a URL</span>
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&quot;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&quot;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output);
<span class="hljs-comment">// { text: &#x27; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&#x27; }</span>`,wrap:!1}}),v=new q({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMjIlM0IlMEElMEElMkYlMkYlMjBDcmVhdGUlMjBpbWFnZSUyMGNsYXNzaWZpY2F0aW9uJTIwcGlwZWxpbmUlMEFjb25zdCUyMGNsYXNzaWZpZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIyb25ueC1jb21tdW5pdHklMkZtb2JpbGVuZXR2NF9jb252X3NtYWxsLmUyNDAwX3IyMjRfaW4xayUyMiUyQyUwQSUyMCUyMCU3QiUyMGRldmljZSUzQSUyMCUyMndlYmdwdSUyMiUyMCU3RCUyQyUwQSklM0IlMEElMEElMkYlMkYlMjBDbGFzc2lmeSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMFVSTCUwQWNvbnN0JTIwdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRnRpZ2VyLmpwZyUyMiUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCklM0IlMEFjb25zb2xlLmxvZyhvdXRwdXQpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAndGlnZXIlMkMlMjBQYW50aGVyYSUyMHRpZ3JpcyclMkMlMjBzY29yZSUzQSUyMDAuNjE0OTc4NDkyMjU5OTc5MiUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zMDI4MTczNDQ2NjU1MjczNCUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RhYmJ5JTJDJTIwdGFiYnklMjBjYXQnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMTkxMzU0MjI3NzE3OTY1ODQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCdseW54JTJDJTIwY2F0YW1vdW50JyUyQyUyMHNjb3JlJTNBJTIwMC4wMDEyMTYxMjY2MDU4NjgzMzk1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnRWd5cHRpYW4lMjBjYXQnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMTE0NjU5NjE1NzkyMzM0MDglMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/transformers&quot;</span>;

<span class="hljs-comment">// Create image classification pipeline</span>
<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(
  <span class="hljs-string">&quot;image-classification&quot;</span>,
  <span class="hljs-string">&quot;onnx-community/mobilenetv4_conv_small.e2400_r224_in1k&quot;</span>,
  { <span class="hljs-attr">device</span>: <span class="hljs-string">&quot;webgpu&quot;</span> },
);

<span class="hljs-comment">// Classify an image from a URL</span>
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&quot;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&quot;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;tiger, Panthera tigris&#x27;, score: 0.6149784922599792 },</span>
<span class="hljs-comment">//   { label: &#x27;tiger cat&#x27;, score: 0.30281734466552734 },</span>
<span class="hljs-comment">//   { label: &#x27;tabby, tabby cat&#x27;, score: 0.0019135422771796584 },</span>
<span class="hljs-comment">//   { label: &#x27;lynx, catamount&#x27;, score: 0.0012161266058683395 },</span>
<span class="hljs-comment">//   { label: &#x27;Egyptian cat&#x27;, score: 0.0011465961579233408 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Z=new O({props:{title:"Reporting bugs and providing feedback",local:"reporting-bugs-and-providing-feedback",headingTag:"h2"}}),x=new us({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/guides/webgpu.md"}}),{c(){i=M("meta"),f=n(),w=M("p"),r=n(),U(y.$$.fragment),u=n(),p=M("p"),p.innerHTML=Q,a=n(),U(c.$$.fragment),R=n(),U(g.$$.fragment),E=n(),I=M("p"),I.innerHTML=K,z=n(),W=M("p"),W.innerHTML=ss,A=n(),U(k.$$.fragment),H=n(),N=M("p"),N.innerHTML=es,V=n(),U(G.$$.fragment),S=n(),C=M("p"),C.innerHTML=ls,_=n(),U(v.$$.fragment),L=n(),U(Z.$$.fragment),P=n(),Y=M("p"),Y.textContent=ts,F=n(),U(x.$$.fragment),D=n(),$=M("p"),this.h()},l(s){const e=ms("svelte-u9bgzb",document.head);i=m(e,"META",{name:!0,content:!0}),e.forEach(l),f=o(s),w=m(s,"P",{}),ns(w).forEach(l),r=o(s),T(y.$$.fragment,s),u=o(s),p=m(s,"P",{"data-svelte-h":!0}),J(p)!=="svelte-19qhkg2"&&(p.innerHTML=Q),a=o(s),T(c.$$.fragment,s),R=o(s),T(g.$$.fragment,s),E=o(s),I=m(s,"P",{"data-svelte-h":!0}),J(I)!=="svelte-1dmideb"&&(I.innerHTML=K),z=o(s),W=m(s,"P",{"data-svelte-h":!0}),J(W)!=="svelte-1sxt5g1"&&(W.innerHTML=ss),A=o(s),T(k.$$.fragment,s),H=o(s),N=m(s,"P",{"data-svelte-h":!0}),J(N)!=="svelte-1jn61pt"&&(N.innerHTML=es),V=o(s),T(G.$$.fragment,s),S=o(s),C=m(s,"P",{"data-svelte-h":!0}),J(C)!=="svelte-1rgic84"&&(C.innerHTML=ls),_=o(s),T(v.$$.fragment,s),L=o(s),T(Z.$$.fragment,s),P=o(s),Y=m(s,"P",{"data-svelte-h":!0}),J(Y)!=="svelte-owwe84"&&(Y.textContent=ts),F=o(s),T(x.$$.fragment,s),D=o(s),$=m(s,"P",{}),ns($).forEach(l),this.h()},h(){os(i,"name","hf:doc:metadata"),os(i,"content",Ts)},m(s,e){ws(document.head,i),t(s,f,e),t(s,w,e),t(s,r,e),h(y,s,e),t(s,u,e),t(s,p,e),t(s,a,e),h(c,s,e),t(s,R,e),h(g,s,e),t(s,E,e),t(s,I,e),t(s,z,e),t(s,W,e),t(s,A,e),h(k,s,e),t(s,H,e),t(s,N,e),t(s,V,e),h(G,s,e),t(s,S,e),t(s,C,e),t(s,_,e),h(v,s,e),t(s,L,e),h(Z,s,e),t(s,P,e),t(s,Y,e),t(s,F,e),h(x,s,e),t(s,D,e),t(s,$,e),X=!0},p(s,[e]){const as={};e&2&&(as.$$scope={dirty:e,ctx:s}),c.$set(as)},i(s){X||(d(y.$$.fragment,s),d(c.$$.fragment,s),d(g.$$.fragment,s),d(k.$$.fragment,s),d(G.$$.fragment,s),d(v.$$.fragment,s),d(Z.$$.fragment,s),d(x.$$.fragment,s),X=!0)},o(s){j(y.$$.fragment,s),j(c.$$.fragment,s),j(g.$$.fragment,s),j(k.$$.fragment,s),j(G.$$.fragment,s),j(v.$$.fragment,s),j(Z.$$.fragment,s),j(x.$$.fragment,s),X=!1},d(s){s&&(l(f),l(w),l(r),l(u),l(p),l(a),l(R),l(E),l(I),l(z),l(W),l(A),l(H),l(N),l(V),l(S),l(C),l(_),l(L),l(P),l(Y),l(F),l(D),l($)),l(i),b(y,s),b(c,s),b(g,s),b(k,s),b(G,s),b(v,s),b(Z,s),b(x,s)}}}const Ts='{"title":"Running models on WebGPU","local":"running-models-on-webgpu","sections":[{"title":"Usage in Transformers.js v3","local":"usage-in-transformersjs-v3","sections":[],"depth":2},{"title":"Reporting bugs and providing feedback","local":"reporting-bugs-and-providing-feedback","sections":[],"depth":2}],"depth":1}';function hs(B){return ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends rs{constructor(i){super(),Ms(this,i,hs,Us,is,{})}}export{Is as component};
