import{s as He,o as Ne,n as Fe}from"../chunks/scheduler.defa9a21.js";import{S as Re,i as Qe,g as y,s as a,r,A as Se,h as M,f as s,c as n,j as We,u as p,x as f,k as ze,y as Ve,a as l,v as c,d,t as m,w as h}from"../chunks/index.fe795e71.js";import{T as Ye}from"../chunks/Tip.179eb360.js";import{C as V}from"../chunks/CodeBlock.42404125.js";import{H as q,E as Ee}from"../chunks/EditOnGithub.0f575778.js";function qe(E){let i,u=`Some of these are utilized with the <a href="/docs/accelerate/pr_2864/en/package_reference/accelerator#accelerate.Accelerator.main_process_first">main_process_first()</a> context manager, which utilizes <a href="/docs/accelerate/pr_2864/en/package_reference/accelerator#accelerate.Accelerator.wait_for_everyone">wait_for_everyone()</a> to
run a particular set of code on the main process beforehand before triggering and launching the other processes`;return{c(){i=y("p"),i.innerHTML=u},l(o){i=M(o,"P",{"data-svelte-h":!0}),f(i)!=="svelte-1kzwmj8"&&(i.innerHTML=u)},m(o,w){l(o,i,w)},p:Fe,d(o){o&&s(i)}}}function Le(E){let i,u=`<code>load_dataset</code> will perform a lock under the hood to stop multiple downloads from happening at once, but if you are downloading something
not using this library you should use this method.`;return{c(){i=y("p"),i.innerHTML=u},l(o){i=M(o,"P",{"data-svelte-h":!0}),f(i)!=="svelte-909il1"&&(i.innerHTML=u)},m(o,w){l(o,i,w)},p:Fe,d(o){o&&s(i)}}}function Pe(E){let i,u,o,w,U,P,j,Je=`When you run your usual script, instructions are executed in order. Using 🤗 Accelerate to deploy your script on several
GPUs at the same time introduces a complication: while each process executes all instructions in order, some may be
faster than others.`,K,T,_e=`You might need to wait for all processes to have reached a certain point before executing a given instruction. For
instance, you shouldn’t save a model before being sure every process is done with training, and you wouldn’t want to
continue training before all the model weights have been loaded in. To do this, just write the following line in your code:`,D,J,O,_,be=`This instruction will block all the processes that arrive first until all the other processes have reached that
point (if you run your script on just one GPU or CPU, this won’t do anything).`,ee,b,Ce="A few example cases of when to use this utility are listed below:",te,g,se,C,le,I,Ie="When downloading a dataset, you should download it first on the main process and then load the cached dataset afterward",ae,$,ne,k,ie,v,ke="Under the hood this is the same as calling:",oe,G,re,Z,pe,B,ve=`When saving the <code>state_dict</code> of the model, since you would normally save one file on just the main process
you should specify that:`,ce,x,de,A,me,X,Ge=`When loading in the <code>state_dict</code> to a model, optimizer, or scheduler, you should wait
for all workers to have the weights loaded in before moving on to training`,he,W,ye,z,Me,Y,Ze=`Applying a <code>map()</code> operation on multiple workers, such as tokenizing should be done on the
main process first, and then propagated to each one.`,fe,F,ue,H,we,N,Be=`To have a check that works with a flag set by a particular process, the <code>set_trigger</code> and <code>check_trigger</code> API should be used. Useful examples
for doing so can include situations such as using early stopping and monitoring the loss (as each loss slightly differs on each process).`,ge,R,xe='Call <a href="/docs/accelerate/pr_2864/en/package_reference/accelerator#accelerate.Accelerator.set_trigger">Accelerator.set_trigger()</a> when your condition has been met, and <a href="/docs/accelerate/pr_2864/en/package_reference/accelerator#accelerate.Accelerator.check_trigger">Accelerator.check_trigger()</a> when checking if that condition has been met in any process:',$e,Q,Ue,S,je,L,Te;return U=new q({props:{title:"Deferring Executions",local:"deferring-executions",headingTag:"h1"}}),J=new V({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKQ==",highlighted:'accelerator.wait<span class="hljs-constructor">_for_everyone()</span>',wrap:!1}}),g=new Ye({props:{$$slots:{default:[qe]},$$scope:{ctx:E}}}),C=new q({props:{title:"Downloading a Dataset",local:"downloading-a-dataset",headingTag:"h2"}}),$=new Ye({props:{$$slots:{default:[Le]},$$scope:{ctx:E}}}),k=new V({props:{code:"d2l0aCUyMGFjY2VsZXJhdG9yLm1haW5fcHJvY2Vzc19maXJzdCgpJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZ2x1ZSUyMiUyQyUyMCUyMm1ycGMlMjIp",highlighted:`<span class="hljs-keyword">with</span> accelerator.main_process_first():
    datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)`,wrap:!1}}),G=new V({props:{code:"JTIzJTIwRmlyc3QlMjBkbyUyMHNvbWV0aGluZyUyMG9uJTIwdGhlJTIwbWFpbiUyMHByb2Nlc3MlMEFpZiUyMGFjY2VsZXJhdG9yLmlzX21haW5fcHJvY2VzcyUzQSUwQSUyMCUyMCUyMCUyMGRhdGFzZXRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvci53YWl0X2Zvcl9ldmVyeW9uZSgpJTBBJTBBJTIzJTIwQW5kJTIwdGhlbiUyMHNlbmQlMjBpdCUyMHRvJTIwdGhlJTIwcmVzdCUyMG9mJTIwdGhlbSUwQWlmJTIwbm90JTIwYWNjZWxlcmF0b3IuaXNfbWFpbl9wcm9jZXNzJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZ2x1ZSUyMiUyQyUyMCUyMm1ycGMlMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLndhaXRfZm9yX2V2ZXJ5b25lKCk=",highlighted:`<span class="hljs-comment"># First do something on the main process</span>
<span class="hljs-keyword">if</span> accelerator.is_main_process:
    datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
<span class="hljs-keyword">else</span>:
    accelerator.wait_for_everyone()

<span class="hljs-comment"># And then send it to the rest of them</span>
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> accelerator.is_main_process:
    datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
<span class="hljs-keyword">else</span>:
    accelerator.wait_for_everyone()`,wrap:!1}}),Z=new q({props:{title:"Saving the state_dict",local:"saving-the-statedict",headingTag:"h2"}}),x=new V({props:{code:"aWYlMjBhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlM0ElMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMGFjY2VsZXJhdG9yLnVud3JhcF9tb2RlbChtb2RlbCklMEElMjAlMjAlMjAlMjB0b3JjaC5zYXZlKG1vZGVsLnN0YXRlX2RpY3QoKSUyQyUyMCUyMndlaWdodHMucHRoJTIyKQ==",highlighted:`<span class="hljs-keyword">if</span> accelerator.is_main_process:
    model = accelerator.unwrap_model(model)
    torch.save(model.state_dict(), <span class="hljs-string">&quot;weights.pth&quot;</span>)`,wrap:!1}}),A=new q({props:{title:"Loading in the state_dict",local:"loading-in-the-statedict",headingTag:"h2"}}),W=new V({props:{code:"d2l0aCUyMGFjY2VsZXJhdG9yLm1haW5fcHJvY2Vzc19maXJzdCgpJTNBJTBBJTIwJTIwJTIwJTIwc3RhdGUlMjAlM0QlMjB0b3JjaC5sb2FkKCUyMndlaWdodHMucHRoJTIyKSUwQSUyMCUyMCUyMCUyMG1vZGVsLmxvYWRfc3RhdGVfZGljdChzdGF0ZSk=",highlighted:`<span class="hljs-keyword">with</span> accelerator.main_process_first():
    state = torch.load(<span class="hljs-string">&quot;weights.pth&quot;</span>)
    model.load_state_dict(state)`,wrap:!1}}),z=new q({props:{title:"Applying a multi-worker CPU operation",local:"applying-a-multi-worker-cpu-operation",headingTag:"h2"}}),F=new V({props:{code:"ZGF0YXNldHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZ2x1ZSUyMiUyQyUyMCUyMm1ycGMlMjIpJTBBJTBBd2l0aCUyMGFjY2VsZXJhdG9yLm1haW5fcHJvY2Vzc19maXJzdCgpJTNBJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldHMubWFwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuaXplX2Z1bmN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRCU1QiUyMmlkeCUyMiUyQyUyMCUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCk=",highlighted:`datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)

<span class="hljs-keyword">with</span> accelerator.main_process_first():
    tokenized_datasets = datasets.<span class="hljs-built_in">map</span>(
        tokenize_function,
        batched=<span class="hljs-literal">True</span>,
        remove_columns=[<span class="hljs-string">&quot;idx&quot;</span>, <span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>],
    )`,wrap:!1}}),H=new q({props:{title:"Applying checks such as Early Stopping",local:"applying-checks-such-as-early-stopping",headingTag:"h2"}}),Q=new V({props:{code:"Zm9yJTIwKHglMkN5KSUyMGluJTIwZGF0YV9sb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCh4KSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmMobG9naXRzJTJDJTIweSklMEElMjAlMjAlMjAlMjAlMjMlMjBBc3N1bWUlMjAlNjBzaG91bGRfZG9fZWFybHlfc3RvcHBpbmclNjAlMjBpcyUyMGElMjBjdXN0b20lMjBkZWZpbmVkJTIwZnVuY3Rpb24lMjB0aGF0JTIwcmV0dXJucyUyMGElMjBjb25kaXRpb25hbCUwQSUyMCUyMCUyMCUyMGlmJTIwc2hvdWxkX2RvX2Vhcmx5X3N0b3BwaW5nKGxvc3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3Iuc2V0X3RyaWdnZXIoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMExhdGVyJTIwaW4lMjB0aGUlMjB0cmFpbmluZyUyMHNjcmlwdCUyMHdoZW4lMjB3ZSUyMG5lZWQlMjB0byUyMGNoZWNrJTIwZm9yJTIwdGhlJTIwYnJlYWtwb2ludCUwQSUyMCUyMCUyMCUyMGlmJTIwYWNjZWxlcmF0b3IuY2hlY2tfdHJpZ2dlcigpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-keyword">for</span> (x,y) <span class="hljs-keyword">in</span> data_loader:
    logits = model(x)
    loss = loss_func(logits, y)
    <span class="hljs-comment"># Assume \`should_do_early_stopping\` is a custom defined function that returns a conditional</span>
    <span class="hljs-keyword">if</span> should_do_early_stopping(loss):
        accelerator.set_trigger()

    <span class="hljs-comment"># Later in the training script when we need to check for the breakpoint</span>
    <span class="hljs-keyword">if</span> accelerator.check_trigger():
        <span class="hljs-keyword">break</span>`,wrap:!1}}),S=new Ee({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/concept_guides/deferring_execution.md"}}),{c(){i=y("meta"),u=a(),o=y("p"),w=a(),r(U.$$.fragment),P=a(),j=y("p"),j.textContent=Je,K=a(),T=y("p"),T.textContent=_e,D=a(),r(J.$$.fragment),O=a(),_=y("p"),_.textContent=be,ee=a(),b=y("p"),b.textContent=Ce,te=a(),r(g.$$.fragment),se=a(),r(C.$$.fragment),le=a(),I=y("p"),I.textContent=Ie,ae=a(),r($.$$.fragment),ne=a(),r(k.$$.fragment),ie=a(),v=y("p"),v.textContent=ke,oe=a(),r(G.$$.fragment),re=a(),r(Z.$$.fragment),pe=a(),B=y("p"),B.innerHTML=ve,ce=a(),r(x.$$.fragment),de=a(),r(A.$$.fragment),me=a(),X=y("p"),X.innerHTML=Ge,he=a(),r(W.$$.fragment),ye=a(),r(z.$$.fragment),Me=a(),Y=y("p"),Y.innerHTML=Ze,fe=a(),r(F.$$.fragment),ue=a(),r(H.$$.fragment),we=a(),N=y("p"),N.innerHTML=Be,ge=a(),R=y("p"),R.innerHTML=xe,$e=a(),r(Q.$$.fragment),Ue=a(),r(S.$$.fragment),je=a(),L=y("p"),this.h()},l(e){const t=Se("svelte-u9bgzb",document.head);i=M(t,"META",{name:!0,content:!0}),t.forEach(s),u=n(e),o=M(e,"P",{}),We(o).forEach(s),w=n(e),p(U.$$.fragment,e),P=n(e),j=M(e,"P",{"data-svelte-h":!0}),f(j)!=="svelte-ddezg0"&&(j.textContent=Je),K=n(e),T=M(e,"P",{"data-svelte-h":!0}),f(T)!=="svelte-15mf0bm"&&(T.textContent=_e),D=n(e),p(J.$$.fragment,e),O=n(e),_=M(e,"P",{"data-svelte-h":!0}),f(_)!=="svelte-19k5yf4"&&(_.textContent=be),ee=n(e),b=M(e,"P",{"data-svelte-h":!0}),f(b)!=="svelte-8u19qz"&&(b.textContent=Ce),te=n(e),p(g.$$.fragment,e),se=n(e),p(C.$$.fragment,e),le=n(e),I=M(e,"P",{"data-svelte-h":!0}),f(I)!=="svelte-g4t7z"&&(I.textContent=Ie),ae=n(e),p($.$$.fragment,e),ne=n(e),p(k.$$.fragment,e),ie=n(e),v=M(e,"P",{"data-svelte-h":!0}),f(v)!=="svelte-mg8wl6"&&(v.textContent=ke),oe=n(e),p(G.$$.fragment,e),re=n(e),p(Z.$$.fragment,e),pe=n(e),B=M(e,"P",{"data-svelte-h":!0}),f(B)!=="svelte-gpwub8"&&(B.innerHTML=ve),ce=n(e),p(x.$$.fragment,e),de=n(e),p(A.$$.fragment,e),me=n(e),X=M(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-yeso4z"&&(X.innerHTML=Ge),he=n(e),p(W.$$.fragment,e),ye=n(e),p(z.$$.fragment,e),Me=n(e),Y=M(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-n7gycq"&&(Y.innerHTML=Ze),fe=n(e),p(F.$$.fragment,e),ue=n(e),p(H.$$.fragment,e),we=n(e),N=M(e,"P",{"data-svelte-h":!0}),f(N)!=="svelte-j7zjkt"&&(N.innerHTML=Be),ge=n(e),R=M(e,"P",{"data-svelte-h":!0}),f(R)!=="svelte-15vfvzs"&&(R.innerHTML=xe),$e=n(e),p(Q.$$.fragment,e),Ue=n(e),p(S.$$.fragment,e),je=n(e),L=M(e,"P",{}),We(L).forEach(s),this.h()},h(){ze(i,"name","hf:doc:metadata"),ze(i,"content",Ke)},m(e,t){Ve(document.head,i),l(e,u,t),l(e,o,t),l(e,w,t),c(U,e,t),l(e,P,t),l(e,j,t),l(e,K,t),l(e,T,t),l(e,D,t),c(J,e,t),l(e,O,t),l(e,_,t),l(e,ee,t),l(e,b,t),l(e,te,t),c(g,e,t),l(e,se,t),c(C,e,t),l(e,le,t),l(e,I,t),l(e,ae,t),c($,e,t),l(e,ne,t),c(k,e,t),l(e,ie,t),l(e,v,t),l(e,oe,t),c(G,e,t),l(e,re,t),c(Z,e,t),l(e,pe,t),l(e,B,t),l(e,ce,t),c(x,e,t),l(e,de,t),c(A,e,t),l(e,me,t),l(e,X,t),l(e,he,t),c(W,e,t),l(e,ye,t),c(z,e,t),l(e,Me,t),l(e,Y,t),l(e,fe,t),c(F,e,t),l(e,ue,t),c(H,e,t),l(e,we,t),l(e,N,t),l(e,ge,t),l(e,R,t),l(e,$e,t),c(Q,e,t),l(e,Ue,t),c(S,e,t),l(e,je,t),l(e,L,t),Te=!0},p(e,[t]){const Ae={};t&2&&(Ae.$$scope={dirty:t,ctx:e}),g.$set(Ae);const Xe={};t&2&&(Xe.$$scope={dirty:t,ctx:e}),$.$set(Xe)},i(e){Te||(d(U.$$.fragment,e),d(J.$$.fragment,e),d(g.$$.fragment,e),d(C.$$.fragment,e),d($.$$.fragment,e),d(k.$$.fragment,e),d(G.$$.fragment,e),d(Z.$$.fragment,e),d(x.$$.fragment,e),d(A.$$.fragment,e),d(W.$$.fragment,e),d(z.$$.fragment,e),d(F.$$.fragment,e),d(H.$$.fragment,e),d(Q.$$.fragment,e),d(S.$$.fragment,e),Te=!0)},o(e){m(U.$$.fragment,e),m(J.$$.fragment,e),m(g.$$.fragment,e),m(C.$$.fragment,e),m($.$$.fragment,e),m(k.$$.fragment,e),m(G.$$.fragment,e),m(Z.$$.fragment,e),m(x.$$.fragment,e),m(A.$$.fragment,e),m(W.$$.fragment,e),m(z.$$.fragment,e),m(F.$$.fragment,e),m(H.$$.fragment,e),m(Q.$$.fragment,e),m(S.$$.fragment,e),Te=!1},d(e){e&&(s(u),s(o),s(w),s(P),s(j),s(K),s(T),s(D),s(O),s(_),s(ee),s(b),s(te),s(se),s(le),s(I),s(ae),s(ne),s(ie),s(v),s(oe),s(re),s(pe),s(B),s(ce),s(de),s(me),s(X),s(he),s(ye),s(Me),s(Y),s(fe),s(ue),s(we),s(N),s(ge),s(R),s($e),s(Ue),s(je),s(L)),s(i),h(U,e),h(J,e),h(g,e),h(C,e),h($,e),h(k,e),h(G,e),h(Z,e),h(x,e),h(A,e),h(W,e),h(z,e),h(F,e),h(H,e),h(Q,e),h(S,e)}}}const Ke='{"title":"Deferring Executions","local":"deferring-executions","sections":[{"title":"Downloading a Dataset","local":"downloading-a-dataset","sections":[],"depth":2},{"title":"Saving the state_dict","local":"saving-the-statedict","sections":[],"depth":2},{"title":"Loading in the state_dict","local":"loading-in-the-statedict","sections":[],"depth":2},{"title":"Applying a multi-worker CPU operation","local":"applying-a-multi-worker-cpu-operation","sections":[],"depth":2},{"title":"Applying checks such as Early Stopping","local":"applying-checks-such-as-early-stopping","sections":[],"depth":2}],"depth":1}';function De(E){return Ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class at extends Re{constructor(i){super(),Qe(this,i,De,Pe,He,{})}}export{at as component};
