import{s as Ys,o as Hs,n as A}from"../chunks/scheduler.37c15a92.js";import{S as zs,i as Ns,g as $,s as a,r,A as Fs,h as u,f as l,c as n,j as Rs,u as i,x as y,k as As,y as Es,a as s,v as m,d as o,t as c,w as M,m as Qs,n as Ls}from"../chunks/index.2bf4358c.js";import{T as Z}from"../chunks/Tip.363c041f.js";import{Y as Vs}from"../chunks/Youtube.1e50a667.js";import{C as j}from"../chunks/CodeBlock.4e987730.js";import{C as Ss}from"../chunks/CourseFloatingBanner.9ff4c771.js";import{Q as ot}from"../chunks/Question.668688bc.js";import{H as C,E as qs}from"../chunks/getInferenceSnippets.80a69898.js";function Ps(h){let p,w='🏗️ <strong>처음부터 훈련하기</strong>: 이 섹션은 이전 내용을 기반으로 합니다. PyTorch 훈련 루프와 모범 사례에 대한 포괄적인 가이드는 <a href="https://huggingface.co/docs/transformers/main/en/training#train-in-native-pytorch" rel="nofollow">🤗 Transformers 훈련 문서</a>와 <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_code_llm_on_single_gpu#model" rel="nofollow">커스텀 훈련 쿡북</a>을 확인하세요.';return{c(){p=$("p"),p.innerHTML=w},l(f){p=u(f,"P",{"data-svelte-h":!0}),y(p)!=="svelte-3cst5z"&&(p.innerHTML=w)},m(f,d){s(f,p,d)},p:A,d(f){f&&l(p)}}}function Ks(h){let p,w="💡 <strong>최신 최적화 팁</strong>: 더 나은 성능을 위해 다음을 시도해볼 수 있습니다.",f,d,U="<li><strong>가중치 감소가 있는 AdamW</strong>: <code>AdamW(model.parameters(), lr=5e-5, weight_decay=0.01)</code></li> <li><strong>8비트 Adam</strong>: 메모리 효율적인 최적화를 위해 <code>bitsandbytes</code> 사용</li> <li><strong>다른 학습률</strong>: 대형 모델에서는 더 낮은 학습률(1e-5 ~ 3e-5)이 종종 더 잘 작동</li>",J,T,_='🚀 <strong>최적화 리소스</strong>: 옵티마이저와 훈련 전략에 대해 자세히 알아보려면 <a href="https://huggingface.co/docs/transformers/main/en/performance#optimizer" rel="nofollow">🤗 Transformers 최적화 가이드</a>를 참조하세요.';return{c(){p=$("p"),p.innerHTML=w,f=a(),d=$("ul"),d.innerHTML=U,J=a(),T=$("p"),T.innerHTML=_},l(b){p=u(b,"P",{"data-svelte-h":!0}),y(p)!=="svelte-qa0e6e"&&(p.innerHTML=w),f=n(b),d=u(b,"UL",{"data-svelte-h":!0}),y(d)!=="svelte-8cjg60"&&(d.innerHTML=U),J=n(b),T=u(b,"P",{"data-svelte-h":!0}),y(T)!=="svelte-1tj9tyf"&&(T.innerHTML=_)},m(b,g){s(b,p,g),s(b,f,g),s(b,d,g),s(b,J,g),s(b,T,g)},p:A,d(b){b&&(l(p),l(f),l(d),l(J),l(T))}}}function Ds(h){let p,w="💡 <strong>최신 훈련 최적화</strong>: 훈련 루프를 더욱 효율적으로 만들려면 다음을 고려하세요.",f,d,U="<li><strong>그래디언트 클리핑</strong>: <code>optimizer.step()</code> 전에 <code>torch.nn.utils.clip_grad_norm_(model.parameters(), max_norm=1.0)</code> 추가</li> <li><strong>혼합 정밀도</strong>: 더 빠른 훈련을 위해 <code>torch.cuda.amp.autocast()</code>와 <code>GradScaler</code> 사용</li> <li><strong>그래디언트 누적</strong>: 여러 배치에 걸쳐 그래디언트를 누적하여 더 큰 배치 크기 시뮬레이션</li> <li><strong>체크포인팅</strong>: 훈련이 중단될 경우를 대비해 주기적으로 모델 체크포인트 저장</li>",J,T,_='🔧 <strong>구현 가이드</strong>: 이러한 최적화의 자세한 예제는 <a href="https://huggingface.co/docs/transformers/main/en/perf_train_gpu_one" rel="nofollow">🤗 Transformers 효율적인 훈련 가이드</a>와 <a href="https://huggingface.co/docs/transformers/main/en/optimizers" rel="nofollow">다양한 옵티마이저</a>를 참조하세요.';return{c(){p=$("p"),p.innerHTML=w,f=a(),d=$("ul"),d.innerHTML=U,J=a(),T=$("p"),T.innerHTML=_},l(b){p=u(b,"P",{"data-svelte-h":!0}),y(p)!=="svelte-11sgwl6"&&(p.innerHTML=w),f=n(b),d=u(b,"UL",{"data-svelte-h":!0}),y(d)!=="svelte-k3m4er"&&(d.innerHTML=U),J=n(b),T=u(b,"P",{"data-svelte-h":!0}),y(T)!=="svelte-zgfzjm"&&(T.innerHTML=_)},m(b,g){s(b,p,g),s(b,f,g),s(b,d,g),s(b,J,g),s(b,T,g)},p:A,d(b){b&&(l(p),l(f),l(d),l(J),l(T))}}}function Os(h){let p,w='📊 <strong>평가 모범 사례</strong>: 더 정교한 평가 전략과 메트릭에 대해서는 <a href="https://huggingface.co/docs/evaluate/" rel="nofollow">🤗 Evaluate 문서</a>와 <a href="https://github.com/huggingface/evaluation-guidebook" rel="nofollow">평가 실무 가이드</a>를 살펴보세요.';return{c(){p=$("p"),p.innerHTML=w},l(f){p=u(f,"P",{"data-svelte-h":!0}),y(p)!=="svelte-12fj1ch"&&(p.innerHTML=w)},m(f,d){s(f,p,d)},p:A,d(f){f&&l(p)}}}function ea(h){let p,w="✏️ <strong>직접 해보세요!</strong> 이전 훈련 루프를 수정하여 SST-2 데이터셋에서 모델을 미세 조정해보세요.";return{c(){p=$("p"),p.innerHTML=w},l(f){p=u(f,"P",{"data-svelte-h":!0}),y(p)!=="svelte-vanit2"&&(p.innerHTML=w)},m(f,d){s(f,p,d)},p:A,d(f){f&&l(p)}}}function ta(h){let p,w='⚡ <strong>Accelerate 심화</strong>: 분산 훈련, 혼합 정밀도, 하드웨어 최적화에 대한 모든 것을 <a href="https://huggingface.co/docs/accelerate/" rel="nofollow">🤗 Accelerate 문서</a>에서 알아보고 <a href="https://huggingface.co/docs/transformers/main/en/accelerate" rel="nofollow">transformers 문서</a>에서 실용적인 예제를 살펴보세요.';return{c(){p=$("p"),p.innerHTML=w},l(f){p=u(f,"P",{"data-svelte-h":!0}),y(p)!=="svelte-1kzd8th"&&(p.innerHTML=w)},m(f,d){s(f,p,d)},p:A,d(f){f&&l(p)}}}function la(h){let p;return{c(){p=Qs('⚠️ Cloud TPU가 제공하는 속도 향상의 이점을 얻으려면 토크나이저의 `padding="max_length"` 및 `max_length` 인수로 샘플을 고정 길이로 패딩하는 것을 권장합니다.')},l(w){p=Ls(w,'⚠️ Cloud TPU가 제공하는 속도 향상의 이점을 얻으려면 토크나이저의 `padding="max_length"` 및 `max_length` 인수로 샘플을 고정 길이로 패딩하는 것을 권장합니다.')},m(w,f){s(w,p,f)},d(w){w&&l(p)}}}function sa(h){let p,w='🌐 <strong>분산 훈련</strong>: 다중 GPU 및 다중 노드 훈련에 대한 포괄적인 내용은 <a href="https://huggingface.co/docs/transformers/main/en/perf_train_gpu_many" rel="nofollow">🤗 Transformers 분산 훈련 가이드</a>와 <a href="https://huggingface.co/docs/transformers/main/en/accelerate" rel="nofollow">훈련 확장 쿡북</a>을 확인하세요.';return{c(){p=$("p"),p.innerHTML=w},l(f){p=u(f,"P",{"data-svelte-h":!0}),y(p)!=="svelte-kxykmq"&&(p.innerHTML=w)},m(f,d){s(f,p,d)},p:A,d(f){f&&l(p)}}}function aa(h){let p,w="💡 <strong>핵심 요점:</strong>",f,d,U="<li>수동 훈련 루프는 완전한 제어를 제공하지만 적절한 순서에 대한 이해가 필요합니다: 순전파 → 역전파 → 옵티마이저 단계 → 스케줄러 단계 → 그래디언트 초기화</li> <li>가중치 감소가 있는 AdamW는 트랜스포머 모델에 권장되는 옵티마이저입니다.</li> <li>올바른 동작과 효율성을 위해 평가 중에는 항상 <code>model.eval()</code>과 <code>torch.no_grad()</code>를 사용하세요.</li> <li>🤗 Accelerate는 최소한의 코드 변경으로 분산 훈련을 접근 가능하게 만듭니다.</li> <li>장치 관리(GPU/CPU로 텐서 이동)는 PyTorch 연산에 중요합니다.</li> <li>혼합 정밀도, 그래디언트 누적, 그래디언트 클리핑과 같은 최신 기법은 훈련 효율성을 크게 향상시킬 수 있습니다.</li>";return{c(){p=$("p"),p.innerHTML=w,f=a(),d=$("ul"),d.innerHTML=U},l(J){p=u(J,"P",{"data-svelte-h":!0}),y(p)!=="svelte-3aouuq"&&(p.innerHTML=w),f=n(J),d=u(J,"UL",{"data-svelte-h":!0}),y(d)!=="svelte-1xnchz6"&&(d.innerHTML=U)},m(J,T){s(J,p,T),s(J,f,T),s(J,d,T)},p:A,d(J){J&&(l(p),l(f),l(d))}}}function na(h){let p,w,f,d,U,J,T,_,b,g,V,Ll="이제 <code>Trainer</code> 클래스를 사용하지 않고 최신 PyTorch 모범 사례를 활용해 처음부터 훈련 루프를 구현하여 이전 섹션과 동일한 결과를 얻는 방법을 알아보겠습니다. 이전과 마찬가지로 섹션 2에서 데이터 처리를 완료했다고 가정하고 진행하겠습니다. 필요한 모든 내용을 담은 간단한 요약은 다음과 같습니다.",Mt,k,ft,Y,$t,H,ut,z,Sl="실제로 훈련 루프를 작성하기 전에 몇 가지 객체를 정의해야 합니다. 첫 번째는 배치를 반복하는 데 사용할 데이터로더입니다. 하지만 이러한 데이터로더를 정의하기 전에 <code>tokenized_datasets</code>에 약간의 후처리를 적용해야 합니다. 이는 <code>Trainer</code>가 자동으로 수행했던 작업들을 직접 처리하기 위해서입니다. 구체적으로 다음과 같은 작업이 필요합니다.",yt,N,ql="<li>모델이 예상하지 않는 값에 해당하는 컬럼을 제거합니다(<code>sentence1</code> 및 <code>sentence2</code> 컬럼 등).</li> <li><code>label</code> 컬럼을 <code>labels</code>로 이름을 변경합니다(모델이 인수 이름을 <code>labels</code>로 예상하기 때문입니다).</li> <li>데이터셋 형식을 설정하여 리스트 대신 PyTorch 텐서를 반환하도록 합니다.</li>",dt,F,Pl="<code>tokenized_datasets</code>에는 이러한 각 단계에 대한 메서드가 있습니다.",bt,E,wt,Q,Kl="그런 다음 결과에 모델이 허용할 컬럼만 있는지 확인할 수 있습니다.",Tt,L,Jt,S,Dl="이제 이 작업들이 완료되었으니 데이터로더를 정의해보겠습니다.",jt,q,ht,P,Ol="데이터 처리가 제대로 되었는지 확인하기 위해 배치를 한번 살펴보겠습니다.",Ut,K,gt,D,Ct,O,es="훈련 데이터로더에 대해 <code>shuffle=True</code>를 설정하고 배치 내에서 최대 길이까지 패딩하므로 실제 모양은 약간 다를 수 있습니다.",_t,ee,ts="이제 데이터 전처리를 완전히 마쳤습니다(모든 ML 실무자들에게는 만족스럽지만 달성하기 어려운 목표죠!). 다음으로 모델을 준비해보겠습니다. 이전 섹션과 동일한 방식으로 모델을 인스턴스화합니다.",Zt,te,kt,le,ls="훈련 중에 모든 것이 원활하게 진행되도록 하기 위해 배치를 이 모델에 전달합니다.",Gt,se,vt,ae,Bt,ne,ss="모든 🤗 Transformers 모델은 <code>labels</code>가 제공될 때 손실을 반환하며, 로짓도 얻습니다(배치의 각 입력에 대해 2개씩, 따라서 8 x 2 크기의 텐서).",It,pe,as='훈련 루프를 작성할 준비가 거의 완료되었습니다! 옵티마이저와 학습률 스케줄러 두 가지만 빠졌습니다. <code>Trainer</code>가 수행한 작업을 수동으로 복제하려고 하므로 동일한 기본값을 사용하겠습니다. <code>Trainer</code>에서 사용하는 옵티마이저는 <code>AdamW</code>로, 가중치 감소 정규화에 대한 변형이 있는 Adam과 동일합니다(Ilya Loshchilov와 Frank Hutter의 <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">“Decoupled Weight Decay Regularization”</a> 참조)',Wt,re,Xt,G,xt,ie,ns="마지막으로, 기본적으로 사용되는 학습률 스케줄러는 최대값(5e-5)에서 0까지의 선형 감소입니다. 이를 올바르게 정의하려면 수행할 훈련 단계 수를 알아야 하는데, 이는 실행하려는 에포크 수에 훈련 배치 수(훈련 데이터로더의 길이)를 곱한 것입니다. <code>Trainer</code>는 기본적으로 3개의 에포크를 사용하므로 이를 따르겠습니다.",Rt,me,At,oe,Vt,ce,Yt,Me,ps="마지막으로 한 가지 더 고려할 점이 있습니다. GPU를 사용할 수 있다면 GPU를 활용하는 것이 좋습니다(CPU에서는 훈련이 몇 분 대신 몇 시간이 걸릴 수 있거든요). 이를 위해 모델과 배치를 배치할 <code>device</code>를 정의하겠습니다.",Ht,fe,zt,$e,Nt,ue,rs="이제 훈련할 준비가 모두 끝났습니다! 훈련 진행 상황을 확인할 수 있도록 <code>tqdm</code> 라이브러리를 사용해서 진행률 표시줄을 추가해보겠습니다.",Ft,ye,Et,v,Qt,de,is="보시다시피 훈련 루프의 핵심 구조는 소개 부분에서 봤던 것과 매우 유사합니다. 하지만 현재 상태로는 모델의 성능에 대한 정보를 전혀 얻을 수 없습니다. 평가 기능을 요청하지 않았기 때문이죠. 이 문제를 해결하기 위해 평가 루프를 추가해야 합니다.",Lt,be,St,we,ms="이전과 마찬가지로 🤗 Evaluate 라이브러리에서 제공하는 메트릭을 사용하겠습니다. <code>metric.compute()</code> 메서드는 이미 알고 계시죠. 하지만 메트릭에는 또 다른 유용한 기능이 있습니다. <code>add_batch()</code> 메서드를 사용해서 예측 루프를 진행하면서 배치별로 결과를 누적할 수 있습니다. 모든 배치를 처리한 후에 <code>metric.compute()</code>를 호출하면 최종 결과를 얻을 수 있습니다. 평가 루프에서 이를 구현하는 방법을 살펴보겠습니다.",qt,B,Pt,Te,Kt,Je,Dt,je,os="다시 말하지만, 모델 헤드 초기화의 무작위성과 데이터 셔플링으로 인해 결과가 약간 다를 수 있지만 같은 수준이어야 합니다.",Ot,I,el,he,tl,Ue,ll,ge,cs='앞서 정의한 훈련 루프는 단일 CPU 또는 GPU에서 잘 작동합니다. 하지만 <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a> 라이브러리를 사용하면 몇 가지 조정만으로 여러 GPU 또는 TPU에서 분산 훈련을 활성화할 수 있습니다. 🤗 Accelerate는 분산 훈련, 혼합 정밀도, 장치 배치의 복잡성을 자동으로 처리합니다. 훈련 및 검증 데이터로더 생성부터 시작하여 수동 훈련 루프는 다음과 같습니다.',sl,W,al,Ce,nl,_e,Ms="추가할 첫 번째 줄은 import 줄입니다. 두 번째 줄은 환경을 살펴보고 적절한 분산 설정을 초기화하는 <code>Accelerator</code> 객체를 인스턴스화합니다. 🤗 Accelerate는 장치 배치를 처리하므로 모델을 장치에 올리는 줄을 제거할 수 있습니다(또는 원한다면 <code>device</code> 대신 <code>accelerator.device</code>를 사용하도록 변경할 수 있습니다).",pl,Ze,fs="그런 다음 주요 작업은 데이터로더, 모델, 옵티마이저를 <code>accelerator.prepare()</code>에 보내는 줄에서 수행됩니다. 이는 분산 훈련이 의도한 대로 작동하도록 적절한 컨테이너에서 해당 객체들을 래핑합니다. 수행해야 할 나머지 변경 사항은 배치를 <code>device</code>에 올리는 줄을 제거하고(다시, 유지하고 싶다면 <code>accelerator.device</code>를 사용하도록 변경하기만 하면 됩니다) <code>loss.backward()</code>를 <code>accelerator.backward(loss)</code>로 바꾸는 것입니다.",rl,X,il,ke,$s="복사해서 가지고 놀고 싶다면 🤗 Accelerate를 사용한 완전한 훈련 루프는 다음과 같습니다.",ml,Ge,ol,ve,us="이것을 <code>train.py</code> 스크립트에 넣으면 모든 종류의 분산 설정에서 실행할 수 있는 스크립트가 됩니다. 분산 설정에서 시도해보려면 다음 명령을 실행하세요.",cl,Be,Ml,Ie,ys="이 명령은 몇 가지 질문에 답하라는 메시지를 표시하고 다음 명령에서 사용되는 구성 파일에 답변을 덤프합니다.",fl,We,$l,Xe,ds="이 명령이 분산 훈련을 시작합니다.",ul,xe,bs="노트북에서 이를 시도하고 싶다면(예: Colab에서 TPU로 테스트하기 위해) 코드를 <code>training_function()</code>에 붙여넣고 다음과 함께 마지막 셀을 실행하기만 하면 됩니다.",yl,Re,dl,Ae,ws='<a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 Accelerate 리포지토리</a>에서 더 많은 예제를 찾을 수 있습니다.',bl,x,wl,Ve,Tl,Ye,Ts="이제 처음부터 훈련을 구현하는 방법을 배웠으므로 프로덕션 사용을 위한 몇 가지 추가 고려사항이 있습니다.",Jl,He,Js="<strong>모델 평가</strong>: 정확도뿐만 아니라 여러 메트릭에서 항상 모델을 평가하세요. 포괄적인 평가를 위해 🤗 Evaluate 라이브러리를 사용하세요.",jl,ze,js="<strong>하이퍼파라미터 튜닝</strong>: 체계적인 하이퍼파라미터 최적화를 위해 Optuna 또는 Ray Tune과 같은 라이브러리 사용을 고려하세요.",hl,Ne,hs="<strong>모델 모니터링</strong>: 훈련 전반에 걸쳐 훈련 메트릭, 학습 곡선, 검증 성능을 추적하세요.",Ul,Fe,Us="<strong>모델 공유</strong>: 훈련이 완료되면 커뮤니티에서 사용할 수 있도록 Hugging Face Hub에서 모델을 공유하세요.",gl,Ee,gs="<strong>효율성</strong>: 대형 모델의 경우 그래디언트 체크포인팅, 매개변수 효율적인 미세 조정(LoRA, AdaLoRA), 양자화 방법과 같은 기술을 고려하세요.",Cl,Qe,Cs="이것으로 커스텀 훈련 루프를 사용한 미세 조정에 대한 심화 과정을 마칩니다. 여기서 배운 기술들은 훈련 프로세스에 대한 완전한 제어가 필요하거나 <code>Trainer</code> API가 제공하는 것을 넘어서는 커스텀 훈련 로직을 구현하고자 할 때 도움이 될 것입니다.",_l,Le,Zl,Se,_s="커스텀 훈련 루프와 고급 훈련 기법에 대한 이해를 테스트해보세요.",kl,qe,Gl,Pe,vl,Ke,Bl,De,Il,Oe,Wl,et,Xl,tt,xl,lt,Rl,st,Al,at,Vl,nt,Yl,pt,Hl,rt,zl,it,Nl,R,Fl,mt,El,ct,Ql;return U=new C({props:{title:"처음부터 구현하는 훈련 루프",local:"a-full-training-loop",headingTag:"h1"}}),T=new Ss({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"}]}}),b=new Vs({props:{id:"Dh9CL8fyG80"}}),k=new Z({props:{$$slots:{default:[Ps]},$$scope:{ctx:h}}}),Y=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),H=new C({props:{title:"훈련 준비",local:"prepare-for-training",headingTag:"h3"}}),E=new j({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),L=new j({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),q=new j({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),K=new j({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),D=new j({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),te=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),se=new j({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),ae=new j({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),re=new j({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),G=new Z({props:{$$slots:{default:[Ks]},$$scope:{ctx:h}}}),me=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),oe=new j({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),ce=new C({props:{title:"훈련 루프",local:"the-training-loop",headingTag:"h3"}}),fe=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),$e=new j({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),ye=new j({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),v=new Z({props:{$$slots:{default:[Ds]},$$scope:{ctx:h}}}),be=new C({props:{title:"평가 루프",local:"the-evaluation-loop",headingTag:"h3"}}),B=new Z({props:{$$slots:{default:[Os]},$$scope:{ctx:h}}}),Te=new j({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),Je=new j({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),I=new Z({props:{$$slots:{default:[ea]},$$scope:{ctx:h}}}),he=new C({props:{title:"🤗 Accelerate로 훈련 루프 강화하기",local:"supercharge-your-training-loop-with-accelerate",headingTag:"h3"}}),Ue=new Vs({props:{id:"s7dy8QRgjJ0"}}),W=new Z({props:{$$slots:{default:[ta]},$$scope:{ctx:h}}}),Ce=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),X=new Z({props:{$$slots:{default:[la]},$$scope:{ctx:h}}}),Ge=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),Be=new j({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),We=new j({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),Re=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),x=new Z({props:{$$slots:{default:[sa]},$$scope:{ctx:h}}}),Ve=new C({props:{title:"다음 단계와 모범 사례",local:"next-steps-and-best-practices",headingTag:"h3"}}),Le=new C({props:{title:"섹션 퀴즈",local:"section-quiz",headingTag:"h2"}}),qe=new C({props:{title:"1. Adam과 AdamW 옵티마이저의 주요 차이점은 무엇인가요?",local:"1-adam과-adamw-옵티마이저의-주요-차이점은-무엇인가요",headingTag:"h3"}}),Pe=new ot({props:{choices:[{text:"AdamW는 다른 학습률 스케줄을 사용합니다.",explain:"학습률 스케줄링은 옵티마이저 선택과 별개입니다."},{text:"AdamW는 분리된 가중치 감소 정규화를 포함합니다.",explain:"정답입니다! AdamW는 가중치 감소를 그래디언트 기반 매개변수 업데이트와 분리하여 더 나은 정규화를 제공합니다.",correct:!0},{text:"AdamW는 트랜스포머 모델에서만 작동합니다.",explain:"AdamW는 트랜스포머뿐만 아니라 모든 모델 아키텍처에 사용할 수 있습니다."},{text:"AdamW는 Adam보다 메모리를 적게 사용합니다.",explain:"두 옵티마이저 모두 비슷한 메모리 요구사항을 가집니다."}]}}),Ke=new C({props:{title:"2. 훈련 루프에서 올바른 연산 순서는 무엇인가요?",local:"2-훈련-루프에서-올바른-연산-순서는-무엇인가요",headingTag:"h3"}}),De=new ot({props:{choices:[{text:"순전파 → 역전파 → 옵티마이저 단계 → 그래디언트 초기화",explain:"비슷하지만, 이전 그래디언트가 누적되지 않도록 다음 순전파 전에 그래디언트를 초기화해야 합니다."},{text:"순전파 → 역전파 → 옵티마이저 단계 → 스케줄러 단계 → 그래디언트 초기화",explain:"정답입니다! 이것이 올바른 순서입니다: 손실 계산, 그래디언트 계산, 매개변수 업데이트, 학습률 업데이트, 그래디언트 초기화.",correct:!0},{text:"그래디언트 초기화 → 순전파 → 옵티마이저 단계 → 역전파",explain:"역전파는 손실에서 그래디언트를 계산하기 위해 순전파 후에 와야 합니다."},{text:"순전파 → 그래디언트 초기화 → 역전파 → 옵티마이저 단계",explain:"역전파 전에 그래디언트를 초기화하면 방금 계산한 그래디언트가 제거됩니다."}]}}),Oe=new C({props:{title:"3. 🤗 Accelerate 라이브러리는 주로 무엇을 도와주나요?",local:"3--accelerate-라이브러리는-주로-무엇을-도와주나요",headingTag:"h3"}}),et=new ot({props:{choices:[{text:"순전파를 최적화하여 모델 훈련을 더 빠르게 만듭니다.",explain:"Accelerate는 모델 아키텍처 자체를 최적화하지 않습니다."},{text:"최적의 하이퍼파라미터를 자동으로 선택합니다.",explain:"Accelerate는 하이퍼파라미터 최적화를 수행하지 않습니다."},{text:"최소한의 코드 변경으로 여러 GPU/TPU에서 분산 훈련을 가능하게 합니다.",explain:"정답입니다! Accelerate는 분산 훈련 복잡성을 처리하여 단일 또는 다중 장치에서 원활하게 코드를 실행할 수 있게 해줍니다.",correct:!0},{text:"모델을 TensorFlow와 같은 다른 프레임워크로 변환합니다.",explain:"Accelerate는 PyTorch 내에서 작동하며 프레임워크 간 변환을 하지 않습니다."}]}}),tt=new C({props:{title:"4. 훈련 루프에서 배치를 장치로 이동하는 이유는 무엇인가요?",local:"4-훈련-루프에서-배치를-장치로-이동하는-이유는-무엇인가요",headingTag:"h3"}}),lt=new ot({props:{choices:[{text:"훈련을 더 빠르게 만들기 위해서입니다.",explain:"속도에 영향을 줄 수 있지만, 주된 이유는 호환성입니다."},{text:"모델과 데이터가 연산을 위해 동일한 장치(CPU/GPU)에 있어야 하기 때문입니다.",explain:"정답입니다! PyTorch는 연산이 작동하려면 텐서가 동일한 장치에 있어야 합니다.",correct:!0},{text:"메모리를 절약하기 위해서입니다.",explain:"장치로 이동하는 것 자체가 메모리를 절약하지는 않습니다."},{text:"DataLoader에서 요구하기 때문입니다.",explain:"DataLoader는 특정 장치 배치를 요구하지 않습니다."}]}}),st=new C({props:{title:"5. 평가 전에 model.eval() 은 무엇을 하나요?",local:"5-평가-전에-modeleval-은-무엇을-하나요",headingTag:"h3"}}),at=new ot({props:{choices:[{text:"모델 매개변수를 고정하여 업데이트되지 않도록 합니다.",explain:"model.eval()은 매개변수를 고정하지 않습니다 - 그것은 requires_grad=False로 설정하는 것입니다."},{text:"드롭아웃 및 배치 정규화와 같은 레이어의 동작을 추론용으로 변경합니다.",explain:"정답입니다! eval() 모드는 드롭아웃을 비활성화하고 현재 배치에서 계산하는 대신 배치 정규화에 실행 통계를 사용합니다.",correct:!0},{text:"평가 메트릭을 위한 그래디언트 계산을 활성화합니다.",explain:"실제로는 평가 중에 그래디언트 계산을 비활성화하기 위해 torch.no_grad()를 일반적으로 사용합니다."},{text:"평가 메트릭을 자동으로 계산합니다.",explain:"model.eval()은 레이어 동작만 변경합니다 - 메트릭 계산은 별도로 구현해야 합니다."}]}}),nt=new C({props:{title:"6. 평가 중 torch.no_grad() 의 목적은 무엇인가요?",local:"6-평가-중-torchnograd-의-목적은-무엇인가요",headingTag:"h3"}}),pt=new ot({props:{choices:[{text:"모델이 예측을 하지 못하도록 방지합니다.",explain:"torch.no_grad()는 예측을 방지하지 않고 그래디언트 계산만 방지합니다."},{text:"그래디언트 추적을 비활성화하여 메모리를 절약하고 계산을 가속화합니다.",explain:"정답입니다! 평가에는 그래디언트가 필요하지 않으므로 비활성화하면 메모리와 계산을 절약합니다.",correct:!0},{text:"모델의 평가 모드를 활성화합니다.",explain:"평가 모드는 torch.no_grad()가 아닌 model.eval()로 활성화됩니다."},{text:"실행 간 일관된 결과를 보장합니다.",explain:"재현성은 torch.no_grad()가 아닌 랜덤 시드 설정으로 처리됩니다."}]}}),rt=new C({props:{title:"7. 훈련 루프에서 🤗 Accelerate를 사용할 때 무엇이 변경되나요?",local:"7-훈련-루프에서--accelerate를-사용할-때-무엇이-변경되나요",headingTag:"h3"}}),it=new ot({props:{choices:[{text:"전체 훈련 루프를 처음부터 다시 작성해야 합니다.",explain:"Accelerate는 기존 PyTorch 코드에 최소한의 변경만 필요합니다."},{text:"accelerator.prepare()로 주요 객체를 래핑하고 loss.backward() 대신 accelerator.backward()를 사용합니다.",explain:"정답입니다! 이것들이 주요 변경사항입니다 - 객체를 준비하고 적절한 분산 훈련을 위해 accelerator.backward()를 사용합니다.",correct:!0},{text:"코드에서 GPU 수를 지정해야 합니다.",explain:"Accelerate는 사용 가능한 하드웨어를 자동으로 감지합니다."},{text:"다른 옵티마이저와 스케줄러를 사용해야 합니다.",explain:"Accelerate와 함께 동일한 옵티마이저와 스케줄러를 사용할 수 있습니다."}]}}),R=new Z({props:{$$slots:{default:[aa]},$$scope:{ctx:h}}}),mt=new qs({props:{source:"https://github.com/huggingface/course/blob/main/chapters/ko/chapter3/4.mdx"}}),{c(){p=$("meta"),w=a(),f=$("p"),d=a(),r(U.$$.fragment),J=a(),r(T.$$.fragment),_=a(),r(b.$$.fragment),g=a(),V=$("p"),V.innerHTML=Ll,Mt=a(),r(k.$$.fragment),ft=a(),r(Y.$$.fragment),$t=a(),r(H.$$.fragment),ut=a(),z=$("p"),z.innerHTML=Sl,yt=a(),N=$("ul"),N.innerHTML=ql,dt=a(),F=$("p"),F.innerHTML=Pl,bt=a(),r(E.$$.fragment),wt=a(),Q=$("p"),Q.textContent=Kl,Tt=a(),r(L.$$.fragment),Jt=a(),S=$("p"),S.textContent=Dl,jt=a(),r(q.$$.fragment),ht=a(),P=$("p"),P.textContent=Ol,Ut=a(),r(K.$$.fragment),gt=a(),r(D.$$.fragment),Ct=a(),O=$("p"),O.innerHTML=es,_t=a(),ee=$("p"),ee.textContent=ts,Zt=a(),r(te.$$.fragment),kt=a(),le=$("p"),le.textContent=ls,Gt=a(),r(se.$$.fragment),vt=a(),r(ae.$$.fragment),Bt=a(),ne=$("p"),ne.innerHTML=ss,It=a(),pe=$("p"),pe.innerHTML=as,Wt=a(),r(re.$$.fragment),Xt=a(),r(G.$$.fragment),xt=a(),ie=$("p"),ie.innerHTML=ns,Rt=a(),r(me.$$.fragment),At=a(),r(oe.$$.fragment),Vt=a(),r(ce.$$.fragment),Yt=a(),Me=$("p"),Me.innerHTML=ps,Ht=a(),r(fe.$$.fragment),zt=a(),r($e.$$.fragment),Nt=a(),ue=$("p"),ue.innerHTML=rs,Ft=a(),r(ye.$$.fragment),Et=a(),r(v.$$.fragment),Qt=a(),de=$("p"),de.textContent=is,Lt=a(),r(be.$$.fragment),St=a(),we=$("p"),we.innerHTML=ms,qt=a(),r(B.$$.fragment),Pt=a(),r(Te.$$.fragment),Kt=a(),r(Je.$$.fragment),Dt=a(),je=$("p"),je.textContent=os,Ot=a(),r(I.$$.fragment),el=a(),r(he.$$.fragment),tl=a(),r(Ue.$$.fragment),ll=a(),ge=$("p"),ge.innerHTML=cs,sl=a(),r(W.$$.fragment),al=a(),r(Ce.$$.fragment),nl=a(),_e=$("p"),_e.innerHTML=Ms,pl=a(),Ze=$("p"),Ze.innerHTML=fs,rl=a(),r(X.$$.fragment),il=a(),ke=$("p"),ke.textContent=$s,ml=a(),r(Ge.$$.fragment),ol=a(),ve=$("p"),ve.innerHTML=us,cl=a(),r(Be.$$.fragment),Ml=a(),Ie=$("p"),Ie.textContent=ys,fl=a(),r(We.$$.fragment),$l=a(),Xe=$("p"),Xe.textContent=ds,ul=a(),xe=$("p"),xe.innerHTML=bs,yl=a(),r(Re.$$.fragment),dl=a(),Ae=$("p"),Ae.innerHTML=ws,bl=a(),r(x.$$.fragment),wl=a(),r(Ve.$$.fragment),Tl=a(),Ye=$("p"),Ye.textContent=Ts,Jl=a(),He=$("p"),He.innerHTML=Js,jl=a(),ze=$("p"),ze.innerHTML=js,hl=a(),Ne=$("p"),Ne.innerHTML=hs,Ul=a(),Fe=$("p"),Fe.innerHTML=Us,gl=a(),Ee=$("p"),Ee.innerHTML=gs,Cl=a(),Qe=$("p"),Qe.innerHTML=Cs,_l=a(),r(Le.$$.fragment),Zl=a(),Se=$("p"),Se.textContent=_s,kl=a(),r(qe.$$.fragment),Gl=a(),r(Pe.$$.fragment),vl=a(),r(Ke.$$.fragment),Bl=a(),r(De.$$.fragment),Il=a(),r(Oe.$$.fragment),Wl=a(),r(et.$$.fragment),Xl=a(),r(tt.$$.fragment),xl=a(),r(lt.$$.fragment),Rl=a(),r(st.$$.fragment),Al=a(),r(at.$$.fragment),Vl=a(),r(nt.$$.fragment),Yl=a(),r(pt.$$.fragment),Hl=a(),r(rt.$$.fragment),zl=a(),r(it.$$.fragment),Nl=a(),r(R.$$.fragment),Fl=a(),r(mt.$$.fragment),El=a(),ct=$("p"),this.h()},l(e){const t=Fs("svelte-u9bgzb",document.head);p=u(t,"META",{name:!0,content:!0}),t.forEach(l),w=n(e),f=u(e,"P",{}),Rs(f).forEach(l),d=n(e),i(U.$$.fragment,e),J=n(e),i(T.$$.fragment,e),_=n(e),i(b.$$.fragment,e),g=n(e),V=u(e,"P",{"data-svelte-h":!0}),y(V)!=="svelte-147ubkh"&&(V.innerHTML=Ll),Mt=n(e),i(k.$$.fragment,e),ft=n(e),i(Y.$$.fragment,e),$t=n(e),i(H.$$.fragment,e),ut=n(e),z=u(e,"P",{"data-svelte-h":!0}),y(z)!=="svelte-1rabmk1"&&(z.innerHTML=Sl),yt=n(e),N=u(e,"UL",{"data-svelte-h":!0}),y(N)!=="svelte-1omicw3"&&(N.innerHTML=ql),dt=n(e),F=u(e,"P",{"data-svelte-h":!0}),y(F)!=="svelte-153nlsq"&&(F.innerHTML=Pl),bt=n(e),i(E.$$.fragment,e),wt=n(e),Q=u(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-12e33ed"&&(Q.textContent=Kl),Tt=n(e),i(L.$$.fragment,e),Jt=n(e),S=u(e,"P",{"data-svelte-h":!0}),y(S)!=="svelte-14gj2r6"&&(S.textContent=Dl),jt=n(e),i(q.$$.fragment,e),ht=n(e),P=u(e,"P",{"data-svelte-h":!0}),y(P)!=="svelte-1eog8g8"&&(P.textContent=Ol),Ut=n(e),i(K.$$.fragment,e),gt=n(e),i(D.$$.fragment,e),Ct=n(e),O=u(e,"P",{"data-svelte-h":!0}),y(O)!=="svelte-yg35k8"&&(O.innerHTML=es),_t=n(e),ee=u(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-4san5o"&&(ee.textContent=ts),Zt=n(e),i(te.$$.fragment,e),kt=n(e),le=u(e,"P",{"data-svelte-h":!0}),y(le)!=="svelte-15qb75n"&&(le.textContent=ls),Gt=n(e),i(se.$$.fragment,e),vt=n(e),i(ae.$$.fragment,e),Bt=n(e),ne=u(e,"P",{"data-svelte-h":!0}),y(ne)!=="svelte-2yodeu"&&(ne.innerHTML=ss),It=n(e),pe=u(e,"P",{"data-svelte-h":!0}),y(pe)!=="svelte-1t2q6jj"&&(pe.innerHTML=as),Wt=n(e),i(re.$$.fragment,e),Xt=n(e),i(G.$$.fragment,e),xt=n(e),ie=u(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-tap1ht"&&(ie.innerHTML=ns),Rt=n(e),i(me.$$.fragment,e),At=n(e),i(oe.$$.fragment,e),Vt=n(e),i(ce.$$.fragment,e),Yt=n(e),Me=u(e,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-9f8zqb"&&(Me.innerHTML=ps),Ht=n(e),i(fe.$$.fragment,e),zt=n(e),i($e.$$.fragment,e),Nt=n(e),ue=u(e,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-5e29jc"&&(ue.innerHTML=rs),Ft=n(e),i(ye.$$.fragment,e),Et=n(e),i(v.$$.fragment,e),Qt=n(e),de=u(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-1pnr8o2"&&(de.textContent=is),Lt=n(e),i(be.$$.fragment,e),St=n(e),we=u(e,"P",{"data-svelte-h":!0}),y(we)!=="svelte-1jmii3m"&&(we.innerHTML=ms),qt=n(e),i(B.$$.fragment,e),Pt=n(e),i(Te.$$.fragment,e),Kt=n(e),i(Je.$$.fragment,e),Dt=n(e),je=u(e,"P",{"data-svelte-h":!0}),y(je)!=="svelte-lkln0q"&&(je.textContent=os),Ot=n(e),i(I.$$.fragment,e),el=n(e),i(he.$$.fragment,e),tl=n(e),i(Ue.$$.fragment,e),ll=n(e),ge=u(e,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-1s0odnf"&&(ge.innerHTML=cs),sl=n(e),i(W.$$.fragment,e),al=n(e),i(Ce.$$.fragment,e),nl=n(e),_e=u(e,"P",{"data-svelte-h":!0}),y(_e)!=="svelte-1huvn8t"&&(_e.innerHTML=Ms),pl=n(e),Ze=u(e,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-rfmz99"&&(Ze.innerHTML=fs),rl=n(e),i(X.$$.fragment,e),il=n(e),ke=u(e,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-1l95d26"&&(ke.textContent=$s),ml=n(e),i(Ge.$$.fragment,e),ol=n(e),ve=u(e,"P",{"data-svelte-h":!0}),y(ve)!=="svelte-113uxm6"&&(ve.innerHTML=us),cl=n(e),i(Be.$$.fragment,e),Ml=n(e),Ie=u(e,"P",{"data-svelte-h":!0}),y(Ie)!=="svelte-byi8r8"&&(Ie.textContent=ys),fl=n(e),i(We.$$.fragment,e),$l=n(e),Xe=u(e,"P",{"data-svelte-h":!0}),y(Xe)!=="svelte-1cpsvqq"&&(Xe.textContent=ds),ul=n(e),xe=u(e,"P",{"data-svelte-h":!0}),y(xe)!=="svelte-1ylpqe4"&&(xe.innerHTML=bs),yl=n(e),i(Re.$$.fragment,e),dl=n(e),Ae=u(e,"P",{"data-svelte-h":!0}),y(Ae)!=="svelte-8g86cz"&&(Ae.innerHTML=ws),bl=n(e),i(x.$$.fragment,e),wl=n(e),i(Ve.$$.fragment,e),Tl=n(e),Ye=u(e,"P",{"data-svelte-h":!0}),y(Ye)!=="svelte-1l9dmrj"&&(Ye.textContent=Ts),Jl=n(e),He=u(e,"P",{"data-svelte-h":!0}),y(He)!=="svelte-151ylzl"&&(He.innerHTML=Js),jl=n(e),ze=u(e,"P",{"data-svelte-h":!0}),y(ze)!=="svelte-1m2wfmp"&&(ze.innerHTML=js),hl=n(e),Ne=u(e,"P",{"data-svelte-h":!0}),y(Ne)!=="svelte-5fb5sg"&&(Ne.innerHTML=hs),Ul=n(e),Fe=u(e,"P",{"data-svelte-h":!0}),y(Fe)!=="svelte-at21ge"&&(Fe.innerHTML=Us),gl=n(e),Ee=u(e,"P",{"data-svelte-h":!0}),y(Ee)!=="svelte-12zf6mi"&&(Ee.innerHTML=gs),Cl=n(e),Qe=u(e,"P",{"data-svelte-h":!0}),y(Qe)!=="svelte-wik8os"&&(Qe.innerHTML=Cs),_l=n(e),i(Le.$$.fragment,e),Zl=n(e),Se=u(e,"P",{"data-svelte-h":!0}),y(Se)!=="svelte-iclnry"&&(Se.textContent=_s),kl=n(e),i(qe.$$.fragment,e),Gl=n(e),i(Pe.$$.fragment,e),vl=n(e),i(Ke.$$.fragment,e),Bl=n(e),i(De.$$.fragment,e),Il=n(e),i(Oe.$$.fragment,e),Wl=n(e),i(et.$$.fragment,e),Xl=n(e),i(tt.$$.fragment,e),xl=n(e),i(lt.$$.fragment,e),Rl=n(e),i(st.$$.fragment,e),Al=n(e),i(at.$$.fragment,e),Vl=n(e),i(nt.$$.fragment,e),Yl=n(e),i(pt.$$.fragment,e),Hl=n(e),i(rt.$$.fragment,e),zl=n(e),i(it.$$.fragment,e),Nl=n(e),i(R.$$.fragment,e),Fl=n(e),i(mt.$$.fragment,e),El=n(e),ct=u(e,"P",{}),Rs(ct).forEach(l),this.h()},h(){As(p,"name","hf:doc:metadata"),As(p,"content",pa)},m(e,t){Es(document.head,p),s(e,w,t),s(e,f,t),s(e,d,t),m(U,e,t),s(e,J,t),m(T,e,t),s(e,_,t),m(b,e,t),s(e,g,t),s(e,V,t),s(e,Mt,t),m(k,e,t),s(e,ft,t),m(Y,e,t),s(e,$t,t),m(H,e,t),s(e,ut,t),s(e,z,t),s(e,yt,t),s(e,N,t),s(e,dt,t),s(e,F,t),s(e,bt,t),m(E,e,t),s(e,wt,t),s(e,Q,t),s(e,Tt,t),m(L,e,t),s(e,Jt,t),s(e,S,t),s(e,jt,t),m(q,e,t),s(e,ht,t),s(e,P,t),s(e,Ut,t),m(K,e,t),s(e,gt,t),m(D,e,t),s(e,Ct,t),s(e,O,t),s(e,_t,t),s(e,ee,t),s(e,Zt,t),m(te,e,t),s(e,kt,t),s(e,le,t),s(e,Gt,t),m(se,e,t),s(e,vt,t),m(ae,e,t),s(e,Bt,t),s(e,ne,t),s(e,It,t),s(e,pe,t),s(e,Wt,t),m(re,e,t),s(e,Xt,t),m(G,e,t),s(e,xt,t),s(e,ie,t),s(e,Rt,t),m(me,e,t),s(e,At,t),m(oe,e,t),s(e,Vt,t),m(ce,e,t),s(e,Yt,t),s(e,Me,t),s(e,Ht,t),m(fe,e,t),s(e,zt,t),m($e,e,t),s(e,Nt,t),s(e,ue,t),s(e,Ft,t),m(ye,e,t),s(e,Et,t),m(v,e,t),s(e,Qt,t),s(e,de,t),s(e,Lt,t),m(be,e,t),s(e,St,t),s(e,we,t),s(e,qt,t),m(B,e,t),s(e,Pt,t),m(Te,e,t),s(e,Kt,t),m(Je,e,t),s(e,Dt,t),s(e,je,t),s(e,Ot,t),m(I,e,t),s(e,el,t),m(he,e,t),s(e,tl,t),m(Ue,e,t),s(e,ll,t),s(e,ge,t),s(e,sl,t),m(W,e,t),s(e,al,t),m(Ce,e,t),s(e,nl,t),s(e,_e,t),s(e,pl,t),s(e,Ze,t),s(e,rl,t),m(X,e,t),s(e,il,t),s(e,ke,t),s(e,ml,t),m(Ge,e,t),s(e,ol,t),s(e,ve,t),s(e,cl,t),m(Be,e,t),s(e,Ml,t),s(e,Ie,t),s(e,fl,t),m(We,e,t),s(e,$l,t),s(e,Xe,t),s(e,ul,t),s(e,xe,t),s(e,yl,t),m(Re,e,t),s(e,dl,t),s(e,Ae,t),s(e,bl,t),m(x,e,t),s(e,wl,t),m(Ve,e,t),s(e,Tl,t),s(e,Ye,t),s(e,Jl,t),s(e,He,t),s(e,jl,t),s(e,ze,t),s(e,hl,t),s(e,Ne,t),s(e,Ul,t),s(e,Fe,t),s(e,gl,t),s(e,Ee,t),s(e,Cl,t),s(e,Qe,t),s(e,_l,t),m(Le,e,t),s(e,Zl,t),s(e,Se,t),s(e,kl,t),m(qe,e,t),s(e,Gl,t),m(Pe,e,t),s(e,vl,t),m(Ke,e,t),s(e,Bl,t),m(De,e,t),s(e,Il,t),m(Oe,e,t),s(e,Wl,t),m(et,e,t),s(e,Xl,t),m(tt,e,t),s(e,xl,t),m(lt,e,t),s(e,Rl,t),m(st,e,t),s(e,Al,t),m(at,e,t),s(e,Vl,t),m(nt,e,t),s(e,Yl,t),m(pt,e,t),s(e,Hl,t),m(rt,e,t),s(e,zl,t),m(it,e,t),s(e,Nl,t),m(R,e,t),s(e,Fl,t),m(mt,e,t),s(e,El,t),s(e,ct,t),Ql=!0},p(e,[t]){const Zs={};t&2&&(Zs.$$scope={dirty:t,ctx:e}),k.$set(Zs);const ks={};t&2&&(ks.$$scope={dirty:t,ctx:e}),G.$set(ks);const Gs={};t&2&&(Gs.$$scope={dirty:t,ctx:e}),v.$set(Gs);const vs={};t&2&&(vs.$$scope={dirty:t,ctx:e}),B.$set(vs);const Bs={};t&2&&(Bs.$$scope={dirty:t,ctx:e}),I.$set(Bs);const Is={};t&2&&(Is.$$scope={dirty:t,ctx:e}),W.$set(Is);const Ws={};t&2&&(Ws.$$scope={dirty:t,ctx:e}),X.$set(Ws);const Xs={};t&2&&(Xs.$$scope={dirty:t,ctx:e}),x.$set(Xs);const xs={};t&2&&(xs.$$scope={dirty:t,ctx:e}),R.$set(xs)},i(e){Ql||(o(U.$$.fragment,e),o(T.$$.fragment,e),o(b.$$.fragment,e),o(k.$$.fragment,e),o(Y.$$.fragment,e),o(H.$$.fragment,e),o(E.$$.fragment,e),o(L.$$.fragment,e),o(q.$$.fragment,e),o(K.$$.fragment,e),o(D.$$.fragment,e),o(te.$$.fragment,e),o(se.$$.fragment,e),o(ae.$$.fragment,e),o(re.$$.fragment,e),o(G.$$.fragment,e),o(me.$$.fragment,e),o(oe.$$.fragment,e),o(ce.$$.fragment,e),o(fe.$$.fragment,e),o($e.$$.fragment,e),o(ye.$$.fragment,e),o(v.$$.fragment,e),o(be.$$.fragment,e),o(B.$$.fragment,e),o(Te.$$.fragment,e),o(Je.$$.fragment,e),o(I.$$.fragment,e),o(he.$$.fragment,e),o(Ue.$$.fragment,e),o(W.$$.fragment,e),o(Ce.$$.fragment,e),o(X.$$.fragment,e),o(Ge.$$.fragment,e),o(Be.$$.fragment,e),o(We.$$.fragment,e),o(Re.$$.fragment,e),o(x.$$.fragment,e),o(Ve.$$.fragment,e),o(Le.$$.fragment,e),o(qe.$$.fragment,e),o(Pe.$$.fragment,e),o(Ke.$$.fragment,e),o(De.$$.fragment,e),o(Oe.$$.fragment,e),o(et.$$.fragment,e),o(tt.$$.fragment,e),o(lt.$$.fragment,e),o(st.$$.fragment,e),o(at.$$.fragment,e),o(nt.$$.fragment,e),o(pt.$$.fragment,e),o(rt.$$.fragment,e),o(it.$$.fragment,e),o(R.$$.fragment,e),o(mt.$$.fragment,e),Ql=!0)},o(e){c(U.$$.fragment,e),c(T.$$.fragment,e),c(b.$$.fragment,e),c(k.$$.fragment,e),c(Y.$$.fragment,e),c(H.$$.fragment,e),c(E.$$.fragment,e),c(L.$$.fragment,e),c(q.$$.fragment,e),c(K.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(G.$$.fragment,e),c(me.$$.fragment,e),c(oe.$$.fragment,e),c(ce.$$.fragment,e),c(fe.$$.fragment,e),c($e.$$.fragment,e),c(ye.$$.fragment,e),c(v.$$.fragment,e),c(be.$$.fragment,e),c(B.$$.fragment,e),c(Te.$$.fragment,e),c(Je.$$.fragment,e),c(I.$$.fragment,e),c(he.$$.fragment,e),c(Ue.$$.fragment,e),c(W.$$.fragment,e),c(Ce.$$.fragment,e),c(X.$$.fragment,e),c(Ge.$$.fragment,e),c(Be.$$.fragment,e),c(We.$$.fragment,e),c(Re.$$.fragment,e),c(x.$$.fragment,e),c(Ve.$$.fragment,e),c(Le.$$.fragment,e),c(qe.$$.fragment,e),c(Pe.$$.fragment,e),c(Ke.$$.fragment,e),c(De.$$.fragment,e),c(Oe.$$.fragment,e),c(et.$$.fragment,e),c(tt.$$.fragment,e),c(lt.$$.fragment,e),c(st.$$.fragment,e),c(at.$$.fragment,e),c(nt.$$.fragment,e),c(pt.$$.fragment,e),c(rt.$$.fragment,e),c(it.$$.fragment,e),c(R.$$.fragment,e),c(mt.$$.fragment,e),Ql=!1},d(e){e&&(l(w),l(f),l(d),l(J),l(_),l(g),l(V),l(Mt),l(ft),l($t),l(ut),l(z),l(yt),l(N),l(dt),l(F),l(bt),l(wt),l(Q),l(Tt),l(Jt),l(S),l(jt),l(ht),l(P),l(Ut),l(gt),l(Ct),l(O),l(_t),l(ee),l(Zt),l(kt),l(le),l(Gt),l(vt),l(Bt),l(ne),l(It),l(pe),l(Wt),l(Xt),l(xt),l(ie),l(Rt),l(At),l(Vt),l(Yt),l(Me),l(Ht),l(zt),l(Nt),l(ue),l(Ft),l(Et),l(Qt),l(de),l(Lt),l(St),l(we),l(qt),l(Pt),l(Kt),l(Dt),l(je),l(Ot),l(el),l(tl),l(ll),l(ge),l(sl),l(al),l(nl),l(_e),l(pl),l(Ze),l(rl),l(il),l(ke),l(ml),l(ol),l(ve),l(cl),l(Ml),l(Ie),l(fl),l($l),l(Xe),l(ul),l(xe),l(yl),l(dl),l(Ae),l(bl),l(wl),l(Tl),l(Ye),l(Jl),l(He),l(jl),l(ze),l(hl),l(Ne),l(Ul),l(Fe),l(gl),l(Ee),l(Cl),l(Qe),l(_l),l(Zl),l(Se),l(kl),l(Gl),l(vl),l(Bl),l(Il),l(Wl),l(Xl),l(xl),l(Rl),l(Al),l(Vl),l(Yl),l(Hl),l(zl),l(Nl),l(Fl),l(El),l(ct)),l(p),M(U,e),M(T,e),M(b,e),M(k,e),M(Y,e),M(H,e),M(E,e),M(L,e),M(q,e),M(K,e),M(D,e),M(te,e),M(se,e),M(ae,e),M(re,e),M(G,e),M(me,e),M(oe,e),M(ce,e),M(fe,e),M($e,e),M(ye,e),M(v,e),M(be,e),M(B,e),M(Te,e),M(Je,e),M(I,e),M(he,e),M(Ue,e),M(W,e),M(Ce,e),M(X,e),M(Ge,e),M(Be,e),M(We,e),M(Re,e),M(x,e),M(Ve,e),M(Le,e),M(qe,e),M(Pe,e),M(Ke,e),M(De,e),M(Oe,e),M(et,e),M(tt,e),M(lt,e),M(st,e),M(at,e),M(nt,e),M(pt,e),M(rt,e),M(it,e),M(R,e),M(mt,e)}}}const pa='{"title":"처음부터 구현하는 훈련 루프","local":"a-full-training-loop","sections":[{"title":"훈련 준비","local":"prepare-for-training","sections":[],"depth":3},{"title":"훈련 루프","local":"the-training-loop","sections":[],"depth":3},{"title":"평가 루프","local":"the-evaluation-loop","sections":[],"depth":3},{"title":"🤗 Accelerate로 훈련 루프 강화하기","local":"supercharge-your-training-loop-with-accelerate","sections":[],"depth":3},{"title":"다음 단계와 모범 사례","local":"next-steps-and-best-practices","sections":[],"depth":3},{"title":"섹션 퀴즈","local":"section-quiz","sections":[{"title":"1. Adam과 AdamW 옵티마이저의 주요 차이점은 무엇인가요?","local":"1-adam과-adamw-옵티마이저의-주요-차이점은-무엇인가요","sections":[],"depth":3},{"title":"2. 훈련 루프에서 올바른 연산 순서는 무엇인가요?","local":"2-훈련-루프에서-올바른-연산-순서는-무엇인가요","sections":[],"depth":3},{"title":"3. 🤗 Accelerate 라이브러리는 주로 무엇을 도와주나요?","local":"3--accelerate-라이브러리는-주로-무엇을-도와주나요","sections":[],"depth":3},{"title":"4. 훈련 루프에서 배치를 장치로 이동하는 이유는 무엇인가요?","local":"4-훈련-루프에서-배치를-장치로-이동하는-이유는-무엇인가요","sections":[],"depth":3},{"title":"5. 평가 전에 model.eval() 은 무엇을 하나요?","local":"5-평가-전에-modeleval-은-무엇을-하나요","sections":[],"depth":3},{"title":"6. 평가 중 torch.no_grad() 의 목적은 무엇인가요?","local":"6-평가-중-torchnograd-의-목적은-무엇인가요","sections":[],"depth":3},{"title":"7. 훈련 루프에서 🤗 Accelerate를 사용할 때 무엇이 변경되나요?","local":"7-훈련-루프에서--accelerate를-사용할-때-무엇이-변경되나요","sections":[],"depth":3}],"depth":2}],"depth":1}';function ra(h){return Hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ya extends zs{constructor(p){super(),Ns(this,p,ra,na,Ys,{})}}export{ya as component};
