import{s as Is,n as Vs,o as Ss}from"../chunks/scheduler.85c25b89.js";import{S as _s,i as Xs,g as M,s as a,r as p,A as Gs,h,f as s,c as n,j as Zs,u as i,x as u,k as vs,y as Ws,a as l,v as r,d as m,t as o,w as c}from"../chunks/index.c9837788.js";import{C as y}from"../chunks/CodeBlock.52fa569e.js";import{H as d,E as Rs}from"../chunks/EditOnGithub.b65eee75.js";function zs(ts){let f,Se,Ie,_e,J,Xe,j,ss="All of the models in <code>timm</code> have consistent mechanisms for obtaining various types of features from the model for tasks besides classification.",Ge,g,We,U,ls="The features from the penultimate model layer can be obtained in several ways without requiring model surgery (although feel free to do surgery). One must first decide if they want pooled or un-pooled features.",Re,T,ze,w,as="There are three ways to obtain unpooled features. The final, unpooled features are sometimes referred to as the last hidden state. In <code>timm</code> this is up to and including the final normalization layer (in e.g. ViT style models) but does not include pooling / class token selection and final post-pooling layers.",Fe,b,ns="Without modifying the network, one can call <code>model.forward_features(input)</code> on any model instead of the usual <code>model(input)</code>. This will bypass the head classifier and global pooling for networks.",De,$,ps="If one wants to explicitly modify the network to return unpooled features, they can either create the model without a classifier and pooling, or remove it later. Both paths remove the parameters associated with the classifier from the network.",Ee,C,Ye,k,He,x,is="Output:",Ae,Q,Le,N,Ke,B,Pe,Z,rs="Output:",Oe,v,qe,I,et,V,tt,S,ms="Output:",st,_,lt,X,at,G,os="The last hidden state can be fed back into the head of the model using the <code>forward_head()</code> function.",nt,W,pt,R,cs="Output:",it,z,rt,F,mt,D,Ms="To modify the network to return pooled features, one can use <code>forward_features()</code> and pool/flatten the result themselves, or modify the network like above but keep pooling intact.",ot,E,ct,Y,Mt,H,hs="Output:",ht,A,ut,L,yt,K,dt,P,us="Output:",ft,O,Jt,q,jt,ee,ys="Object detection, segmentation, keypoint, and a variety of dense pixel tasks require access to feature maps from the backbone network at multiple scales. This is often done by modifying the original classification network. Since each network varies quite a bit in structure, it’s not uncommon to see only a few backbones supported in any given obj detection or segmentation library.",gt,te,ds="<code>timm</code> allows a consistent interface for creating any of the included models as feature backbones that output feature maps for selected levels.",Ut,se,fs="A feature backbone can be created by adding the argument <code>features_only=True</code> to any <code>create_model</code> call. By default most models with a feature hierarchy will output up to 5 features up to a reduction of 32. However this varies per model, some models have fewer hierarchy levels, and some (like ViT) have a larger number of non-hierarchical feature maps and they default to outputting the last 3. The <code>out_indices</code> arg can be passed to <code>create_model</code> to specify which features you want.",Tt,le,wt,ae,bt,ne,Js="Output:",$t,pe,Ct,ie,kt,re,js="After a feature backbone has been created, it can be queried to provide channel or resolution reduction information to the downstream heads without requiring static config or hardcoded constants. The <code>.feature_info</code> attribute is a class encapsulating the information about the feature extraction points.",xt,me,Qt,oe,gs="Output:",Nt,ce,Bt,Me,Zt,he,Us="There are two additional creation arguments impacting the output features.",vt,ue,Ts="<li><code>out_indices</code> selects which indices to output</li> <li><code>output_stride</code> limits the feature output stride of the network (also works in classification mode BTW)</li>",It,ye,Vt,de,ws="The <code>out_indices</code> argument is supported by all models, but not all models have the same index to feature stride mapping. Look at the code or check feature_info to compare. The out indices generally correspond to the <code>C(i+1)th</code> feature level (a <code>2^(i+1)</code> reduction). For most convnet models, index 0 is the stride 2 features, and index 4 is stride 32. For many ViT or ViT-Conv hybrids there may be many to all features maps of the same shape, or a combination of hierarchical and non-hierarchical feature maps. It is best to look at the <code>feature_info</code> attribute to see the number of features, their corresponding channel count and reduction level.",St,fe,bs="<code>out_indices</code> supports negative indexing, this makes it easy to get the last, penultimate, etc feature map. <code>out_indices=(-2,)</code> would return the penultimate feature map for any model.",_t,Je,Xt,je,$s="<code>output_stride</code> is achieved by converting layers to use dilated convolutions. Doing so is not always straightforward, some networks only support <code>output_stride=32</code>.",Gt,ge,Wt,Ue,Cs="Output:",Rt,Te,zt,we,Ft,be,ks="In addition to using <code>features_only</code> with the model factory, many models support a <code>forward_intermediates()</code> method which provides a flexible mechanism for extracting both the intermediate feature maps and the last hidden state (which can be chained to the head). Additionally this method supports some model specific features such as returning class or distill prefix tokens for some models.",Dt,$e,xs="Accompanying the <code>forward_intermediates</code> function is a <code>prune_intermediate_layers</code> function that allows one to prune layers from the model, including both the head, final norm, and/or trailing blocks/stages that are not needed.",Et,Ce,Qs="An <code>indices</code> argument is used for both <code>forward_intermediates()</code> and <code>prune_intermediate_layers()</code> to select the features to return or layers to remove. As with the <code>out_indices</code> for <code>features_only</code> API, <code>indices</code> is model specific and selects which intermediates are returned.",Yt,ke,Ns="In non-hierarchical block based models such as ViT the indices correspond to the blocks, in models with hierarchical stages they usually correspond to the output of the stem + each hierarchical stage. Both positive (from the start), and negative (relative to the end) indexing works, and <code>None</code> is used to return all intermediates.",Ht,xe,Bs="The <code>prune_intermediate_layers()</code> call returns an indices variable, as negative indices must be converted to absolute (positive) indices when the model is trimmed.",At,Qe,Lt,Ne,Kt,Be,Pt,Ze,Ot,ve,qt,Ve,es;return J=new d({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h1"}}),g=new d({props:{title:"Penultimate Layer Features (Pre-Classifier Features)",local:"penultimate-layer-features-pre-classifier-features",headingTag:"h2"}}),T=new d({props:{title:"Unpooled",local:"unpooled",headingTag:"h3"}}),C=new d({props:{title:"forward_features()",local:"forwardfeatures",headingTag:"h4"}}),k=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCd4Y2VwdGlvbjQxJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW8lMjAlM0QlMjBtKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjk5JTJDJTIwMjk5KSklMEFwcmludChmJ09yaWdpbmFsJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyklMEFvJTIwJTNEJTIwbS5mb3J3YXJkX2ZlYXR1cmVzKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjk5JTJDJTIwMjk5KSklMEFwcmludChmJ1VucG9vbGVkJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;xception41&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">299</span>, <span class="hljs-number">299</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m.forward_features(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">299</span>, <span class="hljs-number">299</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),Q=new y({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBVW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjAxMCUyQyUyMDEwJTVEKQ==",highlighted:`Original shape: torch.Size([2, 1000])
Unpooled shape: torch.Size([2, 2048, 10, 10])`,wrap:!1}}),N=new d({props:{title:"Create with no classifier and pooling",local:"create-with-no-classifier-and-pooling",headingTag:"h4"}}),B=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNEMCUyQyUyMGdsb2JhbF9wb29sJTNEJycpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQXByaW50KGYnVW5wb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">0</span>, global_pool=<span class="hljs-string">&#x27;&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),v=new y({props:{code:"VW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:"Unpooled shape: torch.Size([2, 2048, 7, 7])",wrap:!1}}),I=new d({props:{title:"Remove it later",local:"remove-it-later",headingTag:"h4"}}),V=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdkZW5zZW5ldDEyMSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidPcmlnaW5hbCUyMHNoYXBlJTNBJTIwJTdCby5zaGFwZSU3RCcpJTBBbS5yZXNldF9jbGFzc2lmaWVyKDAlMkMlMjAnJyklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidVbnBvb2xlZCUyMHNoYXBlJTNBJTIwJTdCby5zaGFwZSU3RCcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;densenet121&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>m.reset_classifier(<span class="hljs-number">0</span>, <span class="hljs-string">&#x27;&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),_=new y({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBVW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMjQlMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`Original shape: torch.Size([2, 1000])
Unpooled shape: torch.Size([2, 1024, 7, 7])`,wrap:!1}}),X=new d({props:{title:"Chaining unpooled output to classifier",local:"chaining-unpooled-output-to-classifier",headingTag:"h4"}}),W=new y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndml0X21lZGl1bV9wYXRjaDE2X3JlZzFfZ2FwXzI1NiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFvdXRwdXQlMjAlM0QlMjBtb2RlbC5mb3J3YXJkX2ZlYXR1cmVzKHRvcmNoLnJhbmRuKDIlMkMzJTJDMjU2JTJDMjU2KSklMEFwcmludCgnVW5wb29sZWQlMjBvdXRwdXQlMjBzaGFwZSUzQSclMkMlMjBvdXRwdXQuc2hhcGUpJTBBY2xhc3NpZmllZCUyMCUzRCUyMG1vZGVsLmZvcndhcmRfaGVhZChvdXRwdXQpJTBBcHJpbnQoJ0NsYXNzaWZpY2F0aW9uJTIwb3V0cHV0JTIwc2hhcGUlM0EnJTJDJTIwY2xhc3NpZmllZC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;vit_medium_patch16_reg1_gap_256&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.forward_features(torch.randn(<span class="hljs-number">2</span>,<span class="hljs-number">3</span>,<span class="hljs-number">256</span>,<span class="hljs-number">256</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Unpooled output shape:&#x27;</span>, output.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span>classified = model.forward_head(output)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Classification output shape:&#x27;</span>, classified.shape)`,wrap:!1}}),z=new y({props:{code:"VW5wb29sZWQlMjBvdXRwdXQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDI1NyUyQyUyMDUxMiU1RCklMEFDbGFzc2lmaWNhdGlvbiUyMG91dHB1dCUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwMTAwMCU1RCk=",highlighted:`Unpooled output shape: torch.Size([2, 257, 512])
Classification output shape: torch.Size([2, 1000])`,wrap:!1}}),F=new d({props:{title:"Pooled",local:"pooled",headingTag:"h3"}}),E=new d({props:{title:"Create with no classifier",local:"create-with-no-classifier",headingTag:"h4"}}),Y=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNEMCklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidQb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Pooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),A=new y({props:{code:"UG9vbGVkJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjAyMDQ4JTVEKQ==",highlighted:"Pooled shape: torch.Size([2, 2048])",wrap:!1}}),L=new d({props:{title:"Remove it later",local:"remove-it-later",headingTag:"h4"}}),K=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdlc2Vfdm92bmV0MTliX2R3JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW8lMjAlM0QlMjBtKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0KSklMEFwcmludChmJ09yaWdpbmFsJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyklMEFtLnJlc2V0X2NsYXNzaWZpZXIoMCklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidQb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;ese_vovnet19b_dw&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>m.reset_classifier(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Pooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),O=new y({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBUG9vbGVkJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjAxMDI0JTVEKQ==",highlighted:`Original shape: torch.Size([2, 1000])
Pooled shape: torch.Size([2, 1024])`,wrap:!1}}),q=new d({props:{title:"Multi-scale Feature Maps (Feature Pyramid)",local:"multi-scale-feature-maps-feature-pyramid",headingTag:"h2"}}),le=new d({props:{title:"Create a feature map extraction model",local:"create-a-feature-map-extraction-model",headingTag:"h3"}}),ae=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXN0MjZkJyUyQyUyMGZlYXR1cmVzX29ubHklM0RUcnVlJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQWZvciUyMHglMjBpbiUyMG8lM0ElMEElMjAlMjAlMjAlMjBwcmludCh4LnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnest26d&#x27;</span>, features_only=<span class="hljs-literal">True</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`,wrap:!1}}),pe=new y({props:{code:"dG9yY2guU2l6ZSglNUIyJTJDJTIwNjQlMkMlMjAxMTIlMkMlMjAxMTIlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjU2JTJDJTIwNTYlMkMlMjA1NiU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA1MTIlMkMlMjAyOCUyQyUyMDI4JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMjQlMkMlMjAxNCUyQyUyMDE0JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`torch.Size([2, 64, 112, 112])
torch.Size([2, 256, 56, 56])
torch.Size([2, 512, 28, 28])
torch.Size([2, 1024, 14, 14])
torch.Size([2, 2048, 7, 7])`,wrap:!1}}),ie=new d({props:{title:"Query the feature information",local:"query-the-feature-information",headingTag:"h3"}}),me=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZWduZXR5XzAzMiclMkMlMjBmZWF0dXJlc19vbmx5JTNEVHJ1ZSUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXByaW50KGYnRmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTdCbS5mZWF0dXJlX2luZm8uY2hhbm5lbHMoKSU3RCcpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQWZvciUyMHglMjBpbiUyMG8lM0ElMEElMjAlMjAlMjAlMjBwcmludCh4LnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;regnety_032&#x27;</span>, features_only=<span class="hljs-literal">True</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature channels: <span class="hljs-subst">{m.feature_info.channels()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`,wrap:!1}}),ce=new y({props:{code:"RmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTVCMzIlMkMlMjA3MiUyQyUyMDIxNiUyQyUyMDU3NiUyQyUyMDE1MTIlNUQlMEF0b3JjaC5TaXplKCU1QjIlMkMlMjAzMiUyQyUyMDExMiUyQyUyMDExMiU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA3MiUyQyUyMDU2JTJDJTIwNTYlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjE2JTJDJTIwMjglMkMlMjAyOCU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA1NzYlMkMlMjAxNCUyQyUyMDE0JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDE1MTIlMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`Feature channels: [32, 72, 216, 576, 1512]
torch.Size([2, 32, 112, 112])
torch.Size([2, 72, 56, 56])
torch.Size([2, 216, 28, 28])
torch.Size([2, 576, 14, 14])
torch.Size([2, 1512, 7, 7])`,wrap:!1}}),Me=new d({props:{title:"Select specific feature levels or limit the stride",local:"select-specific-feature-levels-or-limit-the-stride",headingTag:"h3"}}),ye=new d({props:{title:"Output index selection",local:"output-index-selection",headingTag:"h4"}}),Je=new d({props:{title:"Output stride (feature map dilation)",local:"output-stride-feature-map-dilation",headingTag:"h4"}}),ge=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdlY2FyZXNuZXQxMDFkJyUyQyUyMGZlYXR1cmVzX29ubHklM0RUcnVlJTJDJTIwb3V0cHV0X3N0cmlkZSUzRDglMkMlMjBvdXRfaW5kaWNlcyUzRCgyJTJDJTIwNCklMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFwcmludChmJ0ZlYXR1cmUlMjBjaGFubmVscyUzQSUyMCU3Qm0uZmVhdHVyZV9pbmZvLmNoYW5uZWxzKCklN0QnKSUwQXByaW50KGYnRmVhdHVyZSUyMHJlZHVjdGlvbiUzQSUyMCU3Qm0uZmVhdHVyZV9pbmZvLnJlZHVjdGlvbigpJTdEJyklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDMyMCUyQyUyMDMyMCkpJTBBZm9yJTIweCUyMGluJTIwbyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHguc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;ecaresnet101d&#x27;</span>, features_only=<span class="hljs-literal">True</span>, output_stride=<span class="hljs-number">8</span>, out_indices=(<span class="hljs-number">2</span>, <span class="hljs-number">4</span>), pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature channels: <span class="hljs-subst">{m.feature_info.channels()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature reduction: <span class="hljs-subst">{m.feature_info.reduction()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">320</span>, <span class="hljs-number">320</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`,wrap:!1}}),Te=new y({props:{code:"RmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTVCNTEyJTJDJTIwMjA0OCU1RCUwQUZlYXR1cmUlMjByZWR1Y3Rpb24lM0ElMjAlNUI4JTJDJTIwOCU1RCUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDUxMiUyQyUyMDQwJTJDJTIwNDAlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjA0OCUyQyUyMDQwJTJDJTIwNDAlNUQp",highlighted:`Feature channels: [512, 2048]
Feature reduction: [8, 8]
torch.Size([2, 512, 40, 40])
torch.Size([2, 2048, 40, 40])`,wrap:!1}}),we=new d({props:{title:"Flexible intermediate feature map extraction",local:"flexible-intermediate-feature-map-extraction",headingTag:"h2"}}),Qe=new y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndml0X21lZGl1bV9wYXRjaDE2X3JlZzFfZ2FwXzI1NiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFvdXRwdXQlMkMlMjBpbnRlcm1lZGlhdGVzJTIwJTNEJTIwbW9kZWwuZm9yd2FyZF9pbnRlcm1lZGlhdGVzKHRvcmNoLnJhbmRuKDIlMkMzJTJDMjU2JTJDMjU2KSklMEFmb3IlMjBpJTJDJTIwbyUyMGluJTIwZW51bWVyYXRlKGludGVybWVkaWF0ZXMpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZidGZWF0JTIwaW5kZXglM0ElMjAlN0JpJTdEJTJDJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyk=",highlighted:`model = timm.create_model(<span class="hljs-string">&#x27;vit_medium_patch16_reg1_gap_256&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
output, intermediates = model.forward_intermediates(torch.randn(<span class="hljs-number">2</span>,<span class="hljs-number">3</span>,<span class="hljs-number">256</span>,<span class="hljs-number">256</span>))
<span class="hljs-keyword">for</span> i, o <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(intermediates):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feat index: <span class="hljs-subst">{i}</span>, shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),Ne=new y({props:{code:"RmVhdCUyMGluZGV4JTNBJTIwMCUyQyUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCklMEFGZWF0JTIwaW5kZXglM0ElMjAxJTJDJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjA1MTIlMkMlMjAxNiUyQyUyMDE2JTVEKSUwQUZlYXQlMjBpbmRleCUzQSUyMDIlMkMlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDUxMiUyQyUyMDE2JTJDJTIwMTYlNUQpJTBBRmVhdCUyMGluZGV4JTNBJTIwMyUyQyUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCklMEFGZWF0JTIwaW5kZXglM0ElMjA0JTJDJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjA1MTIlMkMlMjAxNiUyQyUyMDE2JTVEKSUwQUZlYXQlMjBpbmRleCUzQSUyMDUlMkMlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDUxMiUyQyUyMDE2JTJDJTIwMTYlNUQpJTBBRmVhdCUyMGluZGV4JTNBJTIwNiUyQyUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCklMEFGZWF0JTIwaW5kZXglM0ElMjA3JTJDJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjA1MTIlMkMlMjAxNiUyQyUyMDE2JTVEKSUwQUZlYXQlMjBpbmRleCUzQSUyMDglMkMlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDUxMiUyQyUyMDE2JTJDJTIwMTYlNUQpJTBBRmVhdCUyMGluZGV4JTNBJTIwOSUyQyUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCklMEFGZWF0JTIwaW5kZXglM0ElMjAxMCUyQyUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCklMEFGZWF0JTIwaW5kZXglM0ElMjAxMSUyQyUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCk=",highlighted:`Feat index: 0, shape: torch.Size([2, 512, 16, 16])
Feat index: 1, shape: torch.Size([2, 512, 16, 16])
Feat index: 2, shape: torch.Size([2, 512, 16, 16])
Feat index: 3, shape: torch.Size([2, 512, 16, 16])
Feat index: 4, shape: torch.Size([2, 512, 16, 16])
Feat index: 5, shape: torch.Size([2, 512, 16, 16])
Feat index: 6, shape: torch.Size([2, 512, 16, 16])
Feat index: 7, shape: torch.Size([2, 512, 16, 16])
Feat index: 8, shape: torch.Size([2, 512, 16, 16])
Feat index: 9, shape: torch.Size([2, 512, 16, 16])
Feat index: 10, shape: torch.Size([2, 512, 16, 16])
Feat index: 11, shape: torch.Size([2, 512, 16, 16])`,wrap:!1}}),Be=new y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndml0X21lZGl1bV9wYXRjaDE2X3JlZzFfZ2FwXzI1NiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFwcmludCgnT3JpZ2luYWwlMjBwYXJhbXMlM0EnJTJDJTIwc3VtKCU1QnAubnVtZWwoKSUyMGZvciUyMHAlMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSU1RCkpJTBBJTBBaW5kaWNlcyUyMCUzRCUyMG1vZGVsLnBydW5lX2ludGVybWVkaWF0ZV9sYXllcnMoaW5kaWNlcyUzRCgtMiUyQyklMkMlMjBwcnVuZV9oZWFkJTNEVHJ1ZSUyQyUyMHBydW5lX25vcm0lM0RUcnVlKSUyMCUyMCUyMyUyMHBydW5lJTIwaGVhZCUyQyUyMG5vcm0lMkMlMjBsYXN0JTIwYmxvY2slMEFwcmludCgnUHJ1bmVkJTIwcGFyYW1zJTNBJyUyQyUyMHN1bSglNUJwLm51bWVsKCklMjBmb3IlMjBwJTIwaW4lMjBtb2RlbC5wYXJhbWV0ZXJzKCklNUQpKSUwQSUwQWludGVybWVkaWF0ZXMlMjAlM0QlMjBtb2RlbC5mb3J3YXJkX2ludGVybWVkaWF0ZXModG9yY2gucmFuZG4oMiUyQzMlMkMyNTYlMkMyNTYpJTJDJTIwaW5kaWNlcyUzRGluZGljZXMlMkMlMjBpbnRlcm1lZGlhdGVzX29ubHklM0RUcnVlKSUyMCUyMCUyMyUyMHJldHVybiUyMHBlbnVsdGltYXRlJTIwaW50ZXJtZWRpYXRlJTBBZm9yJTIwbyUyMGluJTIwaW50ZXJtZWRpYXRlcyUzQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMHByaW50KGYnRmVhdCUyMHNoYXBlJTNBJTIwJTdCby5zaGFwZSU3RCcp",highlighted:`model = timm.create_model(<span class="hljs-string">&#x27;vit_medium_patch16_reg1_gap_256&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Original params:&#x27;</span>, <span class="hljs-built_in">sum</span>([p.numel() <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> model.parameters()]))

indices = model.prune_intermediate_layers(indices=(-<span class="hljs-number">2</span>,), prune_head=<span class="hljs-literal">True</span>, prune_norm=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># prune head, norm, last block</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Pruned params:&#x27;</span>, <span class="hljs-built_in">sum</span>([p.numel() <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> model.parameters()]))

intermediates = model.forward_intermediates(torch.randn(<span class="hljs-number">2</span>,<span class="hljs-number">3</span>,<span class="hljs-number">256</span>,<span class="hljs-number">256</span>), indices=indices, intermediates_only=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># return penultimate intermediate</span>
<span class="hljs-keyword">for</span> o <span class="hljs-keyword">in</span> intermediates:    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feat shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),Ze=new y({props:{code:"T3JpZ2luYWwlMjBwYXJhbXMlM0ElMjAzODg4MDIzMiUwQVBydW5lZCUyMHBhcmFtcyUzQSUyMDM1MjEyODAwJTBBRmVhdCUyMHNoYXBlJTNBJTIwdG9yY2guU2l6ZSglNUIyJTJDJTIwNTEyJTJDJTIwMTYlMkMlMjAxNiU1RCk=",highlighted:`Original params: 38880232
Pruned params: 35212800
Feat shape: torch.Size([2, 512, 16, 16])`,wrap:!1}}),ve=new Rs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/feature_extraction.mdx"}}),{c(){f=M("meta"),Se=a(),Ie=M("p"),_e=a(),p(J.$$.fragment),Xe=a(),j=M("p"),j.innerHTML=ss,Ge=a(),p(g.$$.fragment),We=a(),U=M("p"),U.textContent=ls,Re=a(),p(T.$$.fragment),ze=a(),w=M("p"),w.innerHTML=as,Fe=a(),b=M("p"),b.innerHTML=ns,De=a(),$=M("p"),$.textContent=ps,Ee=a(),p(C.$$.fragment),Ye=a(),p(k.$$.fragment),He=a(),x=M("p"),x.textContent=is,Ae=a(),p(Q.$$.fragment),Le=a(),p(N.$$.fragment),Ke=a(),p(B.$$.fragment),Pe=a(),Z=M("p"),Z.textContent=rs,Oe=a(),p(v.$$.fragment),qe=a(),p(I.$$.fragment),et=a(),p(V.$$.fragment),tt=a(),S=M("p"),S.textContent=ms,st=a(),p(_.$$.fragment),lt=a(),p(X.$$.fragment),at=a(),G=M("p"),G.innerHTML=os,nt=a(),p(W.$$.fragment),pt=a(),R=M("p"),R.textContent=cs,it=a(),p(z.$$.fragment),rt=a(),p(F.$$.fragment),mt=a(),D=M("p"),D.innerHTML=Ms,ot=a(),p(E.$$.fragment),ct=a(),p(Y.$$.fragment),Mt=a(),H=M("p"),H.textContent=hs,ht=a(),p(A.$$.fragment),ut=a(),p(L.$$.fragment),yt=a(),p(K.$$.fragment),dt=a(),P=M("p"),P.textContent=us,ft=a(),p(O.$$.fragment),Jt=a(),p(q.$$.fragment),jt=a(),ee=M("p"),ee.textContent=ys,gt=a(),te=M("p"),te.innerHTML=ds,Ut=a(),se=M("p"),se.innerHTML=fs,Tt=a(),p(le.$$.fragment),wt=a(),p(ae.$$.fragment),bt=a(),ne=M("p"),ne.textContent=Js,$t=a(),p(pe.$$.fragment),Ct=a(),p(ie.$$.fragment),kt=a(),re=M("p"),re.innerHTML=js,xt=a(),p(me.$$.fragment),Qt=a(),oe=M("p"),oe.textContent=gs,Nt=a(),p(ce.$$.fragment),Bt=a(),p(Me.$$.fragment),Zt=a(),he=M("p"),he.textContent=Us,vt=a(),ue=M("ul"),ue.innerHTML=Ts,It=a(),p(ye.$$.fragment),Vt=a(),de=M("p"),de.innerHTML=ws,St=a(),fe=M("p"),fe.innerHTML=bs,_t=a(),p(Je.$$.fragment),Xt=a(),je=M("p"),je.innerHTML=$s,Gt=a(),p(ge.$$.fragment),Wt=a(),Ue=M("p"),Ue.textContent=Cs,Rt=a(),p(Te.$$.fragment),zt=a(),p(we.$$.fragment),Ft=a(),be=M("p"),be.innerHTML=ks,Dt=a(),$e=M("p"),$e.innerHTML=xs,Et=a(),Ce=M("p"),Ce.innerHTML=Qs,Yt=a(),ke=M("p"),ke.innerHTML=Ns,Ht=a(),xe=M("p"),xe.innerHTML=Bs,At=a(),p(Qe.$$.fragment),Lt=a(),p(Ne.$$.fragment),Kt=a(),p(Be.$$.fragment),Pt=a(),p(Ze.$$.fragment),Ot=a(),p(ve.$$.fragment),qt=a(),Ve=M("p"),this.h()},l(e){const t=Gs("svelte-u9bgzb",document.head);f=h(t,"META",{name:!0,content:!0}),t.forEach(s),Se=n(e),Ie=h(e,"P",{}),Zs(Ie).forEach(s),_e=n(e),i(J.$$.fragment,e),Xe=n(e),j=h(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-1w5xc9e"&&(j.innerHTML=ss),Ge=n(e),i(g.$$.fragment,e),We=n(e),U=h(e,"P",{"data-svelte-h":!0}),u(U)!=="svelte-1i0y2af"&&(U.textContent=ls),Re=n(e),i(T.$$.fragment,e),ze=n(e),w=h(e,"P",{"data-svelte-h":!0}),u(w)!=="svelte-1ypgfg0"&&(w.innerHTML=as),Fe=n(e),b=h(e,"P",{"data-svelte-h":!0}),u(b)!=="svelte-1c1de84"&&(b.innerHTML=ns),De=n(e),$=h(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-1c79pr0"&&($.textContent=ps),Ee=n(e),i(C.$$.fragment,e),Ye=n(e),i(k.$$.fragment,e),He=n(e),x=h(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-1wuxk0l"&&(x.textContent=is),Ae=n(e),i(Q.$$.fragment,e),Le=n(e),i(N.$$.fragment,e),Ke=n(e),i(B.$$.fragment,e),Pe=n(e),Z=h(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-1wuxk0l"&&(Z.textContent=rs),Oe=n(e),i(v.$$.fragment,e),qe=n(e),i(I.$$.fragment,e),et=n(e),i(V.$$.fragment,e),tt=n(e),S=h(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-1wuxk0l"&&(S.textContent=ms),st=n(e),i(_.$$.fragment,e),lt=n(e),i(X.$$.fragment,e),at=n(e),G=h(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-tjoshe"&&(G.innerHTML=os),nt=n(e),i(W.$$.fragment,e),pt=n(e),R=h(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1wuxk0l"&&(R.textContent=cs),it=n(e),i(z.$$.fragment,e),rt=n(e),i(F.$$.fragment,e),mt=n(e),D=h(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-jci7dg"&&(D.innerHTML=Ms),ot=n(e),i(E.$$.fragment,e),ct=n(e),i(Y.$$.fragment,e),Mt=n(e),H=h(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1wuxk0l"&&(H.textContent=hs),ht=n(e),i(A.$$.fragment,e),ut=n(e),i(L.$$.fragment,e),yt=n(e),i(K.$$.fragment,e),dt=n(e),P=h(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-1wuxk0l"&&(P.textContent=us),ft=n(e),i(O.$$.fragment,e),Jt=n(e),i(q.$$.fragment,e),jt=n(e),ee=h(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-56ounp"&&(ee.textContent=ys),gt=n(e),te=h(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-1j7o0l4"&&(te.innerHTML=ds),Ut=n(e),se=h(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-pd3pcg"&&(se.innerHTML=fs),Tt=n(e),i(le.$$.fragment,e),wt=n(e),i(ae.$$.fragment,e),bt=n(e),ne=h(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1wuxk0l"&&(ne.textContent=Js),$t=n(e),i(pe.$$.fragment,e),Ct=n(e),i(ie.$$.fragment,e),kt=n(e),re=h(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-2ryznm"&&(re.innerHTML=js),xt=n(e),i(me.$$.fragment,e),Qt=n(e),oe=h(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-1wuxk0l"&&(oe.textContent=gs),Nt=n(e),i(ce.$$.fragment,e),Bt=n(e),i(Me.$$.fragment,e),Zt=n(e),he=h(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-18fc4zz"&&(he.textContent=Us),vt=n(e),ue=h(e,"UL",{"data-svelte-h":!0}),u(ue)!=="svelte-1c2ig9e"&&(ue.innerHTML=Ts),It=n(e),i(ye.$$.fragment,e),Vt=n(e),de=h(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-1fuvwot"&&(de.innerHTML=ws),St=n(e),fe=h(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-1s9m3po"&&(fe.innerHTML=bs),_t=n(e),i(Je.$$.fragment,e),Xt=n(e),je=h(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-nvrnid"&&(je.innerHTML=$s),Gt=n(e),i(ge.$$.fragment,e),Wt=n(e),Ue=h(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-1wuxk0l"&&(Ue.textContent=Cs),Rt=n(e),i(Te.$$.fragment,e),zt=n(e),i(we.$$.fragment,e),Ft=n(e),be=h(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-11565gi"&&(be.innerHTML=ks),Dt=n(e),$e=h(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-8sy4p"&&($e.innerHTML=xs),Et=n(e),Ce=h(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-1852v8c"&&(Ce.innerHTML=Qs),Yt=n(e),ke=h(e,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-f9i0wk"&&(ke.innerHTML=Ns),Ht=n(e),xe=h(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-1wflp2q"&&(xe.innerHTML=Bs),At=n(e),i(Qe.$$.fragment,e),Lt=n(e),i(Ne.$$.fragment,e),Kt=n(e),i(Be.$$.fragment,e),Pt=n(e),i(Ze.$$.fragment,e),Ot=n(e),i(ve.$$.fragment,e),qt=n(e),Ve=h(e,"P",{}),Zs(Ve).forEach(s),this.h()},h(){vs(f,"name","hf:doc:metadata"),vs(f,"content",Fs)},m(e,t){Ws(document.head,f),l(e,Se,t),l(e,Ie,t),l(e,_e,t),r(J,e,t),l(e,Xe,t),l(e,j,t),l(e,Ge,t),r(g,e,t),l(e,We,t),l(e,U,t),l(e,Re,t),r(T,e,t),l(e,ze,t),l(e,w,t),l(e,Fe,t),l(e,b,t),l(e,De,t),l(e,$,t),l(e,Ee,t),r(C,e,t),l(e,Ye,t),r(k,e,t),l(e,He,t),l(e,x,t),l(e,Ae,t),r(Q,e,t),l(e,Le,t),r(N,e,t),l(e,Ke,t),r(B,e,t),l(e,Pe,t),l(e,Z,t),l(e,Oe,t),r(v,e,t),l(e,qe,t),r(I,e,t),l(e,et,t),r(V,e,t),l(e,tt,t),l(e,S,t),l(e,st,t),r(_,e,t),l(e,lt,t),r(X,e,t),l(e,at,t),l(e,G,t),l(e,nt,t),r(W,e,t),l(e,pt,t),l(e,R,t),l(e,it,t),r(z,e,t),l(e,rt,t),r(F,e,t),l(e,mt,t),l(e,D,t),l(e,ot,t),r(E,e,t),l(e,ct,t),r(Y,e,t),l(e,Mt,t),l(e,H,t),l(e,ht,t),r(A,e,t),l(e,ut,t),r(L,e,t),l(e,yt,t),r(K,e,t),l(e,dt,t),l(e,P,t),l(e,ft,t),r(O,e,t),l(e,Jt,t),r(q,e,t),l(e,jt,t),l(e,ee,t),l(e,gt,t),l(e,te,t),l(e,Ut,t),l(e,se,t),l(e,Tt,t),r(le,e,t),l(e,wt,t),r(ae,e,t),l(e,bt,t),l(e,ne,t),l(e,$t,t),r(pe,e,t),l(e,Ct,t),r(ie,e,t),l(e,kt,t),l(e,re,t),l(e,xt,t),r(me,e,t),l(e,Qt,t),l(e,oe,t),l(e,Nt,t),r(ce,e,t),l(e,Bt,t),r(Me,e,t),l(e,Zt,t),l(e,he,t),l(e,vt,t),l(e,ue,t),l(e,It,t),r(ye,e,t),l(e,Vt,t),l(e,de,t),l(e,St,t),l(e,fe,t),l(e,_t,t),r(Je,e,t),l(e,Xt,t),l(e,je,t),l(e,Gt,t),r(ge,e,t),l(e,Wt,t),l(e,Ue,t),l(e,Rt,t),r(Te,e,t),l(e,zt,t),r(we,e,t),l(e,Ft,t),l(e,be,t),l(e,Dt,t),l(e,$e,t),l(e,Et,t),l(e,Ce,t),l(e,Yt,t),l(e,ke,t),l(e,Ht,t),l(e,xe,t),l(e,At,t),r(Qe,e,t),l(e,Lt,t),r(Ne,e,t),l(e,Kt,t),r(Be,e,t),l(e,Pt,t),r(Ze,e,t),l(e,Ot,t),r(ve,e,t),l(e,qt,t),l(e,Ve,t),es=!0},p:Vs,i(e){es||(m(J.$$.fragment,e),m(g.$$.fragment,e),m(T.$$.fragment,e),m(C.$$.fragment,e),m(k.$$.fragment,e),m(Q.$$.fragment,e),m(N.$$.fragment,e),m(B.$$.fragment,e),m(v.$$.fragment,e),m(I.$$.fragment,e),m(V.$$.fragment,e),m(_.$$.fragment,e),m(X.$$.fragment,e),m(W.$$.fragment,e),m(z.$$.fragment,e),m(F.$$.fragment,e),m(E.$$.fragment,e),m(Y.$$.fragment,e),m(A.$$.fragment,e),m(L.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(q.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(pe.$$.fragment,e),m(ie.$$.fragment,e),m(me.$$.fragment,e),m(ce.$$.fragment,e),m(Me.$$.fragment,e),m(ye.$$.fragment,e),m(Je.$$.fragment,e),m(ge.$$.fragment,e),m(Te.$$.fragment,e),m(we.$$.fragment,e),m(Qe.$$.fragment,e),m(Ne.$$.fragment,e),m(Be.$$.fragment,e),m(Ze.$$.fragment,e),m(ve.$$.fragment,e),es=!0)},o(e){o(J.$$.fragment,e),o(g.$$.fragment,e),o(T.$$.fragment,e),o(C.$$.fragment,e),o(k.$$.fragment,e),o(Q.$$.fragment,e),o(N.$$.fragment,e),o(B.$$.fragment,e),o(v.$$.fragment,e),o(I.$$.fragment,e),o(V.$$.fragment,e),o(_.$$.fragment,e),o(X.$$.fragment,e),o(W.$$.fragment,e),o(z.$$.fragment,e),o(F.$$.fragment,e),o(E.$$.fragment,e),o(Y.$$.fragment,e),o(A.$$.fragment,e),o(L.$$.fragment,e),o(K.$$.fragment,e),o(O.$$.fragment,e),o(q.$$.fragment,e),o(le.$$.fragment,e),o(ae.$$.fragment,e),o(pe.$$.fragment,e),o(ie.$$.fragment,e),o(me.$$.fragment,e),o(ce.$$.fragment,e),o(Me.$$.fragment,e),o(ye.$$.fragment,e),o(Je.$$.fragment,e),o(ge.$$.fragment,e),o(Te.$$.fragment,e),o(we.$$.fragment,e),o(Qe.$$.fragment,e),o(Ne.$$.fragment,e),o(Be.$$.fragment,e),o(Ze.$$.fragment,e),o(ve.$$.fragment,e),es=!1},d(e){e&&(s(Se),s(Ie),s(_e),s(Xe),s(j),s(Ge),s(We),s(U),s(Re),s(ze),s(w),s(Fe),s(b),s(De),s($),s(Ee),s(Ye),s(He),s(x),s(Ae),s(Le),s(Ke),s(Pe),s(Z),s(Oe),s(qe),s(et),s(tt),s(S),s(st),s(lt),s(at),s(G),s(nt),s(pt),s(R),s(it),s(rt),s(mt),s(D),s(ot),s(ct),s(Mt),s(H),s(ht),s(ut),s(yt),s(dt),s(P),s(ft),s(Jt),s(jt),s(ee),s(gt),s(te),s(Ut),s(se),s(Tt),s(wt),s(bt),s(ne),s($t),s(Ct),s(kt),s(re),s(xt),s(Qt),s(oe),s(Nt),s(Bt),s(Zt),s(he),s(vt),s(ue),s(It),s(Vt),s(de),s(St),s(fe),s(_t),s(Xt),s(je),s(Gt),s(Wt),s(Ue),s(Rt),s(zt),s(Ft),s(be),s(Dt),s($e),s(Et),s(Ce),s(Yt),s(ke),s(Ht),s(xe),s(At),s(Lt),s(Kt),s(Pt),s(Ot),s(qt),s(Ve)),s(f),c(J,e),c(g,e),c(T,e),c(C,e),c(k,e),c(Q,e),c(N,e),c(B,e),c(v,e),c(I,e),c(V,e),c(_,e),c(X,e),c(W,e),c(z,e),c(F,e),c(E,e),c(Y,e),c(A,e),c(L,e),c(K,e),c(O,e),c(q,e),c(le,e),c(ae,e),c(pe,e),c(ie,e),c(me,e),c(ce,e),c(Me,e),c(ye,e),c(Je,e),c(ge,e),c(Te,e),c(we,e),c(Qe,e),c(Ne,e),c(Be,e),c(Ze,e),c(ve,e)}}}const Fs='{"title":"Feature Extraction","local":"feature-extraction","sections":[{"title":"Penultimate Layer Features (Pre-Classifier Features)","local":"penultimate-layer-features-pre-classifier-features","sections":[{"title":"Unpooled","local":"unpooled","sections":[{"title":"forward_features()","local":"forwardfeatures","sections":[],"depth":4},{"title":"Create with no classifier and pooling","local":"create-with-no-classifier-and-pooling","sections":[],"depth":4},{"title":"Remove it later","local":"remove-it-later","sections":[],"depth":4},{"title":"Chaining unpooled output to classifier","local":"chaining-unpooled-output-to-classifier","sections":[],"depth":4}],"depth":3},{"title":"Pooled","local":"pooled","sections":[{"title":"Create with no classifier","local":"create-with-no-classifier","sections":[],"depth":4},{"title":"Remove it later","local":"remove-it-later","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Multi-scale Feature Maps (Feature Pyramid)","local":"multi-scale-feature-maps-feature-pyramid","sections":[{"title":"Create a feature map extraction model","local":"create-a-feature-map-extraction-model","sections":[],"depth":3},{"title":"Query the feature information","local":"query-the-feature-information","sections":[],"depth":3},{"title":"Select specific feature levels or limit the stride","local":"select-specific-feature-levels-or-limit-the-stride","sections":[{"title":"Output index selection","local":"output-index-selection","sections":[],"depth":4},{"title":"Output stride (feature map dilation)","local":"output-stride-feature-map-dilation","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Flexible intermediate feature map extraction","local":"flexible-intermediate-feature-map-extraction","sections":[],"depth":2}],"depth":1}';function Ds(ts){return Ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ls extends _s{constructor(f){super(),Xs(this,f,Ds,zs,Is,{})}}export{Ls as component};
