import{s as Fl,f as Dl,o as Pl,n as ql}from"../chunks/scheduler.f6319a2a.js";import{S as Kl,i as Ol,g as o,s as n,r as J,A as et,h as i,f as t,c as a,j as Ll,u as T,x as M,k as rl,y as lt,a as s,v as w,d as y,t as r,w as c}from"../chunks/index.85aa684c.js";import{T as zl}from"../chunks/Tip.3d397a88.js";import{C as Ie}from"../chunks/CodeBlock.97b48fd2.js";import{D as tt}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as I,E as st}from"../chunks/EditOnGithub.006048dd.js";function nt(re){let p,U='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){p=o("p"),p.innerHTML=U},l(u){p=i(u,"P",{"data-svelte-h":!0}),M(p)!=="svelte-1p1d9vw"&&(p.innerHTML=U)},m(u,d){s(u,p,d)},p:ql,d(u){u&&t(p)}}}function at(re){let p,U="The only way to run LLM-generated code securely is to isolate the execution from your local environment.";return{c(){p=o("p"),p.textContent=U},l(u){p=i(u,"P",{"data-svelte-h":!0}),M(p)!=="svelte-126gpxq"&&(p.textContent=U)},m(u,d){s(u,p,d)},p:ql,d(u){u&&t(p)}}}function ot(re){let p,U,u,d,h,Ue,C,de,j,je,b,me,g,cl='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLM write its actions (the tool calls) in code is much better than the current standard format for tool calling, which is across the industry different shades of “writing actions as a JSON of tools names and arguments to use”.',he,f,ul="Why is code better? Well, because we crafted our code languages specifically to be great at expressing actions performed by a computer. If JSON snippets were a better way, this package would have been written in JSON snippets and the devil would be laughing at us.",Ce,B,Il="Code is just a better way to express actions on a computer. It has better:",be,A,Ul="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training corpus:</strong> why not leverage this benediction of the sky that plenty of quality actions have already been included in LLM training corpus?</li>",ge,x,dl='This is illustrated on the figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',fe,ce,jl,Be,v,ml="This is why we put emphasis on proposing code agents, in this case python agents, which meant putting higher effort on building secure python interpreters.",Ae,Z,xe,k,hl="By default, the <code>CodeAgent</code> runs LLM-generated code in your environment.",ve,$,Cl=`This is inherently risky, LLM-generated code could be harmful to your environment.
One could argue that on the <a href="../conceptual_guides/intro_agents">spectrum of agency</a>, code agents give much higher agency to the LLM on your system than other less agentic setups: this goes hand-in-hand with higher risk.`,Ze,E,bl="So you need to be mindful of security.",ke,W,gl=`To add a first layer of security, code execution in <code>smolagents</code> is not performed by the vanilla Python interpreter.
We have re-built a more secure <code>LocalPythonInterpreter</code> from the ground up.`,$e,G,fl="To be precise, this interpreter works by loading the Abstract Syntax Tree (AST) from your Code and executes it operation by operation, making sure to always follow certain rules:",Ee,N,Bl="<li>By default, imports are disallowed unless they have been explicitly added to an authorization list by the user.<ul><li>Even so, because some innocuous packages like <code>re</code> can give access to potentially harmful packages as in <code>re.subprocess</code>, subpackages that match a list of dangerous patterns are not imported.</li></ul></li> <li>The total count of elementary operations processed is capped to prevent infinite loops and resource bloating.</li> <li>Any operation that has not been explicitly defined in our custom interpreter will raise an error.</li>",We,_,Al="As a result, this interpreter is safer. We have used it on a diversity of use cases, without ever observing any damage to the environment.",Ge,S,xl="However, this solution is certainly not watertight, as no local python sandbox can really be: one could imagine occasions where LLMs fine-tuned for malignant actions could still hurt your environment.",Ne,Q,vl=`For instance, if you have allowed an innocuous package like <code>Pillow</code> to process images, the LLM could generate thousands of image saves to bloat your hard drive.
Other examples of attacks can be found <a href="https://gynvael.coldwind.pl/n/python_sandbox_escape" rel="nofollow">here</a>.`,_e,V,Zl="Running these targeted malicious code snippet require a supply chain attack, meaning the LLM you use has been intoxicated.",Se,R,kl="The likelihood of this happening is low when using well-known LLMs from trusted inference providers, but it is still non-zero.",Qe,m,Ve,H,$l="So if you want to exercise caution, you should use a remote execution sandbox.",Re,Y,El="Here are examples of how to do it.",He,X,Ye,L,Wl="When working with AI agents that execute code, security is paramount. This guide describes how to set up and use secure sandboxes for your agent applications using either E2B cloud sandboxes or local Docker containers.",Xe,z,Le,q,ze,F,Gl='<li>Create an E2B account at <a href="https://e2b.dev" rel="nofollow">e2b.dev</a></li> <li>Install the required packages:</li>',qe,D,Fe,P,De,K,Nl="Here’s a complete example of running an agent in an E2B sandbox:",Pe,O,Ke,ee,Oe,le,el,te,_l='<li><a href="https://docs.docker.com/get-started/get-docker/" rel="nofollow">Install Docker on your system</a></li> <li>Install the Python Docker package:</li>',ll,se,tl,ne,sl,ae,Sl="Create a Dockerfile for your agent environment:",nl,oe,al,ie,Ql="Create a sandbox manager to run code:",ol,Me,il,pe,Ml,Je,Vl="These key practices apply to both E2B and Docker sandboxes:",pl,Te,Rl="<li><p>Resource management</p> <ul><li>Set memory and CPU limits</li> <li>Implement execution timeouts</li> <li>Monitor resource usage</li></ul></li> <li><p>Security</p> <ul><li>Run with minimal privileges</li> <li>Disable unnecessary network access</li> <li>Use environment variables for secrets</li></ul></li> <li><p>Environment</p> <ul><li>Keep dependencies minimal</li> <li>Use fixed package versions</li> <li>If you use base images, update them regularly</li></ul></li> <li><p>Cleanup</p> <ul><li>Always ensure proper cleanup of resources, especially for Docker containers, to avoid having dangling containers eating up resources.</li></ul></li>",Jl,we,Hl="✨ By following these practices and implementing proper cleanup procedures, you can ensure your agent runs safely and efficiently in a sandboxed environment.",Tl,ye,wl,ue,yl;return h=new I({props:{title:"Secure code execution",local:"secure-code-execution",headingTag:"h1"}}),C=new tt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"}]}}),j=new zl({props:{warning:!1,$$slots:{default:[nt]},$$scope:{ctx:re}}}),b=new I({props:{title:"Code agents",local:"code-agents",headingTag:"h3"}}),Z=new I({props:{title:"Local code execution??",local:"local-code-execution",headingTag:"h3"}}),m=new zl({props:{warning:!0,$$slots:{default:[at]},$$scope:{ctx:re}}}),X=new I({props:{title:"Sandbox setup for secure code execution",local:"sandbox-setup-for-secure-code-execution",headingTag:"h2"}}),z=new I({props:{title:"E2B setup",local:"e2b-setup",headingTag:"h3"}}),q=new I({props:{title:"Installation",local:"installation",headingTag:"h4"}}),D=new Ie({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZTJiJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[e2b]&#x27;</span>',wrap:!1}}),P=new I({props:{title:"Running your agent in E2B",local:"running-your-agent-in-e2b",headingTag:"h4"}}),O=new Ie({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> e2b_code_interpreter <span class="hljs-keyword">import</span> Sandbox
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Create the sandbox</span>
sandbox = Sandbox()

<span class="hljs-comment"># Install required packages</span>
sandbox.commands.run(<span class="hljs-string">&quot;pip install smolagents&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code_raise_errors</span>(<span class="hljs-params">sandbox, code: <span class="hljs-built_in">str</span>, verbose: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    execution = sandbox.run_code(
        code,
        envs={<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>: os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}
    )
    <span class="hljs-keyword">if</span> execution.error:
        execution_logs = <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])
        logs = execution_logs
        logs += execution.error.traceback
        <span class="hljs-keyword">raise</span> ValueError(logs)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])

<span class="hljs-comment"># Define your agent application</span>
agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, HfApiModel

# Initialize the agent
agent = CodeAgent(
    model=HfApiModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Run the agent code in the sandbox</span>
execution_logs = run_code_raise_errors(sandbox, agent_code)
<span class="hljs-built_in">print</span>(execution_logs)`,wrap:!1}}),ee=new I({props:{title:"Docker setup",local:"docker-setup",headingTag:"h3"}}),le=new I({props:{title:"Installation",local:"installation",headingTag:"h4"}}),se=new Ie({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRvY2tlcg==",highlighted:"pip install docker",wrap:!1}}),ne=new I({props:{title:"Setting up the docker sandbox",local:"setting-up-the-docker-sandbox",headingTag:"h4"}}),oe=new Ie({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuMTAtYnVsbHNleWUlMEElMEElMjMlMjBJbnN0YWxsJTIwYnVpbGQlMjBkZXBlbmRlbmNpZXMlMEFSVU4lMjBhcHQtZ2V0JTIwdXBkYXRlJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMC0tbm8taW5zdGFsbC1yZWNvbW1lbmRzJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGQtZXNzZW50aWFsJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uMy1kZXYlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjBwaXAlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjBzbW9sYWdlbnRzJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGNsZWFuJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwcm0lMjAtcmYlMjAlMkZ2YXIlMkZsaWIlMkZhcHQlMkZsaXN0cyUyRiolMEElMEElMjMlMjBTZXQlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTBBV09SS0RJUiUyMCUyRmFwcCUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBsaW1pdGVkJTIwcHJpdmlsZWdlcyUwQVVTRVIlMjBub2JvZHklMEElMEElMjMlMjBEZWZhdWx0JTIwY29tbWFuZCUwQUNNRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ0NvbnRhaW5lciUyMHJlYWR5JyklMjIlNUQ=",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.10</span>-bullseye

<span class="hljs-comment"># Install build dependencies</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> apt-get update &amp;&amp; \\
    apt-get install -y --no-install-recommends \\
        build-essential \\
        python3-dev &amp;&amp; \\
    pip install --no-cache-dir --upgrade pip &amp;&amp; \\
    pip install --no-cache-dir smolagents &amp;&amp; \\
    apt-get clean &amp;&amp; \\
    <span class="hljs-built_in">rm</span> -rf /var/lib/apt/lists/*</span>

<span class="hljs-comment"># Set working directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-comment"># Run with limited privileges</span>
<span class="hljs-keyword">USER</span> nobody

<span class="hljs-comment"># Default command</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Container ready&#x27;)&quot;</span>]</span>`,wrap:!1}}),Me=new Ie({props:{code:"aW1wb3J0JTIwZG9ja2VyJTBBaW1wb3J0JTIwb3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwT3B0aW9uYWwlMEElMEFjbGFzcyUyMERvY2tlclNhbmRib3glM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2xpZW50JTIwJTNEJTIwZG9ja2VyLmZyb21fZW52KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmNvbnRhaW5lciUyMCUzRCUyME5vbmUlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBjcmVhdGVfY29udGFpbmVyKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMkMlMjBidWlsZF9sb2dzJTIwJTNEJTIwc2VsZi5jbGllbnQuaW1hZ2VzLmJ1aWxkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhdGglM0QlMjIuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFnJTNEJTIyYWdlbnQtc2FuZGJveCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvcmNlcm0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGRhcmdzJTNEJTdCJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVjb2RlJTNEVHJ1ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleGNlcHQlMjBkb2NrZXIuZXJyb3JzLkJ1aWxkRXJyb3IlMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjJCdWlsZCUyMGVycm9yJTIwbG9ncyUzQSUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBsb2clMjBpbiUyMGUuYnVpbGRfbG9nJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjAnc3RyZWFtJyUyMGluJTIwbG9nJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQobG9nJTVCJ3N0cmVhbSclNUQuc3RyaXAoKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENyZWF0ZSUyMGNvbnRhaW5lciUyMHdpdGglMjBzZWN1cml0eSUyMGNvbnN0cmFpbnRzJTIwYW5kJTIwcHJvcGVyJTIwbG9nZ2luZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY29udGFpbmVyJTIwJTNEJTIwc2VsZi5jbGllbnQuY29udGFpbmVycy5ydW4oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWdlbnQtc2FuZGJveCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlMjJ0YWlsJTIwLWYlMjAlMkZkZXYlMkZudWxsJTIyJTJDJTIwJTIwJTIzJTIwS2VlcCUyMGNvbnRhaW5lciUyMHJ1bm5pbmclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZXRhY2glM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHR5JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lbV9saW1pdCUzRCUyMjUxMm0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjcHVfcXVvdGElM0Q1MDAwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBpZHNfbGltaXQlM0QxMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWN1cml0eV9vcHQlM0QlNUIlMjJuby1uZXctcHJpdmlsZWdlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcF9kcm9wJTNEJTVCJTIyQUxMJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW52aXJvbm1lbnQlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIRl9UT0tFTiUyMiUzQSUyMG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcnVuX2NvZGUoc2VsZiUyQyUyMGNvZGUlM0ElMjBzdHIpJTIwLSUzRSUyME9wdGlvbmFsJTVCc3RyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBzZWxmLmNvbnRhaW5lciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY3JlYXRlX2NvbnRhaW5lcigpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRXhlY3V0ZSUyMGNvZGUlMjBpbiUyMGNvbnRhaW5lciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4ZWNfcmVzdWx0JTIwJTNEJTIwc2VsZi5jb250YWluZXIuZXhlY19ydW4oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY21kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIyLWMlMjIlMkMlMjBjb2RlJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdXNlciUzRCUyMm5vYm9keSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDb2xsZWN0JTIwYWxsJTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhlY19yZXN1bHQub3V0cHV0LmRlY29kZSgpJTIwaWYlMjBleGVjX3Jlc3VsdC5vdXRwdXQlMjBlbHNlJTIwTm9uZSUwQSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGNsZWFudXAoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNlbGYuY29udGFpbmVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5jb250YWluZXIuc3RvcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhjZXB0JTIwZG9ja2VyLmVycm9ycy5Ob3RGb3VuZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENvbnRhaW5lciUyMGFscmVhZHklMjByZW1vdmVkJTJDJTIwdGhpcyUyMGlzJTIwZXhwZWN0ZWQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXNzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkVycm9yJTIwZHVyaW5nJTIwY2xlYW51cCUzQSUyMCU3QmUlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmluYWxseSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY29udGFpbmVyJTIwJTNEJTIwTm9uZSUyMCUyMCUyMyUyMENsZWFyJTIwdGhlJTIwcmVmZXJlbmNlJTBBJTBBJTIzJTIwRXhhbXBsZSUyMHVzYWdlJTNBJTBBc2FuZGJveCUyMCUzRCUyMERvY2tlclNhbmRib3goKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMERlZmluZSUyMHlvdXIlMjBhZ2VudCUyMGNvZGUlMEElMjAlMjAlMjAlMjBhZ2VudF9jb2RlJTIwJTNEJTIwJTIyJTIyJTIyJTBBaW1wb3J0JTIwb3MlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMEhmQXBpTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwYWdlbnQlMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzREhmQXBpTW9kZWwodG9rZW4lM0Rvcy5nZXRlbnYoJTIySEZfVE9LRU4lMjIpJTJDJTIwcHJvdmlkZXIlM0QlMjJ0b2dldGhlciUyMiklMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUwQSklMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhZ2VudCUwQXJlc3BvbnNlJTIwJTNEJTIwYWdlbnQucnVuKCUyMldoYXQncyUyMHRoZSUyMDIwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIpJTBBcHJpbnQocmVzcG9uc2UpJTBBJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUnVuJTIwdGhlJTIwY29kZSUyMGluJTIwdGhlJTIwc2FuZGJveCUwQSUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMHNhbmRib3gucnVuX2NvZGUoYWdlbnRfY29kZSklMEElMjAlMjAlMjAlMjBwcmludChvdXRwdXQpJTBBJTBBZmluYWxseSUzQSUwQSUyMCUyMCUyMCUyMHNhbmRib3guY2xlYW51cCgp",highlighted:`<span class="hljs-keyword">import</span> docker
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DockerSandbox</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.client = docker.from_env()
        self.container = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">create_container</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">try</span>:
            image, build_logs = self.client.images.build(
                path=<span class="hljs-string">&quot;.&quot;</span>,
                tag=<span class="hljs-string">&quot;agent-sandbox&quot;</span>,
                rm=<span class="hljs-literal">True</span>,
                forcerm=<span class="hljs-literal">True</span>,
                buildargs={},
                <span class="hljs-comment"># decode=True</span>
            )
        <span class="hljs-keyword">except</span> docker.errors.BuildError <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Build error logs:&quot;</span>)
            <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> e.build_log:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;stream&#x27;</span> <span class="hljs-keyword">in</span> log:
                    <span class="hljs-built_in">print</span>(log[<span class="hljs-string">&#x27;stream&#x27;</span>].strip())
            <span class="hljs-keyword">raise</span>

        <span class="hljs-comment"># Create container with security constraints and proper logging</span>
        self.container = self.client.containers.run(
            <span class="hljs-string">&quot;agent-sandbox&quot;</span>,
            command=<span class="hljs-string">&quot;tail -f /dev/null&quot;</span>,  <span class="hljs-comment"># Keep container running</span>
            detach=<span class="hljs-literal">True</span>,
            tty=<span class="hljs-literal">True</span>,
            mem_limit=<span class="hljs-string">&quot;512m&quot;</span>,
            cpu_quota=<span class="hljs-number">50000</span>,
            pids_limit=<span class="hljs-number">100</span>,
            security_opt=[<span class="hljs-string">&quot;no-new-privileges&quot;</span>],
            cap_drop=[<span class="hljs-string">&quot;ALL&quot;</span>],
            environment={
                <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
            },
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code</span>(<span class="hljs-params">self, code: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.container:
            self.create_container()

        <span class="hljs-comment"># Execute code in container</span>
        exec_result = self.container.exec_run(
            cmd=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, code],
            user=<span class="hljs-string">&quot;nobody&quot;</span>
        )

        <span class="hljs-comment"># Collect all output</span>
        <span class="hljs-keyword">return</span> exec_result.output.decode() <span class="hljs-keyword">if</span> exec_result.output <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>


    <span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.container:
            <span class="hljs-keyword">try</span>:
                self.container.stop()
            <span class="hljs-keyword">except</span> docker.errors.NotFound:
                <span class="hljs-comment"># Container already removed, this is expected</span>
                <span class="hljs-keyword">pass</span>
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error during cleanup: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">finally</span>:
                self.container = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Clear the reference</span>

<span class="hljs-comment"># Example usage:</span>
sandbox = DockerSandbox()

<span class="hljs-keyword">try</span>:
    <span class="hljs-comment"># Define your agent code</span>
    agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, HfApiModel

# Initialize the agent
agent = CodeAgent(
    model=HfApiModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Run the code in the sandbox</span>
    output = sandbox.run_code(agent_code)
    <span class="hljs-built_in">print</span>(output)

<span class="hljs-keyword">finally</span>:
    sandbox.cleanup()`,wrap:!1}}),pe=new I({props:{title:"Best practices for sandboxes",local:"best-practices-for-sandboxes",headingTag:"h3"}}),ye=new st({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/secure_code_execution.mdx"}}),{c(){p=o("meta"),U=n(),u=o("p"),d=n(),J(h.$$.fragment),Ue=n(),J(C.$$.fragment),de=n(),J(j.$$.fragment),je=n(),J(b.$$.fragment),me=n(),g=o("p"),g.innerHTML=cl,he=n(),f=o("p"),f.textContent=ul,Ce=n(),B=o("p"),B.textContent=Il,be=n(),A=o("ul"),A.innerHTML=Ul,ge=n(),x=o("p"),x.innerHTML=dl,fe=n(),ce=o("img"),Be=n(),v=o("p"),v.textContent=ml,Ae=n(),J(Z.$$.fragment),xe=n(),k=o("p"),k.innerHTML=hl,ve=n(),$=o("p"),$.innerHTML=Cl,Ze=n(),E=o("p"),E.textContent=bl,ke=n(),W=o("p"),W.innerHTML=gl,$e=n(),G=o("p"),G.textContent=fl,Ee=n(),N=o("ul"),N.innerHTML=Bl,We=n(),_=o("p"),_.textContent=Al,Ge=n(),S=o("p"),S.textContent=xl,Ne=n(),Q=o("p"),Q.innerHTML=vl,_e=n(),V=o("p"),V.textContent=Zl,Se=n(),R=o("p"),R.textContent=kl,Qe=n(),J(m.$$.fragment),Ve=n(),H=o("p"),H.textContent=$l,Re=n(),Y=o("p"),Y.textContent=El,He=n(),J(X.$$.fragment),Ye=n(),L=o("p"),L.textContent=Wl,Xe=n(),J(z.$$.fragment),Le=n(),J(q.$$.fragment),ze=n(),F=o("ol"),F.innerHTML=Gl,qe=n(),J(D.$$.fragment),Fe=n(),J(P.$$.fragment),De=n(),K=o("p"),K.textContent=Nl,Pe=n(),J(O.$$.fragment),Ke=n(),J(ee.$$.fragment),Oe=n(),J(le.$$.fragment),el=n(),te=o("ol"),te.innerHTML=_l,ll=n(),J(se.$$.fragment),tl=n(),J(ne.$$.fragment),sl=n(),ae=o("p"),ae.textContent=Sl,nl=n(),J(oe.$$.fragment),al=n(),ie=o("p"),ie.textContent=Ql,ol=n(),J(Me.$$.fragment),il=n(),J(pe.$$.fragment),Ml=n(),Je=o("p"),Je.textContent=Vl,pl=n(),Te=o("ul"),Te.innerHTML=Rl,Jl=n(),we=o("p"),we.textContent=Hl,Tl=n(),J(ye.$$.fragment),wl=n(),ue=o("p"),this.h()},l(e){const l=et("svelte-u9bgzb",document.head);p=i(l,"META",{name:!0,content:!0}),l.forEach(t),U=a(e),u=i(e,"P",{}),Ll(u).forEach(t),d=a(e),T(h.$$.fragment,e),Ue=a(e),T(C.$$.fragment,e),de=a(e),T(j.$$.fragment,e),je=a(e),T(b.$$.fragment,e),me=a(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1nor5c0"&&(g.innerHTML=cl),he=a(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1b2f48c"&&(f.textContent=ul),Ce=a(e),B=i(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1jp5kiv"&&(B.textContent=Il),be=a(e),A=i(e,"UL",{"data-svelte-h":!0}),M(A)!=="svelte-a7ou7n"&&(A.innerHTML=Ul),ge=a(e),x=i(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1ugtxvn"&&(x.innerHTML=dl),fe=a(e),ce=i(e,"IMG",{src:!0}),Be=a(e),v=i(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1lbgv3o"&&(v.textContent=ml),Ae=a(e),T(Z.$$.fragment,e),xe=a(e),k=i(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-19p3p3d"&&(k.innerHTML=hl),ve=a(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-102urw8"&&($.innerHTML=Cl),Ze=a(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1aiwpgt"&&(E.textContent=bl),ke=a(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-19wx21x"&&(W.innerHTML=gl),$e=a(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-180snho"&&(G.textContent=fl),Ee=a(e),N=i(e,"UL",{"data-svelte-h":!0}),M(N)!=="svelte-eu8x2q"&&(N.innerHTML=Bl),We=a(e),_=i(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-df6dcg"&&(_.textContent=Al),Ge=a(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1xn198z"&&(S.textContent=xl),Ne=a(e),Q=i(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-u02p3p"&&(Q.innerHTML=vl),_e=a(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1u5rz9v"&&(V.textContent=Zl),Se=a(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-31qg8m"&&(R.textContent=kl),Qe=a(e),T(m.$$.fragment,e),Ve=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-pv9x3v"&&(H.textContent=$l),Re=a(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-7irprr"&&(Y.textContent=El),He=a(e),T(X.$$.fragment,e),Ye=a(e),L=i(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-6dqx27"&&(L.textContent=Wl),Xe=a(e),T(z.$$.fragment,e),Le=a(e),T(q.$$.fragment,e),ze=a(e),F=i(e,"OL",{"data-svelte-h":!0}),M(F)!=="svelte-uvtwg2"&&(F.innerHTML=Gl),qe=a(e),T(D.$$.fragment,e),Fe=a(e),T(P.$$.fragment,e),De=a(e),K=i(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-lr4w3e"&&(K.textContent=Nl),Pe=a(e),T(O.$$.fragment,e),Ke=a(e),T(ee.$$.fragment,e),Oe=a(e),T(le.$$.fragment,e),el=a(e),te=i(e,"OL",{"data-svelte-h":!0}),M(te)!=="svelte-1ccrdvy"&&(te.innerHTML=_l),ll=a(e),T(se.$$.fragment,e),tl=a(e),T(ne.$$.fragment,e),sl=a(e),ae=i(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-1m1zn33"&&(ae.textContent=Sl),nl=a(e),T(oe.$$.fragment,e),al=a(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-8mtm8c"&&(ie.textContent=Ql),ol=a(e),T(Me.$$.fragment,e),il=a(e),T(pe.$$.fragment,e),Ml=a(e),Je=i(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-5fyo5r"&&(Je.textContent=Vl),pl=a(e),Te=i(e,"UL",{"data-svelte-h":!0}),M(Te)!=="svelte-162p62u"&&(Te.innerHTML=Rl),Jl=a(e),we=i(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-1hbg2e4"&&(we.textContent=Hl),Tl=a(e),T(ye.$$.fragment,e),wl=a(e),ue=i(e,"P",{}),Ll(ue).forEach(t),this.h()},h(){rl(p,"name","hf:doc:metadata"),rl(p,"content",it),Dl(ce.src,jl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||rl(ce,"src",jl)},m(e,l){lt(document.head,p),s(e,U,l),s(e,u,l),s(e,d,l),w(h,e,l),s(e,Ue,l),w(C,e,l),s(e,de,l),w(j,e,l),s(e,je,l),w(b,e,l),s(e,me,l),s(e,g,l),s(e,he,l),s(e,f,l),s(e,Ce,l),s(e,B,l),s(e,be,l),s(e,A,l),s(e,ge,l),s(e,x,l),s(e,fe,l),s(e,ce,l),s(e,Be,l),s(e,v,l),s(e,Ae,l),w(Z,e,l),s(e,xe,l),s(e,k,l),s(e,ve,l),s(e,$,l),s(e,Ze,l),s(e,E,l),s(e,ke,l),s(e,W,l),s(e,$e,l),s(e,G,l),s(e,Ee,l),s(e,N,l),s(e,We,l),s(e,_,l),s(e,Ge,l),s(e,S,l),s(e,Ne,l),s(e,Q,l),s(e,_e,l),s(e,V,l),s(e,Se,l),s(e,R,l),s(e,Qe,l),w(m,e,l),s(e,Ve,l),s(e,H,l),s(e,Re,l),s(e,Y,l),s(e,He,l),w(X,e,l),s(e,Ye,l),s(e,L,l),s(e,Xe,l),w(z,e,l),s(e,Le,l),w(q,e,l),s(e,ze,l),s(e,F,l),s(e,qe,l),w(D,e,l),s(e,Fe,l),w(P,e,l),s(e,De,l),s(e,K,l),s(e,Pe,l),w(O,e,l),s(e,Ke,l),w(ee,e,l),s(e,Oe,l),w(le,e,l),s(e,el,l),s(e,te,l),s(e,ll,l),w(se,e,l),s(e,tl,l),w(ne,e,l),s(e,sl,l),s(e,ae,l),s(e,nl,l),w(oe,e,l),s(e,al,l),s(e,ie,l),s(e,ol,l),w(Me,e,l),s(e,il,l),w(pe,e,l),s(e,Ml,l),s(e,Je,l),s(e,pl,l),s(e,Te,l),s(e,Jl,l),s(e,we,l),s(e,Tl,l),w(ye,e,l),s(e,wl,l),s(e,ue,l),yl=!0},p(e,[l]){const Yl={};l&2&&(Yl.$$scope={dirty:l,ctx:e}),j.$set(Yl);const Xl={};l&2&&(Xl.$$scope={dirty:l,ctx:e}),m.$set(Xl)},i(e){yl||(y(h.$$.fragment,e),y(C.$$.fragment,e),y(j.$$.fragment,e),y(b.$$.fragment,e),y(Z.$$.fragment,e),y(m.$$.fragment,e),y(X.$$.fragment,e),y(z.$$.fragment,e),y(q.$$.fragment,e),y(D.$$.fragment,e),y(P.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(Me.$$.fragment,e),y(pe.$$.fragment,e),y(ye.$$.fragment,e),yl=!0)},o(e){r(h.$$.fragment,e),r(C.$$.fragment,e),r(j.$$.fragment,e),r(b.$$.fragment,e),r(Z.$$.fragment,e),r(m.$$.fragment,e),r(X.$$.fragment,e),r(z.$$.fragment,e),r(q.$$.fragment,e),r(D.$$.fragment,e),r(P.$$.fragment,e),r(O.$$.fragment,e),r(ee.$$.fragment,e),r(le.$$.fragment,e),r(se.$$.fragment,e),r(ne.$$.fragment,e),r(oe.$$.fragment,e),r(Me.$$.fragment,e),r(pe.$$.fragment,e),r(ye.$$.fragment,e),yl=!1},d(e){e&&(t(U),t(u),t(d),t(Ue),t(de),t(je),t(me),t(g),t(he),t(f),t(Ce),t(B),t(be),t(A),t(ge),t(x),t(fe),t(ce),t(Be),t(v),t(Ae),t(xe),t(k),t(ve),t($),t(Ze),t(E),t(ke),t(W),t($e),t(G),t(Ee),t(N),t(We),t(_),t(Ge),t(S),t(Ne),t(Q),t(_e),t(V),t(Se),t(R),t(Qe),t(Ve),t(H),t(Re),t(Y),t(He),t(Ye),t(L),t(Xe),t(Le),t(ze),t(F),t(qe),t(Fe),t(De),t(K),t(Pe),t(Ke),t(Oe),t(el),t(te),t(ll),t(tl),t(sl),t(ae),t(nl),t(al),t(ie),t(ol),t(il),t(Ml),t(Je),t(pl),t(Te),t(Jl),t(we),t(Tl),t(wl),t(ue)),t(p),c(h,e),c(C,e),c(j,e),c(b,e),c(Z,e),c(m,e),c(X,e),c(z,e),c(q,e),c(D,e),c(P,e),c(O,e),c(ee,e),c(le,e),c(se,e),c(ne,e),c(oe,e),c(Me,e),c(pe,e),c(ye,e)}}}const it='{"title":"Secure code execution","local":"secure-code-execution","sections":[{"title":"Code agents","local":"code-agents","sections":[],"depth":3},{"title":"Local code execution??","local":"local-code-execution","sections":[],"depth":3},{"title":"Sandbox setup for secure code execution","local":"sandbox-setup-for-secure-code-execution","sections":[{"title":"E2B setup","local":"e2b-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B","local":"running-your-agent-in-e2b","sections":[],"depth":4}],"depth":3},{"title":"Docker setup","local":"docker-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Setting up the docker sandbox","local":"setting-up-the-docker-sandbox","sections":[],"depth":4}],"depth":3},{"title":"Best practices for sandboxes","local":"best-practices-for-sandboxes","sections":[],"depth":3}],"depth":2}],"depth":1}';function Mt(re){return Pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ct extends Kl{constructor(p){super(),Ol(this,p,Mt,ot,Fl,{})}}export{ct as component};
