import{s as ct,n as dt,o as wt}from"../chunks/scheduler.f3b1e791.js";import{S as Ct,i as ut,e as n,s,c as r,h as jt,a,d as t,b as i,f as Jt,g as y,j as J,k as mt,l as It,m as M,n as o,t as p,o as U,p as T}from"../chunks/index.023a9934.js";import{C as ft,H as c,E as ht}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6c1bfd95.js";import{C as m}from"../chunks/CodeBlock.627e0785.js";function At(Zl){let d,ge,Ae,ke,w,$e,C,Ee,u,Gl=`A kernel can provide layers in addition to kernel functions. A layer from
the Hub can replace the <code>forward</code> method of an existing layer for a certain
device type. This makes it possible to provide more performant kernels for
existing layers.`,Re,j,Ll=`See <a href="kernel-requirements.md">Kernel requirements</a> for more information on the
requirements of Hub layers.`,ve,I,Ne,f,Be,h,Wl=`A layer can be made extensible with the <code>use_kernel_forward_from_hub</code>
decorator. For example:`,_e,A,Se,b,Ql=`The decorator does not change the behavior of the class — it annotates
the class with the given name (here <code>SiluAndMul</code>). The <code>kernelize</code> function
described below uses this name to look up kernels for the layer.`,Ze,g,Ge,k,Hl=`An existing layer that does not (yet) have the <code>use_kernel_forward_from_hub</code>
decorator can be made extensible using the <code>replace_kernel_forward_from_hub</code>
function:`,Le,$,We,E,xl=`<strong>Warning:</strong> we strongly recommend using layers with a decorator, since
it signifies that the maintainer intends to keep the <code>forward</code> signature
compatible with layers from the hub.`,Qe,R,He,v,Vl=`A model will not use Hub kernels by default, even if it contains extensible
layers. To enable the use of Hub kernels in the model, it needs to be
‘kernelized’ using the <code>kernelize</code> function. This function traverses the
model graph and replaces the <code>forward</code> methods of extensible layers for which
Hub kernels are registered. <code>kernelize</code> can be used as follows:`,xe,N,Ve,B,Xl=`The <code>kernelize</code> function modifies the model in-place, the model itself is
returned as a convenience. The <code>mode</code> specifies that the model will be used
in inference. Similarly, you can ask <code>kernelize</code> to prepare the model for
training:`,Xe,_,Fe,S,Fl=`A model that is kernelized for training can also be used for inference, but
not the other way around. If you want to change the mode of the kernelized
model, you can just run <code>kernelize</code> on the model again with the new mode.`,qe,Z,ql=`If you want to compile a model with <code>torch.compile</code>, this should be indicated
in the mode as well. You can do this by combining <code>Mode.INFERENCE</code> or
<code>Mode.TRAINING</code> with <code>Mode.TORCH_COMPILE</code> using the set union (<code>|</code>) operator:`,ze,G,Ye,L,Pe,W,zl=`Kernels can be registered per device type. For instance, separate <code>cuda</code> and
<code>metal</code> kernels could be registered for the name <code>SiluAndMul</code>. By default,
<code>kernelize</code> will try to infer the device type from the model’s parameters.
You can pass the device type to <code>kernelize</code> if the device type cannot be
inferred (e.g. because the model has no parameters):`,Oe,Q,Ke,H,De,x,Yl=`If the <code>TRAINING</code> and/or <code>TORCH_COMPILE</code> modes are used, but a registered
kernel does not support backward passes or <code>torch.compile</code> respectively,
<code>kernelize</code> will fall back to the original, non-kernelized, layer. You
can let <code>kernelize</code> raise an exception instead by using <code>use_fallback=False</code>:`,el,V,ll,X,Pl="This can be useful if you want to guarantee that Hub kernels are used.",tl,F,Ml,q,Ol=`The kernels that are used are logged at the <code>INFO</code> level by <code>kernelize</code>.
See the <a href="https://docs.python.org/3/library/logging.html" rel="nofollow">Python logging</a>
documentation for information on how to configure logging.`,sl,z,il,Y,Kl=`<code>kernelize</code> relies on kernel mappings to find Hub kernels for layers.
Kernel mappings map a kernel name such as <code>SiluAndMul</code> to a kernel on
the Hub. For example:`,nl,P,al,O,Dl="You can register such a mapping using <code>register_kernel_mapping</code>:",rl,K,yl,D,et=`This will register the kernel mapping in the current context, which is
normally global. It is recommended to scope the mapping to where it is
used with the <code>use_kernel_mapping</code> context manager:`,ol,ee,pl,le,lt=`This ensures that the mapping is not active anymore outside the
<code>with</code>-scope.`,Ul,te,Tl,Me,tt=`Kernels are versioned using tags of the form <code>v&lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;</code>.
You can specify which version of the kernel to download using Python version
specifiers:`,Jl,se,ml,ie,Mt=`This will get the layer from latest kernel tagged <code>v0.0.z</code> where <code>z</code> is at
least 4. It is strongly recommended to specify a version bound, since a
kernel author might push incompatible changes to the <code>main</code> branch.`,cl,ne,dl,ae,st=`You might want to register two different kernels for a particular layer,
where one kernel is optimized for a specific mode. You can do so by
registering layer repositories for specific modes. For example:`,wl,re,Cl,ye,it=`The <code>kernelize</code> function will attempt to use the following registered
kernels for a given mode:`,ul,oe,nt=`<li><code>INFERENCE</code>: <code>INFERENCE</code> → <code>INFERENCE | TORCH_COMPILE</code> → <code>TRAINING</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>INFERENCE | TORCH_COMPILE</code>: <code>INFERENCE | TORCH_COMPILE</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING</code>: <code>TRAINING</code> → <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING | TORCH_COMPILE</code>: <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li>`,jl,pe,at=`<code>Mode.FALLBACK</code> is a special mode that is used when no other mode matches. It
is also used when a kernel is registered without a mode, as described in the
previous section.`,Il,Ue,fl,Te,rt=`In this case, both <code>Mode.INFERENCE | Mode.TORCH_COMPILE</code> and
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> will use the <code>Mode.FALLBACK</code> kernel,
since the other kernels do not support <code>torch.compile</code>.`,hl,Je,Al,me,yt=`Some kernels only work with newer CUDA architectures. For instance, some
kernels require capability 9.0 for the TMA unit on Hopper GPUs. <code>kernels</code>
supports registering layers for a range of CUDA capabilities. To do so,
you need to register the layer for a <code>Device</code> with type <code>cuda</code> and
set the supported range of CUDA capabilities with using <code>CUDAProperties</code>:`,bl,ce,gl,de,ot="Capabilities behave as follows:",kl,we,pt=`<li><p>The minimum and maximum capabilities are inclusive.</p></li> <li><p>When a new kernel is registered with the same min/max capabilities as
an existing kernel, the new kernel will replace the old kernel.</p></li> <li><p>When there are multiple kernels that support a capability, the kernel
with the smaller capability interval will be used. E.g. given:</p> <ul><li><code>KernelA</code> with <code>min_capability=80</code> and <code>max_capability=89</code>;</li> <li><code>KernelB</code> with <code>min_capability=75</code> and <code>max_capability=89</code>;</li> <li><code>kernelize</code> runs on a system with capability 8.6.</li></ul> <p>Then <code>KernelA</code> will be used because the interval 80..89 is smaller
than 75..89. The motivation is that kernels with smaller ranges
tend to be more optimized for a specific set of GPUs. <strong>This behavior
might still change in the future.</strong></p></li>`,$l,Ce,El,ue,Ut=`Registering kernels for the ROCm architecture follows the exact same
pattern as CUDA kernels, using <code>min_capability</code> and <code>max_capability</code> to restrict
a kernel to a range of ROCm capabilities.`,Rl,je,vl,Ie,Tt=`The <code>LocalLayerRepository</code> class is provided to load a repository from
a local directory. For example:`,Nl,fe,Bl,he,_l,be,Sl;return w=new ft({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new c({props:{title:"Layers",local:"layers",headingTag:"h1"}}),I=new c({props:{title:"Making a layer extensible with kernels from the hub",local:"making-a-layer-extensible-with-kernels-from-the-hub",headingTag:"h2"}}),f=new c({props:{title:"Using a decorator",local:"using-a-decorator",headingTag:"h3"}}),A=new m({props:{code:"JTQwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViKCUyMlNpbHVBbmRNdWwlMjIpJTBBY2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBpbnB1dCUzQSUyMHRvcmNoLlRlbnNvciklMjAtJTNFJTIwdG9yY2guVGVuc29yJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZCUyMCUzRCUyMGlucHV0LnNoYXBlJTVCLTElNUQlMjAlMkYlMkYlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zaWx1KGlucHV0JTVCLi4uJTJDJTIwJTNBZCU1RCklMjAqJTIwaW5wdXQlNUIuLi4lMkMlMjBkJTNBJTVE",highlighted:`<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, <span class="hljs-built_in">input</span>: torch.Tensor</span>) -&gt; torch.Tensor:
        d = <span class="hljs-built_in">input</span>.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(<span class="hljs-built_in">input</span>[..., :d]) * <span class="hljs-built_in">input</span>[..., d:]`,wrap:!1}}),g=new c({props:{title:"External layers",local:"external-layers",headingTag:"h3"}}),$=new m({props:{code:"ZnJvbSUyMHNvbWVsaWJyYXJ5JTIwaW1wb3J0JTIwU2lsdUFuZE11bCUwQSUwQXJlcGxhY2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIoU2lsdUFuZE11bCUyQyUyMCUyMlNpbHVBbmRNdWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> somelibrary <span class="hljs-keyword">import</span> SiluAndMul

replace_kernel_forward_from_hub(SiluAndMul, <span class="hljs-string">&quot;SiluAndMul&quot;</span>)`,wrap:!1}}),R=new c({props:{title:"Kernelizing a model",local:"kernelizing-a-model",headingTag:"h2"}}),N=new m({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSk=",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE)`,wrap:!1}}),_=new m({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLlRSQUlOSU5HKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.TRAINING)`,wrap:!1}}),G=new m({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEElMEElMjMlMjBJbmZlcmVuY2UlMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSklMEElMEElMjMlMjBUcmFpbmluZyUwQW1vZGVsJTIwJTNEJTIwa2VybmVsaXplKG1vZGVsJTJDJTIwbW9kZSUzRE1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUp",highlighted:`model = MyModel(...)

<span class="hljs-comment"># Inference</span>
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE)

<span class="hljs-comment"># Training</span>
model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),L=new c({props:{title:"Kernel device",local:"kernel-device",headingTag:"h3"}}),Q=new m({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBtb2RlJTNETW9kZS5JTkZFUkVOQ0Up",highlighted:`model = MyModel(...)
model = kernelize(model, device=<span class="hljs-string">&quot;cuda&quot;</span>, mode=Mode.INFERENCE)`,wrap:!1}}),H=new c({props:{title:"Fallback forward",local:"fallback-forward",headingTag:"h3"}}),V=new m({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSUyQyUyMHVzZV9mYWxsYmFjayUzREZhbHNlKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE, use_fallback=<span class="hljs-literal">False</span>)`,wrap:!1}}),F=new c({props:{title:"Inspecting which kernels are used",local:"inspecting-which-kernels-are-used",headingTag:"h3"}}),z=new c({props:{title:"Registering a hub kernel for a layer",local:"registering-a-hub-kernel-for-a-layer",headingTag:"h2"}}),P=new m({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9jbSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
        <span class="hljs-string">&quot;rocm&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}`,wrap:!1}}),K=new m({props:{code:"cmVnaXN0ZXJfa2VybmVsX21hcHBpbmcoa2VybmVsX2xheWVyX21hcHBpbmcp",highlighted:"register_kernel_mapping(kernel_layer_mapping)",wrap:!1}}),ee=new m({props:{code:"d2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyhrZXJuZWxfbGF5ZXJfbWFwcGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBsYXllciUyMGZvciUyMHdoaWNoJTIwdGhlJTIwbWFwcGluZyUyMGlzJTIwYXBwbGllZC4lMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLlRSQUlOSU5HJTIwJTdDJTIwTW9kZS5UT1JDSF9DT01QSUxFKQ==",highlighted:`<span class="hljs-keyword">with</span> use_kernel_mapping(kernel_layer_mapping):
    <span class="hljs-comment"># Use the layer for which the mapping is applied.</span>
    model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),te=new c({props:{title:"Using version bounds",local:"using-version-bounds",headingTag:"h3"}}),se=new m({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2ZXJzaW9uJTNEJTIyJTNFJTNEMC4wLjQlMkMlM0MwLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2NtJTIyJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZlcnNpb24lM0QlMjIlM0UlM0QwLjAuNCUyQyUzQzAuMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            version=<span class="hljs-string">&quot;&gt;=0.0.4,&lt;0.1.0&quot;</span>,
        ),
        <span class="hljs-string">&quot;rocm&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            version=<span class="hljs-string">&quot;&gt;=0.0.4,&lt;0.1.0&quot;</span>,
        )
    }
}`,wrap:!1}}),ne=new c({props:{title:"Registering kernels for specific modes",local:"registering-kernels-for-specific-modes",headingTag:"h3"}}),re=new m({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUlM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
          Mode.INFERENCE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
          Mode.TRAINING | Mode.TORCH_COMPILE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
      }
    }
}`,wrap:!1}}),Ue=new m({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuRkFMTEJBQ0slM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
            Mode.FALLBACK: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.INFERENCE: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.TRAINING: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
        }
    }
}`,wrap:!1}}),Je=new c({props:{title:"Registering kernels for specific CUDA capabilities",local:"registering-kernels-for-specific-cuda-capabilities",headingTag:"h3"}}),ce=new m({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGV2aWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvcGVydGllcyUzRENVREFQcm9wZXJ0aWVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1pbl9jYXBhYmlsaXR5JTNENzUlMkMlMjBtYXhfY2FwYWJpbGl0eSUzRDg5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMERldmljZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNEJTIyY3VkYSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb3BlcnRpZXMlM0RDVURBUHJvcGVydGllcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtaW5fY2FwYWJpbGl0eSUzRDkwJTJDJTIwbWF4X2NhcGFiaWxpdHklM0RzeXMubWF4c2l6ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taG9wcGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">75</span>, max_capability=<span class="hljs-number">89</span>
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">90</span>, max_capability=sys.maxsize
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation-hopper&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
    }
}`,wrap:!1}}),Ce=new c({props:{title:"Registering kernels for specific ROCm capabilities",local:"registering-kernels-for-specific-rocm-capabilities",headingTag:"h3"}}),je=new c({props:{title:"Loading from a local repository for testing",local:"loading-from-a-local-repository-for-testing",headingTag:"h3"}}),fe=new m({props:{code:"d2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExvY2FsTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9fcGF0aCUzRCUyMiUyRmhvbWUlMkZkYW5pZWwlMkZrZXJuZWxzJTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhY2thZ2VfbmFtZSUzRCUyMmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBpbmhlcml0X21hcHBpbmclM0RGYWxzZSUyQyUwQSklM0ElMEElMjAlMjAlMjAlMjBrZXJuZWxpemUobGluZWFyJTJDJTIwbW9kZSUzRE1vZGUuSU5GRVJFTkNFKQ==",highlighted:`<span class="hljs-keyword">with</span> use_kernel_mapping(
    {
        <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
            <span class="hljs-string">&quot;cuda&quot;</span>: LocalLayerRepository(
                repo_path=<span class="hljs-string">&quot;/home/daniel/kernels/activation&quot;</span>,
                package_name=<span class="hljs-string">&quot;activation&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            )
        }
    },
    inherit_mapping=<span class="hljs-literal">False</span>,
):
    kernelize(linear, mode=Mode.INFERENCE)`,wrap:!1}}),he=new ht({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/layers.md"}}),{c(){d=n("meta"),ge=s(),Ae=n("p"),ke=s(),r(w.$$.fragment),$e=s(),r(C.$$.fragment),Ee=s(),u=n("p"),u.innerHTML=Gl,Re=s(),j=n("p"),j.innerHTML=Ll,ve=s(),r(I.$$.fragment),Ne=s(),r(f.$$.fragment),Be=s(),h=n("p"),h.innerHTML=Wl,_e=s(),r(A.$$.fragment),Se=s(),b=n("p"),b.innerHTML=Ql,Ze=s(),r(g.$$.fragment),Ge=s(),k=n("p"),k.innerHTML=Hl,Le=s(),r($.$$.fragment),We=s(),E=n("p"),E.innerHTML=xl,Qe=s(),r(R.$$.fragment),He=s(),v=n("p"),v.innerHTML=Vl,xe=s(),r(N.$$.fragment),Ve=s(),B=n("p"),B.innerHTML=Xl,Xe=s(),r(_.$$.fragment),Fe=s(),S=n("p"),S.innerHTML=Fl,qe=s(),Z=n("p"),Z.innerHTML=ql,ze=s(),r(G.$$.fragment),Ye=s(),r(L.$$.fragment),Pe=s(),W=n("p"),W.innerHTML=zl,Oe=s(),r(Q.$$.fragment),Ke=s(),r(H.$$.fragment),De=s(),x=n("p"),x.innerHTML=Yl,el=s(),r(V.$$.fragment),ll=s(),X=n("p"),X.textContent=Pl,tl=s(),r(F.$$.fragment),Ml=s(),q=n("p"),q.innerHTML=Ol,sl=s(),r(z.$$.fragment),il=s(),Y=n("p"),Y.innerHTML=Kl,nl=s(),r(P.$$.fragment),al=s(),O=n("p"),O.innerHTML=Dl,rl=s(),r(K.$$.fragment),yl=s(),D=n("p"),D.innerHTML=et,ol=s(),r(ee.$$.fragment),pl=s(),le=n("p"),le.innerHTML=lt,Ul=s(),r(te.$$.fragment),Tl=s(),Me=n("p"),Me.innerHTML=tt,Jl=s(),r(se.$$.fragment),ml=s(),ie=n("p"),ie.innerHTML=Mt,cl=s(),r(ne.$$.fragment),dl=s(),ae=n("p"),ae.textContent=st,wl=s(),r(re.$$.fragment),Cl=s(),ye=n("p"),ye.innerHTML=it,ul=s(),oe=n("ul"),oe.innerHTML=nt,jl=s(),pe=n("p"),pe.innerHTML=at,Il=s(),r(Ue.$$.fragment),fl=s(),Te=n("p"),Te.innerHTML=rt,hl=s(),r(Je.$$.fragment),Al=s(),me=n("p"),me.innerHTML=yt,bl=s(),r(ce.$$.fragment),gl=s(),de=n("p"),de.textContent=ot,kl=s(),we=n("ul"),we.innerHTML=pt,$l=s(),r(Ce.$$.fragment),El=s(),ue=n("p"),ue.innerHTML=Ut,Rl=s(),r(je.$$.fragment),vl=s(),Ie=n("p"),Ie.innerHTML=Tt,Nl=s(),r(fe.$$.fragment),Bl=s(),r(he.$$.fragment),_l=s(),be=n("p"),this.h()},l(e){const l=jt("svelte-u9bgzb",document.head);d=a(l,"META",{name:!0,content:!0}),l.forEach(t),ge=i(e),Ae=a(e,"P",{}),Jt(Ae).forEach(t),ke=i(e),y(w.$$.fragment,e),$e=i(e),y(C.$$.fragment,e),Ee=i(e),u=a(e,"P",{"data-svelte-h":!0}),J(u)!=="svelte-178x673"&&(u.innerHTML=Gl),Re=i(e),j=a(e,"P",{"data-svelte-h":!0}),J(j)!=="svelte-j3oddw"&&(j.innerHTML=Ll),ve=i(e),y(I.$$.fragment,e),Ne=i(e),y(f.$$.fragment,e),Be=i(e),h=a(e,"P",{"data-svelte-h":!0}),J(h)!=="svelte-1jd41lf"&&(h.innerHTML=Wl),_e=i(e),y(A.$$.fragment,e),Se=i(e),b=a(e,"P",{"data-svelte-h":!0}),J(b)!=="svelte-tily1x"&&(b.innerHTML=Ql),Ze=i(e),y(g.$$.fragment,e),Ge=i(e),k=a(e,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1hj9ahw"&&(k.innerHTML=Hl),Le=i(e),y($.$$.fragment,e),We=i(e),E=a(e,"P",{"data-svelte-h":!0}),J(E)!=="svelte-13coke1"&&(E.innerHTML=xl),Qe=i(e),y(R.$$.fragment,e),He=i(e),v=a(e,"P",{"data-svelte-h":!0}),J(v)!=="svelte-stkx9y"&&(v.innerHTML=Vl),xe=i(e),y(N.$$.fragment,e),Ve=i(e),B=a(e,"P",{"data-svelte-h":!0}),J(B)!=="svelte-1mdicvi"&&(B.innerHTML=Xl),Xe=i(e),y(_.$$.fragment,e),Fe=i(e),S=a(e,"P",{"data-svelte-h":!0}),J(S)!=="svelte-xhc5xj"&&(S.innerHTML=Fl),qe=i(e),Z=a(e,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-195gdzl"&&(Z.innerHTML=ql),ze=i(e),y(G.$$.fragment,e),Ye=i(e),y(L.$$.fragment,e),Pe=i(e),W=a(e,"P",{"data-svelte-h":!0}),J(W)!=="svelte-808tau"&&(W.innerHTML=zl),Oe=i(e),y(Q.$$.fragment,e),Ke=i(e),y(H.$$.fragment,e),De=i(e),x=a(e,"P",{"data-svelte-h":!0}),J(x)!=="svelte-yu926d"&&(x.innerHTML=Yl),el=i(e),y(V.$$.fragment,e),ll=i(e),X=a(e,"P",{"data-svelte-h":!0}),J(X)!=="svelte-1lkusth"&&(X.textContent=Pl),tl=i(e),y(F.$$.fragment,e),Ml=i(e),q=a(e,"P",{"data-svelte-h":!0}),J(q)!=="svelte-161p6z8"&&(q.innerHTML=Ol),sl=i(e),y(z.$$.fragment,e),il=i(e),Y=a(e,"P",{"data-svelte-h":!0}),J(Y)!=="svelte-1r5il31"&&(Y.innerHTML=Kl),nl=i(e),y(P.$$.fragment,e),al=i(e),O=a(e,"P",{"data-svelte-h":!0}),J(O)!=="svelte-1mzc83p"&&(O.innerHTML=Dl),rl=i(e),y(K.$$.fragment,e),yl=i(e),D=a(e,"P",{"data-svelte-h":!0}),J(D)!=="svelte-p5ro9n"&&(D.innerHTML=et),ol=i(e),y(ee.$$.fragment,e),pl=i(e),le=a(e,"P",{"data-svelte-h":!0}),J(le)!=="svelte-z3xuuf"&&(le.innerHTML=lt),Ul=i(e),y(te.$$.fragment,e),Tl=i(e),Me=a(e,"P",{"data-svelte-h":!0}),J(Me)!=="svelte-130qoue"&&(Me.innerHTML=tt),Jl=i(e),y(se.$$.fragment,e),ml=i(e),ie=a(e,"P",{"data-svelte-h":!0}),J(ie)!=="svelte-8ksrq2"&&(ie.innerHTML=Mt),cl=i(e),y(ne.$$.fragment,e),dl=i(e),ae=a(e,"P",{"data-svelte-h":!0}),J(ae)!=="svelte-1ed3b6y"&&(ae.textContent=st),wl=i(e),y(re.$$.fragment,e),Cl=i(e),ye=a(e,"P",{"data-svelte-h":!0}),J(ye)!=="svelte-sek2d8"&&(ye.innerHTML=it),ul=i(e),oe=a(e,"UL",{"data-svelte-h":!0}),J(oe)!=="svelte-ewhtf4"&&(oe.innerHTML=nt),jl=i(e),pe=a(e,"P",{"data-svelte-h":!0}),J(pe)!=="svelte-m4furw"&&(pe.innerHTML=at),Il=i(e),y(Ue.$$.fragment,e),fl=i(e),Te=a(e,"P",{"data-svelte-h":!0}),J(Te)!=="svelte-1oi4pcx"&&(Te.innerHTML=rt),hl=i(e),y(Je.$$.fragment,e),Al=i(e),me=a(e,"P",{"data-svelte-h":!0}),J(me)!=="svelte-1wl92tu"&&(me.innerHTML=yt),bl=i(e),y(ce.$$.fragment,e),gl=i(e),de=a(e,"P",{"data-svelte-h":!0}),J(de)!=="svelte-1k7nbkd"&&(de.textContent=ot),kl=i(e),we=a(e,"UL",{"data-svelte-h":!0}),J(we)!=="svelte-xyngc6"&&(we.innerHTML=pt),$l=i(e),y(Ce.$$.fragment,e),El=i(e),ue=a(e,"P",{"data-svelte-h":!0}),J(ue)!=="svelte-1q9vv7t"&&(ue.innerHTML=Ut),Rl=i(e),y(je.$$.fragment,e),vl=i(e),Ie=a(e,"P",{"data-svelte-h":!0}),J(Ie)!=="svelte-qa4iob"&&(Ie.innerHTML=Tt),Nl=i(e),y(fe.$$.fragment,e),Bl=i(e),y(he.$$.fragment,e),_l=i(e),be=a(e,"P",{}),Jt(be).forEach(t),this.h()},h(){mt(d,"name","hf:doc:metadata"),mt(d,"content",bt)},m(e,l){It(document.head,d),M(e,ge,l),M(e,Ae,l),M(e,ke,l),o(w,e,l),M(e,$e,l),o(C,e,l),M(e,Ee,l),M(e,u,l),M(e,Re,l),M(e,j,l),M(e,ve,l),o(I,e,l),M(e,Ne,l),o(f,e,l),M(e,Be,l),M(e,h,l),M(e,_e,l),o(A,e,l),M(e,Se,l),M(e,b,l),M(e,Ze,l),o(g,e,l),M(e,Ge,l),M(e,k,l),M(e,Le,l),o($,e,l),M(e,We,l),M(e,E,l),M(e,Qe,l),o(R,e,l),M(e,He,l),M(e,v,l),M(e,xe,l),o(N,e,l),M(e,Ve,l),M(e,B,l),M(e,Xe,l),o(_,e,l),M(e,Fe,l),M(e,S,l),M(e,qe,l),M(e,Z,l),M(e,ze,l),o(G,e,l),M(e,Ye,l),o(L,e,l),M(e,Pe,l),M(e,W,l),M(e,Oe,l),o(Q,e,l),M(e,Ke,l),o(H,e,l),M(e,De,l),M(e,x,l),M(e,el,l),o(V,e,l),M(e,ll,l),M(e,X,l),M(e,tl,l),o(F,e,l),M(e,Ml,l),M(e,q,l),M(e,sl,l),o(z,e,l),M(e,il,l),M(e,Y,l),M(e,nl,l),o(P,e,l),M(e,al,l),M(e,O,l),M(e,rl,l),o(K,e,l),M(e,yl,l),M(e,D,l),M(e,ol,l),o(ee,e,l),M(e,pl,l),M(e,le,l),M(e,Ul,l),o(te,e,l),M(e,Tl,l),M(e,Me,l),M(e,Jl,l),o(se,e,l),M(e,ml,l),M(e,ie,l),M(e,cl,l),o(ne,e,l),M(e,dl,l),M(e,ae,l),M(e,wl,l),o(re,e,l),M(e,Cl,l),M(e,ye,l),M(e,ul,l),M(e,oe,l),M(e,jl,l),M(e,pe,l),M(e,Il,l),o(Ue,e,l),M(e,fl,l),M(e,Te,l),M(e,hl,l),o(Je,e,l),M(e,Al,l),M(e,me,l),M(e,bl,l),o(ce,e,l),M(e,gl,l),M(e,de,l),M(e,kl,l),M(e,we,l),M(e,$l,l),o(Ce,e,l),M(e,El,l),M(e,ue,l),M(e,Rl,l),o(je,e,l),M(e,vl,l),M(e,Ie,l),M(e,Nl,l),o(fe,e,l),M(e,Bl,l),o(he,e,l),M(e,_l,l),M(e,be,l),Sl=!0},p:dt,i(e){Sl||(p(w.$$.fragment,e),p(C.$$.fragment,e),p(I.$$.fragment,e),p(f.$$.fragment,e),p(A.$$.fragment,e),p(g.$$.fragment,e),p($.$$.fragment,e),p(R.$$.fragment,e),p(N.$$.fragment,e),p(_.$$.fragment,e),p(G.$$.fragment,e),p(L.$$.fragment,e),p(Q.$$.fragment,e),p(H.$$.fragment,e),p(V.$$.fragment,e),p(F.$$.fragment,e),p(z.$$.fragment,e),p(P.$$.fragment,e),p(K.$$.fragment,e),p(ee.$$.fragment,e),p(te.$$.fragment,e),p(se.$$.fragment,e),p(ne.$$.fragment,e),p(re.$$.fragment,e),p(Ue.$$.fragment,e),p(Je.$$.fragment,e),p(ce.$$.fragment,e),p(Ce.$$.fragment,e),p(je.$$.fragment,e),p(fe.$$.fragment,e),p(he.$$.fragment,e),Sl=!0)},o(e){U(w.$$.fragment,e),U(C.$$.fragment,e),U(I.$$.fragment,e),U(f.$$.fragment,e),U(A.$$.fragment,e),U(g.$$.fragment,e),U($.$$.fragment,e),U(R.$$.fragment,e),U(N.$$.fragment,e),U(_.$$.fragment,e),U(G.$$.fragment,e),U(L.$$.fragment,e),U(Q.$$.fragment,e),U(H.$$.fragment,e),U(V.$$.fragment,e),U(F.$$.fragment,e),U(z.$$.fragment,e),U(P.$$.fragment,e),U(K.$$.fragment,e),U(ee.$$.fragment,e),U(te.$$.fragment,e),U(se.$$.fragment,e),U(ne.$$.fragment,e),U(re.$$.fragment,e),U(Ue.$$.fragment,e),U(Je.$$.fragment,e),U(ce.$$.fragment,e),U(Ce.$$.fragment,e),U(je.$$.fragment,e),U(fe.$$.fragment,e),U(he.$$.fragment,e),Sl=!1},d(e){e&&(t(ge),t(Ae),t(ke),t($e),t(Ee),t(u),t(Re),t(j),t(ve),t(Ne),t(Be),t(h),t(_e),t(Se),t(b),t(Ze),t(Ge),t(k),t(Le),t(We),t(E),t(Qe),t(He),t(v),t(xe),t(Ve),t(B),t(Xe),t(Fe),t(S),t(qe),t(Z),t(ze),t(Ye),t(Pe),t(W),t(Oe),t(Ke),t(De),t(x),t(el),t(ll),t(X),t(tl),t(Ml),t(q),t(sl),t(il),t(Y),t(nl),t(al),t(O),t(rl),t(yl),t(D),t(ol),t(pl),t(le),t(Ul),t(Tl),t(Me),t(Jl),t(ml),t(ie),t(cl),t(dl),t(ae),t(wl),t(Cl),t(ye),t(ul),t(oe),t(jl),t(pe),t(Il),t(fl),t(Te),t(hl),t(Al),t(me),t(bl),t(gl),t(de),t(kl),t(we),t($l),t(El),t(ue),t(Rl),t(vl),t(Ie),t(Nl),t(Bl),t(_l),t(be)),t(d),T(w,e),T(C,e),T(I,e),T(f,e),T(A,e),T(g,e),T($,e),T(R,e),T(N,e),T(_,e),T(G,e),T(L,e),T(Q,e),T(H,e),T(V,e),T(F,e),T(z,e),T(P,e),T(K,e),T(ee,e),T(te,e),T(se,e),T(ne,e),T(re,e),T(Ue,e),T(Je,e),T(ce,e),T(Ce,e),T(je,e),T(fe,e),T(he,e)}}}const bt='{"title":"Layers","local":"layers","sections":[{"title":"Making a layer extensible with kernels from the hub","local":"making-a-layer-extensible-with-kernels-from-the-hub","sections":[{"title":"Using a decorator","local":"using-a-decorator","sections":[],"depth":3},{"title":"External layers","local":"external-layers","sections":[],"depth":3}],"depth":2},{"title":"Kernelizing a model","local":"kernelizing-a-model","sections":[{"title":"Kernel device","local":"kernel-device","sections":[],"depth":3},{"title":"Fallback forward","local":"fallback-forward","sections":[],"depth":3},{"title":"Inspecting which kernels are used","local":"inspecting-which-kernels-are-used","sections":[],"depth":3}],"depth":2},{"title":"Registering a hub kernel for a layer","local":"registering-a-hub-kernel-for-a-layer","sections":[{"title":"Using version bounds","local":"using-version-bounds","sections":[],"depth":3},{"title":"Registering kernels for specific modes","local":"registering-kernels-for-specific-modes","sections":[],"depth":3},{"title":"Registering kernels for specific CUDA capabilities","local":"registering-kernels-for-specific-cuda-capabilities","sections":[],"depth":3},{"title":"Registering kernels for specific ROCm capabilities","local":"registering-kernels-for-specific-rocm-capabilities","sections":[],"depth":3},{"title":"Loading from a local repository for testing","local":"loading-from-a-local-repository-for-testing","sections":[],"depth":3}],"depth":2}],"depth":1}';function gt(Zl){return wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends Ct{constructor(d){super(),ut(this,d,gt,At,ct,{})}}export{vt as component};
