import{s as vl,o as Cl,n as I}from"../chunks/scheduler.b108d059.js";import{S as kl,i as zl,g as r,s,r as d,A as El,h as p,f as n,c as i,j as Al,u as M,x as u,k as Il,y as Zl,a as l,v as m,d as c,t as h,w as f}from"../chunks/index.008de539.js";import{T as A}from"../chunks/Tip.aeb15ab7.js";import{C as $}from"../chunks/CodeBlock.7b00c886.js";import{H as j,E as _l}from"../chunks/getInferenceSnippets.5050f783.js";function Rl(w){let a,y="Note that you can select any Automatic Speech Recognition (ASR) model available on the Hugging Face Hub with the tag <code>NeMo</code> and the “Deploy to AzureML” option enabled, or directly select any of the ASR models available on either Azure ML or Azure AI Foundry Hub Model Catalog under the “HuggingFace” collection (note that for Azure AI Foundry the Hugging Face Collection will only be available for Hub-based projects), but only the NVIDIA Parakeet models are powered by NVIDIA NeMo, the rest of those rely on the Hugging Face Inference Toolkit.";return{c(){a=r("p"),a.innerHTML=y},l(o){a=p(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-hbrmnf"&&(a.innerHTML=y)},m(o,g){l(o,a,g)},p:I,d(o){o&&n(a)}}}function Bl(w){let a,y="Note that endpoint names must be globally unique per region i.e., even if you don’t have any endpoint named that way running under your subscription, if the name is reserved by another Azure customer, then you won’t be able to use the same name. Adding a timestamp or a custom identifier is recommended to prevent running into HTTP 400 validation issues when trying to deploy an endpoint with an already locked / reserved name. Also the endpoint name must be between 3 and 32 characters long.";return{c(){a=r("p"),a.textContent=y},l(o){a=p(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-1o1z8dc"&&(a.textContent=y)},m(o,g){l(o,a,g)},p:I,d(o){o&&n(a)}}}function Vl(w){let a,y="On standard Azure ML deployments you’d need to create the <code>MLClient</code> using the Azure ML Workspace as the <code>workspace_name</code> whereas for Azure AI Foundry, you need to provide the Azure AI Foundry Hub name as the <code>workspace_name</code> instead, and that will deploy the endpoint under the Azure AI Foundry too.";return{c(){a=r("p"),a.innerHTML=y},l(o){a=p(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-fg1top"&&(a.innerHTML=y)},m(o,g){l(o,a,g)},p:I,d(o){o&&n(a)}}}function Ll(w){let a,y='To check if a model from the Hugging Face Hub is available in Azure, you should read about it in <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/models" rel="nofollow">Supported Models</a>. If not, you can always <a href="https://huggingface.co/docs/microsoft-azure/guides/request-model-addition" rel="nofollow">Request a model addition in the Hugging Face collection on Azure</a>).';return{c(){a=r("p"),a.innerHTML=y},l(o){a=p(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-15zbbe3"&&(a.innerHTML=y)},m(o,g){l(o,a,g)},p:I,d(o){o&&n(a)}}}function Wl(w){let a,y='Every model in the Hugging Face Collection is powered by an efficient inference backend, and each of those can run on a wide variety of instance types (as listed in <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/supported-hardware" rel="nofollow">Supported Hardware</a>). Since for models and inference engines require a GPU-accelerated instance, you might need to request a quota increase as per <a href="https://learn.microsoft.com/en-us/azure/machine-learning/how-to-manage-quotas?view=azureml-api-2" rel="nofollow">Manage and increase quotas and limits for resources with Azure Machine Learning</a>.';return{c(){a=r("p"),a.innerHTML=y},l(o){a=p(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-2fe7bk"&&(a.innerHTML=y)},m(o,g){l(o,a,g)},p:I,d(o){o&&n(a)}}}function Sl(w){let a,y="In Azure AI Foundry the endpoint will only be listed within the “My assets -> Models + endpoints” tab once the deployment is created, not before as in Azure ML where the endpoint is shown even if it doesn’t contain any active or in-progress deployments.";return{c(){a=r("p"),a.textContent=y},l(o){a=p(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-13fiegq"&&(a.textContent=y)},m(o,g){l(o,a,g)},p:I,d(o){o&&n(a)}}}function Fl(w){let a,y="Note that whilst the Azure AI Endpoint creation is relatively fast, the deployment will take longer since it needs to allocate the resources on Azure so expect it to take ~10-15 minutes, but it could as well take longer depending on the instance provisioning and availability.";return{c(){a=r("p"),a.textContent=y},l(o){a=p(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-1q2pvid"&&(a.textContent=y)},m(o,g){l(o,a,g)},p:I,d(o){o&&n(a)}}}function Gl(w){let a,y='Support for Hugging Face models via <a href="https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/ai/azure-ai-inference" rel="nofollow"><code>azure-ai-inference</code> Python SDK</a> is still a work in progress, but that will be included soon and set as the recommended inference method, stay tuned!';return{c(){a=r("p"),a.innerHTML=y},l(o){a=p(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-1c2r502"&&(a.innerHTML=y)},m(o,g){l(o,a,g)},p:I,d(o){o&&n(a)}}}function Nl(w){let a,y="Alternatively, you can also build the API URL manually as it follows, since the URIs are globally unique per region, meaning that there will only be one endpoint named the same way within the same region:",o,g,J,b,v="Or just retrieve it from either the Azure AI Foundry or the Azure ML Studio.",S;return g=new $({props:{code:"YXBpX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRiU3Qm9zLmdldGVudignRU5EUE9JTlRfTkFNRScpJTdELiU3Qm9zLmdldGVudignTE9DQVRJT04nKSU3RC5pbmZlcmVuY2UubWwuYXp1cmUuY29tJTJGYXBpJTJGdjElMjI=",highlighted:'api_url = <span class="hljs-string">f&quot;https://<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;ENDPOINT_NAME&#x27;</span>)}</span>.<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>.inference.ml.azure.com/api/v1&quot;</span>',wrap:!1}}),{c(){a=r("p"),a.textContent=y,o=s(),d(g.$$.fragment),J=s(),b=r("p"),b.textContent=v},l(T){a=p(T,"P",{"data-svelte-h":!0}),u(a)!=="svelte-ufs9gh"&&(a.textContent=y),o=i(T),M(g.$$.fragment,T),J=i(T),b=p(T,"P",{"data-svelte-h":!0}),u(b)!=="svelte-vz1qru"&&(b.textContent=v)},m(T,U){l(T,a,U),l(T,o,U),m(g,T,U),l(T,J,U),l(T,b,U),S=!0},p:I,i(T){S||(c(g.$$.fragment,T),S=!0)},o(T){h(g.$$.fragment,T),S=!1},d(T){T&&(n(a),n(o),n(J),n(b)),f(g,T)}}}function Ql(w){let a,y='Alternatively, the Gradio demo connected to your Azure ML Managed Online Endpoint as an Azure Container App as described in <a href="https://learn.microsoft.com/en-us/azure/container-apps/tutorial-deploy-from-code?tabs=python" rel="nofollow">Tutorial: Build and deploy from source code to Azure Container Apps</a>. If you’d like us to show you how to do it for Gradio in particular, feel free to <a href="https://github.com/huggingface/Microsoft-Azure/issues/new" rel="nofollow">open an issue requesting it</a>.';return{c(){a=r("p"),a.innerHTML=y},l(o){a=p(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-1gkmk5y"&&(a.innerHTML=y)},m(o,g){l(o,a,g)},p:I,d(o){o&&n(a)}}}function Hl(w){let a,y='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/Microsoft-Azure/tree/main/examples/azure-ai/deploy-nvidia-parakeet-asr/azure-notebook.ipynb" rel="nofollow">here</a>!';return{c(){a=r("p"),a.innerHTML=y},l(o){a=p(o,"P",{"data-svelte-h":!0}),u(a)!=="svelte-12wyo3t"&&(a.innerHTML=y)},m(o,g){l(o,a,g)},p:I,d(o){o&&n(a)}}}function xl(w){let a,y,o,g,J,b,v,S="This example showcases how to deploy NVIDIA Parakeet for Automatic Speech Recognition (ASR) from the Hugging Face Collection in Azure AI Foundry Hub as an Azure ML Managed Online Endpoint, powered by Hugging Face’s Inference container on top of NVIDIA NeMo. It also covers how to run inference with cURL, requests, OpenAI Python SDK, and even how to locally run a Gradio application for audio transcription from both recordings and files.",T,U,En="TL;DR NVIDIA NeMo is a scalable generative AI framework built for researchers and developers working on Large Language Models, Multimodal, and Speech AI (Automatic Speech Recognition and Text-to-Speech). NVIDIA NeMo Parakeet ASR Models attain strong speech recognition accuracy while being efficient for inference. Azure AI Foundry provides a unified platform for enterprise AI operations, model builders, and application development. Azure Machine Learning is a cloud service for accelerating and managing the machine learning (ML) project lifecycle.",tt,nt,lt,F,Zn='This example will specifically deploy <a href="https://huggingface.co/nvidia/parakeet-tdt-0.6b-v2" rel="nofollow"><code>nvidia/parakeet-tdt-0.6b-v2</code></a> from the Hugging Face Hub (or see it on <a href="https://ml.azure.com/models/nvidia-parakeet-tdt-0.6b-v2/version/4/catalog/registry/HuggingFace" rel="nofollow">AzureML</a> or on <a href="https://ai.azure.com/explore/models/nvidia-parakeet-tdt-0.6b-v2/version/4/registry/HuggingFace" rel="nofollow">Azure AI Foundry</a>) as an Azure ML Managed Online Endpoint on Azure AI Foundry Hub.',at,G,_n="<code>nvidia/parakeet-tdt-0.6b-v2</code> is a 600-million-parameter automatic speech recognition (ASR) model designed for high-quality English transcription, featuring support for punctuation, capitalization, and accurate timestamp prediction.",st,N,Rn="This XL variant of the FastConformer architecture integrates the TDT decoder and is trained with full attention, enabling efficient transcription of audio segments up to 24 minutes in a single pass. The model achieves an RTFx of 3380 on the HF-Open-ASR leaderboard with a batch size of 128. Note: RTFx Performance may vary depending on dataset audio duration and batch size.",it,Q,Bn="<li>Accurate word-level timestamp predictions</li> <li>Automatic punctuation and capitalization</li> <li>Robust performance on spoken numbers, and song lyrics transcription</li>",ot,H,Vn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-nvidia-parakeet-asr/nvidia-parakeet-hub.png" alt="NVIDIA Parakeet on the Hugging Face Hub"/>',rt,x,Ln='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-nvidia-parakeet-asr/nvidia-parakeet-azure-ai.png" alt="NVIDIA Parakeet on Azure AI Foundry"/>',pt,q,Wn='For more information, make sure to check <a href="https://huggingface.co/nvidia/parakeet-tdt-0.6b-v2/blob/main/README.md" rel="nofollow">their model card on the Hugging Face Hub</a> and the <a href="https://docs.nvidia.com/nemo-framework/user-guide/latest/nemotoolkit/asr/models.html" rel="nofollow">NVIDIA NeMo Documentation</a>.',ut,C,dt,X,Mt,P,Sn='To run the following example, you will need to comply with the following pre-requisites, alternatively, you can also read more about those in the <a href="https://learn.microsoft.com/en-us/azure/machine-learning/quickstart-create-resources?view=azureml-api-2" rel="nofollow">Azure Machine Learning Tutorial: Create resources you need to get started</a>.',mt,Y,Fn="<li>An Azure account with an active subscription.</li> <li>The Azure CLI installed and logged in.</li> <li>The Azure Machine Learning extension for the Azure CLI.</li> <li>An Azure Resource Group.</li> <li>A project based on an Azure AI Foundry Hub.</li>",ct,D,Gn='For more information, please go through the steps in <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/configure" rel="nofollow">Configure Microsoft Azure for Azure AI</a>.',ht,O,ft,K,Nn='In this example, the <a href="https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/ml/azure-ai-ml" rel="nofollow">Azure Machine Learning SDK for Python</a> will be used to create the endpoint and the deployment, as well as to invoke the deployed API. Along with it, you will also need to install <code>azure-identity</code> to authenticate with your Azure credentials via Python.',yt,ee,gt,te,Qn='More information at <a href="https://learn.microsoft.com/en-us/python/api/overview/azure/ai-ml-readme?view=azure-python" rel="nofollow">Azure Machine Learning SDK for Python</a>.',wt,ne,Hn="Then, for convenience setting the following environment variables is recommended as those will be used along the example for the Azure ML Client, so make sure to update and set those values accordingly as per your Microsoft Azure account and resources.",Tt,le,$t,ae,xn="Finally, you also need to define both the endpoint and deployment names, as those will be used throughout the example too:",Ut,k,Jt,se,bt,ie,jt,oe,qn="Initially, you need to authenticate into the Azure AI Foundry Hub via Azure ML with the Azure ML Python SDK, which will be later used to deploy <code>nvidia/parakeet-tdt-0.6b-v2</code> as an Azure ML Managed Online Endpoint in your Azure AI Foundry Hub.",At,z,It,re,vt,pe,Ct,ue,Xn="Before creating the Managed Online Endpoint, you need to build the model URI, which is formatted as it follows <code>azureml://registries/HuggingFace/models/&lt;MODEL_ID&gt;/labels/latest</code> where the <code>MODEL_ID</code> won’t be the Hugging Face Hub ID but rather its name on Azure, as follows:",kt,de,zt,E,Et,Me,Pn='Then you need to create the <a href="https://learn.microsoft.com/en-us/python/api/azure-ai-ml/azure.ai.ml.entities.managedonlineendpoint?view=azure-python" rel="nofollow">ManagedOnlineEndpoint via the Azure ML Python SDK</a> as follows.',Zt,Z,_t,me,Rt,ce,Bt,he,Yn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-nvidia-parakeet-asr/azure-ai-endpoint.png" alt="Azure AI Endpoint from Azure AI Foundry"/>',Vt,_,Lt,fe,Wt,ye,Dn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-nvidia-parakeet-asr/azure-ai-deployment.png" alt="Azure AI Deployment from Azure AI Foundry"/>',St,R,Ft,ge,On='Once deployed, via either the Azure AI Foundry or the Azure ML Studio you’ll be able to inspect the endpoint details, the real-time logs, how to consume the endpoint, and even use the, still on preview, <a href="https://learn.microsoft.com/en-us/azure/machine-learning/concept-model-monitoring?view=azureml-api-2" rel="nofollow">monitoring feature</a>. Find more information about it at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/concept-endpoints-online?view=azureml-api-2#managed-online-endpoints" rel="nofollow">Azure ML Managed Online Endpoints</a>',Gt,we,Nt,Te,Kn="Finally, now that the Azure AI Endpoint is deployed, you can send requests to it. In this case, since the task of the model is <code>automatic-speech-recognition</code> and since it expects a multi-part request to be sent along the audio file, the <code>invoke</code> method cannot be used since it only supports JSON payloads.",Qt,$e,el="This being said, you can still send requests to it programmatically via <code>requests</code>, via the OpenAI SDK for Python or with cURL, to the <code>/api/v1/audio/transcriptions</code> route which is the OpenAI-compatible route for the Transcriptions API.",Ht,B,xt,Ue,tl="To send the requests then we need both the <code>primary_key</code> and the <code>scoring_uri</code>, which can be retrieved via the Azure ML Python SDK as it follows:",qt,Je,Xt,be,nl="Additionally, since you will need a sample audio file to run the inference over, you will need to download an audio file as e.g. the following, which is the audio file showcased within the <code>nvidia/parakeet-tdt-0.6b-v2</code> model card:",Pt,je,Yt,Ae,Dt,Ie,ll="As the deployed Azure AI Endpoint for ASR expects a multi-part request, you need to send separately the files, in this case being the audio files, and the data, being the request parameters such as e.g. the model name or the temperature, among others. To do so, you first need to read the audio file into an <code>io.BytesIO</code> object, and then prepare the requests with the necessary headers for both the authentication and the <code>azureml-model-deployment</code> set to point to the actual Azure AI Deployment, and send the HTTP POST with both the file and the data as follows:",Ot,ve,Kt,Ce,en,ke,al="As the exposed scoring URI is an OpenAI-compatible route i.e., <code>/api/v1/audio/transcriptions</code>, you can leverage the OpenAI Python SDK to send requests to the deployed Azure AI Endpoint.",tn,ze,nn,Ee,sl="To use the OpenAI Python SDK with Azure ML Managed Online Endpoints, you need to update the <code>api_url</code> value defined above, since the default <code>scoring_uri</code> comes with the full route, whereas the OpenAI SDK expects the route up until the <code>v1</code> included, meaning that the <code>/audio/transcriptions</code> should be removed before instantiating the client.",ln,Ze,an,V,sn,_e,il="Then you can use the OpenAI Python SDK normally, making sure to include the extra header <code>azureml-model-deployment</code> header that contains the Azure AI / ML Deployment name.",on,Re,ol="Via the OpenAI Python SDK it can either be set within each call to <code>chat.completions.create</code> via the <code>extra_headers</code> parameter as commented below, or via the <code>default_headers</code> parameter when instantiating the <code>OpenAI</code> client (which is the recommended approach since the header needs to be present on each request, so setting it just once is preferred).",rn,Be,pn,Ve,un,Le,rl="Alternatively, you can also just use <code>cURL</code> to send requests to the deployed endpoint, with the <code>api_url</code> and <code>api_key</code> values programmatically retrieved in the OpenAI snippet and now set as environment variables so that <code>cURL</code> can use those, as it follows:",dn,We,Mn,Se,mn,Fe,pl="Alternatively, you can also just go to the Azure AI Endpoint in either the Azure AI Foundry under “My assets -> Models + endpoints” or in the Azure ML Studio via “Endpoints”, and retrieve both the scoring URI and the API Key values, as well as the Azure AI / ML Deployment name for the given model.",cn,Ge,hn,Ne,ul='<a href="https://www.gradio.app/" rel="nofollow">Gradio</a> is the fastest way to demo your machine learning model with a friendly web interface so that anyone can use it. You can also leverage the OpenAI Python SDK to build a simple automatic-speech-recognition i.e., speech to text demo that you can use within the Jupyter Notebook cell where you are running it.',fn,L,yn,Qe,gn,He,wn,xe,dl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-nvidia-parakeet-asr/azure-ml-gradio.png" alt="Gradio Chat Interface with Azure ML Endpoint"/>',Tn,qe,$n,Xe,Ml="Once you are done using the Azure AI Endpoint / Deployment, you can delete the resources as it follows, meaning that you will stop paying for the instance on which the model is running and all the attached costs will be stopped.",Un,Pe,Jn,Ye,bn,De,ml="Throughout this example you learnt how to create and configure your Azure account for Azure ML and Azure AI Foundry, how to then create a Managed Online Endpoint running an open model for Automatic Speech Recognition (ASR) from the Hugging Face Collection in the Azure AI Foundry Hub / Azure ML Model Catalog, how to send inference requests to it afterwards with different alternatives, how to build a simple Gradio chat interface around it, and finally, how to stop and release the resources.",jn,Oe,cl='If you have any doubt, issue or question about this example, feel free to <a href="https://github.com/huggingface/Microsoft-Azure/issues/new" rel="nofollow">open an issue</a> and we’ll do our best to help!',An,In,vn,W,Cn,Ke,kn,et,zn;return J=new j({props:{title:"Deploy NVIDIA Parakeet for Automatic Speech Recognition (ASR) on Azure AI",local:"deploy-nvidia-parakeet-for-automatic-speech-recognition-asr-on-azure-ai",headingTag:"h1"}}),C=new A({props:{$$slots:{default:[Rl]},$$scope:{ctx:w}}}),X=new j({props:{title:"Pre-requisites",local:"pre-requisites",headingTag:"h2"}}),O=new j({props:{title:"Setup and installation",local:"setup-and-installation",headingTag:"h2"}}),ee=new $({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGF6dXJlLWFpLW1sJTIwYXp1cmUtaWRlbnRpdHklMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:"%pip install azure-ai-ml azure-identity --upgrade --quiet",wrap:!1}}),le=new $({props:{code:"JTI1ZW52JTIwTE9DQVRJT04lMjBlYXN0dXMlMEElMjVlbnYlMjBTVUJTQ1JJUFRJT05fSUQlMjAlM0NZT1VSX1NVQlNDUklQVElPTl9JRCUzRSUwQSUyNWVudiUyMFJFU09VUkNFX0dST1VQJTIwJTNDWU9VUl9SRVNPVVJDRV9HUk9VUCUzRSUwQSUyNWVudiUyMEFJX0ZPVU5EUllfSFVCX1BST0pFQ1QlMjAlM0NZT1VSX0FJX0ZPVU5EUllfSFVCX1BST0pFQ1QlM0U=",highlighted:`%env LOCATION eastus
%env SUBSCRIPTION_ID &lt;YOUR_SUBSCRIPTION_ID&gt;
%env RESOURCE_GROUP &lt;YOUR_RESOURCE_GROUP&gt;
%env AI_FOUNDRY_HUB_PROJECT &lt;YOUR_AI_FOUNDRY_HUB_PROJECT&gt;`,wrap:!1}}),k=new A({props:{$$slots:{default:[Bl]},$$scope:{ctx:w}}}),se=new $({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdXVpZCUyMGltcG9ydCUyMHV1aWQ0JTBBJTBBb3MuZW52aXJvbiU1QiUyMkVORFBPSU5UX05BTUUlMjIlNUQlMjAlM0QlMjBmJTIybnZpZGlhLXBhcmFrZWV0LSU3QnN0cih1dWlkNCgpKSU1QiUzQTglNUQlN0QlMjIlMEFvcy5lbnZpcm9uJTVCJTIyREVQTE9ZTUVOVF9OQU1FJTIyJTVEJTIwJTNEJTIwZiUyMm52aWRpYS1wYXJha2VldC0lN0JzdHIodXVpZDQoKSklNUIlM0E4JTVEJTdEJTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> uuid <span class="hljs-keyword">import</span> uuid4

os.environ[<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>] = <span class="hljs-string">f&quot;nvidia-parakeet-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>
os.environ[<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>] = <span class="hljs-string">f&quot;nvidia-parakeet-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>`,wrap:!1}}),ie=new j({props:{title:"Authenticate to Azure ML",local:"authenticate-to-azure-ml",headingTag:"h2"}}),z=new A({props:{$$slots:{default:[Vl]},$$scope:{ctx:w}}}),re=new $({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwYXp1cmUuYWkubWwlMjBpbXBvcnQlMjBNTENsaWVudCUwQWZyb20lMjBhenVyZS5pZGVudGl0eSUyMGltcG9ydCUyMERlZmF1bHRBenVyZUNyZWRlbnRpYWwlMEElMEFjbGllbnQlMjAlM0QlMjBNTENsaWVudCglMEElMjAlMjAlMjAlMjBjcmVkZW50aWFsJTNERGVmYXVsdEF6dXJlQ3JlZGVudGlhbCgpJTJDJTBBJTIwJTIwJTIwJTIwc3Vic2NyaXB0aW9uX2lkJTNEb3MuZ2V0ZW52KCUyMlNVQlNDUklQVElPTl9JRCUyMiklMkMlMEElMjAlMjAlMjAlMjByZXNvdXJjZV9ncm91cF9uYW1lJTNEb3MuZ2V0ZW52KCUyMlJFU09VUkNFX0dST1VQJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHdvcmtzcGFjZV9uYW1lJTNEb3MuZ2V0ZW52KCUyMkFJX0ZPVU5EUllfSFVCX1BST0pFQ1QlMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> azure.ai.ml <span class="hljs-keyword">import</span> MLClient
<span class="hljs-keyword">from</span> azure.identity <span class="hljs-keyword">import</span> DefaultAzureCredential

client = MLClient(
    credential=DefaultAzureCredential(),
    subscription_id=os.getenv(<span class="hljs-string">&quot;SUBSCRIPTION_ID&quot;</span>),
    resource_group_name=os.getenv(<span class="hljs-string">&quot;RESOURCE_GROUP&quot;</span>),
    workspace_name=os.getenv(<span class="hljs-string">&quot;AI_FOUNDRY_HUB_PROJECT&quot;</span>),
)`,wrap:!1}}),pe=new j({props:{title:"Create and Deploy Azure AI Endpoint",local:"create-and-deploy-azure-ai-endpoint",headingTag:"h2"}}),de=new $({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJudmlkaWElMkZwYXJha2VldC10ZHQtMC42Yi12MiUyMiUwQSUwQW1vZGVsX3VyaSUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjBmJTIyYXp1cmVtbCUzQSUyRiUyRnJlZ2lzdHJpZXMlMkZIdWdnaW5nRmFjZSUyRm1vZGVscyUyRiU3Qm1vZGVsX2lkLnJlcGxhY2UoJyUyRiclMkMlMjAnLScpLnJlcGxhY2UoJ18nJTJDJTIwJy0nKS5sb3dlcigpJTdEJTJGbGFiZWxzJTJGbGF0ZXN0JTIyJTBBKSUwQW1vZGVsX3VyaQ==",highlighted:`model_id = <span class="hljs-string">&quot;nvidia/parakeet-tdt-0.6b-v2&quot;</span>

model_uri = (
    <span class="hljs-string">f&quot;azureml://registries/HuggingFace/models/<span class="hljs-subst">{model_id.replace(<span class="hljs-string">&#x27;/&#x27;</span>, <span class="hljs-string">&#x27;-&#x27;</span>).replace(<span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;-&#x27;</span>).lower()}</span>/labels/latest&quot;</span>
)
model_uri`,wrap:!1}}),E=new A({props:{$$slots:{default:[Ll]},$$scope:{ctx:w}}}),Z=new A({props:{$$slots:{default:[Wl]},$$scope:{ctx:w}}}),me=new $({props:{code:"ZnJvbSUyMGF6dXJlLmFpLm1sLmVudGl0aWVzJTIwaW1wb3J0JTIwTWFuYWdlZE9ubGluZUVuZHBvaW50JTJDJTIwTWFuYWdlZE9ubGluZURlcGxveW1lbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyME1hbmFnZWRPbmxpbmVFbmRwb2ludChuYW1lJTNEb3MuZ2V0ZW52KCUyMkVORFBPSU5UX05BTUUlMjIpKSUwQSUwQWRlcGxveW1lbnQlMjAlM0QlMjBNYW5hZ2VkT25saW5lRGVwbG95bWVudCglMEElMjAlMjAlMjAlMjBuYW1lJTNEb3MuZ2V0ZW52KCUyMkRFUExPWU1FTlRfTkFNRSUyMiklMkMlMEElMjAlMjAlMjAlMjBlbmRwb2ludF9uYW1lJTNEb3MuZ2V0ZW52KCUyMkVORFBPSU5UX05BTUUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbF91cmklMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyU3RhbmRhcmRfTkM0MGFkc19IMTAwX3Y1JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> azure.ai.ml.entities <span class="hljs-keyword">import</span> ManagedOnlineEndpoint, ManagedOnlineDeployment

endpoint = ManagedOnlineEndpoint(name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>))

deployment = ManagedOnlineDeployment(
    name=os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>),
    endpoint_name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>),
    model=model_uri,
    instance_type=<span class="hljs-string">&quot;Standard_NC40ads_H100_v5&quot;</span>,
    instance_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),ce=new $({props:{code:"Y2xpZW50LmJlZ2luX2NyZWF0ZV9vcl91cGRhdGUoZW5kcG9pbnQpLndhaXQoKQ==",highlighted:"client.begin_create_or_update(endpoint).wait()",wrap:!1}}),_=new A({props:{$$slots:{default:[Sl]},$$scope:{ctx:w}}}),fe=new $({props:{code:"Y2xpZW50Lm9ubGluZV9kZXBsb3ltZW50cy5iZWdpbl9jcmVhdGVfb3JfdXBkYXRlKGRlcGxveW1lbnQpLndhaXQoKQ==",highlighted:"client.online_deployments.begin_create_or_update(deployment).wait()",wrap:!1}}),R=new A({props:{$$slots:{default:[Fl]},$$scope:{ctx:w}}}),we=new j({props:{title:"Send requests to the Azure AI Endpoint",local:"send-requests-to-the-azure-ai-endpoint",headingTag:"h2"}}),B=new A({props:{warning:!0,$$slots:{default:[Gl]},$$scope:{ctx:w}}}),Je=new $({props:{code:"YXBpX2tleSUyMCUzRCUyMGNsaWVudC5vbmxpbmVfZW5kcG9pbnRzLmdldF9rZXlzKG9zLmdldGVudiglMjJFTkRQT0lOVF9OQU1FJTIyKSkucHJpbWFyeV9rZXklMEFhcGlfdXJsJTIwJTNEJTIwY2xpZW50Lm9ubGluZV9lbmRwb2ludHMuZ2V0KG9zLmdldGVudiglMjJFTkRQT0lOVF9OQU1FJTIyKSkuc2NvcmluZ191cmk=",highlighted:`api_key = client.online_endpoints.get_keys(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).primary_key
api_url = client.online_endpoints.get(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).scoring_uri`,wrap:!1}}),je=new $({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRmRsZGF0YS1wdWJsaWMuczMudXMtZWFzdC0yLmFtYXpvbmF3cy5jb20lMkYyMDg2LTE0OTIyMC0wMDMzLndhdg==",highlighted:'!wget https://dldata-public.s3.us-east-<span class="hljs-number">2.</span>amazonaws.com/<span class="hljs-number">2086</span>-<span class="hljs-number">149220</span>-<span class="hljs-number">0033.</span>wav',wrap:!1}}),Ae=new j({props:{title:"Python requests",local:"python-requests",headingTag:"h3"}}),ve=new $({props:{code:"ZnJvbSUyMGlvJTIwaW1wb3J0JTIwQnl0ZXNJTyUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBYXVkaW9fZmlsZSUyMCUzRCUyMEJ5dGVzSU8ob3BlbiglMjIyMDg2LTE0OTIyMC0wMDMzLndhdiUyMiUyQyUyMCUyMnJiJTIyKS5yZWFkKCkpJTBBYXVkaW9fZmlsZS5uYW1lJTIwJTNEJTIwJTIyMjA4Ni0xNDkyMjAtMDAzMy53YXYlMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLnBvc3QoJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUyQyUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJBdXRob3JpemF0aW9uJTIyJTNBJTIwZiUyMkJlYXJlciUyMCU3QmFwaV9rZXklN0QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhenVyZW1sLW1vZGVsLWRlcGxveW1lbnQlMjIlM0ElMjBvcy5nZXRlbnYoJTIyREVQTE9ZTUVOVF9OQU1FJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMGZpbGVzJTNEJTdCJTIyZmlsZSUyMiUzQSUyMChhdWRpb19maWxlLm5hbWUlMkMlMjBhdWRpb19maWxlJTJDJTIwJTIyYXVkaW8lMkZ3YXYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YSUzRCU3QiUyMm1vZGVsJTIyJTNBJTIwbW9kZWxfaWQlN0QlMkMlMEEpJTBBcHJpbnQocmVzcG9uc2UuanNvbigpKSUwQSUyMyUyMCU3Qid0ZXh0JyUzQSUyMCUyMldlbGwlMkMlMjBJJTIwZG9uJ3QlMjB3aXNoJTIwdG8lMjBzZWUlMjBpdCUyMGFueSUyMG1vcmUlMkMlMjBvYnNlcnZlZCUyMFBoZWJlJTJDJTIwdHVybmluZyUyMGF3YXklMjBoZXIlMjBleWVzLiUyMEl0JTIwaXMlMjBjZXJ0YWlubHklMjB2ZXJ5JTIwbGlrZSUyMHRoZSUyMG9sZCUyMHBvcnRyYWl0LiUyMiU3RA==",highlighted:`<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">import</span> requests

audio_file = BytesIO(<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;2086-149220-0033.wav&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>).read())
audio_file.name = <span class="hljs-string">&quot;2086-149220-0033.wav&quot;</span>

response = requests.post(
    api_url,
    headers={
        <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{api_key}</span>&quot;</span>,
        <span class="hljs-string">&quot;azureml-model-deployment&quot;</span>: os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>),
    },
    files={<span class="hljs-string">&quot;file&quot;</span>: (audio_file.name, audio_file, <span class="hljs-string">&quot;audio/wav&quot;</span>)},
    data={<span class="hljs-string">&quot;model&quot;</span>: model_id},
)
<span class="hljs-built_in">print</span>(response.json())
<span class="hljs-comment"># {&#x27;text&#x27;: &quot;Well, I don&#x27;t wish to see it any more, observed Phebe, turning away her eyes. It is certainly very like the old portrait.&quot;}</span>`,wrap:!1}}),Ce=new j({props:{title:"OpenAI Python SDK",local:"openai-python-sdk",headingTag:"h3"}}),ze=new $({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMG9wZW5haSUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:"%pip install openai --upgrade --quiet",wrap:!1}}),Ze=new $({props:{code:"YXBpX3VybCUyMCUzRCUyMGNsaWVudC5vbmxpbmVfZW5kcG9pbnRzLmdldChvcy5nZXRlbnYoJTIyRU5EUE9JTlRfTkFNRSUyMikpLnNjb3JpbmdfdXJpLnJlcGxhY2UoJTIyJTJGYXVkaW8lMkZ0cmFuc2NyaXB0aW9ucyUyMiUyQyUyMCUyMiUyMik=",highlighted:'api_url = client.online_endpoints.get(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).scoring_uri.replace(<span class="hljs-string">&quot;/audio/transcriptions&quot;</span>, <span class="hljs-string">&quot;&quot;</span>)',wrap:!1}}),V=new A({props:{$$slots:{default:[Nl]},$$scope:{ctx:w}}}),Be=new $({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBb3BlbmFpX2NsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRGFwaV91cmwlMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEYXBpX2tleSUyQyUwQSUyMCUyMCUyMCUyMGRlZmF1bHRfaGVhZGVycyUzRCU3QiUyMmF6dXJlbWwtbW9kZWwtZGVwbG95bWVudCUyMiUzQSUyMG9zLmdldGVudiglMjJERVBMT1lNRU5UX05BTUUlMjIpJTdEJTJDJTBBKSUwQSUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBvcGVuYWlfY2xpZW50LmF1ZGlvLnRyYW5zY3JpcHRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZmlsZSUzRG9wZW4oJTIyMjA4Ni0xNDkyMjAtMDAzMy53YXYlMjIlMkMlMjAlMjJyYiUyMiklMkMlMEElMjAlMjAlMjAlMjByZXNwb25zZV9mb3JtYXQlM0QlMjJqc29uJTIyJTJDJTBBKSUwQXByaW50KHRyYW5zY3JpcHRpb24udGV4dCklMEElMjMlMjBXZWxsJTJDJTIwSSUyMGRvbid0JTIwd2lzaCUyMHRvJTIwc2VlJTIwaXQlMjBhbnklMjBtb3JlJTJDJTIwb2JzZXJ2ZWQlMjBQaGViZSUyQyUyMHR1cm5pbmclMjBhd2F5JTIwaGVyJTIwZXllcy4lMjBJdCUyMGlzJTIwY2VydGFpbmx5JTIwdmVyeSUyMGxpa2UlMjB0aGUlMjBvbGQlMjBwb3J0cmFpdC4=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

openai_client = OpenAI(
    base_url=api_url,
    api_key=api_key,
    default_headers={<span class="hljs-string">&quot;azureml-model-deployment&quot;</span>: os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>)},
)

transcription = openai_client.audio.transcriptions.create(
    model=model_id,
    file=<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;2086-149220-0033.wav&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>),
    response_format=<span class="hljs-string">&quot;json&quot;</span>,
)
<span class="hljs-built_in">print</span>(transcription.text)
<span class="hljs-comment"># Well, I don&#x27;t wish to see it any more, observed Phebe, turning away her eyes. It is certainly very like the old portrait.</span>`,wrap:!1}}),Ve=new j({props:{title:"cURL",local:"curl",headingTag:"h3"}}),We=new $({props:{code:"b3MuZW52aXJvbiU1QiUyMkFQSV9VUkwlMjIlNUQlMjAlM0QlMjBhcGlfdXJsJTBBb3MuZW52aXJvbiU1QiUyMkFQSV9LRVklMjIlNUQlMjAlM0QlMjBhcGlfa2V5",highlighted:`os.environ[<span class="hljs-string">&quot;API_URL&quot;</span>] = api_url
os.environ[<span class="hljs-string">&quot;API_KEY&quot;</span>] = api_key`,wrap:!1}}),Se=new $({props:{code:"IWN1cmwlMjAtc1MlMjAlMjRBUElfVVJMJTJGYXVkaW8lMkZ0cmFuc2NyaXB0aW9ucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJTIyQXV0aG9yaXphdGlvbiUzQSUyMEJlYXJlciUyMCUyNEFQSV9LRVklMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCUyMmF6dXJlbWwtbW9kZWwtZGVwbG95bWVudCUzQSUyMCUyNERFUExPWU1FTlRfTkFNRSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJTIyQ29udGVudC1UeXBlJTNBJTIwbXVsdGlwYXJ0JTJGZm9ybS1kYXRhJTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUYlMjBmaWxlJTNEJTQwMjA4Ni0xNDkyMjAtMDAzMy53YXYlMjAlNUMlMEElMjAlMjAlMjAlMjAtRiUyMG1vZGVsJTNEbnZpZGlhJTJGcGFyYWtlZXQtdGR0LTAuNmItdjI=",highlighted:`!curl -sS $API_URL/audio/transcriptions \\
    -H <span class="hljs-string">&quot;Authorization: Bearer $API_KEY&quot;</span> \\
    -H <span class="hljs-string">&quot;azureml-model-deployment: $DEPLOYMENT_NAME&quot;</span> \\
    -H <span class="hljs-string">&quot;Content-Type: multipart/form-data&quot;</span> \\
    -F file=@<span class="hljs-number">2086</span>-<span class="hljs-number">149220</span>-<span class="hljs-number">0033.</span>wav \\
    -F model=nvidia/parakeet-tdt-<span class="hljs-number">0.6</span>b-v2`,wrap:!1}}),Ge=new j({props:{title:"Gradio",local:"gradio",headingTag:"h3"}}),L=new A({props:{$$slots:{default:[Ql]},$$scope:{ctx:w}}}),Qe=new $({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGdyYWRpbyUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:"%pip install gradio --upgrade --quiet",wrap:!1}}),He=new $({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwcGF0aGxpYiUyMGltcG9ydCUyMFBhdGglMEElMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQW9wZW5haV9jbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0Rvcy5nZXRlbnYoJTIyQVBJX1VSTCUyMiklMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEb3MuZ2V0ZW52KCUyMkFQSV9LRVklMjIpJTJDJTBBJTIwJTIwJTIwJTIwZGVmYXVsdF9oZWFkZXJzJTNEJTdCJTIyYXp1cmVtbC1tb2RlbC1kZXBsb3ltZW50JTIyJTNBJTIwb3MuZ2V0ZW52KCUyMkRFUExPWU1FTlRfTkFNRSUyMiklN0QlMkMlMEEpJTBBJTBBJTBBZGVmJTIwdHJhbnNjcmliZShhdWRpbyUzQSUyMFBhdGglMkMlMjB0ZW1wZXJhdHVyZSUzQSUyMGZsb2F0JTIwJTNEJTIwMS4wKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvcGVuYWlfY2xpZW50LmF1ZGlvLnRyYW5zY3JpcHRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmlsZSUzRG9wZW4oYXVkaW8lMkMlMjAlMjJyYiUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRHRlbXBlcmF0dXJlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2VfZm9ybWF0JTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMEFkZW1vJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEdHJhbnNjcmliZSUyQyUwQSUyMCUyMCUyMCUyMGlucHV0cyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGh0dHBzJTNBJTJGJTJGd3d3LmdyYWRpby5hcHAlMkZkb2NzJTJGZ3JhZGlvJTJGYXVkaW8lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyh0eXBlJTNEJTIyZmlsZXBhdGglMjIlMkMlMjBzdHJlYW1pbmclM0RGYWxzZSUyQyUyMGxhYmVsJTNEJTIyVXBsb2FkJTIwb3IlMjBSZWNvcmQlMjBBdWRpbyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIoMCUyQyUyMDElMkMlMjB2YWx1ZSUzRDAuMCUyQyUyMHN0ZXAlM0QwLjElMkMlMjBsYWJlbCUzRCUyMlRlbXBlcmF0dXJlJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0Rnci5UZXh0Ym94KGxhYmVsJTNEJTIyVHJhbnNjcmliZWQlMjBUZXh0JTIyKSUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyTlZJRElBJTIwUGFyYWtlZXQlMjBvbiUyMEF6dXJlJTIwQUklMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlVwbG9hZCUyMG9yJTIwcmVjb3JkJTIwYXVkaW8lMjBhbmQlMjBnZXQlMjB0aGUlMjB0cmFuc2NyaWJlZCUyMHRleHQlMjB1c2luZyUyME5WSURJQSUyMFBhcmFrZWV0JTIwb24lMjBBenVyZSUyMEFJJTIwdmlhJTIwdGhlJTIwT3BlbkFJJ3MlMjBUcmFuc2NyaXB0aW9uJTIwQVBJLiUyMiUyQyUwQSklMEElMEFkZW1vLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

openai_client = OpenAI(
    base_url=os.getenv(<span class="hljs-string">&quot;API_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;API_KEY&quot;</span>),
    default_headers={<span class="hljs-string">&quot;azureml-model-deployment&quot;</span>: os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>)},
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">audio: Path, temperature: <span class="hljs-built_in">float</span> = <span class="hljs-number">1.0</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-keyword">return</span> openai_client.audio.transcriptions.create(
        model=model_id,
        file=<span class="hljs-built_in">open</span>(audio, <span class="hljs-string">&quot;rb&quot;</span>),
        temperature=temperature,
        response_format=<span class="hljs-string">&quot;text&quot;</span>,
    )


demo = gr.Interface(
    fn=transcribe,
    inputs=[
        <span class="hljs-comment"># https://www.gradio.app/docs/gradio/audio</span>
        gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, streaming=<span class="hljs-literal">False</span>, label=<span class="hljs-string">&quot;Upload or Record Audio&quot;</span>),
        gr.Slider(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, value=<span class="hljs-number">0.0</span>, step=<span class="hljs-number">0.1</span>, label=<span class="hljs-string">&quot;Temperature&quot;</span>),
    ],
    outputs=gr.Textbox(label=<span class="hljs-string">&quot;Transcribed Text&quot;</span>),
    title=<span class="hljs-string">&quot;NVIDIA Parakeet on Azure AI&quot;</span>,
    description=<span class="hljs-string">&quot;Upload or record audio and get the transcribed text using NVIDIA Parakeet on Azure AI via the OpenAI&#x27;s Transcription API.&quot;</span>,
)

demo.launch()`,wrap:!1}}),qe=new j({props:{title:"Release resources",local:"release-resources",headingTag:"h2"}}),Pe=new $({props:{code:"Y2xpZW50Lm9ubGluZV9lbmRwb2ludHMuYmVnaW5fZGVsZXRlKG5hbWUlM0Rvcy5nZXRlbnYoJTIyRU5EUE9JTlRfTkFNRSUyMikpLnJlc3VsdCgp",highlighted:'client.online_endpoints.begin_delete(name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).result()',wrap:!1}}),Ye=new j({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),W=new A({props:{$$slots:{default:[Hl]},$$scope:{ctx:w}}}),Ke=new _l({props:{source:"https://github.com/huggingface/Microsoft-Azure/blob/main/docs/source/azure-ai/examples/deploy-nvidia-parakeet-asr.mdx"}}),{c(){a=r("meta"),y=s(),o=r("p"),g=s(),d(J.$$.fragment),b=s(),v=r("p"),v.textContent=S,T=s(),U=r("p"),U.textContent=En,tt=s(),nt=r("hr"),lt=s(),F=r("p"),F.innerHTML=Zn,at=s(),G=r("p"),G.innerHTML=_n,st=s(),N=r("p"),N.textContent=Rn,it=s(),Q=r("ul"),Q.innerHTML=Bn,ot=s(),H=r("p"),H.innerHTML=Vn,rt=s(),x=r("p"),x.innerHTML=Ln,pt=s(),q=r("p"),q.innerHTML=Wn,ut=s(),d(C.$$.fragment),dt=s(),d(X.$$.fragment),Mt=s(),P=r("p"),P.innerHTML=Sn,mt=s(),Y=r("ul"),Y.innerHTML=Fn,ct=s(),D=r("p"),D.innerHTML=Gn,ht=s(),d(O.$$.fragment),ft=s(),K=r("p"),K.innerHTML=Nn,yt=s(),d(ee.$$.fragment),gt=s(),te=r("p"),te.innerHTML=Qn,wt=s(),ne=r("p"),ne.textContent=Hn,Tt=s(),d(le.$$.fragment),$t=s(),ae=r("p"),ae.textContent=xn,Ut=s(),d(k.$$.fragment),Jt=s(),d(se.$$.fragment),bt=s(),d(ie.$$.fragment),jt=s(),oe=r("p"),oe.innerHTML=qn,At=s(),d(z.$$.fragment),It=s(),d(re.$$.fragment),vt=s(),d(pe.$$.fragment),Ct=s(),ue=r("p"),ue.innerHTML=Xn,kt=s(),d(de.$$.fragment),zt=s(),d(E.$$.fragment),Et=s(),Me=r("p"),Me.innerHTML=Pn,Zt=s(),d(Z.$$.fragment),_t=s(),d(me.$$.fragment),Rt=s(),d(ce.$$.fragment),Bt=s(),he=r("p"),he.innerHTML=Yn,Vt=s(),d(_.$$.fragment),Lt=s(),d(fe.$$.fragment),Wt=s(),ye=r("p"),ye.innerHTML=Dn,St=s(),d(R.$$.fragment),Ft=s(),ge=r("p"),ge.innerHTML=On,Gt=s(),d(we.$$.fragment),Nt=s(),Te=r("p"),Te.innerHTML=Kn,Qt=s(),$e=r("p"),$e.innerHTML=el,Ht=s(),d(B.$$.fragment),xt=s(),Ue=r("p"),Ue.innerHTML=tl,qt=s(),d(Je.$$.fragment),Xt=s(),be=r("p"),be.innerHTML=nl,Pt=s(),d(je.$$.fragment),Yt=s(),d(Ae.$$.fragment),Dt=s(),Ie=r("p"),Ie.innerHTML=ll,Ot=s(),d(ve.$$.fragment),Kt=s(),d(Ce.$$.fragment),en=s(),ke=r("p"),ke.innerHTML=al,tn=s(),d(ze.$$.fragment),nn=s(),Ee=r("p"),Ee.innerHTML=sl,ln=s(),d(Ze.$$.fragment),an=s(),d(V.$$.fragment),sn=s(),_e=r("p"),_e.innerHTML=il,on=s(),Re=r("p"),Re.innerHTML=ol,rn=s(),d(Be.$$.fragment),pn=s(),d(Ve.$$.fragment),un=s(),Le=r("p"),Le.innerHTML=rl,dn=s(),d(We.$$.fragment),Mn=s(),d(Se.$$.fragment),mn=s(),Fe=r("p"),Fe.textContent=pl,cn=s(),d(Ge.$$.fragment),hn=s(),Ne=r("p"),Ne.innerHTML=ul,fn=s(),d(L.$$.fragment),yn=s(),d(Qe.$$.fragment),gn=s(),d(He.$$.fragment),wn=s(),xe=r("p"),xe.innerHTML=dl,Tn=s(),d(qe.$$.fragment),$n=s(),Xe=r("p"),Xe.textContent=Ml,Un=s(),d(Pe.$$.fragment),Jn=s(),d(Ye.$$.fragment),bn=s(),De=r("p"),De.textContent=ml,jn=s(),Oe=r("p"),Oe.innerHTML=cl,An=s(),In=r("hr"),vn=s(),d(W.$$.fragment),Cn=s(),d(Ke.$$.fragment),kn=s(),et=r("p"),this.h()},l(e){const t=El("svelte-u9bgzb",document.head);a=p(t,"META",{name:!0,content:!0}),t.forEach(n),y=i(e),o=p(e,"P",{}),Al(o).forEach(n),g=i(e),M(J.$$.fragment,e),b=i(e),v=p(e,"P",{"data-svelte-h":!0}),u(v)!=="svelte-qcuv86"&&(v.textContent=S),T=i(e),U=p(e,"P",{"data-svelte-h":!0}),u(U)!=="svelte-qzlp4s"&&(U.textContent=En),tt=i(e),nt=p(e,"HR",{}),lt=i(e),F=p(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-ygi5er"&&(F.innerHTML=Zn),at=i(e),G=p(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-17a4trs"&&(G.innerHTML=_n),st=i(e),N=p(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-1mr2e6"&&(N.textContent=Rn),it=i(e),Q=p(e,"UL",{"data-svelte-h":!0}),u(Q)!=="svelte-eb82nc"&&(Q.innerHTML=Bn),ot=i(e),H=p(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-10zpqm2"&&(H.innerHTML=Vn),rt=i(e),x=p(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-1dzfint"&&(x.innerHTML=Ln),pt=i(e),q=p(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-1gli84r"&&(q.innerHTML=Wn),ut=i(e),M(C.$$.fragment,e),dt=i(e),M(X.$$.fragment,e),Mt=i(e),P=p(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-dnkqle"&&(P.innerHTML=Sn),mt=i(e),Y=p(e,"UL",{"data-svelte-h":!0}),u(Y)!=="svelte-dlzkka"&&(Y.innerHTML=Fn),ct=i(e),D=p(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1myp7ii"&&(D.innerHTML=Gn),ht=i(e),M(O.$$.fragment,e),ft=i(e),K=p(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-bexho5"&&(K.innerHTML=Nn),yt=i(e),M(ee.$$.fragment,e),gt=i(e),te=p(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-1v277rw"&&(te.innerHTML=Qn),wt=i(e),ne=p(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-11uslf2"&&(ne.textContent=Hn),Tt=i(e),M(le.$$.fragment,e),$t=i(e),ae=p(e,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-1wrtw53"&&(ae.textContent=xn),Ut=i(e),M(k.$$.fragment,e),Jt=i(e),M(se.$$.fragment,e),bt=i(e),M(ie.$$.fragment,e),jt=i(e),oe=p(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-1v2xdwc"&&(oe.innerHTML=qn),At=i(e),M(z.$$.fragment,e),It=i(e),M(re.$$.fragment,e),vt=i(e),M(pe.$$.fragment,e),Ct=i(e),ue=p(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-16ken9o"&&(ue.innerHTML=Xn),kt=i(e),M(de.$$.fragment,e),zt=i(e),M(E.$$.fragment,e),Et=i(e),Me=p(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-n9ya7n"&&(Me.innerHTML=Pn),Zt=i(e),M(Z.$$.fragment,e),_t=i(e),M(me.$$.fragment,e),Rt=i(e),M(ce.$$.fragment,e),Bt=i(e),he=p(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-oe1xgq"&&(he.innerHTML=Yn),Vt=i(e),M(_.$$.fragment,e),Lt=i(e),M(fe.$$.fragment,e),Wt=i(e),ye=p(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-1lo3ppe"&&(ye.innerHTML=Dn),St=i(e),M(R.$$.fragment,e),Ft=i(e),ge=p(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-peskmc"&&(ge.innerHTML=On),Gt=i(e),M(we.$$.fragment,e),Nt=i(e),Te=p(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-11ec10k"&&(Te.innerHTML=Kn),Qt=i(e),$e=p(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-1l8sq3y"&&($e.innerHTML=el),Ht=i(e),M(B.$$.fragment,e),xt=i(e),Ue=p(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-fhm0e5"&&(Ue.innerHTML=tl),qt=i(e),M(Je.$$.fragment,e),Xt=i(e),be=p(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-1x7qtcm"&&(be.innerHTML=nl),Pt=i(e),M(je.$$.fragment,e),Yt=i(e),M(Ae.$$.fragment,e),Dt=i(e),Ie=p(e,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-31zkgr"&&(Ie.innerHTML=ll),Ot=i(e),M(ve.$$.fragment,e),Kt=i(e),M(Ce.$$.fragment,e),en=i(e),ke=p(e,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-1cwwxgq"&&(ke.innerHTML=al),tn=i(e),M(ze.$$.fragment,e),nn=i(e),Ee=p(e,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-hibrsl"&&(Ee.innerHTML=sl),ln=i(e),M(Ze.$$.fragment,e),an=i(e),M(V.$$.fragment,e),sn=i(e),_e=p(e,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-1t4oej1"&&(_e.innerHTML=il),on=i(e),Re=p(e,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-1t8h4hs"&&(Re.innerHTML=ol),rn=i(e),M(Be.$$.fragment,e),pn=i(e),M(Ve.$$.fragment,e),un=i(e),Le=p(e,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-6rxgjf"&&(Le.innerHTML=rl),dn=i(e),M(We.$$.fragment,e),Mn=i(e),M(Se.$$.fragment,e),mn=i(e),Fe=p(e,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-ogqx26"&&(Fe.textContent=pl),cn=i(e),M(Ge.$$.fragment,e),hn=i(e),Ne=p(e,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-84t7ko"&&(Ne.innerHTML=ul),fn=i(e),M(L.$$.fragment,e),yn=i(e),M(Qe.$$.fragment,e),gn=i(e),M(He.$$.fragment,e),wn=i(e),xe=p(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-hn6aoa"&&(xe.innerHTML=dl),Tn=i(e),M(qe.$$.fragment,e),$n=i(e),Xe=p(e,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-rntoeu"&&(Xe.textContent=Ml),Un=i(e),M(Pe.$$.fragment,e),Jn=i(e),M(Ye.$$.fragment,e),bn=i(e),De=p(e,"P",{"data-svelte-h":!0}),u(De)!=="svelte-19mlnr1"&&(De.textContent=ml),jn=i(e),Oe=p(e,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-1nopug0"&&(Oe.innerHTML=cl),An=i(e),In=p(e,"HR",{}),vn=i(e),M(W.$$.fragment,e),Cn=i(e),M(Ke.$$.fragment,e),kn=i(e),et=p(e,"P",{}),Al(et).forEach(n),this.h()},h(){Il(a,"name","hf:doc:metadata"),Il(a,"content",ql)},m(e,t){Zl(document.head,a),l(e,y,t),l(e,o,t),l(e,g,t),m(J,e,t),l(e,b,t),l(e,v,t),l(e,T,t),l(e,U,t),l(e,tt,t),l(e,nt,t),l(e,lt,t),l(e,F,t),l(e,at,t),l(e,G,t),l(e,st,t),l(e,N,t),l(e,it,t),l(e,Q,t),l(e,ot,t),l(e,H,t),l(e,rt,t),l(e,x,t),l(e,pt,t),l(e,q,t),l(e,ut,t),m(C,e,t),l(e,dt,t),m(X,e,t),l(e,Mt,t),l(e,P,t),l(e,mt,t),l(e,Y,t),l(e,ct,t),l(e,D,t),l(e,ht,t),m(O,e,t),l(e,ft,t),l(e,K,t),l(e,yt,t),m(ee,e,t),l(e,gt,t),l(e,te,t),l(e,wt,t),l(e,ne,t),l(e,Tt,t),m(le,e,t),l(e,$t,t),l(e,ae,t),l(e,Ut,t),m(k,e,t),l(e,Jt,t),m(se,e,t),l(e,bt,t),m(ie,e,t),l(e,jt,t),l(e,oe,t),l(e,At,t),m(z,e,t),l(e,It,t),m(re,e,t),l(e,vt,t),m(pe,e,t),l(e,Ct,t),l(e,ue,t),l(e,kt,t),m(de,e,t),l(e,zt,t),m(E,e,t),l(e,Et,t),l(e,Me,t),l(e,Zt,t),m(Z,e,t),l(e,_t,t),m(me,e,t),l(e,Rt,t),m(ce,e,t),l(e,Bt,t),l(e,he,t),l(e,Vt,t),m(_,e,t),l(e,Lt,t),m(fe,e,t),l(e,Wt,t),l(e,ye,t),l(e,St,t),m(R,e,t),l(e,Ft,t),l(e,ge,t),l(e,Gt,t),m(we,e,t),l(e,Nt,t),l(e,Te,t),l(e,Qt,t),l(e,$e,t),l(e,Ht,t),m(B,e,t),l(e,xt,t),l(e,Ue,t),l(e,qt,t),m(Je,e,t),l(e,Xt,t),l(e,be,t),l(e,Pt,t),m(je,e,t),l(e,Yt,t),m(Ae,e,t),l(e,Dt,t),l(e,Ie,t),l(e,Ot,t),m(ve,e,t),l(e,Kt,t),m(Ce,e,t),l(e,en,t),l(e,ke,t),l(e,tn,t),m(ze,e,t),l(e,nn,t),l(e,Ee,t),l(e,ln,t),m(Ze,e,t),l(e,an,t),m(V,e,t),l(e,sn,t),l(e,_e,t),l(e,on,t),l(e,Re,t),l(e,rn,t),m(Be,e,t),l(e,pn,t),m(Ve,e,t),l(e,un,t),l(e,Le,t),l(e,dn,t),m(We,e,t),l(e,Mn,t),m(Se,e,t),l(e,mn,t),l(e,Fe,t),l(e,cn,t),m(Ge,e,t),l(e,hn,t),l(e,Ne,t),l(e,fn,t),m(L,e,t),l(e,yn,t),m(Qe,e,t),l(e,gn,t),m(He,e,t),l(e,wn,t),l(e,xe,t),l(e,Tn,t),m(qe,e,t),l(e,$n,t),l(e,Xe,t),l(e,Un,t),m(Pe,e,t),l(e,Jn,t),m(Ye,e,t),l(e,bn,t),l(e,De,t),l(e,jn,t),l(e,Oe,t),l(e,An,t),l(e,In,t),l(e,vn,t),m(W,e,t),l(e,Cn,t),m(Ke,e,t),l(e,kn,t),l(e,et,t),zn=!0},p(e,[t]){const hl={};t&2&&(hl.$$scope={dirty:t,ctx:e}),C.$set(hl);const fl={};t&2&&(fl.$$scope={dirty:t,ctx:e}),k.$set(fl);const yl={};t&2&&(yl.$$scope={dirty:t,ctx:e}),z.$set(yl);const gl={};t&2&&(gl.$$scope={dirty:t,ctx:e}),E.$set(gl);const wl={};t&2&&(wl.$$scope={dirty:t,ctx:e}),Z.$set(wl);const Tl={};t&2&&(Tl.$$scope={dirty:t,ctx:e}),_.$set(Tl);const $l={};t&2&&($l.$$scope={dirty:t,ctx:e}),R.$set($l);const Ul={};t&2&&(Ul.$$scope={dirty:t,ctx:e}),B.$set(Ul);const Jl={};t&2&&(Jl.$$scope={dirty:t,ctx:e}),V.$set(Jl);const bl={};t&2&&(bl.$$scope={dirty:t,ctx:e}),L.$set(bl);const jl={};t&2&&(jl.$$scope={dirty:t,ctx:e}),W.$set(jl)},i(e){zn||(c(J.$$.fragment,e),c(C.$$.fragment,e),c(X.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(k.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(z.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),c(E.$$.fragment,e),c(Z.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(_.$$.fragment,e),c(fe.$$.fragment,e),c(R.$$.fragment,e),c(we.$$.fragment,e),c(B.$$.fragment,e),c(Je.$$.fragment,e),c(je.$$.fragment,e),c(Ae.$$.fragment,e),c(ve.$$.fragment,e),c(Ce.$$.fragment,e),c(ze.$$.fragment,e),c(Ze.$$.fragment,e),c(V.$$.fragment,e),c(Be.$$.fragment,e),c(Ve.$$.fragment,e),c(We.$$.fragment,e),c(Se.$$.fragment,e),c(Ge.$$.fragment,e),c(L.$$.fragment,e),c(Qe.$$.fragment,e),c(He.$$.fragment,e),c(qe.$$.fragment,e),c(Pe.$$.fragment,e),c(Ye.$$.fragment,e),c(W.$$.fragment,e),c(Ke.$$.fragment,e),zn=!0)},o(e){h(J.$$.fragment,e),h(C.$$.fragment,e),h(X.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(k.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),h(z.$$.fragment,e),h(re.$$.fragment,e),h(pe.$$.fragment,e),h(de.$$.fragment,e),h(E.$$.fragment,e),h(Z.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(_.$$.fragment,e),h(fe.$$.fragment,e),h(R.$$.fragment,e),h(we.$$.fragment,e),h(B.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(Ae.$$.fragment,e),h(ve.$$.fragment,e),h(Ce.$$.fragment,e),h(ze.$$.fragment,e),h(Ze.$$.fragment,e),h(V.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),h(We.$$.fragment,e),h(Se.$$.fragment,e),h(Ge.$$.fragment,e),h(L.$$.fragment,e),h(Qe.$$.fragment,e),h(He.$$.fragment,e),h(qe.$$.fragment,e),h(Pe.$$.fragment,e),h(Ye.$$.fragment,e),h(W.$$.fragment,e),h(Ke.$$.fragment,e),zn=!1},d(e){e&&(n(y),n(o),n(g),n(b),n(v),n(T),n(U),n(tt),n(nt),n(lt),n(F),n(at),n(G),n(st),n(N),n(it),n(Q),n(ot),n(H),n(rt),n(x),n(pt),n(q),n(ut),n(dt),n(Mt),n(P),n(mt),n(Y),n(ct),n(D),n(ht),n(ft),n(K),n(yt),n(gt),n(te),n(wt),n(ne),n(Tt),n($t),n(ae),n(Ut),n(Jt),n(bt),n(jt),n(oe),n(At),n(It),n(vt),n(Ct),n(ue),n(kt),n(zt),n(Et),n(Me),n(Zt),n(_t),n(Rt),n(Bt),n(he),n(Vt),n(Lt),n(Wt),n(ye),n(St),n(Ft),n(ge),n(Gt),n(Nt),n(Te),n(Qt),n($e),n(Ht),n(xt),n(Ue),n(qt),n(Xt),n(be),n(Pt),n(Yt),n(Dt),n(Ie),n(Ot),n(Kt),n(en),n(ke),n(tn),n(nn),n(Ee),n(ln),n(an),n(sn),n(_e),n(on),n(Re),n(rn),n(pn),n(un),n(Le),n(dn),n(Mn),n(mn),n(Fe),n(cn),n(hn),n(Ne),n(fn),n(yn),n(gn),n(wn),n(xe),n(Tn),n($n),n(Xe),n(Un),n(Jn),n(bn),n(De),n(jn),n(Oe),n(An),n(In),n(vn),n(Cn),n(kn),n(et)),n(a),f(J,e),f(C,e),f(X,e),f(O,e),f(ee,e),f(le,e),f(k,e),f(se,e),f(ie,e),f(z,e),f(re,e),f(pe,e),f(de,e),f(E,e),f(Z,e),f(me,e),f(ce,e),f(_,e),f(fe,e),f(R,e),f(we,e),f(B,e),f(Je,e),f(je,e),f(Ae,e),f(ve,e),f(Ce,e),f(ze,e),f(Ze,e),f(V,e),f(Be,e),f(Ve,e),f(We,e),f(Se,e),f(Ge,e),f(L,e),f(Qe,e),f(He,e),f(qe,e),f(Pe,e),f(Ye,e),f(W,e),f(Ke,e)}}}const ql='{"title":"Deploy NVIDIA Parakeet for Automatic Speech Recognition (ASR) on Azure AI","local":"deploy-nvidia-parakeet-for-automatic-speech-recognition-asr-on-azure-ai","sections":[{"title":"Pre-requisites","local":"pre-requisites","sections":[],"depth":2},{"title":"Setup and installation","local":"setup-and-installation","sections":[],"depth":2},{"title":"Authenticate to Azure ML","local":"authenticate-to-azure-ml","sections":[],"depth":2},{"title":"Create and Deploy Azure AI Endpoint","local":"create-and-deploy-azure-ai-endpoint","sections":[],"depth":2},{"title":"Send requests to the Azure AI Endpoint","local":"send-requests-to-the-azure-ai-endpoint","sections":[{"title":"Python requests","local":"python-requests","sections":[],"depth":3},{"title":"OpenAI Python SDK","local":"openai-python-sdk","sections":[],"depth":3},{"title":"cURL","local":"curl","sections":[],"depth":3},{"title":"Gradio","local":"gradio","sections":[],"depth":3}],"depth":2},{"title":"Release resources","local":"release-resources","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Xl(w){return Cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ea extends kl{constructor(a){super(),zl(this,a,Xl,xl,vl,{})}}export{ea as component};
