import{s as da,f as ua,n as Ca,o as ba}from"../chunks/scheduler.7bc62968.js";import{S as fa,i as ga,g as i,s as a,r as T,A as Aa,h as M,f as e,c as n,j as ma,u as p,x as J,k as ps,y as xa,a as l,v as o,d as w,t as y,w as r}from"../chunks/index.2f8492b0.js";import{C as c}from"../chunks/CodeBlock.bb61a5a9.js";import{H as h,E as ka}from"../chunks/getInferenceSnippets.f5d646ec.js";function Ba(Jl){let U,ys,os,rs,I,cs,m,Tl="This section will describe how object detection tasks are achieved using Vision Transformers. We will understand how to fine-tune existing pre-trained object detection models for our use case. Before starting, check out this HuggingFace Space, where you can play around with the final output.",js,j,pl="",ol,hs,d,Us,u,wl='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/object_detection_wiki.png" alt="Object detection example"/>',Is,C,yl="Object detection is a computer vision task that involves identifying and localizing objects within an image or video. It consists of two main steps:",ms,b,rl="<li>First, recognizing the types of objects present (such as cars, people, or animals).</li> <li>Second, determining their precise locations by drawing bounding boxes around them.</li>",ds,f,cl="These models typically receive images (static or frames from videos) as their inputs, with multiple objects present in each image. For example, consider an image containing several objects such as cars, people, bicycles, and so on. Upon processing the input, these models produce a set of numbers that convey the following information:",us,g,jl="<li>Location of the object (XY coordinates of the bounding box).</li> <li>Class of the object.</li>",Cs,A,hl="There are a lot of of applications around object detection. One of the most significant examples is in the field of autonomous driving, where object detection is used to detect different objects (like pedestrians, road signs, traffic lights, etc)  around the car that become one of the inputs for taking decisions.",bs,x,Ul='To deepen your understanding of the ins-and-outs of object detection, check out our <a href="https://huggingface.co/learn/computer-vision-course/unit6/basic-cv-tasks/object_detection" rel="nofollow">dedicated chapter</a> on Object Detection 🤗.',fs,k,gs,B,Il="Should you build a new model, or alter an existing one? That is an awesome question. Training an object detection model from scratch means:",As,Q,ml="<li>Doing already done research over and over again.</li> <li>Writing repetitive model code, training them, and maintaining different repositories for different use cases.</li> <li>A lot of experimentation and waste of resources.</li>",xs,Z,dl="Rather than doing all this, take a well-performing pre-trained model (a model which that does an awesome job in recognizing general features), and tweak or re-tune its weights (or some part of its weights) to adapt it for your use case. We believe or assume that the pre-trained model has already learned enough to extract significant features inside an image to locate and classify objects. So, if new objects are introduced, then the same model can be trained for a small period of time and compute to start detecting those new objects with the help of already learned and new features.",ks,v,ul="By the end of this tutorial, you should be able to make a full pipeline (from loading datasets, fine-tuning a model and doing inference) for object detection use case.",Bs,N,Qs,G,Cl="Let’s start with installation. Just execute the below cells to install the necessary packages. For this tutorial, we will be using Hugging Face Transformers and PyTorch.",Zs,E,vs,W,Ns,_,bl="To make this tutorial interesting, let’s consider a real-world example. Consider this scenario: construction workers require the utmost safety when working in construction areas. Basic safety protocol requires wearing a helmet every time. Since there are many construction workers, it is hard to keep and eye on everyone every time.",Gs,V,fl="But, if we can have a camera system that can detect persons and whether the person is wearing a helmet or not in real-time, that would be awesome, right?",Es,R,gl="So, we are going to fine-tune a lightweight object detection model for doing just that. Let’s dive in.",Ws,$,_s,z,Al='For the above scenario, we will use the <a href="https://huggingface.co/datasets/hf-vision/hardhat" rel="nofollow">hardhat</a> dataset provided by <a href="https://dataverse.harvard.edu/dataset.xhtml?persistentId=doi:10.7910/DVN/7CBGOS" rel="nofollow">Northeastern University China</a>. We can download and load this dataset with  🤗 <code>datasets</code>.',Vs,D,Rs,S,xl="This will give you the following data structure:",$s,Y,zs,X,kl=`Above is a <a href="https://huggingface.co/docs/datasets/v2.17.1/en/package_reference/main_classes#datasets.DatasetDict" rel="nofollow">DatasetDict</a>, which is an efficient dict-like structure containing the whole dataset in train and test splits. As you can see, under each split (train and test), we have <code>features</code> and <code>num_rows</code>. Under features, we have the <code>image</code>, a <a href="https://realpython.com/image-processing-with-the-python-pillow-library/" rel="nofollow">Pillow Object</a>, the id of the image, height and width, and objects.
Now let’s see what each datapoint (in train/test set) looks like. To do that, run the following line:`,Ds,H,Ss,F,Bl="And this will give you the following structure:",Ys,L,Xs,q,Ql="As you see, <code>objects</code> is an another dict containing the object ids (which are the class ids here), the area of the objects, and the bounding box coordinates (<code>bbox</code>) and the category (or the label). Here is a more detailed explaination of each of the keys and values of a data element.",Hs,K,Zl="<li><code>image</code>: This is a Pillow Image object that helps to look into the image directly before even loading from the path.</li> <li><code>image_id</code>: Denotes which number of images is from the train file.</li> <li><code>width</code>: The width of the image.</li> <li><code>height</code>: The height of the image.</li> <li><code>objects</code>:  Another dictionary containing information about annotation. This contains the following:<ul><li><code>id</code>: A list, where the length of the list denotes the number of objects and the value of each denotes the class index.</li> <li><code>area</code>: The area of the object.</li> <li><code>bbox</code>: Denotes bounding box coordinates of the object.</li> <li><code>category</code>: The class (string) of the object.</li></ul></li>",Fs,P,vl="Now let’s properly extract the train and test samples. For this tutorial, we have around 5000 training samples and 1700 test samples.",Ls,O,qs,tt,Nl="Now that we know what a sample data point contains, let’s start by plotting that sample. Here we are going to first draw the image and then also draw the corresponding bounding box.",Ks,st,Gl="Here is what we are going to do:",Ps,et,El="<li>Get the image and its corresponding height and width.</li> <li>Make a draw object that can easily draw text and lines on image.</li> <li>Get the annotations dict from the sample.</li> <li>Iterate over it.</li> <li>For each, get the bounding box co-ordinates, which are x (where the bounding box starts horizontally), y (where the bounding box starts vertically), w (width of the bounding box), h (height of the bounding box).</li> <li>Now if the bounding box measures are normalized then scale it, else leave it.</li> <li>And finally draw the rectangle and the the class category text.</li>",Os,lt,te,at,Wl="We have a function to plot one single image, let’s write a simple function using the above to plot multiple images. This will help us with some analysis.",se,nt,ee,it,_l="Running the function will give us a beautiful collage shown below.",le,Mt,Vl='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/object_detection_train_image_with_annotation_plots.png" alt="input-image-plot"/>',ae,Jt,ne,Tt,Rl='Before fine-tuning the model, we must preprocess the data in such a way that it matches exactly with the approach used during the time of pre-training. HuggingFace <a href="https://huggingface.co/docs/transformers/v4.36.0/en/model_doc/auto#transformers.AutoImageProcessor" rel="nofollow">AutoImageProcessor</a> takes care of processing the image data to create <code>pixel_values</code>, <code>pixel_mask</code>, and <code>labels</code> that a DETR model can train with.',ie,pt,$l="Now, let us instantiate the image processor from the same checkpoint we want to use our model to fine-tune.",Me,ot,Je,wt,Te,yt,zl="Before passing the images to the <code>image_processor</code>, let’s also apply different types of augmentations to the images along with their corresponding bounding boxes.",pe,rt,Dl='In simple terms, augmentations are some set of random transformations like rotations, resizing etc. These are applied to get more samples and to make the vision model more robust towards different conditions of the image. We will use the <a href="https://github.com/albumentations-team/albumentations" rel="nofollow">albumentations</a> library to achieve this. It let’s you to create random transformations of the images so that your sample size increases for training.',oe,ct,we,jt,Sl="Once we initialize all the transformations, we need to make a function which formats the annotations and returns the a list of annotation with a very specific format.",ye,ht,Yl="This is because the <code>image_processor</code> expects the annotations to be in the following format: <code>{&#39;image_id&#39;: int, &#39;annotations&#39;: List[Dict]}</code>, where each dictionary is a COCO object annotation.",re,Ut,ce,It,Xl="Finally, we combine the image and annotation transformations to do transformations over the whole batch of dataset.",je,mt,Hl="Here is the final code to do so:",he,dt,Ue,ut,Fl='Finally, all you have to do is apply this preprocessing function to the entire dataset. You can achieve this by using HuggingFace 🤗 <a href="https://huggingface.co/docs/datasets/v2.15.0/en/package_reference/main_classes#datasets.Dataset.with_transform" rel="nofollow">Datasets with transform</a> method.',Ie,Ct,me,bt,Ll="Now let’s see how a transformed train dataset sample looks like:",de,ft,ue,gt,ql="This will return a dictionary of tensors. What we mainly require here is the <code>pixel_values</code> which represent the image, <code>pixel_mask</code> which is the attention masks and the <code>labels</code>. Here is one data point looks like:",Ce,At,be,xt,Kl="We are almost there 🚀. As a last preprocessing step, we need to write a custom <code>collate_fn</code>. Now what is a <code>collate_fn</code> ?",fe,kt,Pl="A <code>collate_fn</code> is responsible for taking a list of samples from a dataset and converting them into a batch suitable for model’s input format.",ge,Bt,Ol="In general a <code>DataCollator</code> typically performs tasks such as padding, truncating etc. In a custom collate function, we often define what and how we want to group the data into batches or simply, how to represent each batch.",Ae,Qt,ta="Data collator mainly puts the data together and then preprocesses them. Let’s make our collate function.",xe,Zt,ke,vt,Be,Nt,sa="So, all the heavy lifting is done so far. Now, all that is left is to assemble each part of the puzzle one by one. Let’s go!",Qe,Gt,ea="The training procedure involves the following steps:",Ze,Et,la='<li><p>Loading the base (pre-trained) model with <a href="https://huggingface.co/docs/transformers/v4.36.0/en/model_doc/auto#transformers.AutoModelForObjectDetection" rel="nofollow">AutoModelForObjectDetection</a> using the same checkpoint as in the preprocessing.</p></li> <li><p>Defining all the hyperparameters and additional arguments inside <a href="https://huggingface.co/docs/transformers/v4.36.0/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>.</p></li> <li><p>Pass the training arguments inside <a href="https://huggingface.co/docs/transformers/v4.36.0/en/main_classes/trainer#transformers.Trainer" rel="nofollow">HuggingFace Trainer</a>, along with the model, dataset and image.</p></li> <li><p>Call the <code>train()</code> method and fine-tune your model.</p></li>',ve,Wt,aa="<p>When loading the model from the same checkpoint that you used for the preprocessing, remember to pass the <code>label2id</code> and <code>id2label</code> maps that you created earlier from the dataset’s metadata. Additionally, we specify <code>ignore_mismatched_sizes=True</code> to replace the existing classification head with a new one.</p>",Ne,_t,Ge,Vt,na="Before proceeding further, log in to Hugging Face Hub to upload your model on the fly while training. In this way, you do not need to handle the checkpoints and save them somewhere.",Ee,Rt,We,$t,ia="Once done, let’s start training the model. We start by defining the training arguments and defining a trainer object that uses those arguments to do the training, as shown here:",_e,zt,Ve,Dt,Ma="Once training is finished, you can now delete the model, because checkpoints are already uploaded in HuggingFace Hub.",Re,St,$e,Yt,ze,Xt,Ja="Now we will try to do inference of our new fine-tuned model. For this tutorial, we will be testing for this image:",De,Ht,Ta='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/test_input_for_od.png" alt="input-test-image"/>',Se,Ft,pa="Here we first write a very simple code on doing inference for object detection for some new images. We start of with inferencing for one single image and after that we will club togather everything up and make a function out of it.",Ye,Lt,Xe,qt,oa="Now let’s make a very simple function to plot the results on our image. We get score, label and corresponding bounding boxes co-ordinates from results, which we will we use to draw in the image.",He,Kt,Fe,Pt,wa="And finally use this function for the same test image we used.",Le,Ot,qe,ts,ya="And this will plot the output below:",Ke,ss,ra='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/test_output_for_od.png" alt="output-test-image-plot"/>',Pe,es,ca="Now, let’s club everything together into a simple function.",Oe,ls,tl,as,ja="Let’s even plot multiple images using our inference function on a small test sample.",sl,ns,el,is,ha="Running this function will give us an output like this:",ll,Ms,Ua='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/sample_od_test_set_inference_output.png" alt="test-sample-output-plot"/>',al,Js,Ia='Well, that’s not bad. We can improve the results if we fine-tune further. You can find this fine-tuned checkpoint <a href="hf-vision/detr-resnet-50-dc5-harhat-finetuned">here</a>.',nl,Ts,il,ws,Ml;return I=new h({props:{title:"Vision Transformers for Object Detection",local:"vision-transformers-for-object-detection",headingTag:"h1"}}),d=new h({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),k=new h({props:{title:"The Need to Fine-tune Models in Object Detection 🤔",local:"the-need-to-fine-tune-models-in-object-detection-",headingTag:"h3"}}),N=new h({props:{title:"Installing Necessary Libraries",local:"installing-necessary-libraries",headingTag:"h2"}}),E=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtVSUyMC1xJTIwZGF0YXNldHMlMjB0cmFuc2Zvcm1lcnMlNUJ0b3JjaCU1RCUyMGV2YWx1YXRlJTIwdGltbSUyMGFsYnVtZW50YXRpb25zJTIwYWNjZWxlcmF0ZQ==",highlighted:"!pip install -U -q datasets transformers[torch] evaluate timm albumentations accelerate",wrap:!1}}),W=new h({props:{title:"Scenario",local:"scenario",headingTag:"h2"}}),$=new h({props:{title:"Dataset",local:"dataset",headingTag:"h3"}}),D=new c({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhbmluZHlhNjQlMkZoYXJkaGF0JTIyKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;anindya64/hardhat&quot;</span>)
dataset`,wrap:!1}}),Y=new c({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2ltYWdlJyUyQyUyMCdpbWFnZV9pZCclMkMlMjAnd2lkdGgnJTJDJTIwJ2hlaWdodCclMkMlMjAnb2JqZWN0cyclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDUyOTclMEElMjAlMjAlMjAlMjAlN0QpJTBBJTIwJTIwJTIwJTIwdGVzdCUzQSUyMERhdGFzZXQoJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmVhdHVyZXMlM0ElMjAlNUInaW1hZ2UnJTJDJTIwJ2ltYWdlX2lkJyUyQyUyMCd3aWR0aCclMkMlMjAnaGVpZ2h0JyUyQyUyMCdvYmplY3RzJyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMTc2NiUwQSUyMCUyMCUyMCUyMCU3RCklMEElN0Qp",highlighted:`DatasetDict({
    train: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;width&#x27;</span>, <span class="hljs-string">&#x27;height&#x27;</span>, <span class="hljs-string">&#x27;objects&#x27;</span>],
        num_rows: <span class="hljs-number">5297</span>
    })
    test: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;width&#x27;</span>, <span class="hljs-string">&#x27;height&#x27;</span>, <span class="hljs-string">&#x27;objects&#x27;</span>],
        num_rows: <span class="hljs-number">1766</span>
    })
})`,wrap:!1}}),H=new c({props:{code:"ZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RA==",highlighted:'dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]',wrap:!1}}),L=new c({props:{code:"JTdCJ2ltYWdlJyUzQSUyMCUzQ1BJTC5KcGVnSW1hZ2VQbHVnaW4uSnBlZ0ltYWdlRmlsZSUyMGltYWdlJTIwbW9kZSUzRFJHQiUyMHNpemUlM0Q1MDB4Mzc1JTNFJTJDJTBBJTIwJ2ltYWdlX2lkJyUzQSUyMDElMkMlMEElMjAnd2lkdGgnJTNBJTIwNTAwJTJDJTBBJTIwJ2hlaWdodCclM0ElMjAzNzUlMkMlMEElMjAnb2JqZWN0cyclM0ElMjAlN0InaWQnJTNBJTIwJTVCMSUyQyUyMDElNUQlMkMlMEElMjAlMjAnYXJlYSclM0ElMjAlNUIzMDY4LjAlMkMlMjA2OTAuMCU1RCUyQyUwQSUyMCUyMCdiYm94JyUzQSUyMCU1QiU1QjE3OC4wJTJDJTIwODQuMCUyQyUyMDUyLjAlMkMlMjA1OS4wJTVEJTJDJTIwJTVCMTExLjAlMkMlMjAxNDQuMCUyQyUyMDIzLjAlMkMlMjAzMC4wJTVEJTVEJTJDJTBBJTIwJTIwJ2NhdGVnb3J5JyUzQSUyMCU1QidoZWxtZXQnJTJDJTIwJ2hlbG1ldCclNUQlN0QlN0Q=",highlighted:`{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL<span class="hljs-selector-class">.JpegImagePlugin</span><span class="hljs-selector-class">.JpegImageFile</span> image mode=RGB size=<span class="hljs-number">500</span>x375&gt;,
 <span class="hljs-string">&#x27;image_id&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;width&#x27;</span>: <span class="hljs-number">500</span>,
 <span class="hljs-string">&#x27;height&#x27;</span>: <span class="hljs-number">375</span>,
 <span class="hljs-string">&#x27;objects&#x27;</span>: {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-selector-attr">[1, 1]</span>,
  <span class="hljs-string">&#x27;area&#x27;</span>: <span class="hljs-selector-attr">[3068.0, 690.0]</span>,
  <span class="hljs-string">&#x27;bbox&#x27;</span>: <span class="hljs-selector-attr">[[178.0, 84.0, 52.0, 59.0]</span>, <span class="hljs-selector-attr">[111.0, 144.0, 23.0, 30.0]</span>],
  <span class="hljs-string">&#x27;category&#x27;</span>: <span class="hljs-selector-attr">[<span class="hljs-string">&#x27;helmet&#x27;</span>, <span class="hljs-string">&#x27;helmet&#x27;</span>]</span>}}`,wrap:!1}}),O=new c({props:{code:"JTIzJTIwRmlyc3QlMkMlMjBleHRyYWN0JTIwb3V0JTIwdGhlJTIwdHJhaW4lMjBhbmQlMjB0ZXN0JTIwc2V0JTBBJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCUwQXRlc3RfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVE",highlighted:`<span class="hljs-comment"># First, extract out the train and test set</span>

train_dataset = dataset[<span class="hljs-string">&quot;train&quot;</span>]
test_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]`,wrap:!1}}),lt=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageDraw


<span class="hljs-keyword">def</span> <span class="hljs-title function_">draw_image_from_idx</span>(<span class="hljs-params">dataset, idx</span>):
    sample = dataset[idx]
    image = sample[<span class="hljs-string">&quot;image&quot;</span>]
    annotations = sample[<span class="hljs-string">&quot;objects&quot;</span>]
    draw = ImageDraw.Draw(image)
    width, height = sample[<span class="hljs-string">&quot;width&quot;</span>], sample[<span class="hljs-string">&quot;height&quot;</span>]

    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(annotations[<span class="hljs-string">&quot;id&quot;</span>])):
        box = annotations[<span class="hljs-string">&quot;bbox&quot;</span>][i]
        class_idx = annotations[<span class="hljs-string">&quot;id&quot;</span>][i]
        x, y, w, h = <span class="hljs-built_in">tuple</span>(box)
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">max</span>(box) &gt; <span class="hljs-number">1.0</span>:
            x1, y1 = <span class="hljs-built_in">int</span>(x), <span class="hljs-built_in">int</span>(y)
            x2, y2 = <span class="hljs-built_in">int</span>(x + w), <span class="hljs-built_in">int</span>(y + h)
        <span class="hljs-keyword">else</span>:
            x1 = <span class="hljs-built_in">int</span>(x * width)
            y1 = <span class="hljs-built_in">int</span>(y * height)
            x2 = <span class="hljs-built_in">int</span>((x + w) * width)
            y2 = <span class="hljs-built_in">int</span>((y + h) * height)
        draw.rectangle((x1, y1, x2, y2), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
        draw.text((x1, y1), annotations[<span class="hljs-string">&quot;category&quot;</span>][i], fill=<span class="hljs-string">&quot;white&quot;</span>)
    <span class="hljs-keyword">return</span> image


draw_image_from_idx(dataset=train_dataset, idx=<span class="hljs-number">10</span>)`,wrap:!1}}),nt=new c({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQSUwQWRlZiUyMHBsb3RfaW1hZ2VzKGRhdGFzZXQlMkMlMjBpbmRpY2VzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMFBsb3QlMjBpbWFnZXMlMjBhbmQlMjB0aGVpciUyMGFubm90YXRpb25zLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMG51bV9yb3dzJTIwJTNEJTIwbGVuKGluZGljZXMpJTIwJTJGJTJGJTIwMyUwQSUyMCUyMCUyMCUyMG51bV9jb2xzJTIwJTNEJTIwMyUwQSUyMCUyMCUyMCUyMGZpZyUyQyUyMGF4ZXMlMjAlM0QlMjBwbHQuc3VicGxvdHMobnVtX3Jvd3MlMkMlMjBudW1fY29scyUyQyUyMGZpZ3NpemUlM0QoMTUlMkMlMjAxMCkpJTBBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMGlkeCUyMGluJTIwZW51bWVyYXRlKGluZGljZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93JTIwJTNEJTIwaSUyMCUyRiUyRiUyMG51bV9jb2xzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29sJTIwJTNEJTIwaSUyMCUyNSUyMG51bV9jb2xzJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRHJhdyUyMGltYWdlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBkcmF3X2ltYWdlX2Zyb21faWR4KGRhdGFzZXQlMkMlMjBpZHgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRGlzcGxheSUyMGltYWdlJTIwb24lMjB0aGUlMjBjb3JyZXNwb25kaW5nJTIwc3VicGxvdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF4ZXMlNUJyb3clMkMlMjBjb2wlNUQuaW1zaG93KGltYWdlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF4ZXMlNUJyb3clMkMlMjBjb2wlNUQuYXhpcyglMjJvZmYlMjIpJTBBJTBBJTIwJTIwJTIwJTIwcGx0LnRpZ2h0X2xheW91dCgpJTBBJTIwJTIwJTIwJTIwcGx0LnNob3coKSUwQSUwQSUwQSUyMyUyME5vdyUyMHVzZSUyMHRoZSUyMGZ1bmN0aW9uJTIwdG8lMjBwbG90JTIwaW1hZ2VzJTBBJTBBcGxvdF9pbWFnZXModHJhaW5fZGF0YXNldCUyQyUyMHJhbmdlKDkpKQ==",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_images</span>(<span class="hljs-params">dataset, indices</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Plot images and their annotations.
    &quot;&quot;&quot;</span>
    num_rows = <span class="hljs-built_in">len</span>(indices) // <span class="hljs-number">3</span>
    num_cols = <span class="hljs-number">3</span>
    fig, axes = plt.subplots(num_rows, num_cols, figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">10</span>))

    <span class="hljs-keyword">for</span> i, idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(indices):
        row = i // num_cols
        col = i % num_cols

        <span class="hljs-comment"># Draw image</span>
        image = draw_image_from_idx(dataset, idx)

        <span class="hljs-comment"># Display image on the corresponding subplot</span>
        axes[row, col].imshow(image)
        axes[row, col].axis(<span class="hljs-string">&quot;off&quot;</span>)

    plt.tight_layout()
    plt.show()


<span class="hljs-comment"># Now use the function to plot images</span>

plot_images(train_dataset, <span class="hljs-built_in">range</span>(<span class="hljs-number">9</span>))`,wrap:!1}}),Jt=new h({props:{title:"AutoImageProcessor",local:"autoimageprocessor",headingTag:"h2"}}),ot=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwLWRjNSUyMiUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

checkpoint = <span class="hljs-string">&quot;facebook/detr-resnet-50-dc5&quot;</span>
image_processor = AutoImageProcessor.from_pretrained(checkpoint)`,wrap:!1}}),wt=new h({props:{title:"Preprocessing the Dataset",local:"preprocessing-the-dataset",headingTag:"h2"}}),ct=new c({props:{code:"aW1wb3J0JTIwYWxidW1lbnRhdGlvbnMlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRyYW5zZm9ybSUyMCUzRCUyMGFsYnVtZW50YXRpb25zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxidW1lbnRhdGlvbnMuUmVzaXplKDQ4MCUyQyUyMDQ4MCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbGJ1bWVudGF0aW9ucy5Ib3Jpem9udGFsRmxpcChwJTNEMS4wKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFsYnVtZW50YXRpb25zLlJhbmRvbUJyaWdodG5lc3NDb250cmFzdChwJTNEMS4wKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMGJib3hfcGFyYW1zJTNEYWxidW1lbnRhdGlvbnMuQmJveFBhcmFtcyhmb3JtYXQlM0QlMjJjb2NvJTIyJTJDJTIwbGFiZWxfZmllbGRzJTNEJTVCJTIyY2F0ZWdvcnklMjIlNUQpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> albumentations
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch

transform = albumentations.Compose(
    [
        albumentations.Resize(<span class="hljs-number">480</span>, <span class="hljs-number">480</span>),
        albumentations.HorizontalFlip(p=<span class="hljs-number">1.0</span>),
        albumentations.RandomBrightnessContrast(p=<span class="hljs-number">1.0</span>),
    ],
    bbox_params=albumentations.BboxParams(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;coco&quot;</span>, label_fields=[<span class="hljs-string">&quot;category&quot;</span>]),
)`,wrap:!1}}),Ut=new c({props:{code:"ZGVmJTIwZm9ybWF0dGVkX2FubnMoaW1hZ2VfaWQlMkMlMjBjYXRlZ29yeSUyQyUyMGFyZWElMkMlMjBiYm94KSUzQSUwQSUyMCUyMCUyMCUyMGFubm90YXRpb25zJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihjYXRlZ29yeSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmV3X2FubiUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmltYWdlX2lkJTIyJTNBJTIwaW1hZ2VfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYXRlZ29yeV9pZCUyMiUzQSUyMGNhdGVnb3J5JTVCaSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlzQ3Jvd2QlMjIlM0ElMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJlYSUyMiUzQSUyMGFyZWElNUJpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYmJveCUyMiUzQSUyMGxpc3QoYmJveCU1QmklNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYW5ub3RhdGlvbnMuYXBwZW5kKG5ld19hbm4pJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYW5ub3RhdGlvbnM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatted_anns</span>(<span class="hljs-params">image_id, category, area, bbox</span>):
    annotations = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(category)):
        new_ann = {
            <span class="hljs-string">&quot;image_id&quot;</span>: image_id,
            <span class="hljs-string">&quot;category_id&quot;</span>: category[i],
            <span class="hljs-string">&quot;isCrowd&quot;</span>: <span class="hljs-number">0</span>,
            <span class="hljs-string">&quot;area&quot;</span>: area[i],
            <span class="hljs-string">&quot;bbox&quot;</span>: <span class="hljs-built_in">list</span>(bbox[i]),
        }
        annotations.append(new_ann)

    <span class="hljs-keyword">return</span> annotations`,wrap:!1}}),dt=new c({props:{code:"JTIzJTIwdHJhbnNmb3JtaW5nJTIwYSUyMGJhdGNoJTBBJTBBJTBBZGVmJTIwdHJhbnNmb3JtX2F1Z19hbm4oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfaWRzJTIwJTNEJTIwZXhhbXBsZXMlNUIlMjJpbWFnZV9pZCUyMiU1RCUwQSUyMCUyMCUyMCUyMGltYWdlcyUyQyUyMGJib3hlcyUyQyUyMGFyZWElMkMlMjBjYXRlZ29yaWVzJTIwJTNEJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaW1hZ2UlMkMlMjBvYmplY3RzJTIwaW4lMjB6aXAoZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCUyQyUyMGV4YW1wbGVzJTVCJTIyb2JqZWN0cyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklNUIlM0ElMkMlMjAlM0ElMkMlMjAlM0ElM0EtMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMHRyYW5zZm9ybShpbWFnZSUzRGltYWdlJTJDJTIwYmJveGVzJTNEb2JqZWN0cyU1QiUyMmJib3glMjIlNUQlMkMlMjBjYXRlZ29yeSUzRG9iamVjdHMlNUIlMjJpZCUyMiU1RCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmVhLmFwcGVuZChvYmplY3RzJTVCJTIyYXJlYSUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKG91dCU1QiUyMmltYWdlJTIyJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJib3hlcy5hcHBlbmQob3V0JTVCJTIyYmJveGVzJTIyJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhdGVnb3JpZXMuYXBwZW5kKG91dCU1QiUyMmNhdGVnb3J5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJpbWFnZV9pZCUyMiUzQSUyMGlkXyUyQyUyMCUyMmFubm90YXRpb25zJTIyJTNBJTIwZm9ybWF0dGVkX2FubnMoaWRfJTJDJTIwY2F0XyUyQyUyMGFyXyUyQyUyMGJveF8pJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwaWRfJTJDJTIwY2F0XyUyQyUyMGFyXyUyQyUyMGJveF8lMjBpbiUyMHppcChpbWFnZV9pZHMlMkMlMjBjYXRlZ29yaWVzJTJDJTIwYXJlYSUyQyUyMGJib3hlcyklMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2VzJTJDJTIwYW5ub3RhdGlvbnMlM0R0YXJnZXRzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-comment"># transforming a batch</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_aug_ann</span>(<span class="hljs-params">examples</span>):
    image_ids = examples[<span class="hljs-string">&quot;image_id&quot;</span>]
    images, bboxes, area, categories = [], [], [], []
    <span class="hljs-keyword">for</span> image, objects <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;image&quot;</span>], examples[<span class="hljs-string">&quot;objects&quot;</span>]):
        image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>))[:, :, ::-<span class="hljs-number">1</span>]
        out = transform(image=image, bboxes=objects[<span class="hljs-string">&quot;bbox&quot;</span>], category=objects[<span class="hljs-string">&quot;id&quot;</span>])

        area.append(objects[<span class="hljs-string">&quot;area&quot;</span>])
        images.append(out[<span class="hljs-string">&quot;image&quot;</span>])
        bboxes.append(out[<span class="hljs-string">&quot;bboxes&quot;</span>])
        categories.append(out[<span class="hljs-string">&quot;category&quot;</span>])

    targets = [
        {<span class="hljs-string">&quot;image_id&quot;</span>: id_, <span class="hljs-string">&quot;annotations&quot;</span>: formatted_anns(id_, cat_, ar_, box_)}
        <span class="hljs-keyword">for</span> id_, cat_, ar_, box_ <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(image_ids, categories, area, bboxes)
    ]

    <span class="hljs-keyword">return</span> image_processor(images=images, annotations=targets, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),Ct=new c({props:{code:"JTIzJTIwQXBwbHklMjB0cmFuc2Zvcm1hdGlvbnMlMjBmb3IlMjBib3RoJTIwdHJhaW4lMjBhbmQlMjB0ZXN0JTIwZGF0YXNldCUwQSUwQXRyYWluX2RhdGFzZXRfdHJhbnNmb3JtZWQlMjAlM0QlMjB0cmFpbl9kYXRhc2V0LndpdGhfdHJhbnNmb3JtKHRyYW5zZm9ybV9hdWdfYW5uKSUwQXRlc3RfZGF0YXNldF90cmFuc2Zvcm1lZCUyMCUzRCUyMHRlc3RfZGF0YXNldC53aXRoX3RyYW5zZm9ybSh0cmFuc2Zvcm1fYXVnX2Fubik=",highlighted:`<span class="hljs-comment"># Apply transformations for both train and test dataset</span>

train_dataset_transformed = train_dataset.with_transform(transform_aug_ann)
test_dataset_transformed = test_dataset.with_transform(transform_aug_ann)`,wrap:!1}}),ft=new c({props:{code:"dHJhaW5fZGF0YXNldF90cmFuc2Zvcm1lZCU1QjAlNUQ=",highlighted:'train_dataset_transformed[<span class="hljs-number">0</span>]',wrap:!1}}),At=new c({props:{code:"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",highlighted:`{&#x27;pixel_values&#x27;: tensor([[[<span class="hljs-string">-0</span>.1657, <span class="hljs-string">-0</span>.1657, <span class="hljs-string">-0</span>.1657,  ..., <span class="hljs-string">-0</span>.3369, <span class="hljs-string">-0</span>.4739, <span class="hljs-string">-0</span>.5767],
          [<span class="hljs-string">-0</span>.1657, <span class="hljs-string">-0</span>.1657, <span class="hljs-string">-0</span>.1657,  ..., <span class="hljs-string">-0</span>.3369, <span class="hljs-string">-0</span>.4739, <span class="hljs-string">-0</span>.5767],
          [<span class="hljs-string">-0</span>.1657, <span class="hljs-string">-0</span>.1657, <span class="hljs-string">-0</span>.1828,  ..., <span class="hljs-string">-0</span>.3541, <span class="hljs-string">-0</span>.4911, <span class="hljs-string">-0</span>.5938],
          ...,
          [<span class="hljs-string">-0</span>.4911, <span class="hljs-string">-0</span>.5596, <span class="hljs-string">-0</span>.6623,  ..., <span class="hljs-string">-0</span>.7137, <span class="hljs-string">-0</span>.7650, <span class="hljs-string">-0</span>.7993],
          [<span class="hljs-string">-0</span>.4911, <span class="hljs-string">-0</span>.5596, <span class="hljs-string">-0</span>.6794,  ..., <span class="hljs-string">-0</span>.7308, <span class="hljs-string">-0</span>.7993, <span class="hljs-string">-0</span>.8335],
          [<span class="hljs-string">-0</span>.4911, <span class="hljs-string">-0</span>.5596, <span class="hljs-string">-0</span>.6794,  ..., <span class="hljs-string">-0</span>.7479, <span class="hljs-string">-0</span>.8164, <span class="hljs-string">-0</span>.8507]],
 
         [[<span class="hljs-string">-0</span>.0924, <span class="hljs-string">-0</span>.0924, <span class="hljs-string">-0</span>.0924,  ...,  0.0651, <span class="hljs-string">-0</span>.0749, <span class="hljs-string">-0</span>.1800],
          [<span class="hljs-string">-0</span>.0924, <span class="hljs-string">-0</span>.0924, <span class="hljs-string">-0</span>.0924,  ...,  0.0651, <span class="hljs-string">-0</span>.0924, <span class="hljs-string">-0</span>.2150],
          [<span class="hljs-string">-0</span>.0924, <span class="hljs-string">-0</span>.0924, <span class="hljs-string">-0</span>.1099,  ...,  0.0476, <span class="hljs-string">-0</span>.1275, <span class="hljs-string">-0</span>.2500],
          ...,
          [<span class="hljs-string">-0</span>.0924, <span class="hljs-string">-0</span>.1800, <span class="hljs-string">-0</span>.3200,  ..., <span class="hljs-string">-0</span>.4426, <span class="hljs-string">-0</span>.4951, <span class="hljs-string">-0</span>.5301],
          [<span class="hljs-string">-0</span>.0924, <span class="hljs-string">-0</span>.1800, <span class="hljs-string">-0</span>.3200,  ..., <span class="hljs-string">-0</span>.4601, <span class="hljs-string">-0</span>.5126, <span class="hljs-string">-0</span>.5651],
          [<span class="hljs-string">-0</span>.0924, <span class="hljs-string">-0</span>.1800, <span class="hljs-string">-0</span>.3200,  ..., <span class="hljs-string">-0</span>.4601, <span class="hljs-string">-0</span>.5301, <span class="hljs-string">-0</span>.5826]],
 
         [[ 0.1999,  0.1999,  0.1999,  ...,  0.6705,  0.5136,  0.4091],
          [ 0.1999,  0.1999,  0.1999,  ...,  0.6531,  0.4962,  0.3916],
          [ 0.1999,  0.1999,  0.1825,  ...,  0.6356,  0.4614,  0.3568],
          ...,
          [ 0.4788,  0.3916,  0.2696,  ...,  0.1825,  0.1302,  0.0953],
          [ 0.4788,  0.3916,  0.2696,  ...,  0.1651,  0.0953,  0.0605],
          [ 0.4788,  0.3916,  0.2696,  ...,  0.1476,  0.0779,  0.0431]]]),
 &#x27;pixel_mask&#x27;: tensor([[1, 1, 1,  ..., 1, 1, 1],
         [1, 1, 1,  ..., 1, 1, 1],
         [1, 1, 1,  ..., 1, 1, 1],
         ...,
         [1, 1, 1,  ..., 1, 1, 1],
         [1, 1, 1,  ..., 1, 1, 1],
         [1, 1, 1,  ..., 1, 1, 1]]),
 &#x27;labels&#x27;: {&#x27;size&#x27;: tensor([800, 800]), &#x27;image_id&#x27;: tensor([1]), &#x27;class_labels&#x27;: tensor([1, 1]), &#x27;boxes&#x27;: tensor([[0.5920, 0.3027, 0.1040, 0.1573],
         [0.7550, 0.4240, 0.0460, 0.0800]]), &#x27;area&#x27;: tensor([8522.2217, 1916.6666]), &#x27;iscrowd&#x27;: tensor([0, 0]), &#x27;orig_size&#x27;: tensor([480, 480])}}`,wrap:!1}}),Zt=new c({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBwaXhlbF92YWx1ZXMlMjAlM0QlMjAlNUJpdGVtJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBlbmNvZGluZyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wYWQocGl4ZWxfdmFsdWVzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjAlNUJpdGVtJTVCJTIybGFiZWxzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwZW5jb2RpbmclNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnBpeGVsX21hc2slMjIlNUQlMjAlM0QlMjBlbmNvZGluZyU1QiUyMnBpeGVsX21hc2slMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNo",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">batch</span>):
    pixel_values = [item[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
    encoding = image_processor.pad(pixel_values, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = [item[<span class="hljs-string">&quot;labels&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
    batch = {}
    batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_values&quot;</span>]
    batch[<span class="hljs-string">&quot;pixel_mask&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_mask&quot;</span>]
    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels
    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),vt=new h({props:{title:"Training a DETR Model.",local:"training-a-detr-model",headingTag:"h2"}}),_t=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQSUwQWlkMmxhYmVsJTIwJTNEJTIwJTdCMCUzQSUyMCUyMmhlYWQlMjIlMkMlMjAxJTNBJTIwJTIyaGVsbWV0JTIyJTJDJTIwMiUzQSUyMCUyMnBlcnNvbiUyMiU3RCUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCdiUzQSUyMGslMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaWQybGFiZWwuaXRlbXMoKSU3RCUwQSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBjaGVja3BvaW50JTJDJTBBJTIwJTIwJTIwJTIwaWQybGFiZWwlM0RpZDJsYWJlbCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsMmlkJTNEbGFiZWwyaWQlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForObjectDetection

id2label = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;head&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;helmet&quot;</span>, <span class="hljs-number">2</span>: <span class="hljs-string">&quot;person&quot;</span>}
label2id = {v: k <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}


model = AutoModelForObjectDetection.from_pretrained(
    checkpoint,
    id2label=id2label,
    label2id=label2id,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Rt=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),zt=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEElMjMlMjBEZWZpbmUlMjB0aGUlMjB0cmFpbmluZyUyMGFyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyZGV0ci1yZXNuZXQtNTAtaGFyZGhhdC1maW5ldHVuZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDMlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMWUtNSUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9kZWNheSUzRDFlLTQlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3RvdGFsX2xpbWl0JTNEMiUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKSUwQSUwQSUyMyUyMERlZmluZSUyMHRoZSUyMHRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0ZV9mbiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0X3RyYW5zZm9ybWVkJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdGVzdF9kYXRhc2V0X3RyYW5zZm9ybWVkJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEaW1hZ2VfcHJvY2Vzc29yJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-comment"># Define the training arguments</span>

training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;detr-resnet-50-hardhat-finetuned&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">8</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    max_steps=<span class="hljs-number">1000</span>,
    fp16=<span class="hljs-literal">True</span>,
    save_steps=<span class="hljs-number">10</span>,
    logging_steps=<span class="hljs-number">30</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    weight_decay=<span class="hljs-number">1e-4</span>,
    save_total_limit=<span class="hljs-number">2</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># Define the trainer</span>

trainer = Trainer(
    model=model,
    args=training_args,
    data_collator=collate_fn,
    train_dataset=train_dataset_transformed,
    eval_dataset=test_dataset_transformed,
    tokenizer=image_processor,
)

trainer.train()`,wrap:!1}}),St=new c({props:{code:"ZGVsJTIwbW9kZWwlMEF0b3JjaC5jdWRhLnN5bmNocm9uaXplKCk=",highlighted:`<span class="hljs-keyword">del</span> model
torch.cuda.synchronize()`,wrap:!1}}),Yt=new h({props:{title:"Testing and Inference",local:"testing-and-inference",headingTag:"h3"}}),Lt=new c({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEElMjMlMjBkb3dubG9hZCUyMGElMjBzYW1wbGUlMjBpbWFnZSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLXZpc2lvbiUyRmNvdXJzZS1hc3NldHMlMkZyZXNvbHZlJTJGbWFpbiUyRnRlc3QtaGVsbWV0LW9iamVjdC1kZXRlY3Rpb24uanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBJTIzJTIwbWFrZSUyMHRoZSUyMG9iamVjdCUyMGRldGVjdGlvbiUyMHBpcGVsaW5lJTBBJTBBb2JqX2RldGVjdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyb2JqZWN0LWRldGVjdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyYW5pbmR5YTY0JTJGZGV0ci1yZXNuZXQtNTAtZGM1LWhhcmRoYXQtZmluZXR1bmVkJTIyJTBBKSUwQXJlc3VsdHMlMjAlM0QlMjBvYmpfZGV0ZWN0b3IodHJhaW5fZGF0YXNldCU1QjAlNUQlNUIlMjJpbWFnZSUyMiU1RCklMEElMEFwcmludChyZXN1bHRzKQ==",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># download a sample image</span>

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/test-helmet-object-detection.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># make the object detection pipeline</span>

obj_detector = pipeline(
    <span class="hljs-string">&quot;object-detection&quot;</span>, model=<span class="hljs-string">&quot;anindya64/detr-resnet-50-dc5-hardhat-finetuned&quot;</span>
)
results = obj_detector(train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>])

<span class="hljs-built_in">print</span>(results)`,wrap:!1}}),Kt=new c({props:{code:"ZGVmJTIwcGxvdF9yZXN1bHRzKGltYWdlJTJDJTIwcmVzdWx0cyUyQyUyMHRocmVzaG9sZCUzRDAuNyklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShucC51aW50OChpbWFnZSkpJTBBJTIwJTIwJTIwJTIwZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlKSUwQSUyMCUyMCUyMCUyMGZvciUyMHJlc3VsdCUyMGluJTIwcmVzdWx0cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3JlJTIwJTNEJTIwcmVzdWx0JTVCJTIyc2NvcmUlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbCUyMCUzRCUyMHJlc3VsdCU1QiUyMmxhYmVsJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm94JTIwJTNEJTIwbGlzdChyZXN1bHQlNUIlMjJib3glMjIlNUQudmFsdWVzKCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzY29yZSUyMCUzRSUyMHRocmVzaG9sZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMkMlMjB5JTJDJTIweDIlMkMlMjB5MiUyMCUzRCUyMHR1cGxlKGJveCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeCUyQyUyMHklMkMlMjB4MiUyQyUyMHkyKSUyQyUyMG91dGxpbmUlM0QlMjJyZWQlMjIlMkMlMjB3aWR0aCUzRDEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHJhdy50ZXh0KCh4JTJDJTIweSklMkMlMjBsYWJlbCUyQyUyMGZpbGwlM0QlMjJ3aGl0ZSUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkcmF3LnRleHQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKHglMjAlMkIlMjAwLjUlMkMlMjB5JTIwLSUyMDAuNSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZXh0JTNEc3RyKHNjb3JlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbGwlM0QlMjJncmVlbiUyMiUyMGlmJTIwc2NvcmUlMjAlM0UlMjAwLjclMjBlbHNlJTIwJTIycmVkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltYWdl",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_results</span>(<span class="hljs-params">image, results, threshold=<span class="hljs-number">0.7</span></span>):
    image = Image.fromarray(np.uint8(image))
    draw = ImageDraw.Draw(image)
    <span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> results:
        score = result[<span class="hljs-string">&quot;score&quot;</span>]
        label = result[<span class="hljs-string">&quot;label&quot;</span>]
        box = <span class="hljs-built_in">list</span>(result[<span class="hljs-string">&quot;box&quot;</span>].values())
        <span class="hljs-keyword">if</span> score &gt; threshold:
            x, y, x2, y2 = <span class="hljs-built_in">tuple</span>(box)
            draw.rectangle((x, y, x2, y2), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
            draw.text((x, y), label, fill=<span class="hljs-string">&quot;white&quot;</span>)
            draw.text(
                (x + <span class="hljs-number">0.5</span>, y - <span class="hljs-number">0.5</span>),
                text=<span class="hljs-built_in">str</span>(score),
                fill=<span class="hljs-string">&quot;green&quot;</span> <span class="hljs-keyword">if</span> score &gt; <span class="hljs-number">0.7</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;red&quot;</span>,
            )
    <span class="hljs-keyword">return</span> image`,wrap:!1}}),Ot=new c({props:{code:"cmVzdWx0cyUyMCUzRCUyMG9ial9kZXRlY3RvcihpbWFnZSklMEFwbG90X3Jlc3VsdHMoaW1hZ2UlMkMlMjByZXN1bHRzKQ==",highlighted:`results = obj<span class="hljs-constructor">_detector(<span class="hljs-params">image</span>)</span>
plot<span class="hljs-constructor">_results(<span class="hljs-params">image</span>, <span class="hljs-params">results</span>)</span>`,wrap:!1}}),ls=new c({props:{code:"ZGVmJTIwcHJlZGljdChpbWFnZSUyQyUyMHBpcGVsaW5lJTJDJTIwdGhyZXNob2xkJTNEMC43KSUzQSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwaXBlbGluZShpbWFnZSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBwbG90X3Jlc3VsdHMoaW1hZ2UlMkMlMjByZXN1bHRzJTJDJTIwdGhyZXNob2xkKSUwQSUwQSUwQSUyMyUyMExldCdzJTIwdGVzdCUyMGZvciUyMGFub3RoZXIlMjB0ZXN0JTIwaW1hZ2UlMEElMEFpbWclMjAlM0QlMjB0ZXN0X2RhdGFzZXQlNUIwJTVEJTVCJTIyaW1hZ2UlMjIlNUQlMEFwcmVkaWN0KGltZyUyQyUyMG9ial9kZXRlY3Rvcik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">predict</span>(<span class="hljs-params">image, pipeline, threshold=<span class="hljs-number">0.7</span></span>):
    results = pipeline(image)
    <span class="hljs-keyword">return</span> plot_results(image, results, threshold)


<span class="hljs-comment"># Let&#x27;s test for another test image</span>

img = test_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]
predict(img, obj_detector)`,wrap:!1}}),ns=new c({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEElMEFkZWYlMjBwbG90X2ltYWdlcyhkYXRhc2V0JTJDJTIwaW5kaWNlcyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBQbG90JTIwaW1hZ2VzJTIwYW5kJTIwdGhlaXIlMjBhbm5vdGF0aW9ucy4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBudW1fcm93cyUyMCUzRCUyMGxlbihpbmRpY2VzKSUyMCUyRiUyRiUyMDMlMEElMjAlMjAlMjAlMjBudW1fY29scyUyMCUzRCUyMDMlMEElMjAlMjAlMjAlMjBmaWclMkMlMjBheGVzJTIwJTNEJTIwcGx0LnN1YnBsb3RzKG51bV9yb3dzJTJDJTIwbnVtX2NvbHMlMkMlMjBmaWdzaXplJTNEKDE1JTJDJTIwMTApKSUwQSUwQSUyMCUyMCUyMCUyMGZvciUyMGklMkMlMjBpZHglMjBpbiUyMHRxZG0oZW51bWVyYXRlKGluZGljZXMpJTJDJTIwdG90YWwlM0RsZW4oaW5kaWNlcykpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93JTIwJTNEJTIwaSUyMCUyRiUyRiUyMG51bV9jb2xzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29sJTIwJTNEJTIwaSUyMCUyNSUyMG51bV9jb2xzJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRHJhdyUyMGltYWdlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBwcmVkaWN0KGRhdGFzZXQlNUJpZHglNUQlNUIlMjJpbWFnZSUyMiU1RCUyQyUyMG9ial9kZXRlY3RvciklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBEaXNwbGF5JTIwaW1hZ2UlMjBvbiUyMHRoZSUyMGNvcnJlc3BvbmRpbmclMjBzdWJwbG90JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXhlcyU1QnJvdyUyQyUyMGNvbCU1RC5pbXNob3coaW1hZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXhlcyU1QnJvdyUyQyUyMGNvbCU1RC5heGlzKCUyMm9mZiUyMiklMEElMEElMjAlMjAlMjAlMjBwbHQudGlnaHRfbGF5b3V0KCklMEElMjAlMjAlMjAlMjBwbHQuc2hvdygpJTBBJTBBJTBBcGxvdF9pbWFnZXModGVzdF9kYXRhc2V0JTJDJTIwcmFuZ2UoNikp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm


<span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_images</span>(<span class="hljs-params">dataset, indices</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Plot images and their annotations.
    &quot;&quot;&quot;</span>
    num_rows = <span class="hljs-built_in">len</span>(indices) // <span class="hljs-number">3</span>
    num_cols = <span class="hljs-number">3</span>
    fig, axes = plt.subplots(num_rows, num_cols, figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">10</span>))

    <span class="hljs-keyword">for</span> i, idx <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(indices), total=<span class="hljs-built_in">len</span>(indices)):
        row = i // num_cols
        col = i % num_cols

        <span class="hljs-comment"># Draw image</span>
        image = predict(dataset[idx][<span class="hljs-string">&quot;image&quot;</span>], obj_detector)

        <span class="hljs-comment"># Display image on the corresponding subplot</span>
        axes[row, col].imshow(image)
        axes[row, col].axis(<span class="hljs-string">&quot;off&quot;</span>)

    plt.tight_layout()
    plt.show()


plot_images(test_dataset, <span class="hljs-built_in">range</span>(<span class="hljs-number">6</span>))`,wrap:!1}}),Ts=new ka({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit3/vision-transformers/vision-transformer-for-object-detection.mdx"}}),{c(){U=i("meta"),ys=a(),os=i("p"),rs=a(),T(I.$$.fragment),cs=a(),m=i("p"),m.textContent=Tl,js=a(),j=i("iframe"),j.innerHTML=pl,hs=a(),T(d.$$.fragment),Us=a(),u=i("p"),u.innerHTML=wl,Is=a(),C=i("p"),C.textContent=yl,ms=a(),b=i("ul"),b.innerHTML=rl,ds=a(),f=i("p"),f.textContent=cl,us=a(),g=i("ul"),g.innerHTML=jl,Cs=a(),A=i("p"),A.textContent=hl,bs=a(),x=i("p"),x.innerHTML=Ul,fs=a(),T(k.$$.fragment),gs=a(),B=i("p"),B.textContent=Il,As=a(),Q=i("ul"),Q.innerHTML=ml,xs=a(),Z=i("p"),Z.textContent=dl,ks=a(),v=i("p"),v.textContent=ul,Bs=a(),T(N.$$.fragment),Qs=a(),G=i("p"),G.textContent=Cl,Zs=a(),T(E.$$.fragment),vs=a(),T(W.$$.fragment),Ns=a(),_=i("p"),_.textContent=bl,Gs=a(),V=i("p"),V.textContent=fl,Es=a(),R=i("p"),R.textContent=gl,Ws=a(),T($.$$.fragment),_s=a(),z=i("p"),z.innerHTML=Al,Vs=a(),T(D.$$.fragment),Rs=a(),S=i("p"),S.textContent=xl,$s=a(),T(Y.$$.fragment),zs=a(),X=i("p"),X.innerHTML=kl,Ds=a(),T(H.$$.fragment),Ss=a(),F=i("p"),F.textContent=Bl,Ys=a(),T(L.$$.fragment),Xs=a(),q=i("p"),q.innerHTML=Ql,Hs=a(),K=i("ul"),K.innerHTML=Zl,Fs=a(),P=i("p"),P.textContent=vl,Ls=a(),T(O.$$.fragment),qs=a(),tt=i("p"),tt.textContent=Nl,Ks=a(),st=i("p"),st.textContent=Gl,Ps=a(),et=i("ol"),et.innerHTML=El,Os=a(),T(lt.$$.fragment),te=a(),at=i("p"),at.textContent=Wl,se=a(),T(nt.$$.fragment),ee=a(),it=i("p"),it.textContent=_l,le=a(),Mt=i("p"),Mt.innerHTML=Vl,ae=a(),T(Jt.$$.fragment),ne=a(),Tt=i("p"),Tt.innerHTML=Rl,ie=a(),pt=i("p"),pt.textContent=$l,Me=a(),T(ot.$$.fragment),Je=a(),T(wt.$$.fragment),Te=a(),yt=i("p"),yt.innerHTML=zl,pe=a(),rt=i("p"),rt.innerHTML=Dl,oe=a(),T(ct.$$.fragment),we=a(),jt=i("p"),jt.textContent=Sl,ye=a(),ht=i("p"),ht.innerHTML=Yl,re=a(),T(Ut.$$.fragment),ce=a(),It=i("p"),It.textContent=Xl,je=a(),mt=i("p"),mt.textContent=Hl,he=a(),T(dt.$$.fragment),Ue=a(),ut=i("p"),ut.innerHTML=Fl,Ie=a(),T(Ct.$$.fragment),me=a(),bt=i("p"),bt.textContent=Ll,de=a(),T(ft.$$.fragment),ue=a(),gt=i("p"),gt.innerHTML=ql,Ce=a(),T(At.$$.fragment),be=a(),xt=i("p"),xt.innerHTML=Kl,fe=a(),kt=i("p"),kt.innerHTML=Pl,ge=a(),Bt=i("p"),Bt.innerHTML=Ol,Ae=a(),Qt=i("p"),Qt.textContent=ta,xe=a(),T(Zt.$$.fragment),ke=a(),T(vt.$$.fragment),Be=a(),Nt=i("p"),Nt.textContent=sa,Qe=a(),Gt=i("p"),Gt.textContent=ea,Ze=a(),Et=i("ol"),Et.innerHTML=la,ve=a(),Wt=i("blockquote"),Wt.innerHTML=aa,Ne=a(),T(_t.$$.fragment),Ge=a(),Vt=i("p"),Vt.textContent=na,Ee=a(),T(Rt.$$.fragment),We=a(),$t=i("p"),$t.textContent=ia,_e=a(),T(zt.$$.fragment),Ve=a(),Dt=i("p"),Dt.textContent=Ma,Re=a(),T(St.$$.fragment),$e=a(),T(Yt.$$.fragment),ze=a(),Xt=i("p"),Xt.textContent=Ja,De=a(),Ht=i("p"),Ht.innerHTML=Ta,Se=a(),Ft=i("p"),Ft.textContent=pa,Ye=a(),T(Lt.$$.fragment),Xe=a(),qt=i("p"),qt.textContent=oa,He=a(),T(Kt.$$.fragment),Fe=a(),Pt=i("p"),Pt.textContent=wa,Le=a(),T(Ot.$$.fragment),qe=a(),ts=i("p"),ts.textContent=ya,Ke=a(),ss=i("p"),ss.innerHTML=ra,Pe=a(),es=i("p"),es.textContent=ca,Oe=a(),T(ls.$$.fragment),tl=a(),as=i("p"),as.textContent=ja,sl=a(),T(ns.$$.fragment),el=a(),is=i("p"),is.textContent=ha,ll=a(),Ms=i("p"),Ms.innerHTML=Ua,al=a(),Js=i("p"),Js.innerHTML=Ia,nl=a(),T(Ts.$$.fragment),il=a(),ws=i("p"),this.h()},l(t){const s=Aa("svelte-u9bgzb",document.head);U=M(s,"META",{name:!0,content:!0}),s.forEach(e),ys=n(t),os=M(t,"P",{}),ma(os).forEach(e),rs=n(t),p(I.$$.fragment,t),cs=n(t),m=M(t,"P",{"data-svelte-h":!0}),J(m)!=="svelte-15dhdw5"&&(m.textContent=Tl),js=n(t),j=M(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0,"data-svelte-h":!0}),J(j)!=="svelte-1p9bvqf"&&(j.innerHTML=pl),hs=n(t),p(d.$$.fragment,t),Us=n(t),u=M(t,"P",{"data-svelte-h":!0}),J(u)!=="svelte-aa9z0u"&&(u.innerHTML=wl),Is=n(t),C=M(t,"P",{"data-svelte-h":!0}),J(C)!=="svelte-10m4gga"&&(C.textContent=yl),ms=n(t),b=M(t,"UL",{"data-svelte-h":!0}),J(b)!=="svelte-1o1k6a3"&&(b.innerHTML=rl),ds=n(t),f=M(t,"P",{"data-svelte-h":!0}),J(f)!=="svelte-oxii5x"&&(f.textContent=cl),us=n(t),g=M(t,"UL",{"data-svelte-h":!0}),J(g)!=="svelte-6e5g71"&&(g.innerHTML=jl),Cs=n(t),A=M(t,"P",{"data-svelte-h":!0}),J(A)!=="svelte-5ajfex"&&(A.textContent=hl),bs=n(t),x=M(t,"P",{"data-svelte-h":!0}),J(x)!=="svelte-6q3o6d"&&(x.innerHTML=Ul),fs=n(t),p(k.$$.fragment,t),gs=n(t),B=M(t,"P",{"data-svelte-h":!0}),J(B)!=="svelte-198v66f"&&(B.textContent=Il),As=n(t),Q=M(t,"UL",{"data-svelte-h":!0}),J(Q)!=="svelte-1adaz66"&&(Q.innerHTML=ml),xs=n(t),Z=M(t,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-1j8qsbc"&&(Z.textContent=dl),ks=n(t),v=M(t,"P",{"data-svelte-h":!0}),J(v)!=="svelte-19ukb67"&&(v.textContent=ul),Bs=n(t),p(N.$$.fragment,t),Qs=n(t),G=M(t,"P",{"data-svelte-h":!0}),J(G)!=="svelte-1tpfle4"&&(G.textContent=Cl),Zs=n(t),p(E.$$.fragment,t),vs=n(t),p(W.$$.fragment,t),Ns=n(t),_=M(t,"P",{"data-svelte-h":!0}),J(_)!=="svelte-1xq7r5r"&&(_.textContent=bl),Gs=n(t),V=M(t,"P",{"data-svelte-h":!0}),J(V)!=="svelte-1asbpjs"&&(V.textContent=fl),Es=n(t),R=M(t,"P",{"data-svelte-h":!0}),J(R)!=="svelte-1683r2r"&&(R.textContent=gl),Ws=n(t),p($.$$.fragment,t),_s=n(t),z=M(t,"P",{"data-svelte-h":!0}),J(z)!=="svelte-xbzkhu"&&(z.innerHTML=Al),Vs=n(t),p(D.$$.fragment,t),Rs=n(t),S=M(t,"P",{"data-svelte-h":!0}),J(S)!=="svelte-1mt80st"&&(S.textContent=xl),$s=n(t),p(Y.$$.fragment,t),zs=n(t),X=M(t,"P",{"data-svelte-h":!0}),J(X)!=="svelte-o7bok4"&&(X.innerHTML=kl),Ds=n(t),p(H.$$.fragment,t),Ss=n(t),F=M(t,"P",{"data-svelte-h":!0}),J(F)!=="svelte-1ya21ae"&&(F.textContent=Bl),Ys=n(t),p(L.$$.fragment,t),Xs=n(t),q=M(t,"P",{"data-svelte-h":!0}),J(q)!=="svelte-1pk421n"&&(q.innerHTML=Ql),Hs=n(t),K=M(t,"UL",{"data-svelte-h":!0}),J(K)!=="svelte-14h640o"&&(K.innerHTML=Zl),Fs=n(t),P=M(t,"P",{"data-svelte-h":!0}),J(P)!=="svelte-1pz85mg"&&(P.textContent=vl),Ls=n(t),p(O.$$.fragment,t),qs=n(t),tt=M(t,"P",{"data-svelte-h":!0}),J(tt)!=="svelte-ur08kl"&&(tt.textContent=Nl),Ks=n(t),st=M(t,"P",{"data-svelte-h":!0}),J(st)!=="svelte-1kqgi0s"&&(st.textContent=Gl),Ps=n(t),et=M(t,"OL",{"data-svelte-h":!0}),J(et)!=="svelte-1vwsin9"&&(et.innerHTML=El),Os=n(t),p(lt.$$.fragment,t),te=n(t),at=M(t,"P",{"data-svelte-h":!0}),J(at)!=="svelte-77gtk2"&&(at.textContent=Wl),se=n(t),p(nt.$$.fragment,t),ee=n(t),it=M(t,"P",{"data-svelte-h":!0}),J(it)!=="svelte-1mpnw7k"&&(it.textContent=_l),le=n(t),Mt=M(t,"P",{"data-svelte-h":!0}),J(Mt)!=="svelte-aiscvm"&&(Mt.innerHTML=Vl),ae=n(t),p(Jt.$$.fragment,t),ne=n(t),Tt=M(t,"P",{"data-svelte-h":!0}),J(Tt)!=="svelte-ghzkm6"&&(Tt.innerHTML=Rl),ie=n(t),pt=M(t,"P",{"data-svelte-h":!0}),J(pt)!=="svelte-1bqm6il"&&(pt.textContent=$l),Me=n(t),p(ot.$$.fragment,t),Je=n(t),p(wt.$$.fragment,t),Te=n(t),yt=M(t,"P",{"data-svelte-h":!0}),J(yt)!=="svelte-1l5ud0l"&&(yt.innerHTML=zl),pe=n(t),rt=M(t,"P",{"data-svelte-h":!0}),J(rt)!=="svelte-1vfdkki"&&(rt.innerHTML=Dl),oe=n(t),p(ct.$$.fragment,t),we=n(t),jt=M(t,"P",{"data-svelte-h":!0}),J(jt)!=="svelte-1g89o79"&&(jt.textContent=Sl),ye=n(t),ht=M(t,"P",{"data-svelte-h":!0}),J(ht)!=="svelte-159z74z"&&(ht.innerHTML=Yl),re=n(t),p(Ut.$$.fragment,t),ce=n(t),It=M(t,"P",{"data-svelte-h":!0}),J(It)!=="svelte-hcsld3"&&(It.textContent=Xl),je=n(t),mt=M(t,"P",{"data-svelte-h":!0}),J(mt)!=="svelte-1u11l6s"&&(mt.textContent=Hl),he=n(t),p(dt.$$.fragment,t),Ue=n(t),ut=M(t,"P",{"data-svelte-h":!0}),J(ut)!=="svelte-19t5jac"&&(ut.innerHTML=Fl),Ie=n(t),p(Ct.$$.fragment,t),me=n(t),bt=M(t,"P",{"data-svelte-h":!0}),J(bt)!=="svelte-h5c757"&&(bt.textContent=Ll),de=n(t),p(ft.$$.fragment,t),ue=n(t),gt=M(t,"P",{"data-svelte-h":!0}),J(gt)!=="svelte-1nnj6p"&&(gt.innerHTML=ql),Ce=n(t),p(At.$$.fragment,t),be=n(t),xt=M(t,"P",{"data-svelte-h":!0}),J(xt)!=="svelte-1ysztb0"&&(xt.innerHTML=Kl),fe=n(t),kt=M(t,"P",{"data-svelte-h":!0}),J(kt)!=="svelte-wggj3"&&(kt.innerHTML=Pl),ge=n(t),Bt=M(t,"P",{"data-svelte-h":!0}),J(Bt)!=="svelte-1531qbg"&&(Bt.innerHTML=Ol),Ae=n(t),Qt=M(t,"P",{"data-svelte-h":!0}),J(Qt)!=="svelte-188g5sw"&&(Qt.textContent=ta),xe=n(t),p(Zt.$$.fragment,t),ke=n(t),p(vt.$$.fragment,t),Be=n(t),Nt=M(t,"P",{"data-svelte-h":!0}),J(Nt)!=="svelte-3iuhuy"&&(Nt.textContent=sa),Qe=n(t),Gt=M(t,"P",{"data-svelte-h":!0}),J(Gt)!=="svelte-1dzo43p"&&(Gt.textContent=ea),Ze=n(t),Et=M(t,"OL",{"data-svelte-h":!0}),J(Et)!=="svelte-1x6e77e"&&(Et.innerHTML=la),ve=n(t),Wt=M(t,"BLOCKQUOTE",{"data-svelte-h":!0}),J(Wt)!=="svelte-ynp8j"&&(Wt.innerHTML=aa),Ne=n(t),p(_t.$$.fragment,t),Ge=n(t),Vt=M(t,"P",{"data-svelte-h":!0}),J(Vt)!=="svelte-jx1t09"&&(Vt.textContent=na),Ee=n(t),p(Rt.$$.fragment,t),We=n(t),$t=M(t,"P",{"data-svelte-h":!0}),J($t)!=="svelte-1bm2kwe"&&($t.textContent=ia),_e=n(t),p(zt.$$.fragment,t),Ve=n(t),Dt=M(t,"P",{"data-svelte-h":!0}),J(Dt)!=="svelte-7155iq"&&(Dt.textContent=Ma),Re=n(t),p(St.$$.fragment,t),$e=n(t),p(Yt.$$.fragment,t),ze=n(t),Xt=M(t,"P",{"data-svelte-h":!0}),J(Xt)!=="svelte-1o9ugp9"&&(Xt.textContent=Ja),De=n(t),Ht=M(t,"P",{"data-svelte-h":!0}),J(Ht)!=="svelte-1iu0era"&&(Ht.innerHTML=Ta),Se=n(t),Ft=M(t,"P",{"data-svelte-h":!0}),J(Ft)!=="svelte-1t3yfbb"&&(Ft.textContent=pa),Ye=n(t),p(Lt.$$.fragment,t),Xe=n(t),qt=M(t,"P",{"data-svelte-h":!0}),J(qt)!=="svelte-sctx0w"&&(qt.textContent=oa),He=n(t),p(Kt.$$.fragment,t),Fe=n(t),Pt=M(t,"P",{"data-svelte-h":!0}),J(Pt)!=="svelte-1yo8179"&&(Pt.textContent=wa),Le=n(t),p(Ot.$$.fragment,t),qe=n(t),ts=M(t,"P",{"data-svelte-h":!0}),J(ts)!=="svelte-ghmkjf"&&(ts.textContent=ya),Ke=n(t),ss=M(t,"P",{"data-svelte-h":!0}),J(ss)!=="svelte-a20gxg"&&(ss.innerHTML=ra),Pe=n(t),es=M(t,"P",{"data-svelte-h":!0}),J(es)!=="svelte-1x3qijx"&&(es.textContent=ca),Oe=n(t),p(ls.$$.fragment,t),tl=n(t),as=M(t,"P",{"data-svelte-h":!0}),J(as)!=="svelte-uuqhws"&&(as.textContent=ja),sl=n(t),p(ns.$$.fragment,t),el=n(t),is=M(t,"P",{"data-svelte-h":!0}),J(is)!=="svelte-1ssmt63"&&(is.textContent=ha),ll=n(t),Ms=M(t,"P",{"data-svelte-h":!0}),J(Ms)!=="svelte-4pe1pb"&&(Ms.innerHTML=Ua),al=n(t),Js=M(t,"P",{"data-svelte-h":!0}),J(Js)!=="svelte-1ev1hiq"&&(Js.innerHTML=Ia),nl=n(t),p(Ts.$$.fragment,t),il=n(t),ws=M(t,"P",{}),ma(ws).forEach(e),this.h()},h(){ps(U,"name","hf:doc:metadata"),ps(U,"content",Qa),ua(j.src,ol="https://hf-vision-finetuning-demo-for-object-detection.hf.space/")||ps(j,"src",ol),ps(j,"frameborder","0"),ps(j,"width","850"),ps(j,"height","450")},m(t,s){xa(document.head,U),l(t,ys,s),l(t,os,s),l(t,rs,s),o(I,t,s),l(t,cs,s),l(t,m,s),l(t,js,s),l(t,j,s),l(t,hs,s),o(d,t,s),l(t,Us,s),l(t,u,s),l(t,Is,s),l(t,C,s),l(t,ms,s),l(t,b,s),l(t,ds,s),l(t,f,s),l(t,us,s),l(t,g,s),l(t,Cs,s),l(t,A,s),l(t,bs,s),l(t,x,s),l(t,fs,s),o(k,t,s),l(t,gs,s),l(t,B,s),l(t,As,s),l(t,Q,s),l(t,xs,s),l(t,Z,s),l(t,ks,s),l(t,v,s),l(t,Bs,s),o(N,t,s),l(t,Qs,s),l(t,G,s),l(t,Zs,s),o(E,t,s),l(t,vs,s),o(W,t,s),l(t,Ns,s),l(t,_,s),l(t,Gs,s),l(t,V,s),l(t,Es,s),l(t,R,s),l(t,Ws,s),o($,t,s),l(t,_s,s),l(t,z,s),l(t,Vs,s),o(D,t,s),l(t,Rs,s),l(t,S,s),l(t,$s,s),o(Y,t,s),l(t,zs,s),l(t,X,s),l(t,Ds,s),o(H,t,s),l(t,Ss,s),l(t,F,s),l(t,Ys,s),o(L,t,s),l(t,Xs,s),l(t,q,s),l(t,Hs,s),l(t,K,s),l(t,Fs,s),l(t,P,s),l(t,Ls,s),o(O,t,s),l(t,qs,s),l(t,tt,s),l(t,Ks,s),l(t,st,s),l(t,Ps,s),l(t,et,s),l(t,Os,s),o(lt,t,s),l(t,te,s),l(t,at,s),l(t,se,s),o(nt,t,s),l(t,ee,s),l(t,it,s),l(t,le,s),l(t,Mt,s),l(t,ae,s),o(Jt,t,s),l(t,ne,s),l(t,Tt,s),l(t,ie,s),l(t,pt,s),l(t,Me,s),o(ot,t,s),l(t,Je,s),o(wt,t,s),l(t,Te,s),l(t,yt,s),l(t,pe,s),l(t,rt,s),l(t,oe,s),o(ct,t,s),l(t,we,s),l(t,jt,s),l(t,ye,s),l(t,ht,s),l(t,re,s),o(Ut,t,s),l(t,ce,s),l(t,It,s),l(t,je,s),l(t,mt,s),l(t,he,s),o(dt,t,s),l(t,Ue,s),l(t,ut,s),l(t,Ie,s),o(Ct,t,s),l(t,me,s),l(t,bt,s),l(t,de,s),o(ft,t,s),l(t,ue,s),l(t,gt,s),l(t,Ce,s),o(At,t,s),l(t,be,s),l(t,xt,s),l(t,fe,s),l(t,kt,s),l(t,ge,s),l(t,Bt,s),l(t,Ae,s),l(t,Qt,s),l(t,xe,s),o(Zt,t,s),l(t,ke,s),o(vt,t,s),l(t,Be,s),l(t,Nt,s),l(t,Qe,s),l(t,Gt,s),l(t,Ze,s),l(t,Et,s),l(t,ve,s),l(t,Wt,s),l(t,Ne,s),o(_t,t,s),l(t,Ge,s),l(t,Vt,s),l(t,Ee,s),o(Rt,t,s),l(t,We,s),l(t,$t,s),l(t,_e,s),o(zt,t,s),l(t,Ve,s),l(t,Dt,s),l(t,Re,s),o(St,t,s),l(t,$e,s),o(Yt,t,s),l(t,ze,s),l(t,Xt,s),l(t,De,s),l(t,Ht,s),l(t,Se,s),l(t,Ft,s),l(t,Ye,s),o(Lt,t,s),l(t,Xe,s),l(t,qt,s),l(t,He,s),o(Kt,t,s),l(t,Fe,s),l(t,Pt,s),l(t,Le,s),o(Ot,t,s),l(t,qe,s),l(t,ts,s),l(t,Ke,s),l(t,ss,s),l(t,Pe,s),l(t,es,s),l(t,Oe,s),o(ls,t,s),l(t,tl,s),l(t,as,s),l(t,sl,s),o(ns,t,s),l(t,el,s),l(t,is,s),l(t,ll,s),l(t,Ms,s),l(t,al,s),l(t,Js,s),l(t,nl,s),o(Ts,t,s),l(t,il,s),l(t,ws,s),Ml=!0},p:Ca,i(t){Ml||(w(I.$$.fragment,t),w(d.$$.fragment,t),w(k.$$.fragment,t),w(N.$$.fragment,t),w(E.$$.fragment,t),w(W.$$.fragment,t),w($.$$.fragment,t),w(D.$$.fragment,t),w(Y.$$.fragment,t),w(H.$$.fragment,t),w(L.$$.fragment,t),w(O.$$.fragment,t),w(lt.$$.fragment,t),w(nt.$$.fragment,t),w(Jt.$$.fragment,t),w(ot.$$.fragment,t),w(wt.$$.fragment,t),w(ct.$$.fragment,t),w(Ut.$$.fragment,t),w(dt.$$.fragment,t),w(Ct.$$.fragment,t),w(ft.$$.fragment,t),w(At.$$.fragment,t),w(Zt.$$.fragment,t),w(vt.$$.fragment,t),w(_t.$$.fragment,t),w(Rt.$$.fragment,t),w(zt.$$.fragment,t),w(St.$$.fragment,t),w(Yt.$$.fragment,t),w(Lt.$$.fragment,t),w(Kt.$$.fragment,t),w(Ot.$$.fragment,t),w(ls.$$.fragment,t),w(ns.$$.fragment,t),w(Ts.$$.fragment,t),Ml=!0)},o(t){y(I.$$.fragment,t),y(d.$$.fragment,t),y(k.$$.fragment,t),y(N.$$.fragment,t),y(E.$$.fragment,t),y(W.$$.fragment,t),y($.$$.fragment,t),y(D.$$.fragment,t),y(Y.$$.fragment,t),y(H.$$.fragment,t),y(L.$$.fragment,t),y(O.$$.fragment,t),y(lt.$$.fragment,t),y(nt.$$.fragment,t),y(Jt.$$.fragment,t),y(ot.$$.fragment,t),y(wt.$$.fragment,t),y(ct.$$.fragment,t),y(Ut.$$.fragment,t),y(dt.$$.fragment,t),y(Ct.$$.fragment,t),y(ft.$$.fragment,t),y(At.$$.fragment,t),y(Zt.$$.fragment,t),y(vt.$$.fragment,t),y(_t.$$.fragment,t),y(Rt.$$.fragment,t),y(zt.$$.fragment,t),y(St.$$.fragment,t),y(Yt.$$.fragment,t),y(Lt.$$.fragment,t),y(Kt.$$.fragment,t),y(Ot.$$.fragment,t),y(ls.$$.fragment,t),y(ns.$$.fragment,t),y(Ts.$$.fragment,t),Ml=!1},d(t){t&&(e(ys),e(os),e(rs),e(cs),e(m),e(js),e(j),e(hs),e(Us),e(u),e(Is),e(C),e(ms),e(b),e(ds),e(f),e(us),e(g),e(Cs),e(A),e(bs),e(x),e(fs),e(gs),e(B),e(As),e(Q),e(xs),e(Z),e(ks),e(v),e(Bs),e(Qs),e(G),e(Zs),e(vs),e(Ns),e(_),e(Gs),e(V),e(Es),e(R),e(Ws),e(_s),e(z),e(Vs),e(Rs),e(S),e($s),e(zs),e(X),e(Ds),e(Ss),e(F),e(Ys),e(Xs),e(q),e(Hs),e(K),e(Fs),e(P),e(Ls),e(qs),e(tt),e(Ks),e(st),e(Ps),e(et),e(Os),e(te),e(at),e(se),e(ee),e(it),e(le),e(Mt),e(ae),e(ne),e(Tt),e(ie),e(pt),e(Me),e(Je),e(Te),e(yt),e(pe),e(rt),e(oe),e(we),e(jt),e(ye),e(ht),e(re),e(ce),e(It),e(je),e(mt),e(he),e(Ue),e(ut),e(Ie),e(me),e(bt),e(de),e(ue),e(gt),e(Ce),e(be),e(xt),e(fe),e(kt),e(ge),e(Bt),e(Ae),e(Qt),e(xe),e(ke),e(Be),e(Nt),e(Qe),e(Gt),e(Ze),e(Et),e(ve),e(Wt),e(Ne),e(Ge),e(Vt),e(Ee),e(We),e($t),e(_e),e(Ve),e(Dt),e(Re),e($e),e(ze),e(Xt),e(De),e(Ht),e(Se),e(Ft),e(Ye),e(Xe),e(qt),e(He),e(Fe),e(Pt),e(Le),e(qe),e(ts),e(Ke),e(ss),e(Pe),e(es),e(Oe),e(tl),e(as),e(sl),e(el),e(is),e(ll),e(Ms),e(al),e(Js),e(nl),e(il),e(ws)),e(U),r(I,t),r(d,t),r(k,t),r(N,t),r(E,t),r(W,t),r($,t),r(D,t),r(Y,t),r(H,t),r(L,t),r(O,t),r(lt,t),r(nt,t),r(Jt,t),r(ot,t),r(wt,t),r(ct,t),r(Ut,t),r(dt,t),r(Ct,t),r(ft,t),r(At,t),r(Zt,t),r(vt,t),r(_t,t),r(Rt,t),r(zt,t),r(St,t),r(Yt,t),r(Lt,t),r(Kt,t),r(Ot,t),r(ls,t),r(ns,t),r(Ts,t)}}}const Qa='{"title":"Vision Transformers for Object Detection","local":"vision-transformers-for-object-detection","sections":[{"title":"Introduction","local":"introduction","sections":[{"title":"The Need to Fine-tune Models in Object Detection 🤔","local":"the-need-to-fine-tune-models-in-object-detection-","sections":[],"depth":3}],"depth":2},{"title":"Installing Necessary Libraries","local":"installing-necessary-libraries","sections":[],"depth":2},{"title":"Scenario","local":"scenario","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":3}],"depth":2},{"title":"AutoImageProcessor","local":"autoimageprocessor","sections":[],"depth":2},{"title":"Preprocessing the Dataset","local":"preprocessing-the-dataset","sections":[],"depth":2},{"title":"Training a DETR Model.","local":"training-a-detr-model","sections":[{"title":"Testing and Inference","local":"testing-and-inference","sections":[],"depth":3}],"depth":2}],"depth":1}';function Za(Jl){return ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wa extends fa{constructor(U){super(),ga(this,U,Za,Ba,da,{})}}export{Wa as component};
