import{s as ra,o as la,n as Ie}from"../chunks/scheduler.25b97de1.js";import{S as ia,i as ca,g as m,s as o,r as h,A as da,h as p,f as n,c as r,j as S,u,x as y,k,y as c,a as l,v as f,d as g,t as T,w as _}from"../chunks/index.d9030fc9.js";import{D as Z}from"../chunks/Docstring.e257edda.js";import{C as Ve}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Re}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as G,E as ma}from"../chunks/EditOnGithub.91d95064.js";function pa(w){let s,v;return s=new Ve({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGFuJTIwUGF0Y2hUU1QlMjBjb25maWd1cmF0aW9uJTIwd2l0aCUyMDEyJTIwdGltZSUyMHN0ZXBzJTIwZm9yJTIwcHJlZGljdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBQYXRjaFRTVENvbmZpZyhwcmVkaWN0aW9uX2xlbmd0aCUzRDEyKSUwQSUwQSUyMyUyMFJhbmRvbWx5JTIwaW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing an PatchTST configuration with 12 time steps for prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PatchTSTConfig(prediction_length=<span class="hljs-number">12</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Randomly initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){h(s.$$.fragment)},l(d){u(s.$$.fragment,d)},m(d,i){f(s,d,i),v=!0},p:Ie,i(d){v||(g(s.$$.fragment,d),v=!0)},o(d){T(s.$$.fragment,d),v=!1},d(d){_(s,d)}}}function ha(w){let s,v="Examples:",d,i,b;return i=new Ve({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUTW9kZWwlMEElMEFmaWxlJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZXR0aDEtaG91cmx5LWJhdGNoJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJ0cmFpbi1iYXRjaC5wdCUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMEEpJTBBYmF0Y2glMjAlM0QlMjB0b3JjaC5sb2FkKGZpbGUpJTBBJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJuYW1jdGluJTJGcGF0Y2h0c3RfZXR0aDFfcHJldHJhaW4lMjIpJTBBJTBBJTIzJTIwZHVyaW5nJTIwdHJhaW5pbmclMkMlMjBvbmUlMjBwcm92aWRlcyUyMGJvdGglMjBwYXN0JTIwYW5kJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCUwQSUyMCUyMCUyMCUyMHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGZ1dHVyZV92YWx1ZXMlM0RiYXRjaCU1QiUyMmZ1dHVyZV92YWx1ZXMlMjIlNUQlMkMlMEEpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGUlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTModel

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTModel.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_pretrain&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>],
<span class="hljs-meta">... </span>    future_values=batch[<span class="hljs-string">&quot;future_values&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state`,wrap:!1}}),{c(){s=m("p"),s.textContent=v,d=o(),h(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=v),d=r(t),u(i.$$.fragment,t)},m(t,M){l(t,s,M),l(t,d,M),f(i,t,M),b=!0},p:Ie,i(t){b||(g(i.$$.fragment,t),b=!0)},o(t){T(i.$$.fragment,t),b=!1},d(t){t&&(n(s),n(d)),_(i,t)}}}function ua(w){let s,v="Examples:",d,i,b;return i=new Ve({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JQcmVkaWN0aW9uJTBBJTBBZmlsZSUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmV0dGgxLWhvdXJseS1iYXRjaCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIydHJhaW4tYmF0Y2gucHQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTBBKSUwQWJhdGNoJTIwJTNEJTIwdG9yY2gubG9hZChmaWxlKSUwQSUwQSUyMyUyMFByZWRpY3Rpb24lMjB0YXNrJTIwd2l0aCUyMDclMjBpbnB1dCUyMGNoYW5uZWxzJTIwYW5kJTIwcHJlZGljdGlvbiUyMGxlbmd0aCUyMGlzJTIwOTYlMEFtb2RlbCUyMCUzRCUyMFBhdGNoVFNURm9yUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybmFtY3RpbiUyRnBhdGNodHN0X2V0dGgxX2ZvcmVjYXN0JTIyKSUwQSUwQSUyMyUyMGR1cmluZyUyMHRyYWluaW5nJTJDJTIwb25lJTIwcHJvdmlkZXMlMjBib3RoJTIwcGFzdCUyMGFuZCUyMGZ1dHVyZSUyMHZhbHVlcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCglMEElMjAlMjAlMjAlMjBwYXN0X3ZhbHVlcyUzRGJhdGNoJTVCJTIycGFzdF92YWx1ZXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBmdXR1cmVfdmFsdWVzJTNEYmF0Y2glNUIlMjJmdXR1cmVfdmFsdWVzJTIyJTVEJTJDJTBBKSUwQSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb3NzLmJhY2t3YXJkKCklMEElMEElMjMlMjBkdXJpbmclMjBpbmZlcmVuY2UlMkMlMjBvbmUlMjBvbmx5JTIwcHJvdmlkZXMlMjBwYXN0JTIwdmFsdWVzJTJDJTIwdGhlJTIwbW9kZWwlMjBvdXRwdXRzJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCklMEFwcmVkaWN0aW9uX291dHB1dHMlMjAlM0QlMjBvdXRwdXRzLnByZWRpY3Rpb25fb3V0cHV0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForPrediction

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prediction task with 7 input channels and prediction length is 96</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForPrediction.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_forecast&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>],
<span class="hljs-meta">... </span>    future_values=batch[<span class="hljs-string">&quot;future_values&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values, the model outputs future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction_outputs = outputs.prediction_outputs`,wrap:!1}}),{c(){s=m("p"),s.textContent=v,d=o(),h(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=v),d=r(t),u(i.$$.fragment,t)},m(t,M){l(t,s,M),l(t,d,M),f(i,t,M),b=!0},p:Ie,i(t){b||(g(i.$$.fragment,t),b=!0)},o(t){T(i.$$.fragment,t),b=!1},d(t){t&&(n(s),n(d)),_(i,t)}}}function fa(w){let s,v="Examples:",d,i,b;return i=new Ve({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMGNsYXNzaWZpY2F0aW9uJTIwdGFzayUyMHdpdGglMjB0d28lMjBpbnB1dCUyMGNoYW5uZWwyJTIwYW5kJTIwMyUyMGNsYXNzZXMlMEFjb25maWclMjAlM0QlMjBQYXRjaFRTVENvbmZpZyglMEElMjAlMjAlMjAlMjBudW1faW5wdXRfY2hhbm5lbHMlM0QyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RhcmdldHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF9sZW5ndGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBwYXRjaF9sZW5ndGglM0QxMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmlkZSUzRDEyJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2Nsc190b2tlbiUzRFRydWUlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVEZvckNsYXNzaWZpY2F0aW9uKGNvbmZpZyUzRGNvbmZpZyklMEElMEElMjMlMjBkdXJpbmclMjBpbmZlcmVuY2UlMkMlMjBvbmUlMjBvbmx5JTIwcHJvdmlkZXMlMjBwYXN0JTIwdmFsdWVzJTBBcGFzdF92YWx1ZXMlMjAlM0QlMjB0b3JjaC5yYW5kbigyMCUyQyUyMDUxMiUyQyUyMDIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEcGFzdF92YWx1ZXMpJTBBbGFiZWxzJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0aW9uX2xvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># classification task with two input channel2 and 3 classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    num_targets=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForClassification(config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_values = torch.randn(<span class="hljs-number">20</span>, <span class="hljs-number">512</span>, <span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=past_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = outputs.prediction_logits`,wrap:!1}}),{c(){s=m("p"),s.textContent=v,d=o(),h(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=v),d=r(t),u(i.$$.fragment,t)},m(t,M){l(t,s,M),l(t,d,M),f(i,t,M),b=!0},p:Ie,i(t){b||(g(i.$$.fragment,t),b=!0)},o(t){T(i.$$.fragment,t),b=!1},d(t){t&&(n(s),n(d)),_(i,t)}}}function ga(w){let s,v="Examples:",d,i,b;return i=new Ve({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JQcmV0cmFpbmluZyUwQSUwQWZpbGUlMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZldHRoMS1ob3VybHktYmF0Y2glMjIlMkMlMjBmaWxlbmFtZSUzRCUyMnRyYWluLWJhdGNoLnB0JTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUwQSklMEFiYXRjaCUyMCUzRCUyMHRvcmNoLmxvYWQoZmlsZSklMEElMEElMjMlMjBDb25maWclMjBmb3IlMjByYW5kb20lMjBtYXNrJTIwcHJldHJhaW5pbmclMEFjb25maWclMjAlM0QlMjBQYXRjaFRTVENvbmZpZyglMEElMjAlMjAlMjAlMjBudW1faW5wdXRfY2hhbm5lbHMlM0Q3JTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF9sZW5ndGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBwYXRjaF9sZW5ndGglM0QxMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmlkZSUzRDEyJTJDJTBBJTIwJTIwJTIwJTIwbWFza190eXBlJTNEJ3JhbmRvbSclMkMlMEElMjAlMjAlMjAlMjByYW5kb21fbWFza19yYXRpbyUzRDAuNCUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jbHNfdG9rZW4lM0RUcnVlJTJDJTBBKSUwQSUyMyUyMENvbmZpZyUyMGZvciUyMGZvcmVjYXN0JTIwbWFzayUyMHByZXRyYWluaW5nJTBBY29uZmlnJTIwJTNEJTIwUGF0Y2hUU1RDb25maWcoJTBBJTIwJTIwJTIwJTIwbnVtX2lucHV0X2NoYW5uZWxzJTNENyUyQyUwQSUyMCUyMCUyMCUyMGNvbnRleHRfbGVuZ3RoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwcGF0Y2hfbGVuZ3RoJTNEMTIlMkMlMEElMjAlMjAlMjAlMjBzdHJpZGUlM0QxMiUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfdHlwZSUzRCdmb3JlY2FzdCclMkMlMEElMjAlMjAlMjAlMjBudW1fZm9yZWNhc3RfbWFza19wYXRjaGVzJTNENSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jbHNfdG9rZW4lM0RUcnVlJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwUGF0Y2hUU1RGb3JQcmV0cmFpbmluZyhjb25maWcpJTBBJTBBJTIzJTIwZHVyaW5nJTIwdHJhaW5pbmclMkMlMjBvbmUlMjBwcm92aWRlcyUyMGJvdGglMjBwYXN0JTIwYW5kJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCklMEElMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9zcy5iYWNrd2FyZCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForPretraining

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Config for random mask pretraining</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">7</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    mask_type=<span class="hljs-string">&#x27;random&#x27;</span>,
<span class="hljs-meta">... </span>    random_mask_ratio=<span class="hljs-number">0.4</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Config for forecast mask pretraining</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">7</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    mask_type=<span class="hljs-string">&#x27;forecast&#x27;</span>,
<span class="hljs-meta">... </span>    num_forecast_mask_patches=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForPretraining(config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()`,wrap:!1}}),{c(){s=m("p"),s.textContent=v,d=o(),h(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=v),d=r(t),u(i.$$.fragment,t)},m(t,M){l(t,s,M),l(t,d,M),f(i,t,M),b=!0},p:Ie,i(t){b||(g(i.$$.fragment,t),b=!0)},o(t){T(i.$$.fragment,t),b=!1},d(t){t&&(n(s),n(d)),_(i,t)}}}function Ta(w){let s,v="Examples:",d,i,b;return i=new Ve({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JSZWdyZXNzaW9uJTBBJTBBJTIzJTIwUmVncmVzc2lvbiUyMHRhc2slMjB3aXRoJTIwNiUyMGlucHV0JTIwY2hhbm5lbHMlMjBhbmQlMjByZWdyZXNzJTIwMiUyMHRhcmdldHMlMEFtb2RlbCUyMCUzRCUyMFBhdGNoVFNURm9yUmVncmVzc2lvbi5mcm9tX3ByZXRyYWluZWQoJTIybmFtY3RpbiUyRnBhdGNodHN0X2V0dGgxX3JlZ3Jlc3Npb24lMjIpJTBBJTBBJTIzJTIwZHVyaW5nJTIwaW5mZXJlbmNlJTJDJTIwb25lJTIwb25seSUyMHByb3ZpZGVzJTIwcGFzdCUyMHZhbHVlcyUyQyUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0cyUyMGZ1dHVyZSUyMHZhbHVlcyUwQXBhc3RfdmFsdWVzJTIwJTNEJTIwdG9yY2gucmFuZG4oMjAlMkMlMjA1MTIlMkMlMjA2KSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChwYXN0X3ZhbHVlcyUzRHBhc3RfdmFsdWVzKSUwQXJlZ3Jlc3Npb25fb3V0cHV0cyUyMCUzRCUyMG91dHB1dHMucmVncmVzc2lvbl9vdXRwdXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForRegression

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Regression task with 6 input channels and regress 2 targets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForRegression.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_regression&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values, the model outputs future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_values = torch.randn(<span class="hljs-number">20</span>, <span class="hljs-number">512</span>, <span class="hljs-number">6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=past_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>regression_outputs = outputs.regression_outputs`,wrap:!1}}),{c(){s=m("p"),s.textContent=v,d=o(),h(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=v),d=r(t),u(i.$$.fragment,t)},m(t,M){l(t,s,M),l(t,d,M),f(i,t,M),b=!0},p:Ie,i(t){b||(g(i.$$.fragment,t),b=!0)},o(t){T(i.$$.fragment,t),b=!1},d(t){t&&(n(s),n(d)),_(i,t)}}}function _a(w){let s,v,d,i,b,t,M,ze,A,It='The PatchTST model was proposed in <a href="https://arxiv.org/abs/2211.14730" rel="nofollow">A Time Series is Worth 64 Words: Long-term Forecasting with Transformers</a> by Yuqi Nie, Nam H. Nguyen, Phanwadee Sinthong and Jayant Kalagnanam.',Ye,O,Vt="At a high level the model vectorizes time series into patches of a given size and encodes the resulting sequence of vectors via a Transformer that then outputs the prediction length forecast via an appropriate head. The model is illustrated in the following figure:",Xe,K,Ht='<img src="https://github.com/namctin/transformers/assets/8100/150af169-29de-419a-8d98-eb78251c21fa" alt="model"/>',Ee,ee,zt="The abstract from the paper is the following:",qe,te,Yt="<em>We propose an efficient design of Transformer-based models for multivariate time series forecasting and self-supervised representation learning. It is based on two key components: (i) segmentation of time series into subseries-level patches which are served as input tokens to Transformer; (ii) channel-independence where each channel contains a single univariate time series that shares the same embedding and Transformer weights across all the series. Patching design naturally has three-fold benefit: local semantic information is retained in the embedding; computation and memory usage of the attention maps are quadratically reduced given the same look-back window; and the model can attend longer history. Our channel-independent patch time series Transformer (PatchTST) can improve the long-term forecasting accuracy significantly when compared with that of SOTA Transformer-based models. We also apply our model to self-supervised pre-training tasks and attain excellent fine-tuning performance, which outperforms supervised training on large datasets. Transferring of masked pre-trained representation on one dataset to others also produces SOTA forecasting accuracy.</em>",Qe,ae,Xt='This model was contributed by <a href="https://huggingface.co/namctin" rel="nofollow">namctin</a>, <a href="https://huggingface.co/gsinthong" rel="nofollow">gsinthong</a>, <a href="https://huggingface.co/diepi" rel="nofollow">diepi</a>, <a href="https://huggingface.co/vijaye12" rel="nofollow">vijaye12</a>, <a href="https://huggingface.co/wmgifford" rel="nofollow">wmgifford</a>, and <a href="https://huggingface.co/kashif" rel="nofollow">kashif</a>. The original code can be found <a href="https://github.com/yuqinie98/PatchTST" rel="nofollow">here</a>.',De,ne,Le,se,Et='The model can also be used for time series classification and time series regression. See the respective <a href="/docs/transformers/pr_30799/en/model_doc/patchtst#transformers.PatchTSTForClassification">PatchTSTForClassification</a> and <a href="/docs/transformers/pr_30799/en/model_doc/patchtst#transformers.PatchTSTForRegression">PatchTSTForRegression</a> classes.',Ae,oe,Oe,re,qt='<li>A blog post explaining PatchTST in depth can be found <a href="https://huggingface.co/blog/patchtst" rel="nofollow">here</a>. The blog can also be opened in Google Colab.</li>',Ke,le,et,j,ie,Tt,Ue,Qt=`This is the configuration class to store the configuration of an <a href="/docs/transformers/pr_30799/en/model_doc/patchtst#transformers.PatchTSTModel">PatchTSTModel</a>. It is used to instantiate an
PatchTST model according to the specified arguments, defining the model architecture.
<a href="https://huggingface.co/ibm/patchtst" rel="nofollow">ibm/patchtst</a> architecture.`,_t,Pe,Dt=`Configuration objects inherit from <a href="/docs/transformers/pr_30799/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30799/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,bt,N,tt,ce,at,$,de,Mt,Ce,Lt=`The bare PatchTST Model outputting raw hidden-states without any specific head.
This model inherits from <a href="/docs/transformers/pr_30799/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,yt,Se,At=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,vt,R,me,wt,I,nt,pe,st,J,he,jt,ke,Ot=`The PatchTST for prediction model.
This model inherits from <a href="/docs/transformers/pr_30799/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,$t,xe,Kt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Jt,V,ue,Ut,H,ot,fe,rt,U,ge,Pt,Fe,ea=`The PatchTST for classification model.
This model inherits from <a href="/docs/transformers/pr_30799/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ct,Be,ta=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,St,z,Te,kt,Y,lt,_e,it,P,be,xt,We,aa=`The PatchTST for pretrain model.
This model inherits from <a href="/docs/transformers/pr_30799/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ft,Ze,na=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Bt,X,Me,Wt,E,ct,ye,dt,C,ve,Zt,Ge,sa=`The PatchTST for regression model.
This model inherits from <a href="/docs/transformers/pr_30799/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Gt,Ne,oa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Nt,q,we,Rt,Q,mt,je,pt,He,ht;return b=new G({props:{title:"PatchTST",local:"patchtst",headingTag:"h1"}}),M=new G({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ne=new G({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),oe=new G({props:{title:"Resources",local:"resources",headingTag:"h2"}}),le=new G({props:{title:"PatchTSTConfig",local:"transformers.PatchTSTConfig",headingTag:"h2"}}),ie=new Z({props:{name:"class transformers.PatchTSTConfig",anchor:"transformers.PatchTSTConfig",parameters:[{name:"num_input_channels",val:": int = 1"},{name:"context_length",val:": int = 32"},{name:"distribution_output",val:": str = 'student_t'"},{name:"loss",val:": str = 'mse'"},{name:"patch_length",val:": int = 1"},{name:"patch_stride",val:": int = 1"},{name:"num_hidden_layers",val:": int = 3"},{name:"d_model",val:": int = 128"},{name:"num_attention_heads",val:": int = 4"},{name:"share_embedding",val:": bool = True"},{name:"channel_attention",val:": bool = False"},{name:"ffn_dim",val:": int = 512"},{name:"norm_type",val:": str = 'batchnorm'"},{name:"norm_eps",val:": float = 1e-05"},{name:"attention_dropout",val:": float = 0.0"},{name:"positional_dropout",val:": float = 0.0"},{name:"path_dropout",val:": float = 0.0"},{name:"ff_dropout",val:": float = 0.0"},{name:"bias",val:": bool = True"},{name:"activation_function",val:": str = 'gelu'"},{name:"pre_norm",val:": bool = True"},{name:"positional_encoding_type",val:": str = 'sincos'"},{name:"use_cls_token",val:": bool = False"},{name:"init_std",val:": float = 0.02"},{name:"share_projection",val:": bool = True"},{name:"scaling",val:": Union = 'std'"},{name:"do_mask_input",val:": Optional = None"},{name:"mask_type",val:": str = 'random'"},{name:"random_mask_ratio",val:": float = 0.5"},{name:"num_forecast_mask_patches",val:": Union = [2]"},{name:"channel_consistent_masking",val:": Optional = False"},{name:"unmasked_channel_indices",val:": Optional = None"},{name:"mask_value",val:": int = 0"},{name:"pooling_type",val:": str = 'mean'"},{name:"head_dropout",val:": float = 0.0"},{name:"prediction_length",val:": int = 24"},{name:"num_targets",val:": int = 1"},{name:"output_range",val:": Optional = None"},{name:"num_parallel_samples",val:": int = 100"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PatchTSTConfig.num_input_channels",description:`<strong>num_input_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size of the target variable which by default is 1 for univariate targets. Would be &gt; 1 in case of
multivariate targets.`,name:"num_input_channels"},{anchor:"transformers.PatchTSTConfig.context_length",description:`<strong>context_length</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The context length of the input sequence.`,name:"context_length"},{anchor:"transformers.PatchTSTConfig.distribution_output",description:`<strong>distribution_output</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;student_t&quot;</code>) &#x2014;
The distribution emission head for the model when loss is &#x201C;nll&#x201D;. Could be either &#x201C;student_t&#x201D;, &#x201C;normal&#x201D; or
&#x201C;negative_binomial&#x201D;.`,name:"distribution_output"},{anchor:"transformers.PatchTSTConfig.loss",description:`<strong>loss</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;mse&quot;</code>) &#x2014;
The loss function for the model corresponding to the <code>distribution_output</code> head. For parametric
distributions it is the negative log likelihood (&#x201C;nll&#x201D;) and for point estimates it is the mean squared
error &#x201C;mse&#x201D;.`,name:"loss"},{anchor:"transformers.PatchTSTConfig.patch_length",description:`<strong>patch_length</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Define the patch length of the patchification process.`,name:"patch_length"},{anchor:"transformers.PatchTSTConfig.patch_stride",description:`<strong>patch_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Define the stride of the patchification process.`,name:"patch_stride"},{anchor:"transformers.PatchTSTConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of hidden layers.`,name:"num_hidden_layers"},{anchor:"transformers.PatchTSTConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Dimensionality of the transformer layers.`,name:"d_model"},{anchor:"transformers.PatchTSTConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.PatchTSTConfig.share_embedding",description:`<strong>share_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Sharing the input embedding across all channels.`,name:"share_embedding"},{anchor:"transformers.PatchTSTConfig.channel_attention",description:`<strong>channel_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activate channel attention block in the Transformer to allow channels to attend each other.`,name:"channel_attention"},{anchor:"transformers.PatchTSTConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"ffn_dim"},{anchor:"transformers.PatchTSTConfig.norm_type",description:`<strong>norm_type</strong> (<code>str</code> , <em>optional</em>, defaults to <code>&quot;batchnorm&quot;</code>) &#x2014;
Normalization at each Transformer layer. Can be <code>&quot;batchnorm&quot;</code> or <code>&quot;layernorm&quot;</code>.`,name:"norm_type"},{anchor:"transformers.PatchTSTConfig.norm_eps",description:`<strong>norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
A value added to the denominator for numerical stability of normalization.`,name:"norm_eps"},{anchor:"transformers.PatchTSTConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.PatchTSTConfig.positional_dropout",description:`<strong>positional_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability in the positional embedding layer.`,name:"positional_dropout"},{anchor:"transformers.PatchTSTConfig.path_dropout",description:`<strong>path_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout path in the residual block.`,name:"path_dropout"},{anchor:"transformers.PatchTSTConfig.ff_dropout",description:`<strong>ff_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability used between the two layers of the feed-forward networks.`,name:"ff_dropout"},{anchor:"transformers.PatchTSTConfig.bias",description:`<strong>bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add bias in the feed-forward networks.`,name:"bias"},{anchor:"transformers.PatchTSTConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (string) in the Transformer.<code>&quot;gelu&quot;</code> and <code>&quot;relu&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.PatchTSTConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Normalization is applied before self-attention if pre_norm is set to <code>True</code>. Otherwise, normalization is
applied after residual block.`,name:"pre_norm"},{anchor:"transformers.PatchTSTConfig.positional_encoding_type",description:`<strong>positional_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sincos&quot;</code>) &#x2014;
Positional encodings. Options <code>&quot;random&quot;</code> and <code>&quot;sincos&quot;</code> are supported.`,name:"positional_encoding_type"},{anchor:"transformers.PatchTSTConfig.use_cls_token",description:`<strong>use_cls_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether cls token is used.`,name:"use_cls_token"},{anchor:"transformers.PatchTSTConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated normal weight initialization distribution.`,name:"init_std"},{anchor:"transformers.PatchTSTConfig.share_projection",description:`<strong>share_projection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Sharing the projection layer across different channels in the forecast head.`,name:"share_projection"},{anchor:"transformers.PatchTSTConfig.scaling",description:`<strong>scaling</strong> (<code>Union</code>, <em>optional</em>, defaults to <code>&quot;std&quot;</code>) &#x2014;
Whether to scale the input targets via &#x201C;mean&#x201D; scaler, &#x201C;std&#x201D; scaler or no scaler if <code>None</code>. If <code>True</code>, the
scaler is set to &#x201C;mean&#x201D;.`,name:"scaling"},{anchor:"transformers.PatchTSTConfig.do_mask_input",description:`<strong>do_mask_input</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Apply masking during the pretraining.`,name:"do_mask_input"},{anchor:"transformers.PatchTSTConfig.mask_type",description:`<strong>mask_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;random&quot;</code>) &#x2014;
Masking type. Only <code>&quot;random&quot;</code> and <code>&quot;forecast&quot;</code> are currently supported.`,name:"mask_type"},{anchor:"transformers.PatchTSTConfig.random_mask_ratio",description:`<strong>random_mask_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Masking ratio applied to mask the input data during random pretraining.`,name:"random_mask_ratio"},{anchor:"transformers.PatchTSTConfig.num_forecast_mask_patches",description:`<strong>num_forecast_mask_patches</strong> (<code>int</code> or <code>list</code>, <em>optional</em>, defaults to <code>[2]</code>) &#x2014;
Number of patches to be masked at the end of each batch sample. If it is an integer,
all the samples in the batch will have the same number of masked patches. If it is a list,
samples in the batch will be randomly masked by numbers defined in the list. This argument is only used
for forecast pretraining.`,name:"num_forecast_mask_patches"},{anchor:"transformers.PatchTSTConfig.channel_consistent_masking",description:`<strong>channel_consistent_masking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If channel consistent masking is True, all the channels will have the same masking pattern.`,name:"channel_consistent_masking"},{anchor:"transformers.PatchTSTConfig.unmasked_channel_indices",description:`<strong>unmasked_channel_indices</strong> (<code>list</code>, <em>optional</em>) &#x2014;
Indices of channels that are not masked during pretraining. Values in the list are number between 1 and
<code>num_input_channels</code>`,name:"unmasked_channel_indices"},{anchor:"transformers.PatchTSTConfig.mask_value",description:`<strong>mask_value</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Values in the masked patches will be filled by <code>mask_value</code>.`,name:"mask_value"},{anchor:"transformers.PatchTSTConfig.pooling_type",description:`<strong>pooling_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;mean&quot;</code>) &#x2014;
Pooling of the embedding. <code>&quot;mean&quot;</code>, <code>&quot;max&quot;</code> and <code>None</code> are supported.`,name:"pooling_type"},{anchor:"transformers.PatchTSTConfig.head_dropout",description:`<strong>head_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for head.`,name:"head_dropout"},{anchor:"transformers.PatchTSTConfig.prediction_length",description:`<strong>prediction_length</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
The prediction horizon that the model will output.`,name:"prediction_length"},{anchor:"transformers.PatchTSTConfig.num_targets",description:`<strong>num_targets</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of targets for regression and classification tasks. For classification, it is the number of
classes.`,name:"num_targets"},{anchor:"transformers.PatchTSTConfig.output_range",description:`<strong>output_range</strong> (<code>list</code>, <em>optional</em>) &#x2014;
Output range for regression task. The range of output values can be set to enforce the model to produce
values within a range.`,name:"output_range"},{anchor:"transformers.PatchTSTConfig.num_parallel_samples",description:`<strong>num_parallel_samples</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of samples is generated in parallel for probabilistic prediction.`,name:"num_parallel_samples"}],source:"https://github.com/huggingface/transformers/blob/vr_30799/src/transformers/models/patchtst/configuration_patchtst.py#L26"}}),N=new Re({props:{anchor:"transformers.PatchTSTConfig.example",$$slots:{default:[pa]},$$scope:{ctx:w}}}),ce=new G({props:{title:"PatchTSTModel",local:"transformers.PatchTSTModel",headingTag:"h2"}}),de=new Z({props:{name:"class transformers.PatchTSTModel",anchor:"transformers.PatchTSTModel",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30799/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30799/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30799/src/transformers/models/patchtst/modeling_patchtst.py#L1142"}}),me=new Z({props:{name:"forward",anchor:"transformers.PatchTSTModel.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": Optional = None"},{name:"future_values",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PatchTSTModel.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTModel.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTModel.forward.future_values",description:`<strong>future_values</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, prediction_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Future target values associated with the <code>past_values</code>`,name:"future_values"},{anchor:"transformers.PatchTSTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30799/src/transformers/models/patchtst/modeling_patchtst.py#L1165",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTModelOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or <code>config.return_dict</code>=False)</p>
`}}),I=new Re({props:{anchor:"transformers.PatchTSTModel.forward.example",$$slots:{default:[ha]},$$scope:{ctx:w}}}),pe=new G({props:{title:"PatchTSTForPrediction",local:"transformers.PatchTSTForPrediction",headingTag:"h2"}}),he=new Z({props:{name:"class transformers.PatchTSTForPrediction",anchor:"transformers.PatchTSTForPrediction",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForPrediction.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30799/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30799/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30799/src/transformers/models/patchtst/modeling_patchtst.py#L1633"}}),ue=new Z({props:{name:"forward",anchor:"transformers.PatchTSTForPrediction.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": Optional = None"},{name:"future_values",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForPrediction.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForPrediction.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForPrediction.forward.future_values",description:`<strong>future_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, forecast_len, num_input_channels)</code>, <em>optional</em>) &#x2014;
Future target values associated with the <code>past_values</code>`,name:"future_values"},{anchor:"transformers.PatchTSTForPrediction.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForPrediction.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForPrediction.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30799/src/transformers/models/patchtst/modeling_patchtst.py#L1667",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForPredictionOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),H=new Re({props:{anchor:"transformers.PatchTSTForPrediction.forward.example",$$slots:{default:[ua]},$$scope:{ctx:w}}}),fe=new G({props:{title:"PatchTSTForClassification",local:"transformers.PatchTSTForClassification",headingTag:"h2"}}),ge=new Z({props:{name:"class transformers.PatchTSTForClassification",anchor:"transformers.PatchTSTForClassification",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30799/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30799/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30799/src/transformers/models/patchtst/modeling_patchtst.py#L1438"}}),Te=new Z({props:{name:"forward",anchor:"transformers.PatchTSTForClassification.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"target_values",val:": Tensor = None"},{name:"past_observed_mask",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForClassification.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForClassification.forward.target_values",description:`<strong>target_values</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Labels associates with the <code>past_values</code>`,name:"target_values"},{anchor:"transformers.PatchTSTForClassification.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30799/src/transformers/models/patchtst/modeling_patchtst.py#L1457",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForClassificationOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),Y=new Re({props:{anchor:"transformers.PatchTSTForClassification.forward.example",$$slots:{default:[fa]},$$scope:{ctx:w}}}),_e=new G({props:{title:"PatchTSTForPretraining",local:"transformers.PatchTSTForPretraining",headingTag:"h2"}}),be=new Z({props:{name:"class transformers.PatchTSTForPretraining",anchor:"transformers.PatchTSTForPretraining",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForPretraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30799/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30799/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30799/src/transformers/models/patchtst/modeling_patchtst.py#L1286"}}),Me=new Z({props:{name:"forward",anchor:"transformers.PatchTSTForPretraining.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForPretraining.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForPretraining.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForPretraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForPretraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForPretraining.forward.return_dict",description:"<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.",name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30799/src/transformers/models/patchtst/modeling_patchtst.py#L1301",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForPretrainingOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),E=new Re({props:{anchor:"transformers.PatchTSTForPretraining.forward.example",$$slots:{default:[ga]},$$scope:{ctx:w}}}),ye=new G({props:{title:"PatchTSTForRegression",local:"transformers.PatchTSTForRegression",headingTag:"h2"}}),ve=new Z({props:{name:"class transformers.PatchTSTForRegression",anchor:"transformers.PatchTSTForRegression",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForRegression.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30799/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30799/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30799/src/transformers/models/patchtst/modeling_patchtst.py#L1879"}}),we=new Z({props:{name:"forward",anchor:"transformers.PatchTSTForRegression.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"target_values",val:": Tensor = None"},{name:"past_observed_mask",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForRegression.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForRegression.forward.target_values",description:`<strong>target_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, num_input_channels)</code>) &#x2014;
Target values associates with the <code>past_values</code>`,name:"target_values"},{anchor:"transformers.PatchTSTForRegression.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForRegression.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForRegression.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForRegression.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30799/src/transformers/models/patchtst/modeling_patchtst.py#L1910",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForRegressionOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),Q=new Re({props:{anchor:"transformers.PatchTSTForRegression.forward.example",$$slots:{default:[Ta]},$$scope:{ctx:w}}}),je=new ma({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/patchtst.md"}}),{c(){s=m("meta"),v=o(),d=m("p"),i=o(),h(b.$$.fragment),t=o(),h(M.$$.fragment),ze=o(),A=m("p"),A.innerHTML=It,Ye=o(),O=m("p"),O.textContent=Vt,Xe=o(),K=m("p"),K.innerHTML=Ht,Ee=o(),ee=m("p"),ee.textContent=zt,qe=o(),te=m("p"),te.innerHTML=Yt,Qe=o(),ae=m("p"),ae.innerHTML=Xt,De=o(),h(ne.$$.fragment),Le=o(),se=m("p"),se.innerHTML=Et,Ae=o(),h(oe.$$.fragment),Oe=o(),re=m("ul"),re.innerHTML=qt,Ke=o(),h(le.$$.fragment),et=o(),j=m("div"),h(ie.$$.fragment),Tt=o(),Ue=m("p"),Ue.innerHTML=Qt,_t=o(),Pe=m("p"),Pe.innerHTML=Dt,bt=o(),h(N.$$.fragment),tt=o(),h(ce.$$.fragment),at=o(),$=m("div"),h(de.$$.fragment),Mt=o(),Ce=m("p"),Ce.innerHTML=Lt,yt=o(),Se=m("p"),Se.innerHTML=At,vt=o(),R=m("div"),h(me.$$.fragment),wt=o(),h(I.$$.fragment),nt=o(),h(pe.$$.fragment),st=o(),J=m("div"),h(he.$$.fragment),jt=o(),ke=m("p"),ke.innerHTML=Ot,$t=o(),xe=m("p"),xe.innerHTML=Kt,Jt=o(),V=m("div"),h(ue.$$.fragment),Ut=o(),h(H.$$.fragment),ot=o(),h(fe.$$.fragment),rt=o(),U=m("div"),h(ge.$$.fragment),Pt=o(),Fe=m("p"),Fe.innerHTML=ea,Ct=o(),Be=m("p"),Be.innerHTML=ta,St=o(),z=m("div"),h(Te.$$.fragment),kt=o(),h(Y.$$.fragment),lt=o(),h(_e.$$.fragment),it=o(),P=m("div"),h(be.$$.fragment),xt=o(),We=m("p"),We.innerHTML=aa,Ft=o(),Ze=m("p"),Ze.innerHTML=na,Bt=o(),X=m("div"),h(Me.$$.fragment),Wt=o(),h(E.$$.fragment),ct=o(),h(ye.$$.fragment),dt=o(),C=m("div"),h(ve.$$.fragment),Zt=o(),Ge=m("p"),Ge.innerHTML=sa,Gt=o(),Ne=m("p"),Ne.innerHTML=oa,Nt=o(),q=m("div"),h(we.$$.fragment),Rt=o(),h(Q.$$.fragment),mt=o(),h(je.$$.fragment),pt=o(),He=m("p"),this.h()},l(e){const a=da("svelte-u9bgzb",document.head);s=p(a,"META",{name:!0,content:!0}),a.forEach(n),v=r(e),d=p(e,"P",{}),S(d).forEach(n),i=r(e),u(b.$$.fragment,e),t=r(e),u(M.$$.fragment,e),ze=r(e),A=p(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-a4z81d"&&(A.innerHTML=It),Ye=r(e),O=p(e,"P",{"data-svelte-h":!0}),y(O)!=="svelte-11qe7tl"&&(O.textContent=Vt),Xe=r(e),K=p(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-cqhrix"&&(K.innerHTML=Ht),Ee=r(e),ee=p(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-vfdo9a"&&(ee.textContent=zt),qe=r(e),te=p(e,"P",{"data-svelte-h":!0}),y(te)!=="svelte-1lan0k1"&&(te.innerHTML=Yt),Qe=r(e),ae=p(e,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-kbmat5"&&(ae.innerHTML=Xt),De=r(e),u(ne.$$.fragment,e),Le=r(e),se=p(e,"P",{"data-svelte-h":!0}),y(se)!=="svelte-1kn5fbn"&&(se.innerHTML=Et),Ae=r(e),u(oe.$$.fragment,e),Oe=r(e),re=p(e,"UL",{"data-svelte-h":!0}),y(re)!=="svelte-tg1cax"&&(re.innerHTML=qt),Ke=r(e),u(le.$$.fragment,e),et=r(e),j=p(e,"DIV",{class:!0});var x=S(j);u(ie.$$.fragment,x),Tt=r(x),Ue=p(x,"P",{"data-svelte-h":!0}),y(Ue)!=="svelte-u41g6d"&&(Ue.innerHTML=Qt),_t=r(x),Pe=p(x,"P",{"data-svelte-h":!0}),y(Pe)!=="svelte-mecz3g"&&(Pe.innerHTML=Dt),bt=r(x),u(N.$$.fragment,x),x.forEach(n),tt=r(e),u(ce.$$.fragment,e),at=r(e),$=p(e,"DIV",{class:!0});var F=S($);u(de.$$.fragment,F),Mt=r(F),Ce=p(F,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-1jlufqf"&&(Ce.innerHTML=Lt),yt=r(F),Se=p(F,"P",{"data-svelte-h":!0}),y(Se)!=="svelte-hswkmf"&&(Se.innerHTML=At),vt=r(F),R=p(F,"DIV",{class:!0});var $e=S(R);u(me.$$.fragment,$e),wt=r($e),u(I.$$.fragment,$e),$e.forEach(n),F.forEach(n),nt=r(e),u(pe.$$.fragment,e),st=r(e),J=p(e,"DIV",{class:!0});var B=S(J);u(he.$$.fragment,B),jt=r(B),ke=p(B,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-cfyu4j"&&(ke.innerHTML=Ot),$t=r(B),xe=p(B,"P",{"data-svelte-h":!0}),y(xe)!=="svelte-hswkmf"&&(xe.innerHTML=Kt),Jt=r(B),V=p(B,"DIV",{class:!0});var Je=S(V);u(ue.$$.fragment,Je),Ut=r(Je),u(H.$$.fragment,Je),Je.forEach(n),B.forEach(n),ot=r(e),u(fe.$$.fragment,e),rt=r(e),U=p(e,"DIV",{class:!0});var W=S(U);u(ge.$$.fragment,W),Pt=r(W),Fe=p(W,"P",{"data-svelte-h":!0}),y(Fe)!=="svelte-ohz22y"&&(Fe.innerHTML=ea),Ct=r(W),Be=p(W,"P",{"data-svelte-h":!0}),y(Be)!=="svelte-hswkmf"&&(Be.innerHTML=ta),St=r(W),z=p(W,"DIV",{class:!0});var ut=S(z);u(Te.$$.fragment,ut),kt=r(ut),u(Y.$$.fragment,ut),ut.forEach(n),W.forEach(n),lt=r(e),u(_e.$$.fragment,e),it=r(e),P=p(e,"DIV",{class:!0});var D=S(P);u(be.$$.fragment,D),xt=r(D),We=p(D,"P",{"data-svelte-h":!0}),y(We)!=="svelte-6p2uo7"&&(We.innerHTML=aa),Ft=r(D),Ze=p(D,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-hswkmf"&&(Ze.innerHTML=na),Bt=r(D),X=p(D,"DIV",{class:!0});var ft=S(X);u(Me.$$.fragment,ft),Wt=r(ft),u(E.$$.fragment,ft),ft.forEach(n),D.forEach(n),ct=r(e),u(ye.$$.fragment,e),dt=r(e),C=p(e,"DIV",{class:!0});var L=S(C);u(ve.$$.fragment,L),Zt=r(L),Ge=p(L,"P",{"data-svelte-h":!0}),y(Ge)!=="svelte-2xezwf"&&(Ge.innerHTML=sa),Gt=r(L),Ne=p(L,"P",{"data-svelte-h":!0}),y(Ne)!=="svelte-hswkmf"&&(Ne.innerHTML=oa),Nt=r(L),q=p(L,"DIV",{class:!0});var gt=S(q);u(we.$$.fragment,gt),Rt=r(gt),u(Q.$$.fragment,gt),gt.forEach(n),L.forEach(n),mt=r(e),u(je.$$.fragment,e),pt=r(e),He=p(e,"P",{}),S(He).forEach(n),this.h()},h(){k(s,"name","hf:doc:metadata"),k(s,"content",ba),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){c(document.head,s),l(e,v,a),l(e,d,a),l(e,i,a),f(b,e,a),l(e,t,a),f(M,e,a),l(e,ze,a),l(e,A,a),l(e,Ye,a),l(e,O,a),l(e,Xe,a),l(e,K,a),l(e,Ee,a),l(e,ee,a),l(e,qe,a),l(e,te,a),l(e,Qe,a),l(e,ae,a),l(e,De,a),f(ne,e,a),l(e,Le,a),l(e,se,a),l(e,Ae,a),f(oe,e,a),l(e,Oe,a),l(e,re,a),l(e,Ke,a),f(le,e,a),l(e,et,a),l(e,j,a),f(ie,j,null),c(j,Tt),c(j,Ue),c(j,_t),c(j,Pe),c(j,bt),f(N,j,null),l(e,tt,a),f(ce,e,a),l(e,at,a),l(e,$,a),f(de,$,null),c($,Mt),c($,Ce),c($,yt),c($,Se),c($,vt),c($,R),f(me,R,null),c(R,wt),f(I,R,null),l(e,nt,a),f(pe,e,a),l(e,st,a),l(e,J,a),f(he,J,null),c(J,jt),c(J,ke),c(J,$t),c(J,xe),c(J,Jt),c(J,V),f(ue,V,null),c(V,Ut),f(H,V,null),l(e,ot,a),f(fe,e,a),l(e,rt,a),l(e,U,a),f(ge,U,null),c(U,Pt),c(U,Fe),c(U,Ct),c(U,Be),c(U,St),c(U,z),f(Te,z,null),c(z,kt),f(Y,z,null),l(e,lt,a),f(_e,e,a),l(e,it,a),l(e,P,a),f(be,P,null),c(P,xt),c(P,We),c(P,Ft),c(P,Ze),c(P,Bt),c(P,X),f(Me,X,null),c(X,Wt),f(E,X,null),l(e,ct,a),f(ye,e,a),l(e,dt,a),l(e,C,a),f(ve,C,null),c(C,Zt),c(C,Ge),c(C,Gt),c(C,Ne),c(C,Nt),c(C,q),f(we,q,null),c(q,Rt),f(Q,q,null),l(e,mt,a),f(je,e,a),l(e,pt,a),l(e,He,a),ht=!0},p(e,[a]){const x={};a&2&&(x.$$scope={dirty:a,ctx:e}),N.$set(x);const F={};a&2&&(F.$$scope={dirty:a,ctx:e}),I.$set(F);const $e={};a&2&&($e.$$scope={dirty:a,ctx:e}),H.$set($e);const B={};a&2&&(B.$$scope={dirty:a,ctx:e}),Y.$set(B);const Je={};a&2&&(Je.$$scope={dirty:a,ctx:e}),E.$set(Je);const W={};a&2&&(W.$$scope={dirty:a,ctx:e}),Q.$set(W)},i(e){ht||(g(b.$$.fragment,e),g(M.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),g(le.$$.fragment,e),g(ie.$$.fragment,e),g(N.$$.fragment,e),g(ce.$$.fragment,e),g(de.$$.fragment,e),g(me.$$.fragment,e),g(I.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(H.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(Te.$$.fragment,e),g(Y.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(Me.$$.fragment,e),g(E.$$.fragment,e),g(ye.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g(Q.$$.fragment,e),g(je.$$.fragment,e),ht=!0)},o(e){T(b.$$.fragment,e),T(M.$$.fragment,e),T(ne.$$.fragment,e),T(oe.$$.fragment,e),T(le.$$.fragment,e),T(ie.$$.fragment,e),T(N.$$.fragment,e),T(ce.$$.fragment,e),T(de.$$.fragment,e),T(me.$$.fragment,e),T(I.$$.fragment,e),T(pe.$$.fragment,e),T(he.$$.fragment,e),T(ue.$$.fragment,e),T(H.$$.fragment,e),T(fe.$$.fragment,e),T(ge.$$.fragment,e),T(Te.$$.fragment,e),T(Y.$$.fragment,e),T(_e.$$.fragment,e),T(be.$$.fragment,e),T(Me.$$.fragment,e),T(E.$$.fragment,e),T(ye.$$.fragment,e),T(ve.$$.fragment,e),T(we.$$.fragment,e),T(Q.$$.fragment,e),T(je.$$.fragment,e),ht=!1},d(e){e&&(n(v),n(d),n(i),n(t),n(ze),n(A),n(Ye),n(O),n(Xe),n(K),n(Ee),n(ee),n(qe),n(te),n(Qe),n(ae),n(De),n(Le),n(se),n(Ae),n(Oe),n(re),n(Ke),n(et),n(j),n(tt),n(at),n($),n(nt),n(st),n(J),n(ot),n(rt),n(U),n(lt),n(it),n(P),n(ct),n(dt),n(C),n(mt),n(pt),n(He)),n(s),_(b,e),_(M,e),_(ne,e),_(oe,e),_(le,e),_(ie),_(N),_(ce,e),_(de),_(me),_(I),_(pe,e),_(he),_(ue),_(H),_(fe,e),_(ge),_(Te),_(Y),_(_e,e),_(be),_(Me),_(E),_(ye,e),_(ve),_(we),_(Q),_(je,e)}}}const ba='{"title":"PatchTST","local":"patchtst","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"PatchTSTConfig","local":"transformers.PatchTSTConfig","sections":[],"depth":2},{"title":"PatchTSTModel","local":"transformers.PatchTSTModel","sections":[],"depth":2},{"title":"PatchTSTForPrediction","local":"transformers.PatchTSTForPrediction","sections":[],"depth":2},{"title":"PatchTSTForClassification","local":"transformers.PatchTSTForClassification","sections":[],"depth":2},{"title":"PatchTSTForPretraining","local":"transformers.PatchTSTForPretraining","sections":[],"depth":2},{"title":"PatchTSTForRegression","local":"transformers.PatchTSTForRegression","sections":[],"depth":2}],"depth":1}';function Ma(w){return la(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ua extends ia{constructor(s){super(),ca(this,s,Ma,_a,ra,{})}}export{Ua as component};
