import{s as Ba,n as ka,o as Na}from"../chunks/scheduler.85c25b89.js";import{S as Aa,i as Fa,g as i,s as n,r as c,A as Za,h as s,f as a,c as o,j as v,u as p,x as d,k as b,y as l,a as r,v as _,d as u,t as g,w as h}from"../chunks/index.c142fe32.js";import{D as M}from"../chunks/Docstring.d3e0bcd1.js";import{C as ze}from"../chunks/CodeBlock.a5e95a57.js";import{H as k,E as Ea}from"../chunks/EditOnGithub.a592e7aa.js";function Wa(ta){let U,Le,He,Ve,N,Xe,A,aa=`TRL supports the Binary Classifier Optimization (BCO).
The <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0.
For a full example have a look at  <code>examples/scripts/bco.py</code>.`,De,F,Re,Z,na="The BCO trainer expects a very specific format for the dataset as it does not require pairwise preferences. Since the model will be trained to directly optimize examples that consist of a prompt, model completion, and a label to indicate whether the completion is “good” or “bad”, we expect a dataset with the following columns:",qe,E,oa="<li><code>prompt</code></li> <li><code>completion</code></li> <li><code>label</code></li>",Qe,W,la="for example:",Pe,H,Se,G,ra=`where the <code>prompt</code> contains the context inputs, <code>completion</code> contains the corresponding responses and <code>label</code> contains the corresponding flag that indicates if the generated completion is desired (<code>True</code>) or undesired (<code>False</code>).
A prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays. It is required that the dataset contains at least one desirable and one undesirable completion.`,Ye,z,Ke,L,ia="The BCO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",et,V,tt,X,sa="For a detailed example have a look at the <code>examples/scripts/bco.py</code> script. At a high level we need to initialize the <code>BCOTrainer</code> with a <code>model</code> we wish to train and a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response.",at,D,da="The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",nt,R,ot,q,ma="After this one can then call:",lt,Q,rt,P,it,S,ca=`In practical scenarios, the thumbs-up and thumbs-down datasets are likely to have divergent underlying distributions of prompts.
Consider an LLM deployed for user feedback: if the model excels in writing tasks but underperforms in coding, the thumbs-up dataset will be dominated by writing-related prompts, while the thumbs-down dataset will contain mostly coding-related prompts.<br/>
If the prompts in your desired and undesired datasets differ a lot, it is useful to enable UDM.`,st,Y,pa="Choose an embedding model and tokenizer:",dt,K,mt,ee,_a="Set <code>prompt_sample_size</code> to defined how many prompts are selected to train the UDM classifier and start the training with the provided embedding function:",ct,te,pt,ae,_t,ne,ua=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,ut,oe,ga=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. MixtralConfig).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: 0.001).`,gt,le,ht,m,re,jt,Me,ha='Initialize BCOTrainer from <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> paper.',Ot,J,ie,It,Te,fa="Compute the BCO loss for a batch of policy and reference model log probabilities.",Bt,$,se,kt,ye,va="Computes log probabilities of the reference model for a single padded batch of a BCO specific dataset.",Nt,y,de,At,Ce,ba=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Ft,we,Ma="Works both with or without labels.",Zt,x,me,Et,Ue,Ta="Compute the log probabilities of the given labels under the given logits.",Wt,j,ce,Ht,Je,ya="Compute the BCO loss and other metrics for the given batch of inputs for train or test.",Gt,O,pe,zt,$e,Ca="Generate samples from the model and reference model for the given batch of inputs.",Lt,C,_e,Vt,xe,wa="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Xt,je,Ua="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Dt,w,ue,Rt,Oe,Ja="Returns the training <code>~torch.utils.data.DataLoader</code>.",qt,Ie,$a="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Qt,I,ge,Pt,Be,xa="Log <code>logs</code> on the various objects watching training, including stored metrics.",St,B,he,Yt,ke,ja="Context manager for handling null reference model (that is, peft adapter manipulation).",ft,fe,vt,T,ve,Kt,Ne,Oa='BCOConfig collects all training arguments related to the <a href="/docs/trl/pr_1725/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a> class.',ea,Ae,Ia=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,bt,be,Mt,Ge,Tt;return N=new k({props:{title:"BCO Trainer",local:"bco-trainer",headingTag:"h1"}}),F=new k({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),H=new ze({props:{code:"YmNvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhleSUyQyUyMGhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoaSUyMG5pY2UlMjB0byUyMG1lZXQlMjB5b3UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDJTJCJTJCJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySmF2YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`bco_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;Hey, hello&quot;</span>,
        <span class="hljs-string">&quot;How are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;completion&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I don&#x27;t have a name&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;label&quot;</span>: [
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
    ],
}`,wrap:!1}}),z=new k({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),V=new k({props:{title:"Using the BCOTrainer",local:"using-the-bcotrainer",headingTag:"h2"}}),R=new ze({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEJDT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQSUwQWJjb190cmFpbmVyJTIwJTNEJTIwQkNPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`training_args = BCOConfig(
    beta=<span class="hljs-number">0.1</span>,
)

bco_trainer = BCOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),Q=new ze({props:{code:"YmNvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"bco_trainer.train()",wrap:!1}}),P=new k({props:{title:"Underlying Distribution matching (UDM)",local:"underlying-distribution-matching-udm",headingTag:"h2"}}),K=new ze({props:{code:"ZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCh5b3VyX21vZGVsX2lkKSUwQWVtYmVkZGluZ190b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCh5b3VyX21vZGVsX2lkKSUwQSUwQSUyMyUyMGN1c3RvbWl6ZSUyMHRoaXMlMjBmdW5jdGlvbiUyMGRlcGVuZGluZyUyMG9uJTIweW91ciUyMGVtYmVkZGluZyUyMG1vZGVsJTBBZGVmJTIwZW1iZWRfcHJvbXB0KGlucHV0X2lkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTJDJTIwbW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUzRGlucHV0X2lkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTNEYXR0ZW50aW9uX21hc2spJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZS5tZWFuKGRpbSUzRDEpJTBBJTBBZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwQWNjZWxlcmF0b3IoKS5wcmVwYXJlX21vZGVsKHNlbGYuZW1iZWRkaW5nX21vZGVsKSUwQWVtYmVkZGluZ19mdW5jJTIwJTNEJTIwcGFydGlhbChlbWJlZF9wcm9tcHQlMkMlMjBtb2RlbCUzRGVtYmVkZGluZ19tb2RlbCk=",highlighted:`embedding_model = AutoModel.from_pretrained(your_model_id)
embedding_tokenizer = AutoTokenizer.from_pretrained(your_model_id)

<span class="hljs-comment"># customize this function depending on your embedding model</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">embed_prompt</span>(<span class="hljs-params">input_ids, attention_mask, model</span>):
    outputs = model(input_ids=input_ids, attention_mask=attention_mask)
    <span class="hljs-keyword">return</span> outputs.last_hidden_state.mean(dim=<span class="hljs-number">1</span>)

embedding_model = Accelerator().prepare_model(self.embedding_model)
embedding_func = partial(embed_prompt, model=embedding_model)`,wrap:!1}}),te=new ze({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEJDT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3NhbXBsZV9zaXplJTNENTEyJTJDJTBBKSUwQSUwQWJjb190cmFpbmVyJTIwJTNEJTIwQkNPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBlbWJlZGRpbmdfZnVuYyUzRGVtYmVkZGluZ19mdW5jJTJDJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nX3Rva2VuaXplciUzRHNlbGYuZW1iZWRkaW5nX3Rva2VuaXplciUyQyUwQSklMEElMEFiY29fdHJhaW5lci50cmFpbigp",highlighted:`training_args = BCOConfig(
    beta=<span class="hljs-number">0.1</span>,
    prompt_sample_size=<span class="hljs-number">512</span>,
)

bco_trainer = BCOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
    embedding_func=embedding_func,
    embedding_tokenizer=self.embedding_tokenizer,
)

bco_trainer.train()`,wrap:!1}}),ae=new k({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),le=new k({props:{title:"BCOTrainer",local:"trl.BCOTrainer",headingTag:"h2"}}),re=new M({props:{name:"class trl.BCOTrainer",anchor:"trl.BCOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"args",val:": BCOConfig = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"embedding_func",val:": Optional = None"},{name:"embedding_tokenizer",val:": Optional = None"}],parametersDescription:[{anchor:"trl.BCOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.BCOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.BCOTrainer.args",description:`<strong>args</strong> (<code>BCOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.BCOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.BCOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.BCOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.BCOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.BCOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.BCOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.BCOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.BCOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.BCOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.BCOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.BCOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.BCOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.BCOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/bco_trainer.py#L266"}}),ie=new M({props:{name:"bco_loss",anchor:"trl.BCOTrainer.bco_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"chosen_embeddings",val:": Optional"},{name:"rejected_embeddings",val:": Optional"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/bco_trainer.py#L1081",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, delta).
The losses tensor contains the BCO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The delta value contains the moving average of all implicit rewards.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),se=new M({props:{name:"compute_reference_log_probs",anchor:"trl.BCOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/bco_trainer.py#L940"}}),de=new M({props:{name:"evaluation_loop",anchor:"trl.BCOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/bco_trainer.py#L1341"}}),me=new M({props:{name:"get_batch_logps",anchor:"trl.BCOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/bco_trainer.py#L983",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),ce=new M({props:{name:"get_batch_loss_metrics",anchor:"trl.BCOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/bco_trainer.py#L1143"}}),pe=new M({props:{name:"get_batch_samples",anchor:"trl.BCOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/bco_trainer.py#L1256"}}),_e=new M({props:{name:"get_eval_dataloader",anchor:"trl.BCOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.BCOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/bco_trainer.py#L894"}}),ue=new M({props:{name:"get_train_dataloader",anchor:"trl.BCOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/bco_trainer.py#L860"}}),ge=new M({props:{name:"log",anchor:"trl.BCOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.BCOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/bco_trainer.py#L1397"}}),he=new M({props:{name:"null_ref_context",anchor:"trl.BCOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/bco_trainer.py#L848"}}),fe=new k({props:{title:"BCOConfig",local:"trl.BCOConfig",headingTag:"h2"}}),ve=new M({props:{name:"class trl.BCOConfig",anchor:"trl.BCOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"},{name:"prompt_sample_size",val:": int = 1024"},{name:"min_density_ratio",val:": float = 0.5"},{name:"max_density_ratio",val:": float = 10.0"}],parametersDescription:[{anchor:"trl.BCOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.BCOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.BCOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.BCOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in BCO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.BCOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.BCOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.BCOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.BCOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.BCOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.BCOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string.
dataset_num_proc &#x2014; (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>):
Number of processes to use for processing the datasets.
prompt_sample_size &#x2014; (<code>int</code>, defaults to 1024):
Number of prompts that are fed to density ratio classifier.
min_density_ratio &#x2014; (<code>float</code>, defaults to 0.5):
The minimum value of the density ratio. The estimated density ratio is clamped to this value.
max_density_ratio &#x2014; (<code>float</code>, defaults to 10.0):
The maximum value of the density ratio. The estimated density ratio is clamped to this value.`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/bco_config.py#L22"}}),be=new Ea({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/bco_trainer.mdx"}}),{c(){U=i("meta"),Le=n(),He=i("p"),Ve=n(),c(N.$$.fragment),Xe=n(),A=i("p"),A.innerHTML=aa,De=n(),c(F.$$.fragment),Re=n(),Z=i("p"),Z.textContent=na,qe=n(),E=i("ul"),E.innerHTML=oa,Qe=n(),W=i("p"),W.textContent=la,Pe=n(),c(H.$$.fragment),Se=n(),G=i("p"),G.innerHTML=ra,Ye=n(),c(z.$$.fragment),Ke=n(),L=i("p"),L.innerHTML=ia,et=n(),c(V.$$.fragment),tt=n(),X=i("p"),X.innerHTML=sa,at=n(),D=i("p"),D.innerHTML=da,nt=n(),c(R.$$.fragment),ot=n(),q=i("p"),q.textContent=ma,lt=n(),c(Q.$$.fragment),rt=n(),c(P.$$.fragment),it=n(),S=i("p"),S.innerHTML=ca,st=n(),Y=i("p"),Y.textContent=pa,dt=n(),c(K.$$.fragment),mt=n(),ee=i("p"),ee.innerHTML=_a,ct=n(),c(te.$$.fragment),pt=n(),c(ae.$$.fragment),_t=n(),ne=i("p"),ne.innerHTML=ua,ut=n(),oe=i("p"),oe.innerHTML=ga,gt=n(),c(le.$$.fragment),ht=n(),m=i("div"),c(re.$$.fragment),jt=n(),Me=i("p"),Me.innerHTML=ha,Ot=n(),J=i("div"),c(ie.$$.fragment),It=n(),Te=i("p"),Te.textContent=fa,Bt=n(),$=i("div"),c(se.$$.fragment),kt=n(),ye=i("p"),ye.textContent=va,Nt=n(),y=i("div"),c(de.$$.fragment),At=n(),Ce=i("p"),Ce.innerHTML=ba,Ft=n(),we=i("p"),we.textContent=Ma,Zt=n(),x=i("div"),c(me.$$.fragment),Et=n(),Ue=i("p"),Ue.textContent=Ta,Wt=n(),j=i("div"),c(ce.$$.fragment),Ht=n(),Je=i("p"),Je.textContent=ya,Gt=n(),O=i("div"),c(pe.$$.fragment),zt=n(),$e=i("p"),$e.textContent=Ca,Lt=n(),C=i("div"),c(_e.$$.fragment),Vt=n(),xe=i("p"),xe.innerHTML=wa,Xt=n(),je=i("p"),je.innerHTML=Ua,Dt=n(),w=i("div"),c(ue.$$.fragment),Rt=n(),Oe=i("p"),Oe.innerHTML=Ja,qt=n(),Ie=i("p"),Ie.innerHTML=$a,Qt=n(),I=i("div"),c(ge.$$.fragment),Pt=n(),Be=i("p"),Be.innerHTML=xa,St=n(),B=i("div"),c(he.$$.fragment),Yt=n(),ke=i("p"),ke.textContent=ja,ft=n(),c(fe.$$.fragment),vt=n(),T=i("div"),c(ve.$$.fragment),Kt=n(),Ne=i("p"),Ne.innerHTML=Oa,ea=n(),Ae=i("p"),Ae.innerHTML=Ia,bt=n(),c(be.$$.fragment),Mt=n(),Ge=i("p"),this.h()},l(e){const t=Za("svelte-u9bgzb",document.head);U=s(t,"META",{name:!0,content:!0}),t.forEach(a),Le=o(e),He=s(e,"P",{}),v(He).forEach(a),Ve=o(e),p(N.$$.fragment,e),Xe=o(e),A=s(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-r130jr"&&(A.innerHTML=aa),De=o(e),p(F.$$.fragment,e),Re=o(e),Z=s(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-ili6wi"&&(Z.textContent=na),qe=o(e),E=s(e,"UL",{"data-svelte-h":!0}),d(E)!=="svelte-1bk1n3o"&&(E.innerHTML=oa),Qe=o(e),W=s(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1gl9mvz"&&(W.textContent=la),Pe=o(e),p(H.$$.fragment,e),Se=o(e),G=s(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1yefqq4"&&(G.innerHTML=ra),Ye=o(e),p(z.$$.fragment,e),Ke=o(e),L=s(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-a13xh1"&&(L.innerHTML=ia),et=o(e),p(V.$$.fragment,e),tt=o(e),X=s(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1xv0q10"&&(X.innerHTML=sa),at=o(e),D=s(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1eil2tw"&&(D.innerHTML=da),nt=o(e),p(R.$$.fragment,e),ot=o(e),q=s(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1lg6q1l"&&(q.textContent=ma),lt=o(e),p(Q.$$.fragment,e),rt=o(e),p(P.$$.fragment,e),it=o(e),S=s(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-16kpfu0"&&(S.innerHTML=ca),st=o(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1hlwkqm"&&(Y.textContent=pa),dt=o(e),p(K.$$.fragment,e),mt=o(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-ef1qid"&&(ee.innerHTML=_a),ct=o(e),p(te.$$.fragment,e),pt=o(e),p(ae.$$.fragment,e),_t=o(e),ne=s(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-3kfva2"&&(ne.innerHTML=ua),ut=o(e),oe=s(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1c01yo3"&&(oe.innerHTML=ga),gt=o(e),p(le.$$.fragment,e),ht=o(e),m=s(e,"DIV",{class:!0});var f=v(m);p(re.$$.fragment,f),jt=o(f),Me=s(f,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-120phx2"&&(Me.innerHTML=ha),Ot=o(f),J=s(f,"DIV",{class:!0});var yt=v(J);p(ie.$$.fragment,yt),It=o(yt),Te=s(yt,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-2814fy"&&(Te.textContent=fa),yt.forEach(a),Bt=o(f),$=s(f,"DIV",{class:!0});var Ct=v($);p(se.$$.fragment,Ct),kt=o(Ct),ye=s(Ct,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-2l3xud"&&(ye.textContent=va),Ct.forEach(a),Nt=o(f),y=s(f,"DIV",{class:!0});var Fe=v(y);p(de.$$.fragment,Fe),At=o(Fe),Ce=s(Fe,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-8qlty5"&&(Ce.innerHTML=ba),Ft=o(Fe),we=s(Fe,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1tyo99t"&&(we.textContent=Ma),Fe.forEach(a),Zt=o(f),x=s(f,"DIV",{class:!0});var wt=v(x);p(me.$$.fragment,wt),Et=o(wt),Ue=s(wt,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-4nmimv"&&(Ue.textContent=Ta),wt.forEach(a),Wt=o(f),j=s(f,"DIV",{class:!0});var Ut=v(j);p(ce.$$.fragment,Ut),Ht=o(Ut),Je=s(Ut,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1syv8mg"&&(Je.textContent=ya),Ut.forEach(a),Gt=o(f),O=s(f,"DIV",{class:!0});var Jt=v(O);p(pe.$$.fragment,Jt),zt=o(Jt),$e=s(Jt,"P",{"data-svelte-h":!0}),d($e)!=="svelte-18uwvbi"&&($e.textContent=Ca),Jt.forEach(a),Lt=o(f),C=s(f,"DIV",{class:!0});var Ze=v(C);p(_e.$$.fragment,Ze),Vt=o(Ze),xe=s(Ze,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-xesobz"&&(xe.innerHTML=wa),Xt=o(Ze),je=s(Ze,"P",{"data-svelte-h":!0}),d(je)!=="svelte-qg43tm"&&(je.innerHTML=Ua),Ze.forEach(a),Dt=o(f),w=s(f,"DIV",{class:!0});var Ee=v(w);p(ue.$$.fragment,Ee),Rt=o(Ee),Oe=s(Ee,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-dkae9b"&&(Oe.innerHTML=Ja),qt=o(Ee),Ie=s(Ee,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-hmd5cw"&&(Ie.innerHTML=$a),Ee.forEach(a),Qt=o(f),I=s(f,"DIV",{class:!0});var $t=v(I);p(ge.$$.fragment,$t),Pt=o($t),Be=s($t,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-nqksfz"&&(Be.innerHTML=xa),$t.forEach(a),St=o(f),B=s(f,"DIV",{class:!0});var xt=v(B);p(he.$$.fragment,xt),Yt=o(xt),ke=s(xt,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-17kjsy4"&&(ke.textContent=ja),xt.forEach(a),f.forEach(a),ft=o(e),p(fe.$$.fragment,e),vt=o(e),T=s(e,"DIV",{class:!0});var We=v(T);p(ve.$$.fragment,We),Kt=o(We),Ne=s(We,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-wnnx4g"&&(Ne.innerHTML=Oa),ea=o(We),Ae=s(We,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1xl7jqc"&&(Ae.innerHTML=Ia),We.forEach(a),bt=o(e),p(be.$$.fragment,e),Mt=o(e),Ge=s(e,"P",{}),v(Ge).forEach(a),this.h()},h(){b(U,"name","hf:doc:metadata"),b(U,"content",Ha),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,U),r(e,Le,t),r(e,He,t),r(e,Ve,t),_(N,e,t),r(e,Xe,t),r(e,A,t),r(e,De,t),_(F,e,t),r(e,Re,t),r(e,Z,t),r(e,qe,t),r(e,E,t),r(e,Qe,t),r(e,W,t),r(e,Pe,t),_(H,e,t),r(e,Se,t),r(e,G,t),r(e,Ye,t),_(z,e,t),r(e,Ke,t),r(e,L,t),r(e,et,t),_(V,e,t),r(e,tt,t),r(e,X,t),r(e,at,t),r(e,D,t),r(e,nt,t),_(R,e,t),r(e,ot,t),r(e,q,t),r(e,lt,t),_(Q,e,t),r(e,rt,t),_(P,e,t),r(e,it,t),r(e,S,t),r(e,st,t),r(e,Y,t),r(e,dt,t),_(K,e,t),r(e,mt,t),r(e,ee,t),r(e,ct,t),_(te,e,t),r(e,pt,t),_(ae,e,t),r(e,_t,t),r(e,ne,t),r(e,ut,t),r(e,oe,t),r(e,gt,t),_(le,e,t),r(e,ht,t),r(e,m,t),_(re,m,null),l(m,jt),l(m,Me),l(m,Ot),l(m,J),_(ie,J,null),l(J,It),l(J,Te),l(m,Bt),l(m,$),_(se,$,null),l($,kt),l($,ye),l(m,Nt),l(m,y),_(de,y,null),l(y,At),l(y,Ce),l(y,Ft),l(y,we),l(m,Zt),l(m,x),_(me,x,null),l(x,Et),l(x,Ue),l(m,Wt),l(m,j),_(ce,j,null),l(j,Ht),l(j,Je),l(m,Gt),l(m,O),_(pe,O,null),l(O,zt),l(O,$e),l(m,Lt),l(m,C),_(_e,C,null),l(C,Vt),l(C,xe),l(C,Xt),l(C,je),l(m,Dt),l(m,w),_(ue,w,null),l(w,Rt),l(w,Oe),l(w,qt),l(w,Ie),l(m,Qt),l(m,I),_(ge,I,null),l(I,Pt),l(I,Be),l(m,St),l(m,B),_(he,B,null),l(B,Yt),l(B,ke),r(e,ft,t),_(fe,e,t),r(e,vt,t),r(e,T,t),_(ve,T,null),l(T,Kt),l(T,Ne),l(T,ea),l(T,Ae),r(e,bt,t),_(be,e,t),r(e,Mt,t),r(e,Ge,t),Tt=!0},p:ka,i(e){Tt||(u(N.$$.fragment,e),u(F.$$.fragment,e),u(H.$$.fragment,e),u(z.$$.fragment,e),u(V.$$.fragment,e),u(R.$$.fragment,e),u(Q.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(_e.$$.fragment,e),u(ue.$$.fragment,e),u(ge.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(ve.$$.fragment,e),u(be.$$.fragment,e),Tt=!0)},o(e){g(N.$$.fragment,e),g(F.$$.fragment,e),g(H.$$.fragment,e),g(z.$$.fragment,e),g(V.$$.fragment,e),g(R.$$.fragment,e),g(Q.$$.fragment,e),g(P.$$.fragment,e),g(K.$$.fragment,e),g(te.$$.fragment,e),g(ae.$$.fragment,e),g(le.$$.fragment,e),g(re.$$.fragment,e),g(ie.$$.fragment,e),g(se.$$.fragment,e),g(de.$$.fragment,e),g(me.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(_e.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(ve.$$.fragment,e),g(be.$$.fragment,e),Tt=!1},d(e){e&&(a(Le),a(He),a(Ve),a(Xe),a(A),a(De),a(Re),a(Z),a(qe),a(E),a(Qe),a(W),a(Pe),a(Se),a(G),a(Ye),a(Ke),a(L),a(et),a(tt),a(X),a(at),a(D),a(nt),a(ot),a(q),a(lt),a(rt),a(it),a(S),a(st),a(Y),a(dt),a(mt),a(ee),a(ct),a(pt),a(_t),a(ne),a(ut),a(oe),a(gt),a(ht),a(m),a(ft),a(vt),a(T),a(bt),a(Mt),a(Ge)),a(U),h(N,e),h(F,e),h(H,e),h(z,e),h(V,e),h(R,e),h(Q,e),h(P,e),h(K,e),h(te,e),h(ae,e),h(le,e),h(re),h(ie),h(se),h(de),h(me),h(ce),h(pe),h(_e),h(ue),h(ge),h(he),h(fe,e),h(ve),h(be,e)}}}const Ha='{"title":"BCO Trainer","local":"bco-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the BCOTrainer","local":"using-the-bcotrainer","sections":[],"depth":2},{"title":"Underlying Distribution matching (UDM)","local":"underlying-distribution-matching-udm","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"BCOTrainer","local":"trl.BCOTrainer","sections":[],"depth":2},{"title":"BCOConfig","local":"trl.BCOConfig","sections":[],"depth":2}],"depth":1}';function Ga(ta){return Na(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ra extends Aa{constructor(U){super(),Fa(this,U,Ga,Wa,Ba,{})}}export{Ra as component};
