import{s as Bd,f as Rd,o as zd,n as Pd}from"../chunks/scheduler.25b97de1.js";import{S as Ed,i as Gd,g as i,s as o,r as d,A as Qd,h as a,f as n,c as s,j as C,u as m,x as r,k as ea,y as f,a as l,v as p,d as h,t as u,w as c}from"../chunks/index.d9030fc9.js";import{T as Vd}from"../chunks/Tip.baa67368.js";import{C as y}from"../chunks/CodeBlock.e6cd0d95.js";import{H as k,E as Dd}from"../chunks/EditOnGithub.91d95064.js";function Yd(cl){let w,_="In case you are using Windows, you should replace <code>RUN_SLOW=1</code> with <code>SET RUN_SLOW=1</code>";return{c(){w=i("p"),w.innerHTML=_},l(j){w=a(j,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1w9gxqz"&&(w.innerHTML=_)},m(j,On){l(j,w,On)},p:Pd,d(j){j&&n(w)}}}function Fd(cl){let w,_,j,On,I,fl,x,ta='The 🤗 Transformers library is often able to offer new models thanks to community contributors. But this can be a challenging project and requires an in-depth knowledge of the 🤗 Transformers library and the model to implement. At Hugging Face, we’re trying to empower more of the community to actively add models and we’ve put together this guide to walk you through the process of adding a PyTorch model (make sure you have <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch installed</a>).',yl,$,na="Along the way, you’ll:",wl,L,la="<li>get insights into open-source best practices</li> <li>understand the design principles behind one of the most popular deep learning libraries</li> <li>learn how to efficiently test large models</li> <li>learn how to integrate Python utilities like <code>black</code>, <code>ruff</code>, and <code>make fix-copies</code> to ensure clean and readable code</li>",Ml,A,oa="A Hugging Face team member will be available to help you along the way so you’ll never be alone. 🤗 ❤️",gl,H,sa='To get started, open a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=New+model&amp;template=new-model-addition.yml" rel="nofollow">New model addition</a> issue for the model you want to see in 🤗 Transformers. If you’re not especially picky about contributing a specific model, you can filter by the <a href="https://github.com/huggingface/transformers/labels/New%20model" rel="nofollow">New model label</a> to see if there are any unclaimed model requests and work on it.',Tl,Z,ia="Once you’ve opened a new model request, the first step is to get familiar with 🤗 Transformers if you aren’t already!",bl,N,vl,W,aa=`First, you should get a general overview of 🤗 Transformers. 🤗 Transformers is a very opinionated library, so there is a
chance that you don’t agree with some of the library’s philosophies or design choices. From our experience, however, we
found that the fundamental design choices and philosophies of the library are crucial to efficiently scale 🤗
Transformers while keeping maintenance costs at a reasonable level.`,Jl,B,ra='A good first starting point to better understand the library is to read the <a href="philosophy">documentation of our philosophy</a>. As a result of our way of working, there are some choices that we try to apply to all models:',jl,R,da=`<li>Composition is generally favored over-abstraction</li> <li>Duplicating code is not always bad if it strongly improves the readability or accessibility of a model</li> <li>Model files are as self-contained as possible so that when you read the code of a specific model, you ideally only
have to look into the respective <code>modeling_....py</code> file.</li>`,Cl,z,ma=`In our opinion, the library’s code is not just a means to provide a product, <em>e.g.</em> the ability to use BERT for
inference, but also as the very product that we want to improve. Hence, when adding a model, the user is not only the
person who will use your model, but also everybody who will read, try to understand, and possibly tweak your code.`,kl,P,pa="With this in mind, let’s go a bit deeper into the general library design.",Ul,E,_l,G,ha=`To successfully add a model, it is important to understand the interaction between your model and its config,
<a href="/docs/transformers/pr_27818/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, and <a href="/docs/transformers/pr_27818/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. For exemplary purposes, we will
call the model to be added to 🤗 Transformers <code>BrandNewBert</code>.`,Il,Q,ua="Let’s take a look:",xl,Kn,ca,$l,V,fa=`As you can see, we do make use of inheritance in 🤗 Transformers, but we keep the level of abstraction to an absolute
minimum. There are never more than two levels of abstraction for any model in the library. <code>BrandNewBertModel</code>
inherits from <code>BrandNewBertPreTrainedModel</code> which in turn inherits from <a href="/docs/transformers/pr_27818/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> and
that’s it. As a general rule, we want to make sure that a new model only depends on
<a href="/docs/transformers/pr_27818/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. The important functionalities that are automatically provided to every new
model are <a href="/docs/transformers/pr_27818/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> and
<a href="/docs/transformers/pr_27818/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, which are used for serialization and deserialization. All of the
other important functionalities, such as <code>BrandNewBertModel.forward</code> should be completely defined in the new
<code>modeling_brand_new_bert.py</code> script. Next, we want to make sure that a model with a specific head layer, such as
<code>BrandNewBertForMaskedLM</code> does not inherit from <code>BrandNewBertModel</code>, but rather uses <code>BrandNewBertModel</code>
as a component that can be called in its forward pass to keep the level of abstraction low. Every new model requires a
configuration class, called <code>BrandNewBertConfig</code>. This configuration is always stored as an attribute in
<a href="/docs/transformers/pr_27818/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, and thus can be accessed via the <code>config</code> attribute for all classes
inheriting from <code>BrandNewBertPreTrainedModel</code>:`,Ll,D,Al,Y,ya=`Similar to the model, the configuration inherits basic serialization and deserialization functionalities from
<a href="/docs/transformers/pr_27818/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. Note that the configuration and the model are always serialized into two
different formats - the model to a <em>pytorch_model.bin</em> file and the configuration to a <em>config.json</em> file. Calling
the model’s <a href="/docs/transformers/pr_27818/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> will automatically call
the config’s <a href="/docs/transformers/pr_27818/en/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a>, so that both model and configuration are saved.`,Hl,F,Zl,S,wa=`When coding your new model, keep in mind that Transformers is an opinionated library and we have a few quirks of our
own regarding how code should be written :-)`,Nl,X,Ma=`<li>The forward pass of your model should be fully written in the modeling file while being fully independent of other
models in the library. If you want to reuse a block from another model, copy the code and paste it with a
<code># Copied from</code> comment on top (see <a href="https://github.com/huggingface/transformers/blob/v4.17.0/src/transformers/models/roberta/modeling_roberta.py#L160" rel="nofollow">here</a>
for a good example and <a href="pr_checks#check-copies">there</a> for more documentation on Copied from).</li> <li>The code should be fully understandable, even by a non-native English speaker. This means you should pick
descriptive variable names and avoid abbreviations. As an example, <code>activation</code> is preferred to <code>act</code>.
One-letter variable names are strongly discouraged unless it’s an index in a for loop.</li> <li>More generally we prefer longer explicit code to short magical one.</li> <li>Avoid subclassing <code>nn.Sequential</code> in PyTorch but subclass <code>nn.Module</code> and write the forward pass, so that anyone
using your code can quickly debug it by adding print statements or breaking points.</li> <li>Your function signature should be type-annotated. For the rest, good variable names are way more readable and
understandable than type annotations.</li>`,Wl,q,Bl,O,ga="Not quite ready yet :-( This section will be added soon!",Rl,K,zl,ee,Ta=`Everyone has different preferences of how to port a model so it can be very helpful for you to take a look at summaries
of how other contributors ported models to Hugging Face. Here is a list of community blog posts on how to port a model:`,Pl,te,ba='<li><a href="https://medium.com/huggingface/from-tensorflow-to-pytorch-265f40ef2a28" rel="nofollow">Porting GPT2 Model</a> by <a href="https://huggingface.co/thomwolf" rel="nofollow">Thomas</a></li> <li><a href="https://huggingface.co/blog/porting-fsmt" rel="nofollow">Porting WMT19 MT Model</a> by <a href="https://huggingface.co/stas" rel="nofollow">Stas</a></li>',El,ne,va="From experience, we can tell you that the most important things to keep in mind when adding a model are:",Gl,le,Ja=`<li>Don’t reinvent the wheel! Most parts of the code you will add for the new 🤗 Transformers model already exist
somewhere in 🤗 Transformers. Take some time to find similar, already existing models and tokenizers you can copy
from. <a href="https://www.gnu.org/software/grep/" rel="nofollow">grep</a> and <a href="https://github.com/BurntSushi/ripgrep" rel="nofollow">rg</a> are your
friends. Note that it might very well happen that your model’s tokenizer is based on one model implementation, and
your model’s modeling code on another one. <em>E.g.</em> FSMT’s modeling code is based on BART, while FSMT’s tokenizer code
is based on XLM.</li> <li>It’s more of an engineering challenge than a scientific challenge. You should spend more time creating an
efficient debugging environment rather than trying to understand all theoretical aspects of the model in the paper.</li> <li>Ask for help, when you’re stuck! Models are the core component of 🤗 Transformers so we at Hugging Face are more
than happy to help you at every step to add your model. Don’t hesitate to ask if you notice you are not making
progress.</li>`,Ql,oe,ja="In the following, we try to give you a general recipe that we found most useful when porting a model to 🤗 Transformers.",Vl,se,Ca=`The following list is a summary of everything that has to be done to add a model and can be used by you as a To-Do
List:`,Dl,ie,ka=`☐ (Optional) Understood the model’s theoretical aspects<br/>
☐ Prepared 🤗 Transformers dev environment<br/>
☐ Set up debugging environment of the original repository<br/>
☐ Created script that successfully runs the <code>forward()</code> pass using the original repository and checkpoint<br/>
☐ Successfully added the model skeleton to 🤗 Transformers<br/>
☐ Successfully converted original checkpoint to 🤗 Transformers checkpoint<br/>
☐ Successfully ran <code>forward()</code> pass in 🤗 Transformers that gives identical output to original checkpoint<br/>
☐ Finished model tests in 🤗 Transformers<br/>
☐ Successfully added tokenizer in 🤗 Transformers<br/>
☐ Run end-to-end integration tests<br/>
☐ Finished docs<br/>
☐ Uploaded model weights to the Hub<br/>
☐ Submitted the pull request<br/>
☐ (Optional) Added a demo notebook`,Yl,ae,Ua=`To begin with, we usually recommend starting by getting a good theoretical understanding of <code>BrandNewBert</code>. However,
if you prefer to understand the theoretical aspects of the model <em>on-the-job</em>, then it is totally fine to directly dive
into the <code>BrandNewBert</code>’s code-base. This option might suit you better if your engineering skills are better than
your theoretical skill, if you have trouble understanding <code>BrandNewBert</code>’s paper, or if you just enjoy programming
much more than reading scientific papers.`,Fl,re,Sl,de,_a=`You should take some time to read <em>BrandNewBert’s</em> paper, if such descriptive work exists. There might be large
sections of the paper that are difficult to understand. If this is the case, this is fine - don’t worry! The goal is
not to get a deep theoretical understanding of the paper, but to extract the necessary information required to
effectively re-implement the model in 🤗 Transformers. That being said, you don’t have to spend too much time on the
theoretical aspects, but rather focus on the practical ones, namely:`,Xl,me,Ia=`<li>What type of model is <em>brand_new_bert</em>? BERT-like encoder-only model? GPT2-like decoder-only model? BART-like
encoder-decoder model? Look at the <a href="model_summary">model_summary</a> if you’re not familiar with the differences between those.</li> <li>What are the applications of <em>brand_new_bert</em>? Text classification? Text generation? Seq2Seq tasks, <em>e.g.,</em>
summarization?</li> <li>What is the novel feature of the model that makes it different from BERT/GPT-2/BART?</li> <li>Which of the already existing <a href="https://huggingface.co/transformers/#contents" rel="nofollow">🤗 Transformers models</a> is most
similar to <em>brand_new_bert</em>?</li> <li>What type of tokenizer is used? A sentencepiece tokenizer? Word piece tokenizer? Is it the same tokenizer as used
for BERT or BART?</li>`,ql,pe,xa=`After you feel like you have gotten a good overview of the architecture of the model, you might want to write to the
Hugging Face team with any questions you might have. This might include questions regarding the model’s architecture,
its attention layer, etc. We will be more than happy to help you.`,Ol,he,Kl,T,el,$a=`<p>Fork the <a href="https://github.com/huggingface/transformers" rel="nofollow">repository</a> by clicking on the ‘Fork’ button on the
repository’s page. This creates a copy of the code under your GitHub user account.</p>`,Hi,ue,tl,La="Clone your <code>transformers</code> fork to your local disk, and add the base repository as a remote:",Zi,ce,Ni,g,nl,Aa="Set up a development environment, for instance by running the following command:",Wi,fe,Bi,ll,Ha=`Depending on your OS, and since the number of optional dependencies of Transformers is growing, you might get a
failure with this command. If that’s the case make sure to install the Deep Learning framework you are working with
(PyTorch, TensorFlow and/or Flax) then do:`,Ri,ye,zi,ol,Za="which should be enough for most use cases. You can then return to the parent directory",Pi,we,Ei,sl,Na=`<p>We recommend adding the PyTorch version of <em>brand_new_bert</em> to Transformers. To install PyTorch, please follow the
instructions on <a href="https://pytorch.org/get-started/locally/" rel="nofollow">https://pytorch.org/get-started/locally/</a>.</p> <p><strong>Note:</strong> You don’t need to have CUDA installed. Making the new model work on CPU is sufficient.</p>`,Gi,Me,il,Wa="To port <em>brand_new_bert</em>, you will also need access to its original repository:",Qi,ge,eo,Te,Ba="Now you have set up a development environment to port <em>brand_new_bert</em> to 🤗 Transformers.",to,be,no,ve,Ra=`At first, you will work on the original <em>brand_new_bert</em> repository. Often, the original implementation is very
“researchy”. Meaning that documentation might be lacking and the code can be difficult to understand. But this should
be exactly your motivation to reimplement <em>brand_new_bert</em>. At Hugging Face, one of our main goals is to <em>make people
stand on the shoulders of giants</em> which translates here very well into taking a working model and rewriting it to make
it as <strong>accessible, user-friendly, and beautiful</strong> as possible. This is the number-one motivation to re-implement
models into 🤗 Transformers - trying to make complex new NLP technology accessible to <strong>everybody</strong>.`,lo,Je,za="You should start thereby by diving into the original repository.",oo,je,Pa=`Successfully running the official pretrained model in the original repository is often <strong>the most difficult</strong> step.
From our experience, it is very important to spend some time getting familiar with the original code-base. You need to
figure out the following:`,so,Ce,Ea=`<li>Where to find the pretrained weights?</li> <li>How to load the pretrained weights into the corresponding model?</li> <li>How to run the tokenizer independently from the model?</li> <li>Trace one forward pass so that you know which classes and functions are required for a simple forward pass. Usually,
you only have to reimplement those functions.</li> <li>Be able to locate the important components of the model: Where is the model’s class? Are there model sub-classes,
<em>e.g.</em> EncoderModel, DecoderModel? Where is the self-attention layer? Are there multiple different attention layers,
<em>e.g.</em> <em>self-attention</em>, <em>cross-attention</em>…?</li> <li>How can you debug the model in the original environment of the repo? Do you have to add <em>print</em> statements, can you
work with an interactive debugger like <em>ipdb</em>, or should you use an efficient IDE to debug the model, like PyCharm?</li>`,io,ke,Ga=`It is very important that before you start the porting process, you can <strong>efficiently</strong> debug code in the original
repository! Also, remember that you are working with an open-source library, so do not hesitate to open an issue, or
even a pull request in the original repository. The maintainers of this repository are most likely very happy about
someone looking into their code!`,ao,Ue,Qa=`At this point, it is really up to you which debugging environment and strategy you prefer to use to debug the original
model. We strongly advise against setting up a costly GPU environment, but simply work on a CPU both when starting to
dive into the original repository and also when starting to write the 🤗 Transformers implementation of the model. Only
at the very end, when the model has already been successfully ported to 🤗 Transformers, one should verify that the
model also works as expected on GPU.`,ro,_e,Va="In general, there are two possible debugging environments for running the original model",mo,Ie,Da='<li><a href="https://jupyter.org/" rel="nofollow">Jupyter notebooks</a> / <a href="https://colab.research.google.com/notebooks/intro.ipynb" rel="nofollow">google colab</a></li> <li>Local python scripts.</li>',po,xe,Ya=`Jupyter notebooks have the advantage that they allow for cell-by-cell execution which can be helpful to better split
logical components from one another and to have faster debugging cycles as intermediate results can be stored. Also,
notebooks are often easier to share with other contributors, which might be very helpful if you want to ask the Hugging
Face team for help. If you are familiar with Jupyter notebooks, we strongly recommend you work with them.`,ho,$e,Fa=`The obvious disadvantage of Jupyter notebooks is that if you are not used to working with them you will have to spend
some time adjusting to the new programming environment and you might not be able to use your known debugging tools
anymore, like <code>ipdb</code>.`,uo,Le,Sa=`For each code-base, a good first step is always to load a <strong>small</strong> pretrained checkpoint and to be able to reproduce a
single forward pass using a dummy integer vector of input IDs as an input. Such a script could look like this (in
pseudocode):`,co,Ae,fo,He,Xa="Next, regarding the debugging strategy, there are generally a few from which to choose from:",yo,Ze,qa=`<li>Decompose the original model into many small testable components and run a forward pass on each of those for
verification</li> <li>Decompose the original model only into the original <em>tokenizer</em> and the original <em>model</em>, run a forward pass on
those, and use intermediate print statements or breakpoints for verification</li>`,wo,Ne,Oa=`Again, it is up to you which strategy to choose. Often, one or the other is advantageous depending on the original code
base.`,Mo,We,Ka=`If the original code-base allows you to decompose the model into smaller sub-components, <em>e.g.</em> if the original
code-base can easily be run in eager mode, it is usually worth the effort to do so. There are some important advantages
to taking the more difficult road in the beginning:`,go,Be,er=`<li>at a later stage when comparing the original model to the Hugging Face implementation, you can verify automatically
for each component individually that the corresponding component of the 🤗 Transformers implementation matches instead
of relying on visual comparison via print statements</li> <li>it can give you some rope to decompose the big problem of porting a model into smaller problems of just porting
individual components and thus structure your work better</li> <li>separating the model into logical meaningful components will help you to get a better overview of the model’s design
and thus to better understand the model</li> <li>at a later stage those component-by-component tests help you to ensure that no regression occurs as you continue
changing your code</li>`,To,Re,tr=`<a href="https://gist.github.com/LysandreJik/db4c948f6b4483960de5cbac598ad4ed" rel="nofollow">Lysandre’s</a> integration checks for ELECTRA
gives a nice example of how this can be done.`,bo,ze,nr=`However, if the original code-base is very complex or only allows intermediate components to be run in a compiled mode,
it might be too time-consuming or even impossible to separate the model into smaller testable sub-components. A good
example is <a href="https://github.com/tensorflow/mesh/tree/master/mesh_tensorflow" rel="nofollow">T5’s MeshTensorFlow</a> library which is
very complex and does not offer a simple way to decompose the model into its sub-components. For such libraries, one
often relies on verifying print statements.`,vo,Pe,lr=`No matter which strategy you choose, the recommended procedure is often the same that you should start to debug the
starting layers first and the ending layers last.`,Jo,Ee,or=`It is recommended that you retrieve the output, either by print statements or sub-component functions, of the following
layers in the following order:`,jo,Ge,sr="<li>Retrieve the input IDs passed to the model</li> <li>Retrieve the word embeddings</li> <li>Retrieve the input of the first Transformer layer</li> <li>Retrieve the output of the first Transformer layer</li> <li>Retrieve the output of the following n - 1 Transformer layers</li> <li>Retrieve the output of the whole BrandNewBert Model</li>",Co,Qe,ir="Input IDs should thereby consists of an array of integers, <em>e.g.</em> <code>input_ids = [0, 4, 4, 3, 2, 4, 1, 7, 19]</code>",ko,Ve,ar="The outputs of the following layers often consist of multi-dimensional float arrays and can look like this:",Uo,De,_o,Ye,rr=`We expect that every model added to 🤗 Transformers passes a couple of integration tests, meaning that the original
model and the reimplemented version in 🤗 Transformers have to give the exact same output up to a precision of 0.001!
Since it is normal that the exact same model written in different libraries can give a slightly different output
depending on the library framework, we accept an error tolerance of 1e-3 (0.001). It is not enough if the model gives
nearly the same output, they have to be almost identical. Therefore, you will certainly compare the intermediate
outputs of the 🤗 Transformers version multiple times against the intermediate outputs of the original implementation of
<em>brand_new_bert</em> in which case an <strong>efficient</strong> debugging environment of the original repository is absolutely
important. Here is some advice to make your debugging environment as efficient as possible.`,Io,Fe,dr=`<li>Find the best way of debugging intermediate results. Is the original repository written in PyTorch? Then you should
probably take the time to write a longer script that decomposes the original model into smaller sub-components to
retrieve intermediate values. Is the original repository written in Tensorflow 1? Then you might have to rely on
TensorFlow print operations like <a href="https://www.tensorflow.org/api_docs/python/tf/print" rel="nofollow">tf.print</a> to output
intermediate values. Is the original repository written in Jax? Then make sure that the model is <strong>not jitted</strong> when
running the forward pass, <em>e.g.</em> check-out <a href="https://github.com/google/jax/issues/196" rel="nofollow">this link</a>.</li> <li>Use the smallest pretrained checkpoint you can find. The smaller the checkpoint, the faster your debug cycle
becomes. It is not efficient if your pretrained model is so big that your forward pass takes more than 10 seconds.
In case only very large checkpoints are available, it might make more sense to create a dummy model in the new
environment with randomly initialized weights and save those weights for comparison with the 🤗 Transformers version
of your model</li> <li>Make sure you are using the easiest way of calling a forward pass in the original repository. Ideally, you want to
find the function in the original repository that <strong>only</strong> calls a single forward pass, <em>i.e.</em> that is often called
<code>predict</code>, <code>evaluate</code>, <code>forward</code> or <code>__call__</code>. You don’t want to debug a function that calls <code>forward</code>
multiple times, <em>e.g.</em> to generate text, like <code>autoregressive_sample</code>, <code>generate</code>.</li> <li>Try to separate the tokenization from the model’s <em>forward</em> pass. If the original repository shows examples where
you have to input a string, then try to find out where in the forward call the string input is changed to input ids
and start from this point. This might mean that you have to possibly write a small script yourself or change the
original code so that you can directly input the ids instead of an input string.</li> <li>Make sure that the model in your debugging setup is <strong>not</strong> in training mode, which often causes the model to yield
random outputs due to multiple dropout layers in the model. Make sure that the forward pass in your debugging
environment is <strong>deterministic</strong> so that the dropout layers are not used. Or use <em>transformers.utils.set_seed</em>
if the old and new implementations are in the same framework.</li>`,xo,Se,mr="The following section gives you more specific details/tips on how you can do this for <em>brand_new_bert</em>.",$o,Xe,Lo,qe,pr="Next, you can finally start adding new code to 🤗 Transformers. Go into the clone of your 🤗 Transformers’ fork:",Ao,Oe,Ho,Ke,hr=`In the special case that you are adding a model whose architecture exactly matches the model architecture of an
existing model you only have to add a conversion script as described in <a href="#write-a-conversion-script">this section</a>.
In this case, you can just re-use the whole model architecture of the already existing model.`,Zo,et,ur=`Otherwise, let’s start generating a new model. We recommend using the following script to add a model starting from
an existing model:`,No,tt,Wo,nt,cr="You will be prompted with a questionnaire to fill in the basic information of your model.",Bo,lt,fr="<strong>Open a Pull Request on the main huggingface/transformers repo</strong>",Ro,ot,yr=`Before starting to adapt the automatically generated code, now is the time to open a “Work in progress (WIP)” pull
request, <em>e.g.</em> “[WIP] Add <em>brand_new_bert</em>”, in 🤗 Transformers so that you and the Hugging Face team can work
side-by-side on integrating the model into 🤗 Transformers.`,zo,st,wr="You should do the following:",Po,M,it,al,Mr="Create a branch with a descriptive name from your main branch",Vi,at,Di,rt,rl,gr="Commit the automatically generated code:",Yi,dt,Fi,mt,dl,Tr="Fetch and rebase to current main",Si,pt,Xi,ht,ml,br="Push the changes to your account using:",qi,ut,Oi,pl,vr=`<p>Once you are satisfied, go to the webpage of your fork on GitHub. Click on “Pull request”. Make sure to add the
GitHub handle of some members of the Hugging Face team as reviewers, so that the Hugging Face team gets notified for
future changes.</p>`,Ki,hl,Jr="<p>Change the PR into a draft by clicking on “Convert to draft” on the right of the GitHub pull request web page.</p>",Eo,ct,jr=`In the following, whenever you have made some progress, don’t forget to commit your work and push it to your account so
that it shows in the pull request. Additionally, you should make sure to update your work with the current main from
time to time by doing:`,Go,ft,Qo,yt,Cr=`In general, all questions you might have regarding the model or your implementation should be asked in your PR and
discussed/solved in the PR. This way, the Hugging Face team will always be notified when you are committing new code or
if you have a question. It is often very helpful to point the Hugging Face team to your added code so that the Hugging
Face team can efficiently understand your problem or question.`,Vo,wt,kr=`To do so, you can go to the “Files changed” tab where you see all of your changes, go to a line regarding which you
want to ask a question, and click on the “+” symbol to add a comment. Whenever a question or problem has been solved,
you can click on the “Resolve” button of the created comment.`,Do,Mt,Ur=`In the same way, the Hugging Face team will open comments when reviewing your code. We recommend asking most questions
on GitHub on your PR. For some very general questions that are not very useful for the public, feel free to ping the
Hugging Face team by Slack or email.`,Yo,gt,_r="<strong>5. Adapt the generated models code for brand_new_bert</strong>",Fo,Tt,Ir=`At first, we will focus only on the model itself and not care about the tokenizer. All the relevant code should be
found in the generated files <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> and
<code>src/transformers/models/brand_new_bert/configuration_brand_new_bert.py</code>.`,So,bt,xr=`Now you can finally start coding :). The generated code in
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> will either have the same architecture as BERT if
it’s an encoder-only model or BART if it’s an encoder-decoder model. At this point, you should remind yourself what
you’ve learned in the beginning about the theoretical aspects of the model: <em>How is the model different from BERT or
BART?</em>”. Implement those changes which often means changing the <em>self-attention</em> layer, the order of the normalization
layer, etc… Again, it is often useful to look at the similar architecture of already existing models in Transformers to
get a better feeling of how your model should be implemented.`,Xo,vt,$r=`<strong>Note</strong> that at this point, you don’t have to be very sure that your code is fully correct or clean. Rather, it is
advised to add a first <em>unclean</em>, copy-pasted version of the original code to
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> until you feel like all the necessary code is
added. From our experience, it is much more efficient to quickly add a first version of the required code and
improve/correct the code iteratively with the conversion script as described in the next section. The only thing that
has to work at this point is that you can instantiate the 🤗 Transformers implementation of <em>brand_new_bert</em>, <em>i.e.</em> the
following command should work:`,qo,Jt,Oo,jt,Lr=`The above command will create a model according to the default parameters as defined in <code>BrandNewBertConfig()</code> with
random weights, thus making sure that the <code>init()</code> methods of all components works.`,Ko,Ct,Ar=`Note that all random initialization should happen in the <code>_init_weights</code> method of your <code>BrandnewBertPreTrainedModel</code>
class. It should initialize all leaf modules depending on the variables of the config. Here is an example with the
BERT <code>_init_weights</code> method:`,es,kt,ts,Ut,Hr=`You can have some more custom schemes if you need a special initialization for some modules. For instance, in
<code>Wav2Vec2ForPreTraining</code>, the last two linear layers need to have the initialization of the regular PyTorch <code>nn.Linear</code>
but all the other ones should use an initialization as above. This is coded like this:`,ns,_t,ls,It,Zr=`The <code>_is_hf_initialized</code> flag is internally used to make sure we only initialize a submodule once. By setting it to
<code>True</code> for <code>module.project_q</code> and <code>module.project_hid</code>, we make sure the custom initialization we did is not overridden later on,
the <code>_init_weights</code> function won’t be applied to them.`,os,xt,Nr="<strong>6. Write a conversion script</strong>",ss,$t,Wr=`Next, you should write a conversion script that lets you convert the checkpoint you used to debug <em>brand_new_bert</em> in
the original repository to a checkpoint compatible with your just created 🤗 Transformers implementation of
<em>brand_new_bert</em>. It is not advised to write the conversion script from scratch, but rather to look through already
existing conversion scripts in 🤗 Transformers for one that has been used to convert a similar model that was written in
the same framework as <em>brand_new_bert</em>. Usually, it is enough to copy an already existing conversion script and
slightly adapt it for your use case. Don’t hesitate to ask the Hugging Face team to point you to a similar already
existing conversion script for your model.`,is,Lt,Br='<li>If you are porting a model from TensorFlow to PyTorch, a good starting point might be BERT’s conversion script <a href="https://github.com/huggingface/transformers/blob/7acfa95afb8194f8f9c1f4d2c6028224dbed35a2/src/transformers/models/bert/modeling_bert.py#L91" rel="nofollow">here</a></li> <li>If you are porting a model from PyTorch to PyTorch, a good starting point might be BART’s conversion script <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/bart/convert_bart_original_pytorch_checkpoint_to_pytorch.py" rel="nofollow">here</a></li>',as,At,Rr=`In the following, we’ll quickly explain how PyTorch models store layer weights and define layer names. In PyTorch, the
name of a layer is defined by the name of the class attribute you give the layer. Let’s define a dummy model in
PyTorch, called <code>SimpleModel</code> as follows:`,rs,Ht,ds,Zt,zr=`Now we can create an instance of this model definition which will fill all weights: <code>dense</code>, <code>intermediate</code>,
<code>layer_norm</code> with random weights. We can print the model to see its architecture`,ms,Nt,ps,Wt,Pr="This will print out the following:",hs,Bt,us,Rt,Er=`We can see that the layer names are defined by the name of the class attribute in PyTorch. You can print out the weight
values of a specific layer:`,cs,zt,fs,Pt,Gr="to see that the weights were randomly initialized",ys,Et,ws,Gt,Qr=`In the conversion script, you should fill those randomly initialized weights with the exact weights of the
corresponding layer in the checkpoint. <em>E.g.</em>`,Ms,Qt,gs,Vt,Vr=`While doing so, you must verify that each randomly initialized weight of your PyTorch model and its corresponding
pretrained checkpoint weight exactly match in both <strong>shape and name</strong>. To do so, it is <strong>necessary</strong> to add assert
statements for the shape and print out the names of the checkpoints weights. E.g. you should add statements like:`,Ts,Dt,bs,Yt,Dr="Besides, you should also print out the names of both weights to make sure they match, <em>e.g.</em>",vs,Ft,Js,St,Yr=`If either the shape or the name doesn’t match, you probably assigned the wrong checkpoint weight to a randomly
initialized layer of the 🤗 Transformers implementation.`,js,Xt,Fr=`An incorrect shape is most likely due to an incorrect setting of the config parameters in <code>BrandNewBertConfig()</code> that
do not exactly match those that were used for the checkpoint you want to convert. However, it could also be that
PyTorch’s implementation of a layer requires the weight to be transposed beforehand.`,Cs,qt,Sr=`Finally, you should also check that <strong>all</strong> required weights are initialized and print out all checkpoint weights that
were not used for initialization to make sure the model is correctly converted. It is completely normal, that the
conversion trials fail with either a wrong shape statement or a wrong name assignment. This is most likely because either
you used incorrect parameters in <code>BrandNewBertConfig()</code>, have a wrong architecture in the 🤗 Transformers
implementation, you have a bug in the <code>init()</code> functions of one of the components of the 🤗 Transformers
implementation or you need to transpose one of the checkpoint weights.`,ks,Ot,Xr=`This step should be iterated with the previous step until all weights of the checkpoint are correctly loaded in the
Transformers model. Having correctly loaded the checkpoint into the 🤗 Transformers implementation, you can then save
the model under a folder of your choice <code>/path/to/converted/checkpoint/folder</code> that should then contain both a
<code>pytorch_model.bin</code> file and a <code>config.json</code> file:`,Us,Kt,_s,en,qr="<strong>7. Implement the forward pass</strong>",Is,tn,Or=`Having managed to correctly load the pretrained weights into the 🤗 Transformers implementation, you should now make
sure that the forward pass is correctly implemented. In <a href="#3-4-run-a-pretrained-checkpoint-using-the-original-repository">Get familiar with the original repository</a>, you have already created a script that runs a forward
pass of the model using the original repository. Now you should write an analogous script using the 🤗 Transformers
implementation instead of the original one. It should look as follows:`,xs,nn,$s,ln,Kr=`It is very likely that the 🤗 Transformers implementation and the original model implementation don’t give the exact
same output the very first time or that the forward pass throws an error. Don’t be disappointed - it’s expected! First,
you should make sure that the forward pass doesn’t throw any errors. It often happens that the wrong dimensions are
used leading to a <em>Dimensionality mismatch</em> error or that the wrong data type object is used, <em>e.g.</em> <code>torch.long</code>
instead of <code>torch.float32</code>. Don’t hesitate to ask the Hugging Face team for help, if you don’t manage to solve
certain errors.`,Ls,on,ed=`The final part to make sure the 🤗 Transformers implementation works correctly is to ensure that the outputs are
equivalent to a precision of <code>1e-3</code>. First, you should ensure that the output shapes are identical, <em>i.e.</em> <code>outputs.shape</code> should yield the same value for the script of the 🤗 Transformers implementation and the original
implementation. Next, you should make sure that the output values are identical as well. This one of the most difficult
parts of adding a new model. Common mistakes why the outputs are not identical are:`,As,sn,td=`<li>Some layers were not added, <em>i.e.</em> an <em>activation</em> layer was not added, or the residual connection was forgotten</li> <li>The word embedding matrix was not tied</li> <li>The wrong positional embeddings are used because the original implementation uses on offset</li> <li>Dropout is applied during the forward pass. To fix this make sure <em>model.training is False</em> and that no dropout
layer is falsely activated during the forward pass, <em>i.e.</em> pass <em>self.training</em> to <a href="https://pytorch.org/docs/stable/nn.functional.html?highlight=dropout#torch.nn.functional.dropout" rel="nofollow">PyTorch’s functional dropout</a></li>`,Hs,an,nd=`The best way to fix the problem is usually to look at the forward pass of the original implementation and the 🤗
Transformers implementation side-by-side and check if there are any differences. Ideally, you should debug/print out
intermediate outputs of both implementations of the forward pass to find the exact position in the network where the 🤗
Transformers implementation shows a different output than the original implementation. First, make sure that the
hard-coded <code>input_ids</code> in both scripts are identical. Next, verify that the outputs of the first transformation of
the <code>input_ids</code> (usually the word embeddings) are identical. And then work your way up to the very last layer of the
network. At some point, you will notice a difference between the two implementations, which should point you to the bug
in the 🤗 Transformers implementation. From our experience, a simple and efficient way is to add many print statements
in both the original implementation and 🤗 Transformers implementation, at the same positions in the network
respectively, and to successively remove print statements showing the same values for intermediate presentations.`,Zs,rn,ld=`When you’re confident that both implementations yield the same output, verify the outputs with
<code>torch.allclose(original_output, output, atol=1e-3)</code>, you’re done with the most difficult part! Congratulations - the
work left to be done should be a cakewalk 😊.`,Ns,dn,od="<strong>8. Adding all necessary model tests</strong>",Ws,mn,sd=`At this point, you have successfully added a new model. However, it is very much possible that the model does not yet
fully comply with the required design. To make sure, the implementation is fully compatible with 🤗 Transformers, all
common tests should pass. The Cookiecutter should have automatically added a test file for your model, probably under
the same <code>tests/models/brand_new_bert/test_modeling_brand_new_bert.py</code>. Run this test file to verify that all common
tests pass:`,Bs,pn,Rs,hn,id="Having fixed all common tests, it is now crucial to ensure that all the nice work you have done is well tested, so that",zs,un,ad="<li>a) The community can easily understand your work by looking at specific tests of <em>brand_new_bert</em></li> <li>b) Future changes to your model will not break any important feature of the model.</li>",Ps,cn,rd=`At first, integration tests should be added. Those integration tests essentially do the same as the debugging scripts
you used earlier to implement the model to 🤗 Transformers. A template of those model tests has already added by the
Cookiecutter, called <code>BrandNewBertModelIntegrationTests</code> and only has to be filled out by you. To ensure that those
tests are passing, run`,Es,fn,Gs,U,Qs,yn,dd=`Second, all features that are special to <em>brand_new_bert</em> should be tested additionally in a separate test under
<code>BrandNewBertModelTester</code>/<code>BrandNewBertModelTest</code>. This part is often forgotten but is extremely useful in two
ways:`,Vs,wn,md=`<li>It helps to transfer the knowledge you have acquired during the model addition to the community by showing how the
special features of <em>brand_new_bert</em> should work.</li> <li>Future contributors can quickly test changes to the model by running those special tests.</li>`,Ds,Mn,pd="<strong>9. Implement the tokenizer</strong>",Ys,gn,hd=`Next, we should add the tokenizer of <em>brand_new_bert</em>. Usually, the tokenizer is equivalent to or very similar to an
already existing tokenizer of 🤗 Transformers.`,Fs,Tn,ud=`It is very important to find/extract the original tokenizer file and to manage to load this file into the 🤗
Transformers’ implementation of the tokenizer.`,Ss,bn,cd=`To ensure that the tokenizer works correctly, it is recommended to first create a script in the original repository
that inputs a string and returns the <code>input_ids</code>. It could look similar to this (in pseudo-code):`,Xs,vn,qs,Jn,fd=`You might have to take a deeper look again into the original repository to find the correct tokenizer function or you
might even have to do changes to your clone of the original repository to only output the <code>input_ids</code>. Having written
a functional tokenization script that uses the original repository, an analogous script for 🤗 Transformers should be
created. It should look similar to this:`,Os,jn,Ks,Cn,yd="When both <code>input_ids</code> yield the same values, as a final step a tokenizer test file should also be added.",ei,kn,wd=`Analogous to the modeling test files of <em>brand_new_bert</em>, the tokenization test files of <em>brand_new_bert</em> should
contain a couple of hard-coded integration tests.`,ti,Un,Md="<strong>10. Run End-to-end integration tests</strong>",ni,_n,gd=`Having added the tokenizer, you should also add a couple of end-to-end integration tests using both the model and the
tokenizer to <code>tests/models/brand_new_bert/test_modeling_brand_new_bert.py</code> in 🤗 Transformers.
Such a test should show on a meaningful
text-to-text sample that the 🤗 Transformers implementation works as expected. A meaningful text-to-text sample can
include <em>e.g.</em> a source-to-target-translation pair, an article-to-summary pair, a question-to-answer pair, etc… If none
of the ported checkpoints has been fine-tuned on a downstream task it is enough to simply rely on the model tests. In a
final step to ensure that the model is fully functional, it is advised that you also run all tests on GPU. It can
happen that you forgot to add some <code>.to(self.device)</code> statements to internal tensors of the model, which in such a
test would show in an error. In case you have no access to a GPU, the Hugging Face team can take care of running those
tests for you.`,li,In,Td="<strong>11. Add Docstring</strong>",oi,xn,bd=`Now, all the necessary functionality for <em>brand_new_bert</em> is added - you’re almost done! The only thing left to add is
a nice docstring and a doc page. The Cookiecutter should have added a template file called
<code>docs/source/model_doc/brand_new_bert.md</code> that you should fill out. Users of your model will usually first look at
this page before using your model. Hence, the documentation must be understandable and concise. It is very useful for
the community to add some <em>Tips</em> to show how the model should be used. Don’t hesitate to ping the Hugging Face team
regarding the docstrings.`,si,$n,vd=`Next, make sure that the docstring added to <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> is
correct and included all necessary inputs and outputs. We have a detailed guide about writing documentation and our docstring format <a href="writing-documentation">here</a>. It is always good to remind oneself that documentation should
be treated at least as carefully as the code in 🤗 Transformers since the documentation is usually the first contact
point of the community with the model.`,ii,Ln,Jd="<strong>Code refactor</strong>",ai,An,jd=`Great, now you have added all the necessary code for <em>brand_new_bert</em>. At this point, you should correct some potential
incorrect code style by running:`,ri,Hn,di,Zn,Cd="and verify that your coding style passes the quality check:",mi,Nn,pi,Wn,kd=`There are a couple of other very strict design tests in 🤗 Transformers that might still be failing, which shows up in
the tests of your pull request. This is often because of some missing information in the docstring or some incorrect
naming. The Hugging Face team will surely help you if you’re stuck here.`,hi,Bn,Ud=`Lastly, it is always a good idea to refactor one’s code after having ensured that the code works correctly. With all
tests passing, now it’s a good time to go over the added code again and do some refactoring.`,ui,Rn,_d="You have now finished the coding part, congratulation! 🎉 You are Awesome! 😎",ci,zn,Id="<strong>12. Upload the models to the model hub</strong>",fi,Pn,xd=`In this final part, you should convert and upload all checkpoints to the model hub and add a model card for each
uploaded model checkpoint. You can get familiar with the hub functionalities by reading our <a href="model_sharing">Model sharing and uploading Page</a>. You should work alongside the Hugging Face team here to decide on a fitting name for each
checkpoint and to get the required access rights to be able to upload the model under the author’s organization of
<em>brand_new_bert</em>. The <code>push_to_hub</code> method, present in all models in <code>transformers</code>, is a quick and efficient way to push your checkpoint to the hub. A little snippet is pasted below:`,yi,En,wi,Gn,$d=`It is worth spending some time to create fitting model cards for each checkpoint. The model cards should highlight the
specific characteristics of this particular checkpoint, <em>e.g.</em> On which dataset was the checkpoint
pretrained/fine-tuned on? On what down-stream task should the model be used? And also include some code on how to
correctly use the model.`,Mi,Qn,Ld="<strong>13. (Optional) Add notebook</strong>",gi,Vn,Ad=`It is very helpful to add a notebook that showcases in-detail how <em>brand_new_bert</em> can be used for inference and/or
fine-tuned on a downstream task. This is not mandatory to merge your PR, but very useful for the community.`,Ti,Dn,Hd="<strong>14. Submit your finished PR</strong>",bi,Yn,Zd=`You’re done programming now and can move to the last step, which is getting your PR merged into main. Usually, the
Hugging Face team should have helped you already at this point, but it is worth taking some time to give your finished
PR a nice description and eventually add comments to your code, if you want to point out certain design choices to your
reviewer.`,vi,Fn,Ji,Sn,Nd=`Now, it’s time to get some credit from the community for your work! Having completed a model addition is a major
contribution to Transformers and the whole NLP community. Your code and the ported pre-trained models will certainly be
used by hundreds and possibly even thousands of developers and researchers. You should be proud of your work and share
your achievements with the community.`,ji,Xn,Wd="<strong>You have made another model that is super easy to access for everyone in the community! 🤯</strong>",Ci,qn,ki,ul,Ui;return I=new k({props:{title:"How to add a model to 🤗 Transformers?",local:"how-to-add-a-model-to--transformers",headingTag:"h1"}}),N=new k({props:{title:"General overview of 🤗 Transformers",local:"general-overview-of--transformers",headingTag:"h2"}}),E=new k({props:{title:"Overview of models",local:"overview-of-models",headingTag:"h3"}}),D=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYnJhbmR5JTJGYnJhbmRfbmV3X2JlcnQlMjIpJTBBbW9kZWwuY29uZmlnJTIwJTIwJTIzJTIwbW9kZWwlMjBoYXMlMjBhY2Nlc3MlMjB0byUyMGl0cyUyMGNvbmZpZw==",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;brandy/brand_new_bert&quot;</span>)
model.config  <span class="hljs-comment"># model has access to its config</span>`,wrap:!1}}),F=new k({props:{title:"Code style",local:"code-style",headingTag:"h3"}}),q=new k({props:{title:"Overview of tokenizers",local:"overview-of-tokenizers",headingTag:"h3"}}),K=new k({props:{title:"Step-by-step recipe to add a model to 🤗 Transformers",local:"step-by-step-recipe-to-add-a-model-to--transformers",headingTag:"h2"}}),re=new k({props:{title:"1. (Optional) Theoretical aspects of BrandNewBert",local:"1-optional-theoretical-aspects-of-brandnewbert",headingTag:"h3"}}),he=new k({props:{title:"2. Next prepare your environment",local:"2-next-prepare-your-environment",headingTag:"h3"}}),ce=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkYlNUJ5b3VyJTIwR2l0aHViJTIwaGFuZGxlJTVEJTJGdHJhbnNmb3JtZXJzLmdpdCUwQWNkJTIwdHJhbnNmb3JtZXJzJTBBZ2l0JTIwcmVtb3RlJTIwYWRkJTIwdXBzdHJlYW0lMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQ=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/[your Github handle]/transformers.git
<span class="hljs-built_in">cd</span> transformers
git remote add upstream https://github.com/huggingface/transformers.git`,wrap:!1}}),fe=new y({props:{code:"cHl0aG9uJTIwLW0lMjB2ZW52JTIwLmVudiUwQXNvdXJjZSUyMC5lbnYlMkZiaW4lMkZhY3RpdmF0ZSUwQXBpcCUyMGluc3RhbGwlMjAtZSUyMCUyMi4lNUJkZXYlNUQlMjI=",highlighted:`python -m venv .<span class="hljs-built_in">env</span>
<span class="hljs-built_in">source</span> .<span class="hljs-built_in">env</span>/bin/activate
pip install -e <span class="hljs-string">&quot;.[dev]&quot;</span>`,wrap:!1}}),ye=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QnF1YWxpdHklNUQlMjI=",highlighted:'pip install -e <span class="hljs-string">&quot;.[quality]&quot;</span>',wrap:!1}}),we=new y({props:{code:"Y2QlMjAuLg==",highlighted:'<span class="hljs-built_in">cd</span> ..',wrap:!1}}),ge=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZvcmdfdGhhdF9jcmVhdGVkX2JyYW5kX25ld19iZXJ0X29yZyUyRmJyYW5kX25ld19iZXJ0LmdpdCUwQWNkJTIwYnJhbmRfbmV3X2JlcnQlMEFwaXAlMjBpbnN0YWxsJTIwLWUlMjAu",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/org_that_created_brand_new_bert_org/brand_new_bert.git
<span class="hljs-built_in">cd</span> brand_new_bert
pip install -e .`,wrap:!1}}),be=new k({props:{title:"3.-4. Run a pretrained checkpoint using the original repository",local:"3-4-run-a-pretrained-checkpoint-using-the-original-repository",headingTag:"h3"}}),Ae=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5sb2FkX3ByZXRyYWluZWRfY2hlY2twb2ludCglMjIlMkZwYXRoJTJGdG8lMkZjaGVja3BvaW50JTJGJTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMCU1QjAlMkMlMjA0JTJDJTIwNSUyQyUyMDIlMkMlMjAzJTJDJTIwNyUyQyUyMDklNUQlMjAlMjAlMjMlMjB2ZWN0b3IlMjBvZiUyMGlucHV0JTIwaWRzJTBBb3JpZ2luYWxfb3V0cHV0JTIwJTNEJTIwbW9kZWwucHJlZGljdChpbnB1dF9pZHMp",highlighted:`model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">7</span>, <span class="hljs-number">9</span>]  <span class="hljs-comment"># vector of input ids</span>
original_output = model.predict(input_ids)`,wrap:!1}}),De=new y({props:{code:"JTVCJTVCJTBBJTIwJTVCLTAuMTQ2NSUyQyUyMC0wLjY1MDElMkMlMjAlMjAwLjE5OTMlMkMlMjAlMjAuLi4lMkMlMjAlMjAwLjE0NTElMkMlMjAlMjAwLjM0MzAlMkMlMjAlMjAwLjYwMjQlNUQlMkMlMEElMjAlNUItMC40NDE3JTJDJTIwLTAuNTkyMCUyQyUyMCUyMDAuMzQ1MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjMwNjIlMkMlMjAlMjAwLjYxODIlMkMlMjAlMjAwLjcxMzIlNUQlMkMlMEElMjAlNUItMC41MDA5JTJDJTIwLTAuNzEyMiUyQyUyMCUyMDAuNDU0OCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM2NjIlMkMlMjAlMjAwLjYwOTElMkMlMjAlMjAwLjc2NDglNUQlMkMlMEElMjAuLi4lMkMlMEElMjAlNUItMC41NjEzJTJDJTIwLTAuNjMzMiUyQyUyMCUyMDAuNDMyNCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM3OTIlMkMlMjAlMjAwLjczNzIlMkMlMjAlMjAwLjkyODglNUQlMkMlMEElMjAlNUItMC41NDE2JTJDJTIwLTAuNjM0NSUyQyUyMCUyMDAuNDE4MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM1NjQlMkMlMjAlMjAwLjY5OTIlMkMlMjAlMjAwLjkxOTElNUQlMkMlMEElMjAlNUItMC41MzM0JTJDJTIwLTAuNjQwMyUyQyUyMCUyMDAuNDI3MSUyQyUyMCUyMC4uLiUyQyUyMC0wLjMzMzklMkMlMjAlMjAwLjY1MzMlMkMlMjAlMjAwLjg2OTQlNUQlNUQlNUQlMkM=",highlighted:`<span class="hljs-comment">[<span class="hljs-comment">[
 <span class="hljs-comment">[-0.1465, -0.6501,  0.1993,  ...,  0.1451,  0.3430,  0.6024]</span>,
 <span class="hljs-comment">[-0.4417, -0.5920,  0.3450,  ..., -0.3062,  0.6182,  0.7132]</span>,
 <span class="hljs-comment">[-0.5009, -0.7122,  0.4548,  ..., -0.3662,  0.6091,  0.7648]</span>,
 ...,
 <span class="hljs-comment">[-0.5613, -0.6332,  0.4324,  ..., -0.3792,  0.7372,  0.9288]</span>,
 <span class="hljs-comment">[-0.5416, -0.6345,  0.4180,  ..., -0.3564,  0.6992,  0.9191]</span>,
 <span class="hljs-comment">[-0.5334, -0.6403,  0.4271,  ..., -0.3339,  0.6533,  0.8694]</span>]</span>]</span>,`,wrap:!1}}),Xe=new k({props:{title:"5.-14. Port BrandNewBert to 🤗 Transformers",local:"5-14-port-brandnewbert-to--transformers",headingTag:"h3"}}),Oe=new y({props:{code:"Y2QlMjB0cmFuc2Zvcm1lcnM=",highlighted:'<span class="hljs-built_in">cd</span> transformers',wrap:!1}}),tt=new y({props:{code:"dHJhbnNmb3JtZXJzLWNsaSUyMGFkZC1uZXctbW9kZWwtbGlrZQ==",highlighted:"transformers-cli add-new-model-like",wrap:!1}}),at=new y({props:{code:"Z2l0JTIwY2hlY2tvdXQlMjAtYiUyMGFkZF9icmFuZF9uZXdfYmVydA==",highlighted:"git checkout -b add_brand_new_bert",wrap:!1}}),dt=new y({props:{code:"Z2l0JTIwYWRkJTIwLiUwQWdpdCUyMGNvbW1pdA==",highlighted:`git add .
git commit`,wrap:!1}}),pt=new y({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMHJlYmFzZSUyMHVwc3RyZWFtJTJGbWFpbg==",highlighted:`git fetch upstream
git rebase upstream/main`,wrap:!1}}),ut=new y({props:{code:"Z2l0JTIwcHVzaCUyMC11JTIwb3JpZ2luJTIwYS1kZXNjcmlwdGl2ZS1uYW1lLWZvci1teS1jaGFuZ2Vz",highlighted:"git push -u origin a-descriptive-name-for-my-changes",wrap:!1}}),ft=new y({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMG1lcmdlJTIwdXBzdHJlYW0lMkZtYWlu",highlighted:`git fetch upstream
git merge upstream/main`,wrap:!1}}),Jt=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydE1vZGVsJTJDJTIwQnJhbmROZXdCZXJ0Q29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbChCcmFuZE5ld0JlcnRDb25maWcoKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertModel, BrandNewBertConfig

model = BrandNewBertModel(BrandNewBertConfig())`,wrap:!1}}),kt=new y({props:{code:"ZGVmJTIwX2luaXRfd2VpZ2h0cyhzZWxmJTJDJTIwbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkluaXRpYWxpemUlMjB0aGUlMjB3ZWlnaHRzJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkxpbmVhciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEubm9ybWFsXyhtZWFuJTNEMC4wJTJDJTIwc3RkJTNEc2VsZi5jb25maWcuaW5pdGlhbGl6ZXJfcmFuZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtb2R1bGUuYmlhcyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZHVsZS5iaWFzLmRhdGEuemVyb18oKSUwQSUyMCUyMCUyMCUyMGVsaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkVtYmVkZGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEubm9ybWFsXyhtZWFuJTNEMC4wJTJDJTIwc3RkJTNEc2VsZi5jb25maWcuaW5pdGlhbGl6ZXJfcmFuZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtb2R1bGUucGFkZGluZ19pZHglMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGElNUJtb2R1bGUucGFkZGluZ19pZHglNUQuemVyb18oKSUwQSUyMCUyMCUyMCUyMGVsaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkxheWVyTm9ybSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUuYmlhcy5kYXRhLnplcm9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEuZmlsbF8oMS4wKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_init_weights</span>(<span class="hljs-params">self, module</span>):
    <span class="hljs-string">&quot;&quot;&quot;Initialize the weights&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(module, nn.Linear):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.bias <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.bias.data.zero_()
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.Embedding):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.padding_idx <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.weight.data[module.padding_idx].zero_()
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.LayerNorm):
        module.bias.data.zero_()
        module.weight.data.fill_(<span class="hljs-number">1.0</span>)`,wrap:!1}}),_t=new y({props:{code:"ZGVmJTIwX2luaXRfd2VpZ2h0cyhzZWxmJTJDJTIwbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkluaXRpYWxpemUlMjB0aGUlMjB3ZWlnaHRzJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMFdhdjJWZWMyRm9yUHJlVHJhaW5pbmcpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLnByb2plY3RfaGlkLnJlc2V0X3BhcmFtZXRlcnMoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZHVsZS5wcm9qZWN0X3EucmVzZXRfcGFyYW1ldGVycygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLnByb2plY3RfaGlkLl9pc19oZl9pbml0aWFsaXplZCUyMCUzRCUyMFRydWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUucHJvamVjdF9xLl9pc19oZl9pbml0aWFsaXplZCUyMCUzRCUyMFRydWUlMEElMjAlMjAlMjAlMjBlbGlmJTIwaXNpbnN0YW5jZShtb2R1bGUlMkMlMjBubi5MaW5lYXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLndlaWdodC5kYXRhLm5vcm1hbF8obWVhbiUzRDAuMCUyQyUyMHN0ZCUzRHNlbGYuY29uZmlnLmluaXRpYWxpemVyX3JhbmdlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbW9kdWxlLmJpYXMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUuYmlhcy5kYXRhLnplcm9fKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_init_weights</span>(<span class="hljs-params">self, module</span>):
    <span class="hljs-string">&quot;&quot;&quot;Initialize the weights&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(module, Wav2Vec2ForPreTraining):
        module.project_hid.reset_parameters()
        module.project_q.reset_parameters()
        module.project_hid._is_hf_initialized = <span class="hljs-literal">True</span>
        module.project_q._is_hf_initialized = <span class="hljs-literal">True</span>
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.Linear):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.bias <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.bias.data.zero_()`,wrap:!1}}),Ht=new y({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyMFNpbXBsZU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZGVuc2UlMjAlM0QlMjBubi5MaW5lYXIoMTAlMkMlMjAxMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmludGVybWVkaWF0ZSUyMCUzRCUyMG5uLkxpbmVhcigxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXJfbm9ybSUyMCUzRCUyMG5uLkxheWVyTm9ybSgxMCk=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">SimpleModel</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.dense = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.intermediate = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.layer_norm = nn.LayerNorm(<span class="hljs-number">10</span>)`,wrap:!1}}),Nt=new y({props:{code:"bW9kZWwlMjAlM0QlMjBTaW1wbGVNb2RlbCgpJTBBJTBBcHJpbnQobW9kZWwp",highlighted:`model = SimpleModel()

<span class="hljs-built_in">print</span>(model)`,wrap:!1}}),Bt=new y({props:{code:"U2ltcGxlTW9kZWwoJTBBJTIwJTIwKGRlbnNlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAoaW50ZXJtZWRpYXRlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAobGF5ZXJfbm9ybSklM0ElMjBMYXllck5vcm0oKDEwJTJDKSUyQyUyMGVwcyUzRDFlLTA1JTJDJTIwZWxlbWVudHdpc2VfYWZmaW5lJTNEVHJ1ZSklMEEp",highlighted:`SimpleModel(
  (dense): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (intermediate): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (layer_norm): LayerNorm((10,), <span class="hljs-attribute">eps</span>=1e-05, <span class="hljs-attribute">elementwise_affine</span>=<span class="hljs-literal">True</span>)
)`,wrap:!1}}),zt=new y({props:{code:"cHJpbnQobW9kZWwuZGVuc2Uud2VpZ2h0LmRhdGEp",highlighted:'<span class="hljs-built_in">print</span>(model.dense.weight.data)',wrap:!1}}),Et=new y({props:{code:"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",highlighted:`tensor([[<span class="hljs-string">-0</span>.0818,  0.2207, <span class="hljs-string">-0</span>.0749, <span class="hljs-string">-0</span>.0030,  0.0045, <span class="hljs-string">-0</span>.1569, <span class="hljs-string">-0</span>.1598,  0.0212,
         <span class="hljs-string">-0</span>.2077,  0.2157],
        [ 0.1044,  0.0201,  0.0990,  0.2482,  0.3116,  0.2509,  0.2866, <span class="hljs-string">-0</span>.2190,
          0.2166, <span class="hljs-string">-0</span>.0212],
        [<span class="hljs-string">-0</span>.2000,  0.1107, <span class="hljs-string">-0</span>.1999, <span class="hljs-string">-0</span>.3119,  0.1559,  0.0993,  0.1776, <span class="hljs-string">-0</span>.1950,
         <span class="hljs-string">-0</span>.1023, <span class="hljs-string">-0</span>.0447],
        [<span class="hljs-string">-0</span>.0888, <span class="hljs-string">-0</span>.1092,  0.2281,  0.0336,  0.1817, <span class="hljs-string">-0</span>.0115,  0.2096,  0.1415,
         <span class="hljs-string">-0</span>.1876, <span class="hljs-string">-0</span>.2467],
        [ 0.2208, <span class="hljs-string">-0</span>.2352, <span class="hljs-string">-0</span>.1426, <span class="hljs-string">-0</span>.2636, <span class="hljs-string">-0</span>.2889, <span class="hljs-string">-0</span>.2061, <span class="hljs-string">-0</span>.2849, <span class="hljs-string">-0</span>.0465,
          0.2577,  0.0402],
        [ 0.1502,  0.2465,  0.2566,  0.0693,  0.2352, <span class="hljs-string">-0</span>.0530,  0.1859, <span class="hljs-string">-0</span>.0604,
          0.2132,  0.1680],
        [ 0.1733, <span class="hljs-string">-0</span>.2407, <span class="hljs-string">-0</span>.1721,  0.1484,  0.0358, <span class="hljs-string">-0</span>.0633, <span class="hljs-string">-0</span>.0721, <span class="hljs-string">-0</span>.0090,
          0.2707, <span class="hljs-string">-0</span>.2509],
        [<span class="hljs-string">-0</span>.1173,  0.1561,  0.2945,  0.0595, <span class="hljs-string">-0</span>.1996,  0.2988, <span class="hljs-string">-0</span>.0802,  0.0407,
          0.1829, <span class="hljs-string">-0</span>.1568],
        [<span class="hljs-string">-0</span>.1164, <span class="hljs-string">-0</span>.2228, <span class="hljs-string">-0</span>.0403,  0.0428,  0.1339,  0.0047,  0.1967,  0.2923,
          0.0333, <span class="hljs-string">-0</span>.0536],
        [<span class="hljs-string">-0</span>.1492, <span class="hljs-string">-0</span>.1616,  0.1057,  0.1950, <span class="hljs-string">-0</span>.2807, <span class="hljs-string">-0</span>.2710, <span class="hljs-string">-0</span>.1586,  0.0739,
          0.2220,  0.2358]]).`,wrap:!1}}),Qt=new y({props:{code:"JTIzJTIwcmV0cmlldmUlMjBtYXRjaGluZyUyMGxheWVyJTIwd2VpZ2h0cyUyQyUyMGUuZy4lMjBieSUwQSUyMyUyMHJlY3Vyc2l2ZSUyMGFsZ29yaXRobSUwQWxheWVyX25hbWUlMjAlM0QlMjAlMjJkZW5zZSUyMiUwQXByZXRyYWluZWRfd2VpZ2h0JTIwJTNEJTIwYXJyYXlfb2ZfZGVuc2VfbGF5ZXIlMEElMEFtb2RlbF9wb2ludGVyJTIwJTNEJTIwZ2V0YXR0cihtb2RlbCUyQyUyMCUyMmRlbnNlJTIyKSUwQSUwQW1vZGVsX3BvaW50ZXIud2VpZ2h0LmRhdGElMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHByZXRyYWluZWRfd2VpZ2h0KQ==",highlighted:`<span class="hljs-comment"># retrieve matching layer weights, e.g. by</span>
<span class="hljs-comment"># recursive algorithm</span>
layer_name = <span class="hljs-string">&quot;dense&quot;</span>
pretrained_weight = array_of_dense_layer

model_pointer = <span class="hljs-built_in">getattr</span>(model, <span class="hljs-string">&quot;dense&quot;</span>)

model_pointer.weight.data = torch.from_numpy(pretrained_weight)`,wrap:!1}}),Dt=new y({props:{code:"YXNzZXJ0JTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsX3BvaW50ZXIud2VpZ2h0LnNoYXBlJTIwJTNEJTNEJTIwcHJldHJhaW5lZF93ZWlnaHQuc2hhcGUlMEEpJTJDJTIwZiUyMlBvaW50ZXIlMjBzaGFwZSUyMG9mJTIwcmFuZG9tJTIwd2VpZ2h0JTIwJTdCbW9kZWxfcG9pbnRlci5zaGFwZSU3RCUyMGFuZCUyMGFycmF5JTIwc2hhcGUlMjBvZiUyMGNoZWNrcG9pbnQlMjB3ZWlnaHQlMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5zaGFwZSU3RCUyMG1pc21hdGNoZWQlMjI=",highlighted:`<span class="hljs-keyword">assert</span> (
    model_pointer.weight.shape == pretrained_weight.shape
), <span class="hljs-string">f&quot;Pointer shape of random weight <span class="hljs-subst">{model_pointer.shape}</span> and array shape of checkpoint weight <span class="hljs-subst">{pretrained_weight.shape}</span> mismatched&quot;</span>`,wrap:!1}}),Ft=new y({props:{code:"bG9nZ2VyLmluZm8oZiUyMkluaXRpYWxpemUlMjBQeVRvcmNoJTIwd2VpZ2h0JTIwJTdCbGF5ZXJfbmFtZSU3RCUyMGZyb20lMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5uYW1lJTdEJTIyKQ==",highlighted:'logger.info(<span class="hljs-string">f&quot;Initialize PyTorch weight <span class="hljs-subst">{layer_name}</span> from <span class="hljs-subst">{pretrained_weight.name}</span>&quot;</span>)',wrap:!1}}),Kt=new y({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmNvbnZlcnRlZCUyRmNoZWNrcG9pbnQlMkZmb2xkZXIlMjIp",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)',wrap:!1}}),nn=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyJTJGcGF0aCUyRnRvJTJGY29udmVydGVkJTJGY2hlY2twb2ludCUyRmZvbGRlciUyMiklMEFpbnB1dF9pZHMlMjAlM0QlMjAlNUIwJTJDJTIwNCUyQyUyMDQlMkMlMjAzJTJDJTIwMiUyQyUyMDQlMkMlMjAxJTJDJTIwNyUyQyUyMDE5JTVEJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzKS5sYXN0X2hpZGRlbl9zdGF0ZXM=",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1</span>, <span class="hljs-number">7</span>, <span class="hljs-number">19</span>]
output = model(input_ids).last_hidden_states`,wrap:!1}}),pn=new y({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZtb2RlbHMlMkZicmFuZF9uZXdfYmVydCUyRnRlc3RfbW9kZWxpbmdfYnJhbmRfbmV3X2JlcnQucHk=",highlighted:"pytest tests/models/brand_new_bert/test_modeling_brand_new_bert.py",wrap:!1}}),fn=new y({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwLXN2JTIwdGVzdHMlMkZtb2RlbHMlMkZicmFuZF9uZXdfYmVydCUyRnRlc3RfbW9kZWxpbmdfYnJhbmRfbmV3X2JlcnQucHklM0ElM0FCcmFuZE5ld0JlcnRNb2RlbEludGVncmF0aW9uVGVzdHM=",highlighted:"RUN_SLOW=1 pytest -sv tests/models/brand_new_bert/test_modeling_brand_new_bert.py::BrandNewBertModelIntegrationTests",wrap:!1}}),U=new Vd({props:{$$slots:{default:[Yd]},$$scope:{ctx:cl}}}),vn=new y({props:{code:"aW5wdXRfc3RyJTIwJTNEJTIwJTIyVGhpcyUyMGlzJTIwYSUyMGxvbmclMjBleGFtcGxlJTIwaW5wdXQlMjBzdHJpbmclMjBjb250YWluaW5nJTIwc3BlY2lhbCUyMGNoYXJhY3RlcnMlMjAuJTI0JTNGLSUyQyUyMG51bWJlcnMlMjAyODcyJTIwMjM0JTIwMTIlMjBhbmQlMjB3b3Jkcy4lMjIlMEFtb2RlbCUyMCUzRCUyMEJyYW5kTmV3QmVydE1vZGVsLmxvYWRfcHJldHJhaW5lZF9jaGVja3BvaW50KCUyMiUyRnBhdGglMkZ0byUyRmNoZWNrcG9pbnQlMkYlMjIpJTBBaW5wdXRfaWRzJTIwJTNEJTIwbW9kZWwudG9rZW5pemUoaW5wdXRfc3RyKQ==",highlighted:`input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>
model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = model.tokenize(input_str)`,wrap:!1}}),jn=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydFRva2VuaXplciUwQSUwQWlucHV0X3N0ciUyMCUzRCUyMCUyMlRoaXMlMjBpcyUyMGElMjBsb25nJTIwZXhhbXBsZSUyMGlucHV0JTIwc3RyaW5nJTIwY29udGFpbmluZyUyMHNwZWNpYWwlMjBjaGFyYWN0ZXJzJTIwLiUyNCUzRi0lMkMlMjBudW1iZXJzJTIwMjg3MiUyMDIzNCUyMDEyJTIwYW5kJTIwd29yZHMuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQnJhbmROZXdCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIlMkZwYXRoJTJGdG8lMkZ0b2tlbml6ZXIlMkZmb2xkZXIlMkYlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cikuaW5wdXRfaWRz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertTokenizer

input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>

tokenizer = BrandNewBertTokenizer.from_pretrained(<span class="hljs-string">&quot;/path/to/tokenizer/folder/&quot;</span>)

input_ids = tokenizer(input_str).input_ids`,wrap:!1}}),Hn=new y({props:{code:"bWFrZSUyMHN0eWxl",highlighted:"make style",wrap:!1}}),Nn=new y({props:{code:"bWFrZSUyMHF1YWxpdHk=",highlighted:"make quality",wrap:!1}}),En=new y({props:{code:"YnJhbmRfbmV3X2JlcnQucHVzaF90b19odWIoJTIyYnJhbmRfbmV3X2JlcnQlMjIpJTBBJTIzJTIwVW5jb21tZW50JTIwdGhlJTIwZm9sbG93aW5nJTIwbGluZSUyMHRvJTIwcHVzaCUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24uJTBBJTIzJTIwYnJhbmRfbmV3X2JlcnQucHVzaF90b19odWIoJTIyJTNDb3JnYW5pemF0aW9uJTNFJTJGYnJhbmRfbmV3X2JlcnQlMjIp",highlighted:`brand_new_bert.push_to_hub(<span class="hljs-string">&quot;brand_new_bert&quot;</span>)
<span class="hljs-comment"># Uncomment the following line to push to an organization.</span>
<span class="hljs-comment"># brand_new_bert.push_to_hub(&quot;&lt;organization&gt;/brand_new_bert&quot;)</span>`,wrap:!1}}),Fn=new k({props:{title:"Share your work!!",local:"share-your-work",headingTag:"h3"}}),qn=new Dd({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/add_new_model.md"}}),{c(){w=i("meta"),_=o(),j=i("p"),On=o(),d(I.$$.fragment),fl=o(),x=i("p"),x.innerHTML=ta,yl=o(),$=i("p"),$.textContent=na,wl=o(),L=i("ul"),L.innerHTML=la,Ml=o(),A=i("p"),A.textContent=oa,gl=o(),H=i("p"),H.innerHTML=sa,Tl=o(),Z=i("p"),Z.textContent=ia,bl=o(),d(N.$$.fragment),vl=o(),W=i("p"),W.textContent=aa,Jl=o(),B=i("p"),B.innerHTML=ra,jl=o(),R=i("ul"),R.innerHTML=da,Cl=o(),z=i("p"),z.innerHTML=ma,kl=o(),P=i("p"),P.textContent=pa,Ul=o(),d(E.$$.fragment),_l=o(),G=i("p"),G.innerHTML=ha,Il=o(),Q=i("p"),Q.textContent=ua,xl=o(),Kn=i("img"),$l=o(),V=i("p"),V.innerHTML=fa,Ll=o(),d(D.$$.fragment),Al=o(),Y=i("p"),Y.innerHTML=ya,Hl=o(),d(F.$$.fragment),Zl=o(),S=i("p"),S.textContent=wa,Nl=o(),X=i("ol"),X.innerHTML=Ma,Wl=o(),d(q.$$.fragment),Bl=o(),O=i("p"),O.textContent=ga,Rl=o(),d(K.$$.fragment),zl=o(),ee=i("p"),ee.textContent=Ta,Pl=o(),te=i("ol"),te.innerHTML=ba,El=o(),ne=i("p"),ne.textContent=va,Gl=o(),le=i("ul"),le.innerHTML=Ja,Ql=o(),oe=i("p"),oe.textContent=ja,Vl=o(),se=i("p"),se.textContent=Ca,Dl=o(),ie=i("p"),ie.innerHTML=ka,Yl=o(),ae=i("p"),ae.innerHTML=Ua,Fl=o(),d(re.$$.fragment),Sl=o(),de=i("p"),de.innerHTML=_a,Xl=o(),me=i("ul"),me.innerHTML=Ia,ql=o(),pe=i("p"),pe.textContent=xa,Ol=o(),d(he.$$.fragment),Kl=o(),T=i("ol"),el=i("li"),el.innerHTML=$a,Hi=o(),ue=i("li"),tl=i("p"),tl.innerHTML=La,Zi=o(),d(ce.$$.fragment),Ni=o(),g=i("li"),nl=i("p"),nl.textContent=Aa,Wi=o(),d(fe.$$.fragment),Bi=o(),ll=i("p"),ll.textContent=Ha,Ri=o(),d(ye.$$.fragment),zi=o(),ol=i("p"),ol.textContent=Za,Pi=o(),d(we.$$.fragment),Ei=o(),sl=i("li"),sl.innerHTML=Na,Gi=o(),Me=i("li"),il=i("p"),il.innerHTML=Wa,Qi=o(),d(ge.$$.fragment),eo=o(),Te=i("p"),Te.innerHTML=Ba,to=o(),d(be.$$.fragment),no=o(),ve=i("p"),ve.innerHTML=Ra,lo=o(),Je=i("p"),Je.textContent=za,oo=o(),je=i("p"),je.innerHTML=Pa,so=o(),Ce=i("ul"),Ce.innerHTML=Ea,io=o(),ke=i("p"),ke.innerHTML=Ga,ao=o(),Ue=i("p"),Ue.textContent=Qa,ro=o(),_e=i("p"),_e.textContent=Va,mo=o(),Ie=i("ul"),Ie.innerHTML=Da,po=o(),xe=i("p"),xe.textContent=Ya,ho=o(),$e=i("p"),$e.innerHTML=Fa,uo=o(),Le=i("p"),Le.innerHTML=Sa,co=o(),d(Ae.$$.fragment),fo=o(),He=i("p"),He.textContent=Xa,yo=o(),Ze=i("ul"),Ze.innerHTML=qa,wo=o(),Ne=i("p"),Ne.textContent=Oa,Mo=o(),We=i("p"),We.innerHTML=Ka,go=o(),Be=i("ul"),Be.innerHTML=er,To=o(),Re=i("p"),Re.innerHTML=tr,bo=o(),ze=i("p"),ze.innerHTML=nr,vo=o(),Pe=i("p"),Pe.textContent=lr,Jo=o(),Ee=i("p"),Ee.textContent=or,jo=o(),Ge=i("ol"),Ge.innerHTML=sr,Co=o(),Qe=i("p"),Qe.innerHTML=ir,ko=o(),Ve=i("p"),Ve.textContent=ar,Uo=o(),d(De.$$.fragment),_o=o(),Ye=i("p"),Ye.innerHTML=rr,Io=o(),Fe=i("ul"),Fe.innerHTML=dr,xo=o(),Se=i("p"),Se.innerHTML=mr,$o=o(),d(Xe.$$.fragment),Lo=o(),qe=i("p"),qe.textContent=pr,Ao=o(),d(Oe.$$.fragment),Ho=o(),Ke=i("p"),Ke.innerHTML=hr,Zo=o(),et=i("p"),et.textContent=ur,No=o(),d(tt.$$.fragment),Wo=o(),nt=i("p"),nt.textContent=cr,Bo=o(),lt=i("p"),lt.innerHTML=fr,Ro=o(),ot=i("p"),ot.innerHTML=yr,zo=o(),st=i("p"),st.textContent=wr,Po=o(),M=i("ol"),it=i("li"),al=i("p"),al.textContent=Mr,Vi=o(),d(at.$$.fragment),Di=o(),rt=i("li"),rl=i("p"),rl.textContent=gr,Yi=o(),d(dt.$$.fragment),Fi=o(),mt=i("li"),dl=i("p"),dl.textContent=Tr,Si=o(),d(pt.$$.fragment),Xi=o(),ht=i("li"),ml=i("p"),ml.textContent=br,qi=o(),d(ut.$$.fragment),Oi=o(),pl=i("li"),pl.innerHTML=vr,Ki=o(),hl=i("li"),hl.innerHTML=Jr,Eo=o(),ct=i("p"),ct.textContent=jr,Go=o(),d(ft.$$.fragment),Qo=o(),yt=i("p"),yt.textContent=Cr,Vo=o(),wt=i("p"),wt.textContent=kr,Do=o(),Mt=i("p"),Mt.textContent=Ur,Yo=o(),gt=i("p"),gt.innerHTML=_r,Fo=o(),Tt=i("p"),Tt.innerHTML=Ir,So=o(),bt=i("p"),bt.innerHTML=xr,Xo=o(),vt=i("p"),vt.innerHTML=$r,qo=o(),d(Jt.$$.fragment),Oo=o(),jt=i("p"),jt.innerHTML=Lr,Ko=o(),Ct=i("p"),Ct.innerHTML=Ar,es=o(),d(kt.$$.fragment),ts=o(),Ut=i("p"),Ut.innerHTML=Hr,ns=o(),d(_t.$$.fragment),ls=o(),It=i("p"),It.innerHTML=Zr,os=o(),xt=i("p"),xt.innerHTML=Nr,ss=o(),$t=i("p"),$t.innerHTML=Wr,is=o(),Lt=i("ul"),Lt.innerHTML=Br,as=o(),At=i("p"),At.innerHTML=Rr,rs=o(),d(Ht.$$.fragment),ds=o(),Zt=i("p"),Zt.innerHTML=zr,ms=o(),d(Nt.$$.fragment),ps=o(),Wt=i("p"),Wt.textContent=Pr,hs=o(),d(Bt.$$.fragment),us=o(),Rt=i("p"),Rt.textContent=Er,cs=o(),d(zt.$$.fragment),fs=o(),Pt=i("p"),Pt.textContent=Gr,ys=o(),d(Et.$$.fragment),ws=o(),Gt=i("p"),Gt.innerHTML=Qr,Ms=o(),d(Qt.$$.fragment),gs=o(),Vt=i("p"),Vt.innerHTML=Vr,Ts=o(),d(Dt.$$.fragment),bs=o(),Yt=i("p"),Yt.innerHTML=Dr,vs=o(),d(Ft.$$.fragment),Js=o(),St=i("p"),St.textContent=Yr,js=o(),Xt=i("p"),Xt.innerHTML=Fr,Cs=o(),qt=i("p"),qt.innerHTML=Sr,ks=o(),Ot=i("p"),Ot.innerHTML=Xr,Us=o(),d(Kt.$$.fragment),_s=o(),en=i("p"),en.innerHTML=qr,Is=o(),tn=i("p"),tn.innerHTML=Or,xs=o(),d(nn.$$.fragment),$s=o(),ln=i("p"),ln.innerHTML=Kr,Ls=o(),on=i("p"),on.innerHTML=ed,As=o(),sn=i("ul"),sn.innerHTML=td,Hs=o(),an=i("p"),an.innerHTML=nd,Zs=o(),rn=i("p"),rn.innerHTML=ld,Ns=o(),dn=i("p"),dn.innerHTML=od,Ws=o(),mn=i("p"),mn.innerHTML=sd,Bs=o(),d(pn.$$.fragment),Rs=o(),hn=i("p"),hn.textContent=id,zs=o(),un=i("ul"),un.innerHTML=ad,Ps=o(),cn=i("p"),cn.innerHTML=rd,Es=o(),d(fn.$$.fragment),Gs=o(),d(U.$$.fragment),Qs=o(),yn=i("p"),yn.innerHTML=dd,Vs=o(),wn=i("ul"),wn.innerHTML=md,Ds=o(),Mn=i("p"),Mn.innerHTML=pd,Ys=o(),gn=i("p"),gn.innerHTML=hd,Fs=o(),Tn=i("p"),Tn.textContent=ud,Ss=o(),bn=i("p"),bn.innerHTML=cd,Xs=o(),d(vn.$$.fragment),qs=o(),Jn=i("p"),Jn.innerHTML=fd,Os=o(),d(jn.$$.fragment),Ks=o(),Cn=i("p"),Cn.innerHTML=yd,ei=o(),kn=i("p"),kn.innerHTML=wd,ti=o(),Un=i("p"),Un.innerHTML=Md,ni=o(),_n=i("p"),_n.innerHTML=gd,li=o(),In=i("p"),In.innerHTML=Td,oi=o(),xn=i("p"),xn.innerHTML=bd,si=o(),$n=i("p"),$n.innerHTML=vd,ii=o(),Ln=i("p"),Ln.innerHTML=Jd,ai=o(),An=i("p"),An.innerHTML=jd,ri=o(),d(Hn.$$.fragment),di=o(),Zn=i("p"),Zn.textContent=Cd,mi=o(),d(Nn.$$.fragment),pi=o(),Wn=i("p"),Wn.textContent=kd,hi=o(),Bn=i("p"),Bn.textContent=Ud,ui=o(),Rn=i("p"),Rn.textContent=_d,ci=o(),zn=i("p"),zn.innerHTML=Id,fi=o(),Pn=i("p"),Pn.innerHTML=xd,yi=o(),d(En.$$.fragment),wi=o(),Gn=i("p"),Gn.innerHTML=$d,Mi=o(),Qn=i("p"),Qn.innerHTML=Ld,gi=o(),Vn=i("p"),Vn.innerHTML=Ad,Ti=o(),Dn=i("p"),Dn.innerHTML=Hd,bi=o(),Yn=i("p"),Yn.textContent=Zd,vi=o(),d(Fn.$$.fragment),Ji=o(),Sn=i("p"),Sn.textContent=Nd,ji=o(),Xn=i("p"),Xn.innerHTML=Wd,Ci=o(),d(qn.$$.fragment),ki=o(),ul=i("p"),this.h()},l(e){const t=Qd("svelte-u9bgzb",document.head);w=a(t,"META",{name:!0,content:!0}),t.forEach(n),_=s(e),j=a(e,"P",{}),C(j).forEach(n),On=s(e),m(I.$$.fragment,e),fl=s(e),x=a(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-wxtsp1"&&(x.innerHTML=ta),yl=s(e),$=a(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1k9yxd1"&&($.textContent=na),wl=s(e),L=a(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-167a1ja"&&(L.innerHTML=la),Ml=s(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1wxv5qq"&&(A.textContent=oa),gl=s(e),H=a(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-77fy0j"&&(H.innerHTML=sa),Tl=s(e),Z=a(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-ug8854"&&(Z.textContent=ia),bl=s(e),m(N.$$.fragment,e),vl=s(e),W=a(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-rkgkw1"&&(W.textContent=aa),Jl=s(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-hekrk0"&&(B.innerHTML=ra),jl=s(e),R=a(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-9txdfw"&&(R.innerHTML=da),Cl=s(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-77738k"&&(z.innerHTML=ma),kl=s(e),P=a(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1z0o4ph"&&(P.textContent=pa),Ul=s(e),m(E.$$.fragment,e),_l=s(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1tdrku1"&&(G.innerHTML=ha),Il=s(e),Q=a(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1bv64m8"&&(Q.textContent=ua),xl=s(e),Kn=a(e,"IMG",{src:!0}),$l=s(e),V=a(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1hfvvm5"&&(V.innerHTML=fa),Ll=s(e),m(D.$$.fragment,e),Al=s(e),Y=a(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1jclvvw"&&(Y.innerHTML=ya),Hl=s(e),m(F.$$.fragment,e),Zl=s(e),S=a(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-105bqi8"&&(S.textContent=wa),Nl=s(e),X=a(e,"OL",{"data-svelte-h":!0}),r(X)!=="svelte-xy8tqe"&&(X.innerHTML=Ma),Wl=s(e),m(q.$$.fragment,e),Bl=s(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-10n9flr"&&(O.textContent=ga),Rl=s(e),m(K.$$.fragment,e),zl=s(e),ee=a(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-u747sz"&&(ee.textContent=Ta),Pl=s(e),te=a(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-b7gw6m"&&(te.innerHTML=ba),El=s(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-lru7u6"&&(ne.textContent=va),Gl=s(e),le=a(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-otnau5"&&(le.innerHTML=Ja),Ql=s(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-sv8a89"&&(oe.textContent=ja),Vl=s(e),se=a(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1ydy9mz"&&(se.textContent=Ca),Dl=s(e),ie=a(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-w74yfn"&&(ie.innerHTML=ka),Yl=s(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1pmt80l"&&(ae.innerHTML=Ua),Fl=s(e),m(re.$$.fragment,e),Sl=s(e),de=a(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-10phlbf"&&(de.innerHTML=_a),Xl=s(e),me=a(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-1b4oxlm"&&(me.innerHTML=Ia),ql=s(e),pe=a(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-g50mc6"&&(pe.textContent=xa),Ol=s(e),m(he.$$.fragment,e),Kl=s(e),T=a(e,"OL",{});var b=C(T);el=a(b,"LI",{"data-svelte-h":!0}),r(el)!=="svelte-4g2dtl"&&(el.innerHTML=$a),Hi=s(b),ue=a(b,"LI",{});var _i=C(ue);tl=a(_i,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-lgncv4"&&(tl.innerHTML=La),Zi=s(_i),m(ce.$$.fragment,_i),_i.forEach(n),Ni=s(b),g=a(b,"LI",{});var v=C(g);nl=a(v,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-lbvoi5"&&(nl.textContent=Aa),Wi=s(v),m(fe.$$.fragment,v),Bi=s(v),ll=a(v,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-4wf1r3"&&(ll.textContent=Ha),Ri=s(v),m(ye.$$.fragment,v),zi=s(v),ol=a(v,"P",{"data-svelte-h":!0}),r(ol)!=="svelte-182t6ba"&&(ol.textContent=Za),Pi=s(v),m(we.$$.fragment,v),v.forEach(n),Ei=s(b),sl=a(b,"LI",{"data-svelte-h":!0}),r(sl)!=="svelte-1t6q97z"&&(sl.innerHTML=Na),Gi=s(b),Me=a(b,"LI",{});var Ii=C(Me);il=a(Ii,"P",{"data-svelte-h":!0}),r(il)!=="svelte-hv4twz"&&(il.innerHTML=Wa),Qi=s(Ii),m(ge.$$.fragment,Ii),Ii.forEach(n),b.forEach(n),eo=s(e),Te=a(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-63px9k"&&(Te.innerHTML=Ba),to=s(e),m(be.$$.fragment,e),no=s(e),ve=a(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-hj6dkp"&&(ve.innerHTML=Ra),lo=s(e),Je=a(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1wodnvr"&&(Je.textContent=za),oo=s(e),je=a(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-172lkai"&&(je.innerHTML=Pa),so=s(e),Ce=a(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-10bloo4"&&(Ce.innerHTML=Ea),io=s(e),ke=a(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1jxuc4f"&&(ke.innerHTML=Ga),ao=s(e),Ue=a(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-197bmdq"&&(Ue.textContent=Qa),ro=s(e),_e=a(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-9v9j15"&&(_e.textContent=Va),mo=s(e),Ie=a(e,"UL",{"data-svelte-h":!0}),r(Ie)!=="svelte-1k92mpt"&&(Ie.innerHTML=Da),po=s(e),xe=a(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-xdlpes"&&(xe.textContent=Ya),ho=s(e),$e=a(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1u4zdsg"&&($e.innerHTML=Fa),uo=s(e),Le=a(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1g4uiwx"&&(Le.innerHTML=Sa),co=s(e),m(Ae.$$.fragment,e),fo=s(e),He=a(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-17f6vr7"&&(He.textContent=Xa),yo=s(e),Ze=a(e,"UL",{"data-svelte-h":!0}),r(Ze)!=="svelte-1w5zp67"&&(Ze.innerHTML=qa),wo=s(e),Ne=a(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-69ds49"&&(Ne.textContent=Oa),Mo=s(e),We=a(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-17olrqh"&&(We.innerHTML=Ka),go=s(e),Be=a(e,"UL",{"data-svelte-h":!0}),r(Be)!=="svelte-uaiiy7"&&(Be.innerHTML=er),To=s(e),Re=a(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-pv6v4"&&(Re.innerHTML=tr),bo=s(e),ze=a(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1ex3w25"&&(ze.innerHTML=nr),vo=s(e),Pe=a(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1480vjb"&&(Pe.textContent=lr),Jo=s(e),Ee=a(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1sttzvl"&&(Ee.textContent=or),jo=s(e),Ge=a(e,"OL",{"data-svelte-h":!0}),r(Ge)!=="svelte-1u0bkk8"&&(Ge.innerHTML=sr),Co=s(e),Qe=a(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-xvgy42"&&(Qe.innerHTML=ir),ko=s(e),Ve=a(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-a9oe4g"&&(Ve.textContent=ar),Uo=s(e),m(De.$$.fragment,e),_o=s(e),Ye=a(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1d7jpm"&&(Ye.innerHTML=rr),Io=s(e),Fe=a(e,"UL",{"data-svelte-h":!0}),r(Fe)!=="svelte-1bsafyj"&&(Fe.innerHTML=dr),xo=s(e),Se=a(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1fog5tn"&&(Se.innerHTML=mr),$o=s(e),m(Xe.$$.fragment,e),Lo=s(e),qe=a(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-hwuqxz"&&(qe.textContent=pr),Ao=s(e),m(Oe.$$.fragment,e),Ho=s(e),Ke=a(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1492az0"&&(Ke.innerHTML=hr),Zo=s(e),et=a(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-5vgl1p"&&(et.textContent=ur),No=s(e),m(tt.$$.fragment,e),Wo=s(e),nt=a(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-v5lffq"&&(nt.textContent=cr),Bo=s(e),lt=a(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1e0s43k"&&(lt.innerHTML=fr),Ro=s(e),ot=a(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1aoj71c"&&(ot.innerHTML=yr),zo=s(e),st=a(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-3h83p"&&(st.textContent=wr),Po=s(e),M=a(e,"OL",{});var J=C(M);it=a(J,"LI",{});var xi=C(it);al=a(xi,"P",{"data-svelte-h":!0}),r(al)!=="svelte-1hwk139"&&(al.textContent=Mr),Vi=s(xi),m(at.$$.fragment,xi),xi.forEach(n),Di=s(J),rt=a(J,"LI",{});var $i=C(rt);rl=a($i,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-gmko0l"&&(rl.textContent=gr),Yi=s($i),m(dt.$$.fragment,$i),$i.forEach(n),Fi=s(J),mt=a(J,"LI",{});var Li=C(mt);dl=a(Li,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-h4badi"&&(dl.textContent=Tr),Si=s(Li),m(pt.$$.fragment,Li),Li.forEach(n),Xi=s(J),ht=a(J,"LI",{});var Ai=C(ht);ml=a(Ai,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-1adm7yl"&&(ml.textContent=br),qi=s(Ai),m(ut.$$.fragment,Ai),Ai.forEach(n),Oi=s(J),pl=a(J,"LI",{"data-svelte-h":!0}),r(pl)!=="svelte-v52akd"&&(pl.innerHTML=vr),Ki=s(J),hl=a(J,"LI",{"data-svelte-h":!0}),r(hl)!=="svelte-1jfczy2"&&(hl.innerHTML=Jr),J.forEach(n),Eo=s(e),ct=a(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-fby7tz"&&(ct.textContent=jr),Go=s(e),m(ft.$$.fragment,e),Qo=s(e),yt=a(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-707ott"&&(yt.textContent=Cr),Vo=s(e),wt=a(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-10vuoyb"&&(wt.textContent=kr),Do=s(e),Mt=a(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1rsqt8e"&&(Mt.textContent=Ur),Yo=s(e),gt=a(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-e56uo0"&&(gt.innerHTML=_r),Fo=s(e),Tt=a(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1pev0u3"&&(Tt.innerHTML=Ir),So=s(e),bt=a(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-o2c99d"&&(bt.innerHTML=xr),Xo=s(e),vt=a(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-cf404e"&&(vt.innerHTML=$r),qo=s(e),m(Jt.$$.fragment,e),Oo=s(e),jt=a(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1dloo7i"&&(jt.innerHTML=Lr),Ko=s(e),Ct=a(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-nsqyfa"&&(Ct.innerHTML=Ar),es=s(e),m(kt.$$.fragment,e),ts=s(e),Ut=a(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-sj6wf0"&&(Ut.innerHTML=Hr),ns=s(e),m(_t.$$.fragment,e),ls=s(e),It=a(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1pfm0sb"&&(It.innerHTML=Zr),os=s(e),xt=a(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-f68cwo"&&(xt.innerHTML=Nr),ss=s(e),$t=a(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-vdut7s"&&($t.innerHTML=Wr),is=s(e),Lt=a(e,"UL",{"data-svelte-h":!0}),r(Lt)!=="svelte-16vb6hw"&&(Lt.innerHTML=Br),as=s(e),At=a(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-14nqqv0"&&(At.innerHTML=Rr),rs=s(e),m(Ht.$$.fragment,e),ds=s(e),Zt=a(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-p81vjw"&&(Zt.innerHTML=zr),ms=s(e),m(Nt.$$.fragment,e),ps=s(e),Wt=a(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-ilov09"&&(Wt.textContent=Pr),hs=s(e),m(Bt.$$.fragment,e),us=s(e),Rt=a(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-13dugi2"&&(Rt.textContent=Er),cs=s(e),m(zt.$$.fragment,e),fs=s(e),Pt=a(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-1lx6n8g"&&(Pt.textContent=Gr),ys=s(e),m(Et.$$.fragment,e),ws=s(e),Gt=a(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-1t5qty0"&&(Gt.innerHTML=Qr),Ms=s(e),m(Qt.$$.fragment,e),gs=s(e),Vt=a(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-1b67ucv"&&(Vt.innerHTML=Vr),Ts=s(e),m(Dt.$$.fragment,e),bs=s(e),Yt=a(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-10rxzj1"&&(Yt.innerHTML=Dr),vs=s(e),m(Ft.$$.fragment,e),Js=s(e),St=a(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-tq4e7m"&&(St.textContent=Yr),js=s(e),Xt=a(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-nguxo0"&&(Xt.innerHTML=Fr),Cs=s(e),qt=a(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-5g2dr4"&&(qt.innerHTML=Sr),ks=s(e),Ot=a(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-jkulr9"&&(Ot.innerHTML=Xr),Us=s(e),m(Kt.$$.fragment,e),_s=s(e),en=a(e,"P",{"data-svelte-h":!0}),r(en)!=="svelte-8ivqw6"&&(en.innerHTML=qr),Is=s(e),tn=a(e,"P",{"data-svelte-h":!0}),r(tn)!=="svelte-1v8xetm"&&(tn.innerHTML=Or),xs=s(e),m(nn.$$.fragment,e),$s=s(e),ln=a(e,"P",{"data-svelte-h":!0}),r(ln)!=="svelte-txar7q"&&(ln.innerHTML=Kr),Ls=s(e),on=a(e,"P",{"data-svelte-h":!0}),r(on)!=="svelte-10rs2ro"&&(on.innerHTML=ed),As=s(e),sn=a(e,"UL",{"data-svelte-h":!0}),r(sn)!=="svelte-1r46n3h"&&(sn.innerHTML=td),Hs=s(e),an=a(e,"P",{"data-svelte-h":!0}),r(an)!=="svelte-1i2mpdn"&&(an.innerHTML=nd),Zs=s(e),rn=a(e,"P",{"data-svelte-h":!0}),r(rn)!=="svelte-16p1dlw"&&(rn.innerHTML=ld),Ns=s(e),dn=a(e,"P",{"data-svelte-h":!0}),r(dn)!=="svelte-1q8o052"&&(dn.innerHTML=od),Ws=s(e),mn=a(e,"P",{"data-svelte-h":!0}),r(mn)!=="svelte-13ruakv"&&(mn.innerHTML=sd),Bs=s(e),m(pn.$$.fragment,e),Rs=s(e),hn=a(e,"P",{"data-svelte-h":!0}),r(hn)!=="svelte-1z4cf"&&(hn.textContent=id),zs=s(e),un=a(e,"UL",{"data-svelte-h":!0}),r(un)!=="svelte-1msq586"&&(un.innerHTML=ad),Ps=s(e),cn=a(e,"P",{"data-svelte-h":!0}),r(cn)!=="svelte-2t6h0z"&&(cn.innerHTML=rd),Es=s(e),m(fn.$$.fragment,e),Gs=s(e),m(U.$$.fragment,e),Qs=s(e),yn=a(e,"P",{"data-svelte-h":!0}),r(yn)!=="svelte-63hgsc"&&(yn.innerHTML=dd),Vs=s(e),wn=a(e,"UL",{"data-svelte-h":!0}),r(wn)!=="svelte-1192mxo"&&(wn.innerHTML=md),Ds=s(e),Mn=a(e,"P",{"data-svelte-h":!0}),r(Mn)!=="svelte-1l7w7z9"&&(Mn.innerHTML=pd),Ys=s(e),gn=a(e,"P",{"data-svelte-h":!0}),r(gn)!=="svelte-17g0btz"&&(gn.innerHTML=hd),Fs=s(e),Tn=a(e,"P",{"data-svelte-h":!0}),r(Tn)!=="svelte-w3jgow"&&(Tn.textContent=ud),Ss=s(e),bn=a(e,"P",{"data-svelte-h":!0}),r(bn)!=="svelte-3mgn5l"&&(bn.innerHTML=cd),Xs=s(e),m(vn.$$.fragment,e),qs=s(e),Jn=a(e,"P",{"data-svelte-h":!0}),r(Jn)!=="svelte-12b6z3d"&&(Jn.innerHTML=fd),Os=s(e),m(jn.$$.fragment,e),Ks=s(e),Cn=a(e,"P",{"data-svelte-h":!0}),r(Cn)!=="svelte-12o38jn"&&(Cn.innerHTML=yd),ei=s(e),kn=a(e,"P",{"data-svelte-h":!0}),r(kn)!=="svelte-m9dhdl"&&(kn.innerHTML=wd),ti=s(e),Un=a(e,"P",{"data-svelte-h":!0}),r(Un)!=="svelte-1r4x1hz"&&(Un.innerHTML=Md),ni=s(e),_n=a(e,"P",{"data-svelte-h":!0}),r(_n)!=="svelte-1a2qjdi"&&(_n.innerHTML=gd),li=s(e),In=a(e,"P",{"data-svelte-h":!0}),r(In)!=="svelte-lu4l51"&&(In.innerHTML=Td),oi=s(e),xn=a(e,"P",{"data-svelte-h":!0}),r(xn)!=="svelte-ngbmem"&&(xn.innerHTML=bd),si=s(e),$n=a(e,"P",{"data-svelte-h":!0}),r($n)!=="svelte-oj7bsa"&&($n.innerHTML=vd),ii=s(e),Ln=a(e,"P",{"data-svelte-h":!0}),r(Ln)!=="svelte-1h13ics"&&(Ln.innerHTML=Jd),ai=s(e),An=a(e,"P",{"data-svelte-h":!0}),r(An)!=="svelte-1o0dhcg"&&(An.innerHTML=jd),ri=s(e),m(Hn.$$.fragment,e),di=s(e),Zn=a(e,"P",{"data-svelte-h":!0}),r(Zn)!=="svelte-1hnvgw6"&&(Zn.textContent=Cd),mi=s(e),m(Nn.$$.fragment,e),pi=s(e),Wn=a(e,"P",{"data-svelte-h":!0}),r(Wn)!=="svelte-158gt2o"&&(Wn.textContent=kd),hi=s(e),Bn=a(e,"P",{"data-svelte-h":!0}),r(Bn)!=="svelte-z20wkr"&&(Bn.textContent=Ud),ui=s(e),Rn=a(e,"P",{"data-svelte-h":!0}),r(Rn)!=="svelte-1uwhc8b"&&(Rn.textContent=_d),ci=s(e),zn=a(e,"P",{"data-svelte-h":!0}),r(zn)!=="svelte-cmu0wm"&&(zn.innerHTML=Id),fi=s(e),Pn=a(e,"P",{"data-svelte-h":!0}),r(Pn)!=="svelte-11c1nk5"&&(Pn.innerHTML=xd),yi=s(e),m(En.$$.fragment,e),wi=s(e),Gn=a(e,"P",{"data-svelte-h":!0}),r(Gn)!=="svelte-hwxs76"&&(Gn.innerHTML=$d),Mi=s(e),Qn=a(e,"P",{"data-svelte-h":!0}),r(Qn)!=="svelte-1gie4tq"&&(Qn.innerHTML=Ld),gi=s(e),Vn=a(e,"P",{"data-svelte-h":!0}),r(Vn)!=="svelte-1so49zx"&&(Vn.innerHTML=Ad),Ti=s(e),Dn=a(e,"P",{"data-svelte-h":!0}),r(Dn)!=="svelte-144ouhf"&&(Dn.innerHTML=Hd),bi=s(e),Yn=a(e,"P",{"data-svelte-h":!0}),r(Yn)!=="svelte-jag54x"&&(Yn.textContent=Zd),vi=s(e),m(Fn.$$.fragment,e),Ji=s(e),Sn=a(e,"P",{"data-svelte-h":!0}),r(Sn)!=="svelte-d34izn"&&(Sn.textContent=Nd),ji=s(e),Xn=a(e,"P",{"data-svelte-h":!0}),r(Xn)!=="svelte-1f9gbqf"&&(Xn.innerHTML=Wd),Ci=s(e),m(qn.$$.fragment,e),ki=s(e),ul=a(e,"P",{}),C(ul).forEach(n),this.h()},h(){ea(w,"name","hf:doc:metadata"),ea(w,"content",Sd),Rd(Kn.src,ca="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers_overview.png")||ea(Kn,"src",ca)},m(e,t){f(document.head,w),l(e,_,t),l(e,j,t),l(e,On,t),p(I,e,t),l(e,fl,t),l(e,x,t),l(e,yl,t),l(e,$,t),l(e,wl,t),l(e,L,t),l(e,Ml,t),l(e,A,t),l(e,gl,t),l(e,H,t),l(e,Tl,t),l(e,Z,t),l(e,bl,t),p(N,e,t),l(e,vl,t),l(e,W,t),l(e,Jl,t),l(e,B,t),l(e,jl,t),l(e,R,t),l(e,Cl,t),l(e,z,t),l(e,kl,t),l(e,P,t),l(e,Ul,t),p(E,e,t),l(e,_l,t),l(e,G,t),l(e,Il,t),l(e,Q,t),l(e,xl,t),l(e,Kn,t),l(e,$l,t),l(e,V,t),l(e,Ll,t),p(D,e,t),l(e,Al,t),l(e,Y,t),l(e,Hl,t),p(F,e,t),l(e,Zl,t),l(e,S,t),l(e,Nl,t),l(e,X,t),l(e,Wl,t),p(q,e,t),l(e,Bl,t),l(e,O,t),l(e,Rl,t),p(K,e,t),l(e,zl,t),l(e,ee,t),l(e,Pl,t),l(e,te,t),l(e,El,t),l(e,ne,t),l(e,Gl,t),l(e,le,t),l(e,Ql,t),l(e,oe,t),l(e,Vl,t),l(e,se,t),l(e,Dl,t),l(e,ie,t),l(e,Yl,t),l(e,ae,t),l(e,Fl,t),p(re,e,t),l(e,Sl,t),l(e,de,t),l(e,Xl,t),l(e,me,t),l(e,ql,t),l(e,pe,t),l(e,Ol,t),p(he,e,t),l(e,Kl,t),l(e,T,t),f(T,el),f(T,Hi),f(T,ue),f(ue,tl),f(ue,Zi),p(ce,ue,null),f(T,Ni),f(T,g),f(g,nl),f(g,Wi),p(fe,g,null),f(g,Bi),f(g,ll),f(g,Ri),p(ye,g,null),f(g,zi),f(g,ol),f(g,Pi),p(we,g,null),f(T,Ei),f(T,sl),f(T,Gi),f(T,Me),f(Me,il),f(Me,Qi),p(ge,Me,null),l(e,eo,t),l(e,Te,t),l(e,to,t),p(be,e,t),l(e,no,t),l(e,ve,t),l(e,lo,t),l(e,Je,t),l(e,oo,t),l(e,je,t),l(e,so,t),l(e,Ce,t),l(e,io,t),l(e,ke,t),l(e,ao,t),l(e,Ue,t),l(e,ro,t),l(e,_e,t),l(e,mo,t),l(e,Ie,t),l(e,po,t),l(e,xe,t),l(e,ho,t),l(e,$e,t),l(e,uo,t),l(e,Le,t),l(e,co,t),p(Ae,e,t),l(e,fo,t),l(e,He,t),l(e,yo,t),l(e,Ze,t),l(e,wo,t),l(e,Ne,t),l(e,Mo,t),l(e,We,t),l(e,go,t),l(e,Be,t),l(e,To,t),l(e,Re,t),l(e,bo,t),l(e,ze,t),l(e,vo,t),l(e,Pe,t),l(e,Jo,t),l(e,Ee,t),l(e,jo,t),l(e,Ge,t),l(e,Co,t),l(e,Qe,t),l(e,ko,t),l(e,Ve,t),l(e,Uo,t),p(De,e,t),l(e,_o,t),l(e,Ye,t),l(e,Io,t),l(e,Fe,t),l(e,xo,t),l(e,Se,t),l(e,$o,t),p(Xe,e,t),l(e,Lo,t),l(e,qe,t),l(e,Ao,t),p(Oe,e,t),l(e,Ho,t),l(e,Ke,t),l(e,Zo,t),l(e,et,t),l(e,No,t),p(tt,e,t),l(e,Wo,t),l(e,nt,t),l(e,Bo,t),l(e,lt,t),l(e,Ro,t),l(e,ot,t),l(e,zo,t),l(e,st,t),l(e,Po,t),l(e,M,t),f(M,it),f(it,al),f(it,Vi),p(at,it,null),f(M,Di),f(M,rt),f(rt,rl),f(rt,Yi),p(dt,rt,null),f(M,Fi),f(M,mt),f(mt,dl),f(mt,Si),p(pt,mt,null),f(M,Xi),f(M,ht),f(ht,ml),f(ht,qi),p(ut,ht,null),f(M,Oi),f(M,pl),f(M,Ki),f(M,hl),l(e,Eo,t),l(e,ct,t),l(e,Go,t),p(ft,e,t),l(e,Qo,t),l(e,yt,t),l(e,Vo,t),l(e,wt,t),l(e,Do,t),l(e,Mt,t),l(e,Yo,t),l(e,gt,t),l(e,Fo,t),l(e,Tt,t),l(e,So,t),l(e,bt,t),l(e,Xo,t),l(e,vt,t),l(e,qo,t),p(Jt,e,t),l(e,Oo,t),l(e,jt,t),l(e,Ko,t),l(e,Ct,t),l(e,es,t),p(kt,e,t),l(e,ts,t),l(e,Ut,t),l(e,ns,t),p(_t,e,t),l(e,ls,t),l(e,It,t),l(e,os,t),l(e,xt,t),l(e,ss,t),l(e,$t,t),l(e,is,t),l(e,Lt,t),l(e,as,t),l(e,At,t),l(e,rs,t),p(Ht,e,t),l(e,ds,t),l(e,Zt,t),l(e,ms,t),p(Nt,e,t),l(e,ps,t),l(e,Wt,t),l(e,hs,t),p(Bt,e,t),l(e,us,t),l(e,Rt,t),l(e,cs,t),p(zt,e,t),l(e,fs,t),l(e,Pt,t),l(e,ys,t),p(Et,e,t),l(e,ws,t),l(e,Gt,t),l(e,Ms,t),p(Qt,e,t),l(e,gs,t),l(e,Vt,t),l(e,Ts,t),p(Dt,e,t),l(e,bs,t),l(e,Yt,t),l(e,vs,t),p(Ft,e,t),l(e,Js,t),l(e,St,t),l(e,js,t),l(e,Xt,t),l(e,Cs,t),l(e,qt,t),l(e,ks,t),l(e,Ot,t),l(e,Us,t),p(Kt,e,t),l(e,_s,t),l(e,en,t),l(e,Is,t),l(e,tn,t),l(e,xs,t),p(nn,e,t),l(e,$s,t),l(e,ln,t),l(e,Ls,t),l(e,on,t),l(e,As,t),l(e,sn,t),l(e,Hs,t),l(e,an,t),l(e,Zs,t),l(e,rn,t),l(e,Ns,t),l(e,dn,t),l(e,Ws,t),l(e,mn,t),l(e,Bs,t),p(pn,e,t),l(e,Rs,t),l(e,hn,t),l(e,zs,t),l(e,un,t),l(e,Ps,t),l(e,cn,t),l(e,Es,t),p(fn,e,t),l(e,Gs,t),p(U,e,t),l(e,Qs,t),l(e,yn,t),l(e,Vs,t),l(e,wn,t),l(e,Ds,t),l(e,Mn,t),l(e,Ys,t),l(e,gn,t),l(e,Fs,t),l(e,Tn,t),l(e,Ss,t),l(e,bn,t),l(e,Xs,t),p(vn,e,t),l(e,qs,t),l(e,Jn,t),l(e,Os,t),p(jn,e,t),l(e,Ks,t),l(e,Cn,t),l(e,ei,t),l(e,kn,t),l(e,ti,t),l(e,Un,t),l(e,ni,t),l(e,_n,t),l(e,li,t),l(e,In,t),l(e,oi,t),l(e,xn,t),l(e,si,t),l(e,$n,t),l(e,ii,t),l(e,Ln,t),l(e,ai,t),l(e,An,t),l(e,ri,t),p(Hn,e,t),l(e,di,t),l(e,Zn,t),l(e,mi,t),p(Nn,e,t),l(e,pi,t),l(e,Wn,t),l(e,hi,t),l(e,Bn,t),l(e,ui,t),l(e,Rn,t),l(e,ci,t),l(e,zn,t),l(e,fi,t),l(e,Pn,t),l(e,yi,t),p(En,e,t),l(e,wi,t),l(e,Gn,t),l(e,Mi,t),l(e,Qn,t),l(e,gi,t),l(e,Vn,t),l(e,Ti,t),l(e,Dn,t),l(e,bi,t),l(e,Yn,t),l(e,vi,t),p(Fn,e,t),l(e,Ji,t),l(e,Sn,t),l(e,ji,t),l(e,Xn,t),l(e,Ci,t),p(qn,e,t),l(e,ki,t),l(e,ul,t),Ui=!0},p(e,[t]){const b={};t&2&&(b.$$scope={dirty:t,ctx:e}),U.$set(b)},i(e){Ui||(h(I.$$.fragment,e),h(N.$$.fragment,e),h(E.$$.fragment,e),h(D.$$.fragment,e),h(F.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h(re.$$.fragment,e),h(he.$$.fragment,e),h(ce.$$.fragment,e),h(fe.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(ge.$$.fragment,e),h(be.$$.fragment,e),h(Ae.$$.fragment,e),h(De.$$.fragment,e),h(Xe.$$.fragment,e),h(Oe.$$.fragment,e),h(tt.$$.fragment,e),h(at.$$.fragment,e),h(dt.$$.fragment,e),h(pt.$$.fragment,e),h(ut.$$.fragment,e),h(ft.$$.fragment,e),h(Jt.$$.fragment,e),h(kt.$$.fragment,e),h(_t.$$.fragment,e),h(Ht.$$.fragment,e),h(Nt.$$.fragment,e),h(Bt.$$.fragment,e),h(zt.$$.fragment,e),h(Et.$$.fragment,e),h(Qt.$$.fragment,e),h(Dt.$$.fragment,e),h(Ft.$$.fragment,e),h(Kt.$$.fragment,e),h(nn.$$.fragment,e),h(pn.$$.fragment,e),h(fn.$$.fragment,e),h(U.$$.fragment,e),h(vn.$$.fragment,e),h(jn.$$.fragment,e),h(Hn.$$.fragment,e),h(Nn.$$.fragment,e),h(En.$$.fragment,e),h(Fn.$$.fragment,e),h(qn.$$.fragment,e),Ui=!0)},o(e){u(I.$$.fragment,e),u(N.$$.fragment,e),u(E.$$.fragment,e),u(D.$$.fragment,e),u(F.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(re.$$.fragment,e),u(he.$$.fragment,e),u(ce.$$.fragment,e),u(fe.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u(ge.$$.fragment,e),u(be.$$.fragment,e),u(Ae.$$.fragment,e),u(De.$$.fragment,e),u(Xe.$$.fragment,e),u(Oe.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(dt.$$.fragment,e),u(pt.$$.fragment,e),u(ut.$$.fragment,e),u(ft.$$.fragment,e),u(Jt.$$.fragment,e),u(kt.$$.fragment,e),u(_t.$$.fragment,e),u(Ht.$$.fragment,e),u(Nt.$$.fragment,e),u(Bt.$$.fragment,e),u(zt.$$.fragment,e),u(Et.$$.fragment,e),u(Qt.$$.fragment,e),u(Dt.$$.fragment,e),u(Ft.$$.fragment,e),u(Kt.$$.fragment,e),u(nn.$$.fragment,e),u(pn.$$.fragment,e),u(fn.$$.fragment,e),u(U.$$.fragment,e),u(vn.$$.fragment,e),u(jn.$$.fragment,e),u(Hn.$$.fragment,e),u(Nn.$$.fragment,e),u(En.$$.fragment,e),u(Fn.$$.fragment,e),u(qn.$$.fragment,e),Ui=!1},d(e){e&&(n(_),n(j),n(On),n(fl),n(x),n(yl),n($),n(wl),n(L),n(Ml),n(A),n(gl),n(H),n(Tl),n(Z),n(bl),n(vl),n(W),n(Jl),n(B),n(jl),n(R),n(Cl),n(z),n(kl),n(P),n(Ul),n(_l),n(G),n(Il),n(Q),n(xl),n(Kn),n($l),n(V),n(Ll),n(Al),n(Y),n(Hl),n(Zl),n(S),n(Nl),n(X),n(Wl),n(Bl),n(O),n(Rl),n(zl),n(ee),n(Pl),n(te),n(El),n(ne),n(Gl),n(le),n(Ql),n(oe),n(Vl),n(se),n(Dl),n(ie),n(Yl),n(ae),n(Fl),n(Sl),n(de),n(Xl),n(me),n(ql),n(pe),n(Ol),n(Kl),n(T),n(eo),n(Te),n(to),n(no),n(ve),n(lo),n(Je),n(oo),n(je),n(so),n(Ce),n(io),n(ke),n(ao),n(Ue),n(ro),n(_e),n(mo),n(Ie),n(po),n(xe),n(ho),n($e),n(uo),n(Le),n(co),n(fo),n(He),n(yo),n(Ze),n(wo),n(Ne),n(Mo),n(We),n(go),n(Be),n(To),n(Re),n(bo),n(ze),n(vo),n(Pe),n(Jo),n(Ee),n(jo),n(Ge),n(Co),n(Qe),n(ko),n(Ve),n(Uo),n(_o),n(Ye),n(Io),n(Fe),n(xo),n(Se),n($o),n(Lo),n(qe),n(Ao),n(Ho),n(Ke),n(Zo),n(et),n(No),n(Wo),n(nt),n(Bo),n(lt),n(Ro),n(ot),n(zo),n(st),n(Po),n(M),n(Eo),n(ct),n(Go),n(Qo),n(yt),n(Vo),n(wt),n(Do),n(Mt),n(Yo),n(gt),n(Fo),n(Tt),n(So),n(bt),n(Xo),n(vt),n(qo),n(Oo),n(jt),n(Ko),n(Ct),n(es),n(ts),n(Ut),n(ns),n(ls),n(It),n(os),n(xt),n(ss),n($t),n(is),n(Lt),n(as),n(At),n(rs),n(ds),n(Zt),n(ms),n(ps),n(Wt),n(hs),n(us),n(Rt),n(cs),n(fs),n(Pt),n(ys),n(ws),n(Gt),n(Ms),n(gs),n(Vt),n(Ts),n(bs),n(Yt),n(vs),n(Js),n(St),n(js),n(Xt),n(Cs),n(qt),n(ks),n(Ot),n(Us),n(_s),n(en),n(Is),n(tn),n(xs),n($s),n(ln),n(Ls),n(on),n(As),n(sn),n(Hs),n(an),n(Zs),n(rn),n(Ns),n(dn),n(Ws),n(mn),n(Bs),n(Rs),n(hn),n(zs),n(un),n(Ps),n(cn),n(Es),n(Gs),n(Qs),n(yn),n(Vs),n(wn),n(Ds),n(Mn),n(Ys),n(gn),n(Fs),n(Tn),n(Ss),n(bn),n(Xs),n(qs),n(Jn),n(Os),n(Ks),n(Cn),n(ei),n(kn),n(ti),n(Un),n(ni),n(_n),n(li),n(In),n(oi),n(xn),n(si),n($n),n(ii),n(Ln),n(ai),n(An),n(ri),n(di),n(Zn),n(mi),n(pi),n(Wn),n(hi),n(Bn),n(ui),n(Rn),n(ci),n(zn),n(fi),n(Pn),n(yi),n(wi),n(Gn),n(Mi),n(Qn),n(gi),n(Vn),n(Ti),n(Dn),n(bi),n(Yn),n(vi),n(Ji),n(Sn),n(ji),n(Xn),n(Ci),n(ki),n(ul)),n(w),c(I,e),c(N,e),c(E,e),c(D,e),c(F,e),c(q,e),c(K,e),c(re,e),c(he,e),c(ce),c(fe),c(ye),c(we),c(ge),c(be,e),c(Ae,e),c(De,e),c(Xe,e),c(Oe,e),c(tt,e),c(at),c(dt),c(pt),c(ut),c(ft,e),c(Jt,e),c(kt,e),c(_t,e),c(Ht,e),c(Nt,e),c(Bt,e),c(zt,e),c(Et,e),c(Qt,e),c(Dt,e),c(Ft,e),c(Kt,e),c(nn,e),c(pn,e),c(fn,e),c(U,e),c(vn,e),c(jn,e),c(Hn,e),c(Nn,e),c(En,e),c(Fn,e),c(qn,e)}}}const Sd='{"title":"How to add a model to 🤗 Transformers?","local":"how-to-add-a-model-to--transformers","sections":[{"title":"General overview of 🤗 Transformers","local":"general-overview-of--transformers","sections":[{"title":"Overview of models","local":"overview-of-models","sections":[],"depth":3},{"title":"Code style","local":"code-style","sections":[],"depth":3},{"title":"Overview of tokenizers","local":"overview-of-tokenizers","sections":[],"depth":3}],"depth":2},{"title":"Step-by-step recipe to add a model to 🤗 Transformers","local":"step-by-step-recipe-to-add-a-model-to--transformers","sections":[{"title":"1. (Optional) Theoretical aspects of BrandNewBert","local":"1-optional-theoretical-aspects-of-brandnewbert","sections":[],"depth":3},{"title":"2. Next prepare your environment","local":"2-next-prepare-your-environment","sections":[],"depth":3},{"title":"3.-4. Run a pretrained checkpoint using the original repository","local":"3-4-run-a-pretrained-checkpoint-using-the-original-repository","sections":[],"depth":3},{"title":"5.-14. Port BrandNewBert to 🤗 Transformers","local":"5-14-port-brandnewbert-to--transformers","sections":[],"depth":3},{"title":"Share your work!!","local":"share-your-work","sections":[],"depth":3}],"depth":2}],"depth":1}';function Xd(cl){return zd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nm extends Ed{constructor(w){super(),Gd(this,w,Xd,Fd,Bd,{})}}export{nm as component};
