import{s as ee,o as se,n as le}from"../chunks/scheduler.25b97de1.js";import{S as ae,i as ne,g as i,s as a,r,A as ie,h as p,f as s,c as n,j as te,u as h,x as o,k as O,y as pe,a as l,v as c,d,t as u,w as g}from"../chunks/index.d9030fc9.js";import{T as oe}from"../chunks/Tip.baa67368.js";import{C as M}from"../chunks/CodeBlock.e6cd0d95.js";import{H as Gt,E as me}from"../chunks/EditOnGithub.91d95064.js";function re(tt){let m,j='To see all architectures and checkpoints compatible with this task, we recommend checking the <a href="https://huggingface.co/tasks/depth-anything" rel="nofollow">task-page</a>';return{c(){m=i("p"),m.innerHTML=j},l(f){m=p(f,"P",{"data-svelte-h":!0}),o(m)!=="svelte-15v7fmc"&&(m.innerHTML=j)},m(f,D){l(f,m,D)},p:le,d(f){f&&s(m)}}}function he(tt){let m,j,f,D,v,et,J,Bt=`Monocular depth estimation is a computer vision task that involves predicting the depth information of a scene from a
single image. In other words, it is the process of estimating the distance of objects in a scene from
a single camera viewpoint.`,st,T,Ht=`Monocular depth estimation has various applications, including 3D reconstruction, augmented reality, autonomous driving,
and robotics. It is a challenging task as it requires the model to understand the complex relationships between objects
in the scene and the corresponding depth information, which can be affected by factors such as lighting conditions,
occlusion, and texture.`,lt,y,at,U,It="In this guide you’ll learn how to:",nt,C,zt="<li>create a depth estimation pipeline</li> <li>run depth estimation inference by hand</li>",it,k,Et="Before you begin, make sure you have all the necessary libraries installed:",pt,Z,ot,x,mt,W,Vt=`The simplest way to try out inference with a model supporting depth estimation is to use the corresponding <a href="/docs/transformers/pr_27818/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>.
Instantiate a pipeline from a <a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>:`,rt,R,ht,_,Nt="Next, choose an image to analyze:",ct,G,dt,w,Xt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-estimation-example.jpg" alt="Photo of a busy street"/>',ut,B,Qt="Pass the image to the pipeline.",gt,H,ft,I,Ft=`The pipeline returns a dictionary with two entries. The first one, called <code>predicted_depth</code>, is a tensor with the values
being the depth expressed in meters for each pixel.
The second one, <code>depth</code>, is a PIL image that visualizes the depth estimation result.`,Mt,z,Yt="Let’s take a look at the visualized result:",yt,E,wt,$,St='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-visualization.png" alt="Depth estimation visualization"/>',$t,V,bt,N,Lt="Now that you’ve seen how to use the depth estimation pipeline, let’s see how we can replicate the same result by hand.",jt,X,Pt=`Start by loading the model and associated processor from a <a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>.
Here we’ll use the same checkpoint as before:`,vt,Q,Jt,F,qt=`Prepare the image input for the model using the <code>image_processor</code> that will take care of the necessary image transformations
such as resizing and normalization:`,Tt,Y,Ut,S,At="Pass the prepared inputs through the model:",Ct,L,kt,P,Dt="Visualize the results:",Zt,q,xt,b,Kt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-visualization.png" alt="Depth estimation visualization"/>',Wt,A,Rt,K,_t;return v=new Gt({props:{title:"Monocular depth estimation",local:"monocular-depth-estimation",headingTag:"h1"}}),y=new oe({props:{$$slots:{default:[re]},$$scope:{ctx:tt}}}),Z=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),x=new Gt({props:{title:"Depth estimation pipeline",local:"depth-estimation-pipeline",headingTag:"h2"}}),R=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMnZpbnZpbm8wMiUyRmdscG4tbnl1JTIyJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiUyQyUyMG1vZGVsJTNEY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;vinvino02/glpn-nyu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = pipeline(<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=checkpoint)`,wrap:!1}}),G=new M({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRkh3QkFzU2JQQkRVJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4elpXRnlZMmg4TXpSOGZHTmhjaVV5TUdsdUpUSXdkR2hsSlRJd2MzUnlaV1YwZkdWdWZEQjhNSHg4ZkRFMk56ZzVNREV3T0RnJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/HwBAsSbPBDU/download?ixid=MnwxMjA3fDB8MXxzZWFyY2h8MzR8fGNhciUyMGluJTIwdGhlJTIwc3RyZWV0fGVufDB8MHx8fDE2Nzg5MDEwODg&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),H=new M({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoaW1hZ2Up",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = depth_estimator(image)',wrap:!1}}),E=new M({props:{code:"cHJlZGljdGlvbnMlNUIlMjJkZXB0aCUyMiU1RA==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>predictions[<span class="hljs-string">&quot;depth&quot;</span>]',wrap:!1}}),V=new Gt({props:{title:"Depth estimation inference by hand",local:"depth-estimation-inference-by-hand",headingTag:"h2"}}),Q=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJ2aW52aW5vMDIlMkZnbHBuLW55dSUyMiUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;vinvino02/glpn-nyu&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(checkpoint)`,wrap:!1}}),Y=new M({props:{code:"cGl4ZWxfdmFsdWVzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVz",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values',wrap:!1}}),L=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyklMEElMjAlMjAlMjAlMjBwcmVkaWN0ZWRfZGVwdGglMjAlM0QlMjBvdXRwdXRzLnByZWRpY3RlZF9kZXB0aA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(pixel_values)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth`,wrap:!1}}),q=new M({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXByZWRpY3Rpb24lMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLmludGVycG9sYXRlKCUwQSUyMCUyMCUyMCUyMHByZWRpY3RlZF9kZXB0aC51bnNxdWVlemUoMSklMkMlMEElMjAlMjAlMjAlMjBzaXplJTNEaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZSUzRCUyMmJpY3ViaWMlMjIlMkMlMEElMjAlMjAlMjAlMjBhbGlnbl9jb3JuZXJzJTNERmFsc2UlMkMlMEEpLnNxdWVlemUoKSUwQW91dHB1dCUyMCUzRCUyMHByZWRpY3Rpb24ubnVtcHkoKSUwQSUwQWZvcm1hdHRlZCUyMCUzRCUyMChvdXRwdXQlMjAqJTIwMjU1JTIwJTJGJTIwbnAubWF4KG91dHB1dCkpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShmb3JtYXR0ZWQpJTBBZGVwdGg=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.numpy()

<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth`,wrap:!1}}),A=new me({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/monocular_depth_estimation.md"}}),{c(){m=i("meta"),j=a(),f=i("p"),D=a(),r(v.$$.fragment),et=a(),J=i("p"),J.textContent=Bt,st=a(),T=i("p"),T.textContent=Ht,lt=a(),r(y.$$.fragment),at=a(),U=i("p"),U.textContent=It,nt=a(),C=i("ul"),C.innerHTML=zt,it=a(),k=i("p"),k.textContent=Et,pt=a(),r(Z.$$.fragment),ot=a(),r(x.$$.fragment),mt=a(),W=i("p"),W.innerHTML=Vt,rt=a(),r(R.$$.fragment),ht=a(),_=i("p"),_.textContent=Nt,ct=a(),r(G.$$.fragment),dt=a(),w=i("div"),w.innerHTML=Xt,ut=a(),B=i("p"),B.textContent=Qt,gt=a(),r(H.$$.fragment),ft=a(),I=i("p"),I.innerHTML=Ft,Mt=a(),z=i("p"),z.textContent=Yt,yt=a(),r(E.$$.fragment),wt=a(),$=i("div"),$.innerHTML=St,$t=a(),r(V.$$.fragment),bt=a(),N=i("p"),N.textContent=Lt,jt=a(),X=i("p"),X.innerHTML=Pt,vt=a(),r(Q.$$.fragment),Jt=a(),F=i("p"),F.innerHTML=qt,Tt=a(),r(Y.$$.fragment),Ut=a(),S=i("p"),S.textContent=At,Ct=a(),r(L.$$.fragment),kt=a(),P=i("p"),P.textContent=Dt,Zt=a(),r(q.$$.fragment),xt=a(),b=i("div"),b.innerHTML=Kt,Wt=a(),r(A.$$.fragment),Rt=a(),K=i("p"),this.h()},l(t){const e=ie("svelte-u9bgzb",document.head);m=p(e,"META",{name:!0,content:!0}),e.forEach(s),j=n(t),f=p(t,"P",{}),te(f).forEach(s),D=n(t),h(v.$$.fragment,t),et=n(t),J=p(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1elgt0a"&&(J.textContent=Bt),st=n(t),T=p(t,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1bkqs5v"&&(T.textContent=Ht),lt=n(t),h(y.$$.fragment,t),at=n(t),U=p(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-jr2b5g"&&(U.textContent=It),nt=n(t),C=p(t,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-tj6led"&&(C.innerHTML=zt),it=n(t),k=p(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1c9nexd"&&(k.textContent=Et),pt=n(t),h(Z.$$.fragment,t),ot=n(t),h(x.$$.fragment,t),mt=n(t),W=p(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-12c4lty"&&(W.innerHTML=Vt),rt=n(t),h(R.$$.fragment,t),ht=n(t),_=p(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-wuz5lr"&&(_.textContent=Nt),ct=n(t),h(G.$$.fragment,t),dt=n(t),w=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-10bakl"&&(w.innerHTML=Xt),ut=n(t),B=p(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-mcr1tn"&&(B.textContent=Qt),gt=n(t),h(H.$$.fragment,t),ft=n(t),I=p(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1jckqfu"&&(I.innerHTML=Ft),Mt=n(t),z=p(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1dzpyfr"&&(z.textContent=Yt),yt=n(t),h(E.$$.fragment,t),wt=n(t),$=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o($)!=="svelte-43wxxb"&&($.innerHTML=St),$t=n(t),h(V.$$.fragment,t),bt=n(t),N=p(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1u79cc9"&&(N.textContent=Lt),jt=n(t),X=p(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1r8mctn"&&(X.innerHTML=Pt),vt=n(t),h(Q.$$.fragment,t),Jt=n(t),F=p(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-hhrw3"&&(F.innerHTML=qt),Tt=n(t),h(Y.$$.fragment,t),Ut=n(t),S=p(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1yk8q0z"&&(S.textContent=At),Ct=n(t),h(L.$$.fragment,t),kt=n(t),P=p(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-6ebm65"&&(P.textContent=Dt),Zt=n(t),h(q.$$.fragment,t),xt=n(t),b=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-43wxxb"&&(b.innerHTML=Kt),Wt=n(t),h(A.$$.fragment,t),Rt=n(t),K=p(t,"P",{}),te(K).forEach(s),this.h()},h(){O(m,"name","hf:doc:metadata"),O(m,"content",ce),O(w,"class","flex justify-center"),O($,"class","flex justify-center"),O(b,"class","flex justify-center")},m(t,e){pe(document.head,m),l(t,j,e),l(t,f,e),l(t,D,e),c(v,t,e),l(t,et,e),l(t,J,e),l(t,st,e),l(t,T,e),l(t,lt,e),c(y,t,e),l(t,at,e),l(t,U,e),l(t,nt,e),l(t,C,e),l(t,it,e),l(t,k,e),l(t,pt,e),c(Z,t,e),l(t,ot,e),c(x,t,e),l(t,mt,e),l(t,W,e),l(t,rt,e),c(R,t,e),l(t,ht,e),l(t,_,e),l(t,ct,e),c(G,t,e),l(t,dt,e),l(t,w,e),l(t,ut,e),l(t,B,e),l(t,gt,e),c(H,t,e),l(t,ft,e),l(t,I,e),l(t,Mt,e),l(t,z,e),l(t,yt,e),c(E,t,e),l(t,wt,e),l(t,$,e),l(t,$t,e),c(V,t,e),l(t,bt,e),l(t,N,e),l(t,jt,e),l(t,X,e),l(t,vt,e),c(Q,t,e),l(t,Jt,e),l(t,F,e),l(t,Tt,e),c(Y,t,e),l(t,Ut,e),l(t,S,e),l(t,Ct,e),c(L,t,e),l(t,kt,e),l(t,P,e),l(t,Zt,e),c(q,t,e),l(t,xt,e),l(t,b,e),l(t,Wt,e),c(A,t,e),l(t,Rt,e),l(t,K,e),_t=!0},p(t,[e]){const Ot={};e&2&&(Ot.$$scope={dirty:e,ctx:t}),y.$set(Ot)},i(t){_t||(d(v.$$.fragment,t),d(y.$$.fragment,t),d(Z.$$.fragment,t),d(x.$$.fragment,t),d(R.$$.fragment,t),d(G.$$.fragment,t),d(H.$$.fragment,t),d(E.$$.fragment,t),d(V.$$.fragment,t),d(Q.$$.fragment,t),d(Y.$$.fragment,t),d(L.$$.fragment,t),d(q.$$.fragment,t),d(A.$$.fragment,t),_t=!0)},o(t){u(v.$$.fragment,t),u(y.$$.fragment,t),u(Z.$$.fragment,t),u(x.$$.fragment,t),u(R.$$.fragment,t),u(G.$$.fragment,t),u(H.$$.fragment,t),u(E.$$.fragment,t),u(V.$$.fragment,t),u(Q.$$.fragment,t),u(Y.$$.fragment,t),u(L.$$.fragment,t),u(q.$$.fragment,t),u(A.$$.fragment,t),_t=!1},d(t){t&&(s(j),s(f),s(D),s(et),s(J),s(st),s(T),s(lt),s(at),s(U),s(nt),s(C),s(it),s(k),s(pt),s(ot),s(mt),s(W),s(rt),s(ht),s(_),s(ct),s(dt),s(w),s(ut),s(B),s(gt),s(ft),s(I),s(Mt),s(z),s(yt),s(wt),s($),s($t),s(bt),s(N),s(jt),s(X),s(vt),s(Jt),s(F),s(Tt),s(Ut),s(S),s(Ct),s(kt),s(P),s(Zt),s(xt),s(b),s(Wt),s(Rt),s(K)),s(m),g(v,t),g(y,t),g(Z,t),g(x,t),g(R,t),g(G,t),g(H,t),g(E,t),g(V,t),g(Q,t),g(Y,t),g(L,t),g(q,t),g(A,t)}}}const ce='{"title":"Monocular depth estimation","local":"monocular-depth-estimation","sections":[{"title":"Depth estimation pipeline","local":"depth-estimation-pipeline","sections":[],"depth":2},{"title":"Depth estimation inference by hand","local":"depth-estimation-inference-by-hand","sections":[],"depth":2}],"depth":1}';function de(tt){return se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class we extends ae{constructor(m){super(),ne(this,m,de,he,ee,{})}}export{we as component};
