import{s as De,n as Ne,o as Ye}from"../chunks/scheduler.9bc65507.js";import{S as Ke,i as Oe,g as i,s,r as d,A as et,h as l,f as n,c as o,j as X,u as m,x as g,k as E,y as r,a,v as h,d as u,t as f,w as _}from"../chunks/index.707bf1b6.js";import{D as ee}from"../chunks/Docstring.570ddb64.js";import{C as Se}from"../chunks/CodeBlock.54a9f38d.js";import{H as te,E as tt}from"../chunks/EditOnGithub.922df6ba.js";function nt(Ce){let b,ne,K,se,v,oe,w,ae,B,Le='BARTpho モデルは、Nguyen Luong Tran、Duong Minh Le、Dat Quoc Nguyen によって <a href="https://arxiv.org/abs/2109.09701" rel="nofollow">BARTpho: Pre-trained Sequence-to-Sequence Models for Vietnam</a> で提案されました。',re,$,Ie="論文の要約は次のとおりです。",ie,J,He=`<em>BARTpho には、BARTpho_word と BARTpho_syllable の 2 つのバージョンがあり、初の公開された大規模な単一言語です。
ベトナム語用に事前トレーニングされたシーケンスツーシーケンス モデル。当社の BARTpho は「大規模な」アーキテクチャと事前トレーニングを使用します
シーケンス間ノイズ除去モデル BART のスキームなので、生成 NLP タスクに特に適しています。実験
ベトナム語テキスト要約の下流タスクでは、自動評価と人間による評価の両方で、BARTpho が
強力なベースライン mBART を上回り、最先端の性能を向上させます。将来を容易にするためにBARTphoをリリースします
生成的なベトナム語 NLP タスクの研究と応用。</em>`,le,z,We='このモデルは <a href="https://huggingface.co/dqnguyen" rel="nofollow">dqnguyen</a> によって提供されました。元のコードは <a href="https://github.com/VinAIResearch/BARTpho" rel="nofollow">こちら</a> にあります。',pe,j,ce,U,de,x,me,R,Ze=`<li>mBARTに続いて、BARTphoはBARTの「大規模な」アーキテクチャを使用し、その上に追加の層正規化層を備えています。
エンコーダとデコーダの両方。したがって、<a href="bart">BART のドキュメント</a> の使用例は、使用に適応する場合に使用されます。
BARTpho を使用する場合は、BART に特化したクラスを mBART に特化した対応するクラスに置き換えることによって調整する必要があります。
例えば：</li>`,ge,q,he,C,Ve=`<li>この実装はトークン化のみを目的としています。<code>monolingual_vocab_file</code>はベトナム語に特化した型で構成されています
多言語 XLM-RoBERTa から利用できる事前トレーニング済み SentencePiece モデル<code>vocab_file</code>から抽出されます。
他の言語 (サブワードにこの事前トレーニング済み多言語 SentencePiece モデル<code>vocab_file</code>を使用する場合)
セグメンテーションにより、独自の言語に特化した<code>monolingual_vocab_file</code>を使用して BartphoTokenizer を再利用できます。</li>`,ue,L,fe,p,I,ve,Q,Ae='Adapted from <code>XLMRobertaTokenizer</code>. Based on <a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a>.',we,F,Xe=`This tokenizer inherits from <a href="/docs/transformers/pr_28250/ja/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Be,k,H,$e,P,Ee=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. An BARTPho sequence has the following format:`,Je,G,Qe="<li>single sequence: <code>&lt;s&gt; X &lt;/s&gt;</code></li> <li>pair of sequences: <code>&lt;s&gt; A &lt;/s&gt;&lt;/s&gt; B &lt;/s&gt;</code></li>",ze,T,W,je,S,Fe="Converts a sequence of tokens (strings for sub-words) in a single string.",Ue,y,Z,xe,D,Pe=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. BARTPho does not
make use of token type ids, therefore a list of zeros is returned.`,Re,M,V,qe,N,Ge=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,_e,A,ke,O,be;return v=new te({props:{title:"BARTpho",local:"bartpho",headingTag:"h1"}}),w=new te({props:{title:"Overview",local:"overview",headingTag:"h2"}}),j=new te({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),U=new Se({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWJhcnRwaG8lMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnZpbmFpJTJGYmFydHBoby1zeWxsYWJsZSUyMiklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ2aW5haSUyRmJhcnRwaG8tc3lsbGFibGUlMjIpJTBBJTBBbGluZSUyMCUzRCUyMCUyMkNoJUMzJUJBbmclMjB0JUMzJUI0aSUyMGwlQzMlQTAlMjBuaCVFMSVCQiVBRm5nJTIwbmdoaSVDMyVBQW4lMjBjJUUxJUJCJUE5dSUyMHZpJUMzJUFBbi4lMjIlMEElMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIobGluZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGZlYXR1cmVzJTIwJTNEJTIwYmFydHBobygqKmlucHV0X2lkcyklMjAlMjAlMjMlMjBNb2RlbHMlMjBvdXRwdXRzJTIwYXJlJTIwbm93JTIwdHVwbGVzJTBBJTBBJTIzJTIwV2l0aCUyMFRlbnNvckZsb3clMjAyLjAlMkIlM0ElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVEZBdXRvTW9kZWwlMEElMEFiYXJ0cGhvJTIwJTNEJTIwVEZBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnZpbmFpJTJGYmFydHBoby1zeWxsYWJsZSUyMiklMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIobGluZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBZmVhdHVyZXMlMjAlM0QlMjBiYXJ0cGhvKCoqaW5wdXRfaWRzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>bartpho = AutoModel.from_pretrained(<span class="hljs-string">&quot;vinai/bartpho-syllable&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;vinai/bartpho-syllable&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>line = <span class="hljs-string">&quot;Chúng tôi là những nghiên cứu viên.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(line, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    features = bartpho(**input_ids)  <span class="hljs-comment"># Models outputs are now tuples</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With TensorFlow 2.0+:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span>bartpho = TFAutoModel.from_pretrained(<span class="hljs-string">&quot;vinai/bartpho-syllable&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(line, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>features = bartpho(**input_ids)`,wrap:!1}}),x=new te({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),q=new Se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1CYXJ0Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBYmFydHBobyUyMCUzRCUyME1CYXJ0Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJ2aW5haSUyRmJhcnRwaG8tc3lsbGFibGUlMjIpJTBBVFhUJTIwJTNEJTIwJTIyQ2glQzMlQkFuZyUyMHQlQzMlQjRpJTIwbCVDMyVBMCUyMCUzQ21hc2slM0UlMjBuZ2hpJUMzJUFBbiUyMGMlRTElQkIlQTl1JTIwdmklQzMlQUFuLiUyMiUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglNUJUWFQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQWxvZ2l0cyUyMCUzRCUyMGJhcnRwaG8oaW5wdXRfaWRzKS5sb2dpdHMlMEFtYXNrZWRfaW5kZXglMjAlM0QlMjAoaW5wdXRfaWRzJTVCMCU1RCUyMCUzRCUzRCUyMHRva2VuaXplci5tYXNrX3Rva2VuX2lkKS5ub256ZXJvKCkuaXRlbSgpJTBBcHJvYnMlMjAlM0QlMjBsb2dpdHMlNUIwJTJDJTIwbWFza2VkX2luZGV4JTVELnNvZnRtYXgoZGltJTNEMCklMEF2YWx1ZXMlMkMlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMHByb2JzLnRvcGsoNSklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHByZWRpY3Rpb25zKS5zcGxpdCgpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MBartForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>bartpho = MBartForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;vinai/bartpho-syllable&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>TXT = <span class="hljs-string">&quot;Chúng tôi là &lt;mask&gt; nghiên cứu viên.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer([TXT], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = bartpho(input_ids).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masked_index = (input_ids[<span class="hljs-number">0</span>] == tokenizer.mask_token_id).nonzero().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits[<span class="hljs-number">0</span>, masked_index].softmax(dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>values, predictions = probs.topk(<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(predictions).split())`,wrap:!1}}),L=new te({props:{title:"BartphoTokenizer",local:"transformers.BartphoTokenizer",headingTag:"h2"}}),I=new ee({props:{name:"class transformers.BartphoTokenizer",anchor:"transformers.BartphoTokenizer",parameters:[{name:"vocab_file",val:""},{name:"monolingual_vocab_file",val:""},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"sp_model_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BartphoTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file. This vocabulary is the pre-trained SentencePiece model available from the
multilingual XLM-RoBERTa, also used in mBART, consisting of 250K types.`,name:"vocab_file"},{anchor:"transformers.BartphoTokenizer.monolingual_vocab_file",description:`<strong>monolingual_vocab_file</strong> (<code>str</code>) &#x2014;
Path to the monolingual vocabulary file. This monolingual vocabulary consists of Vietnamese-specialized
types extracted from the multilingual vocabulary vocab_file of 250K types.`,name:"monolingual_vocab_file"},{anchor:"transformers.BartphoTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.BartphoTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.BartphoTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.BartphoTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.BartphoTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.BartphoTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.BartphoTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.BartphoTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.BartphoTokenizer.sp_model",description:`<strong>sp_model</strong> (<code>SentencePieceProcessor</code>) &#x2014;
The <em>SentencePiece</em> processor that is used for every conversion (string, tokens and IDs).`,name:"sp_model"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/bartpho/tokenization_bartpho.py#L34"}}),H=new ee({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.BartphoTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.BartphoTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.BartphoTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/bartpho/tokenization_bartpho.py#L177",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),W=new ee({props:{name:"convert_tokens_to_string",anchor:"transformers.BartphoTokenizer.convert_tokens_to_string",parameters:[{name:"tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/bartpho/tokenization_bartpho.py#L279"}}),Z=new ee({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.BartphoTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.BartphoTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.BartphoTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/bartpho/tokenization_bartpho.py#L231",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of zeros.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),V=new ee({props:{name:"get_special_tokens_mask",anchor:"transformers.BartphoTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.BartphoTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.BartphoTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.BartphoTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/bartpho/tokenization_bartpho.py#L203",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),A=new tt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/model_doc/bartpho.md"}}),{c(){b=i("meta"),ne=s(),K=i("p"),se=s(),d(v.$$.fragment),oe=s(),d(w.$$.fragment),ae=s(),B=i("p"),B.innerHTML=Le,re=s(),$=i("p"),$.textContent=Ie,ie=s(),J=i("p"),J.innerHTML=He,le=s(),z=i("p"),z.innerHTML=We,pe=s(),d(j.$$.fragment),ce=s(),d(U.$$.fragment),de=s(),d(x.$$.fragment),me=s(),R=i("ul"),R.innerHTML=Ze,ge=s(),d(q.$$.fragment),he=s(),C=i("ul"),C.innerHTML=Ve,ue=s(),d(L.$$.fragment),fe=s(),p=i("div"),d(I.$$.fragment),ve=s(),Q=i("p"),Q.innerHTML=Ae,we=s(),F=i("p"),F.innerHTML=Xe,Be=s(),k=i("div"),d(H.$$.fragment),$e=s(),P=i("p"),P.textContent=Ee,Je=s(),G=i("ul"),G.innerHTML=Qe,ze=s(),T=i("div"),d(W.$$.fragment),je=s(),S=i("p"),S.textContent=Fe,Ue=s(),y=i("div"),d(Z.$$.fragment),xe=s(),D=i("p"),D.textContent=Pe,Re=s(),M=i("div"),d(V.$$.fragment),qe=s(),N=i("p"),N.innerHTML=Ge,_e=s(),d(A.$$.fragment),ke=s(),O=i("p"),this.h()},l(e){const t=et("svelte-u9bgzb",document.head);b=l(t,"META",{name:!0,content:!0}),t.forEach(n),ne=o(e),K=l(e,"P",{}),X(K).forEach(n),se=o(e),m(v.$$.fragment,e),oe=o(e),m(w.$$.fragment,e),ae=o(e),B=l(e,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1217tv1"&&(B.innerHTML=Le),re=o(e),$=l(e,"P",{"data-svelte-h":!0}),g($)!=="svelte-1cv3nri"&&($.textContent=Ie),ie=o(e),J=l(e,"P",{"data-svelte-h":!0}),g(J)!=="svelte-cjjv07"&&(J.innerHTML=He),le=o(e),z=l(e,"P",{"data-svelte-h":!0}),g(z)!=="svelte-1073njs"&&(z.innerHTML=We),pe=o(e),m(j.$$.fragment,e),ce=o(e),m(U.$$.fragment,e),de=o(e),m(x.$$.fragment,e),me=o(e),R=l(e,"UL",{"data-svelte-h":!0}),g(R)!=="svelte-1qs110o"&&(R.innerHTML=Ze),ge=o(e),m(q.$$.fragment,e),he=o(e),C=l(e,"UL",{"data-svelte-h":!0}),g(C)!=="svelte-11cg0gs"&&(C.innerHTML=Ve),ue=o(e),m(L.$$.fragment,e),fe=o(e),p=l(e,"DIV",{class:!0});var c=X(p);m(I.$$.fragment,c),ve=o(c),Q=l(c,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-11w33w6"&&(Q.innerHTML=Ae),we=o(c),F=l(c,"P",{"data-svelte-h":!0}),g(F)!=="svelte-1graj5"&&(F.innerHTML=Xe),Be=o(c),k=l(c,"DIV",{class:!0});var Y=X(k);m(H.$$.fragment,Y),$e=o(Y),P=l(Y,"P",{"data-svelte-h":!0}),g(P)!=="svelte-hazsjn"&&(P.textContent=Ee),Je=o(Y),G=l(Y,"UL",{"data-svelte-h":!0}),g(G)!=="svelte-rq8uot"&&(G.innerHTML=Qe),Y.forEach(n),ze=o(c),T=l(c,"DIV",{class:!0});var Te=X(T);m(W.$$.fragment,Te),je=o(Te),S=l(Te,"P",{"data-svelte-h":!0}),g(S)!=="svelte-1ne8awa"&&(S.textContent=Fe),Te.forEach(n),Ue=o(c),y=l(c,"DIV",{class:!0});var ye=X(y);m(Z.$$.fragment,ye),xe=o(ye),D=l(ye,"P",{"data-svelte-h":!0}),g(D)!=="svelte-1t18cnp"&&(D.textContent=Pe),ye.forEach(n),Re=o(c),M=l(c,"DIV",{class:!0});var Me=X(M);m(V.$$.fragment,Me),qe=o(Me),N=l(Me,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1f4f5kp"&&(N.innerHTML=Ge),Me.forEach(n),c.forEach(n),_e=o(e),m(A.$$.fragment,e),ke=o(e),O=l(e,"P",{}),X(O).forEach(n),this.h()},h(){E(b,"name","hf:doc:metadata"),E(b,"content",st),E(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),E(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,b),a(e,ne,t),a(e,K,t),a(e,se,t),h(v,e,t),a(e,oe,t),h(w,e,t),a(e,ae,t),a(e,B,t),a(e,re,t),a(e,$,t),a(e,ie,t),a(e,J,t),a(e,le,t),a(e,z,t),a(e,pe,t),h(j,e,t),a(e,ce,t),h(U,e,t),a(e,de,t),h(x,e,t),a(e,me,t),a(e,R,t),a(e,ge,t),h(q,e,t),a(e,he,t),a(e,C,t),a(e,ue,t),h(L,e,t),a(e,fe,t),a(e,p,t),h(I,p,null),r(p,ve),r(p,Q),r(p,we),r(p,F),r(p,Be),r(p,k),h(H,k,null),r(k,$e),r(k,P),r(k,Je),r(k,G),r(p,ze),r(p,T),h(W,T,null),r(T,je),r(T,S),r(p,Ue),r(p,y),h(Z,y,null),r(y,xe),r(y,D),r(p,Re),r(p,M),h(V,M,null),r(M,qe),r(M,N),a(e,_e,t),h(A,e,t),a(e,ke,t),a(e,O,t),be=!0},p:Ne,i(e){be||(u(v.$$.fragment,e),u(w.$$.fragment,e),u(j.$$.fragment,e),u(U.$$.fragment,e),u(x.$$.fragment,e),u(q.$$.fragment,e),u(L.$$.fragment,e),u(I.$$.fragment,e),u(H.$$.fragment,e),u(W.$$.fragment,e),u(Z.$$.fragment,e),u(V.$$.fragment,e),u(A.$$.fragment,e),be=!0)},o(e){f(v.$$.fragment,e),f(w.$$.fragment,e),f(j.$$.fragment,e),f(U.$$.fragment,e),f(x.$$.fragment,e),f(q.$$.fragment,e),f(L.$$.fragment,e),f(I.$$.fragment,e),f(H.$$.fragment,e),f(W.$$.fragment,e),f(Z.$$.fragment,e),f(V.$$.fragment,e),f(A.$$.fragment,e),be=!1},d(e){e&&(n(ne),n(K),n(se),n(oe),n(ae),n(B),n(re),n($),n(ie),n(J),n(le),n(z),n(pe),n(ce),n(de),n(me),n(R),n(ge),n(he),n(C),n(ue),n(fe),n(p),n(_e),n(ke),n(O)),n(b),_(v,e),_(w,e),_(j,e),_(U,e),_(x,e),_(q,e),_(L,e),_(I),_(H),_(W),_(Z),_(V),_(A,e)}}}const st='{"title":"BARTpho","local":"bartpho","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"BartphoTokenizer","local":"transformers.BartphoTokenizer","sections":[],"depth":2}],"depth":1}';function ot(Ce){return Ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ct extends Ke{constructor(b){super(),Oe(this,b,ot,nt,De,{})}}export{ct as component};
