import{s as Ct,f as xt,o as It,n as Te}from"../chunks/scheduler.bdbef820.js";import{S as Ut,i as kt,g as c,s as r,r as u,A as Jt,h as m,f as o,c as i,j as W,u as h,x as b,k as C,y as p,a,v as f,d as g,t as _,w}from"../chunks/index.33f81d56.js";import{T as jt}from"../chunks/Tip.34194030.js";import{D as pe}from"../chunks/Docstring.64554317.js";import{C as dt}from"../chunks/CodeBlock.362b34a4.js";import{E as lt}from"../chunks/ExampleCodeBlock.4f2252c6.js";import{H as ue,E as Ft}from"../chunks/EditOnGithub.a9246e21.js";function Wt(v){let n,y="Example:",l,d,S;return d=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN3aW4yU1JDb25maWclMkMlMjBTd2luMlNSTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3dpbjJTUiUyMGNhaWRhcyUyRnN3aW4yc3ItY2xhc3NpY2Fsc3IteDItNjQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3dpbjJTUkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjYWlkYXMlMkZzd2luMnNyLWNsYXNzaWNhbHNyLXgyLTY0JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBTd2luMlNSTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Swin2SRConfig, Swin2SRModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Swin2SR caidas/swin2sr-classicalsr-x2-64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Swin2SRConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the caidas/swin2sr-classicalsr-x2-64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Swin2SRModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,l=r(),u(d.$$.fragment)},l(s){n=m(s,"P",{"data-svelte-h":!0}),b(n)!=="svelte-11lpom8"&&(n.textContent=y),l=i(s),h(d.$$.fragment,s)},m(s,M){a(s,n,M),a(s,l,M),f(d,s,M),S=!0},p:Te,i(s){S||(g(d.$$.fragment,s),S=!0)},o(s){_(d.$$.fragment,s),S=!1},d(s){s&&(o(n),o(l)),w(d,s)}}}function zt(v){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=y},l(l){n=m(l,"P",{"data-svelte-h":!0}),b(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(l,d){a(l,n,d)},p:Te,d(l){l&&o(n)}}}function Nt(v){let n,y="Example:",l,d,S;return d=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW4yU1JNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyY2FpZGFzJTJGc3dpbjJTUi1jbGFzc2ljYWwtc3IteDItNjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBTd2luMlNSTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmNhaWRhcyUyRnN3aW4yU1ItY2xhc3NpY2FsLXNyLXgyLTY0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Swin2SRModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-classical-sr-x2-64&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Swin2SRModel.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-classical-sr-x2-64&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">180</span>, <span class="hljs-number">488</span>, <span class="hljs-number">648</span>]`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,l=r(),u(d.$$.fragment)},l(s){n=m(s,"P",{"data-svelte-h":!0}),b(n)!=="svelte-11lpom8"&&(n.textContent=y),l=i(s),h(d.$$.fragment,s)},m(s,M){a(s,n,M),a(s,l,M),f(d,s,M),S=!0},p:Te,i(s){S||(g(d.$$.fragment,s),S=!0)},o(s){_(d.$$.fragment,s),S=!1},d(s){s&&(o(n),o(l)),w(d,s)}}}function Zt(v){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=y},l(l){n=m(l,"P",{"data-svelte-h":!0}),b(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(l,d){a(l,n,d)},p:Te,d(l){l&&o(n)}}}function Bt(v){let n,y="Example:",l,d,S;return d=new dt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMkMlMjBTd2luMlNSRm9ySW1hZ2VTdXBlclJlc29sdXRpb24lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmNhaWRhcyUyRnN3aW4yU1ItY2xhc3NpY2FsLXNyLXgyLTY0JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3dpbjJTUkZvckltYWdlU3VwZXJSZXNvbHV0aW9uLmZyb21fcHJldHJhaW5lZCglMjJjYWlkYXMlMkZzd2luMlNSLWNsYXNzaWNhbC1zci14Mi02NCUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGampvdXJuZXkxMTI1JTJGc3dpbjJzciUyRnJlc29sdmUlMkZtYWluJTJGc2FtcGxlcyUyRmJ1dHRlcmZseS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMjMlMjBwcmVwYXJlJTIwaW1hZ2UlMjBmb3IlMjB0aGUlMjBtb2RlbCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQW91dHB1dCUyMCUzRCUyMG91dHB1dHMucmVjb25zdHJ1Y3Rpb24uZGF0YS5zcXVlZXplKCkuZmxvYXQoKS5jcHUoKS5jbGFtcF8oMCUyQyUyMDEpLm51bXB5KCklMEFvdXRwdXQlMjAlM0QlMjBucC5tb3ZlYXhpcyhvdXRwdXQlMkMlMjBzb3VyY2UlM0QwJTJDJTIwZGVzdGluYXRpb24lM0QtMSklMEFvdXRwdXQlMjAlM0QlMjAob3V0cHV0JTIwKiUyMDI1NS4wKS5yb3VuZCgpLmFzdHlwZShucC51aW50OCklMjAlMjAlMjMlMjBmbG9hdDMyJTIwdG8lMjB1aW50OCUwQSUyMyUyMHlvdSUyMGNhbiUyMHZpc3VhbGl6ZSUyMCU2MG91dHB1dCU2MCUyMHdpdGglMjAlNjBJbWFnZS5mcm9tYXJyYXklNjA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Swin2SRForImageSuperResolution

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-classical-sr-x2-64&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Swin2SRForImageSuperResolution.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-classical-sr-x2-64&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/spaces/jjourney1125/swin2sr/resolve/main/samples/butterfly.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = outputs.reconstruction.data.squeeze().<span class="hljs-built_in">float</span>().cpu().clamp_(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = np.moveaxis(output, source=<span class="hljs-number">0</span>, destination=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = (output * <span class="hljs-number">255.0</span>).<span class="hljs-built_in">round</span>().astype(np.uint8)  <span class="hljs-comment"># float32 to uint8</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can visualize \`output\` with \`Image.fromarray\`</span>`,wrap:!1}}),{c(){n=c("p"),n.textContent=y,l=r(),u(d.$$.fragment)},l(s){n=m(s,"P",{"data-svelte-h":!0}),b(n)!=="svelte-11lpom8"&&(n.textContent=y),l=i(s),h(d.$$.fragment,s)},m(s,M){a(s,n,M),a(s,l,M),f(d,s,M),S=!0},p:Te,i(s){S||(g(d.$$.fragment,s),S=!0)},o(s){_(d.$$.fragment,s),S=!1},d(s){s&&(o(n),o(l)),w(d,s)}}}function Pt(v){let n,y,l,d,S,s,M,ve,X,ct=`Swin2SR 모델은 Marcos V. Conde, Ui-Jin Choi, Maxime Burchi, Radu Timofte가 제안한 논문 <a href="https://arxiv.org/abs/2209.11345" rel="nofollow">Swin2SR: SwinV2 Transformer for Compressed Image Super-Resolution and Restoration</a>에서 소개되었습니다.
Swin2SR은 <a href="https://github.com/JingyunLiang/SwinIR/" rel="nofollow">SwinIR</a> 모델을 개선하고자 <a href="swinv2">Swin Transformer v2</a> 레이어를 도입함으로써, 훈련 불안정성, 사전 훈련과 미세 조정 간의 해상도 차이, 그리고 데이터 의존성 문제를 완화시킵니다.`,$e,V,mt="논문의 초록은 다음과 같습니다:",je,E,pt="<em>압축은 스트리밍 서비스, 가상 현실, 비디오 게임과 같은 대역폭이 제한된 시스템을 통해 이미지와 영상을 효율적으로 전송하고 저장하는 데 중요한 역할을 합니다. 하지만 압축은 필연적으로 원본 정보의 손실과 아티팩트를 초래하며, 이는 시각적 품질을 심각하게 저하시킬 수 있습니다. 이러한 이유로, 압축된 이미지의 품질 향상은 활발한 연구 주제가 되고 있습니다. 현재 대부분의 최첨단 이미지 복원 방법은 합성곱 신경망을 기반으로 하지만, SwinIR과 같은 트랜스포머 기반 방법들도 이 작업에서 인상적인 성능을 보여주고 있습니다. 이번 논문에서는 Swin Transformer V2를 사용해 SwinIR을 개선하여 이미지 초해상도 작업, 특히 압축된 입력 시나리오에서 성능을 향상시키고자 합니다. 이 방법을 통해 트랜스포머 비전 모델을 훈련할 때 발생하는 주요 문제들, 예를 들어 훈련 불안정성, 사전 훈련과 미세 조정 간 해상도 차이, 그리고 데이터 의존성을 해결할 수 있습니다. 우리는 JPEG 압축 아티팩트 제거, 이미지 초해상도(클래식 및 경량), 그리고 압축된 이미지 초해상도라는 세 가지 대표적인 작업에서 실험을 수행했습니다. 실험 결과, 우리의 방법인 Swin2SR은 SwinIR의 훈련 수렴성과 성능을 향상시킬 수 있으며, “AIM 2022 Challenge on Super-Resolution of Compressed Image and Video”에서 상위 5위 솔루션으로 선정되었습니다.</em>",Ce,z,ut,xe,Y,ht='Swin2SR 아키텍처. <a href="https://arxiv.org/abs/2209.11345">원본 논문</a>에서 발췌.',Ie,Q,ft=`이 모델은 <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>가 기여하였습니다.
원본 코드는 <a href="https://github.com/mv-lab/swin2sr" rel="nofollow">여기</a>에서 확인할 수 있습니다.`,Ue,A,ke,D,gt='Swin2SR demo notebook은 <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Swin2SR" rel="nofollow">여기</a>에서 확인할 수 있습니다.',Je,O,_t='SwinSR을 활용한 image super-resolution demo space는 <a href="https://huggingface.co/spaces/jjourney1125/swin2sr" rel="nofollow">여기</a>에서 확인할 수 있습니다.',Fe,K,We,x,ee,Xe,he,wt="Constructs a Swin2SR image processor.",Ve,N,te,Ee,fe,St="Preprocess an image or batch of images.",ze,oe,Ne,R,ne,Ye,ge,bt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_28250/ko/model_doc/swin2sr#transformers.Swin2SRModel">Swin2SRModel</a>. It is used to instantiate a Swin
Transformer v2 model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Swin Transformer v2
<a href="https://huggingface.co/caidas/swin2sr-classicalsr-x2-64" rel="nofollow">caidas/swin2sr-classicalsr-x2-64</a> architecture.`,Qe,_e,yt=`Configuration objects inherit from <a href="/docs/transformers/pr_28250/ko/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_28250/ko/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ae,Z,Ze,se,Be,I,ae,De,we,Mt=`The bare Swin2SR Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Oe,$,re,Ke,Se,Rt='The <a href="/docs/transformers/pr_28250/ko/model_doc/swin2sr#transformers.Swin2SRModel">Swin2SRModel</a> forward method, overrides the <code>__call__</code> special method.',et,B,tt,P,Pe,ie,He,T,le,ot,be,Tt="Swin2SR Model transformer with an upsampler head on top for image super resolution and restoration.",nt,ye,vt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,st,j,de,at,Me,$t='The <a href="/docs/transformers/pr_28250/ko/model_doc/swin2sr#transformers.Swin2SRForImageSuperResolution">Swin2SRForImageSuperResolution</a> forward method, overrides the <code>__call__</code> special method.',rt,H,it,G,Ge,ce,Le,Re,qe;return S=new ue({props:{title:"Swin2SR",local:"swin2sr",headingTag:"h1"}}),M=new ue({props:{title:"개요",local:"overview",headingTag:"h2"}}),A=new ue({props:{title:"리소스",local:"resources",headingTag:"h2"}}),K=new ue({props:{title:"Swin2SRImageProcessor",local:"transformers.Swin2SRImageProcessor ][ transformers.Swin2SRImageProcessor",headingTag:"h2"}}),ee=new pe({props:{name:"class transformers.Swin2SRImageProcessor",anchor:"transformers.Swin2SRImageProcessor",parameters:[{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_pad",val:": bool = True"},{name:"pad_size",val:": int = 8"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.Swin2SRImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/swin2sr/image_processing_swin2sr.py#L39"}}),te=new pe({props:{name:"preprocess",anchor:"transformers.Swin2SRImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"pad_size",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[transformers.image_utils.ChannelDimension, str, NoneType] = None"}],parametersDescription:[{anchor:"transformers.Swin2SRImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to make the height and width divisible by <code>window_size</code>.`,name:"do_pad"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The size of the sliding window for the local attention.`,name:"pad_size"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of typ, input_data_format=input_data_formate
<code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/swin2sr/image_processing_swin2sr.py#L110"}}),oe=new ue({props:{title:"Swin2SRConfig",local:"transformers.Swin2SRConfig ][ transformers.Swin2SRConfig",headingTag:"h2"}}),ne=new pe({props:{name:"class transformers.Swin2SRConfig",anchor:"transformers.Swin2SRConfig",parameters:[{name:"image_size",val:" = 64"},{name:"patch_size",val:" = 1"},{name:"num_channels",val:" = 3"},{name:"num_channels_out",val:" = None"},{name:"embed_dim",val:" = 180"},{name:"depths",val:" = [6, 6, 6, 6, 6, 6]"},{name:"num_heads",val:" = [6, 6, 6, 6, 6, 6]"},{name:"window_size",val:" = 8"},{name:"mlp_ratio",val:" = 2.0"},{name:"qkv_bias",val:" = True"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"drop_path_rate",val:" = 0.1"},{name:"hidden_act",val:" = 'gelu'"},{name:"use_absolute_embeddings",val:" = False"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"upscale",val:" = 2"},{name:"img_range",val:" = 1.0"},{name:"resi_connection",val:" = '1conv'"},{name:"upsampler",val:" = 'pixelshuffle'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.Swin2SRConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.Swin2SRConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.Swin2SRConfig.num_channels_out",description:`<strong>num_channels_out</strong> (<code>int</code>, <em>optional</em>, defaults to <code>num_channels</code>) &#x2014;
The number of output channels. If not set, it will be set to <code>num_channels</code>.`,name:"num_channels_out"},{anchor:"transformers.Swin2SRConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 180) &#x2014;
Dimensionality of patch embedding.`,name:"embed_dim"},{anchor:"transformers.Swin2SRConfig.depths",description:`<strong>depths</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[6, 6, 6, 6, 6, 6]</code>) &#x2014;
Depth of each layer in the Transformer encoder.`,name:"depths"},{anchor:"transformers.Swin2SRConfig.num_heads",description:`<strong>num_heads</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[6, 6, 6, 6, 6, 6]</code>) &#x2014;
Number of attention heads in each layer of the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.Swin2SRConfig.window_size",description:`<strong>window_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Size of windows.`,name:"window_size"},{anchor:"transformers.Swin2SRConfig.mlp_ratio",description:`<strong>mlp_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Ratio of MLP hidden dimensionality to embedding dimensionality.`,name:"mlp_ratio"},{anchor:"transformers.Swin2SRConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not a learnable bias should be added to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.Swin2SRConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings and encoder.`,name:"hidden_dropout_prob"},{anchor:"transformers.Swin2SRConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.Swin2SRConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Stochastic depth rate.`,name:"drop_path_rate"},{anchor:"transformers.Swin2SRConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Swin2SRConfig.use_absolute_embeddings",description:`<strong>use_absolute_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add absolute position embeddings to the patch embeddings.`,name:"use_absolute_embeddings"},{anchor:"transformers.Swin2SRConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Swin2SRConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Swin2SRConfig.upscale",description:`<strong>upscale</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The upscale factor for the image. 2/3/4/8 for image super resolution, 1 for denoising and compress artifact
reduction`,name:"upscale"},{anchor:"transformers.Swin2SRConfig.img_range",description:`<strong>img_range</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The range of the values of the input image.`,name:"img_range"},{anchor:"transformers.Swin2SRConfig.resi_connection",description:`<strong>resi_connection</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;1conv&quot;</code>) &#x2014;
The convolutional block to use before the residual connection in each stage.`,name:"resi_connection"},{anchor:"transformers.Swin2SRConfig.upsampler",description:`<strong>upsampler</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pixelshuffle&quot;</code>) &#x2014;
The reconstruction reconstruction module. Can be &#x2018;pixelshuffle&#x2019;/&#x2018;pixelshuffledirect&#x2019;/&#x2018;nearest+conv&#x2019;/None.`,name:"upsampler"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/swin2sr/configuration_swin2sr.py#L24"}}),Z=new lt({props:{anchor:"transformers.Swin2SRConfig.example",$$slots:{default:[Wt]},$$scope:{ctx:v}}}),se=new ue({props:{title:"Swin2SRModel",local:"transformers.Swin2SRModel ][ transformers.Swin2SRModel",headingTag:"h2"}}),ae=new pe({props:{name:"class transformers.Swin2SRModel",anchor:"transformers.Swin2SRModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28250/ko/model_doc/swin2sr#transformers.Swin2SRConfig">Swin2SRConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28250/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/swin2sr/modeling_swin2sr.py#L806"}}),re=new pe({props:{name:"forward",anchor:"transformers.Swin2SRModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Swin2SRModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_28250/ko/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/pr_28250/ko/model_doc/vit#transformers.ViTFeatureExtractor.__call__">Swin2SRImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.Swin2SRModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Swin2SRModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Swin2SRModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Swin2SRModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28250/ko/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/swin2sr/modeling_swin2sr.py#L859",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28250/ko/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28250/ko/model_doc/swin2sr#transformers.Swin2SRConfig"
>Swin2SRConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28250/ko/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new jt({props:{$$slots:{default:[zt]},$$scope:{ctx:v}}}),P=new lt({props:{anchor:"transformers.Swin2SRModel.forward.example",$$slots:{default:[Nt]},$$scope:{ctx:v}}}),ie=new ue({props:{title:"Swin2SRForImageSuperResolution",local:"transformers.Swin2SRForImageSuperResolution ][ transformers.Swin2SRForImageSuperResolution",headingTag:"h2"}}),le=new pe({props:{name:"class transformers.Swin2SRForImageSuperResolution",anchor:"transformers.Swin2SRForImageSuperResolution",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRForImageSuperResolution.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28250/ko/model_doc/swin2sr#transformers.Swin2SRConfig">Swin2SRConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28250/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/swin2sr/modeling_swin2sr.py#L1060"}}),de=new pe({props:{name:"forward",anchor:"transformers.Swin2SRForImageSuperResolution.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Swin2SRForImageSuperResolution.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_28250/ko/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/pr_28250/ko/model_doc/vit#transformers.ViTFeatureExtractor.__call__">Swin2SRImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.Swin2SRForImageSuperResolution.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Swin2SRForImageSuperResolution.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Swin2SRForImageSuperResolution.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Swin2SRForImageSuperResolution.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28250/ko/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_28250/src/transformers/models/swin2sr/modeling_swin2sr.py#L1093",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.ImageSuperResolutionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28250/ko/model_doc/swin2sr#transformers.Swin2SRConfig"
>Swin2SRConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Reconstruction loss.</p>
</li>
<li>
<p><strong>reconstruction</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Reconstructed images, possibly upscaled.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.ImageSuperResolutionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),H=new jt({props:{$$slots:{default:[Zt]},$$scope:{ctx:v}}}),G=new lt({props:{anchor:"transformers.Swin2SRForImageSuperResolution.forward.example",$$slots:{default:[Bt]},$$scope:{ctx:v}}}),ce=new Ft({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/model_doc/swin2sr.md"}}),{c(){n=c("meta"),y=r(),l=c("p"),d=r(),u(S.$$.fragment),s=r(),u(M.$$.fragment),ve=r(),X=c("p"),X.innerHTML=ct,$e=r(),V=c("p"),V.textContent=mt,je=r(),E=c("p"),E.innerHTML=pt,Ce=r(),z=c("img"),xe=r(),Y=c("small"),Y.innerHTML=ht,Ie=r(),Q=c("p"),Q.innerHTML=ft,Ue=r(),u(A.$$.fragment),ke=r(),D=c("p"),D.innerHTML=gt,Je=r(),O=c("p"),O.innerHTML=_t,Fe=r(),u(K.$$.fragment),We=r(),x=c("div"),u(ee.$$.fragment),Xe=r(),he=c("p"),he.textContent=wt,Ve=r(),N=c("div"),u(te.$$.fragment),Ee=r(),fe=c("p"),fe.textContent=St,ze=r(),u(oe.$$.fragment),Ne=r(),R=c("div"),u(ne.$$.fragment),Ye=r(),ge=c("p"),ge.innerHTML=bt,Qe=r(),_e=c("p"),_e.innerHTML=yt,Ae=r(),u(Z.$$.fragment),Ze=r(),u(se.$$.fragment),Be=r(),I=c("div"),u(ae.$$.fragment),De=r(),we=c("p"),we.innerHTML=Mt,Oe=r(),$=c("div"),u(re.$$.fragment),Ke=r(),Se=c("p"),Se.innerHTML=Rt,et=r(),u(B.$$.fragment),tt=r(),u(P.$$.fragment),Pe=r(),u(ie.$$.fragment),He=r(),T=c("div"),u(le.$$.fragment),ot=r(),be=c("p"),be.textContent=Tt,nt=r(),ye=c("p"),ye.innerHTML=vt,st=r(),j=c("div"),u(de.$$.fragment),at=r(),Me=c("p"),Me.innerHTML=$t,rt=r(),u(H.$$.fragment),it=r(),u(G.$$.fragment),Ge=r(),u(ce.$$.fragment),Le=r(),Re=c("p"),this.h()},l(e){const t=Jt("svelte-u9bgzb",document.head);n=m(t,"META",{name:!0,content:!0}),t.forEach(o),y=i(e),l=m(e,"P",{}),W(l).forEach(o),d=i(e),h(S.$$.fragment,e),s=i(e),h(M.$$.fragment,e),ve=i(e),X=m(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-hg59aq"&&(X.innerHTML=ct),$e=i(e),V=m(e,"P",{"data-svelte-h":!0}),b(V)!=="svelte-e5r8wp"&&(V.textContent=mt),je=i(e),E=m(e,"P",{"data-svelte-h":!0}),b(E)!=="svelte-18wtzno"&&(E.innerHTML=pt),Ce=i(e),z=m(e,"IMG",{src:!0,alt:!0,width:!0}),xe=i(e),Y=m(e,"SMALL",{"data-svelte-h":!0}),b(Y)!=="svelte-1g9yt3w"&&(Y.innerHTML=ht),Ie=i(e),Q=m(e,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-1sy3i4l"&&(Q.innerHTML=ft),Ue=i(e),h(A.$$.fragment,e),ke=i(e),D=m(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-1pfatz2"&&(D.innerHTML=gt),Je=i(e),O=m(e,"P",{"data-svelte-h":!0}),b(O)!=="svelte-6y3neo"&&(O.innerHTML=_t),Fe=i(e),h(K.$$.fragment,e),We=i(e),x=m(e,"DIV",{class:!0});var J=W(x);h(ee.$$.fragment,J),Xe=i(J),he=m(J,"P",{"data-svelte-h":!0}),b(he)!=="svelte-1jih302"&&(he.textContent=wt),Ve=i(J),N=m(J,"DIV",{class:!0});var me=W(N);h(te.$$.fragment,me),Ee=i(me),fe=m(me,"P",{"data-svelte-h":!0}),b(fe)!=="svelte-1x3yxsa"&&(fe.textContent=St),me.forEach(o),J.forEach(o),ze=i(e),h(oe.$$.fragment,e),Ne=i(e),R=m(e,"DIV",{class:!0});var U=W(R);h(ne.$$.fragment,U),Ye=i(U),ge=m(U,"P",{"data-svelte-h":!0}),b(ge)!=="svelte-jxuwlz"&&(ge.innerHTML=bt),Qe=i(U),_e=m(U,"P",{"data-svelte-h":!0}),b(_e)!=="svelte-4blsb7"&&(_e.innerHTML=yt),Ae=i(U),h(Z.$$.fragment,U),U.forEach(o),Ze=i(e),h(se.$$.fragment,e),Be=i(e),I=m(e,"DIV",{class:!0});var F=W(I);h(ae.$$.fragment,F),De=i(F),we=m(F,"P",{"data-svelte-h":!0}),b(we)!=="svelte-8sq17a"&&(we.innerHTML=Mt),Oe=i(F),$=m(F,"DIV",{class:!0});var k=W($);h(re.$$.fragment,k),Ke=i(k),Se=m(k,"P",{"data-svelte-h":!0}),b(Se)!=="svelte-7qzxk3"&&(Se.innerHTML=Rt),et=i(k),h(B.$$.fragment,k),tt=i(k),h(P.$$.fragment,k),k.forEach(o),F.forEach(o),Pe=i(e),h(ie.$$.fragment,e),He=i(e),T=m(e,"DIV",{class:!0});var L=W(T);h(le.$$.fragment,L),ot=i(L),be=m(L,"P",{"data-svelte-h":!0}),b(be)!=="svelte-31vje8"&&(be.textContent=Tt),nt=i(L),ye=m(L,"P",{"data-svelte-h":!0}),b(ye)!=="svelte-68lg8f"&&(ye.innerHTML=vt),st=i(L),j=m(L,"DIV",{class:!0});var q=W(j);h(de.$$.fragment,q),at=i(q),Me=m(q,"P",{"data-svelte-h":!0}),b(Me)!=="svelte-h9w0o7"&&(Me.innerHTML=$t),rt=i(q),h(H.$$.fragment,q),it=i(q),h(G.$$.fragment,q),q.forEach(o),L.forEach(o),Ge=i(e),h(ce.$$.fragment,e),Le=i(e),Re=m(e,"P",{}),W(Re).forEach(o),this.h()},h(){C(n,"name","hf:doc:metadata"),C(n,"content",Ht),xt(z.src,ut="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/swin2sr_architecture.png")||C(z,"src",ut),C(z,"alt","drawing"),C(z,"width","600"),C(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,n),a(e,y,t),a(e,l,t),a(e,d,t),f(S,e,t),a(e,s,t),f(M,e,t),a(e,ve,t),a(e,X,t),a(e,$e,t),a(e,V,t),a(e,je,t),a(e,E,t),a(e,Ce,t),a(e,z,t),a(e,xe,t),a(e,Y,t),a(e,Ie,t),a(e,Q,t),a(e,Ue,t),f(A,e,t),a(e,ke,t),a(e,D,t),a(e,Je,t),a(e,O,t),a(e,Fe,t),f(K,e,t),a(e,We,t),a(e,x,t),f(ee,x,null),p(x,Xe),p(x,he),p(x,Ve),p(x,N),f(te,N,null),p(N,Ee),p(N,fe),a(e,ze,t),f(oe,e,t),a(e,Ne,t),a(e,R,t),f(ne,R,null),p(R,Ye),p(R,ge),p(R,Qe),p(R,_e),p(R,Ae),f(Z,R,null),a(e,Ze,t),f(se,e,t),a(e,Be,t),a(e,I,t),f(ae,I,null),p(I,De),p(I,we),p(I,Oe),p(I,$),f(re,$,null),p($,Ke),p($,Se),p($,et),f(B,$,null),p($,tt),f(P,$,null),a(e,Pe,t),f(ie,e,t),a(e,He,t),a(e,T,t),f(le,T,null),p(T,ot),p(T,be),p(T,nt),p(T,ye),p(T,st),p(T,j),f(de,j,null),p(j,at),p(j,Me),p(j,rt),f(H,j,null),p(j,it),f(G,j,null),a(e,Ge,t),f(ce,e,t),a(e,Le,t),a(e,Re,t),qe=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),Z.$set(J);const me={};t&2&&(me.$$scope={dirty:t,ctx:e}),B.$set(me);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),P.$set(U);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),H.$set(F);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),G.$set(k)},i(e){qe||(g(S.$$.fragment,e),g(M.$$.fragment,e),g(A.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(Z.$$.fragment,e),g(se.$$.fragment,e),g(ae.$$.fragment,e),g(re.$$.fragment,e),g(B.$$.fragment,e),g(P.$$.fragment,e),g(ie.$$.fragment,e),g(le.$$.fragment,e),g(de.$$.fragment,e),g(H.$$.fragment,e),g(G.$$.fragment,e),g(ce.$$.fragment,e),qe=!0)},o(e){_(S.$$.fragment,e),_(M.$$.fragment,e),_(A.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(Z.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(B.$$.fragment,e),_(P.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(H.$$.fragment,e),_(G.$$.fragment,e),_(ce.$$.fragment,e),qe=!1},d(e){e&&(o(y),o(l),o(d),o(s),o(ve),o(X),o($e),o(V),o(je),o(E),o(Ce),o(z),o(xe),o(Y),o(Ie),o(Q),o(Ue),o(ke),o(D),o(Je),o(O),o(Fe),o(We),o(x),o(ze),o(Ne),o(R),o(Ze),o(Be),o(I),o(Pe),o(He),o(T),o(Ge),o(Le),o(Re)),o(n),w(S,e),w(M,e),w(A,e),w(K,e),w(ee),w(te),w(oe,e),w(ne),w(Z),w(se,e),w(ae),w(re),w(B),w(P),w(ie,e),w(le),w(de),w(H),w(G),w(ce,e)}}}const Ht='{"title":"Swin2SR","local":"swin2sr","sections":[{"title":"개요","local":"overview","sections":[],"depth":2},{"title":"리소스","local":"resources","sections":[],"depth":2},{"title":"Swin2SRImageProcessor","local":"transformers.Swin2SRImageProcessor ][ transformers.Swin2SRImageProcessor","sections":[],"depth":2},{"title":"Swin2SRConfig","local":"transformers.Swin2SRConfig ][ transformers.Swin2SRConfig","sections":[],"depth":2},{"title":"Swin2SRModel","local":"transformers.Swin2SRModel ][ transformers.Swin2SRModel","sections":[],"depth":2},{"title":"Swin2SRForImageSuperResolution","local":"transformers.Swin2SRForImageSuperResolution ][ transformers.Swin2SRForImageSuperResolution","sections":[],"depth":2}],"depth":1}';function Gt(v){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends Ut{constructor(n){super(),kt(this,n,Gt,Pt,Ct,{})}}export{At as component};
