import{s as Wo,o as zo,n as no}from"../chunks/scheduler.25b97de1.js";import{S as xo,i as $o,g as r,s as n,r as c,A as Ro,h as l,f as o,c as s,j as L,u as m,x as M,k,y as i,a as t,v as p,d as h,t as g,w as f}from"../chunks/index.d9030fc9.js";import{T as Fo}from"../chunks/Tip.baa67368.js";import{D as G}from"../chunks/Docstring.e257edda.js";import{C as A}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Go}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as I,E as No}from"../chunks/EditOnGithub.91d95064.js";function So(W){let u,J="Example:",_,y,v;return y=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBWaWRlb0xsYXZhQ29uZmlnJTJDJTIwQ0xJUFZpc2lvbkNvbmZpZyUyQyUyMExsYW1hQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMENMSVAtdmlzaW9uJTIwY29uZmlnJTBBdmlzaW9uX2NvbmZpZyUyMCUzRCUyMENMSVBWaXNpb25Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMbGFtYSUyMGNvbmZpZyUwQXRleHRfY29uZmlnJTIwJTNEJTIwTGxhbWFDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBWaWRlb0xsYXZhJTIwdmlkZW9fbGxhdmEtMS41LTdiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFZpZGVvTGxhdmFDb25maWcodmlzaW9uX2NvbmZpZyUyQyUyMHRleHRfY29uZmlnKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjB2aWRlb19sbGF2YS0xLjUtN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, VideoLlavaConfig, CLIPVisionConfig, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = CLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a VideoLlava video_llava-1.5-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VideoLlavaConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the video_llava-1.5-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoLlavaForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){u=r("p"),u.textContent=J,_=n(),c(y.$$.fragment)},l(d){u=l(d,"P",{"data-svelte-h":!0}),M(u)!=="svelte-11lpom8"&&(u.textContent=J),_=s(d),m(y.$$.fragment,d)},m(d,T){t(d,u,T),t(d,_,T),p(y,d,T),v=!0},p:no,i(d){v||(h(y.$$.fragment,d),v=!0)},o(d){g(y.$$.fragment,d),v=!1},d(d){d&&(o(u),o(_)),f(y,d)}}}function Eo(W){let u,J=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){u=r("p"),u.innerHTML=J},l(_){u=l(_,"P",{"data-svelte-h":!0}),M(u)!=="svelte-fincs2"&&(u.innerHTML=J)},m(_,y){t(_,u,y)},p:no,d(_){_&&o(u)}}}function Xo(W){let u,J="Example:",_,y,v;return y=new A({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaProcessor, VideoLlavaForConditionalGeneration


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])

<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VideoLlavaProcessor.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;USER: &lt;video&gt;Why is this video funny? ASSISTANT:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(video_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample uniformly 8 frames from the video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>clip = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, videos=clip, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">80</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;USER:  Why is this video funny? ASSISTANT: The video is funny because the baby is playing with a Wii remote while sitting on the floor, and the baby is wearing glasses.Ъ. The baby&#x27;s actions are amusing because it is a young child trying to interact with a video game, which is not a typical activity for a&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to generate from image and video mix</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;USER: &lt;image&gt; How many cats do you see? ASSISTANT:&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;USER: &lt;video&gt;Why is this video funny? ASSISTANT:&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, images=image, videos=clip, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;USER:   How many cats do you see? ASSISTANT: There are two cats visible in the image. (or three, if you count the one in the background).&#x27;</span>, <span class="hljs-string">&#x27;USER:  Why is this video funny? ASSISTANT: The video is funny because it shows a baby sitting on a bed and playing with a Wii remote.Ъ. The baby is holding the remote&#x27;</span>]`,wrap:!1}}),{c(){u=r("p"),u.textContent=J,_=n(),c(y.$$.fragment)},l(d){u=l(d,"P",{"data-svelte-h":!0}),M(u)!=="svelte-11lpom8"&&(u.textContent=J),_=s(d),m(y.$$.fragment,d)},m(d,T){t(d,u,T),t(d,_,T),p(y,d,T),v=!0},p:no,i(d){v||(h(y.$$.fragment,d),v=!0)},o(d){g(y.$$.fragment,d),v=!1},d(d){d&&(o(u),o(_)),f(y,d)}}}function Ao(W){let u,J,_,y,v,d,T,He,Y,so="Video-LLaVa is an open-source multimodal LLM trained by fine-tuning LlamA/Vicuna on multimodal instruction-following data generated by Llava1.5 and VideChat. It is an auto-regressive language model, based on the transformer architecture. Video-LLaVa unifies visual representations to the language feature space, and enables an LLM to perform visual reasoning capabilities on both images and videos simultaneously.",qe,Q,ro='The Video-LLaVA model was proposed in <a href="https://arxiv.org/abs/2311.10122" rel="nofollow">Video-LLaVA: Learning United Visual Representation by Alignment Before Projection</a> by Bin Lin, Yang Ye, Bin Zhu, Jiaxi Cui, Munang Ning, Peng Jin, Li Yuan.',De,P,lo="The abstract from the paper is the following:",Ke,H,io=`<em>The Large Vision-Language Model (LVLM) has enhanced the performance of various downstream tasks in
visual-language understanding. Most existing approaches
encode images and videos into separate feature spaces,
which are then fed as inputs to large language models.
However, due to the lack of unified tokenization for images and videos, namely misalignment before projection, it
becomes challenging for a Large Language Model (LLM)
to learn multi-modal interactions from several poor projection layers. In this work, we unify visual representation into the language feature space to advance the foundational LLM towards a unified LVLM. As a result, we establish a simple but robust LVLM baseline, Video-LLaVA,
which learns from a mixed dataset of images and videos,
mutually enhancing each other. Video-LLaVA achieves superior performances on a broad range of 9 image benchmarks across 5 image question-answering datasets and 4
image benchmark toolkits. Additionally, our Video-LLaVA
also outperforms Video-ChatGPT by 5.8%, 9.9%, 18.6%,
and 10.1% on MSRVTT, MSVD, TGIF, and ActivityNet, respectively. Notably, extensive experiments demonstrate that
Video-LLaVA mutually benefits images and videos within
a unified visual representation, outperforming models designed specifically for images or videos. We aim for this
work to provide modest insights into the multi-modal inputs
for the LLM</em>`,Oe,q,ea,D,co="<li><p>We advise users to use padding_side=“left” when computing batched generation as it leads to more accurate results. Simply make sure to call processor.tokenizer.padding_side = “left” before generating.</p></li> <li><p>Note the model has not been explicitly trained to process multiple images/videos in the same prompt, although this is technically possible, you may experience inaccurate results.</p></li> <li><p>Note that the video inputs should have exactly 8 frames at the input, since the models were trained in that setting.</p></li>",aa,K,mo=`This model was contributed by <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/PKU-YuanGroup/Video-LLaVA" rel="nofollow">here</a>.`,oa,O,ta,ee,na,ae,po="The model can accept both images and videos as input. Here’s an example code for inference in half-precision (<code>torch.float16</code>):",sa,oe,ra,te,ho="For multiple turns conversation change the prompt format to:",la,ne,ia,se,da,re,go="The model can also generate from an interleaved image-video inputs. However note, that it was not trained in interleaved image-video setting which might affect the performance. Below is an example usage for mixed media input, add the following lines to the above code snippet:",ca,le,ma,ie,pa,de,ha,ce,fo="The model can be loaded in lower bits, significantly reducing memory burden while maintaining the performance of the original model. his allows for efficient deployment on resource-constrained cases.",ga,me,uo='First make sure to install bitsandbytes by running <code>pip install bitsandbytes</code> and to have access to a CUDA compatible GPU device. Load the quantized model by simply adding <a href="../main_classes/quantization#transformers.BitsAndBytesConfig"><code>BitsAndBytesConfig</code></a> as shown below:',fa,pe,ua,he,Ma,ge,Mo='Additionally, we can greatly speed-up model inference by using <a href="../perf_train_gpu_one.md#flash-attention-2">Flash Attention</a>, which is a faster implementation of the attention mechanism used inside the model.',ya,fe,yo="First, make sure to install the latest version of Flash Attention 2:",_a,ue,va,Me,_o='Also, you should have a hardware that is compatible with Flash-Attention 2. Read more about it in the official documentation of the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">flash attention repository</a>. FlashAttention-2 can only be used when a model is loaded in <code>torch.float16</code> or <code>torch.bfloat16</code>.',Ta,ye,vo="To load and run a model using Flash Attention-2, simply add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when loading the model as follows:",ba,_e,wa,ve,Ja,b,Te,xa,We,To=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_31102/en/model_doc/video_llava#transformers.VideoLlavaForConditionalGeneration">VideoLlavaForConditionalGeneration</a>. It is used to instantiate an
VideoLlava model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the like LanguageBind/Video-LLaVA-7B-hf.`,$a,ze,bo='e.g. <a href="https://huggingface.co/LanguageBind/Video-LLaVA-7B-hf" rel="nofollow">LanguageBind/Video-LLaVA-7B-hf</a>',Ra,xe,wo=`Configuration objects inherit from <a href="/docs/transformers/pr_31102/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31102/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Fa,z,ja,be,Ua,j,we,Na,$e,Jo="Constructs a CLIP image processor.",Sa,x,Je,Ea,Re,jo="Preprocess an image or batch of images.",Xa,$,je,Aa,Fe,Uo=`Resize an image. The shortest edge of the image is resized to size[“shortest_edge”], with the longest edge
resized to keep the input aspect ratio.`,Va,Ue,Ia,w,Ve,Ya,Ne,Vo="Constructs a VideoLlava processor which wraps a VideoLlava image processor and a Llava tokenizer into a single processor.",Qa,Se,Io=`<a href="/docs/transformers/pr_31102/en/model_doc/video_llava#transformers.VideoLlavaProcessor">VideoLlavaProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_31102/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> and <a href="/docs/transformers/pr_31102/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/pr_31102/en/model_doc/video_llava#transformers.VideoLlavaProcessor.decode">decode()</a> for more information.`,Pa,R,Ie,Ha,Ee,Co=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/pr_31102/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,qa,F,Ce,Da,Xe,Zo=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/pr_31102/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Ca,Ze,Za,U,Le,Ka,Ae,Lo=`The VideoLlava model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/pr_31102/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Oa,Ye,ko=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,eo,C,ke,ao,Qe,Bo='The <a href="/docs/transformers/pr_31102/en/model_doc/video_llava#transformers.VideoLlavaForConditionalGeneration">VideoLlavaForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',oo,N,to,S,La,Be,ka,Pe,Ba;return v=new I({props:{title:"Video-LLaVA",local:"video-llava",headingTag:"h1"}}),T=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),q=new I({props:{title:"Usage tips:",local:"usage-tips",headingTag:"h2"}}),O=new I({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),ee=new I({props:{title:"Single Media Mode",local:"single-media-mode",headingTag:"h3"}}),oe=new A({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> av
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, VideoLlavaProcessor

<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
    <span class="hljs-string">&#x27;&#x27;&#x27;
    Decode the video with PyAV decoder.
    Args:
        container (\`av.container.input.InputContainer\`): PyAV container.
        indices (\`List[int]\`): List of frame indices to decode.
    Returns:
        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
    &#x27;&#x27;&#x27;</span>
    frames = []
    container.seek(<span class="hljs-number">0</span>)
    start_index = indices[<span class="hljs-number">0</span>]
    end_index = indices[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
        <span class="hljs-keyword">if</span> i &gt; end_index:
            <span class="hljs-keyword">break</span>
        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
            frames.append(frame)
    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])

<span class="hljs-comment"># Load the model in half-precision</span>
model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = VideoLlavaProcessor.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)

<span class="hljs-comment"># Load the video as an np.arrau, sampling uniformly 8 frames</span>
video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
container = av.<span class="hljs-built_in">open</span>(video_path)
total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
video = read_video_pyav(container, indices)

<span class="hljs-comment"># For better results, we recommend to prompt the model in the following format</span>
prompt = <span class="hljs-string">&quot;USER: &lt;video&gt;Why is this funny? ASSISTANT:&quot;</span>
inputs = processor(text=prompt, videos=video, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">60</span>)
processor.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)`,wrap:!1}}),ne=new A({props:{code:"JTIyVVNFUiUzQSUyMCUzQ3ZpZGVvJTNFV2hhdCUyMGRvJTIweW91JTIwc2VlJTIwaW4lMjB0aGlzJTIwdmlkZW8lM0YlMjBBU1NJU1RBTlQlM0ElMjBBJTIwYmFieSUyMHJlYWRpbmclMjBhJTIwYm9vay4lMjBVU0VSJTNBJTIwV2h5JTIwaXMlMjB0aGUlMjBpdCUyMGZ1bm55JTNGJTIwQVNTSVNUQU5UJTNBJTIy",highlighted:'<span class="hljs-string">&quot;USER: &lt;video&gt;What do you see in this video? ASSISTANT: A baby reading a book. USER: Why is the it funny? ASSISTANT:&quot;</span>',wrap:!1}}),se=new I({props:{title:"Mixed Media Mode",local:"mixed-media-mode",headingTag:"h3"}}),le=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBHZW5lcmF0ZSUyMGZyb20lMjBpbWFnZSUyMGFuZCUyMHZpZGVvJTIwbWl4ZWQlMjBpbnB1dHMlMEElMjMlMjBMb2FkJTIwYW5kJTIwaW1hZ2UlMjBhbmQlMjB3cml0ZSUyMGElMjBuZXclMjBwcm9tcHQlMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBcHJvbXB0JTIwJTNEJTIwJTIyVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTIwSG93JTIwbWFueSUyMGNhdHMlMjBhcmUlMjB0aGVyZSUyMGluJTIwdGhlJTIwaW1hZ2UlM0YlMjBBU1NJU1RBTlQlM0ElMjBUaGVyZSUyMGFyZSUyMHR3byUyMGNhdHMuJTIwVVNFUiUzQSUyMCUzQ3ZpZGVvJTNFV2h5JTIwaXMlMjB0aGlzJTIwdmlkZW8lMjBmdW5ueSUzRiUyMEFTU0lTVEFOVCUzQSUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEcHJvbXB0JTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjB2aWRlb3MlM0RjbGlwJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNENTApJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RUcnVlKSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

<span class="hljs-comment"># Generate from image and video mixed inputs</span>
<span class="hljs-comment"># Load and image and write a new prompt</span>
url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
prompt = <span class="hljs-string">&quot;USER: &lt;image&gt; How many cats are there in the image? ASSISTANT: There are two cats. USER: &lt;video&gt;Why is this video funny? ASSISTANT:&quot;</span>

inputs = processor(text=prompt, images=image, videos=clip, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">50</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
`,wrap:!1}}),ie=new I({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),de=new I({props:{title:"Quantization using Bitsandbytes for memory efficiency",local:"quantization-using-bitsandbytes-for-memory-efficiency",headingTag:"h3"}}),pe=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEElMjMlMjBzcGVjaWZ5JTIwaG93JTIwdG8lMjBxdWFudGl6ZSUyMHRoZSUyMG1vZGVsJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwVmlkZW9MbGF2YUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGFuZ3VhZ2VCaW5kJTJGVmlkZW8tTExhVkEtN0ItaGYlMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),he=new I({props:{title:"Flash-Attention 2 to speed-up generation",local:"flash-attention-2-to-speed-up-generation",headingTag:"h3"}}),ue=new A({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),_e=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkxhbmd1YWdlQmluZCUyRlZpZGVvLUxMYVZBLTdCLWhmJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTJDJTBBKS50bygwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration

model = VideoLlavaForConditionalGeneration.from_pretrained(
    <span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>, 
    torch_dtype=torch.float16, 
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),ve=new I({props:{title:"VideoLlavaConfig",local:"transformers.VideoLlavaConfig",headingTag:"h2"}}),Te=new G({props:{name:"class transformers.VideoLlavaConfig",anchor:"transformers.VideoLlavaConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"ignore_index",val:" = -100"},{name:"image_token_index",val:" = 32000"},{name:"video_token_index",val:" = 32001"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"vision_feature_layer",val:" = -2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaConfig.vision_config",description:`<strong>vision_config</strong> (<code>VideoLlavaVisionConfig</code>, <em>optional</em>) &#x2014;
Custom vision config or dict. Defaults to <code>CLIPVisionConfig</code> if not indicated.`,name:"vision_config"},{anchor:"transformers.VideoLlavaConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>) &#x2014;
The config object of the text backbone. Can be any of <code>LlamaConfig</code> or <code>MistralConfig</code>.
Defaults to <code>LlamaConfig</code> if not indicated.`,name:"text_config"},{anchor:"transformers.VideoLlavaConfig.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>, defaults to -100) &#x2014;
The ignore index for the loss function.`,name:"ignore_index"},{anchor:"transformers.VideoLlavaConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.VideoLlavaConfig.video_token_index",description:`<strong>video_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32001) &#x2014;
The video token index to encode the image prompt.`,name:"video_token_index"},{anchor:"transformers.VideoLlavaConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.VideoLlavaConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the CLIP backbone.
Can be either &#x201C;full&#x201D; to select all features or &#x201C;default&#x201D; to select features without <code>CLS</code>.`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>int</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature.`,name:"vision_feature_layer"}],source:"https://github.com/huggingface/transformers/blob/vr_31102/src/transformers/models/video_llava/configuration_video_llava.py#L24"}}),z=new Go({props:{anchor:"transformers.VideoLlavaConfig.example",$$slots:{default:[So]},$$scope:{ctx:W}}}),be=new I({props:{title:"VideoLlavaImageProcessor",local:"transformers.VideoLlavaImageProcessor",headingTag:"h2"}}),we=new G({props:{name:"class transformers.VideoLlavaImageProcessor",anchor:"transformers.VideoLlavaImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": Dict = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.VideoLlavaImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.VideoLlavaImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.VideoLlavaImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VideoLlavaImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.VideoLlavaImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.VideoLlavaImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VideoLlavaImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.VideoLlavaImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/vr_31102/src/transformers/models/video_llava/image_processing_video_llava.py#L67"}}),Je=new G({props:{name:"preprocess",anchor:"transformers.VideoLlavaImageProcessor.preprocess",parameters:[{name:"images",val:": List = None"},{name:"videos",val:": List = None"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": int = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
List of images to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>VideoInput</code>, <em>optional</em>) &#x2014;
List of videos to preprocess. Expects a single or batch of videos with pixel values ranging from 0 to 255. If
passing in videos with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"videos"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_31102/src/transformers/models/video_llava/image_processing_video_llava.py#L208"}}),je=new G({props:{name:"resize",anchor:"transformers.VideoLlavaImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": Dict"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"data_format",val:": Union = None"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.VideoLlavaImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Size of the output image.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.resize.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Resampling filter to use when resiizing the image.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.VideoLlavaImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_31102/src/transformers/models/video_llava/image_processing_video_llava.py#L159"}}),Ue=new I({props:{title:"VideoLlavaProcessor",local:"transformers.VideoLlavaProcessor",headingTag:"h2"}}),Ve=new G({props:{name:"class transformers.VideoLlavaProcessor",anchor:"transformers.VideoLlavaProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"}],parametersDescription:[{anchor:"transformers.VideoLlavaProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/pr_31102/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.VideoLlavaProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/pr_31102/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/vr_31102/src/transformers/models/video_llava/processing_video_llava.py#L28"}}),Ie=new G({props:{name:"batch_decode",anchor:"transformers.VideoLlavaProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31102/src/transformers/models/video_llava/processing_video_llava.py#L122"}}),Ce=new G({props:{name:"decode",anchor:"transformers.VideoLlavaProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31102/src/transformers/models/video_llava/processing_video_llava.py#L130"}}),Ze=new I({props:{title:"VideoLlavaForConditionalGeneration",local:"transformers.VideoLlavaForConditionalGeneration",headingTag:"h2"}}),Le=new G({props:{name:"class transformers.VideoLlavaForConditionalGeneration",anchor:"transformers.VideoLlavaForConditionalGeneration",parameters:[{name:"config",val:": VideoLlavaConfig"}],parametersDescription:[{anchor:"transformers.VideoLlavaForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31102/en/model_doc/video_llava#transformers.VideoLlavaConfig">VideoLlavaConfig</a> or <code>VideoLlavaVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_31102/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31102/src/transformers/models/video_llava/modeling_video_llava.py#L237"}}),ke=new G({props:{name:"forward",anchor:"transformers.VideoLlavaForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values_images",val:": FloatTensor = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"vision_feature_layer",val:": Optional = None"},{name:"vision_feature_select_strategy",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31102/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31102/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31102/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.pixel_values_images",description:'<strong>pixel_values_images</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)) -- The tensors corresponding to the input images. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/pr_31102/en/model_doc/auto#transformers.AutoImageProcessor). See [VideoLlavaImageProcessor.__call__()](/docs/transformers/pr_31102/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__) for details ([]</code>LlavaProcessor`] uses\n<a href="/docs/transformers/pr_31102/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> for processing images).',name:"pixel_values_images"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.pixel_values_videos",description:'<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, image_size, image_size)) -- The tensors corresponding to the input video. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/pr_31102/en/model_doc/auto#transformers.AutoImageProcessor). See [VideoLlavaImageProcessor.__call__()](/docs/transformers/pr_31102/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__) for details ([]</code>LlavaProcessor`] uses\n<a href="/docs/transformers/pr_31102/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> for processing videos).',name:"pixel_values_videos"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31102/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31102/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31102/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>int</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature.`,name:"vision_feature_layer"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31102/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31102/src/transformers/models/video_llava/modeling_video_llava.py#L401",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.video_llava.modeling_video_llava.VideoLlavaCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31102/en/model_doc/video_llava#transformers.VideoLlavaConfig"
>VideoLlavaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the image embeddings, <code>(batch_size, num_images, sequence_length, hidden_size)</code>.</p>
<p>image_hidden_states of the model produced by the vision encoder, and optionally by the perceiver</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.video_llava.modeling_video_llava.VideoLlavaCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),N=new Fo({props:{$$slots:{default:[Eo]},$$scope:{ctx:W}}}),S=new Go({props:{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.example",$$slots:{default:[Xo]},$$scope:{ctx:W}}}),Be=new No({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/video_llava.md"}}),{c(){u=r("meta"),J=n(),_=r("p"),y=n(),c(v.$$.fragment),d=n(),c(T.$$.fragment),He=n(),Y=r("p"),Y.textContent=so,qe=n(),Q=r("p"),Q.innerHTML=ro,De=n(),P=r("p"),P.textContent=lo,Ke=n(),H=r("p"),H.innerHTML=io,Oe=n(),c(q.$$.fragment),ea=n(),D=r("ul"),D.innerHTML=co,aa=n(),K=r("p"),K.innerHTML=mo,oa=n(),c(O.$$.fragment),ta=n(),c(ee.$$.fragment),na=n(),ae=r("p"),ae.innerHTML=po,sa=n(),c(oe.$$.fragment),ra=n(),te=r("p"),te.textContent=ho,la=n(),c(ne.$$.fragment),ia=n(),c(se.$$.fragment),da=n(),re=r("p"),re.textContent=go,ca=n(),c(le.$$.fragment),ma=n(),c(ie.$$.fragment),pa=n(),c(de.$$.fragment),ha=n(),ce=r("p"),ce.textContent=fo,ga=n(),me=r("p"),me.innerHTML=uo,fa=n(),c(pe.$$.fragment),ua=n(),c(he.$$.fragment),Ma=n(),ge=r("p"),ge.innerHTML=Mo,ya=n(),fe=r("p"),fe.textContent=yo,_a=n(),c(ue.$$.fragment),va=n(),Me=r("p"),Me.innerHTML=_o,Ta=n(),ye=r("p"),ye.innerHTML=vo,ba=n(),c(_e.$$.fragment),wa=n(),c(ve.$$.fragment),Ja=n(),b=r("div"),c(Te.$$.fragment),xa=n(),We=r("p"),We.innerHTML=To,$a=n(),ze=r("p"),ze.innerHTML=bo,Ra=n(),xe=r("p"),xe.innerHTML=wo,Fa=n(),c(z.$$.fragment),ja=n(),c(be.$$.fragment),Ua=n(),j=r("div"),c(we.$$.fragment),Na=n(),$e=r("p"),$e.textContent=Jo,Sa=n(),x=r("div"),c(Je.$$.fragment),Ea=n(),Re=r("p"),Re.textContent=jo,Xa=n(),$=r("div"),c(je.$$.fragment),Aa=n(),Fe=r("p"),Fe.textContent=Uo,Va=n(),c(Ue.$$.fragment),Ia=n(),w=r("div"),c(Ve.$$.fragment),Ya=n(),Ne=r("p"),Ne.textContent=Vo,Qa=n(),Se=r("p"),Se.innerHTML=Io,Pa=n(),R=r("div"),c(Ie.$$.fragment),Ha=n(),Ee=r("p"),Ee.innerHTML=Co,qa=n(),F=r("div"),c(Ce.$$.fragment),Da=n(),Xe=r("p"),Xe.innerHTML=Zo,Ca=n(),c(Ze.$$.fragment),Za=n(),U=r("div"),c(Le.$$.fragment),Ka=n(),Ae=r("p"),Ae.innerHTML=Lo,Oa=n(),Ye=r("p"),Ye.innerHTML=ko,eo=n(),C=r("div"),c(ke.$$.fragment),ao=n(),Qe=r("p"),Qe.innerHTML=Bo,oo=n(),c(N.$$.fragment),to=n(),c(S.$$.fragment),La=n(),c(Be.$$.fragment),ka=n(),Pe=r("p"),this.h()},l(e){const a=Ro("svelte-u9bgzb",document.head);u=l(a,"META",{name:!0,content:!0}),a.forEach(o),J=s(e),_=l(e,"P",{}),L(_).forEach(o),y=s(e),m(v.$$.fragment,e),d=s(e),m(T.$$.fragment,e),He=s(e),Y=l(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-81xura"&&(Y.textContent=so),qe=s(e),Q=l(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-v87k6c"&&(Q.innerHTML=ro),De=s(e),P=l(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-vfdo9a"&&(P.textContent=lo),Ke=s(e),H=l(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-sk56aa"&&(H.innerHTML=io),Oe=s(e),m(q.$$.fragment,e),ea=s(e),D=l(e,"UL",{"data-svelte-h":!0}),M(D)!=="svelte-s3c9rf"&&(D.innerHTML=co),aa=s(e),K=l(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1lvcrum"&&(K.innerHTML=mo),oa=s(e),m(O.$$.fragment,e),ta=s(e),m(ee.$$.fragment,e),na=s(e),ae=l(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-1pauxcy"&&(ae.innerHTML=po),sa=s(e),m(oe.$$.fragment,e),ra=s(e),te=l(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-1hi3kkd"&&(te.textContent=ho),la=s(e),m(ne.$$.fragment,e),ia=s(e),m(se.$$.fragment,e),da=s(e),re=l(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-1ngvr6w"&&(re.textContent=go),ca=s(e),m(le.$$.fragment,e),ma=s(e),m(ie.$$.fragment,e),pa=s(e),m(de.$$.fragment,e),ha=s(e),ce=l(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-uomo89"&&(ce.textContent=fo),ga=s(e),me=l(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-v8fva4"&&(me.innerHTML=uo),fa=s(e),m(pe.$$.fragment,e),ua=s(e),m(he.$$.fragment,e),Ma=s(e),ge=l(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-1bm9h4d"&&(ge.innerHTML=Mo),ya=s(e),fe=l(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-13kjllm"&&(fe.textContent=yo),_a=s(e),m(ue.$$.fragment,e),va=s(e),Me=l(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-dzzatn"&&(Me.innerHTML=_o),Ta=s(e),ye=l(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-z3ioid"&&(ye.innerHTML=vo),ba=s(e),m(_e.$$.fragment,e),wa=s(e),m(ve.$$.fragment,e),Ja=s(e),b=l(e,"DIV",{class:!0});var V=L(b);m(Te.$$.fragment,V),xa=s(V),We=l(V,"P",{"data-svelte-h":!0}),M(We)!=="svelte-1h2crg7"&&(We.innerHTML=To),$a=s(V),ze=l(V,"P",{"data-svelte-h":!0}),M(ze)!=="svelte-q9hjjl"&&(ze.innerHTML=bo),Ra=s(V),xe=l(V,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-cehht7"&&(xe.innerHTML=wo),Fa=s(V),m(z.$$.fragment,V),V.forEach(o),ja=s(e),m(be.$$.fragment,e),Ua=s(e),j=l(e,"DIV",{class:!0});var Z=L(j);m(we.$$.fragment,Z),Na=s(Z),$e=l(Z,"P",{"data-svelte-h":!0}),M($e)!=="svelte-x48p92"&&($e.textContent=Jo),Sa=s(Z),x=l(Z,"DIV",{class:!0});var Ge=L(x);m(Je.$$.fragment,Ge),Ea=s(Ge),Re=l(Ge,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-1x3yxsa"&&(Re.textContent=jo),Ge.forEach(o),Xa=s(Z),$=l(Z,"DIV",{class:!0});var Ga=L($);m(je.$$.fragment,Ga),Aa=s(Ga),Fe=l(Ga,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-1qmgo6y"&&(Fe.textContent=Uo),Ga.forEach(o),Z.forEach(o),Va=s(e),m(Ue.$$.fragment,e),Ia=s(e),w=l(e,"DIV",{class:!0});var B=L(w);m(Ve.$$.fragment,B),Ya=s(B),Ne=l(B,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-15aq8e1"&&(Ne.textContent=Vo),Qa=s(B),Se=l(B,"P",{"data-svelte-h":!0}),M(Se)!=="svelte-1l2fb64"&&(Se.innerHTML=Io),Pa=s(B),R=l(B,"DIV",{class:!0});var Wa=L(R);m(Ie.$$.fragment,Wa),Ha=s(Wa),Ee=l(Wa,"P",{"data-svelte-h":!0}),M(Ee)!=="svelte-1c3f1xf"&&(Ee.innerHTML=Co),Wa.forEach(o),qa=s(B),F=l(B,"DIV",{class:!0});var za=L(F);m(Ce.$$.fragment,za),Da=s(za),Xe=l(za,"P",{"data-svelte-h":!0}),M(Xe)!=="svelte-opl3xl"&&(Xe.innerHTML=Zo),za.forEach(o),B.forEach(o),Ca=s(e),m(Ze.$$.fragment,e),Za=s(e),U=l(e,"DIV",{class:!0});var E=L(U);m(Le.$$.fragment,E),Ka=s(E),Ae=l(E,"P",{"data-svelte-h":!0}),M(Ae)!=="svelte-13xppg9"&&(Ae.innerHTML=Lo),Oa=s(E),Ye=l(E,"P",{"data-svelte-h":!0}),M(Ye)!=="svelte-hswkmf"&&(Ye.innerHTML=ko),eo=s(E),C=l(E,"DIV",{class:!0});var X=L(C);m(ke.$$.fragment,X),ao=s(X),Qe=l(X,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-1rc6jxy"&&(Qe.innerHTML=Bo),oo=s(X),m(N.$$.fragment,X),to=s(X),m(S.$$.fragment,X),X.forEach(o),E.forEach(o),La=s(e),m(Be.$$.fragment,e),ka=s(e),Pe=l(e,"P",{}),L(Pe).forEach(o),this.h()},h(){k(u,"name","hf:doc:metadata"),k(u,"content",Yo),k(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){i(document.head,u),t(e,J,a),t(e,_,a),t(e,y,a),p(v,e,a),t(e,d,a),p(T,e,a),t(e,He,a),t(e,Y,a),t(e,qe,a),t(e,Q,a),t(e,De,a),t(e,P,a),t(e,Ke,a),t(e,H,a),t(e,Oe,a),p(q,e,a),t(e,ea,a),t(e,D,a),t(e,aa,a),t(e,K,a),t(e,oa,a),p(O,e,a),t(e,ta,a),p(ee,e,a),t(e,na,a),t(e,ae,a),t(e,sa,a),p(oe,e,a),t(e,ra,a),t(e,te,a),t(e,la,a),p(ne,e,a),t(e,ia,a),p(se,e,a),t(e,da,a),t(e,re,a),t(e,ca,a),p(le,e,a),t(e,ma,a),p(ie,e,a),t(e,pa,a),p(de,e,a),t(e,ha,a),t(e,ce,a),t(e,ga,a),t(e,me,a),t(e,fa,a),p(pe,e,a),t(e,ua,a),p(he,e,a),t(e,Ma,a),t(e,ge,a),t(e,ya,a),t(e,fe,a),t(e,_a,a),p(ue,e,a),t(e,va,a),t(e,Me,a),t(e,Ta,a),t(e,ye,a),t(e,ba,a),p(_e,e,a),t(e,wa,a),p(ve,e,a),t(e,Ja,a),t(e,b,a),p(Te,b,null),i(b,xa),i(b,We),i(b,$a),i(b,ze),i(b,Ra),i(b,xe),i(b,Fa),p(z,b,null),t(e,ja,a),p(be,e,a),t(e,Ua,a),t(e,j,a),p(we,j,null),i(j,Na),i(j,$e),i(j,Sa),i(j,x),p(Je,x,null),i(x,Ea),i(x,Re),i(j,Xa),i(j,$),p(je,$,null),i($,Aa),i($,Fe),t(e,Va,a),p(Ue,e,a),t(e,Ia,a),t(e,w,a),p(Ve,w,null),i(w,Ya),i(w,Ne),i(w,Qa),i(w,Se),i(w,Pa),i(w,R),p(Ie,R,null),i(R,Ha),i(R,Ee),i(w,qa),i(w,F),p(Ce,F,null),i(F,Da),i(F,Xe),t(e,Ca,a),p(Ze,e,a),t(e,Za,a),t(e,U,a),p(Le,U,null),i(U,Ka),i(U,Ae),i(U,Oa),i(U,Ye),i(U,eo),i(U,C),p(ke,C,null),i(C,ao),i(C,Qe),i(C,oo),p(N,C,null),i(C,to),p(S,C,null),t(e,La,a),p(Be,e,a),t(e,ka,a),t(e,Pe,a),Ba=!0},p(e,[a]){const V={};a&2&&(V.$$scope={dirty:a,ctx:e}),z.$set(V);const Z={};a&2&&(Z.$$scope={dirty:a,ctx:e}),N.$set(Z);const Ge={};a&2&&(Ge.$$scope={dirty:a,ctx:e}),S.$set(Ge)},i(e){Ba||(h(v.$$.fragment,e),h(T.$$.fragment,e),h(q.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(oe.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(de.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(Te.$$.fragment,e),h(z.$$.fragment,e),h(be.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h(Ve.$$.fragment,e),h(Ie.$$.fragment,e),h(Ce.$$.fragment,e),h(Ze.$$.fragment,e),h(Le.$$.fragment,e),h(ke.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(Be.$$.fragment,e),Ba=!0)},o(e){g(v.$$.fragment,e),g(T.$$.fragment,e),g(q.$$.fragment,e),g(O.$$.fragment,e),g(ee.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(le.$$.fragment,e),g(ie.$$.fragment,e),g(de.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(Te.$$.fragment,e),g(z.$$.fragment,e),g(be.$$.fragment,e),g(we.$$.fragment,e),g(Je.$$.fragment,e),g(je.$$.fragment,e),g(Ue.$$.fragment,e),g(Ve.$$.fragment,e),g(Ie.$$.fragment,e),g(Ce.$$.fragment,e),g(Ze.$$.fragment,e),g(Le.$$.fragment,e),g(ke.$$.fragment,e),g(N.$$.fragment,e),g(S.$$.fragment,e),g(Be.$$.fragment,e),Ba=!1},d(e){e&&(o(J),o(_),o(y),o(d),o(He),o(Y),o(qe),o(Q),o(De),o(P),o(Ke),o(H),o(Oe),o(ea),o(D),o(aa),o(K),o(oa),o(ta),o(na),o(ae),o(sa),o(ra),o(te),o(la),o(ia),o(da),o(re),o(ca),o(ma),o(pa),o(ha),o(ce),o(ga),o(me),o(fa),o(ua),o(Ma),o(ge),o(ya),o(fe),o(_a),o(va),o(Me),o(Ta),o(ye),o(ba),o(wa),o(Ja),o(b),o(ja),o(Ua),o(j),o(Va),o(Ia),o(w),o(Ca),o(Za),o(U),o(La),o(ka),o(Pe)),o(u),f(v,e),f(T,e),f(q,e),f(O,e),f(ee,e),f(oe,e),f(ne,e),f(se,e),f(le,e),f(ie,e),f(de,e),f(pe,e),f(he,e),f(ue,e),f(_e,e),f(ve,e),f(Te),f(z),f(be,e),f(we),f(Je),f(je),f(Ue,e),f(Ve),f(Ie),f(Ce),f(Ze,e),f(Le),f(ke),f(N),f(S),f(Be,e)}}}const Yo='{"title":"Video-LLaVA","local":"video-llava","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips:","local":"usage-tips","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single Media Mode","local":"single-media-mode","sections":[],"depth":3},{"title":"Mixed Media Mode","local":"mixed-media-mode","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes for memory efficiency","local":"quantization-using-bitsandbytes-for-memory-efficiency","sections":[],"depth":3},{"title":"Flash-Attention 2 to speed-up generation","local":"flash-attention-2-to-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"VideoLlavaConfig","local":"transformers.VideoLlavaConfig","sections":[],"depth":2},{"title":"VideoLlavaImageProcessor","local":"transformers.VideoLlavaImageProcessor","sections":[],"depth":2},{"title":"VideoLlavaProcessor","local":"transformers.VideoLlavaProcessor","sections":[],"depth":2},{"title":"VideoLlavaForConditionalGeneration","local":"transformers.VideoLlavaForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Qo(W){return zo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class at extends xo{constructor(u){super(),$o(this,u,Qo,Ao,Wo,{})}}export{at as component};
