import{s as Qs,f as Fs,o as Ns,n as Ls}from"../chunks/scheduler.65852ee5.js";import{S as qs,i as Es,g as i,s as a,r as u,A as As,h as o,f as l,c as s,j as Nt,u as p,x as r,k as v,y as B,a as n,v as c,d,t as m,w as h}from"../chunks/index.aa74147d.js";import{T as zs}from"../chunks/Tip.bb8ccac8.js";import{D as Ps,C as M}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as b,E as Ds}from"../chunks/EditOnGithub.4eda6a96.js";function Ks(Ft){let y,f='Also check out <code>Interface</code>’s <a href="https://www.gradio.app/docs/gradio/interface#interface-from_pipeline" rel="nofollow">from_pipeline</a> constructor which will directly build the <code>Interface</code> from a <code>pipeline</code>.';return{c(){y=i("p"),y.innerHTML=f},l(w){y=o(w,"P",{"data-svelte-h":!0}),r(y)!=="svelte-e72r3l"&&(y.innerHTML=f)},m(w,g){n(w,y,g)},p:Ls,d(w){w&&l(y)}}}function Os(Ft){let y,f="The output that we get from the call above is a made-up meeting that was generated by the LLM that we are using for text organization. This is because the sample input file isn’t an actual meeting recording. You can tweak the LLM’s prompt to handle this case.";return{c(){y=i("p"),y.textContent=f},l(w){y=o(w,"P",{"data-svelte-h":!0}),r(y)!=="svelte-avohft"&&(y.textContent=f)},m(w,g){n(w,y,g)},p:Ls,d(w){w&&l(y)}}}function ei(Ft){let y,f,w,g,G,qt,C,Et,Z,da='<em>Authored by: <a href="https://huggingface.co/dmaniloff" rel="nofollow">Diego Maniloff</a></em>',At,x,Pt,k,ma='In this notebook we will demonstrate how to bring any machine learning model to life using <a href="https://www.gradio.app/" rel="nofollow">Gradio</a>, a library that allows you to create a web demo from any Python function and share it with the world 🌎!',Dt,W,ha="📚 This notebook covers:",Kt,$,ya="<li>Building a <code>Hello, World!</code> demo: The basics of Gradio</li> <li>Moving your demo to Hugging Face Spaces</li> <li>Making it interesting: a real-world example that leverages the 🤗 Hub</li> <li>Some of the cool “batteries included” features that come with Gradio</li>",Ot,H,Ma="⏭️ At the end of this notebook you will find a <code>Further Reading</code> list with links to keep going on your own.",el,R,tl,V,wa="To get started install the <code>gradio</code> library along with <code>transformers</code>.",ll,_,nl,X,ba=`\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m12.3/12.3 MB\x1B[0m \x1B[31m23.4 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m92.0/92.0 kB\x1B[0m \x1B[31m4.4 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[?25h  Preparing metadata (setup.py) ... \x1B[?25l\x1B[?25hdone
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m318.1/318.1 kB\x1B[0m \x1B[31m23.1 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m75.6/75.6 kB\x1B[0m \x1B[31m3.9 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m145.0/145.0 kB\x1B[0m \x1B[31m1.2 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m10.1/10.1 MB\x1B[0m \x1B[31m30.2 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m62.4/62.4 kB\x1B[0m \x1B[31m4.7 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m129.9/129.9 kB\x1B[0m \x1B[31m2.0 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m77.9/77.9 kB\x1B[0m \x1B[31m5.3 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m58.3/58.3 kB\x1B[0m \x1B[31m4.1 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m71.9/71.9 kB\x1B[0m \x1B[31m4.8 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m53.6/53.6 kB\x1B[0m \x1B[31m1.3 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m307.7/307.7 kB\x1B[0m \x1B[31m19.5 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m341.4/341.4 kB\x1B[0m \x1B[31m18.7 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m3.4/3.4 MB\x1B[0m \x1B[31m36.4 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m1.2/1.2 MB\x1B[0m \x1B[31m41.4 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[?25h  Building wheel for ffmpy (setup.py) ... \x1B[?25l\x1B[?25hdone
`,al,S,sl,Y,il,F,fa="At its core, Gradio turns any Python function into a web interface.",ol,z,ga="Say we have a simple function that takes <code>name</code> and <code>intensity</code> as parameters, and returns a string like so:",rl,L,ul,Q,Ta="If you run this function for the name ‘Diego’ you will get an output string that looks like this:",pl,N,cl,q,Ja=`Hello, Diego!!!
`,dl,E,Ua="With Gradio, we can build an interface for this function via the <code>gr.Interface</code> class. All we need to do is pass in the <code>greet</code> function we created above, and the kinds of inputs and outputs that our function expects:",ml,A,hl,P,ja='Notice how we passed in <code>[&quot;text&quot;, &quot;slider&quot;]</code> as inputs and <code>[&quot;text&quot;]</code> as outputs — these are called <a href="https://www.gradio.app/docs/gradio/introduction#components" rel="nofollow">Components</a> in Gradio.',yl,D,Ia="That’s all we need for our first demo. Go ahead and try it out 👆! Type your name into the <code>name</code> textbox, slide the intensity that you want, and click <code>Submit</code>.",Ml,K,wl,O,va="Setting queue=True in a Colab notebook requires sharing enabled. Setting `share=True` (you can turn this off by setting `share=False` in `launch()` explicitly).\n\nColab notebook detected. To show errors in colab notebook, set debug=True in launch()\nRunning on public URL: https://b02977526e3600d305.gradio.live\n\nThis share link expires in 72 hours. For free permanent hosting and GPU upgrades, run `gradio deploy` from Terminal to deploy to Spaces (https://huggingface.co/spaces)\n",bl,ee,Ba="Go ahead and try it out 👆! Type your name into the <code>name</code> textbox, slide the intensity that you want, and click <code>Submit</code>.",fl,te,Ga="<strong>⏭️ Further reading</strong>",gl,le,Ca='<li><a href="https://www.gradio.app/guides/quickstart#building-your-first-demo" rel="nofollow">Your first demo with gradio</a></li> <li><a href="https://www.gradio.app/docs/gradio/introduction#components" rel="nofollow">Gradio Components</a></li>',Tl,ne,Jl,ae,Za=`At this point you understand how to take a basic Python function and turn it into
a web-ready demo. However, we only did this for a function that is very simple, a bit boring even!`,Ul,se,xa="Let’s consider a more interesting example that highlights the very thing that Gradio was built for: demoing cutting-edge machine learning models. A good friend of mine recently asked me for help with an audio recording of an interview she had done. She needed to convert the audio file into a well-organized text summary. How did I help her? I built a Gradio app!",jl,ie,ka="Let’s walk through the steps to build the meeting transcription tool. We can think of the process as two parts:",Il,oe,Wa="<li>Transcribe the audio file into text</li> <li>Organize the text into sections, paragraphs, lists, etc. We could include summarization here too.</li>",vl,re,Bl,ue,$a="In this part we will build a demo that handles the first step of the meeting transcription tool: converting audio into text.",Gl,pe,Ha="As we learned, the key ingredient to building a Gradio demo is to have a Python function that executes the logic we are trying to showcase. For the audio-to-text conversion, we will build our function using the awesome <code>transformers</code> library and its <code>pipeline</code> utility to use a popular audio-to-text model called <code>distil-whisper/distil-large-v3</code>.",Cl,ce,Ra="The result is the following <code>transcribe</code> function, which takes as input the audio that we want to convert:",Zl,de,xl,me,Va='Now that we have our Python function, we can demo that by passing it into <code>gr.Interface</code>. Notice how in this case the input that the function expects is the audio that we want to convert. Gradio includes a ton useful components, one of which is <a href="https://www.gradio.app/docs/gradio/audio" rel="nofollow">Audio</a>, exactly what we need for our demo 🎶 😎.',kl,he,Wl,ye,_a="Setting queue=True in a Colab notebook requires sharing enabled. Setting `share=True` (you can turn this off by setting `share=False` in `launch()` explicitly).\n\nColab notebook detected. To show errors in colab notebook, set debug=True in launch()\nRunning on public URL: https://5d107f49734b10fa46.gradio.live\n\nThis share link expires in 72 hours. For free permanent hosting and GPU upgrades, run `gradio deploy` from Terminal to deploy to Spaces (https://huggingface.co/spaces)\n",$l,Me,Xa="Go ahead and try it out 👆! You can upload an <code>.mp3</code> file or hit the 🎤 button to record your own voice.",Hl,we,Sa='For a sample file with an actual meeting recording, you can check out the <a href="https://huggingface.co/datasets/huuuyeah/MeetingBank_Audio" rel="nofollow">MeetingBank_Audio dataset</a> which is a dataset of meetings from city councils of 6 major U.S. cities. For my own testing, I tried out a couple of the <a href="https://huggingface.co/datasets/huuuyeah/MeetingBank_Audio/blob/main/Denver/mp3/Denver-21.zip" rel="nofollow">Denver meetings</a>.',Rl,T,Vl,be,_l,fe,Ya="For part 2 of the meeting transcription tool, we need to organize the transcribed text from the previous step.",Xl,ge,Fa='Once again, to build a Gradio demo we need the Python function with the logic that we care about. For text organization and summarization, we will use an “instruction-tuned” model that is trained to follow a broad range of tasks. There are many options to pick from such as <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3-8B-Instruct</a> or <a href="https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.3" rel="nofollow">mistralai/Mistral-7B-Instruct-v0.3</a>. For our example we are going to use <a href="https://huggingface.co/microsoft/Phi-3-mini-4k-instruct" rel="nofollow">microsoft/Phi-3-mini-4k-instruct</a>.',Sl,Te,za='Just like for part 1, we could leverage the <code>pipeline</code> utility within <code>transformers</code> to do this, but instead we will take this opportunity to showcase the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Serverless Inference API</a>, which is an API within the Hugging Face Hub that allows us to use thousands of publicly accessible (or your own privately permissioned) machine learning models <strong><em>for free</em></strong>! Check out the cookbook section of the Serverless Inferfence API <a href="https://huggingface.co/learn/cookbook/en/enterprise_hub_serverless_inference_api" rel="nofollow">here</a>.',Yl,Je,La='Using the Serverless Inferfence API means that instead of calling a model via a pipeline (like we did for the audio conversion part), we will call it from the <code>InferenceClient</code>, which is part of the <code>huggingface_hub</code> library (<a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/login" rel="nofollow">Hub Python Library</a>). And in turn, to use the <code>InferenceClient</code>, we need to log into the 🤗 Hub using <code>notebook_login()</code>, which will produce a dialog box asking for your User Access Token to authenticate with the Hub.',Fl,Ue,Qa='You can manage your tokens from your <a href="https://huggingface.co/settings/tokens" rel="nofollow">personal settings page</a>, and please remember to use <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">fine-grained</a> tokens as much as possible for enhanced security.',zl,je,Ll,Ie,Na="Now that we are logged into the Hub, we can write our text processing function using the Serverless Inference API via <code>InferenceClient</code>.",Ql,ve,qa="The code for this part will be structured into two functions:",Nl,Be,Ea="<li><code>build_messages</code>, to format the message prompt into the LLM;</li> <li><code>organize_text</code>, to actually pass the raw meeting text into the LLM for organization (and summarization, depending on the prompt we provide).</li>",ql,Ge,El,Ce,Al,Ze,Aa="And now that we have our text organization function <code>organize_text</code>, we can build a demo for it as well:",Pl,xe,Dl,ke,Pa="Setting queue=True in a Colab notebook requires sharing enabled. Setting `share=True` (you can turn this off by setting `share=False` in `launch()` explicitly).\n\nColab notebook detected. To show errors in colab notebook, set debug=True in launch()\nRunning on public URL: https://ef8938f7aa45bf7bd1.gradio.live\n\nThis share link expires in 72 hours. For free permanent hosting and GPU upgrades, run `gradio deploy` from Terminal to deploy to Spaces (https://huggingface.co/spaces)\n",Kl,We,Da="Go ahead and try it out 👆! If you hit “Submit” in the demo above, you will see that the output text is a much clearer and organized version of the transcript, with a title and sections for the different parts of the meeting.",Ol,$e,Ka="See if you can get a summary by playing around with the <code>user_input</code> variable that controls the LLM prompt.",en,He,tn,Re,Oa="At this point we have a function for each of the two steps we want out meeting transcription tool to do:",ln,Ve,es="<li>convert the audio into a text file, and</li> <li>organize that text file into a nicely-formatted meeting document.</li>",nn,_e,ts="All we have to do next is stitch these two functions together and build a demo for the combined steps. In other words, our complete meeting transcription tool is just a new function (which we’ll creatively call <code>meeting_transcript_tool</code> 😀) that takes the output of <code>transcribe</code> and passes it into <code>organize_text</code>:",an,Xe,sn,Se,ls="Setting queue=True in a Colab notebook requires sharing enabled. Setting `share=True` (you can turn this off by setting `share=False` in `launch()` explicitly).\n\nColab notebook detected. To show errors in colab notebook, set debug=True in launch()\nRunning on public URL: https://7c953dd88d7b6f273a.gradio.live\n\nThis share link expires in 72 hours. For free permanent hosting and GPU upgrades, run `gradio deploy` from Terminal to deploy to Spaces (https://huggingface.co/spaces)\n",on,Ye,ns="Go ahead and try it out 👆! This is now the full demo of our transcript tool. If you give it an audio file, the output will be the already-organized (and potentially summarized) version of the meeting. Super cool 😎.",rn,Fe,un,ze,as="If you made it this far, now you know the basics of how to create a demo of your machine learning model using Gradio 👏!",pn,Le,ss="Up next we are going to show you how to take your brand new demo to Hugging Face Spaces. On top of the ease of use and powerful features of Gradio, moving your demo to 🤗 Spaces gives you the benefit of permanent hosting, ease of deployment each time you update your app, and the ability to share your work with anyone! Do keep in mind that your Space will go to sleep after a while unless you are using it or making changes to it.",cn,Qe,is='The first step is to head over to <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a>, select “Gradio” from the templates, and leave the rest of the options as default for now (you can change these later):',dn,J,os,mn,Ne,rs='This will result in a newly created Space that you can populate with your demo code. As an example for you to follow, I created the 🤗 Space <code>dmaniloff/meeting-transcript-tool</code>, which you can access <a href="https://huggingface.co/spaces/dmaniloff/meeting-transcript-tool" rel="nofollow">here</a>.',hn,qe,us="There are two files we need to edit:",yn,U,Ee,zt,ps="<code>app.py</code> — This is where the demo code lives. It should look something like this:",ua,Ae,pa,Pe,Lt,cs="<code>requirements.txt</code> — This is where we tell our Space about the libraries it will need. It should look something like this:",ca,De,Mn,Ke,wn,Oe,ds="Gradio comes with lots of cool functionality right out of the box. We won’t be able to cover all of it in this notebook, but here’s 3 that we will check out:",bn,et,ms="<li>Access as an API</li> <li>Sharing via public URL</li> <li>Flagging</li>",fn,tt,gn,lt,hs="One of the benefits of building your web demos with Gradio is that you automatically get an API 🙌! This means that you can access the functionality of your Python function using a standard HTTP client like <code>curl</code> or the Python <code>requests</code> library.",Tn,nt,ys='If you look closely at the demos we created above, you will see at the bottom there is a link that says “Use via API”. If you click on it in the Space I created (<a href="https://huggingface.co/spaces/dmaniloff/meeting-transcript-tool/blob/main/app.py" rel="nofollow">dmaniloff/meeting-transcript-tool</a>), you will see the following:',Jn,j,Ms,Un,at,ws="Let’s go ahead and copy-paste that code below to use our Space as an API:",jn,st,In,it,bs=`Requirement already satisfied: gradio_client in /usr/local/lib/python3.10/dist-packages (1.0.1)
Requirement already satisfied: fsspec in /usr/local/lib/python3.10/dist-packages (from gradio_client) (2023.6.0)
Requirement already satisfied: httpx>=0.24.1 in /usr/local/lib/python3.10/dist-packages (from gradio_client) (0.27.0)
Requirement already satisfied: huggingface-hub>=0.19.3 in /usr/local/lib/python3.10/dist-packages (from gradio_client) (0.23.4)
Requirement already satisfied: packaging in /usr/local/lib/python3.10/dist-packages (from gradio_client) (24.1)
Requirement already satisfied: typing-extensions~=4.0 in /usr/local/lib/python3.10/dist-packages (from gradio_client) (4.12.2)
Requirement already satisfied: websockets<12.0,>=10.0 in /usr/local/lib/python3.10/dist-packages (from gradio_client) (11.0.3)
Requirement already satisfied: anyio in /usr/local/lib/python3.10/dist-packages (from httpx>=0.24.1->gradio_client) (3.7.1)
Requirement already satisfied: certifi in /usr/local/lib/python3.10/dist-packages (from httpx>=0.24.1->gradio_client) (2024.6.2)
Requirement already satisfied: httpcore==1.* in /usr/local/lib/python3.10/dist-packages (from httpx>=0.24.1->gradio_client) (1.0.5)
Requirement already satisfied: idna in /usr/local/lib/python3.10/dist-packages (from httpx>=0.24.1->gradio_client) (3.7)
Requirement already satisfied: sniffio in /usr/local/lib/python3.10/dist-packages (from httpx>=0.24.1->gradio_client) (1.3.1)
Requirement already satisfied: h11<0.15,>=0.13 in /usr/local/lib/python3.10/dist-packages (from httpcore==1.*->httpx>=0.24.1->gradio_client) (0.14.0)
Requirement already satisfied: filelock in /usr/local/lib/python3.10/dist-packages (from huggingface-hub>=0.19.3->gradio_client) (3.15.3)
Requirement already satisfied: pyyaml>=5.1 in /usr/local/lib/python3.10/dist-packages (from huggingface-hub>=0.19.3->gradio_client) (6.0.1)
Requirement already satisfied: requests in /usr/local/lib/python3.10/dist-packages (from huggingface-hub>=0.19.3->gradio_client) (2.31.0)
Requirement already satisfied: tqdm>=4.42.1 in /usr/local/lib/python3.10/dist-packages (from huggingface-hub>=0.19.3->gradio_client) (4.66.4)
Requirement already satisfied: exceptiongroup in /usr/local/lib/python3.10/dist-packages (from anyio->httpx>=0.24.1->gradio_client) (1.2.1)
Requirement already satisfied: charset-normalizer<4,>=2 in /usr/local/lib/python3.10/dist-packages (from requests->huggingface-hub>=0.19.3->gradio_client) (3.3.2)
Requirement already satisfied: urllib3<3,>=1.21.1 in /usr/local/lib/python3.10/dist-packages (from requests->huggingface-hub>=0.19.3->gradio_client) (2.0.7)
`,vn,ot,Bn,rt,fs=`Loaded as API: https://dmaniloff-meeting-transcript-tool.hf.space ✔
Certainly! Below is an organized version of a hypothetical meeting transcript. Since the original transcript you've provided is quite minimal, I'll create a more detailed and structured example featuring a meeting summary.

---

# Meeting Transcript: Project Alpha Kickoff

**Date:** April 7, 2023

**Location:** Conference Room B, TechCorp Headquarters


**Attendees:**

- John Smith (Project Manager)

- Emily Johnson (Lead Developer)

- Michael Brown (Marketing Lead)

- Lisa Green (Design Lead)


**Meeting Duration:** 1 hour 30 minutes


## Opening Remarks

**John Smith:**

Good morning everyone, and thank you for joining this kickoff meeting for Project Alpha. Today, we'll discuss our project vision, milestones, and roles. Let's get started.


## Vision and Goals

**Emily Johnson:**

The main goal of Project Alpha is to
`,Gn,ut,gs="Wow! What happened there? Let’s break it down:",Cn,pt,Ts="<li>We installed the <code>gradio_client</code>, which is a package that is specifically designed to interact with APIs built with Gradio.</li> <li>We instantiated the client by providing the name of the 🤗 Space that we want to query.</li> <li>We called the <code>predict</code> method of the client and passed in a sample audio file to it.</li>",Zn,ct,Js="The Gradio client takes care of making the HTTP POST for us, and it also provides functionality like reading the input audio file that our meeting transcript tool will process (via the function <code>handle_file</code>).",xn,dt,Us="Again, using this client is a choice, and you can just as well run a <code>curl -X POST https://dmaniloff-meeting-transcript-tool.hf.space/call/predict [...]</code> and pass in all the parameters needed in the request.",kn,I,Wn,mt,$n,ht,js="Another cool feature built into Gradio is that even if you build your demo on your local computer (before you move it into a 🤗 Space) you can still share this with anyone in the world by passing in <code>share=True</code> into <code>launch</code> like so:",Hn,yt,Rn,Mt,Is="You might have noticed that in this Google Colab environment that behaviour is enabled by default, and so the previous demos that we created already had a public URL that you can share 🌎. Go back ⬆ and look at the logs for <code>Running on public URL:</code> to find it 🔎!",Vn,wt,_n,bt,vs='<a href="https://www.gradio.app/guides/using-flagging" rel="nofollow">Flagging</a> is a feature built into Gradio that allows the users of your demo to provide feedback. You might have noticed that the first demo we created had a <code>Flag</code> button at the bottom.',Xn,ft,Bs="Under the default options, if a user clicks that button then the input and output samples are saved into a CSV log file that you can review later. If the demo involves audio (like in our case), these are saved separately in a parallel directory and the paths to these files are saved in the CSV file.",Sn,gt,Gs="Go back and play with our first demo once more, and then click the <code>Flag</code> button. You will see that a new log file is created in the <code>flagged</code> directory:",Yn,Tt,Fn,Jt,Cs=`name,intensity,output,flag,username,timestamp
Diego,4,"Hello, Diego!!!!",,,2024-06-29 22:07:50.242707
`,zn,Ut,Zs="In this case I set inputs to <code>name=diego</code> and <code>intensity=29</code>, which I then flagged. You can see that the log file includes the inputs to the function, the output <code>&quot;Hello, diego!!!!!!!!!!!!!!!!!!!!!!!!!!!!!&quot;</code>, and also a timestamp.",Ln,jt,xs="While a list of inputs and outputs that your users found problematic is better than nothing, Gradio’s flagging feature allows you to do much more. For example, you can provide a <code>flagging_options</code> parameter that lets you customize the kind of feedback or errors that you can receive, such as <code>[&quot;Incorrect&quot;, &quot;Ambiguous&quot;]</code>. Note that this requires that <code>allow_flagging</code> is set to <code>&quot;manual&quot;</code>:",Qn,It,Nn,vt,ks="Setting queue=True in a Colab notebook requires sharing enabled. Setting `share=True` (you can turn this off by setting `share=False` in `launch()` explicitly).\n\nColab notebook detected. To show errors in colab notebook, set debug=True in launch()\nRunning on public URL: https://46de561b83f8c0ce73.gradio.live\n\nThis share link expires in 72 hours. For free permanent hosting and GPU upgrades, run `gradio deploy` from Terminal to deploy to Spaces (https://huggingface.co/spaces)\n",qn,Bt,Ws="Go ahead and try it out 👆! You can see that the flagging buttons now are <code>Flag as Incorrect</code> and <code>Flag as Ambiguous</code>, and the new log file will reflect those options:",En,Gt,An,Ct,$s=`name,intensity,output,flag,username,timestamp
Diego,4,"Hello, Diego!!!!",,,2024-06-29 22:07:50.242707
Diego,5,"Hello, Diego!!!!!",Ambiguous,,2024-06-29 22:08:04.281030
`,Pn,Zt,Dn,xt,Hs="In this notebook we learned how to demo any machine learning model using Gradio.",Kn,kt,Rs="First, we learned the basics of setting up an interface for a simple Python function; and second, we covered Gradio’s true strength: building demos for machine learning models.",On,Wt,Vs="For this, we learned how easy it is to leverage models in the 🤗 Hub via the <code>transformers</code> library and its <code>pipeline</code> function, and how to use multimedia inputs like <code>gr.Audio</code>.",ea,$t,_s="Third, we covered how to host your Gradio demo on 🤗 Spaces, which lets you keep your demo running in the cloud and gives you flexibility in terms of the compute requirements for your demo.",ta,Ht,Xs="Finally, we showcased a few of the super cool batteries included that come with Gradio such as API access, public URLs, and Flagging.",la,Rt,Ss="For next steps, check out the <code>Further Reading</code> links at the end of each section.",na,Vt,aa,_t,Ys='<li><a href="https://www.gradio.app/guides/quickstart#building-your-first-demo" rel="nofollow">Your first demo with gradio</a></li> <li><a href="https://www.gradio.app/docs/gradio/introduction#components" rel="nofollow">Gradio Components</a></li> <li><a href="https://huggingface.co/docs/transformers/en/index" rel="nofollow">The transformers library</a></li> <li><a href="https://huggingface.co/docs/transformers/en/main_classes/pipelines" rel="nofollow">The pipeline function</a></li> <li><a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/login" rel="nofollow">Hub Python Library</a></li> <li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Serverless Inference API</a></li> <li><a href="https://huggingface.co/spaces" rel="nofollow">🤗 Spaces</a></li> <li><a href="https://huggingface.co/docs/hub/spaces" rel="nofollow">Spaces documentation</a></li>',sa,Xt,ia,Qt,oa;return G=new Ps({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/enterprise-cookbook-gradio/notebooks/en/enterprise_cookbook_gradio.ipynb"}]}}),C=new b({props:{title:"Creating Demos with Spaces and Gradio",local:"creating-demos-with-spaces-and-gradio",headingTag:"h1"}}),x=new b({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),R=new b({props:{title:"Setup",local:"setup",headingTag:"h2"}}),_=new M({props:{code:"IXBpcCUyMC1xJTIwaW5zdGFsbCUyMGdyYWRpbyUzRCUzRDQuMzYuMSUwQSFwaXAlMjAtcSUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlM0QlM0Q0LjQxLjI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>!pip -q install gradio==<span class="hljs-number">4.36</span><span class="hljs-number">.1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>!pip -q install transformers==<span class="hljs-number">4.41</span><span class="hljs-number">.2</span>`,wrap:!1}}),S=new M({props:{code:"JTIzJTIwdGhlJTIwdXN1YWwlMjBzaG9ydGhhbmQlMjBpcyUyMHRvJTIwaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWltcG9ydCUyMGdyYWRpbyUyMGFzJTIwZ3I=",highlighted:`<span class="hljs-comment"># the usual shorthand is to import gradio as gr</span>
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr`,wrap:!1}}),Y=new b({props:{title:"Your first demo: the basics of Gradio",local:"your-first-demo-the-basics-of-gradio",headingTag:"h2"}}),L=new M({props:{code:"ZGVmJTIwZ3JlZXQobmFtZSUzQSUyMHN0ciUyQyUyMGludGVuc2l0eSUzQSUyMGludCklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIySGVsbG8lMkMlMjAlMjIlMjAlMkIlMjBuYW1lJTIwJTJCJTIwJTIyISUyMiUyMColMjBpbnQoaW50ZW5zaXR5KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">greet</span>(<span class="hljs-params">name: <span class="hljs-built_in">str</span>, intensity: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Hello, &quot;</span> + name + <span class="hljs-string">&quot;!&quot;</span> * <span class="hljs-built_in">int</span>(intensity)`,wrap:!1}}),N=new M({props:{code:"cHJpbnQoZ3JlZXQoJTIyRGllZ28lMjIlMkMlMjAzKSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(greet(<span class="hljs-string">&quot;Diego&quot;</span>, <span class="hljs-number">3</span>))',wrap:!1}}),A=new M({props:{code:"ZGVtbyUyMCUzRCUyMGdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRGdyZWV0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEJTVCJTIydGV4dCUyMiUyQyUyMCUyMnNsaWRlciUyMiU1RCUyQyUyMCUyMCUyMyUyMHRoZSUyMGlucHV0cyUyMGFyZSUyMGElMjB0ZXh0JTIwYm94JTIwYW5kJTIwYSUyMHNsaWRlciUyMCglMjJ0ZXh0JTIyJTIwYW5kJTIwJTIyc2xpZGVyJTIyJTIwYXJlJTIwY29tcG9uZW50cyUyMGluJTIwR3JhZGlvKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0QlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwJTIwJTIzJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjBhJTIwdGV4dCUyMGJveCUwQSk=",highlighted:`demo = gr.Interface(
    fn=greet,
    inputs=[<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;slider&quot;</span>],  <span class="hljs-comment"># the inputs are a text box and a slider (&quot;text&quot; and &quot;slider&quot; are components in Gradio)</span>
    outputs=[<span class="hljs-string">&quot;text&quot;</span>],  <span class="hljs-comment"># the output is a text box</span>
)`,wrap:!1}}),K=new M({props:{code:"JTIzJTIwdGhlJTIwbGF1bmNoJTIwbWV0aG9kJTIwd2lsbCUyMGZpcmUlMjB1cCUyMHRoZSUyMGludGVyZmFjZSUyMHdlJTIwanVzdCUyMGNyZWF0ZWQlMEFkZW1vLmxhdW5jaCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the launch method will fire up the interface we just created</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>demo.launch()`,wrap:!1}}),ne=new b({props:{title:"Let’s make it interesting: a meeting transcription tool",local:"lets-make-it-interesting-a-meeting-transcription-tool",headingTag:"h2"}}),re=new b({props:{title:"Audio-to-text",local:"audio-to-text",headingTag:"h3"}}),de=new M({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0ZW1wZmlsZSUwQSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMDAlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBJTBBQVVESU9fTU9ERUxfTkFNRSUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJkaXN0aWwtd2hpc3BlciUyRmRpc3RpbC1sYXJnZS12MyUyMiUyMCUyMCUyMyUyMGZhc3RlciUyMGFuZCUyMHZlcnklMjBjbG9zZSUyMGluJTIwcGVyZm9ybWFuY2UlMjB0byUyMHRoZSUyMGZ1bGwtc2l6ZSUyMCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjMlMjIlMEEpJTBBQkFUQ0hfU0laRSUyMCUzRCUyMDglMEElMEElMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwdGFzayUzRCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREFVRElPX01PREVMX05BTUUlMkMlMEElMjAlMjAlMjAlMjBjaHVua19sZW5ndGhfcyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTNEZGV2aWNlJTJDJTBBKSUwQSUwQSUwQWRlZiUyMHRyYW5zY3JpYmUoYXVkaW9faW5wdXQpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyRnVuY3Rpb24lMjB0byUyMGNvbnZlcnQlMjBhdWRpbyUyMHRvJTIwdGV4dC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpZiUyMGF1ZGlvX2lucHV0JTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBnci5FcnJvciglMjJObyUyMGF1ZGlvJTIwZmlsZSUyMHN1Ym1pdHRlZCElMjIpJTBBJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwcGlwZShhdWRpb19pbnB1dCUyQyUyMGJhdGNoX3NpemUlM0RCQVRDSF9TSVpFJTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zY3JpYmUlMjIlN0QlMkMlMjByZXR1cm5fdGltZXN0YW1wcyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwb3V0cHV0JTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> tempfile

<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-number">0</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

AUDIO_MODEL_NAME = (
    <span class="hljs-string">&quot;distil-whisper/distil-large-v3&quot;</span>  <span class="hljs-comment"># faster and very close in performance to the full-size &quot;openai/whisper-large-v3&quot;</span>
)
BATCH_SIZE = <span class="hljs-number">8</span>


pipe = pipeline(
    task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
    model=AUDIO_MODEL_NAME,
    chunk_length_s=<span class="hljs-number">30</span>,
    device=device,
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">audio_input</span>):
    <span class="hljs-string">&quot;&quot;&quot;Function to convert audio to text.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> audio_input <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">raise</span> gr.Error(<span class="hljs-string">&quot;No audio file submitted!&quot;</span>)

    output = pipe(audio_input, batch_size=BATCH_SIZE, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>}, return_timestamps=<span class="hljs-literal">True</span>)
    <span class="hljs-keyword">return</span> output[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),he=new M({props:{code:"cGFydF8xX2RlbW8lMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0R0cmFuc2NyaWJlJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuQXVkaW8odHlwZSUzRCUyMmZpbGVwYXRoJTIyKSUyQyUyMCUyMCUyMyUyMCUyMmZpbGVwYXRoJTIyJTIwcGFzc2VzJTIwYSUyMHN0ciUyMHBhdGglMjB0byUyMGElMjB0ZW1wb3JhcnklMjBmaWxlJTIwY29udGFpbmluZyUyMHRoZSUyMGF1ZGlvJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRGdyLlRleHRib3goc2hvd19jb3B5X2J1dHRvbiUzRFRydWUpJTJDJTIwJTIwJTIzJTIwZ2l2ZSUyMHVzZXJzJTIwdGhlJTIwb3B0aW9uJTIwdG8lMjBjb3B5JTIwdGhlJTIwcmVzdWx0cyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyVHJhbnNjcmliZSUyMEF1ZGlvJTIwdG8lMjBUZXh0JTIyJTJDJTIwJTIwJTIzJTIwZ2l2ZSUyMG91ciUyMGRlbW8lMjBhJTIwdGl0bGUlMjAlM0EpJTBBKSUwQSUwQXBhcnRfMV9kZW1vLmxhdW5jaCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>part_1_demo = gr.Interface(
<span class="hljs-meta">... </span>    fn=transcribe,
<span class="hljs-meta">... </span>    inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),  <span class="hljs-comment"># &quot;filepath&quot; passes a str path to a temporary file containing the audio</span>
<span class="hljs-meta">... </span>    outputs=gr.Textbox(show_copy_button=<span class="hljs-literal">True</span>),  <span class="hljs-comment"># give users the option to copy the results</span>
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;Transcribe Audio to Text&quot;</span>,  <span class="hljs-comment"># give our demo a title :)</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>part_1_demo.launch()`,wrap:!1}}),T=new zs({props:{warning:!1,$$slots:{default:[Ks]},$$scope:{ctx:Ft}}}),be=new b({props:{title:"Organize & summarize text",local:"organize--summarize-text",headingTag:"h3"}}),je=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTJDJTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBJTIzJTIwcnVubmluZyUyMHRoaXMlMjB3aWxsJTIwcHJvbXB0JTIweW91JTIwdG8lMjBlbnRlciUyMHlvdXIlMjBIdWdnaW5nJTIwRmFjZSUyMGNyZWRlbnRpYWxzJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login, InferenceClient

<span class="hljs-comment"># running this will prompt you to enter your Hugging Face credentials</span>
notebook_login()`,wrap:!1}}),Ge=new M({props:{code:"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",highlighted:`<span class="hljs-comment"># sample meeting transcript from huuuyeah/MeetingBank_Audio</span>
<span class="hljs-comment"># this is just a copy-paste from the output of part 1 using one of the Denver meetings</span>
sample_transcript = <span class="hljs-string">&quot;&quot;&quot;
 Good evening. Welcome to the Denver City Council meeting of Monday, May 8, 2017. My name is Kelly Velez. I&#x27;m your Council Secretary. According to our rules of procedure, when our Council President, Albus Brooks, and Council President Pro Tem, JoLynn Clark, are both absent, the Council Secretary calls the meeting to order. Please rise and join Councilman Herndon in the Pledge of Allegiance. Madam Secretary, roll call. Roll call. Here. Mark. Espinosa. Here. Platt. Delmar. Here. Here. Here. Here. We have five members present. There is not a quorum this evening. Many of the council members are participating in an urban exploration trip in Portland, Oregon, pursuant to Section 3.3.4 of the city charter. Because there is not a quorum of seven council members present, all of tonight&#x27;s business will move to next week, to Monday, May 15th. Seeing no other business before this body except to wish Councilwoman Keniche a very happy birthday this meeting is adjourned Thank you. A standard model and an energy efficient model likely will be returned to you in energy savings many times during its lifespan. Now, what size do you need? Air conditioners are not a one-size-or-type fits all. Before you buy an air conditioner, you need to consider the size of your home and the cost to operate the unit per hour. Do you want a room air conditioner, which costs less but cools a smaller area, or do you want a central air conditioner, which cools your entire house but costs more? Do your homework. Now, let&#x27;s discuss evaporative coolers. In low humidity areas, evaporating water into the air provides a natural and energy efficient means of cooling. Evaporative coolers, also called swamp coolers, cool outdoor air by passing it over water saturated pads, causing the water to evaporate into it. Evaporative coolers cost about one half as much to install as central air conditioners and use about one-quarter as much energy. However, they require more frequent maintenance than refrigerated air conditioners, and they&#x27;re suitable only for areas with low humidity. Watch the maintenance tips at the end of this segment to learn more. And finally, fans. When air moves around in your home, it creates a wind chill effect. A mere two-mile-an-hour breeze will make your home feel four degrees cooler and therefore you can set your thermostat a bit higher. Ceiling fans and portable oscillating fans are cheap to run and they make your house feel cooler. You can also install a whole house fan to draw the hot air out of your home. A whole house fan draws cool outdoor air inside through open windows and exhausts hot room air through the attic to the outside. The result is excellent ventilation, lower indoor temperatures, and improved evaporative cooling. But remember, there are many low-cost, no-cost ways that you can keep your home cool. You should focus on these long before you turn on your AC or even before you purchase an AC. But if you are going to purchase a new cooling system, remember to get one that&#x27;s energy efficient and the correct size for your home. Wait, wait, don&#x27;t go away, there&#x27;s more. After this segment of the presentation is over, you&#x27;re going to be given the option to view maintenance tips about air conditioners and evaporative coolers. Now all of these tips are brought to you by the people at Xcel Energy. Thanks for watching.
&quot;&quot;&quot;</span>`,wrap:!1}}),Ce=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQVRFWFRfTU9ERUxfTkFNRSUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktNGstaW5zdHJ1Y3QlMjIlMEElMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQSUwQSUwQWRlZiUyMG9yZ2FuaXplX3RleHQobWVldGluZ190cmFuc2NyaXB0KSUzQSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwYnVpbGRfbWVzc2FnZXMobWVldGluZ190cmFuc2NyaXB0KSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1vZGVsJTNEVEVYVF9NT0RFTF9OQU1FJTJDJTIwbWF4X3Rva2VucyUzRDI1MCUyQyUyMHNlZWQlM0Q0MzApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS5jb250ZW50JTBBJTBBJTBBZGVmJTIwYnVpbGRfbWVzc2FnZXMobWVldGluZ190cmFuc2NyaXB0KSUyMC0lM0UlMjBsaXN0JTNBJTBBJTIwJTIwJTIwJTIwc3lzdGVtX2lucHV0JTIwJTNEJTIwJTIyWW91JTIwYXJlJTIwYW4lMjBhc3NpdGFudCUyMHRoYXQlMjBvcmdhbml6ZXMlMjBtZWV0aW5nJTIwbWludXRlcy4lMjIlMEElMjAlMjAlMjAlMjB1c2VyX2lucHV0JTIwJTNEJTIwJTIyJTIyJTIyVGFrZSUyMHRoaXMlMjByYXclMjBtZWV0aW5nJTIwdHJhbnNjcmlwdCUyMGFuZCUyMHJldHVybiUyMGFuJTIwb3JnYW5pemVkJTIwdmVyc2lvbi4lMEElMjAlMjAlMjAlMjBIZXJlJTIwaXMlMjB0aGUlMjB0cmFuc2NyaXB0JTNBJTBBJTIwJTIwJTIwJTIwJTdCbWVldGluZ190cmFuc2NyaXB0JTdEJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyLmZvcm1hdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZWV0aW5nX3RyYW5zY3JpcHQlM0RtZWV0aW5nX3RyYW5zY3JpcHQlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHN5c3RlbV9pbnB1dCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHVzZXJfaW5wdXQlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBtZXNzYWdlcw==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

TEXT_MODEL_NAME = <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>

client = InferenceClient()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">organize_text</span>(<span class="hljs-params">meeting_transcript</span>):
    messages = build_messages(meeting_transcript)
    response = client.chat_completion(messages, model=TEXT_MODEL_NAME, max_tokens=<span class="hljs-number">250</span>, seed=<span class="hljs-number">430</span>)
    <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content


<span class="hljs-keyword">def</span> <span class="hljs-title function_">build_messages</span>(<span class="hljs-params">meeting_transcript</span>) -&gt; <span class="hljs-built_in">list</span>:
    system_input = <span class="hljs-string">&quot;You are an assitant that organizes meeting minutes.&quot;</span>
    user_input = <span class="hljs-string">&quot;&quot;&quot;Take this raw meeting transcript and return an organized version.
    Here is the transcript:
    {meeting_transcript}
    &quot;&quot;&quot;</span>.<span class="hljs-built_in">format</span>(
        meeting_transcript=meeting_transcript
    )

    messages = [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: system_input},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: user_input},
    ]
    <span class="hljs-keyword">return</span> messages`,wrap:!1}}),xe=new M({props:{code:"cGFydF8yX2RlbW8lMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0Rvcmdhbml6ZV90ZXh0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuVGV4dGJveCh2YWx1ZSUzRHNhbXBsZV90cmFuc2NyaXB0KSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0Rnci5UZXh0Ym94KHNob3dfY29weV9idXR0b24lM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyQ2xlYW4lMjBVcCUyMFRyYW5zY3JpcHQlMjBUZXh0JTIyJTJDJTBBKSUwQXBhcnRfMl9kZW1vLmxhdW5jaCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>part_2_demo = gr.Interface(
<span class="hljs-meta">... </span>    fn=organize_text,
<span class="hljs-meta">... </span>    inputs=gr.Textbox(value=sample_transcript),
<span class="hljs-meta">... </span>    outputs=gr.Textbox(show_copy_button=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;Clean Up Transcript Text&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>part_2_demo.launch()`,wrap:!1}}),He=new b({props:{title:"Putting it all together",local:"putting-it-all-together",headingTag:"h3"}}),Xe=new M({props:{code:"ZGVmJTIwbWVldGluZ190cmFuc2NyaXB0X3Rvb2woYXVkaW9faW5wdXQpJTNBJTBBJTIwJTIwJTIwJTIwbWVldGluZ190ZXh0JTIwJTNEJTIwdHJhbnNjcmliZShhdWRpb19pbnB1dCklMEElMjAlMjAlMjAlMjBvcmdhbml6ZWRfdGV4dCUyMCUzRCUyMG9yZ2FuaXplX3RleHQobWVldGluZ190ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG9yZ2FuaXplZF90ZXh0JTBBJTBBJTBBZnVsbF9kZW1vJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEbWVldGluZ190cmFuc2NyaXB0X3Rvb2wlMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyh0eXBlJTNEJTIyZmlsZXBhdGglMjIpJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRGdyLlRleHRib3goc2hvd19jb3B5X2J1dHRvbiUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjJUaGUlMjBDb21wbGV0ZSUyME1lZXRpbmclMjBUcmFuc2NyaXB0aW9uJTIwVG9vbCUyMiUyQyUwQSklMEFmdWxsX2RlbW8ubGF1bmNoKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">meeting_transcript_tool</span>(<span class="hljs-params">audio_input</span>):
<span class="hljs-meta">... </span>    meeting_text = transcribe(audio_input)
<span class="hljs-meta">... </span>    organized_text = organize_text(meeting_text)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> organized_text


<span class="hljs-meta">&gt;&gt;&gt; </span>full_demo = gr.Interface(
<span class="hljs-meta">... </span>    fn=meeting_transcript_tool,
<span class="hljs-meta">... </span>    inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
<span class="hljs-meta">... </span>    outputs=gr.Textbox(show_copy_button=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;The Complete Meeting Transcription Tool&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>full_demo.launch()`,wrap:!1}}),Fe=new b({props:{title:"Move your demo into 🤗 Spaces",local:"move-your-demo-into--spaces",headingTag:"h2"}}),Ae=new M({props:{code:"JTIzJTIwb3V0bGluZSUyMG9mJTIwYXBwLnB5JTNBJTBBJTBBZGVmJTIwbWVldGluZ190cmFuc2NyaXB0X3Rvb2woLi4uKSUzQSUwQSUyMCUyMCUyMC4uLiUwQSUwQWRlZiUyMHRyYW5zY3JpYmUoLi4uKSUzQSUwQSUyMCUyMCUyMC4uLiUwQSUwQWRlZiUyMG9yZ2FuaXplX3RleHQoLi4uKSUzQSUwQSUyMCUyMCUyMC4uLiUwQQ==",highlighted:`<span class="hljs-comment"># outline of app.py:</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">meeting_transcript_tool</span>(<span class="hljs-params">...</span>):
   ...

<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">...</span>):
   ...

<span class="hljs-keyword">def</span> <span class="hljs-title function_">organize_text</span>(<span class="hljs-params">...</span>):
   ...
`,wrap:!1}}),De=new M({props:{code:"JTIzJTIwY29udGVudHMlMjBvZiUyMHJlcXVpcmVtZW50cy50eHQlM0ElMEF0b3JjaCUwQXRyYW5zZm9ybWVycw==",highlighted:`<span class="hljs-comment"># contents of requirements.txt:</span>
<span class="hljs-attribute">torch</span>
transformers`,wrap:!1}}),Ke=new b({props:{title:"Gradio comes with batteries included 🔋",local:"gradio-comes-with-batteries-included-",headingTag:"h2"}}),tt=new b({props:{title:"Access as an API",local:"access-as-an-api",headingTag:"h3"}}),st=new M({props:{code:"IXBpcCUyMGluc3RhbGwlMjBncmFkaW9fY2xpZW50",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!pip install gradio_client',wrap:!1}}),ot=new M({props:{code:"ZnJvbSUyMGdyYWRpb19jbGllbnQlMjBpbXBvcnQlMjBDbGllbnQlMkMlMjBoYW5kbGVfZmlsZSUwQSUwQWNsaWVudCUyMCUzRCUyMENsaWVudCglMjJkbWFuaWxvZmYlMkZtZWV0aW5nLXRyYW5zY3JpcHQtdG9vbCUyMiklMEFyZXN1bHQlMjAlM0QlMjBjbGllbnQucHJlZGljdCglMEElMjAlMjAlMjAlMjBhdWRpb19pbnB1dCUzRGhhbmRsZV9maWxlKCUyMmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmdyYWRpby1hcHAlMkZncmFkaW8lMkZyYXclMkZtYWluJTJGdGVzdCUyRnRlc3RfZmlsZXMlMkZhdWRpb19zYW1wbGUud2F2JTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9uYW1lJTNEJTIyJTJGcHJlZGljdCUyMiUyQyUwQSklMEFwcmludChyZXN1bHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> gradio_client <span class="hljs-keyword">import</span> Client, handle_file

<span class="hljs-meta">&gt;&gt;&gt; </span>client = Client(<span class="hljs-string">&quot;dmaniloff/meeting-transcript-tool&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = client.predict(
<span class="hljs-meta">... </span>    audio_input=handle_file(<span class="hljs-string">&quot;https://github.com/gradio-app/gradio/raw/main/test/test_files/audio_sample.wav&quot;</span>),
<span class="hljs-meta">... </span>    api_name=<span class="hljs-string">&quot;/predict&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(result)`,wrap:!1}}),I=new zs({props:{warning:!1,$$slots:{default:[Os]},$$scope:{ctx:Ft}}}),mt=new b({props:{title:"Share via public URL",local:"share-via-public-url",headingTag:"h3"}}),yt=new M({props:{code:"JTIwZGVtby5sYXVuY2goc2hhcmUlM0RUcnVlKQ==",highlighted:' demo.launch(share=<span class="hljs-literal">True</span>)',wrap:!1}}),wt=new b({props:{title:"Flagging",local:"flagging",headingTag:"h3"}}),Tt=new M({props:{code:"IWNhdCUyMGZsYWdnZWQlMkZsb2cuY3N2",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!cat flagged/log.csv',wrap:!1}}),It=new M({props:{code:"ZGVtb193aXRoX2N1c3RvbV9mbGFnZ2luZyUyMCUzRCUyMGdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRGdyZWV0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNsaWRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUyMCUyMCUyMyUyMHRoZSUyMGlucHV0cyUyMGFyZSUyMGElMjB0ZXh0JTIwYm94JTIwYW5kJTIwYSUyMHNsaWRlciUyMCglMjJ0ZXh0JTIyJTIwYW5kJTIwJTIyc2xpZGVyJTIyJTIwYXJlJTIwY29tcG9uZW50cyUyMGluJTIwR3JhZGlvKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0QlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwJTIwJTIzJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjBhJTIwdGV4dCUyMGJveCUwQSUyMCUyMCUyMCUyMGFsbG93X2ZsYWdnaW5nJTNEJTIybWFudWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwZmxhZ2dpbmdfb3B0aW9ucyUzRCU1QiUyMkluY29ycmVjdCUyMiUyQyUyMCUyMkFtYmlndW91cyUyMiU1RCUyQyUwQSklMEFkZW1vX3dpdGhfY3VzdG9tX2ZsYWdnaW5nLmxhdW5jaCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>demo_with_custom_flagging = gr.Interface(
<span class="hljs-meta">... </span>    fn=greet,
<span class="hljs-meta">... </span>    inputs=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;text&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;slider&quot;</span>,
<span class="hljs-meta">... </span>    ],  <span class="hljs-comment"># the inputs are a text box and a slider (&quot;text&quot; and &quot;slider&quot; are components in Gradio)</span>
<span class="hljs-meta">... </span>    outputs=[<span class="hljs-string">&quot;text&quot;</span>],  <span class="hljs-comment"># the output is a text box</span>
<span class="hljs-meta">... </span>    allow_flagging=<span class="hljs-string">&quot;manual&quot;</span>,
<span class="hljs-meta">... </span>    flagging_options=[<span class="hljs-string">&quot;Incorrect&quot;</span>, <span class="hljs-string">&quot;Ambiguous&quot;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>demo_with_custom_flagging.launch()`,wrap:!1}}),Gt=new M({props:{code:"IWNhdCUyMGZsYWdnZWQlMkZsb2cuY3N2",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!cat flagged/log.csv',wrap:!1}}),Zt=new b({props:{title:"Wrap up & Next Steps",local:"wrap-up--next-steps",headingTag:"h2"}}),Vt=new b({props:{title:"⏭️ Further reading",local:"-further-reading",headingTag:"h2"}}),Xt=new Ds({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/enterprise_cookbook_gradio.md"}}),{c(){y=i("meta"),f=a(),w=i("p"),g=a(),u(G.$$.fragment),qt=a(),u(C.$$.fragment),Et=a(),Z=i("p"),Z.innerHTML=da,At=a(),u(x.$$.fragment),Pt=a(),k=i("p"),k.innerHTML=ma,Dt=a(),W=i("p"),W.textContent=ha,Kt=a(),$=i("ul"),$.innerHTML=ya,Ot=a(),H=i("p"),H.innerHTML=Ma,el=a(),u(R.$$.fragment),tl=a(),V=i("p"),V.innerHTML=wa,ll=a(),u(_.$$.fragment),nl=a(),X=i("pre"),X.textContent=ba,al=a(),u(S.$$.fragment),sl=a(),u(Y.$$.fragment),il=a(),F=i("p"),F.textContent=fa,ol=a(),z=i("p"),z.innerHTML=ga,rl=a(),u(L.$$.fragment),ul=a(),Q=i("p"),Q.textContent=Ta,pl=a(),u(N.$$.fragment),cl=a(),q=i("pre"),q.textContent=Ja,dl=a(),E=i("p"),E.innerHTML=Ua,ml=a(),u(A.$$.fragment),hl=a(),P=i("p"),P.innerHTML=ja,yl=a(),D=i("p"),D.innerHTML=Ia,Ml=a(),u(K.$$.fragment),wl=a(),O=i("pre"),O.textContent=va,bl=a(),ee=i("p"),ee.innerHTML=Ba,fl=a(),te=i("p"),te.innerHTML=Ga,gl=a(),le=i("ul"),le.innerHTML=Ca,Tl=a(),u(ne.$$.fragment),Jl=a(),ae=i("p"),ae.textContent=Za,Ul=a(),se=i("p"),se.textContent=xa,jl=a(),ie=i("p"),ie.textContent=ka,Il=a(),oe=i("ol"),oe.innerHTML=Wa,vl=a(),u(re.$$.fragment),Bl=a(),ue=i("p"),ue.textContent=$a,Gl=a(),pe=i("p"),pe.innerHTML=Ha,Cl=a(),ce=i("p"),ce.innerHTML=Ra,Zl=a(),u(de.$$.fragment),xl=a(),me=i("p"),me.innerHTML=Va,kl=a(),u(he.$$.fragment),Wl=a(),ye=i("pre"),ye.textContent=_a,$l=a(),Me=i("p"),Me.innerHTML=Xa,Hl=a(),we=i("p"),we.innerHTML=Sa,Rl=a(),u(T.$$.fragment),Vl=a(),u(be.$$.fragment),_l=a(),fe=i("p"),fe.textContent=Ya,Xl=a(),ge=i("p"),ge.innerHTML=Fa,Sl=a(),Te=i("p"),Te.innerHTML=za,Yl=a(),Je=i("p"),Je.innerHTML=La,Fl=a(),Ue=i("p"),Ue.innerHTML=Qa,zl=a(),u(je.$$.fragment),Ll=a(),Ie=i("p"),Ie.innerHTML=Na,Ql=a(),ve=i("p"),ve.textContent=qa,Nl=a(),Be=i("ul"),Be.innerHTML=Ea,ql=a(),u(Ge.$$.fragment),El=a(),u(Ce.$$.fragment),Al=a(),Ze=i("p"),Ze.innerHTML=Aa,Pl=a(),u(xe.$$.fragment),Dl=a(),ke=i("pre"),ke.textContent=Pa,Kl=a(),We=i("p"),We.textContent=Da,Ol=a(),$e=i("p"),$e.innerHTML=Ka,en=a(),u(He.$$.fragment),tn=a(),Re=i("p"),Re.textContent=Oa,ln=a(),Ve=i("ol"),Ve.innerHTML=es,nn=a(),_e=i("p"),_e.innerHTML=ts,an=a(),u(Xe.$$.fragment),sn=a(),Se=i("pre"),Se.textContent=ls,on=a(),Ye=i("p"),Ye.textContent=ns,rn=a(),u(Fe.$$.fragment),un=a(),ze=i("p"),ze.textContent=as,pn=a(),Le=i("p"),Le.textContent=ss,cn=a(),Qe=i("p"),Qe.innerHTML=is,dn=a(),J=i("img"),mn=a(),Ne=i("p"),Ne.innerHTML=rs,hn=a(),qe=i("p"),qe.textContent=us,yn=a(),U=i("ul"),Ee=i("li"),zt=i("p"),zt.innerHTML=ps,ua=a(),u(Ae.$$.fragment),pa=a(),Pe=i("li"),Lt=i("p"),Lt.innerHTML=cs,ca=a(),u(De.$$.fragment),Mn=a(),u(Ke.$$.fragment),wn=a(),Oe=i("p"),Oe.textContent=ds,bn=a(),et=i("ul"),et.innerHTML=ms,fn=a(),u(tt.$$.fragment),gn=a(),lt=i("p"),lt.innerHTML=hs,Tn=a(),nt=i("p"),nt.innerHTML=ys,Jn=a(),j=i("img"),Un=a(),at=i("p"),at.textContent=ws,jn=a(),u(st.$$.fragment),In=a(),it=i("pre"),it.textContent=bs,vn=a(),u(ot.$$.fragment),Bn=a(),rt=i("pre"),rt.textContent=fs,Gn=a(),ut=i("p"),ut.textContent=gs,Cn=a(),pt=i("ul"),pt.innerHTML=Ts,Zn=a(),ct=i("p"),ct.innerHTML=Js,xn=a(),dt=i("p"),dt.innerHTML=Us,kn=a(),u(I.$$.fragment),Wn=a(),u(mt.$$.fragment),$n=a(),ht=i("p"),ht.innerHTML=js,Hn=a(),u(yt.$$.fragment),Rn=a(),Mt=i("p"),Mt.innerHTML=Is,Vn=a(),u(wt.$$.fragment),_n=a(),bt=i("p"),bt.innerHTML=vs,Xn=a(),ft=i("p"),ft.textContent=Bs,Sn=a(),gt=i("p"),gt.innerHTML=Gs,Yn=a(),u(Tt.$$.fragment),Fn=a(),Jt=i("pre"),Jt.textContent=Cs,zn=a(),Ut=i("p"),Ut.innerHTML=Zs,Ln=a(),jt=i("p"),jt.innerHTML=xs,Qn=a(),u(It.$$.fragment),Nn=a(),vt=i("pre"),vt.textContent=ks,qn=a(),Bt=i("p"),Bt.innerHTML=Ws,En=a(),u(Gt.$$.fragment),An=a(),Ct=i("pre"),Ct.textContent=$s,Pn=a(),u(Zt.$$.fragment),Dn=a(),xt=i("p"),xt.textContent=Hs,Kn=a(),kt=i("p"),kt.textContent=Rs,On=a(),Wt=i("p"),Wt.innerHTML=Vs,ea=a(),$t=i("p"),$t.textContent=_s,ta=a(),Ht=i("p"),Ht.textContent=Xs,la=a(),Rt=i("p"),Rt.innerHTML=Ss,na=a(),u(Vt.$$.fragment),aa=a(),_t=i("ul"),_t.innerHTML=Ys,sa=a(),u(Xt.$$.fragment),ia=a(),Qt=i("p"),this.h()},l(e){const t=As("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),f=s(e),w=o(e,"P",{}),Nt(w).forEach(l),g=s(e),p(G.$$.fragment,e),qt=s(e),p(C.$$.fragment,e),Et=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-jo227l"&&(Z.innerHTML=da),At=s(e),p(x.$$.fragment,e),Pt=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-tfh72r"&&(k.innerHTML=ma),Dt=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-18fq2ds"&&(W.textContent=ha),Kt=s(e),$=o(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-yc80xa"&&($.innerHTML=ya),Ot=s(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-dsdcpw"&&(H.innerHTML=Ma),el=s(e),p(R.$$.fragment,e),tl=s(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-ndetzi"&&(V.innerHTML=wa),ll=s(e),p(_.$$.fragment,e),nl=s(e),X=o(e,"PRE",{"data-svelte-h":!0}),r(X)!=="svelte-ie80p"&&(X.textContent=ba),al=s(e),p(S.$$.fragment,e),sl=s(e),p(Y.$$.fragment,e),il=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-imykz0"&&(F.textContent=fa),ol=s(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-ck34qj"&&(z.innerHTML=ga),rl=s(e),p(L.$$.fragment,e),ul=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-i6af0b"&&(Q.textContent=Ta),pl=s(e),p(N.$$.fragment,e),cl=s(e),q=o(e,"PRE",{"data-svelte-h":!0}),r(q)!=="svelte-1d8bxpj"&&(q.textContent=Ja),dl=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-ao31px"&&(E.innerHTML=Ua),ml=s(e),p(A.$$.fragment,e),hl=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1gssur6"&&(P.innerHTML=ja),yl=s(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-19g4tlw"&&(D.innerHTML=Ia),Ml=s(e),p(K.$$.fragment,e),wl=s(e),O=o(e,"PRE",{"data-svelte-h":!0}),r(O)!=="svelte-14x4svi"&&(O.textContent=va),bl=s(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1w2mfb6"&&(ee.innerHTML=Ba),fl=s(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-s92s2r"&&(te.innerHTML=Ga),gl=s(e),le=o(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-1uzek3j"&&(le.innerHTML=Ca),Tl=s(e),p(ne.$$.fragment,e),Jl=s(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-17laqx2"&&(ae.textContent=Za),Ul=s(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1yo8y7n"&&(se.textContent=xa),jl=s(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-ekm3wd"&&(ie.textContent=ka),Il=s(e),oe=o(e,"OL",{"data-svelte-h":!0}),r(oe)!=="svelte-86ps6"&&(oe.innerHTML=Wa),vl=s(e),p(re.$$.fragment,e),Bl=s(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-16t2jma"&&(ue.textContent=$a),Gl=s(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-oonzuh"&&(pe.innerHTML=Ha),Cl=s(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-mzfgq9"&&(ce.innerHTML=Ra),Zl=s(e),p(de.$$.fragment,e),xl=s(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-2mbqop"&&(me.innerHTML=Va),kl=s(e),p(he.$$.fragment,e),Wl=s(e),ye=o(e,"PRE",{"data-svelte-h":!0}),r(ye)!=="svelte-elz2kq"&&(ye.textContent=_a),$l=s(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-qv5xew"&&(Me.innerHTML=Xa),Hl=s(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1yvhatv"&&(we.innerHTML=Sa),Rl=s(e),p(T.$$.fragment,e),Vl=s(e),p(be.$$.fragment,e),_l=s(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1pk54pa"&&(fe.textContent=Ya),Xl=s(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-121gwix"&&(ge.innerHTML=Fa),Sl=s(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-rn2c0"&&(Te.innerHTML=za),Yl=s(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1ytrw7h"&&(Je.innerHTML=La),Fl=s(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-eig0yh"&&(Ue.innerHTML=Qa),zl=s(e),p(je.$$.fragment,e),Ll=s(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1nuljlf"&&(Ie.innerHTML=Na),Ql=s(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1t4rfuz"&&(ve.textContent=qa),Nl=s(e),Be=o(e,"UL",{"data-svelte-h":!0}),r(Be)!=="svelte-590jvf"&&(Be.innerHTML=Ea),ql=s(e),p(Ge.$$.fragment,e),El=s(e),p(Ce.$$.fragment,e),Al=s(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1y7r0u"&&(Ze.innerHTML=Aa),Pl=s(e),p(xe.$$.fragment,e),Dl=s(e),ke=o(e,"PRE",{"data-svelte-h":!0}),r(ke)!=="svelte-1n5sti5"&&(ke.textContent=Pa),Kl=s(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1qiucww"&&(We.textContent=Da),Ol=s(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-l930ml"&&($e.innerHTML=Ka),en=s(e),p(He.$$.fragment,e),tn=s(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-su8pwm"&&(Re.textContent=Oa),ln=s(e),Ve=o(e,"OL",{"data-svelte-h":!0}),r(Ve)!=="svelte-jraobi"&&(Ve.innerHTML=es),nn=s(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-97jp0s"&&(_e.innerHTML=ts),an=s(e),p(Xe.$$.fragment,e),sn=s(e),Se=o(e,"PRE",{"data-svelte-h":!0}),r(Se)!=="svelte-1lpy14f"&&(Se.textContent=ls),on=s(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-ug6zdj"&&(Ye.textContent=ns),rn=s(e),p(Fe.$$.fragment,e),un=s(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1f1og5o"&&(ze.textContent=as),pn=s(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-18it3mz"&&(Le.textContent=ss),cn=s(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-7nl279"&&(Qe.innerHTML=is),dn=s(e),J=o(e,"IMG",{src:!0,width:!0,alt:!0}),mn=s(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-112s0s1"&&(Ne.innerHTML=rs),hn=s(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-t0rmiw"&&(qe.textContent=us),yn=s(e),U=o(e,"UL",{});var St=Nt(U);Ee=o(St,"LI",{});var Yt=Nt(Ee);zt=o(Yt,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-1rhlgw4"&&(zt.innerHTML=ps),ua=s(Yt),p(Ae.$$.fragment,Yt),Yt.forEach(l),pa=s(St),Pe=o(St,"LI",{});var ra=Nt(Pe);Lt=o(ra,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-qc8pgv"&&(Lt.innerHTML=cs),ca=s(ra),p(De.$$.fragment,ra),ra.forEach(l),St.forEach(l),Mn=s(e),p(Ke.$$.fragment,e),wn=s(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-8s6vsh"&&(Oe.textContent=ds),bn=s(e),et=o(e,"UL",{"data-svelte-h":!0}),r(et)!=="svelte-1vr4ngb"&&(et.innerHTML=ms),fn=s(e),p(tt.$$.fragment,e),gn=s(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-7qbjz7"&&(lt.innerHTML=hs),Tn=s(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1ydqs3k"&&(nt.innerHTML=ys),Jn=s(e),j=o(e,"IMG",{src:!0,width:!0,alt:!0}),Un=s(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-853jwi"&&(at.textContent=ws),jn=s(e),p(st.$$.fragment,e),In=s(e),it=o(e,"PRE",{"data-svelte-h":!0}),r(it)!=="svelte-9gt6x0"&&(it.textContent=bs),vn=s(e),p(ot.$$.fragment,e),Bn=s(e),rt=o(e,"PRE",{"data-svelte-h":!0}),r(rt)!=="svelte-1f419gx"&&(rt.textContent=fs),Gn=s(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-7n3hrv"&&(ut.textContent=gs),Cn=s(e),pt=o(e,"UL",{"data-svelte-h":!0}),r(pt)!=="svelte-8wzody"&&(pt.innerHTML=Ts),Zn=s(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-edepwe"&&(ct.innerHTML=Js),xn=s(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-czm7yu"&&(dt.innerHTML=Us),kn=s(e),p(I.$$.fragment,e),Wn=s(e),p(mt.$$.fragment,e),$n=s(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-bmr5of"&&(ht.innerHTML=js),Hn=s(e),p(yt.$$.fragment,e),Rn=s(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-6zs2wg"&&(Mt.innerHTML=Is),Vn=s(e),p(wt.$$.fragment,e),_n=s(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-j019a0"&&(bt.innerHTML=vs),Xn=s(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-byl69c"&&(ft.textContent=Bs),Sn=s(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-qd0749"&&(gt.innerHTML=Gs),Yn=s(e),p(Tt.$$.fragment,e),Fn=s(e),Jt=o(e,"PRE",{"data-svelte-h":!0}),r(Jt)!=="svelte-t58374"&&(Jt.textContent=Cs),zn=s(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-1f1ercz"&&(Ut.innerHTML=Zs),Ln=s(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1kvyfsz"&&(jt.innerHTML=xs),Qn=s(e),p(It.$$.fragment,e),Nn=s(e),vt=o(e,"PRE",{"data-svelte-h":!0}),r(vt)!=="svelte-tb8hhx"&&(vt.textContent=ks),qn=s(e),Bt=o(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-n67zfm"&&(Bt.innerHTML=Ws),En=s(e),p(Gt.$$.fragment,e),An=s(e),Ct=o(e,"PRE",{"data-svelte-h":!0}),r(Ct)!=="svelte-p76wiz"&&(Ct.textContent=$s),Pn=s(e),p(Zt.$$.fragment,e),Dn=s(e),xt=o(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-s3ahdf"&&(xt.textContent=Hs),Kn=s(e),kt=o(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-1c8mrg"&&(kt.textContent=Rs),On=s(e),Wt=o(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-1ef1i7i"&&(Wt.innerHTML=Vs),ea=s(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-v4dtnd"&&($t.textContent=_s),ta=s(e),Ht=o(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-thjo29"&&(Ht.textContent=Xs),la=s(e),Rt=o(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-3wup7e"&&(Rt.innerHTML=Ss),na=s(e),p(Vt.$$.fragment,e),aa=s(e),_t=o(e,"UL",{"data-svelte-h":!0}),r(_t)!=="svelte-dfn8uw"&&(_t.innerHTML=Ys),sa=s(e),p(Xt.$$.fragment,e),ia=s(e),Qt=o(e,"P",{}),Nt(Qt).forEach(l),this.h()},h(){v(y,"name","hf:doc:metadata"),v(y,"content",ti),Fs(J.src,os="https://github.com/dmaniloff/public-screenshots/blob/main/create-new-space.png?raw=true")||v(J,"src",os),v(J,"width","350"),v(J,"alt","image description"),Fs(j.src,Ms="https://github.com/dmaniloff/public-screenshots/blob/main/gradio-as-api.png?raw=true")||v(j,"src",Ms),v(j,"width","750"),v(j,"alt","image description")},m(e,t){B(document.head,y),n(e,f,t),n(e,w,t),n(e,g,t),c(G,e,t),n(e,qt,t),c(C,e,t),n(e,Et,t),n(e,Z,t),n(e,At,t),c(x,e,t),n(e,Pt,t),n(e,k,t),n(e,Dt,t),n(e,W,t),n(e,Kt,t),n(e,$,t),n(e,Ot,t),n(e,H,t),n(e,el,t),c(R,e,t),n(e,tl,t),n(e,V,t),n(e,ll,t),c(_,e,t),n(e,nl,t),n(e,X,t),n(e,al,t),c(S,e,t),n(e,sl,t),c(Y,e,t),n(e,il,t),n(e,F,t),n(e,ol,t),n(e,z,t),n(e,rl,t),c(L,e,t),n(e,ul,t),n(e,Q,t),n(e,pl,t),c(N,e,t),n(e,cl,t),n(e,q,t),n(e,dl,t),n(e,E,t),n(e,ml,t),c(A,e,t),n(e,hl,t),n(e,P,t),n(e,yl,t),n(e,D,t),n(e,Ml,t),c(K,e,t),n(e,wl,t),n(e,O,t),n(e,bl,t),n(e,ee,t),n(e,fl,t),n(e,te,t),n(e,gl,t),n(e,le,t),n(e,Tl,t),c(ne,e,t),n(e,Jl,t),n(e,ae,t),n(e,Ul,t),n(e,se,t),n(e,jl,t),n(e,ie,t),n(e,Il,t),n(e,oe,t),n(e,vl,t),c(re,e,t),n(e,Bl,t),n(e,ue,t),n(e,Gl,t),n(e,pe,t),n(e,Cl,t),n(e,ce,t),n(e,Zl,t),c(de,e,t),n(e,xl,t),n(e,me,t),n(e,kl,t),c(he,e,t),n(e,Wl,t),n(e,ye,t),n(e,$l,t),n(e,Me,t),n(e,Hl,t),n(e,we,t),n(e,Rl,t),c(T,e,t),n(e,Vl,t),c(be,e,t),n(e,_l,t),n(e,fe,t),n(e,Xl,t),n(e,ge,t),n(e,Sl,t),n(e,Te,t),n(e,Yl,t),n(e,Je,t),n(e,Fl,t),n(e,Ue,t),n(e,zl,t),c(je,e,t),n(e,Ll,t),n(e,Ie,t),n(e,Ql,t),n(e,ve,t),n(e,Nl,t),n(e,Be,t),n(e,ql,t),c(Ge,e,t),n(e,El,t),c(Ce,e,t),n(e,Al,t),n(e,Ze,t),n(e,Pl,t),c(xe,e,t),n(e,Dl,t),n(e,ke,t),n(e,Kl,t),n(e,We,t),n(e,Ol,t),n(e,$e,t),n(e,en,t),c(He,e,t),n(e,tn,t),n(e,Re,t),n(e,ln,t),n(e,Ve,t),n(e,nn,t),n(e,_e,t),n(e,an,t),c(Xe,e,t),n(e,sn,t),n(e,Se,t),n(e,on,t),n(e,Ye,t),n(e,rn,t),c(Fe,e,t),n(e,un,t),n(e,ze,t),n(e,pn,t),n(e,Le,t),n(e,cn,t),n(e,Qe,t),n(e,dn,t),n(e,J,t),n(e,mn,t),n(e,Ne,t),n(e,hn,t),n(e,qe,t),n(e,yn,t),n(e,U,t),B(U,Ee),B(Ee,zt),B(Ee,ua),c(Ae,Ee,null),B(U,pa),B(U,Pe),B(Pe,Lt),B(Pe,ca),c(De,Pe,null),n(e,Mn,t),c(Ke,e,t),n(e,wn,t),n(e,Oe,t),n(e,bn,t),n(e,et,t),n(e,fn,t),c(tt,e,t),n(e,gn,t),n(e,lt,t),n(e,Tn,t),n(e,nt,t),n(e,Jn,t),n(e,j,t),n(e,Un,t),n(e,at,t),n(e,jn,t),c(st,e,t),n(e,In,t),n(e,it,t),n(e,vn,t),c(ot,e,t),n(e,Bn,t),n(e,rt,t),n(e,Gn,t),n(e,ut,t),n(e,Cn,t),n(e,pt,t),n(e,Zn,t),n(e,ct,t),n(e,xn,t),n(e,dt,t),n(e,kn,t),c(I,e,t),n(e,Wn,t),c(mt,e,t),n(e,$n,t),n(e,ht,t),n(e,Hn,t),c(yt,e,t),n(e,Rn,t),n(e,Mt,t),n(e,Vn,t),c(wt,e,t),n(e,_n,t),n(e,bt,t),n(e,Xn,t),n(e,ft,t),n(e,Sn,t),n(e,gt,t),n(e,Yn,t),c(Tt,e,t),n(e,Fn,t),n(e,Jt,t),n(e,zn,t),n(e,Ut,t),n(e,Ln,t),n(e,jt,t),n(e,Qn,t),c(It,e,t),n(e,Nn,t),n(e,vt,t),n(e,qn,t),n(e,Bt,t),n(e,En,t),c(Gt,e,t),n(e,An,t),n(e,Ct,t),n(e,Pn,t),c(Zt,e,t),n(e,Dn,t),n(e,xt,t),n(e,Kn,t),n(e,kt,t),n(e,On,t),n(e,Wt,t),n(e,ea,t),n(e,$t,t),n(e,ta,t),n(e,Ht,t),n(e,la,t),n(e,Rt,t),n(e,na,t),c(Vt,e,t),n(e,aa,t),n(e,_t,t),n(e,sa,t),c(Xt,e,t),n(e,ia,t),n(e,Qt,t),oa=!0},p(e,[t]){const St={};t&2&&(St.$$scope={dirty:t,ctx:e}),T.$set(St);const Yt={};t&2&&(Yt.$$scope={dirty:t,ctx:e}),I.$set(Yt)},i(e){oa||(d(G.$$.fragment,e),d(C.$$.fragment,e),d(x.$$.fragment,e),d(R.$$.fragment,e),d(_.$$.fragment,e),d(S.$$.fragment,e),d(Y.$$.fragment,e),d(L.$$.fragment,e),d(N.$$.fragment,e),d(A.$$.fragment,e),d(K.$$.fragment,e),d(ne.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),d(T.$$.fragment,e),d(be.$$.fragment,e),d(je.$$.fragment,e),d(Ge.$$.fragment,e),d(Ce.$$.fragment,e),d(xe.$$.fragment,e),d(He.$$.fragment,e),d(Xe.$$.fragment,e),d(Fe.$$.fragment,e),d(Ae.$$.fragment,e),d(De.$$.fragment,e),d(Ke.$$.fragment,e),d(tt.$$.fragment,e),d(st.$$.fragment,e),d(ot.$$.fragment,e),d(I.$$.fragment,e),d(mt.$$.fragment,e),d(yt.$$.fragment,e),d(wt.$$.fragment,e),d(Tt.$$.fragment,e),d(It.$$.fragment,e),d(Gt.$$.fragment,e),d(Zt.$$.fragment,e),d(Vt.$$.fragment,e),d(Xt.$$.fragment,e),oa=!0)},o(e){m(G.$$.fragment,e),m(C.$$.fragment,e),m(x.$$.fragment,e),m(R.$$.fragment,e),m(_.$$.fragment,e),m(S.$$.fragment,e),m(Y.$$.fragment,e),m(L.$$.fragment,e),m(N.$$.fragment,e),m(A.$$.fragment,e),m(K.$$.fragment,e),m(ne.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(T.$$.fragment,e),m(be.$$.fragment,e),m(je.$$.fragment,e),m(Ge.$$.fragment,e),m(Ce.$$.fragment,e),m(xe.$$.fragment,e),m(He.$$.fragment,e),m(Xe.$$.fragment,e),m(Fe.$$.fragment,e),m(Ae.$$.fragment,e),m(De.$$.fragment,e),m(Ke.$$.fragment,e),m(tt.$$.fragment,e),m(st.$$.fragment,e),m(ot.$$.fragment,e),m(I.$$.fragment,e),m(mt.$$.fragment,e),m(yt.$$.fragment,e),m(wt.$$.fragment,e),m(Tt.$$.fragment,e),m(It.$$.fragment,e),m(Gt.$$.fragment,e),m(Zt.$$.fragment,e),m(Vt.$$.fragment,e),m(Xt.$$.fragment,e),oa=!1},d(e){e&&(l(f),l(w),l(g),l(qt),l(Et),l(Z),l(At),l(Pt),l(k),l(Dt),l(W),l(Kt),l($),l(Ot),l(H),l(el),l(tl),l(V),l(ll),l(nl),l(X),l(al),l(sl),l(il),l(F),l(ol),l(z),l(rl),l(ul),l(Q),l(pl),l(cl),l(q),l(dl),l(E),l(ml),l(hl),l(P),l(yl),l(D),l(Ml),l(wl),l(O),l(bl),l(ee),l(fl),l(te),l(gl),l(le),l(Tl),l(Jl),l(ae),l(Ul),l(se),l(jl),l(ie),l(Il),l(oe),l(vl),l(Bl),l(ue),l(Gl),l(pe),l(Cl),l(ce),l(Zl),l(xl),l(me),l(kl),l(Wl),l(ye),l($l),l(Me),l(Hl),l(we),l(Rl),l(Vl),l(_l),l(fe),l(Xl),l(ge),l(Sl),l(Te),l(Yl),l(Je),l(Fl),l(Ue),l(zl),l(Ll),l(Ie),l(Ql),l(ve),l(Nl),l(Be),l(ql),l(El),l(Al),l(Ze),l(Pl),l(Dl),l(ke),l(Kl),l(We),l(Ol),l($e),l(en),l(tn),l(Re),l(ln),l(Ve),l(nn),l(_e),l(an),l(sn),l(Se),l(on),l(Ye),l(rn),l(un),l(ze),l(pn),l(Le),l(cn),l(Qe),l(dn),l(J),l(mn),l(Ne),l(hn),l(qe),l(yn),l(U),l(Mn),l(wn),l(Oe),l(bn),l(et),l(fn),l(gn),l(lt),l(Tn),l(nt),l(Jn),l(j),l(Un),l(at),l(jn),l(In),l(it),l(vn),l(Bn),l(rt),l(Gn),l(ut),l(Cn),l(pt),l(Zn),l(ct),l(xn),l(dt),l(kn),l(Wn),l($n),l(ht),l(Hn),l(Rn),l(Mt),l(Vn),l(_n),l(bt),l(Xn),l(ft),l(Sn),l(gt),l(Yn),l(Fn),l(Jt),l(zn),l(Ut),l(Ln),l(jt),l(Qn),l(Nn),l(vt),l(qn),l(Bt),l(En),l(An),l(Ct),l(Pn),l(Dn),l(xt),l(Kn),l(kt),l(On),l(Wt),l(ea),l($t),l(ta),l(Ht),l(la),l(Rt),l(na),l(aa),l(_t),l(sa),l(ia),l(Qt)),l(y),h(G,e),h(C,e),h(x,e),h(R,e),h(_,e),h(S,e),h(Y,e),h(L,e),h(N,e),h(A,e),h(K,e),h(ne,e),h(re,e),h(de,e),h(he,e),h(T,e),h(be,e),h(je,e),h(Ge,e),h(Ce,e),h(xe,e),h(He,e),h(Xe,e),h(Fe,e),h(Ae),h(De),h(Ke,e),h(tt,e),h(st,e),h(ot,e),h(I,e),h(mt,e),h(yt,e),h(wt,e),h(Tt,e),h(It,e),h(Gt,e),h(Zt,e),h(Vt,e),h(Xt,e)}}}const ti='{"title":"Creating Demos with Spaces and Gradio","local":"creating-demos-with-spaces-and-gradio","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Your first demo: the basics of Gradio","local":"your-first-demo-the-basics-of-gradio","sections":[],"depth":2},{"title":"Let’s make it interesting: a meeting transcription tool","local":"lets-make-it-interesting-a-meeting-transcription-tool","sections":[{"title":"Audio-to-text","local":"audio-to-text","sections":[],"depth":3},{"title":"Organize & summarize text","local":"organize--summarize-text","sections":[],"depth":3},{"title":"Putting it all together","local":"putting-it-all-together","sections":[],"depth":3}],"depth":2},{"title":"Move your demo into 🤗 Spaces","local":"move-your-demo-into--spaces","sections":[],"depth":2},{"title":"Gradio comes with batteries included 🔋","local":"gradio-comes-with-batteries-included-","sections":[{"title":"Access as an API","local":"access-as-an-api","sections":[],"depth":3},{"title":"Share via public URL","local":"share-via-public-url","sections":[],"depth":3},{"title":"Flagging","local":"flagging","sections":[],"depth":3}],"depth":2},{"title":"Wrap up & Next Steps","local":"wrap-up--next-steps","sections":[],"depth":2},{"title":"⏭️ Further reading","local":"-further-reading","sections":[],"depth":2}],"depth":1}';function li(Ft){return Ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ri extends qs{constructor(y){super(),Es(this,y,li,ei,Qs,{})}}export{ri as component};
