import{s as RT,o as mT,n as hT}from"../chunks/scheduler.f6319a2a.js";import{S as uT,i as cT,g as t,s as e,r as s,A as bT,h as i,f as T,c as M,j as dT,u as n,x as C,k as FT,y as QT,a as J,v as a,d as y,t as w,w as o}from"../chunks/index.85aa684c.js";import{T as jT}from"../chunks/Tip.3d397a88.js";import{C as I}from"../chunks/CodeBlock.97b48fd2.js";import{D as AT}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as k,E as DT}from"../chunks/EditOnGithub.006048dd.js";function BT(ul){let g,V='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){g=t("p"),g.innerHTML=V},l(N){g=i(N,"P",{"data-svelte-h":!0}),C(g)!=="svelte-1p1d9vw"&&(g.innerHTML=V)},m(N,ml){J(N,g,ml)},p:hT,d(N){N&&T(g)}}}function fT(ul){let g,V,N,ml,r,cl,O,bl,d,fU=`There’s a world of difference between building an agent that works and one that doesn’t.
How can we build agents that fall into the latter category?
In this guide, we’re going to see best practices for building agents.`,Ql,p,jl,F,Al,R,ZU="Giving an LLM some agency in your workflow introduces some risk of errors.",Dl,m,GU="Well-programmed agentic systems have good error logging and retry mechanisms anyway, so the LLM engine has a chance to self-correct their mistake. But to reduce the risk of LLM error to the maximum, you should simplify your workflow!",Bl,h,vU=`Let’s revisit the example from [intro_agents]: a bot that answers user queries for a surf trip company.
Instead of letting the agent do 2 different calls for “travel distance API” and “weather API” each time they are asked about a new surf spot, you could just make one unified tool “return_spot_information”, a function that calls both APIs at once and returns their concatenated outputs to the user.`,fl,u,xU="This will reduce costs, latency, and error risk!",Zl,c,EU="The main guideline is: Reduce the number of LLM calls as much as you can.",Gl,b,WU="This leads to a few takeaways:",vl,Q,zU="<li>Whenever possible, group 2 tools in one, like in our example of the two APIs.</li> <li>Whenever possible, logic should be based on deterministic functions rather than agentic decisions.</li>",xl,j,El,A,XU="Remember that your LLM engine is like a ~intelligent~ robot, tapped into a room with the only communication with the outside world being notes passed under a door.",Wl,D,HU="It won’t know of anything that happened if you don’t explicitly put that into its prompt.",zl,B,YU=`So first start with making your task very clear!
Since an agent is powered by an LLM, minor variations in your task formulation might yield completely different results.`,Xl,f,_U="Then, improve the information flow towards your agent in tool use.",Hl,Z,SU="Particular guidelines to follow:",Yl,G,$U="<li>Each tool should log (by simply using <code>print</code> statements inside the tool’s <code>forward</code> method) everything that could be useful for the LLM engine.<ul><li>In particular, logging detail on tool execution errors would help a lot!</li></ul></li>",_l,v,LU="For instance, here’s a tool that retrieves weather data based on location and date-time:",Sl,x,qU="First, here’s a poor version:",$l,E,Ll,W,PU="Why is it bad?",ql,z,KU="<li>there’s no precision of the format that should be used for <code>date_time</code></li> <li>there’s no detail on how location should be specified.</li> <li>there’s no logging mechanism tying to explicit failure cases like location not being in a proper format, or date_time not being properly formatted.</li> <li>the output format is hard to understand</li>",Pl,X,lT="If the tool call fails, the error trace logged in memory can help the LLM reverse engineer the tool to fix the errors. But why leave it with so much heavy lifting to do?",Kl,H,UT="A better way to build this tool would have been the following:",lU,Y,UU,_,TT="In general, to ease the load on your LLM, the good question to ask yourself is: “How easy would it be for me, if I was dumb and using this tool for the first time ever, to program with this tool and correct my own errors?“.",TU,S,JU,$,JT="To pass some additional objects to your agent beyond the simple string describing the task, you can use the <code>additional_args</code> argument to pass any type of object:",eU,L,MU,q,eT="For instance, you can use this <code>additional_args</code> argument to pass images or strings that you want your agent to leverage.",tU,P,iU,K,CU,ll,MT=`In an agentic workflows, some of the errors are actual errors, some other are the fault of your LLM engine not reasoning properly.
For instance, consider this trace for an <code>CodeAgent</code> that I asked to create a car picture:`,sU,Ul,nU,Tl,tT=`The user sees, instead of an image being returned, a path being returned to them.
It could look like a bug from the system, but actually the agentic system didn’t cause the error: it’s just that the LLM brain did the mistake of not saving the image output into a variable.
Thus it cannot access the image again except by leveraging the path that was logged while saving the image, so it returns the path instead of an image.`,aU,Jl,iT="The first step to debugging your agent is thus “Use a more powerful LLM”. Alternatives like <code>Qwen2/5-72B-Instruct</code> wouldn’t have made that mistake.",yU,el,wU,Ml,CT="You can also use less powerful models, provided you guide them more effectively.",oU,tl,sT="Put yourself in the shoes of your model: if you were the model solving the task, would you struggle with the information available to you (from the system prompt + task formulation + tool description) ?",gU,il,nT="Would you need some added clarifications?",NU,Cl,aT=`To provide extra information, we do not recommend to change the system prompt right away: the default system prompt has many adjustments that you do not want to mess up except if you understand the prompt very well.
Better ways to guide your LLM engine are:`,kU,sl,yT="<li>If it ‘s about the task to solve: add all these details to the task. The task could be 100s of pages long.</li> <li>If it’s about how to use tools: the description attribute of your tools.</li>",pU,nl,IU,al,wT="If above clarifications above are not sufficient, you can change the system prompt.",VU,yl,oT='Let’s see how it works. For example, let us check the default system prompt for the <a href="/docs/smolagents/pr_98/en/reference/agents#smolagents.CodeAgent">CodeAgent</a> (below version is shortened by skipping zero-shot examples).',rU,wl,OU,ol,gT="Here is what you get:",dU,gl,FU,Nl,NT="As yo can see, there are placeholders like <code>&quot;{{tool_descriptions}}&quot;</code>: these will be used upon agent initialization to insert certain automatically generated descriptions of tools or managed agents.",RU,kl,kT="So while you can overwrite this system prompt template by passing your custom prompt as an argument to the <code>system_prompt</code> parameter, your new system promptmust contain the following placeholders:",mU,pl,pT="<li><code>&quot;{{tool_descriptions}}&quot;</code> to insert tool descriptions.</li> <li><code>&quot;{{managed_agents_description}}&quot;</code> to insert the description for managed agents if there are any.</li> <li>For <code>CodeAgent</code> only: <code>&quot;{{authorized_imports}}&quot;</code> to insert the list of authorized imports.</li>",hU,Il,IT="Then you can change the system prompt as follows:",uU,Vl,cU,rl,VT='This also works with the <a href="/docs/smolagents/pr_98/en/reference/agents#smolagents.ToolCallingAgent">ToolCallingAgent</a>.',bU,Ol,QU,dl,rT="We provide a model for a supplementary planning step, that an agent can run regularly in-between normal action steps. In this step, there is no tool call, the LLM is simply asked to update a list of facts it knows and to reflect on what steps it should take next based on those facts.",jU,Fl,AU,Rl,DU,hl,BU;return r=new k({props:{title:"Building good agents",local:"building-good-agents",headingTag:"h1"}}),O=new AT({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/building_good_agents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/building_good_agents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/building_good_agents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/building_good_agents.ipynb"}]}}),p=new jT({props:{warning:!1,$$slots:{default:[BT]},$$scope:{ctx:ul}}}),F=new k({props:{title:"The best agentic systems are the simplest: simplify the workflow as much as you can",local:"the-best-agentic-systems-are-the-simplest-simplify-the-workflow-as-much-as-you-can",headingTag:"h3"}}),j=new k({props:{title:"Improve the information flow to the LLM engine",local:"improve-the-information-flow-to-the-llm-engine",headingTag:"h3"}}),E=new I({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMHRvb2wlMEElMEFkZWYlMjBnZXRfd2VhdGhlcl9yZXBvcnRfYXRfY29vcmRpbmF0ZXMoY29vcmRpbmF0ZXMlMkMlMjBkYXRlX3RpbWUpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRHVtbXklMjBmdW5jdGlvbiUyQyUyMHJldHVybnMlMjBhJTIwbGlzdCUyMG9mJTIwJTVCdGVtcGVyYXR1cmUlMjBpbiUyMCVDMiVCMEMlMkMlMjByaXNrJTIwb2YlMjByYWluJTIwb24lMjBhJTIwc2NhbGUlMjAwLTElMkMlMjB3YXZlJTIwaGVpZ2h0JTIwaW4lMjBtJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCMjguMCUyQyUyMDAuMzUlMkMlMjAwLjg1JTVEJTBBJTBBZGVmJTIwZ2V0X2Nvb3JkaW5hdGVzX2Zyb21fbG9jYXRpb24obG9jYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmV0dXJucyUyMGR1bW15JTIwY29vcmRpbmF0ZXMlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIzLjMlMkMlMjAtNDIuMCU1RCUwQSUwQSU0MHRvb2wlMEFkZWYlMjBnZXRfd2VhdGhlcl9hcGkobG9jYXRpb24lM0ElMjBzdHIlMkMlMjBkYXRlX3RpbWUlM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMFJldHVybnMlMjB0aGUlMjB3ZWF0aGVyJTIwcmVwb3J0LiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2NhdGlvbiUzQSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMHBsYWNlJTIwdGhhdCUyMHlvdSUyMHdhbnQlMjB0aGUlMjB3ZWF0aGVyJTIwZm9yLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGVfdGltZSUzQSUyMHRoZSUyMGRhdGUlMjBhbmQlMjB0aW1lJTIwZm9yJTIwd2hpY2glMjB5b3UlMjB3YW50JTIwdGhlJTIwcmVwb3J0LiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGxvbiUyQyUyMGxhdCUyMCUzRCUyMGNvbnZlcnRfbG9jYXRpb25fdG9fY29vcmRpbmF0ZXMobG9jYXRpb24pJTBBJTIwJTIwJTIwJTIwZGF0ZV90aW1lJTIwJTNEJTIwZGF0ZXRpbWUuc3RycHRpbWUoZGF0ZV90aW1lKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHN0cihnZXRfd2VhdGhlcl9yZXBvcnRfYXRfY29vcmRpbmF0ZXMoKGxvbiUyQyUyMGxhdCklMkMlMjBkYXRlX3RpbWUpKQ==",highlighted:`<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_report_at_coordinates</span>(<span class="hljs-params">coordinates, date_time</span>):
    <span class="hljs-comment"># Dummy function, returns a list of [temperature in °C, risk of rain on a scale 0-1, wave height in m]</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">28.0</span>, <span class="hljs-number">0.35</span>, <span class="hljs-number">0.85</span>]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_coordinates_from_location</span>(<span class="hljs-params">location</span>):
    <span class="hljs-comment"># Returns dummy coordinates</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">3.3</span>, -<span class="hljs-number">42.0</span>]

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for.
        date_time: the date and time for which you want the report.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(get_weather_report_at_coordinates((lon, lat), date_time))`,wrap:!1}}),Y=new I({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for. Should be a place name, followed by possibly a city name, then a country, like &quot;Anchor Point, Taghazout, Morocco&quot;.
        date_time: the date and time for which you want the report, formatted as &#x27;%m/%d/%y %H:%M:%S&#x27;.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    <span class="hljs-keyword">try</span>:
        date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Conversion of \`date_time\` to datetime format failed, make sure to provide a string in format &#x27;%m/%d/%y %H:%M:%S&#x27;. Full trace:&quot;</span> + <span class="hljs-built_in">str</span>(e))
    temperature_celsius, risk_of_rain, wave_height = get_weather_report_at_coordinates((lon, lat), date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Weather report for <span class="hljs-subst">{location}</span>, <span class="hljs-subst">{date_time}</span>: Temperature will be <span class="hljs-subst">{temperature_celsius}</span>°C, risk of rain is <span class="hljs-subst">{risk_of_rain*<span class="hljs-number">100</span>:<span class="hljs-number">.0</span>f}</span>%, wave height is <span class="hljs-subst">{wave_height}</span>m.&quot;</span>`,wrap:!1}}),S=new k({props:{title:"Give more arguments to the agent",local:"give-more-arguments-to-the-agent",headingTag:"h3"}}),L=new I({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4zLTcwQi1JbnN0cnVjdCUyMiUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0RIZkFwaU1vZGVsKG1vZGVsX2lkJTNEbW9kZWxfaWQpJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJXaHklMjBkb2VzJTIwTWlrZSUyMG5vdCUyMGtub3clMjBtYW55JTIwcGVvcGxlJTIwaW4lMjBOZXclMjBZb3JrJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hcmdzJTNEJTdCJTIybXAzX3NvdW5kX2ZpbGVfdXJsJTIyJTNBJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnRyYW5zZm9ybWVycyUyRnJlY29yZGluZy5tcDMnJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>

agent = CodeAgent(tools=[], model=HfApiModel(model_id=model_id), add_base_tools=<span class="hljs-literal">True</span>)

agent.run(
    <span class="hljs-string">&quot;Why does Mike not know many people in New York?&quot;</span>,
    additional_args={<span class="hljs-string">&quot;mp3_sound_file_url&quot;</span>:<span class="hljs-string">&#x27;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/recording.mp3&#x27;</span>}
)`,wrap:!1}}),P=new k({props:{title:"How to debug your agent",local:"how-to-debug-your-agent",headingTag:"h2"}}),K=new k({props:{title:"1. Use a stronger LLM",local:"1-use-a-stronger-llm",headingTag:"h3"}}),Ul=new I({props:{code:"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",highlighted:`==================================================================================================== <span class="hljs-keyword">New</span> <span class="hljs-keyword">task</span> ====================================================================================================
Make me a cool car picture
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
image_generator(prompt=<span class="hljs-string">&quot;A cool, futuristic sports car with LED headlights, aerodynamic design, and vibrant color, high-res, photorealistic&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Step</span> <span class="hljs-number">1</span>:

- Time taken: <span class="hljs-number">16.35</span> seconds
- Input tokens: <span class="hljs-number">1</span>,<span class="hljs-number">383</span>
- Output tokens: <span class="hljs-number">77</span>
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
final_answer(<span class="hljs-string">&quot;/var/folders/6m/9b1tts6d5w960j80wbw9tx3m0000gn/T/tmpx09qfsdd/652f0007-3ee9-44e2-94ac-90dae6bb89a4.png&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-keyword">Print</span> outputs:

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Final</span> answer:
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png`,wrap:!1}}),el=new k({props:{title:"2. Provide more guidance / more information",local:"2-provide-more-guidance--more-information",headingTag:"h3"}}),nl=new k({props:{title:"3. Change the system prompt (generally not advised)",local:"3-change-the-system-prompt-generally-not-advised",headingTag:"h3"}}),wl=new I({props:{code:"cHJpbnQoYWdlbnQuc3lzdGVtX3Byb21wdF90ZW1wbGF0ZSk=",highlighted:'<span class="hljs-built_in">print</span>(agent.system_prompt_template)',wrap:!1}}),gl=new I({props:{code:"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",highlighted:`You are an expert assistant who can solve any task using code blobs. You will be given a task to solve as best you can.
To do so, you have been given access to a list of tools: these tools are basically Python functions which you can call with code.
To solve the task, you must plan forward to proceed in a series of steps, in a cycle of &#x27;Thought:&#x27;, &#x27;Code:&#x27;, and &#x27;Observation:&#x27; sequences.

At each step, in the &#x27;Thought:&#x27; sequence, you should first explain your reasoning towards solving the task and the tools that you want to use.
Then in the &#x27;Code:&#x27; sequence, you should write the code in simple Python. The code sequence must end with &#x27;&lt;end_code&gt;&#x27; sequence.
During each intermediate step, you can use &#x27;print()&#x27; to save whatever important information you will then need.
These print outputs will then appear in the &#x27;Observation:&#x27; field, which will be available as input for the next step.
In the end you have to return a final answer using the \`final_answer\` tool.

Here are a few examples using notional tools:
---
{examples}

Above example were using notional tools that might not exist for you. On top of performing computations in the Python code snippets that you create, you only have access to these tools:

{{tool_descriptions}}

{{managed_agents_descriptions}}

Here are the rules you should always follow to solve your task:
1. Always provide a &#x27;Thought:&#x27; sequence, and a &#x27;Code:\\n\`\`\`py&#x27; sequence ending with &#x27;\`\`\`&lt;end_code&gt;&#x27; sequence, else you will fail.
2. Use only variables that you have defined!
3. Always use the right arguments for the tools. DO NOT pass the arguments as a dict as in &#x27;answer = wiki({&#x27;query&#x27;: &quot;What is the place where James Bond lives?&quot;})&#x27;, but use the arguments directly as in &#x27;answer = wiki(query=&quot;What is the place where James Bond lives?&quot;)&#x27;.
4. Take care to not chain too many sequential tool calls in the same code block, especially when the output format is unpredictable. For instance, a call to search has an unpredictable return format, so do not have another tool call that depends on its output in the same block: rather output results with print() to use them in the next block.
5. Call a tool only when needed, and never re-do a tool call that you previously did with the exact same parameters.
6. Don&#x27;t name any new variable with the same name as a tool: for instance don&#x27;t name a variable &#x27;final_answer&#x27;.
7. Never create any notional variables in our code, as having these in your logs might derail you from the true variables.
8. You can use imports in your code, but only from the following list of modules: {{authorized_imports}}
9. The state persists between code executions: so if in one step you&#x27;ve created variables or imported modules, these will all persist.
10. Don&#x27;t give up! You&#x27;re in charge of solving the task, not providing directions to solve it.

Now Begin! If you solve the task correctly, you will receive a reward of $1,000,000.`,wrap:!1}}),Vl=new I({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMucHJvbXB0cyUyMGltcG9ydCUyMENPREVfU1lTVEVNX1BST01QVCUwQSUwQW1vZGlmaWVkX3N5c3RlbV9wcm9tcHQlMjAlM0QlMjBDT0RFX1NZU1RFTV9QUk9NUFQlMjAlMkIlMjAlMjIlNUNuSGVyZSUyMHlvdSUyMGdvISUyMiUyMCUyMyUyMENoYW5nZSUyMHRoZSUyMHN5c3RlbSUyMHByb21wdCUyMGhlcmUlMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUyMCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESGZBcGlNb2RlbCgpJTJDJTIwJTBBJTIwJTIwJTIwJTIwc3lzdGVtX3Byb21wdCUzRG1vZGlmaWVkX3N5c3RlbV9wcm9tcHQlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents.prompts <span class="hljs-keyword">import</span> CODE_SYSTEM_PROMPT

modified_system_prompt = CODE_SYSTEM_PROMPT + <span class="hljs-string">&quot;\\nHere you go!&quot;</span> <span class="hljs-comment"># Change the system prompt here</span>

agent = CodeAgent(
    tools=[], 
    model=HfApiModel(), 
    system_prompt=modified_system_prompt
)`,wrap:!1}}),Ol=new k({props:{title:"4. Extra planning",local:"4-extra-planning",headingTag:"h3"}}),Fl=new I({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMEFmcm9tJTIwZG90ZW52JTIwaW1wb3J0JTIwbG9hZF9kb3RlbnYlMEElMEFsb2FkX2RvdGVudigpJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2woKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREhmQXBpTW9kZWwoJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyKSUyQyUwQSUyMCUyMCUyMCUyMHBsYW5uaW5nX2ludGVydmFsJTNEMyUyMCUyMyUyMFRoaXMlMjBpcyUyMHdoZXJlJTIweW91JTIwYWN0aXZhdGUlMjBwbGFubmluZyElMEEpJTBBJTBBJTIzJTIwUnVuJTIwaXQhJTBBcmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkhvdyUyMGxvbmclMjB3b3VsZCUyMGElMjBjaGVldGFoJTIwYXQlMjBmdWxsJTIwc3BlZWQlMjB0YWtlJTIwdG8lMjBydW4lMjB0aGUlMjBsZW5ndGglMjBvZiUyMFBvbnQlMjBBbGV4YW5kcmUlMjBJSUklM0YlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, HfApiModel, DuckDuckGoSearchTool
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv

load_dotenv()

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

search_tool = DuckDuckGoSearchTool()

agent = CodeAgent(
    tools=[search_tool],
    model=HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>),
    planning_interval=<span class="hljs-number">3</span> <span class="hljs-comment"># This is where you activate planning!</span>
)

<span class="hljs-comment"># Run it!</span>
result = agent.run(
    <span class="hljs-string">&quot;How long would a cheetah at full speed take to run the length of Pont Alexandre III?&quot;</span>,
)`,wrap:!1}}),Rl=new DT({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/building_good_agents.md"}}),{c(){g=t("meta"),V=e(),N=t("p"),ml=e(),s(r.$$.fragment),cl=e(),s(O.$$.fragment),bl=e(),d=t("p"),d.textContent=fU,Ql=e(),s(p.$$.fragment),jl=e(),s(F.$$.fragment),Al=e(),R=t("p"),R.textContent=ZU,Dl=e(),m=t("p"),m.textContent=GU,Bl=e(),h=t("p"),h.textContent=vU,fl=e(),u=t("p"),u.textContent=xU,Zl=e(),c=t("p"),c.textContent=EU,Gl=e(),b=t("p"),b.textContent=WU,vl=e(),Q=t("ul"),Q.innerHTML=zU,xl=e(),s(j.$$.fragment),El=e(),A=t("p"),A.textContent=XU,Wl=e(),D=t("p"),D.textContent=HU,zl=e(),B=t("p"),B.textContent=YU,Xl=e(),f=t("p"),f.textContent=_U,Hl=e(),Z=t("p"),Z.textContent=SU,Yl=e(),G=t("ul"),G.innerHTML=$U,_l=e(),v=t("p"),v.textContent=LU,Sl=e(),x=t("p"),x.textContent=qU,$l=e(),s(E.$$.fragment),Ll=e(),W=t("p"),W.textContent=PU,ql=e(),z=t("ul"),z.innerHTML=KU,Pl=e(),X=t("p"),X.textContent=lT,Kl=e(),H=t("p"),H.textContent=UT,lU=e(),s(Y.$$.fragment),UU=e(),_=t("p"),_.textContent=TT,TU=e(),s(S.$$.fragment),JU=e(),$=t("p"),$.innerHTML=JT,eU=e(),s(L.$$.fragment),MU=e(),q=t("p"),q.innerHTML=eT,tU=e(),s(P.$$.fragment),iU=e(),s(K.$$.fragment),CU=e(),ll=t("p"),ll.innerHTML=MT,sU=e(),s(Ul.$$.fragment),nU=e(),Tl=t("p"),Tl.textContent=tT,aU=e(),Jl=t("p"),Jl.innerHTML=iT,yU=e(),s(el.$$.fragment),wU=e(),Ml=t("p"),Ml.textContent=CT,oU=e(),tl=t("p"),tl.textContent=sT,gU=e(),il=t("p"),il.textContent=nT,NU=e(),Cl=t("p"),Cl.textContent=aT,kU=e(),sl=t("ul"),sl.innerHTML=yT,pU=e(),s(nl.$$.fragment),IU=e(),al=t("p"),al.textContent=wT,VU=e(),yl=t("p"),yl.innerHTML=oT,rU=e(),s(wl.$$.fragment),OU=e(),ol=t("p"),ol.textContent=gT,dU=e(),s(gl.$$.fragment),FU=e(),Nl=t("p"),Nl.innerHTML=NT,RU=e(),kl=t("p"),kl.innerHTML=kT,mU=e(),pl=t("ul"),pl.innerHTML=pT,hU=e(),Il=t("p"),Il.textContent=IT,uU=e(),s(Vl.$$.fragment),cU=e(),rl=t("p"),rl.innerHTML=VT,bU=e(),s(Ol.$$.fragment),QU=e(),dl=t("p"),dl.textContent=rT,jU=e(),s(Fl.$$.fragment),AU=e(),s(Rl.$$.fragment),DU=e(),hl=t("p"),this.h()},l(l){const U=bT("svelte-u9bgzb",document.head);g=i(U,"META",{name:!0,content:!0}),U.forEach(T),V=M(l),N=i(l,"P",{}),dT(N).forEach(T),ml=M(l),n(r.$$.fragment,l),cl=M(l),n(O.$$.fragment,l),bl=M(l),d=i(l,"P",{"data-svelte-h":!0}),C(d)!=="svelte-byver2"&&(d.textContent=fU),Ql=M(l),n(p.$$.fragment,l),jl=M(l),n(F.$$.fragment,l),Al=M(l),R=i(l,"P",{"data-svelte-h":!0}),C(R)!=="svelte-jydojv"&&(R.textContent=ZU),Dl=M(l),m=i(l,"P",{"data-svelte-h":!0}),C(m)!=="svelte-f19v2r"&&(m.textContent=GU),Bl=M(l),h=i(l,"P",{"data-svelte-h":!0}),C(h)!=="svelte-m09d16"&&(h.textContent=vU),fl=M(l),u=i(l,"P",{"data-svelte-h":!0}),C(u)!=="svelte-1265t8d"&&(u.textContent=xU),Zl=M(l),c=i(l,"P",{"data-svelte-h":!0}),C(c)!=="svelte-67t7fl"&&(c.textContent=EU),Gl=M(l),b=i(l,"P",{"data-svelte-h":!0}),C(b)!=="svelte-zyva75"&&(b.textContent=WU),vl=M(l),Q=i(l,"UL",{"data-svelte-h":!0}),C(Q)!=="svelte-nty9k8"&&(Q.innerHTML=zU),xl=M(l),n(j.$$.fragment,l),El=M(l),A=i(l,"P",{"data-svelte-h":!0}),C(A)!=="svelte-1sxjtyt"&&(A.textContent=XU),Wl=M(l),D=i(l,"P",{"data-svelte-h":!0}),C(D)!=="svelte-1bz3os9"&&(D.textContent=HU),zl=M(l),B=i(l,"P",{"data-svelte-h":!0}),C(B)!=="svelte-kvre75"&&(B.textContent=YU),Xl=M(l),f=i(l,"P",{"data-svelte-h":!0}),C(f)!=="svelte-s4b558"&&(f.textContent=_U),Hl=M(l),Z=i(l,"P",{"data-svelte-h":!0}),C(Z)!=="svelte-19k59ru"&&(Z.textContent=SU),Yl=M(l),G=i(l,"UL",{"data-svelte-h":!0}),C(G)!=="svelte-sky73b"&&(G.innerHTML=$U),_l=M(l),v=i(l,"P",{"data-svelte-h":!0}),C(v)!=="svelte-1pp4kyh"&&(v.textContent=LU),Sl=M(l),x=i(l,"P",{"data-svelte-h":!0}),C(x)!=="svelte-14ogt9"&&(x.textContent=qU),$l=M(l),n(E.$$.fragment,l),Ll=M(l),W=i(l,"P",{"data-svelte-h":!0}),C(W)!=="svelte-1invwxb"&&(W.textContent=PU),ql=M(l),z=i(l,"UL",{"data-svelte-h":!0}),C(z)!=="svelte-oe6iao"&&(z.innerHTML=KU),Pl=M(l),X=i(l,"P",{"data-svelte-h":!0}),C(X)!=="svelte-73i6xx"&&(X.textContent=lT),Kl=M(l),H=i(l,"P",{"data-svelte-h":!0}),C(H)!=="svelte-np4knk"&&(H.textContent=UT),lU=M(l),n(Y.$$.fragment,l),UU=M(l),_=i(l,"P",{"data-svelte-h":!0}),C(_)!=="svelte-q0zmuw"&&(_.textContent=TT),TU=M(l),n(S.$$.fragment,l),JU=M(l),$=i(l,"P",{"data-svelte-h":!0}),C($)!=="svelte-jz4g6f"&&($.innerHTML=JT),eU=M(l),n(L.$$.fragment,l),MU=M(l),q=i(l,"P",{"data-svelte-h":!0}),C(q)!=="svelte-usmqd6"&&(q.innerHTML=eT),tU=M(l),n(P.$$.fragment,l),iU=M(l),n(K.$$.fragment,l),CU=M(l),ll=i(l,"P",{"data-svelte-h":!0}),C(ll)!=="svelte-jh63p8"&&(ll.innerHTML=MT),sU=M(l),n(Ul.$$.fragment,l),nU=M(l),Tl=i(l,"P",{"data-svelte-h":!0}),C(Tl)!=="svelte-y1pddw"&&(Tl.textContent=tT),aU=M(l),Jl=i(l,"P",{"data-svelte-h":!0}),C(Jl)!=="svelte-y3io9r"&&(Jl.innerHTML=iT),yU=M(l),n(el.$$.fragment,l),wU=M(l),Ml=i(l,"P",{"data-svelte-h":!0}),C(Ml)!=="svelte-1b7s4xp"&&(Ml.textContent=CT),oU=M(l),tl=i(l,"P",{"data-svelte-h":!0}),C(tl)!=="svelte-ofl7w0"&&(tl.textContent=sT),gU=M(l),il=i(l,"P",{"data-svelte-h":!0}),C(il)!=="svelte-56ojdu"&&(il.textContent=nT),NU=M(l),Cl=i(l,"P",{"data-svelte-h":!0}),C(Cl)!=="svelte-1k3y8ke"&&(Cl.textContent=aT),kU=M(l),sl=i(l,"UL",{"data-svelte-h":!0}),C(sl)!=="svelte-1grv1sn"&&(sl.innerHTML=yT),pU=M(l),n(nl.$$.fragment,l),IU=M(l),al=i(l,"P",{"data-svelte-h":!0}),C(al)!=="svelte-1u3d3cc"&&(al.textContent=wT),VU=M(l),yl=i(l,"P",{"data-svelte-h":!0}),C(yl)!=="svelte-1sgcwcz"&&(yl.innerHTML=oT),rU=M(l),n(wl.$$.fragment,l),OU=M(l),ol=i(l,"P",{"data-svelte-h":!0}),C(ol)!=="svelte-174l3zr"&&(ol.textContent=gT),dU=M(l),n(gl.$$.fragment,l),FU=M(l),Nl=i(l,"P",{"data-svelte-h":!0}),C(Nl)!=="svelte-1abqyos"&&(Nl.innerHTML=NT),RU=M(l),kl=i(l,"P",{"data-svelte-h":!0}),C(kl)!=="svelte-1ed7es9"&&(kl.innerHTML=kT),mU=M(l),pl=i(l,"UL",{"data-svelte-h":!0}),C(pl)!=="svelte-mqwb3d"&&(pl.innerHTML=pT),hU=M(l),Il=i(l,"P",{"data-svelte-h":!0}),C(Il)!=="svelte-1gu6gc"&&(Il.textContent=IT),uU=M(l),n(Vl.$$.fragment,l),cU=M(l),rl=i(l,"P",{"data-svelte-h":!0}),C(rl)!=="svelte-1mh58jx"&&(rl.innerHTML=VT),bU=M(l),n(Ol.$$.fragment,l),QU=M(l),dl=i(l,"P",{"data-svelte-h":!0}),C(dl)!=="svelte-f8c96r"&&(dl.textContent=rT),jU=M(l),n(Fl.$$.fragment,l),AU=M(l),n(Rl.$$.fragment,l),DU=M(l),hl=i(l,"P",{}),dT(hl).forEach(T),this.h()},h(){FT(g,"name","hf:doc:metadata"),FT(g,"content",ZT)},m(l,U){QT(document.head,g),J(l,V,U),J(l,N,U),J(l,ml,U),a(r,l,U),J(l,cl,U),a(O,l,U),J(l,bl,U),J(l,d,U),J(l,Ql,U),a(p,l,U),J(l,jl,U),a(F,l,U),J(l,Al,U),J(l,R,U),J(l,Dl,U),J(l,m,U),J(l,Bl,U),J(l,h,U),J(l,fl,U),J(l,u,U),J(l,Zl,U),J(l,c,U),J(l,Gl,U),J(l,b,U),J(l,vl,U),J(l,Q,U),J(l,xl,U),a(j,l,U),J(l,El,U),J(l,A,U),J(l,Wl,U),J(l,D,U),J(l,zl,U),J(l,B,U),J(l,Xl,U),J(l,f,U),J(l,Hl,U),J(l,Z,U),J(l,Yl,U),J(l,G,U),J(l,_l,U),J(l,v,U),J(l,Sl,U),J(l,x,U),J(l,$l,U),a(E,l,U),J(l,Ll,U),J(l,W,U),J(l,ql,U),J(l,z,U),J(l,Pl,U),J(l,X,U),J(l,Kl,U),J(l,H,U),J(l,lU,U),a(Y,l,U),J(l,UU,U),J(l,_,U),J(l,TU,U),a(S,l,U),J(l,JU,U),J(l,$,U),J(l,eU,U),a(L,l,U),J(l,MU,U),J(l,q,U),J(l,tU,U),a(P,l,U),J(l,iU,U),a(K,l,U),J(l,CU,U),J(l,ll,U),J(l,sU,U),a(Ul,l,U),J(l,nU,U),J(l,Tl,U),J(l,aU,U),J(l,Jl,U),J(l,yU,U),a(el,l,U),J(l,wU,U),J(l,Ml,U),J(l,oU,U),J(l,tl,U),J(l,gU,U),J(l,il,U),J(l,NU,U),J(l,Cl,U),J(l,kU,U),J(l,sl,U),J(l,pU,U),a(nl,l,U),J(l,IU,U),J(l,al,U),J(l,VU,U),J(l,yl,U),J(l,rU,U),a(wl,l,U),J(l,OU,U),J(l,ol,U),J(l,dU,U),a(gl,l,U),J(l,FU,U),J(l,Nl,U),J(l,RU,U),J(l,kl,U),J(l,mU,U),J(l,pl,U),J(l,hU,U),J(l,Il,U),J(l,uU,U),a(Vl,l,U),J(l,cU,U),J(l,rl,U),J(l,bU,U),a(Ol,l,U),J(l,QU,U),J(l,dl,U),J(l,jU,U),a(Fl,l,U),J(l,AU,U),a(Rl,l,U),J(l,DU,U),J(l,hl,U),BU=!0},p(l,[U]){const OT={};U&2&&(OT.$$scope={dirty:U,ctx:l}),p.$set(OT)},i(l){BU||(y(r.$$.fragment,l),y(O.$$.fragment,l),y(p.$$.fragment,l),y(F.$$.fragment,l),y(j.$$.fragment,l),y(E.$$.fragment,l),y(Y.$$.fragment,l),y(S.$$.fragment,l),y(L.$$.fragment,l),y(P.$$.fragment,l),y(K.$$.fragment,l),y(Ul.$$.fragment,l),y(el.$$.fragment,l),y(nl.$$.fragment,l),y(wl.$$.fragment,l),y(gl.$$.fragment,l),y(Vl.$$.fragment,l),y(Ol.$$.fragment,l),y(Fl.$$.fragment,l),y(Rl.$$.fragment,l),BU=!0)},o(l){w(r.$$.fragment,l),w(O.$$.fragment,l),w(p.$$.fragment,l),w(F.$$.fragment,l),w(j.$$.fragment,l),w(E.$$.fragment,l),w(Y.$$.fragment,l),w(S.$$.fragment,l),w(L.$$.fragment,l),w(P.$$.fragment,l),w(K.$$.fragment,l),w(Ul.$$.fragment,l),w(el.$$.fragment,l),w(nl.$$.fragment,l),w(wl.$$.fragment,l),w(gl.$$.fragment,l),w(Vl.$$.fragment,l),w(Ol.$$.fragment,l),w(Fl.$$.fragment,l),w(Rl.$$.fragment,l),BU=!1},d(l){l&&(T(V),T(N),T(ml),T(cl),T(bl),T(d),T(Ql),T(jl),T(Al),T(R),T(Dl),T(m),T(Bl),T(h),T(fl),T(u),T(Zl),T(c),T(Gl),T(b),T(vl),T(Q),T(xl),T(El),T(A),T(Wl),T(D),T(zl),T(B),T(Xl),T(f),T(Hl),T(Z),T(Yl),T(G),T(_l),T(v),T(Sl),T(x),T($l),T(Ll),T(W),T(ql),T(z),T(Pl),T(X),T(Kl),T(H),T(lU),T(UU),T(_),T(TU),T(JU),T($),T(eU),T(MU),T(q),T(tU),T(iU),T(CU),T(ll),T(sU),T(nU),T(Tl),T(aU),T(Jl),T(yU),T(wU),T(Ml),T(oU),T(tl),T(gU),T(il),T(NU),T(Cl),T(kU),T(sl),T(pU),T(IU),T(al),T(VU),T(yl),T(rU),T(OU),T(ol),T(dU),T(FU),T(Nl),T(RU),T(kl),T(mU),T(pl),T(hU),T(Il),T(uU),T(cU),T(rl),T(bU),T(QU),T(dl),T(jU),T(AU),T(DU),T(hl)),T(g),o(r,l),o(O,l),o(p,l),o(F,l),o(j,l),o(E,l),o(Y,l),o(S,l),o(L,l),o(P,l),o(K,l),o(Ul,l),o(el,l),o(nl,l),o(wl,l),o(gl,l),o(Vl,l),o(Ol,l),o(Fl,l),o(Rl,l)}}}const ZT='{"title":"Building good agents","local":"building-good-agents","sections":[{"title":"The best agentic systems are the simplest: simplify the workflow as much as you can","local":"the-best-agentic-systems-are-the-simplest-simplify-the-workflow-as-much-as-you-can","sections":[],"depth":3},{"title":"Improve the information flow to the LLM engine","local":"improve-the-information-flow-to-the-llm-engine","sections":[],"depth":3},{"title":"Give more arguments to the agent","local":"give-more-arguments-to-the-agent","sections":[],"depth":3},{"title":"How to debug your agent","local":"how-to-debug-your-agent","sections":[{"title":"1. Use a stronger LLM","local":"1-use-a-stronger-llm","sections":[],"depth":3},{"title":"2. Provide more guidance / more information","local":"2-provide-more-guidance--more-information","sections":[],"depth":3},{"title":"3. Change the system prompt (generally not advised)","local":"3-change-the-system-prompt-generally-not-advised","sections":[],"depth":3},{"title":"4. Extra planning","local":"4-extra-planning","sections":[],"depth":3}],"depth":2}],"depth":1}';function GT(ul){return mT(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class HT extends uT{constructor(g){super(),cT(this,g,GT,fT,RT,{})}}export{HT as component};
