#!/usr/bin/env python3

import sys
import os
from collections import defaultdict

spk2len = defaultdict(int)
spk2line = {}

for line in open(sys.argv[1]):
    line = line.strip()
    items = line.split('|')
    size = os.path.getsize("../" + items[0])
    spk = items[1]
    if spk2len[spk] < size and size < 441000:
        spk2len[spk] = size
        spk2line[spk] = line

for it, v in spk2line.items():
    items = v.split("|")
    fitems = items[0].split("/")
    newfn = fitems[2] + "_" + fitems[-1]
    os.system(f"cp ../{items[0]} out/{newfn}")
    items[0] = newfn
    print ("|".join(items))
