#!/usr/bin/env python3

import sys
import numpy as np

id2u = {}
spk2u = {}

for line in open(sys.argv[1]):
    items = line.split()
    if len(items) == 2:
        id2u[items[0]] = float(items[1])
        spk = items[0].split('/')[1].split("_")[0]
        if spk not in spk2u:
            spk2u[spk] = []
        spk2u[spk].append(float(items[1]))

for spk, lu in spk2u.items():
    nscores = np.array(lu)
    print (spk, np.mean(lu), np.min(lu), len(lu))