/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.CryptoAllPermission;
import javax.crypto.CryptoPermission;
import javax.crypto.ExemptionMechanism;
import javax.crypto.ExemptionMechanismException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.JceSecurity;
import javax.crypto.JceSecurityManager;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import sun.security.jca.GetInstance;
import sun.security.jca.JCAUtil;
import sun.security.jca.ServiceId;
import sun.security.util.Debug;
import sun.security.util.KnownOIDs;

public class Cipher {
    private static final Debug debug = Debug.getInstance("jca", "Cipher");
    private static final Debug pdebug = Debug.getInstance("provider", "Provider");
    private static final boolean skipDebug = Debug.isOn("engine=") && !Debug.isOn("cipher");
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int WRAP_MODE = 3;
    public static final int UNWRAP_MODE = 4;
    public static final int PUBLIC_KEY = 1;
    public static final int PRIVATE_KEY = 2;
    public static final int SECRET_KEY = 3;
    private Provider provider;
    private CipherSpi spi;
    private String transformation;
    private CryptoPermission cryptoPerm;
    private ExemptionMechanism exmech;
    private boolean initialized = false;
    private int opmode = 0;
    private CipherSpi firstSpi;
    private Provider.Service firstService;
    private Iterator<Provider.Service> serviceIterator;
    private List<Transform> transforms;
    private final Object lock;
    private static final String ATTR_MODE = "SupportedModes";
    private static final String ATTR_PAD = "SupportedPaddings";
    private static final int S_NO = 0;
    private static final int S_MAYBE = 1;
    private static final int S_YES = 2;
    private static int warnCount = 10;
    private static final int I_KEY = 1;
    private static final int I_PARAMSPEC = 2;
    private static final int I_PARAMS = 3;
    private static final int I_CERT = 4;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String string) {
        if (!JceSecurityManager.INSTANCE.isCallerTrusted()) {
            throw new NullPointerException();
        }
        this.spi = cipherSpi;
        this.provider = provider;
        this.transformation = string;
        this.cryptoPerm = CryptoAllPermission.INSTANCE;
        this.lock = null;
    }

    Cipher(CipherSpi cipherSpi, String string) {
        this.spi = cipherSpi;
        this.transformation = string;
        this.cryptoPerm = CryptoAllPermission.INSTANCE;
        this.lock = null;
    }

    private Cipher(CipherSpi cipherSpi, Provider.Service service, Iterator<Provider.Service> iterator, String string, List<Transform> list) {
        this.firstSpi = cipherSpi;
        this.firstService = service;
        this.serviceIterator = iterator;
        this.transforms = list;
        this.transformation = string;
        this.lock = new Object();
    }

    private static String[] tokenizeTransformation(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NoSuchAlgorithmException("No transformation given");
        }
        String[] stringArray = new String[3];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        try {
            while (stringTokenizer.hasMoreTokens() && n < 3) {
                stringArray[n++] = stringTokenizer.nextToken().trim();
            }
            if (n == 0 || n == 2) {
                throw new NoSuchAlgorithmException("Invalid transformation format:" + string);
            }
            if (n == 3 && stringTokenizer.hasMoreTokens()) {
                stringArray[2] = stringArray[2] + stringTokenizer.nextToken("\r\n");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchAlgorithmException("Invalid transformation format:" + string);
        }
        if (stringArray[0] == null || stringArray[0].isEmpty()) {
            throw new NoSuchAlgorithmException("Invalid transformation:algorithm not specified-" + string);
        }
        return stringArray;
    }

    private static List<Transform> getTransforms(String string) throws NoSuchAlgorithmException {
        String[] stringArray = Cipher.tokenizeTransformation(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        if (string3 != null && string3.isEmpty()) {
            string3 = null;
        }
        if (string4 != null && string4.isEmpty()) {
            string4 = null;
        }
        if (string3 == null && string4 == null) {
            Transform transform = new Transform(string2, "", null, null);
            return Collections.singletonList(transform);
        }
        ArrayList<Transform> arrayList = new ArrayList<Transform>(4);
        arrayList.add(new Transform(string2, "/" + string3 + "/" + string4, null, null));
        arrayList.add(new Transform(string2, "/" + string3, null, string4));
        arrayList.add(new Transform(string2, "//" + string4, string3, null));
        arrayList.add(new Transform(string2, "", string3, string4));
        return arrayList;
    }

    private static Transform getTransform(Provider.Service service, List<Transform> list) {
        String string = service.getAlgorithm().toUpperCase(Locale.ENGLISH);
        for (Transform transform : list) {
            if (!string.endsWith(transform.suffix)) continue;
            return transform;
        }
        return null;
    }

    public static final Cipher getInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        List<Transform> list = Cipher.getTransforms(string);
        ArrayList<ServiceId> arrayList = new ArrayList<ServiceId>(list.size());
        for (Transform object2 : list) {
            arrayList.add(new ServiceId("Cipher", object2.transform));
        }
        List<Provider.Service> list2 = GetInstance.getServices(arrayList);
        Iterator<Provider.Service> iterator = list2.iterator();
        Exception exception = null;
        while (iterator.hasNext()) {
            int n;
            Transform transform;
            Provider.Service service = (Provider.Service)iterator.next();
            if (!JceSecurity.canUseProvider(service.getProvider()) || (transform = Cipher.getTransform(service, list)) == null || (n = transform.supportsModePadding(service)) == 0) continue;
            if (n == 2) {
                return new Cipher(null, service, iterator, string, list);
            }
            try {
                CipherSpi cipherSpi = (CipherSpi)service.newInstance(null);
                transform.setModePadding(cipherSpi);
                return new Cipher(cipherSpi, service, iterator, string, list);
            }
            catch (Exception cipherSpi) {
                exception = cipherSpi;
            }
        }
        throw new NoSuchAlgorithmException("Cannot find any provider supporting " + string, exception);
    }

    public static final Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Missing provider");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException("No such provider: " + string2);
        }
        return Cipher.getInstance(string, provider);
    }

    private String getProviderName() {
        return this.provider == null ? "(no provider)" : this.provider.getName();
    }

    public static final Cipher getInstance(String string, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (provider == null) {
            throw new IllegalArgumentException("Missing provider");
        }
        Exception exception = null;
        List<Transform> list = Cipher.getTransforms(string);
        boolean bl = false;
        String string2 = null;
        for (Transform transform : list) {
            Object object;
            Provider.Service service = provider.getService("Cipher", transform.transform);
            if (service == null) continue;
            if (!bl) {
                object = JceSecurity.getVerificationResult(provider);
                if (object != null) {
                    String string3 = "JCE cannot authenticate the provider " + provider.getName();
                    throw new SecurityException(string3, (Throwable)object);
                }
                bl = true;
            }
            if (transform.supportsMode(service) == 0) continue;
            if (transform.supportsPadding(service) == 0) {
                string2 = transform.pad;
                continue;
            }
            try {
                object = (CipherSpi)service.newInstance(null);
                transform.setModePadding((CipherSpi)object);
                Cipher cipher = new Cipher((CipherSpi)object, string);
                cipher.provider = service.getProvider();
                cipher.initCryptoPermission();
                return cipher;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        if (exception instanceof NoSuchPaddingException) {
            throw (NoSuchPaddingException)exception;
        }
        if (string2 != null) {
            throw new NoSuchPaddingException("Padding not supported: " + string2);
        }
        throw new NoSuchAlgorithmException("No such algorithm: " + string, exception);
    }

    private void initCryptoPermission() throws NoSuchAlgorithmException {
        if (!JceSecurity.isRestricted()) {
            this.cryptoPerm = CryptoAllPermission.INSTANCE;
            this.exmech = null;
            return;
        }
        this.cryptoPerm = Cipher.getConfiguredPermission(this.transformation);
        String string = this.cryptoPerm.getExemptionMechanism();
        if (string != null) {
            this.exmech = ExemptionMechanism.getInstance(string);
        }
    }

    void chooseFirstProvider() {
        if (this.spi != null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            int n;
            if (this.spi != null) {
                return;
            }
            if (debug != null && (n = --warnCount) >= 0) {
                debug.println("Cipher.init() not first method called, disabling delayed provider selection");
                if (n == 0) {
                    debug.println("Further warnings of this type will be suppressed");
                }
                new Exception("Call trace").printStackTrace();
            }
            Exception exception = null;
            while (this.firstService != null || this.serviceIterator.hasNext()) {
                Transform transform;
                CipherSpi cipherSpi;
                if (this.firstService != null) {
                    object2 = this.firstService;
                    cipherSpi = this.firstSpi;
                    this.firstService = null;
                    this.firstSpi = null;
                } else {
                    object2 = this.serviceIterator.next();
                    cipherSpi = null;
                }
                if (!JceSecurity.canUseProvider(((Provider.Service)object2).getProvider()) || (transform = Cipher.getTransform((Provider.Service)object2, this.transforms)) == null || transform.supportsModePadding((Provider.Service)object2) == 0) continue;
                try {
                    if (cipherSpi == null) {
                        Object object3 = ((Provider.Service)object2).newInstance(null);
                        if (!(object3 instanceof CipherSpi)) continue;
                        cipherSpi = (CipherSpi)object3;
                    }
                    transform.setModePadding(cipherSpi);
                    this.initCryptoPermission();
                    this.spi = cipherSpi;
                    this.provider = ((Provider.Service)object2).getProvider();
                    this.firstService = null;
                    this.serviceIterator = null;
                    this.transforms = null;
                    return;
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            }
            object2 = new ProviderException("Could not construct CipherSpi instance");
            if (exception != null) {
                ((Throwable)object2).initCause(exception);
            }
            throw object2;
        }
    }

    private void implInit(CipherSpi cipherSpi, int n, int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        switch (n) {
            case 1: {
                this.checkCryptoPerm(cipherSpi, key);
                cipherSpi.engineInit(n2, key, secureRandom);
                break;
            }
            case 2: {
                this.checkCryptoPerm(cipherSpi, key, algorithmParameterSpec);
                cipherSpi.engineInit(n2, key, algorithmParameterSpec, secureRandom);
                break;
            }
            case 3: {
                this.checkCryptoPerm(cipherSpi, key, algorithmParameters);
                cipherSpi.engineInit(n2, key, algorithmParameters, secureRandom);
                break;
            }
            case 4: {
                this.checkCryptoPerm(cipherSpi, key);
                cipherSpi.engineInit(n2, key, secureRandom);
                break;
            }
            default: {
                throw new AssertionError((Object)("Internal Cipher error: " + n));
            }
        }
    }

    private void chooseProvider(int n, int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            if (this.spi != null) {
                this.implInit(this.spi, n, n2, key, algorithmParameterSpec, algorithmParameters, secureRandom);
                return;
            }
            Exception exception = null;
            while (this.firstService != null || this.serviceIterator.hasNext()) {
                Transform transform;
                CipherSpi cipherSpi;
                if (this.firstService != null) {
                    object2 = this.firstService;
                    cipherSpi = this.firstSpi;
                    this.firstService = null;
                    this.firstSpi = null;
                } else {
                    object2 = this.serviceIterator.next();
                    cipherSpi = null;
                }
                if (!((Provider.Service)object2).supportsParameter(key) || !JceSecurity.canUseProvider(((Provider.Service)object2).getProvider()) || (transform = Cipher.getTransform((Provider.Service)object2, this.transforms)) == null || transform.supportsModePadding((Provider.Service)object2) == 0) continue;
                try {
                    if (cipherSpi == null) {
                        cipherSpi = (CipherSpi)((Provider.Service)object2).newInstance(null);
                    }
                    transform.setModePadding(cipherSpi);
                    this.initCryptoPermission();
                    this.implInit(cipherSpi, n, n2, key, algorithmParameterSpec, algorithmParameters, secureRandom);
                    this.provider = ((Provider.Service)object2).getProvider();
                    this.spi = cipherSpi;
                    this.firstService = null;
                    this.serviceIterator = null;
                    this.transforms = null;
                    return;
                }
                catch (Exception exception2) {
                    if (exception != null) continue;
                    exception = exception2;
                }
            }
            if (exception instanceof InvalidKeyException) {
                throw (InvalidKeyException)exception;
            }
            if (exception instanceof InvalidAlgorithmParameterException) {
                throw (InvalidAlgorithmParameterException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            object2 = key != null ? key.getClass().getName() : "(null)";
            throw new InvalidKeyException("No installed provider supports this key: " + (String)object2, exception);
        }
    }

    public final Provider getProvider() {
        this.chooseFirstProvider();
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.transformation;
    }

    public final int getBlockSize() {
        this.chooseFirstProvider();
        return this.spi.engineGetBlockSize();
    }

    public final int getOutputSize(int n) {
        if (!this.initialized && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Input size must be equal to or greater than zero");
        }
        this.chooseFirstProvider();
        return this.spi.engineGetOutputSize(n);
    }

    public final byte[] getIV() {
        this.chooseFirstProvider();
        return this.spi.engineGetIV();
    }

    public final AlgorithmParameters getParameters() {
        this.chooseFirstProvider();
        return this.spi.engineGetParameters();
    }

    public final ExemptionMechanism getExemptionMechanism() {
        this.chooseFirstProvider();
        return this.exmech;
    }

    private void checkCryptoPerm(CipherSpi cipherSpi, Key key) throws InvalidKeyException {
        AlgorithmParameterSpec algorithmParameterSpec;
        if (this.cryptoPerm == CryptoAllPermission.INSTANCE) {
            return;
        }
        try {
            algorithmParameterSpec = this.getAlgorithmParameterSpec(cipherSpi.engineGetParameters());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException("Unsupported default algorithm parameters");
        }
        if (!this.passCryptoPermCheck(cipherSpi, key, algorithmParameterSpec)) {
            throw new InvalidKeyException("Illegal key size or default parameters");
        }
    }

    private void checkCryptoPerm(CipherSpi cipherSpi, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.cryptoPerm == CryptoAllPermission.INSTANCE) {
            return;
        }
        if (!this.passCryptoPermCheck(cipherSpi, key, null)) {
            throw new InvalidKeyException("Illegal key size");
        }
        if (algorithmParameterSpec != null && !this.passCryptoPermCheck(cipherSpi, key, algorithmParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Illegal parameters");
        }
    }

    private void checkCryptoPerm(CipherSpi cipherSpi, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec;
        if (this.cryptoPerm == CryptoAllPermission.INSTANCE) {
            return;
        }
        try {
            algorithmParameterSpec = this.getAlgorithmParameterSpec(algorithmParameters);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException("Failed to retrieve algorithm parameter specification");
        }
        this.checkCryptoPerm(cipherSpi, key, algorithmParameterSpec);
    }

    private boolean passCryptoPermCheck(CipherSpi cipherSpi, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        String string = this.cryptoPerm.getExemptionMechanism();
        int n = cipherSpi.engineGetKeySize(key);
        int n2 = this.transformation.indexOf(47);
        String string2 = n2 != -1 ? this.transformation.substring(0, n2) : this.transformation;
        CryptoPermission cryptoPermission = new CryptoPermission(string2, n, algorithmParameterSpec, string);
        if (!this.cryptoPerm.implies(cryptoPermission)) {
            if (debug != null) {
                debug.println("Crypto Permission check failed");
                debug.println("granted: " + this.cryptoPerm);
                debug.println("requesting: " + cryptoPermission);
            }
            return false;
        }
        if (this.exmech == null) {
            return true;
        }
        try {
            if (!this.exmech.isCryptoAllowed(key)) {
                if (debug != null) {
                    debug.println(this.exmech.getName() + " isn't enforced");
                }
                return false;
            }
        }
        catch (ExemptionMechanismException exemptionMechanismException) {
            if (debug != null) {
                debug.println("Cannot determine whether " + this.exmech.getName() + " has been enforced");
                exemptionMechanismException.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private static void checkOpmode(int n) {
        if (n < 1 || n > 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
    }

    private static String getOpmodeString(int n) {
        switch (n) {
            case 1: {
                return "encryption";
            }
            case 2: {
                return "decryption";
            }
            case 3: {
                return "key wrapping";
            }
            case 4: {
                return "key unwrapping";
            }
        }
        return "";
    }

    public final void init(int n, Key key) throws InvalidKeyException {
        this.init(n, key, JCAUtil.getDefSecureRandom());
    }

    public final void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.initialized = false;
        Cipher.checkOpmode(n);
        if (this.spi != null) {
            this.checkCryptoPerm(this.spi, key);
            this.spi.engineInit(n, key, secureRandom);
        } else {
            try {
                this.chooseProvider(1, n, key, null, null, secureRandom);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidKeyException(invalidAlgorithmParameterException);
            }
        }
        this.initialized = true;
        this.opmode = n;
        if (!skipDebug && pdebug != null) {
            pdebug.println("Cipher." + this.transformation + " " + Cipher.getOpmodeString(n) + " algorithm from: " + this.getProviderName());
        }
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(n, key, algorithmParameterSpec, JCAUtil.getDefSecureRandom());
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initialized = false;
        Cipher.checkOpmode(n);
        if (this.spi != null) {
            this.checkCryptoPerm(this.spi, key, algorithmParameterSpec);
            this.spi.engineInit(n, key, algorithmParameterSpec, secureRandom);
        } else {
            this.chooseProvider(2, n, key, algorithmParameterSpec, null, secureRandom);
        }
        this.initialized = true;
        this.opmode = n;
        if (!skipDebug && pdebug != null) {
            pdebug.println("Cipher." + this.transformation + " " + Cipher.getOpmodeString(n) + " algorithm from: " + this.getProviderName());
        }
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(n, key, algorithmParameters, JCAUtil.getDefSecureRandom());
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initialized = false;
        Cipher.checkOpmode(n);
        if (this.spi != null) {
            this.checkCryptoPerm(this.spi, key, algorithmParameters);
            this.spi.engineInit(n, key, algorithmParameters, secureRandom);
        } else {
            this.chooseProvider(3, n, key, null, algorithmParameters, secureRandom);
        }
        this.initialized = true;
        this.opmode = n;
        if (!skipDebug && pdebug != null) {
            pdebug.println("Cipher." + this.transformation + " " + Cipher.getOpmodeString(n) + " algorithm from: " + this.getProviderName());
        }
    }

    public final void init(int n, Certificate certificate) throws InvalidKeyException {
        this.init(n, certificate, JCAUtil.getDefSecureRandom());
    }

    public final void init(int n, Certificate certificate, SecureRandom secureRandom) throws InvalidKeyException {
        boolean[] blArray;
        Serializable serializable;
        Set<String> set;
        this.initialized = false;
        Cipher.checkOpmode(n);
        if (certificate instanceof X509Certificate && (set = (serializable = (X509Certificate)certificate).getCriticalExtensionOIDs()) != null && !set.isEmpty() && set.contains(KnownOIDs.KeyUsage.value()) && (blArray = ((X509Certificate)serializable).getKeyUsage()) != null && (n == 1 && blArray.length > 3 && !blArray[3] || n == 3 && blArray.length > 2 && !blArray[2])) {
            throw new InvalidKeyException("Wrong key usage");
        }
        Serializable serializable2 = serializable = certificate == null ? null : certificate.getPublicKey();
        if (this.spi != null) {
            this.checkCryptoPerm(this.spi, (Key)serializable);
            this.spi.engineInit(n, (Key)serializable, secureRandom);
        } else {
            try {
                this.chooseProvider(4, n, (Key)serializable, null, null, secureRandom);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidKeyException(invalidAlgorithmParameterException);
            }
        }
        this.initialized = true;
        this.opmode = n;
        if (!skipDebug && pdebug != null) {
            pdebug.println("Cipher." + this.transformation + " " + Cipher.getOpmodeString(n) + " algorithm from: " + this.getProviderName());
        }
    }

    private void checkCipherState() {
        if (!(this instanceof NullCipher)) {
            if (!this.initialized) {
                throw new IllegalStateException("Cipher not initialized");
            }
            if (this.opmode != 1 && this.opmode != 2) {
                throw new IllegalStateException("Cipher not initialized for encryption/decryption");
            }
        }
    }

    public final byte[] update(byte[] byArray) {
        this.checkCipherState();
        if (byArray == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        this.chooseFirstProvider();
        if (byArray.length == 0) {
            return null;
        }
        return this.spi.engineUpdate(byArray, 0, byArray.length);
    }

    public final byte[] update(byte[] byArray, int n, int n2) {
        this.checkCipherState();
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.chooseFirstProvider();
        if (n2 == 0) {
            return null;
        }
        return this.spi.engineUpdate(byArray, n, n2);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2) throws ShortBufferException {
        this.checkCipherState();
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.chooseFirstProvider();
        if (n2 == 0) {
            return 0;
        }
        return this.spi.engineUpdate(byArray, n, n2, byArray2, 0);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        this.checkCipherState();
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.chooseFirstProvider();
        if (n2 == 0) {
            return 0;
        }
        return this.spi.engineUpdate(byArray, n, n2, byArray2, n3);
    }

    public final int update(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        this.checkCipherState();
        if (byteBuffer == null || byteBuffer2 == null) {
            throw new IllegalArgumentException("Buffers must not be null");
        }
        if (byteBuffer == byteBuffer2) {
            throw new IllegalArgumentException("Input and output buffers must not be the same object, consider using buffer.duplicate()");
        }
        if (byteBuffer2.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.chooseFirstProvider();
        return this.spi.engineUpdate(byteBuffer, byteBuffer2);
    }

    public final byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        this.checkCipherState();
        this.chooseFirstProvider();
        return this.spi.engineDoFinal(null, 0, 0);
    }

    public final int doFinal(byte[] byArray, int n) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        this.checkCipherState();
        if (byArray == null || n < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.chooseFirstProvider();
        return this.spi.engineDoFinal(null, 0, 0, byArray, n);
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        this.checkCipherState();
        if (byArray == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        this.chooseFirstProvider();
        return this.spi.engineDoFinal(byArray, 0, byArray.length);
    }

    public final byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        this.checkCipherState();
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.chooseFirstProvider();
        return this.spi.engineDoFinal(byArray, n, n2);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.checkCipherState();
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.chooseFirstProvider();
        return this.spi.engineDoFinal(byArray, n, n2, byArray2, 0);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.checkCipherState();
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.chooseFirstProvider();
        return this.spi.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    public final int doFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.checkCipherState();
        if (byteBuffer == null || byteBuffer2 == null) {
            throw new IllegalArgumentException("Buffers must not be null");
        }
        if (byteBuffer == byteBuffer2) {
            throw new IllegalArgumentException("Input and output buffers must not be the same object, consider using buffer.duplicate()");
        }
        if (byteBuffer2.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.chooseFirstProvider();
        return this.spi.engineDoFinal(byteBuffer, byteBuffer2);
    }

    public final byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (!(this instanceof NullCipher)) {
            if (!this.initialized) {
                throw new IllegalStateException("Cipher not initialized");
            }
            if (this.opmode != 3) {
                throw new IllegalStateException("Cipher not initialized for wrapping keys");
            }
        }
        this.chooseFirstProvider();
        return this.spi.engineWrap(key);
    }

    public final Key unwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (!(this instanceof NullCipher)) {
            if (!this.initialized) {
                throw new IllegalStateException("Cipher not initialized");
            }
            if (this.opmode != 4) {
                throw new IllegalStateException("Cipher not initialized for unwrapping keys");
            }
        }
        if (n != 3 && n != 2 && n != 1) {
            throw new InvalidParameterException("Invalid key type");
        }
        this.chooseFirstProvider();
        return this.spi.engineUnwrap(byArray, string, n);
    }

    private AlgorithmParameterSpec getAlgorithmParameterSpec(AlgorithmParameters algorithmParameters) throws InvalidParameterSpecException {
        if (algorithmParameters == null) {
            return null;
        }
        String string = algorithmParameters.getAlgorithm().toUpperCase(Locale.ENGLISH);
        if (string.equalsIgnoreCase("RC2")) {
            return algorithmParameters.getParameterSpec(RC2ParameterSpec.class);
        }
        if (string.equalsIgnoreCase("RC5")) {
            return algorithmParameters.getParameterSpec(RC5ParameterSpec.class);
        }
        if (string.startsWith("PBE")) {
            return algorithmParameters.getParameterSpec(PBEParameterSpec.class);
        }
        if (string.startsWith("DES")) {
            return algorithmParameters.getParameterSpec(IvParameterSpec.class);
        }
        return null;
    }

    private static CryptoPermission getConfiguredPermission(String string) throws NullPointerException, NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException();
        }
        String[] stringArray = Cipher.tokenizeTransformation(string);
        return JceSecurityManager.INSTANCE.getCryptoPermission(stringArray[0]);
    }

    public static final int getMaxAllowedKeyLength(String string) throws NoSuchAlgorithmException {
        CryptoPermission cryptoPermission = Cipher.getConfiguredPermission(string);
        return cryptoPermission.getMaxKeySize();
    }

    public static final AlgorithmParameterSpec getMaxAllowedParameterSpec(String string) throws NoSuchAlgorithmException {
        CryptoPermission cryptoPermission = Cipher.getConfiguredPermission(string);
        return cryptoPermission.getAlgorithmParameterSpec();
    }

    public final void updateAAD(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("src buffer is null");
        }
        this.updateAAD(byArray, 0, byArray.length);
    }

    public final void updateAAD(byte[] byArray, int n, int n2) {
        this.checkCipherState();
        if (byArray == null || n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.chooseFirstProvider();
        if (n2 == 0) {
            return;
        }
        this.spi.engineUpdateAAD(byArray, n, n2);
    }

    public final void updateAAD(ByteBuffer byteBuffer) {
        this.checkCipherState();
        if (byteBuffer == null) {
            throw new IllegalArgumentException("src ByteBuffer is null");
        }
        this.chooseFirstProvider();
        if (byteBuffer.remaining() == 0) {
            return;
        }
        this.spi.engineUpdateAAD(byteBuffer);
    }

    private static class Transform {
        final String transform;
        final String suffix;
        final String mode;
        final String pad;
        private static final ConcurrentMap<String, Pattern> patternCache = new ConcurrentHashMap<String, Pattern>();

        Transform(String string, String string2, String string3, String string4) {
            this.transform = string + string2;
            this.suffix = string2.toUpperCase(Locale.ENGLISH);
            this.mode = string3;
            this.pad = string4;
        }

        void setModePadding(CipherSpi cipherSpi) throws NoSuchAlgorithmException, NoSuchPaddingException {
            if (this.mode != null) {
                cipherSpi.engineSetMode(this.mode);
            }
            if (this.pad != null) {
                cipherSpi.engineSetPadding(this.pad);
            }
        }

        int supportsModePadding(Provider.Service service) {
            int n = this.supportsMode(service);
            if (n == 0) {
                return n;
            }
            int n2 = this.supportsPadding(service);
            return Math.min(n, n2);
        }

        int supportsMode(Provider.Service service) {
            return Transform.supports(service, Cipher.ATTR_MODE, this.mode);
        }

        int supportsPadding(Provider.Service service) {
            return Transform.supports(service, Cipher.ATTR_PAD, this.pad);
        }

        private static int supports(Provider.Service service, String string, String string2) {
            if (string2 == null) {
                return 2;
            }
            String string3 = service.getAttribute(string);
            if (string3 == null) {
                return 1;
            }
            return Transform.matches(string3, string2) ? 2 : 0;
        }

        private static boolean matches(String string, String string2) {
            Pattern pattern = (Pattern)patternCache.get(string);
            if (pattern == null) {
                pattern = Pattern.compile(string);
                patternCache.putIfAbsent(string, pattern);
            }
            return pattern.matcher(string2.toUpperCase(Locale.ENGLISH)).matches();
        }
    }
}

