/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.GotoInstruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.VariableLengthInstruction;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import java.io.DataOutputStream;
import java.io.IOException;

public class GOTO
extends GotoInstruction
implements VariableLengthInstruction {
    GOTO() {
    }

    public GOTO(InstructionHandle target) {
        super((short)167, target);
    }

    @Override
    public void accept(Visitor v) {
        v.visitVariableLengthInstruction(this);
        v.visitUnconditionalBranch(this);
        v.visitBranchInstruction(this);
        v.visitGotoInstruction(this);
        v.visitGOTO(this);
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        super.setIndex(this.getTargetOffset());
        short opcode = this.getOpcode();
        if (opcode == 167) {
            super.dump(out);
        } else {
            super.setIndex(this.getTargetOffset());
            out.writeByte(opcode);
            out.writeInt(super.getIndex());
        }
    }

    @Override
    protected int updatePosition(int offset, int maxOffset) {
        int i = this.getTargetOffset();
        this.setPosition(this.getPosition() + offset);
        if (Math.abs(i) >= Short.MAX_VALUE - maxOffset) {
            super.setOpcode((short)200);
            short oldLength = (short)super.getLength();
            super.setLength(5);
            return super.getLength() - oldLength;
        }
        return 0;
    }
}

