/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509IssuerSerial;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509IssuerSerialResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(X509IssuerSerialResolver.class);

    @Override
    protected boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        if (XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            try {
                X509Data x509Data = new X509Data(element, string);
                return x509Data.containsIssuerSerial();
            }
            catch (XMLSecurityException xMLSecurityException) {
                return false;
            }
        }
        return false;
    }

    @Override
    protected PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineResolveX509Certificate(element, string, storageResolver, bl);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    @Override
    protected X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        X509Data x509Data = null;
        try {
            x509Data = new X509Data(element, string);
        }
        catch (XMLSecurityException xMLSecurityException) {
            return null;
        }
        if (!x509Data.containsIssuerSerial()) {
            return null;
        }
        try {
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509IssuerSerial"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                LOG.debug("", keyResolverException);
                throw keyResolverException;
            }
            int n = x509Data.lengthIssuerSerial();
            Iterator<Certificate> iterator = storageResolver.getIterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                XMLX509IssuerSerial xMLX509IssuerSerial = new XMLX509IssuerSerial(element.getOwnerDocument(), x509Certificate);
                LOG.debug("Found Certificate Issuer: {}", xMLX509IssuerSerial.getIssuerName());
                LOG.debug("Found Certificate Serial: {}", xMLX509IssuerSerial.getSerialNumber().toString());
                for (int i = 0; i < n; ++i) {
                    XMLX509IssuerSerial xMLX509IssuerSerial2 = x509Data.itemIssuerSerial(i);
                    LOG.debug("Found Element Issuer:     {}", xMLX509IssuerSerial2.getIssuerName());
                    LOG.debug("Found Element Serial:     {}", xMLX509IssuerSerial2.getSerialNumber().toString());
                    if (xMLX509IssuerSerial.equals(xMLX509IssuerSerial2)) {
                        LOG.debug("match !!! ");
                        return x509Certificate;
                    }
                    LOG.debug("no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.debug("XMLSecurityException", xMLSecurityException);
            throw new KeyResolverException(xMLSecurityException);
        }
    }

    @Override
    protected SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver, boolean bl) {
        return null;
    }

    @Override
    protected PrivateKey engineResolvePrivateKey(Element element, String string, StorageResolver storageResolver, boolean bl) {
        return null;
    }
}

