/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import sun.misc.Contended;
import sun.misc.Unsafe;

public class ConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 16;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final float LOAD_FACTOR = 0.75f;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    private static final int MIN_TRANSFER_STRIDE = 16;
    private static int RESIZE_STAMP_BITS = 16;
    private static final int MAX_RESIZERS = (1 << 32 - RESIZE_STAMP_BITS) - 1;
    private static final int RESIZE_STAMP_SHIFT = 32 - RESIZE_STAMP_BITS;
    static final int MOVED = -1;
    static final int TREEBIN = -2;
    static final int RESERVED = -3;
    static final int HASH_BITS = Integer.MAX_VALUE;
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("segments", Segment[].class), new ObjectStreamField("segmentMask", Integer.TYPE), new ObjectStreamField("segmentShift", Integer.TYPE)};
    volatile transient Node<K, V>[] table;
    private volatile transient Node<K, V>[] nextTable;
    private volatile transient long baseCount;
    private volatile transient int sizeCtl;
    private volatile transient int transferIndex;
    private volatile transient int cellsBusy;
    private volatile transient CounterCell[] counterCells;
    private transient KeySetView<K, V> keySet;
    private transient ValuesView<K, V> values;
    private transient EntrySetView<K, V> entrySet;
    private static final Unsafe U;
    private static final long SIZECTL;
    private static final long TRANSFERINDEX;
    private static final long BASECOUNT;
    private static final long CELLSBUSY;
    private static final long CELLVALUE;
    private static final long ABASE;
    private static final int ASHIFT;

    static final int spread(int n) {
        return (n ^ n >>> 16) & Integer.MAX_VALUE;
    }

    private static final int tableSizeFor(int n) {
        int n2 = n - 1;
        n2 |= n2 >>> 1;
        n2 |= n2 >>> 2;
        n2 |= n2 >>> 4;
        n2 |= n2 >>> 8;
        return (n2 |= n2 >>> 16) < 0 ? 1 : (n2 >= 0x40000000 ? 0x40000000 : n2 + 1);
    }

    static Class<?> comparableClassFor(Object object) {
        if (object instanceof Comparable) {
            Class<?> clazz = object.getClass();
            if (clazz == String.class) {
                return clazz;
            }
            Type[] typeArray = clazz.getGenericInterfaces();
            if (typeArray != null) {
                for (int i = 0; i < typeArray.length; ++i) {
                    Type[] typeArray2;
                    ParameterizedType parameterizedType;
                    Type type = typeArray[i];
                    if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != Comparable.class || (typeArray2 = parameterizedType.getActualTypeArguments()) == null || typeArray2.length != 1 || typeArray2[0] != clazz) continue;
                    return clazz;
                }
            }
        }
        return null;
    }

    static int compareComparables(Class<?> clazz, Object object, Object object2) {
        return object2 == null || object2.getClass() != clazz ? 0 : ((Comparable)object).compareTo(object2);
    }

    static final <K, V> Node<K, V> tabAt(Node<K, V>[] nodeArray, int n) {
        return (Node)U.getObjectVolatile(nodeArray, ((long)n << ASHIFT) + ABASE);
    }

    static final <K, V> boolean casTabAt(Node<K, V>[] nodeArray, int n, Node<K, V> node, Node<K, V> node2) {
        return U.compareAndSwapObject(nodeArray, ((long)n << ASHIFT) + ABASE, node, node2);
    }

    static final <K, V> void setTabAt(Node<K, V>[] nodeArray, int n, Node<K, V> node) {
        U.putObjectVolatile(nodeArray, ((long)n << ASHIFT) + ABASE, node);
    }

    public ConcurrentHashMap() {
    }

    public ConcurrentHashMap(int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.sizeCtl = n2 = n >= 0x20000000 ? 0x40000000 : ConcurrentHashMap.tableSizeFor(n + (n >>> 1) + 1);
    }

    public ConcurrentHashMap(Map<? extends K, ? extends V> map) {
        this.sizeCtl = 16;
        this.putAll(map);
    }

    public ConcurrentHashMap(int n, float f) {
        this(n, f, 1);
    }

    public ConcurrentHashMap(int n, float f, int n2) {
        long l;
        int n3;
        if (!(f > 0.0f) || n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n < n2) {
            n = n2;
        }
        this.sizeCtl = n3 = (l = (long)(1.0 + (double)((float)n / f))) >= 0x40000000L ? 0x40000000 : ConcurrentHashMap.tableSizeFor((int)l);
    }

    @Override
    public int size() {
        long l = this.sumCount();
        return l < 0L ? 0 : (l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l);
    }

    @Override
    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    @Override
    public V get(Object object) {
        Node<K, V> node;
        int n;
        int n2 = ConcurrentHashMap.spread(object.hashCode());
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null && (n = nodeArray.length) > 0 && (node = ConcurrentHashMap.tabAt(nodeArray, n - 1 & n2)) != null) {
            Object k;
            int n3 = node.hash;
            if (n3 == n2) {
                k = node.key;
                if (k == object || k != null && object.equals(k)) {
                    return node.val;
                }
            } else if (n3 < 0) {
                Node<K, V> node2 = node.find(n2, object);
                return node2 != null ? (V)node2.val : null;
            }
            while ((node = node.next) != null) {
                if (node.hash != n2 || (k = node.key) != object && (k == null || !object.equals(k))) continue;
                return node.val;
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null) {
            Node<K, V> node;
            Traverser<K, V> traverser = new Traverser<K, V>(nodeArray, nodeArray.length, 0, nodeArray.length);
            while ((node = traverser.advance()) != null) {
                Object v = node.val;
                if (v != object && (v == null || !object.equals(v))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V put(K k, V v) {
        return this.putVal(k, v, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V putVal(K k, V v, boolean bl) {
        int n;
        block19: {
            V v2;
            int n2;
            if (k == null || v == null) {
                throw new NullPointerException();
            }
            int n3 = ConcurrentHashMap.spread(k.hashCode());
            n = 0;
            Node<K, V>[] nodeArray = this.table;
            while (true) {
                int n4;
                if (nodeArray == null || (n4 = nodeArray.length) == 0) {
                    nodeArray = this.initTable();
                    continue;
                }
                n2 = n4 - 1 & n3;
                Node<K, V> node = ConcurrentHashMap.tabAt(nodeArray, n2);
                if (node == null) {
                    if (!ConcurrentHashMap.casTabAt(nodeArray, n2, null, new Node<K, V>(n3, k, v, null))) continue;
                    break block19;
                }
                int n5 = node.hash;
                if (n5 == -1) {
                    nodeArray = this.helpTransfer(nodeArray, node);
                    continue;
                }
                v2 = null;
                Node<K, V> node2 = node;
                synchronized (node2) {
                    block20: {
                        if (ConcurrentHashMap.tabAt(nodeArray, n2) == node) {
                            Node<K, V> node3;
                            if (n5 >= 0) {
                                n = 1;
                                node3 = node;
                                while (true) {
                                    Object k2;
                                    if (node3.hash == n3 && ((k2 = node3.key) == k || k2 != null && k.equals(k2))) {
                                        v2 = node3.val;
                                        if (!bl) {
                                            node3.val = v;
                                        }
                                        break block20;
                                    }
                                    Node<K, V> node4 = node3;
                                    node3 = node3.next;
                                    if (node3 == null) {
                                        node4.next = new Node<K, V>(n3, k, v, null);
                                        break block20;
                                    }
                                    ++n;
                                }
                            }
                            if (node instanceof TreeBin) {
                                n = 2;
                                node3 = ((TreeBin)node).putTreeVal(n3, k, v);
                                if (node3 != null) {
                                    v2 = node3.val;
                                    if (!bl) {
                                        node3.val = v;
                                    }
                                }
                            }
                        }
                    }
                }
                if (n != 0) break;
            }
            if (n >= 8) {
                this.treeifyBin(nodeArray, n2);
            }
            if (v2 != null) {
                return v2;
            }
        }
        this.addCount(1L, n);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.tryPresize(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putVal(entry.getKey(), entry.getValue(), false);
        }
    }

    @Override
    public V remove(Object object) {
        return this.replaceNode(object, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V replaceNode(Object object, V v, Object object2) {
        int n;
        TreeBin treeBin;
        int n2;
        int n3 = ConcurrentHashMap.spread(object.hashCode());
        Node<K, V>[] nodeArray = this.table;
        while (nodeArray != null && (n2 = nodeArray.length) != 0 && (treeBin = ConcurrentHashMap.tabAt(nodeArray, n = n2 - 1 & n3)) != null) {
            int n4 = treeBin.hash;
            if (n4 == -1) {
                nodeArray = this.helpTransfer(nodeArray, treeBin);
                continue;
            }
            V v2 = null;
            boolean bl = false;
            TreeBin treeBin2 = treeBin;
            synchronized (treeBin2) {
                if (ConcurrentHashMap.tabAt(nodeArray, n) == treeBin) {
                    Object object3;
                    Object object4;
                    Node node;
                    Node node2;
                    if (n4 >= 0) {
                        bl = true;
                        node2 = treeBin;
                        node = null;
                        do {
                            if (node2.hash == n3 && ((object4 = node2.key) == object || object4 != null && object.equals(object4))) {
                                object3 = node2.val;
                                if (object2 == null || object2 == object3 || object3 != null && object2.equals(object3)) {
                                    v2 = object3;
                                    if (v != null) {
                                        node2.val = v;
                                    } else if (node != null) {
                                        node.next = node2.next;
                                    } else {
                                        ConcurrentHashMap.setTabAt(nodeArray, n, node2.next);
                                    }
                                }
                                break;
                            }
                            node = node2;
                        } while ((node2 = node2.next) != null);
                    } else if (treeBin instanceof TreeBin) {
                        bl = true;
                        node2 = treeBin;
                        node = ((TreeBin)node2).root;
                        if (node != null && (object4 = ((TreeNode)node).findTreeNode(n3, object, null)) != null) {
                            object3 = ((TreeNode)object4).val;
                            if (object2 == null || object2 == object3 || object3 != null && object2.equals(object3)) {
                                v2 = object3;
                                if (v != null) {
                                    ((TreeNode)object4).val = v;
                                } else if (((TreeBin)node2).removeTreeNode(object4)) {
                                    ConcurrentHashMap.setTabAt(nodeArray, n, ConcurrentHashMap.untreeify(((TreeBin)node2).first));
                                }
                            }
                        }
                    }
                }
            }
            if (!bl) continue;
            if (v2 == null) break;
            if (v == null) {
                this.addCount(-1L, -1);
            }
            return v2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        long l = 0L;
        int n = 0;
        Node<K, V>[] nodeArray = this.table;
        while (nodeArray != null && n < nodeArray.length) {
            Node<K, V> node = ConcurrentHashMap.tabAt(nodeArray, n);
            if (node == null) {
                ++n;
                continue;
            }
            int n2 = node.hash;
            if (n2 == -1) {
                nodeArray = this.helpTransfer(nodeArray, node);
                n = 0;
                continue;
            }
            Node<K, V> node2 = node;
            synchronized (node2) {
                if (ConcurrentHashMap.tabAt(nodeArray, n) == node) {
                    Node<K, V> node3;
                    Node<K, V> node4 = n2 >= 0 ? node : (node3 = node instanceof TreeBin ? ((TreeBin)node).first : null);
                    while (node3 != null) {
                        --l;
                        node3 = node3.next;
                    }
                    ConcurrentHashMap.setTabAt(nodeArray, n++, null);
                }
            }
        }
        if (l != 0L) {
            this.addCount(l, -1);
        }
    }

    public KeySetView<K, V> keySet() {
        KeySetView<K, V> keySetView = this.keySet;
        return keySetView != null ? keySetView : (this.keySet = new KeySetView(this, null));
    }

    @Override
    public Collection<V> values() {
        ValuesView<K, V> valuesView = this.values;
        return valuesView != null ? valuesView : (this.values = new ValuesView(this));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetView<K, V> entrySetView = this.entrySet;
        return entrySetView != null ? entrySetView : (this.entrySet = new EntrySetView(this));
    }

    @Override
    public int hashCode() {
        int n = 0;
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null) {
            Node<K, V> node;
            Traverser<K, V> traverser = new Traverser<K, V>(nodeArray, nodeArray.length, 0, nodeArray.length);
            while ((node = traverser.advance()) != null) {
                n += node.key.hashCode() ^ node.val.hashCode();
            }
        }
        return n;
    }

    @Override
    public String toString() {
        Node<K, V>[] nodeArray = this.table;
        int n = this.table == null ? 0 : nodeArray.length;
        Traverser<K, V> traverser = new Traverser<K, V>(nodeArray, n, 0, n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        Node<K, V> node = traverser.advance();
        if (node != null) {
            while (true) {
                Object k = node.key;
                Object v = node.val;
                stringBuilder.append((Object)(k == this ? "(this Map)" : k));
                stringBuilder.append('=');
                stringBuilder.append((Object)(v == this ? "(this Map)" : v));
                node = traverser.advance();
                if (node == null) break;
                stringBuilder.append(',').append(' ');
            }
        }
        return stringBuilder.append('}').toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object != this) {
            Object object2;
            Object object3;
            if (!(object instanceof Map)) {
                return false;
            }
            Map map = (Map)object;
            Node<K, V>[] nodeArray = this.table;
            int n = this.table == null ? 0 : nodeArray.length;
            Traverser<K, V> traverser = new Traverser<K, V>(nodeArray, n, 0, n);
            while ((object3 = traverser.advance()) != null) {
                Object object4 = ((Node)object3).val;
                object2 = map.get(((Node)object3).key);
                if (object2 != null && (object2 == object4 || object2.equals(object4))) continue;
                return false;
            }
            for (Map.Entry entry : map.entrySet()) {
                V v;
                Object v2;
                object2 = entry.getKey();
                if (object2 != null && (v2 = entry.getValue()) != null && (v = this.get(object2)) != null && (v2 == v || v2.equals(v))) continue;
                return false;
            }
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        int n2 = 0;
        for (n = 1; n < 16; n <<= 1) {
            ++n2;
        }
        int n3 = 32 - n2;
        int n4 = n - 1;
        Segment[] segmentArray = new Segment[16];
        for (int i = 0; i < segmentArray.length; ++i) {
            segmentArray[i] = new Segment(0.75f);
        }
        objectOutputStream.putFields().put("segments", segmentArray);
        objectOutputStream.putFields().put("segmentShift", n3);
        objectOutputStream.putFields().put("segmentMask", n4);
        objectOutputStream.writeFields();
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null) {
            Node<K, V> node;
            Traverser<K, V> traverser = new Traverser<K, V>(nodeArray, nodeArray.length, 0, nodeArray.length);
            while ((node = traverser.advance()) != null) {
                objectOutputStream.writeObject(node.key);
                objectOutputStream.writeObject(node.val);
            }
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
        segmentArray = null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Node[] nodeArray;
        this.sizeCtl = -1;
        objectInputStream.defaultReadObject();
        long l = 0L;
        Node<Object, Object> node = null;
        while (true) {
            Object object = objectInputStream.readObject();
            nodeArray = objectInputStream.readObject();
            if (object == null || nodeArray == null) break;
            node = new Node<Object, Object>(ConcurrentHashMap.spread(object.hashCode()), object, nodeArray, node);
            ++l;
        }
        if (l == 0L) {
            this.sizeCtl = 0;
        } else {
            int n;
            if (l >= 0x20000000L) {
                n = 0x40000000;
            } else {
                int n2 = (int)l;
                n = ConcurrentHashMap.tableSizeFor(n2 + (n2 >>> 1) + 1);
            }
            nodeArray = new Node[n];
            int n3 = n - 1;
            long l2 = 0L;
            while (node != null) {
                boolean bl;
                Node node2 = node.next;
                int n4 = node.hash;
                int n5 = n4 & n3;
                Node<K, V> node3 = ConcurrentHashMap.tabAt(nodeArray, n5);
                if (node3 == null) {
                    bl = true;
                } else {
                    Object k = node.key;
                    if (node3.hash < 0) {
                        TreeBin treeBin = (TreeBin)node3;
                        if (treeBin.putTreeVal(n4, k, node.val) == null) {
                            ++l2;
                        }
                        bl = false;
                    } else {
                        int n6 = 0;
                        bl = true;
                        Node<Object, Object> node4 = node3;
                        while (node4 != null) {
                            Object k2;
                            if (node4.hash == n4 && ((k2 = node4.key) == k || k2 != null && k.equals(k2))) {
                                bl = false;
                                break;
                            }
                            ++n6;
                            node4 = node4.next;
                        }
                        if (bl && n6 >= 8) {
                            bl = false;
                            ++l2;
                            node.next = node3;
                            TreeNode treeNode = null;
                            TreeNode treeNode2 = null;
                            node4 = node;
                            while (node4 != null) {
                                TreeNode treeNode3 = new TreeNode(node4.hash, node4.key, node4.val, null, null);
                                treeNode3.prev = treeNode2;
                                if (treeNode3.prev == null) {
                                    treeNode = treeNode3;
                                } else {
                                    treeNode2.next = treeNode3;
                                }
                                treeNode2 = treeNode3;
                                node4 = node4.next;
                            }
                            ConcurrentHashMap.setTabAt(nodeArray, n5, new TreeBin(treeNode));
                        }
                    }
                }
                if (bl) {
                    ++l2;
                    node.next = node3;
                    ConcurrentHashMap.setTabAt(nodeArray, n5, node);
                }
                node = node2;
            }
            this.table = nodeArray;
            this.sizeCtl = n - (n >>> 2);
            this.baseCount = l2;
        }
    }

    @Override
    public V putIfAbsent(K k, V v) {
        return this.putVal(k, v, true);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object2 != null && this.replaceNode(object, null, object2) != null;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        if (k == null || v == null || v2 == null) {
            throw new NullPointerException();
        }
        return this.replaceNode(k, v2, v) != null;
    }

    @Override
    public V replace(K k, V v) {
        if (k == null || v == null) {
            throw new NullPointerException();
        }
        return this.replaceNode(k, v, null);
    }

    @Override
    public V getOrDefault(Object object, V v) {
        V v2 = this.get(object);
        return v2 == null ? v : v2;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        if (biConsumer == null) {
            throw new NullPointerException();
        }
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null) {
            Node<K, V> node;
            Traverser<K, V> traverser = new Traverser<K, V>(nodeArray, nodeArray.length, 0, nodeArray.length);
            while ((node = traverser.advance()) != null) {
                biConsumer.accept(node.key, node.val);
            }
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        if (biFunction == null) {
            throw new NullPointerException();
        }
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null) {
            Node<K, V> node;
            Traverser<K, V> traverser = new Traverser<K, V>(nodeArray, nodeArray.length, 0, nodeArray.length);
            while ((node = traverser.advance()) != null) {
                V v;
                Object v2 = node.val;
                Object k = node.key;
                do {
                    if ((v = biFunction.apply(k, v2)) != null) continue;
                    throw new NullPointerException();
                } while (this.replaceNode(k, v, v2) == null && (v2 = this.get(k)) != null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        int n;
        Object object;
        block30: {
            boolean bl;
            int n2;
            if (k == null || function == null) {
                throw new NullPointerException();
            }
            int n3 = ConcurrentHashMap.spread(k.hashCode());
            object = null;
            n = 0;
            Node<K, V>[] nodeArray = this.table;
            while (true) {
                Node node;
                Node node2;
                int n4;
                if (nodeArray == null || (n4 = nodeArray.length) == 0) {
                    nodeArray = this.initTable();
                    continue;
                }
                n2 = n4 - 1 & n3;
                TreeBin treeBin = ConcurrentHashMap.tabAt(nodeArray, n2);
                if (treeBin == null) {
                    ReservationNode reservationNode;
                    node2 = reservationNode = new ReservationNode();
                    synchronized (node2) {
                        if (ConcurrentHashMap.casTabAt(nodeArray, n2, null, reservationNode)) {
                            n = 1;
                            node = null;
                            try {
                                V v = function.apply(k);
                                object = v;
                                if (v != null) {
                                    node = new Node<K, Object>(n3, k, object, null);
                                }
                            }
                            finally {
                                ConcurrentHashMap.setTabAt(nodeArray, n2, node);
                            }
                        }
                    }
                    if (n == 0) continue;
                    break block30;
                }
                int n5 = treeBin.hash;
                if (n5 == -1) {
                    nodeArray = this.helpTransfer(nodeArray, treeBin);
                    continue;
                }
                bl = false;
                node2 = treeBin;
                synchronized (node2) {
                    block31: {
                        if (ConcurrentHashMap.tabAt(nodeArray, n2) == treeBin) {
                            Object object2;
                            if (n5 >= 0) {
                                n = 1;
                                node = treeBin;
                                while (true) {
                                    if (node.hash == n3 && ((object2 = node.key) == k || object2 != null && k.equals(object2))) {
                                        object = node.val;
                                        break block31;
                                    }
                                    TreeBin treeBin2 = node;
                                    node = node.next;
                                    if (node == null) {
                                        V v = function.apply(k);
                                        object = v;
                                        if (v != null) {
                                            bl = true;
                                            treeBin2.next = new Node<K, Object>(n3, k, object, null);
                                        }
                                        break block31;
                                    }
                                    ++n;
                                }
                            }
                            if (treeBin instanceof TreeBin) {
                                TreeNode treeNode;
                                n = 2;
                                node = treeBin;
                                object2 = ((TreeBin)node).root;
                                if (object2 != null && (treeNode = ((TreeNode)object2).findTreeNode(n3, k, null)) != null) {
                                    object = treeNode.val;
                                } else {
                                    V v = function.apply(k);
                                    object = v;
                                    if (v != null) {
                                        bl = true;
                                        ((TreeBin)node).putTreeVal(n3, k, object);
                                    }
                                }
                            }
                        }
                    }
                }
                if (n != 0) break;
            }
            if (n >= 8) {
                this.treeifyBin(nodeArray, n2);
            }
            if (!bl) {
                return (V)object;
            }
        }
        if (object != null) {
            this.addCount(1L, n);
        }
        return (V)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        if (k == null || biFunction == null) {
            throw new NullPointerException();
        }
        int n = ConcurrentHashMap.spread(k.hashCode());
        V v = null;
        int n2 = 0;
        int n3 = 0;
        Node<K, V>[] nodeArray = this.table;
        while (true) {
            int n4;
            if (nodeArray == null || (n4 = nodeArray.length) == 0) {
                nodeArray = this.initTable();
                continue;
            }
            int n5 = n4 - 1 & n;
            TreeBin treeBin = ConcurrentHashMap.tabAt(nodeArray, n5);
            if (treeBin == null) break;
            int n6 = treeBin.hash;
            if (n6 == -1) {
                nodeArray = this.helpTransfer(nodeArray, treeBin);
                continue;
            }
            TreeBin treeBin2 = treeBin;
            synchronized (treeBin2) {
                if (ConcurrentHashMap.tabAt(nodeArray, n5) == treeBin) {
                    Object object;
                    Node node;
                    Node node2;
                    if (n6 >= 0) {
                        n3 = 1;
                        node2 = treeBin;
                        node = null;
                        while (true) {
                            if (node2.hash == n && ((object = node2.key) == k || object != null && k.equals(object))) {
                                v = biFunction.apply(k, node2.val);
                                if (v != null) {
                                    node2.val = v;
                                } else {
                                    n2 = -1;
                                    Node node3 = node2.next;
                                    if (node != null) {
                                        node.next = node3;
                                    } else {
                                        ConcurrentHashMap.setTabAt(nodeArray, n5, node3);
                                    }
                                }
                            } else {
                                node = node2;
                                node2 = node2.next;
                                if (node2 != null) {
                                    ++n3;
                                    continue;
                                }
                            }
                            break;
                        }
                    } else if (treeBin instanceof TreeBin) {
                        n3 = 2;
                        node2 = treeBin;
                        node = ((TreeBin)node2).root;
                        if (node != null && (object = ((TreeNode)node).findTreeNode(n, k, null)) != null) {
                            v = biFunction.apply(k, ((TreeNode)object).val);
                            if (v != null) {
                                ((TreeNode)object).val = v;
                            } else {
                                n2 = -1;
                                if (((TreeBin)node2).removeTreeNode(object)) {
                                    ConcurrentHashMap.setTabAt(nodeArray, n5, ConcurrentHashMap.untreeify(((TreeBin)node2).first));
                                }
                            }
                        }
                    }
                }
            }
            if (n3 != 0) break;
        }
        if (n2 != 0) {
            this.addCount(n2, n3);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        int n;
        int n2;
        Object v;
        block36: {
            int n3;
            if (k == null || biFunction == null) {
                throw new NullPointerException();
            }
            int n4 = ConcurrentHashMap.spread(k.hashCode());
            v = null;
            n2 = 0;
            n = 0;
            Node<K, V>[] nodeArray = this.table;
            while (true) {
                Node node;
                Node node2;
                Node node3;
                int n5;
                if (nodeArray == null || (n5 = nodeArray.length) == 0) {
                    nodeArray = this.initTable();
                    continue;
                }
                n3 = n5 - 1 & n4;
                Node<K, V> node4 = ConcurrentHashMap.tabAt(nodeArray, n3);
                if (node4 == null) {
                    node3 = new ReservationNode();
                    node2 = node3;
                    synchronized (node2) {
                        if (ConcurrentHashMap.casTabAt(nodeArray, n3, null, node3)) {
                            n = 1;
                            node = null;
                            try {
                                V v2 = biFunction.apply(k, null);
                                v = v2;
                                if (v2 != null) {
                                    n2 = 1;
                                    node = new Node<K, Object>(n4, k, v, null);
                                }
                            }
                            finally {
                                ConcurrentHashMap.setTabAt(nodeArray, n3, node);
                            }
                        }
                    }
                    if (n == 0) continue;
                    break block36;
                }
                int n6 = node4.hash;
                if (n6 == -1) {
                    nodeArray = this.helpTransfer(nodeArray, node4);
                    continue;
                }
                node3 = node4;
                synchronized (node3) {
                    block37: {
                        if (ConcurrentHashMap.tabAt(nodeArray, n3) == node4) {
                            Node node5;
                            Object object;
                            if (n6 >= 0) {
                                n = 1;
                                node2 = node4;
                                node = null;
                                while (true) {
                                    if (node2.hash == n4 && ((object = node2.key) == k || object != null && k.equals(object))) {
                                        v = biFunction.apply(k, node2.val);
                                        if (v != null) {
                                            node2.val = v;
                                        } else {
                                            n2 = -1;
                                            node5 = node2.next;
                                            if (node != null) {
                                                node.next = node5;
                                            } else {
                                                ConcurrentHashMap.setTabAt(nodeArray, n3, node5);
                                            }
                                        }
                                        break block37;
                                    }
                                    node = node2;
                                    node2 = node2.next;
                                    if (node2 == null) {
                                        v = biFunction.apply(k, null);
                                        if (v != null) {
                                            n2 = 1;
                                            node.next = new Node<K, Object>(n4, k, v, null);
                                        }
                                        break block37;
                                    }
                                    ++n;
                                }
                            }
                            if (node4 instanceof TreeBin) {
                                n = 1;
                                node2 = (TreeBin)node4;
                                node = ((TreeBin)node2).root;
                                object = node != null ? ((TreeNode)node).findTreeNode(n4, k, null) : null;
                                node5 = object == null ? null : ((TreeNode)object).val;
                                v = biFunction.apply(k, node5);
                                if (v != null) {
                                    if (object != null) {
                                        ((TreeNode)object).val = v;
                                    } else {
                                        n2 = 1;
                                        ((TreeBin)node2).putTreeVal(n4, k, v);
                                    }
                                } else if (object != null) {
                                    n2 = -1;
                                    if (((TreeBin)node2).removeTreeNode(object)) {
                                        ConcurrentHashMap.setTabAt(nodeArray, n3, ConcurrentHashMap.untreeify(((TreeBin)node2).first));
                                    }
                                }
                            }
                        }
                    }
                }
                if (n != 0) break;
            }
            if (n >= 8) {
                this.treeifyBin(nodeArray, n3);
            }
        }
        if (n2 != 0) {
            this.addCount(n2, n);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        int n;
        int n2;
        Object v2;
        block26: {
            int n3;
            if (k == null || v == null || biFunction == null) {
                throw new NullPointerException();
            }
            int n4 = ConcurrentHashMap.spread(k.hashCode());
            v2 = null;
            n2 = 0;
            n = 0;
            Node<K, V>[] nodeArray = this.table;
            while (true) {
                int n5;
                if (nodeArray == null || (n5 = nodeArray.length) == 0) {
                    nodeArray = this.initTable();
                    continue;
                }
                n3 = n5 - 1 & n4;
                TreeBin treeBin = ConcurrentHashMap.tabAt(nodeArray, n3);
                if (treeBin == null) {
                    if (!ConcurrentHashMap.casTabAt(nodeArray, n3, null, new Node<K, V>(n4, k, v, null))) continue;
                    n2 = 1;
                    v2 = v;
                    break block26;
                }
                int n6 = treeBin.hash;
                if (n6 == -1) {
                    nodeArray = this.helpTransfer(nodeArray, treeBin);
                    continue;
                }
                TreeBin treeBin2 = treeBin;
                synchronized (treeBin2) {
                    block27: {
                        if (ConcurrentHashMap.tabAt(nodeArray, n3) == treeBin) {
                            Object object;
                            Node node;
                            Node node2;
                            if (n6 >= 0) {
                                n = 1;
                                node2 = treeBin;
                                node = null;
                                while (true) {
                                    if (node2.hash == n4 && ((object = node2.key) == k || object != null && k.equals(object))) {
                                        v2 = biFunction.apply(node2.val, v);
                                        if (v2 != null) {
                                            node2.val = v2;
                                        } else {
                                            n2 = -1;
                                            Node node3 = node2.next;
                                            if (node != null) {
                                                node.next = node3;
                                            } else {
                                                ConcurrentHashMap.setTabAt(nodeArray, n3, node3);
                                            }
                                        }
                                        break block27;
                                    }
                                    node = node2;
                                    node2 = node2.next;
                                    if (node2 == null) {
                                        n2 = 1;
                                        v2 = v;
                                        node.next = new Node<K, Object>(n4, k, v2, null);
                                        break block27;
                                    }
                                    ++n;
                                }
                            }
                            if (treeBin instanceof TreeBin) {
                                n = 2;
                                node2 = treeBin;
                                node = ((TreeBin)node2).root;
                                object = node == null ? null : ((TreeNode)node).findTreeNode(n4, k, null);
                                v2 = object == null ? v : biFunction.apply(((TreeNode)object).val, v);
                                if (v2 != null) {
                                    if (object != null) {
                                        ((TreeNode)object).val = v2;
                                    } else {
                                        n2 = 1;
                                        ((TreeBin)node2).putTreeVal(n4, k, v2);
                                    }
                                } else if (object != null) {
                                    n2 = -1;
                                    if (((TreeBin)node2).removeTreeNode(object)) {
                                        ConcurrentHashMap.setTabAt(nodeArray, n3, ConcurrentHashMap.untreeify(((TreeBin)node2).first));
                                    }
                                }
                            }
                        }
                    }
                }
                if (n != 0) break;
            }
            if (n >= 8) {
                this.treeifyBin(nodeArray, n3);
            }
        }
        if (n2 != 0) {
            this.addCount(n2, n);
        }
        return v2;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public Enumeration<K> keys() {
        Node<K, V>[] nodeArray = this.table;
        int n = this.table == null ? 0 : nodeArray.length;
        return new KeyIterator<K, V>(nodeArray, n, 0, n, this);
    }

    public Enumeration<V> elements() {
        Node<K, V>[] nodeArray = this.table;
        int n = this.table == null ? 0 : nodeArray.length;
        return new ValueIterator<K, V>(nodeArray, n, 0, n, this);
    }

    public long mappingCount() {
        long l = this.sumCount();
        return l < 0L ? 0L : l;
    }

    public static <K> KeySetView<K, Boolean> newKeySet() {
        return new KeySetView<K, Boolean>(new ConcurrentHashMap(), Boolean.TRUE);
    }

    public static <K> KeySetView<K, Boolean> newKeySet(int n) {
        return new KeySetView<K, Boolean>(new ConcurrentHashMap(n), Boolean.TRUE);
    }

    public KeySetView<K, V> keySet(V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        return new KeySetView(this, v);
    }

    static final int resizeStamp(int n) {
        return Integer.numberOfLeadingZeros(n) | 1 << RESIZE_STAMP_BITS - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Node<K, V>[] initTable() {
        Node<K, V>[] nodeArray;
        block6: {
            int n;
            while (true) {
                nodeArray = this.table;
                if (this.table != null && nodeArray.length != 0) break block6;
                n = this.sizeCtl;
                if (n < 0) {
                    Thread.yield();
                    continue;
                }
                if (U.compareAndSwapInt(this, SIZECTL, n, -1)) break;
            }
            try {
                nodeArray = this.table;
                if (this.table == null || nodeArray.length == 0) {
                    int n2 = n > 0 ? n : 16;
                    Node[] nodeArray2 = new Node[n2];
                    nodeArray = nodeArray2;
                    this.table = nodeArray2;
                    n = n2 - (n2 >>> 2);
                }
            }
            finally {
                this.sizeCtl = n;
            }
        }
        return nodeArray;
    }

    private final void addCount(long l, int n) {
        Node<K, V>[] nodeArray;
        int n2;
        int n3;
        long l2;
        long l3;
        CounterCell[] counterCellArray = this.counterCells;
        if (this.counterCells != null || !U.compareAndSwapLong(this, BASECOUNT, l3 = this.baseCount, l2 = l3 + l)) {
            long l4;
            n3 = 1;
            if (counterCellArray == null || (n2 = counterCellArray.length - 1) < 0 || (nodeArray = counterCellArray[ThreadLocalRandom.getProbe() & n2]) == null || (n3 = U.compareAndSwapLong(nodeArray, CELLVALUE, l4 = nodeArray.value, l4 + l)) == 0) {
                this.fullAddCount(l, n3 != 0);
                return;
            }
            if (n <= 1) {
                return;
            }
            l2 = this.sumCount();
        }
        if (n >= 0) {
            while (l2 >= (long)(n2 = this.sizeCtl)) {
                int n4;
                nodeArray = this.table;
                if (this.table == null || (n4 = nodeArray.length) >= 0x40000000) break;
                n3 = ConcurrentHashMap.resizeStamp(n4) << RESIZE_STAMP_SHIFT;
                if (n2 < 0) {
                    if (n2 == n3 + MAX_RESIZERS || n2 == n3 + 1) break;
                    Node<K, V>[] nodeArray2 = this.nextTable;
                    if (this.nextTable == null || this.transferIndex <= 0) break;
                    if (U.compareAndSwapInt(this, SIZECTL, n2, n2 + 1)) {
                        this.transfer(nodeArray, nodeArray2);
                    }
                } else if (U.compareAndSwapInt(this, SIZECTL, n2, n3 + 2)) {
                    this.transfer(nodeArray, null);
                }
                l2 = this.sumCount();
            }
        }
    }

    final Node<K, V>[] helpTransfer(Node<K, V>[] nodeArray, Node<K, V> node) {
        if (nodeArray != null && node instanceof ForwardingNode) {
            Node<K, V>[] nodeArray2 = ((ForwardingNode)node).nextTable;
            if (((ForwardingNode)node).nextTable != null) {
                int n;
                int n2 = ConcurrentHashMap.resizeStamp(nodeArray.length) << RESIZE_STAMP_SHIFT;
                while (nodeArray2 == this.nextTable && this.table == nodeArray && (n = this.sizeCtl) < 0 && n != n2 + MAX_RESIZERS && n != n2 + 1 && this.transferIndex > 0) {
                    if (!U.compareAndSwapInt(this, SIZECTL, n, n + 1)) continue;
                    this.transfer(nodeArray, nodeArray2);
                    break;
                }
                return nodeArray2;
            }
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryPresize(int n) {
        int n2;
        int n3;
        int n4 = n3 = n >= 0x20000000 ? 0x40000000 : ConcurrentHashMap.tableSizeFor(n + (n >>> 1) + 1);
        while ((n2 = this.sizeCtl) >= 0) {
            int n5;
            Node<K, V>[] nodeArray = this.table;
            if (nodeArray == null || (n5 = nodeArray.length) == 0) {
                int n6 = n5 = n2 > n3 ? n2 : n3;
                if (!U.compareAndSwapInt(this, SIZECTL, n2, -1)) continue;
                try {
                    if (this.table != nodeArray) continue;
                    Node[] nodeArray2 = new Node[n5];
                    this.table = nodeArray2;
                    n2 = n5 - (n5 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl = n2;
                    continue;
                }
            }
            if (n3 <= n2 || n5 >= 0x40000000) break;
            if (nodeArray != this.table) continue;
            int n7 = ConcurrentHashMap.resizeStamp(n5);
            if (n2 < 0) {
                if (n2 >>> RESIZE_STAMP_SHIFT != n7 || n2 == n7 + 1 || n2 == n7 + MAX_RESIZERS) break;
                Node<K, V>[] nodeArray3 = this.nextTable;
                if (this.nextTable == null || this.transferIndex <= 0) break;
                if (!U.compareAndSwapInt(this, SIZECTL, n2, n2 + 1)) continue;
                this.transfer(nodeArray, nodeArray3);
                continue;
            }
            if (!U.compareAndSwapInt(this, SIZECTL, n2, (n7 << RESIZE_STAMP_SHIFT) + 2)) continue;
            this.transfer(nodeArray, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void transfer(Node<K, V>[] nodeArray, Node<K, V>[] nodeArray2) {
        int n = nodeArray.length;
        int n2 = NCPU > 1 ? (n >>> 3) / NCPU : n;
        if (n2 < 16) {
            n2 = 16;
        }
        if (nodeArray2 == null) {
            try {
                Node[] nodeArray3 = new Node[n << 1];
                nodeArray2 = nodeArray3;
            }
            catch (Throwable throwable) {
                this.sizeCtl = Integer.MAX_VALUE;
                return;
            }
            this.nextTable = nodeArray2;
            this.transferIndex = n;
        }
        int n3 = nodeArray2.length;
        ForwardingNode<K, V> forwardingNode = new ForwardingNode<K, V>(nodeArray2);
        boolean bl = true;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            int n6;
            if (bl) {
                if (--n4 >= n5 || bl2) {
                    bl = false;
                    continue;
                }
                n6 = this.transferIndex;
                if (n6 <= 0) {
                    n4 = -1;
                    bl = false;
                    continue;
                }
                int n7 = n6 > n2 ? n6 - n2 : 0;
                if (!U.compareAndSwapInt(this, TRANSFERINDEX, n6, n7)) continue;
                n5 = n7;
                n4 = n6 - 1;
                bl = false;
                continue;
            }
            if (n4 < 0 || n4 >= n || n4 + n >= n3) {
                if (bl2) {
                    this.nextTable = null;
                    this.table = nodeArray2;
                    this.sizeCtl = (n << 1) - (n >>> 1);
                    return;
                }
                n6 = this.sizeCtl;
                if (!U.compareAndSwapInt(this, SIZECTL, n6, n6 - 1)) continue;
                if (n6 - 2 != ConcurrentHashMap.resizeStamp(n) << RESIZE_STAMP_SHIFT) {
                    return;
                }
                bl = true;
                bl2 = true;
                n4 = n;
                continue;
            }
            TreeBin<K, V> treeBin = ConcurrentHashMap.tabAt(nodeArray, n4);
            if (treeBin == null) {
                bl = ConcurrentHashMap.casTabAt(nodeArray, n4, null, forwardingNode);
                continue;
            }
            int n8 = treeBin.hash;
            if (n8 == -1) {
                bl = true;
                continue;
            }
            TreeBin<K, V> treeBin2 = treeBin;
            synchronized (treeBin2) {
                if (ConcurrentHashMap.tabAt(nodeArray, n4) == treeBin) {
                    TreeNode treeNode;
                    Node node;
                    Node node2;
                    Node node3;
                    if (n8 >= 0) {
                        Node node4;
                        int n9;
                        int n10 = n8 & n;
                        node3 = treeBin;
                        node2 = treeBin.next;
                        while (node2 != null) {
                            n9 = node2.hash & n;
                            if (n9 != n10) {
                                n10 = n9;
                                node3 = node2;
                            }
                            node2 = node2.next;
                        }
                        if (n10 == 0) {
                            node4 = node3;
                            node = null;
                        } else {
                            node = node3;
                            node4 = null;
                        }
                        node2 = treeBin;
                        while (node2 != node3) {
                            n9 = node2.hash;
                            treeNode = (TreeNode)node2.key;
                            Object v = node2.val;
                            if ((n9 & n) == 0) {
                                node4 = new Node(n9, treeNode, v, node4);
                            } else {
                                node = new Node(n9, treeNode, v, node);
                            }
                            node2 = node2.next;
                        }
                        ConcurrentHashMap.setTabAt(nodeArray2, n4, node4);
                        ConcurrentHashMap.setTabAt(nodeArray2, n4 + n, node);
                        ConcurrentHashMap.setTabAt(nodeArray, n4, forwardingNode);
                        bl = true;
                    } else if (treeBin instanceof TreeBin) {
                        TreeBin<K, V> treeBin3;
                        TreeBin<K, V> treeBin4 = treeBin;
                        node3 = null;
                        node2 = null;
                        TreeNode treeNode2 = null;
                        treeNode = null;
                        int n11 = 0;
                        int n12 = 0;
                        Node node5 = treeBin4.first;
                        while (node5 != null) {
                            int n13 = node5.hash;
                            TreeNode treeNode3 = new TreeNode(n13, node5.key, node5.val, null, null);
                            if ((n13 & n) == 0) {
                                treeNode3.prev = node2;
                                if (treeNode3.prev == null) {
                                    node3 = treeNode3;
                                } else {
                                    ((TreeNode)node2).next = treeNode3;
                                }
                                node2 = treeNode3;
                                ++n11;
                            } else {
                                treeNode3.prev = treeNode;
                                if (treeNode3.prev == null) {
                                    treeNode2 = treeNode3;
                                } else {
                                    treeNode.next = treeNode3;
                                }
                                treeNode = treeNode3;
                                ++n12;
                            }
                            node5 = node5.next;
                        }
                        TreeBin<K, V> treeBin5 = n11 <= 6 ? ConcurrentHashMap.untreeify(node3) : (treeBin3 = n12 != 0 ? new TreeBin<K, V>(node3) : treeBin4);
                        node = n12 <= 6 ? ConcurrentHashMap.untreeify(treeNode2) : (n11 != 0 ? new TreeBin(treeNode2) : treeBin4);
                        ConcurrentHashMap.setTabAt(nodeArray2, n4, treeBin3);
                        ConcurrentHashMap.setTabAt(nodeArray2, n4 + n, node);
                        ConcurrentHashMap.setTabAt(nodeArray, n4, forwardingNode);
                        bl = true;
                    }
                }
            }
        }
    }

    final long sumCount() {
        CounterCell[] counterCellArray = this.counterCells;
        long l = this.baseCount;
        if (counterCellArray != null) {
            for (int i = 0; i < counterCellArray.length; ++i) {
                CounterCell counterCell = counterCellArray[i];
                if (counterCell == null) continue;
                l += counterCell.value;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void fullAddCount(long l, boolean bl) {
        int n = ThreadLocalRandom.getProbe();
        if (n == 0) {
            ThreadLocalRandom.localInit();
            n = ThreadLocalRandom.getProbe();
            bl = true;
        }
        boolean bl2 = false;
        while (true) {
            long l2;
            int n2;
            CounterCell[] counterCellArray = this.counterCells;
            if (this.counterCells != null && (n2 = counterCellArray.length) > 0) {
                CounterCell[] counterCellArray2;
                CounterCell counterCell = counterCellArray[n2 - 1 & n];
                if (counterCell == null) {
                    if (this.cellsBusy == 0) {
                        counterCellArray2 = new CounterCell(l);
                        if (this.cellsBusy == 0 && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                            boolean bl3 = false;
                            try {
                                int n3;
                                int n4;
                                CounterCell[] counterCellArray3 = this.counterCells;
                                if (this.counterCells != null && (n4 = counterCellArray3.length) > 0 && counterCellArray3[n3 = n4 - 1 & n] == null) {
                                    counterCellArray3[n3] = counterCellArray2;
                                    bl3 = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!bl3) continue;
                            return;
                        }
                    }
                    bl2 = false;
                } else if (!bl) {
                    bl = true;
                } else {
                    l2 = counterCell.value;
                    if (U.compareAndSwapLong(counterCell, CELLVALUE, l2, l2 + l)) return;
                    if (this.counterCells != counterCellArray || n2 >= NCPU) {
                        bl2 = false;
                    } else if (!bl2) {
                        bl2 = true;
                    } else if (this.cellsBusy == 0 && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                        try {
                            if (this.counterCells == counterCellArray) {
                                counterCellArray2 = new CounterCell[n2 << 1];
                                for (int i = 0; i < n2; ++i) {
                                    counterCellArray2[i] = counterCellArray[i];
                                }
                                this.counterCells = counterCellArray2;
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        bl2 = false;
                        continue;
                    }
                }
                n = ThreadLocalRandom.advanceProbe(n);
                continue;
            }
            if (this.cellsBusy == 0 && this.counterCells == counterCellArray && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                boolean bl4 = false;
                try {
                    if (this.counterCells == counterCellArray) {
                        CounterCell[] counterCellArray4 = new CounterCell[2];
                        counterCellArray4[n & 1] = new CounterCell(l);
                        this.counterCells = counterCellArray4;
                        bl4 = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!bl4) continue;
                return;
            }
            l2 = this.baseCount;
            if (U.compareAndSwapLong(this, BASECOUNT, l2, l2 + l)) return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void treeifyBin(Node<K, V>[] nodeArray, int n) {
        if (nodeArray != null) {
            int n2 = nodeArray.length;
            if (n2 < 64) {
                this.tryPresize(n2 << 1);
            } else {
                Node<K, V> node = ConcurrentHashMap.tabAt(nodeArray, n);
                if (node != null && node.hash >= 0) {
                    Node<K, V> node2 = node;
                    synchronized (node2) {
                        if (ConcurrentHashMap.tabAt(nodeArray, n) == node) {
                            TreeNode treeNode = null;
                            TreeNode treeNode2 = null;
                            Node<K, V> node3 = node;
                            while (node3 != null) {
                                TreeNode treeNode3 = new TreeNode(node3.hash, node3.key, node3.val, null, null);
                                treeNode3.prev = treeNode2;
                                if (treeNode3.prev == null) {
                                    treeNode = treeNode3;
                                } else {
                                    treeNode2.next = treeNode3;
                                }
                                treeNode2 = treeNode3;
                                node3 = node3.next;
                            }
                            ConcurrentHashMap.setTabAt(nodeArray, n, new TreeBin(treeNode));
                        }
                    }
                }
            }
        }
    }

    static <K, V> Node<K, V> untreeify(Node<K, V> node) {
        Node node2 = null;
        Node node3 = null;
        Node<K, V> node4 = node;
        while (node4 != null) {
            Node node5 = new Node(node4.hash, node4.key, node4.val, null);
            if (node3 == null) {
                node2 = node5;
            } else {
                node3.next = node5;
            }
            node3 = node5;
            node4 = node4.next;
        }
        return node2;
    }

    final int batchFor(long l) {
        long l2;
        if (l == Long.MAX_VALUE || (l2 = this.sumCount()) <= 1L || l2 < l) {
            return 0;
        }
        int n = ForkJoinPool.getCommonPoolParallelism() << 2;
        return l <= 0L || (l2 /= l) >= (long)n ? n : (int)l2;
    }

    public void forEach(long l, BiConsumer<? super K, ? super V> biConsumer) {
        if (biConsumer == null) {
            throw new NullPointerException();
        }
        new ForEachMappingTask<K, V>(null, this.batchFor(l), 0, 0, this.table, biConsumer).invoke();
    }

    public <U> void forEach(long l, BiFunction<? super K, ? super V, ? extends U> biFunction, Consumer<? super U> consumer) {
        if (biFunction == null || consumer == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedMappingTask<K, V, U>(null, this.batchFor(l), 0, 0, this.table, biFunction, consumer).invoke();
    }

    public <U> U search(long l, BiFunction<? super K, ? super V, ? extends U> biFunction) {
        if (biFunction == null) {
            throw new NullPointerException();
        }
        return (U)new SearchMappingsTask<K, V, U>(null, this.batchFor(l), 0, 0, this.table, biFunction, new AtomicReference()).invoke();
    }

    public <U> U reduce(long l, BiFunction<? super K, ? super V, ? extends U> biFunction, BiFunction<? super U, ? super U, ? extends U> biFunction2) {
        if (biFunction == null || biFunction2 == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceMappingsTask<K, V, U>(null, this.batchFor(l), 0, 0, this.table, null, biFunction, biFunction2).invoke();
    }

    public double reduceToDouble(long l, ToDoubleBiFunction<? super K, ? super V> toDoubleBiFunction, double d, DoubleBinaryOperator doubleBinaryOperator) {
        if (toDoubleBiFunction == null || doubleBinaryOperator == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceMappingsToDoubleTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, toDoubleBiFunction, d, doubleBinaryOperator).invoke();
    }

    public long reduceToLong(long l, ToLongBiFunction<? super K, ? super V> toLongBiFunction, long l2, LongBinaryOperator longBinaryOperator) {
        if (toLongBiFunction == null || longBinaryOperator == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceMappingsToLongTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, toLongBiFunction, l2, longBinaryOperator).invoke();
    }

    public int reduceToInt(long l, ToIntBiFunction<? super K, ? super V> toIntBiFunction, int n, IntBinaryOperator intBinaryOperator) {
        if (toIntBiFunction == null || intBinaryOperator == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceMappingsToIntTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, toIntBiFunction, n, intBinaryOperator).invoke();
    }

    public void forEachKey(long l, Consumer<? super K> consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        new ForEachKeyTask<K, V>(null, this.batchFor(l), 0, 0, this.table, consumer).invoke();
    }

    public <U> void forEachKey(long l, Function<? super K, ? extends U> function, Consumer<? super U> consumer) {
        if (function == null || consumer == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedKeyTask<K, V, U>(null, this.batchFor(l), 0, 0, this.table, function, consumer).invoke();
    }

    public <U> U searchKeys(long l, Function<? super K, ? extends U> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        return (U)new SearchKeysTask<K, V, U>(null, this.batchFor(l), 0, 0, this.table, function, new AtomicReference()).invoke();
    }

    public K reduceKeys(long l, BiFunction<? super K, ? super K, ? extends K> biFunction) {
        if (biFunction == null) {
            throw new NullPointerException();
        }
        return (K)new ReduceKeysTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, biFunction).invoke();
    }

    public <U> U reduceKeys(long l, Function<? super K, ? extends U> function, BiFunction<? super U, ? super U, ? extends U> biFunction) {
        if (function == null || biFunction == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceKeysTask<K, V, U>(null, this.batchFor(l), 0, 0, this.table, null, function, biFunction).invoke();
    }

    public double reduceKeysToDouble(long l, ToDoubleFunction<? super K> toDoubleFunction, double d, DoubleBinaryOperator doubleBinaryOperator) {
        if (toDoubleFunction == null || doubleBinaryOperator == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceKeysToDoubleTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, toDoubleFunction, d, doubleBinaryOperator).invoke();
    }

    public long reduceKeysToLong(long l, ToLongFunction<? super K> toLongFunction, long l2, LongBinaryOperator longBinaryOperator) {
        if (toLongFunction == null || longBinaryOperator == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceKeysToLongTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, toLongFunction, l2, longBinaryOperator).invoke();
    }

    public int reduceKeysToInt(long l, ToIntFunction<? super K> toIntFunction, int n, IntBinaryOperator intBinaryOperator) {
        if (toIntFunction == null || intBinaryOperator == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceKeysToIntTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, toIntFunction, n, intBinaryOperator).invoke();
    }

    public void forEachValue(long l, Consumer<? super V> consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        new ForEachValueTask<K, V>(null, this.batchFor(l), 0, 0, this.table, consumer).invoke();
    }

    public <U> void forEachValue(long l, Function<? super V, ? extends U> function, Consumer<? super U> consumer) {
        if (function == null || consumer == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedValueTask<K, V, U>(null, this.batchFor(l), 0, 0, this.table, function, consumer).invoke();
    }

    public <U> U searchValues(long l, Function<? super V, ? extends U> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        return (U)new SearchValuesTask<K, V, U>(null, this.batchFor(l), 0, 0, this.table, function, new AtomicReference()).invoke();
    }

    public V reduceValues(long l, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        if (biFunction == null) {
            throw new NullPointerException();
        }
        return new ReduceValuesTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, biFunction).invoke();
    }

    public <U> U reduceValues(long l, Function<? super V, ? extends U> function, BiFunction<? super U, ? super U, ? extends U> biFunction) {
        if (function == null || biFunction == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceValuesTask<K, V, U>(null, this.batchFor(l), 0, 0, this.table, null, function, biFunction).invoke();
    }

    public double reduceValuesToDouble(long l, ToDoubleFunction<? super V> toDoubleFunction, double d, DoubleBinaryOperator doubleBinaryOperator) {
        if (toDoubleFunction == null || doubleBinaryOperator == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceValuesToDoubleTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, toDoubleFunction, d, doubleBinaryOperator).invoke();
    }

    public long reduceValuesToLong(long l, ToLongFunction<? super V> toLongFunction, long l2, LongBinaryOperator longBinaryOperator) {
        if (toLongFunction == null || longBinaryOperator == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceValuesToLongTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, toLongFunction, l2, longBinaryOperator).invoke();
    }

    public int reduceValuesToInt(long l, ToIntFunction<? super V> toIntFunction, int n, IntBinaryOperator intBinaryOperator) {
        if (toIntFunction == null || intBinaryOperator == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceValuesToIntTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, toIntFunction, n, intBinaryOperator).invoke();
    }

    public void forEachEntry(long l, Consumer<? super Map.Entry<K, V>> consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        new ForEachEntryTask<K, V>(null, this.batchFor(l), 0, 0, this.table, consumer).invoke();
    }

    public <U> void forEachEntry(long l, Function<Map.Entry<K, V>, ? extends U> function, Consumer<? super U> consumer) {
        if (function == null || consumer == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedEntryTask<K, V, U>(null, this.batchFor(l), 0, 0, this.table, function, consumer).invoke();
    }

    public <U> U searchEntries(long l, Function<Map.Entry<K, V>, ? extends U> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        return (U)new SearchEntriesTask<K, V, U>(null, this.batchFor(l), 0, 0, this.table, function, new AtomicReference()).invoke();
    }

    public Map.Entry<K, V> reduceEntries(long l, BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> biFunction) {
        if (biFunction == null) {
            throw new NullPointerException();
        }
        return (Map.Entry)new ReduceEntriesTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, biFunction).invoke();
    }

    public <U> U reduceEntries(long l, Function<Map.Entry<K, V>, ? extends U> function, BiFunction<? super U, ? super U, ? extends U> biFunction) {
        if (function == null || biFunction == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceEntriesTask<K, V, U>(null, this.batchFor(l), 0, 0, this.table, null, function, biFunction).invoke();
    }

    public double reduceEntriesToDouble(long l, ToDoubleFunction<Map.Entry<K, V>> toDoubleFunction, double d, DoubleBinaryOperator doubleBinaryOperator) {
        if (toDoubleFunction == null || doubleBinaryOperator == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceEntriesToDoubleTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, toDoubleFunction, d, doubleBinaryOperator).invoke();
    }

    public long reduceEntriesToLong(long l, ToLongFunction<Map.Entry<K, V>> toLongFunction, long l2, LongBinaryOperator longBinaryOperator) {
        if (toLongFunction == null || longBinaryOperator == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceEntriesToLongTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, toLongFunction, l2, longBinaryOperator).invoke();
    }

    public int reduceEntriesToInt(long l, ToIntFunction<Map.Entry<K, V>> toIntFunction, int n, IntBinaryOperator intBinaryOperator) {
        if (toIntFunction == null || intBinaryOperator == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceEntriesToIntTask<K, V>(null, this.batchFor(l), 0, 0, this.table, null, toIntFunction, n, intBinaryOperator).invoke();
    }

    static {
        try {
            U = Unsafe.getUnsafe();
            Class<ConcurrentHashMap> clazz = ConcurrentHashMap.class;
            SIZECTL = U.objectFieldOffset(clazz.getDeclaredField("sizeCtl"));
            TRANSFERINDEX = U.objectFieldOffset(clazz.getDeclaredField("transferIndex"));
            BASECOUNT = U.objectFieldOffset(clazz.getDeclaredField("baseCount"));
            CELLSBUSY = U.objectFieldOffset(clazz.getDeclaredField("cellsBusy"));
            Class<CounterCell> clazz2 = CounterCell.class;
            CELLVALUE = U.objectFieldOffset(clazz2.getDeclaredField("value"));
            Class<Node[]> clazz3 = Node[].class;
            ABASE = U.arrayBaseOffset(clazz3);
            int n = U.arrayIndexScale(clazz3);
            if ((n & n - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(n);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    static class BaseIterator<K, V>
    extends Traverser<K, V> {
        final ConcurrentHashMap<K, V> map;
        Node<K, V> lastReturned;

        BaseIterator(Node<K, V>[] nodeArray, int n, int n2, int n3, ConcurrentHashMap<K, V> concurrentHashMap) {
            super(nodeArray, n, n2, n3);
            this.map = concurrentHashMap;
            this.advance();
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public final boolean hasMoreElements() {
            return this.next != null;
        }

        public final void remove() {
            Node<K, V> node = this.lastReturned;
            if (node == null) {
                throw new IllegalStateException();
            }
            this.lastReturned = null;
            this.map.replaceNode(node.key, null, null);
        }
    }

    static abstract class BulkTask<K, V, R>
    extends CountedCompleter<R> {
        Node<K, V>[] tab;
        Node<K, V> next;
        TableStack<K, V> stack;
        TableStack<K, V> spare;
        int index;
        int baseIndex;
        int baseLimit;
        final int baseSize;
        int batch;

        BulkTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray) {
            super(bulkTask);
            this.batch = n;
            this.index = this.baseIndex = n2;
            this.tab = nodeArray;
            if (nodeArray == null) {
                this.baseLimit = 0;
                this.baseSize = 0;
            } else if (bulkTask == null) {
                this.baseSize = this.baseLimit = nodeArray.length;
            } else {
                this.baseLimit = n3;
                this.baseSize = bulkTask.baseSize;
            }
        }

        final Node<K, V> advance() {
            Node<K, V> node = this.next;
            if (node != null) {
                node = node.next;
            }
            while (true) {
                int n;
                int n2;
                Node<K, V>[] nodeArray;
                block10: {
                    block9: {
                        if (node != null) {
                            this.next = node;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        nodeArray = this.tab;
                        if (this.tab != null && (n2 = nodeArray.length) > (n = this.index) && n >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                node = ConcurrentHashMap.tabAt(nodeArray, n);
                if (node != null && node.hash < 0) {
                    if (node instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)node).nextTable;
                        node = null;
                        this.pushState(nodeArray, n, n2);
                        continue;
                    }
                    node = node instanceof TreeBin ? ((TreeBin)node).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n2);
                    continue;
                }
                this.index = n + this.baseSize;
                if (this.index < n2) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(Node<K, V>[] nodeArray, int n, int n2) {
            TableStack<K, V> tableStack = this.spare;
            if (tableStack != null) {
                this.spare = tableStack.next;
            } else {
                tableStack = new TableStack();
            }
            tableStack.tab = nodeArray;
            tableStack.length = n2;
            tableStack.index = n;
            tableStack.next = this.stack;
            this.stack = tableStack;
        }

        private void recoverState(int n) {
            int n2;
            TableStack<K, V> tableStack;
            while ((tableStack = this.stack) != null && (this.index += (n2 = tableStack.length)) >= n) {
                n = n2;
                this.index = tableStack.index;
                this.tab = tableStack.tab;
                tableStack.tab = null;
                TableStack tableStack2 = tableStack.next;
                tableStack.next = this.spare;
                this.stack = tableStack2;
                this.spare = tableStack;
            }
            if (tableStack == null && (this.index += this.baseSize) >= n) {
                this.index = ++this.baseIndex;
            }
        }
    }

    static abstract class CollectionView<K, V, E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 7249069246763182397L;
        final ConcurrentHashMap<K, V> map;
        private static final String oomeMsg = "Required array size too large";

        CollectionView(ConcurrentHashMap<K, V> concurrentHashMap) {
            this.map = concurrentHashMap;
        }

        public ConcurrentHashMap<K, V> getMap() {
            return this.map;
        }

        @Override
        public final void clear() {
            this.map.clear();
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public abstract Iterator<E> iterator();

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public abstract boolean remove(Object var1);

        @Override
        public final Object[] toArray() {
            long l = this.map.mappingCount();
            if (l > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int n = (int)l;
            Object[] objectArray = new Object[n];
            int n2 = 0;
            for (E e : this) {
                if (n2 == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    objectArray = Arrays.copyOf(objectArray, n);
                }
                objectArray[n2++] = e;
            }
            return n2 == n ? objectArray : Arrays.copyOf(objectArray, n2);
        }

        @Override
        public final <T> T[] toArray(T[] TArray) {
            long l = this.map.mappingCount();
            if (l > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int n = (int)l;
            T[] TArray2 = TArray.length >= n ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
            int n2 = TArray2.length;
            int n3 = 0;
            for (E e : this) {
                if (n3 == n2) {
                    if (n2 >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n2 = n2 >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n2 += (n2 >>> 1) + 1);
                    TArray2 = Arrays.copyOf(TArray2, n2);
                }
                TArray2[n3++] = e;
            }
            if (TArray == TArray2 && n3 < n2) {
                TArray2[n3] = null;
                return TArray2;
            }
            return n3 == n2 ? TArray2 : Arrays.copyOf(TArray2, n3);
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            Iterator<E> iterator = this.iterator();
            if (iterator.hasNext()) {
                while (true) {
                    E e;
                    stringBuilder.append((Object)((e = iterator.next()) == this ? "(this Collection)" : e));
                    if (!iterator.hasNext()) break;
                    stringBuilder.append(',').append(' ');
                }
            }
            return stringBuilder.append(']').toString();
        }

        @Override
        public final boolean containsAll(Collection<?> collection) {
            if (collection != this) {
                for (Object obj : collection) {
                    if (obj != null && this.contains(obj)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public final boolean removeAll(Collection<?> collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            boolean bl = false;
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public final boolean retainAll(Collection<?> collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            boolean bl = false;
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }
    }

    @Contended
    static final class CounterCell {
        volatile long value;

        CounterCell(long l) {
            this.value = l;
        }
    }

    static final class EntryIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(Node<K, V>[] nodeArray, int n, int n2, int n3, ConcurrentHashMap<K, V> concurrentHashMap) {
            super(nodeArray, n, n2, n3, concurrentHashMap);
        }

        @Override
        public final Map.Entry<K, V> next() {
            Node node = this.next;
            if (node == null) {
                throw new NoSuchElementException();
            }
            Object k = node.key;
            Object v = node.val;
            this.lastReturned = node;
            this.advance();
            return new MapEntry(k, v, this.map);
        }
    }

    static final class EntrySetView<K, V>
    extends CollectionView<K, V, Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>>,
    Serializable {
        private static final long serialVersionUID = 2249069246763182397L;

        EntrySetView(ConcurrentHashMap<K, V> concurrentHashMap) {
            super(concurrentHashMap);
        }

        @Override
        public boolean contains(Object object) {
            Object v;
            Object v2;
            Map.Entry entry;
            Object k;
            return object instanceof Map.Entry && (k = (entry = (Map.Entry)object).getKey()) != null && (v2 = this.map.get(k)) != null && (v = entry.getValue()) != null && (v == v2 || v.equals(v2));
        }

        @Override
        public boolean remove(Object object) {
            Object v;
            Map.Entry entry;
            Object k;
            return object instanceof Map.Entry && (k = (entry = (Map.Entry)object).getKey()) != null && (v = entry.getValue()) != null && this.map.remove(k, v);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            ConcurrentHashMap concurrentHashMap = this.map;
            Node<K, V>[] nodeArray = concurrentHashMap.table;
            int n = concurrentHashMap.table == null ? 0 : nodeArray.length;
            return new EntryIterator(nodeArray, n, 0, n, concurrentHashMap);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return this.map.putVal(entry.getKey(), entry.getValue(), false) == null;
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
            boolean bl = false;
            for (Map.Entry<K, V> entry : collection) {
                if (!this.add(entry)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public final int hashCode() {
            int n = 0;
            Node<K, V>[] nodeArray = this.map.table;
            if (this.map.table != null) {
                Node node;
                Traverser traverser = new Traverser(nodeArray, nodeArray.length, 0, nodeArray.length);
                while ((node = traverser.advance()) != null) {
                    n += node.hashCode();
                }
            }
            return n;
        }

        @Override
        public final boolean equals(Object object) {
            Set set;
            return object instanceof Set && ((set = (Set)object) == this || this.containsAll(set) && set.containsAll(this));
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            ConcurrentHashMap concurrentHashMap = this.map;
            long l = concurrentHashMap.sumCount();
            Node<K, V>[] nodeArray = concurrentHashMap.table;
            int n = concurrentHashMap.table == null ? 0 : nodeArray.length;
            return new EntrySpliterator(nodeArray, n, 0, n, l < 0L ? 0L : l, concurrentHashMap);
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<K, V>> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] nodeArray = this.map.table;
            if (this.map.table != null) {
                Node node;
                Traverser traverser = new Traverser(nodeArray, nodeArray.length, 0, nodeArray.length);
                while ((node = traverser.advance()) != null) {
                    consumer.accept(new MapEntry(node.key, node.val, this.map));
                }
            }
        }
    }

    static final class EntrySpliterator<K, V>
    extends Traverser<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        final ConcurrentHashMap<K, V> map;
        long est;

        EntrySpliterator(Node<K, V>[] nodeArray, int n, int n2, int n3, long l, ConcurrentHashMap<K, V> concurrentHashMap) {
            super(nodeArray, n, n2, n3);
            this.map = concurrentHashMap;
            this.est = l;
        }

        @Override
        public Spliterator<Map.Entry<K, V>> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            int n = this.baseIndex;
            int n2 = this.baseLimit;
            int n3 = n + n2 >>> 1;
            if (n3 <= n) {
                entrySpliterator = null;
            } else {
                this.baseLimit = n3;
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.tab, this.baseSize, this.baseLimit, n2, this.est >>>= 1, this.map);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> consumer) {
            Node node;
            if (consumer == null) {
                throw new NullPointerException();
            }
            while ((node = this.advance()) != null) {
                consumer.accept(new MapEntry(node.key, node.val, this.map));
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Node node = this.advance();
            if (node == null) {
                return false;
            }
            consumer.accept(new MapEntry(node.key, node.val, this.map));
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4353;
        }
    }

    static final class ForEachEntryTask<K, V>
    extends BulkTask<K, V, Void> {
        final Consumer<? super Map.Entry<K, V>> action;

        ForEachEntryTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, Consumer<? super Map.Entry<K, V>> consumer) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.action = consumer;
        }

        @Override
        public final void compute() {
            Consumer<Map.Entry<K, V>> consumer = this.action;
            if (consumer != null) {
                Node node;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    new ForEachEntryTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, consumer).fork();
                }
                while ((node = this.advance()) != null) {
                    consumer.accept(node);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachKeyTask<K, V>
    extends BulkTask<K, V, Void> {
        final Consumer<? super K> action;

        ForEachKeyTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, Consumer<? super K> consumer) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.action = consumer;
        }

        @Override
        public final void compute() {
            Consumer<K> consumer = this.action;
            if (consumer != null) {
                Node node;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    new ForEachKeyTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, consumer).fork();
                }
                while ((node = this.advance()) != null) {
                    consumer.accept(node.key);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachMappingTask<K, V>
    extends BulkTask<K, V, Void> {
        final BiConsumer<? super K, ? super V> action;

        ForEachMappingTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, BiConsumer<? super K, ? super V> biConsumer) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.action = biConsumer;
        }

        @Override
        public final void compute() {
            BiConsumer<K, V> biConsumer = this.action;
            if (biConsumer != null) {
                Node node;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    new ForEachMappingTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, biConsumer).fork();
                }
                while ((node = this.advance()) != null) {
                    biConsumer.accept(node.key, node.val);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedEntryTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final Function<Map.Entry<K, V>, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedEntryTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, Function<Map.Entry<K, V>, ? extends U> function, Consumer<? super U> consumer) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.transformer = function;
            this.action = consumer;
        }

        @Override
        public final void compute() {
            Consumer<U> consumer;
            Function<Map.Entry<K, V>, U> function = this.transformer;
            if (function != null && (consumer = this.action) != null) {
                Node node;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    new ForEachTransformedEntryTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, function, consumer).fork();
                }
                while ((node = this.advance()) != null) {
                    U u = function.apply(node);
                    if (u == null) continue;
                    consumer.accept(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedKeyTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final Function<? super K, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedKeyTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, Function<? super K, ? extends U> function, Consumer<? super U> consumer) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.transformer = function;
            this.action = consumer;
        }

        @Override
        public final void compute() {
            Consumer<U> consumer;
            Function<K, U> function = this.transformer;
            if (function != null && (consumer = this.action) != null) {
                Node node;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    new ForEachTransformedKeyTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, function, consumer).fork();
                }
                while ((node = this.advance()) != null) {
                    U u = function.apply(node.key);
                    if (u == null) continue;
                    consumer.accept(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedMappingTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final BiFunction<? super K, ? super V, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedMappingTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, BiFunction<? super K, ? super V, ? extends U> biFunction, Consumer<? super U> consumer) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.transformer = biFunction;
            this.action = consumer;
        }

        @Override
        public final void compute() {
            Consumer<U> consumer;
            BiFunction biFunction = this.transformer;
            if (biFunction != null && (consumer = this.action) != null) {
                Node node;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    new ForEachTransformedMappingTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, biFunction, consumer).fork();
                }
                while ((node = this.advance()) != null) {
                    U u = biFunction.apply(node.key, node.val);
                    if (u == null) continue;
                    consumer.accept(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedValueTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final Function<? super V, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedValueTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, Function<? super V, ? extends U> function, Consumer<? super U> consumer) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.transformer = function;
            this.action = consumer;
        }

        @Override
        public final void compute() {
            Consumer<U> consumer;
            Function<V, U> function = this.transformer;
            if (function != null && (consumer = this.action) != null) {
                Node node;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    new ForEachTransformedValueTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, function, consumer).fork();
                }
                while ((node = this.advance()) != null) {
                    U u = function.apply(node.val);
                    if (u == null) continue;
                    consumer.accept(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachValueTask<K, V>
    extends BulkTask<K, V, Void> {
        final Consumer<? super V> action;

        ForEachValueTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, Consumer<? super V> consumer) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.action = consumer;
        }

        @Override
        public final void compute() {
            Consumer<V> consumer = this.action;
            if (consumer != null) {
                Node node;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    new ForEachValueTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, consumer).fork();
                }
                while ((node = this.advance()) != null) {
                    consumer.accept(node.val);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForwardingNode<K, V>
    extends Node<K, V> {
        final Node<K, V>[] nextTable;

        ForwardingNode(Node<K, V>[] nodeArray) {
            super(-1, null, null, null);
            this.nextTable = nodeArray;
        }

        @Override
        Node<K, V> find(int n, Object object) {
            Node<K, V>[] nodeArray = this.nextTable;
            block0: while (true) {
                Node<K, V> node;
                int n2;
                if (object == null || nodeArray == null || (n2 = nodeArray.length) == 0 || (node = ConcurrentHashMap.tabAt(nodeArray, n2 - 1 & n)) == null) {
                    return null;
                }
                do {
                    Object k;
                    int n3;
                    if ((n3 = node.hash) == n && ((k = node.key) == object || k != null && object.equals(k))) {
                        return node;
                    }
                    if (n3 >= 0) continue;
                    if (node instanceof ForwardingNode) {
                        nodeArray = ((ForwardingNode)node).nextTable;
                        continue block0;
                    }
                    return node.find(n, object);
                } while ((node = node.next) != null);
                break;
            }
            return null;
        }
    }

    static final class KeyIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator(Node<K, V>[] nodeArray, int n, int n2, int n3, ConcurrentHashMap<K, V> concurrentHashMap) {
            super(nodeArray, n, n2, n3, concurrentHashMap);
        }

        @Override
        public final K next() {
            Node node = this.next;
            if (node == null) {
                throw new NoSuchElementException();
            }
            Object k = node.key;
            this.lastReturned = node;
            this.advance();
            return k;
        }

        @Override
        public final K nextElement() {
            return this.next();
        }
    }

    public static class KeySetView<K, V>
    extends CollectionView<K, V, K>
    implements Set<K>,
    Serializable {
        private static final long serialVersionUID = 7249069246763182397L;
        private final V value;

        KeySetView(ConcurrentHashMap<K, V> concurrentHashMap, V v) {
            super(concurrentHashMap);
            this.value = v;
        }

        public V getMappedValue() {
            return this.value;
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.map.remove(object) != null;
        }

        @Override
        public Iterator<K> iterator() {
            ConcurrentHashMap concurrentHashMap = this.map;
            Node<K, V>[] nodeArray = concurrentHashMap.table;
            int n = concurrentHashMap.table == null ? 0 : nodeArray.length;
            return new KeyIterator(nodeArray, n, 0, n, concurrentHashMap);
        }

        @Override
        public boolean add(K k) {
            V v = this.value;
            if (v == null) {
                throw new UnsupportedOperationException();
            }
            return this.map.putVal(k, v, true) == null;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            boolean bl = false;
            V v = this.value;
            if (v == null) {
                throw new UnsupportedOperationException();
            }
            for (K k : collection) {
                if (this.map.putVal(k, v, true) != null) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public int hashCode() {
            int n = 0;
            for (K k : this) {
                n += k.hashCode();
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            Set set;
            return object instanceof Set && ((set = (Set)object) == this || this.containsAll(set) && set.containsAll(this));
        }

        @Override
        public Spliterator<K> spliterator() {
            ConcurrentHashMap concurrentHashMap = this.map;
            long l = concurrentHashMap.sumCount();
            Node<K, V>[] nodeArray = concurrentHashMap.table;
            int n = concurrentHashMap.table == null ? 0 : nodeArray.length;
            return new KeySpliterator(nodeArray, n, 0, n, l < 0L ? 0L : l);
        }

        @Override
        public void forEach(Consumer<? super K> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] nodeArray = this.map.table;
            if (this.map.table != null) {
                Node node;
                Traverser traverser = new Traverser(nodeArray, nodeArray.length, 0, nodeArray.length);
                while ((node = traverser.advance()) != null) {
                    consumer.accept(node.key);
                }
            }
        }
    }

    static final class KeySpliterator<K, V>
    extends Traverser<K, V>
    implements Spliterator<K> {
        long est;

        KeySpliterator(Node<K, V>[] nodeArray, int n, int n2, int n3, long l) {
            super(nodeArray, n, n2, n3);
            this.est = l;
        }

        @Override
        public Spliterator<K> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            int n = this.baseIndex;
            int n2 = this.baseLimit;
            int n3 = n + n2 >>> 1;
            if (n3 <= n) {
                keySpliterator = null;
            } else {
                this.baseLimit = n3;
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.tab, this.baseSize, this.baseLimit, n2, this.est >>>= 1);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
            Node node;
            if (consumer == null) {
                throw new NullPointerException();
            }
            while ((node = this.advance()) != null) {
                consumer.accept(node.key);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Node node = this.advance();
            if (node == null) {
                return false;
            }
            consumer.accept(node.key);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4353;
        }
    }

    static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V val;
        final ConcurrentHashMap<K, V> map;

        MapEntry(K k, V v, ConcurrentHashMap<K, V> concurrentHashMap) {
            this.key = k;
            this.val = v;
            this.map = concurrentHashMap;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.val.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.val;
        }

        @Override
        public boolean equals(Object object) {
            Object v;
            Map.Entry entry;
            Object k;
            return !(!(object instanceof Map.Entry) || (k = (entry = (Map.Entry)object).getKey()) == null || (v = entry.getValue()) == null || k != this.key && !k.equals(this.key) || v != this.val && !v.equals(this.val));
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            V v2 = this.val;
            this.val = v;
            this.map.put(this.key, v);
            return v2;
        }
    }

    static final class MapReduceEntriesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<Map.Entry<K, V>, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceEntriesTask<K, V, U> rights;
        MapReduceEntriesTask<K, V, U> nextRight;

        MapReduceEntriesTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceEntriesTask<K, V, U> mapReduceEntriesTask, Function<Map.Entry<K, V>, ? extends U> function, BiFunction<? super U, ? super U, ? extends U> biFunction) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceEntriesTask;
            this.transformer = function;
            this.reducer = biFunction;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> biFunction;
            Function<Map.Entry<K, V>, U> function = this.transformer;
            if (function != null && (biFunction = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceEntriesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, function, biFunction);
                    this.rights.fork();
                }
                Object t = null;
                while ((countedCompleter = this.advance()) != null) {
                    U u = function.apply((Map.Entry<K, V>)((Object)countedCompleter));
                    if (u == null) continue;
                    t = t == null ? u : biFunction.apply(t, u);
                }
                this.result = t;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceEntriesTask mapReduceEntriesTask = (MapReduceEntriesTask)countedCompleter;
                    MapReduceEntriesTask<K, V, U> mapReduceEntriesTask2 = mapReduceEntriesTask.rights;
                    while (mapReduceEntriesTask2 != null) {
                        U u = mapReduceEntriesTask2.result;
                        if (u != null) {
                            U u2 = mapReduceEntriesTask.result;
                            mapReduceEntriesTask.result = u2 == null ? u : biFunction.apply(u2, u);
                        }
                        mapReduceEntriesTask2 = mapReduceEntriesTask.rights = mapReduceEntriesTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleFunction<Map.Entry<K, V>> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceEntriesToDoubleTask<K, V> rights;
        MapReduceEntriesToDoubleTask<K, V> nextRight;

        MapReduceEntriesToDoubleTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceEntriesToDoubleTask<K, V> mapReduceEntriesToDoubleTask, ToDoubleFunction<Map.Entry<K, V>> toDoubleFunction, double d, DoubleBinaryOperator doubleBinaryOperator) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceEntriesToDoubleTask;
            this.transformer = toDoubleFunction;
            this.basis = d;
            this.reducer = doubleBinaryOperator;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator doubleBinaryOperator;
            ToDoubleFunction<Map.Entry<K, V>> toDoubleFunction = this.transformer;
            if (toDoubleFunction != null && (doubleBinaryOperator = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                double d = this.basis;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceEntriesToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, toDoubleFunction, d, doubleBinaryOperator);
                    this.rights.fork();
                }
                while ((countedCompleter = this.advance()) != null) {
                    d = doubleBinaryOperator.applyAsDouble(d, toDoubleFunction.applyAsDouble((Map.Entry<K, V>)((Object)countedCompleter)));
                }
                this.result = d;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceEntriesToDoubleTask mapReduceEntriesToDoubleTask = (MapReduceEntriesToDoubleTask)countedCompleter;
                    MapReduceEntriesToDoubleTask<K, V> mapReduceEntriesToDoubleTask2 = mapReduceEntriesToDoubleTask.rights;
                    while (mapReduceEntriesToDoubleTask2 != null) {
                        mapReduceEntriesToDoubleTask.result = doubleBinaryOperator.applyAsDouble(mapReduceEntriesToDoubleTask.result, mapReduceEntriesToDoubleTask2.result);
                        mapReduceEntriesToDoubleTask2 = mapReduceEntriesToDoubleTask.rights = mapReduceEntriesToDoubleTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntFunction<Map.Entry<K, V>> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceEntriesToIntTask<K, V> rights;
        MapReduceEntriesToIntTask<K, V> nextRight;

        MapReduceEntriesToIntTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceEntriesToIntTask<K, V> mapReduceEntriesToIntTask, ToIntFunction<Map.Entry<K, V>> toIntFunction, int n4, IntBinaryOperator intBinaryOperator) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceEntriesToIntTask;
            this.transformer = toIntFunction;
            this.basis = n4;
            this.reducer = intBinaryOperator;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator intBinaryOperator;
            ToIntFunction<Map.Entry<K, V>> toIntFunction = this.transformer;
            if (toIntFunction != null && (intBinaryOperator = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                int n3 = this.basis;
                int n4 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n4 >>> 1) > n4) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceEntriesToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, toIntFunction, n3, intBinaryOperator);
                    this.rights.fork();
                }
                while ((countedCompleter = this.advance()) != null) {
                    n3 = intBinaryOperator.applyAsInt(n3, toIntFunction.applyAsInt((Map.Entry<K, V>)((Object)countedCompleter)));
                }
                this.result = n3;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceEntriesToIntTask mapReduceEntriesToIntTask = (MapReduceEntriesToIntTask)countedCompleter;
                    MapReduceEntriesToIntTask<K, V> mapReduceEntriesToIntTask2 = mapReduceEntriesToIntTask.rights;
                    while (mapReduceEntriesToIntTask2 != null) {
                        mapReduceEntriesToIntTask.result = intBinaryOperator.applyAsInt(mapReduceEntriesToIntTask.result, mapReduceEntriesToIntTask2.result);
                        mapReduceEntriesToIntTask2 = mapReduceEntriesToIntTask.rights = mapReduceEntriesToIntTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongFunction<Map.Entry<K, V>> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceEntriesToLongTask<K, V> rights;
        MapReduceEntriesToLongTask<K, V> nextRight;

        MapReduceEntriesToLongTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceEntriesToLongTask<K, V> mapReduceEntriesToLongTask, ToLongFunction<Map.Entry<K, V>> toLongFunction, long l, LongBinaryOperator longBinaryOperator) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceEntriesToLongTask;
            this.transformer = toLongFunction;
            this.basis = l;
            this.reducer = longBinaryOperator;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator longBinaryOperator;
            ToLongFunction<Map.Entry<K, V>> toLongFunction = this.transformer;
            if (toLongFunction != null && (longBinaryOperator = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                long l = this.basis;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceEntriesToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, toLongFunction, l, longBinaryOperator);
                    this.rights.fork();
                }
                while ((countedCompleter = this.advance()) != null) {
                    l = longBinaryOperator.applyAsLong(l, toLongFunction.applyAsLong((Map.Entry<K, V>)((Object)countedCompleter)));
                }
                this.result = l;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceEntriesToLongTask mapReduceEntriesToLongTask = (MapReduceEntriesToLongTask)countedCompleter;
                    MapReduceEntriesToLongTask<K, V> mapReduceEntriesToLongTask2 = mapReduceEntriesToLongTask.rights;
                    while (mapReduceEntriesToLongTask2 != null) {
                        mapReduceEntriesToLongTask.result = longBinaryOperator.applyAsLong(mapReduceEntriesToLongTask.result, mapReduceEntriesToLongTask2.result);
                        mapReduceEntriesToLongTask2 = mapReduceEntriesToLongTask.rights = mapReduceEntriesToLongTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super K, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceKeysTask<K, V, U> rights;
        MapReduceKeysTask<K, V, U> nextRight;

        MapReduceKeysTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceKeysTask<K, V, U> mapReduceKeysTask, Function<? super K, ? extends U> function, BiFunction<? super U, ? super U, ? extends U> biFunction) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceKeysTask;
            this.transformer = function;
            this.reducer = biFunction;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> biFunction;
            Function<K, U> function = this.transformer;
            if (function != null && (biFunction = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceKeysTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, function, biFunction);
                    this.rights.fork();
                }
                Object t = null;
                while ((countedCompleter = this.advance()) != null) {
                    U u = function.apply(((Node)((Object)countedCompleter)).key);
                    if (u == null) continue;
                    t = t == null ? u : biFunction.apply(t, u);
                }
                this.result = t;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceKeysTask mapReduceKeysTask = (MapReduceKeysTask)countedCompleter;
                    MapReduceKeysTask<K, V, U> mapReduceKeysTask2 = mapReduceKeysTask.rights;
                    while (mapReduceKeysTask2 != null) {
                        U u = mapReduceKeysTask2.result;
                        if (u != null) {
                            U u2 = mapReduceKeysTask.result;
                            mapReduceKeysTask.result = u2 == null ? u : biFunction.apply(u2, u);
                        }
                        mapReduceKeysTask2 = mapReduceKeysTask.rights = mapReduceKeysTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleFunction<? super K> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceKeysToDoubleTask<K, V> rights;
        MapReduceKeysToDoubleTask<K, V> nextRight;

        MapReduceKeysToDoubleTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceKeysToDoubleTask<K, V> mapReduceKeysToDoubleTask, ToDoubleFunction<? super K> toDoubleFunction, double d, DoubleBinaryOperator doubleBinaryOperator) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceKeysToDoubleTask;
            this.transformer = toDoubleFunction;
            this.basis = d;
            this.reducer = doubleBinaryOperator;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator doubleBinaryOperator;
            ToDoubleFunction<K> toDoubleFunction = this.transformer;
            if (toDoubleFunction != null && (doubleBinaryOperator = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                double d = this.basis;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceKeysToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, toDoubleFunction, d, doubleBinaryOperator);
                    this.rights.fork();
                }
                while ((countedCompleter = this.advance()) != null) {
                    d = doubleBinaryOperator.applyAsDouble(d, toDoubleFunction.applyAsDouble(((Node)((Object)countedCompleter)).key));
                }
                this.result = d;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceKeysToDoubleTask mapReduceKeysToDoubleTask = (MapReduceKeysToDoubleTask)countedCompleter;
                    MapReduceKeysToDoubleTask<K, V> mapReduceKeysToDoubleTask2 = mapReduceKeysToDoubleTask.rights;
                    while (mapReduceKeysToDoubleTask2 != null) {
                        mapReduceKeysToDoubleTask.result = doubleBinaryOperator.applyAsDouble(mapReduceKeysToDoubleTask.result, mapReduceKeysToDoubleTask2.result);
                        mapReduceKeysToDoubleTask2 = mapReduceKeysToDoubleTask.rights = mapReduceKeysToDoubleTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntFunction<? super K> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceKeysToIntTask<K, V> rights;
        MapReduceKeysToIntTask<K, V> nextRight;

        MapReduceKeysToIntTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceKeysToIntTask<K, V> mapReduceKeysToIntTask, ToIntFunction<? super K> toIntFunction, int n4, IntBinaryOperator intBinaryOperator) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceKeysToIntTask;
            this.transformer = toIntFunction;
            this.basis = n4;
            this.reducer = intBinaryOperator;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator intBinaryOperator;
            ToIntFunction<K> toIntFunction = this.transformer;
            if (toIntFunction != null && (intBinaryOperator = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                int n3 = this.basis;
                int n4 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n4 >>> 1) > n4) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceKeysToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, toIntFunction, n3, intBinaryOperator);
                    this.rights.fork();
                }
                while ((countedCompleter = this.advance()) != null) {
                    n3 = intBinaryOperator.applyAsInt(n3, toIntFunction.applyAsInt(((Node)((Object)countedCompleter)).key));
                }
                this.result = n3;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceKeysToIntTask mapReduceKeysToIntTask = (MapReduceKeysToIntTask)countedCompleter;
                    MapReduceKeysToIntTask<K, V> mapReduceKeysToIntTask2 = mapReduceKeysToIntTask.rights;
                    while (mapReduceKeysToIntTask2 != null) {
                        mapReduceKeysToIntTask.result = intBinaryOperator.applyAsInt(mapReduceKeysToIntTask.result, mapReduceKeysToIntTask2.result);
                        mapReduceKeysToIntTask2 = mapReduceKeysToIntTask.rights = mapReduceKeysToIntTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongFunction<? super K> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceKeysToLongTask<K, V> rights;
        MapReduceKeysToLongTask<K, V> nextRight;

        MapReduceKeysToLongTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceKeysToLongTask<K, V> mapReduceKeysToLongTask, ToLongFunction<? super K> toLongFunction, long l, LongBinaryOperator longBinaryOperator) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceKeysToLongTask;
            this.transformer = toLongFunction;
            this.basis = l;
            this.reducer = longBinaryOperator;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator longBinaryOperator;
            ToLongFunction<K> toLongFunction = this.transformer;
            if (toLongFunction != null && (longBinaryOperator = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                long l = this.basis;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceKeysToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, toLongFunction, l, longBinaryOperator);
                    this.rights.fork();
                }
                while ((countedCompleter = this.advance()) != null) {
                    l = longBinaryOperator.applyAsLong(l, toLongFunction.applyAsLong(((Node)((Object)countedCompleter)).key));
                }
                this.result = l;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceKeysToLongTask mapReduceKeysToLongTask = (MapReduceKeysToLongTask)countedCompleter;
                    MapReduceKeysToLongTask<K, V> mapReduceKeysToLongTask2 = mapReduceKeysToLongTask.rights;
                    while (mapReduceKeysToLongTask2 != null) {
                        mapReduceKeysToLongTask.result = longBinaryOperator.applyAsLong(mapReduceKeysToLongTask.result, mapReduceKeysToLongTask2.result);
                        mapReduceKeysToLongTask2 = mapReduceKeysToLongTask.rights = mapReduceKeysToLongTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsTask<K, V, U>
    extends BulkTask<K, V, U> {
        final BiFunction<? super K, ? super V, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceMappingsTask<K, V, U> rights;
        MapReduceMappingsTask<K, V, U> nextRight;

        MapReduceMappingsTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceMappingsTask<K, V, U> mapReduceMappingsTask, BiFunction<? super K, ? super V, ? extends U> biFunction, BiFunction<? super U, ? super U, ? extends U> biFunction2) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceMappingsTask;
            this.transformer = biFunction;
            this.reducer = biFunction2;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> biFunction;
            BiFunction biFunction2 = this.transformer;
            if (biFunction2 != null && (biFunction = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceMappingsTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, biFunction2, biFunction);
                    this.rights.fork();
                }
                Object t = null;
                while ((countedCompleter = this.advance()) != null) {
                    U u = biFunction2.apply(((Node)((Object)countedCompleter)).key, ((Node)((Object)countedCompleter)).val);
                    if (u == null) continue;
                    t = t == null ? u : biFunction.apply(t, u);
                }
                this.result = t;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceMappingsTask mapReduceMappingsTask = (MapReduceMappingsTask)countedCompleter;
                    MapReduceMappingsTask<K, V, U> mapReduceMappingsTask2 = mapReduceMappingsTask.rights;
                    while (mapReduceMappingsTask2 != null) {
                        U u = mapReduceMappingsTask2.result;
                        if (u != null) {
                            U u2 = mapReduceMappingsTask.result;
                            mapReduceMappingsTask.result = u2 == null ? u : biFunction.apply(u2, u);
                        }
                        mapReduceMappingsTask2 = mapReduceMappingsTask.rights = mapReduceMappingsTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleBiFunction<? super K, ? super V> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceMappingsToDoubleTask<K, V> rights;
        MapReduceMappingsToDoubleTask<K, V> nextRight;

        MapReduceMappingsToDoubleTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceMappingsToDoubleTask<K, V> mapReduceMappingsToDoubleTask, ToDoubleBiFunction<? super K, ? super V> toDoubleBiFunction, double d, DoubleBinaryOperator doubleBinaryOperator) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceMappingsToDoubleTask;
            this.transformer = toDoubleBiFunction;
            this.basis = d;
            this.reducer = doubleBinaryOperator;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator doubleBinaryOperator;
            ToDoubleBiFunction<K, V> toDoubleBiFunction = this.transformer;
            if (toDoubleBiFunction != null && (doubleBinaryOperator = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                double d = this.basis;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceMappingsToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, toDoubleBiFunction, d, doubleBinaryOperator);
                    this.rights.fork();
                }
                while ((countedCompleter = this.advance()) != null) {
                    d = doubleBinaryOperator.applyAsDouble(d, toDoubleBiFunction.applyAsDouble(((Node)((Object)countedCompleter)).key, ((Node)((Object)countedCompleter)).val));
                }
                this.result = d;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceMappingsToDoubleTask mapReduceMappingsToDoubleTask = (MapReduceMappingsToDoubleTask)countedCompleter;
                    MapReduceMappingsToDoubleTask<K, V> mapReduceMappingsToDoubleTask2 = mapReduceMappingsToDoubleTask.rights;
                    while (mapReduceMappingsToDoubleTask2 != null) {
                        mapReduceMappingsToDoubleTask.result = doubleBinaryOperator.applyAsDouble(mapReduceMappingsToDoubleTask.result, mapReduceMappingsToDoubleTask2.result);
                        mapReduceMappingsToDoubleTask2 = mapReduceMappingsToDoubleTask.rights = mapReduceMappingsToDoubleTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntBiFunction<? super K, ? super V> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceMappingsToIntTask<K, V> rights;
        MapReduceMappingsToIntTask<K, V> nextRight;

        MapReduceMappingsToIntTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceMappingsToIntTask<K, V> mapReduceMappingsToIntTask, ToIntBiFunction<? super K, ? super V> toIntBiFunction, int n4, IntBinaryOperator intBinaryOperator) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceMappingsToIntTask;
            this.transformer = toIntBiFunction;
            this.basis = n4;
            this.reducer = intBinaryOperator;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator intBinaryOperator;
            ToIntBiFunction<K, V> toIntBiFunction = this.transformer;
            if (toIntBiFunction != null && (intBinaryOperator = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                int n3 = this.basis;
                int n4 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n4 >>> 1) > n4) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceMappingsToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, toIntBiFunction, n3, intBinaryOperator);
                    this.rights.fork();
                }
                while ((countedCompleter = this.advance()) != null) {
                    n3 = intBinaryOperator.applyAsInt(n3, toIntBiFunction.applyAsInt(((Node)((Object)countedCompleter)).key, ((Node)((Object)countedCompleter)).val));
                }
                this.result = n3;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceMappingsToIntTask mapReduceMappingsToIntTask = (MapReduceMappingsToIntTask)countedCompleter;
                    MapReduceMappingsToIntTask<K, V> mapReduceMappingsToIntTask2 = mapReduceMappingsToIntTask.rights;
                    while (mapReduceMappingsToIntTask2 != null) {
                        mapReduceMappingsToIntTask.result = intBinaryOperator.applyAsInt(mapReduceMappingsToIntTask.result, mapReduceMappingsToIntTask2.result);
                        mapReduceMappingsToIntTask2 = mapReduceMappingsToIntTask.rights = mapReduceMappingsToIntTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongBiFunction<? super K, ? super V> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceMappingsToLongTask<K, V> rights;
        MapReduceMappingsToLongTask<K, V> nextRight;

        MapReduceMappingsToLongTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceMappingsToLongTask<K, V> mapReduceMappingsToLongTask, ToLongBiFunction<? super K, ? super V> toLongBiFunction, long l, LongBinaryOperator longBinaryOperator) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceMappingsToLongTask;
            this.transformer = toLongBiFunction;
            this.basis = l;
            this.reducer = longBinaryOperator;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator longBinaryOperator;
            ToLongBiFunction<K, V> toLongBiFunction = this.transformer;
            if (toLongBiFunction != null && (longBinaryOperator = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                long l = this.basis;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceMappingsToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, toLongBiFunction, l, longBinaryOperator);
                    this.rights.fork();
                }
                while ((countedCompleter = this.advance()) != null) {
                    l = longBinaryOperator.applyAsLong(l, toLongBiFunction.applyAsLong(((Node)((Object)countedCompleter)).key, ((Node)((Object)countedCompleter)).val));
                }
                this.result = l;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceMappingsToLongTask mapReduceMappingsToLongTask = (MapReduceMappingsToLongTask)countedCompleter;
                    MapReduceMappingsToLongTask<K, V> mapReduceMappingsToLongTask2 = mapReduceMappingsToLongTask.rights;
                    while (mapReduceMappingsToLongTask2 != null) {
                        mapReduceMappingsToLongTask.result = longBinaryOperator.applyAsLong(mapReduceMappingsToLongTask.result, mapReduceMappingsToLongTask2.result);
                        mapReduceMappingsToLongTask2 = mapReduceMappingsToLongTask.rights = mapReduceMappingsToLongTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super V, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceValuesTask<K, V, U> rights;
        MapReduceValuesTask<K, V, U> nextRight;

        MapReduceValuesTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceValuesTask<K, V, U> mapReduceValuesTask, Function<? super V, ? extends U> function, BiFunction<? super U, ? super U, ? extends U> biFunction) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceValuesTask;
            this.transformer = function;
            this.reducer = biFunction;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> biFunction;
            Function<V, U> function = this.transformer;
            if (function != null && (biFunction = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceValuesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, function, biFunction);
                    this.rights.fork();
                }
                Object t = null;
                while ((countedCompleter = this.advance()) != null) {
                    U u = function.apply(((Node)((Object)countedCompleter)).val);
                    if (u == null) continue;
                    t = t == null ? u : biFunction.apply(t, u);
                }
                this.result = t;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceValuesTask mapReduceValuesTask = (MapReduceValuesTask)countedCompleter;
                    MapReduceValuesTask<K, V, U> mapReduceValuesTask2 = mapReduceValuesTask.rights;
                    while (mapReduceValuesTask2 != null) {
                        U u = mapReduceValuesTask2.result;
                        if (u != null) {
                            U u2 = mapReduceValuesTask.result;
                            mapReduceValuesTask.result = u2 == null ? u : biFunction.apply(u2, u);
                        }
                        mapReduceValuesTask2 = mapReduceValuesTask.rights = mapReduceValuesTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleFunction<? super V> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceValuesToDoubleTask<K, V> rights;
        MapReduceValuesToDoubleTask<K, V> nextRight;

        MapReduceValuesToDoubleTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceValuesToDoubleTask<K, V> mapReduceValuesToDoubleTask, ToDoubleFunction<? super V> toDoubleFunction, double d, DoubleBinaryOperator doubleBinaryOperator) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceValuesToDoubleTask;
            this.transformer = toDoubleFunction;
            this.basis = d;
            this.reducer = doubleBinaryOperator;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator doubleBinaryOperator;
            ToDoubleFunction<V> toDoubleFunction = this.transformer;
            if (toDoubleFunction != null && (doubleBinaryOperator = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                double d = this.basis;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceValuesToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, toDoubleFunction, d, doubleBinaryOperator);
                    this.rights.fork();
                }
                while ((countedCompleter = this.advance()) != null) {
                    d = doubleBinaryOperator.applyAsDouble(d, toDoubleFunction.applyAsDouble(((Node)((Object)countedCompleter)).val));
                }
                this.result = d;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceValuesToDoubleTask mapReduceValuesToDoubleTask = (MapReduceValuesToDoubleTask)countedCompleter;
                    MapReduceValuesToDoubleTask<K, V> mapReduceValuesToDoubleTask2 = mapReduceValuesToDoubleTask.rights;
                    while (mapReduceValuesToDoubleTask2 != null) {
                        mapReduceValuesToDoubleTask.result = doubleBinaryOperator.applyAsDouble(mapReduceValuesToDoubleTask.result, mapReduceValuesToDoubleTask2.result);
                        mapReduceValuesToDoubleTask2 = mapReduceValuesToDoubleTask.rights = mapReduceValuesToDoubleTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntFunction<? super V> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceValuesToIntTask<K, V> rights;
        MapReduceValuesToIntTask<K, V> nextRight;

        MapReduceValuesToIntTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceValuesToIntTask<K, V> mapReduceValuesToIntTask, ToIntFunction<? super V> toIntFunction, int n4, IntBinaryOperator intBinaryOperator) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceValuesToIntTask;
            this.transformer = toIntFunction;
            this.basis = n4;
            this.reducer = intBinaryOperator;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator intBinaryOperator;
            ToIntFunction<V> toIntFunction = this.transformer;
            if (toIntFunction != null && (intBinaryOperator = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                int n3 = this.basis;
                int n4 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n4 >>> 1) > n4) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceValuesToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, toIntFunction, n3, intBinaryOperator);
                    this.rights.fork();
                }
                while ((countedCompleter = this.advance()) != null) {
                    n3 = intBinaryOperator.applyAsInt(n3, toIntFunction.applyAsInt(((Node)((Object)countedCompleter)).val));
                }
                this.result = n3;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceValuesToIntTask mapReduceValuesToIntTask = (MapReduceValuesToIntTask)countedCompleter;
                    MapReduceValuesToIntTask<K, V> mapReduceValuesToIntTask2 = mapReduceValuesToIntTask.rights;
                    while (mapReduceValuesToIntTask2 != null) {
                        mapReduceValuesToIntTask.result = intBinaryOperator.applyAsInt(mapReduceValuesToIntTask.result, mapReduceValuesToIntTask2.result);
                        mapReduceValuesToIntTask2 = mapReduceValuesToIntTask.rights = mapReduceValuesToIntTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongFunction<? super V> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceValuesToLongTask<K, V> rights;
        MapReduceValuesToLongTask<K, V> nextRight;

        MapReduceValuesToLongTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, MapReduceValuesToLongTask<K, V> mapReduceValuesToLongTask, ToLongFunction<? super V> toLongFunction, long l, LongBinaryOperator longBinaryOperator) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = mapReduceValuesToLongTask;
            this.transformer = toLongFunction;
            this.basis = l;
            this.reducer = longBinaryOperator;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator longBinaryOperator;
            ToLongFunction<V> toLongFunction = this.transformer;
            if (toLongFunction != null && (longBinaryOperator = this.reducer) != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                long l = this.basis;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new MapReduceValuesToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, toLongFunction, l, longBinaryOperator);
                    this.rights.fork();
                }
                while ((countedCompleter = this.advance()) != null) {
                    l = longBinaryOperator.applyAsLong(l, toLongFunction.applyAsLong(((Node)((Object)countedCompleter)).val));
                }
                this.result = l;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    MapReduceValuesToLongTask mapReduceValuesToLongTask = (MapReduceValuesToLongTask)countedCompleter;
                    MapReduceValuesToLongTask<K, V> mapReduceValuesToLongTask2 = mapReduceValuesToLongTask.rights;
                    while (mapReduceValuesToLongTask2 != null) {
                        mapReduceValuesToLongTask.result = longBinaryOperator.applyAsLong(mapReduceValuesToLongTask.result, mapReduceValuesToLongTask2.result);
                        mapReduceValuesToLongTask2 = mapReduceValuesToLongTask.rights = mapReduceValuesToLongTask2.nextRight;
                    }
                }
            }
        }
    }

    static class Node<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        volatile V val;
        volatile Node<K, V> next;

        Node(int n, K k, V v, Node<K, V> node) {
            this.hash = n;
            this.key = k;
            this.val = v;
            this.next = node;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.val;
        }

        @Override
        public final int hashCode() {
            return this.key.hashCode() ^ this.val.hashCode();
        }

        public final String toString() {
            return this.key + "=" + this.val;
        }

        @Override
        public final V setValue(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean equals(Object object) {
            V v;
            Object v2;
            Map.Entry entry;
            Object k;
            return !(!(object instanceof Map.Entry) || (k = (entry = (Map.Entry)object).getKey()) == null || (v2 = entry.getValue()) == null || k != this.key && !k.equals(this.key) || v2 != (v = this.val) && !v2.equals(v));
        }

        Node<K, V> find(int n, Object object) {
            Node<K, V> node = this;
            if (object != null) {
                do {
                    K k;
                    if (node.hash != n || (k = node.key) != object && (k == null || !object.equals(k))) continue;
                    return node;
                } while ((node = node.next) != null);
            }
            return null;
        }
    }

    static final class ReduceEntriesTask<K, V>
    extends BulkTask<K, V, Map.Entry<K, V>> {
        final BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer;
        Map.Entry<K, V> result;
        ReduceEntriesTask<K, V> rights;
        ReduceEntriesTask<K, V> nextRight;

        ReduceEntriesTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, ReduceEntriesTask<K, V> reduceEntriesTask, BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> biFunction) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = reduceEntriesTask;
            this.reducer = biFunction;
        }

        @Override
        public final Map.Entry<K, V> getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, Map.Entry<K, V>> biFunction = this.reducer;
            if (biFunction != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new ReduceEntriesTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, biFunction);
                    this.rights.fork();
                }
                Node node = null;
                while ((countedCompleter = this.advance()) != null) {
                    node = node == null ? countedCompleter : biFunction.apply(node, (Map.Entry<K, V>)((Object)countedCompleter));
                }
                this.result = node;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    ReduceEntriesTask reduceEntriesTask = (ReduceEntriesTask)countedCompleter;
                    ReduceEntriesTask<K, V> reduceEntriesTask2 = reduceEntriesTask.rights;
                    while (reduceEntriesTask2 != null) {
                        Map.Entry<K, V> entry = reduceEntriesTask2.result;
                        if (entry != null) {
                            Map.Entry<K, V> entry2 = reduceEntriesTask.result;
                            reduceEntriesTask.result = entry2 == null ? entry : biFunction.apply(entry2, entry);
                        }
                        reduceEntriesTask2 = reduceEntriesTask.rights = reduceEntriesTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class ReduceKeysTask<K, V>
    extends BulkTask<K, V, K> {
        final BiFunction<? super K, ? super K, ? extends K> reducer;
        K result;
        ReduceKeysTask<K, V> rights;
        ReduceKeysTask<K, V> nextRight;

        ReduceKeysTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, ReduceKeysTask<K, V> reduceKeysTask, BiFunction<? super K, ? super K, ? extends K> biFunction) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = reduceKeysTask;
            this.reducer = biFunction;
        }

        @Override
        public final K getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<K, K, K> biFunction = this.reducer;
            if (biFunction != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new ReduceKeysTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, biFunction);
                    this.rights.fork();
                }
                Object t = null;
                while ((countedCompleter = this.advance()) != null) {
                    Object k = ((Node)((Object)countedCompleter)).key;
                    t = t == null ? k : (k == null ? t : biFunction.apply(t, k));
                }
                this.result = t;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    ReduceKeysTask reduceKeysTask = (ReduceKeysTask)countedCompleter;
                    ReduceKeysTask<K, V> reduceKeysTask2 = reduceKeysTask.rights;
                    while (reduceKeysTask2 != null) {
                        K k = reduceKeysTask2.result;
                        if (k != null) {
                            K k2 = reduceKeysTask.result;
                            reduceKeysTask.result = k2 == null ? k : biFunction.apply(k2, k);
                        }
                        reduceKeysTask2 = reduceKeysTask.rights = reduceKeysTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class ReduceValuesTask<K, V>
    extends BulkTask<K, V, V> {
        final BiFunction<? super V, ? super V, ? extends V> reducer;
        V result;
        ReduceValuesTask<K, V> rights;
        ReduceValuesTask<K, V> nextRight;

        ReduceValuesTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, ReduceValuesTask<K, V> reduceValuesTask, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.nextRight = reduceValuesTask;
            this.reducer = biFunction;
        }

        @Override
        public final V getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<V, V, V> biFunction = this.reducer;
            if (biFunction != null) {
                CountedCompleter<?> countedCompleter;
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    this.rights = new ReduceValuesTask<K, V>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, this.rights, biFunction);
                    this.rights.fork();
                }
                Object t = null;
                while ((countedCompleter = this.advance()) != null) {
                    Object v = ((Node)((Object)countedCompleter)).val;
                    t = t == null ? v : biFunction.apply(t, v);
                }
                this.result = t;
                for (countedCompleter = this.firstComplete(); countedCompleter != null; countedCompleter = countedCompleter.nextComplete()) {
                    ReduceValuesTask reduceValuesTask = (ReduceValuesTask)countedCompleter;
                    ReduceValuesTask<K, V> reduceValuesTask2 = reduceValuesTask.rights;
                    while (reduceValuesTask2 != null) {
                        V v = reduceValuesTask2.result;
                        if (v != null) {
                            V v2 = reduceValuesTask.result;
                            reduceValuesTask.result = v2 == null ? v : biFunction.apply(v2, v);
                        }
                        reduceValuesTask2 = reduceValuesTask.rights = reduceValuesTask2.nextRight;
                    }
                }
            }
        }
    }

    static final class ReservationNode<K, V>
    extends Node<K, V> {
        ReservationNode() {
            super(-3, null, null, null);
        }

        @Override
        Node<K, V> find(int n, Object object) {
            return null;
        }
    }

    static final class SearchEntriesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<Map.Entry<K, V>, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchEntriesTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, Function<Map.Entry<K, V>, ? extends U> function, AtomicReference<U> atomicReference) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.searchFunction = function;
            this.result = atomicReference;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> atomicReference;
            Function<Map.Entry<K, V>, U> function = this.searchFunction;
            if (function != null && (atomicReference = this.result) != null) {
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    if (atomicReference.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    new SearchEntriesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, function, atomicReference).fork();
                }
                while (atomicReference.get() == null) {
                    Node node = this.advance();
                    if (node == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = function.apply(node);
                    if (u == null) continue;
                    if (atomicReference.compareAndSet(null, u)) {
                        this.quietlyCompleteRoot();
                    }
                    return;
                }
            }
        }
    }

    static final class SearchKeysTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super K, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchKeysTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, Function<? super K, ? extends U> function, AtomicReference<U> atomicReference) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.searchFunction = function;
            this.result = atomicReference;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> atomicReference;
            Function<K, U> function = this.searchFunction;
            if (function != null && (atomicReference = this.result) != null) {
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    if (atomicReference.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    new SearchKeysTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, function, atomicReference).fork();
                }
                while (atomicReference.get() == null) {
                    Node node = this.advance();
                    if (node == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = function.apply(node.key);
                    if (u == null) continue;
                    if (!atomicReference.compareAndSet(null, u)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class SearchMappingsTask<K, V, U>
    extends BulkTask<K, V, U> {
        final BiFunction<? super K, ? super V, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchMappingsTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, BiFunction<? super K, ? super V, ? extends U> biFunction, AtomicReference<U> atomicReference) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.searchFunction = biFunction;
            this.result = atomicReference;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> atomicReference;
            BiFunction biFunction = this.searchFunction;
            if (biFunction != null && (atomicReference = this.result) != null) {
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    if (atomicReference.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    new SearchMappingsTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, biFunction, atomicReference).fork();
                }
                while (atomicReference.get() == null) {
                    Node node = this.advance();
                    if (node == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = biFunction.apply(node.key, node.val);
                    if (u == null) continue;
                    if (!atomicReference.compareAndSet(null, u)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class SearchValuesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super V, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchValuesTask(BulkTask<K, V, ?> bulkTask, int n, int n2, int n3, Node<K, V>[] nodeArray, Function<? super V, ? extends U> function, AtomicReference<U> atomicReference) {
            super(bulkTask, n, n2, n3, nodeArray);
            this.searchFunction = function;
            this.result = atomicReference;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> atomicReference;
            Function<V, U> function = this.searchFunction;
            if (function != null && (atomicReference = this.result) != null) {
                int n;
                int n2;
                int n3 = this.baseIndex;
                while (this.batch > 0 && (n2 = (n = this.baseLimit) + n3 >>> 1) > n3) {
                    if (atomicReference.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = n2;
                    new SearchValuesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, n, this.tab, function, atomicReference).fork();
                }
                while (atomicReference.get() == null) {
                    Node node = this.advance();
                    if (node == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = function.apply(node.val);
                    if (u == null) continue;
                    if (!atomicReference.compareAndSet(null, u)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        final float loadFactor;

        Segment(float f) {
            this.loadFactor = f;
        }
    }

    static final class TableStack<K, V> {
        int length;
        int index;
        Node<K, V>[] tab;
        TableStack<K, V> next;

        TableStack() {
        }
    }

    static class Traverser<K, V> {
        Node<K, V>[] tab;
        Node<K, V> next;
        TableStack<K, V> stack;
        TableStack<K, V> spare;
        int index;
        int baseIndex;
        int baseLimit;
        final int baseSize;

        Traverser(Node<K, V>[] nodeArray, int n, int n2, int n3) {
            this.tab = nodeArray;
            this.baseSize = n;
            this.baseIndex = this.index = n2;
            this.baseLimit = n3;
            this.next = null;
        }

        final Node<K, V> advance() {
            Node<K, V> node = this.next;
            if (node != null) {
                node = node.next;
            }
            while (true) {
                int n;
                int n2;
                Node<K, V>[] nodeArray;
                block10: {
                    block9: {
                        if (node != null) {
                            this.next = node;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        nodeArray = this.tab;
                        if (this.tab != null && (n2 = nodeArray.length) > (n = this.index) && n >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                node = ConcurrentHashMap.tabAt(nodeArray, n);
                if (node != null && node.hash < 0) {
                    if (node instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)node).nextTable;
                        node = null;
                        this.pushState(nodeArray, n, n2);
                        continue;
                    }
                    node = node instanceof TreeBin ? ((TreeBin)node).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n2);
                    continue;
                }
                this.index = n + this.baseSize;
                if (this.index < n2) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(Node<K, V>[] nodeArray, int n, int n2) {
            TableStack<K, V> tableStack = this.spare;
            if (tableStack != null) {
                this.spare = tableStack.next;
            } else {
                tableStack = new TableStack();
            }
            tableStack.tab = nodeArray;
            tableStack.length = n2;
            tableStack.index = n;
            tableStack.next = this.stack;
            this.stack = tableStack;
        }

        private void recoverState(int n) {
            int n2;
            TableStack<K, V> tableStack;
            while ((tableStack = this.stack) != null && (this.index += (n2 = tableStack.length)) >= n) {
                n = n2;
                this.index = tableStack.index;
                this.tab = tableStack.tab;
                tableStack.tab = null;
                TableStack tableStack2 = tableStack.next;
                tableStack.next = this.spare;
                this.stack = tableStack2;
                this.spare = tableStack;
            }
            if (tableStack == null && (this.index += this.baseSize) >= n) {
                this.index = ++this.baseIndex;
            }
        }
    }

    static final class TreeBin<K, V>
    extends Node<K, V> {
        TreeNode<K, V> root;
        volatile TreeNode<K, V> first;
        volatile Thread waiter;
        volatile int lockState;
        static final int WRITER = 1;
        static final int WAITER = 2;
        static final int READER = 4;
        private static final Unsafe U;
        private static final long LOCKSTATE;
        private static final long WAITERTHREAD;

        static int tieBreakOrder(Object object, Object object2) {
            int n;
            if (object == null || object2 == null || (n = object.getClass().getName().compareTo(object2.getClass().getName())) == 0) {
                n = System.identityHashCode(object) <= System.identityHashCode(object2) ? -1 : 1;
            }
            return n;
        }

        TreeBin(TreeNode<K, V> treeNode) {
            super(-2, null, null, null);
            this.first = treeNode;
            TreeNode treeNode2 = null;
            TreeNode treeNode3 = treeNode;
            while (treeNode3 != null) {
                TreeNode treeNode4 = (TreeNode)treeNode3.next;
                treeNode3.right = null;
                treeNode3.left = null;
                if (treeNode2 == null) {
                    treeNode3.parent = null;
                    treeNode3.red = false;
                    treeNode2 = treeNode3;
                } else {
                    TreeNode treeNode5;
                    int n;
                    Object object = treeNode3.key;
                    int n2 = treeNode3.hash;
                    Class<?> clazz = null;
                    TreeNode treeNode6 = treeNode2;
                    do {
                        Object object2 = treeNode6.key;
                        int n3 = treeNode6.hash;
                        if (n3 > n2) {
                            n = -1;
                        } else if (n3 < n2) {
                            n = 1;
                        } else if (clazz == null && (clazz = ConcurrentHashMap.comparableClassFor(object)) == null || (n = ConcurrentHashMap.compareComparables(clazz, object, object2)) == 0) {
                            n = TreeBin.tieBreakOrder(object, object2);
                        }
                        treeNode5 = treeNode6;
                    } while ((treeNode6 = n <= 0 ? treeNode6.left : treeNode6.right) != null);
                    treeNode3.parent = treeNode5;
                    if (n <= 0) {
                        treeNode5.left = treeNode3;
                    } else {
                        treeNode5.right = treeNode3;
                    }
                    treeNode2 = TreeBin.balanceInsertion(treeNode2, treeNode3);
                }
                treeNode3 = treeNode4;
            }
            this.root = treeNode2;
            assert (TreeBin.checkInvariants(this.root));
        }

        private final void lockRoot() {
            if (!U.compareAndSwapInt(this, LOCKSTATE, 0, 1)) {
                this.contendedLock();
            }
        }

        private final void unlockRoot() {
            this.lockState = 0;
        }

        private final void contendedLock() {
            Thread thread = Thread.currentThread();
            while (true) {
                int n;
                if (((n = this.lockState) & 0xFFFFFFFD) == 0) {
                    if (!U.compareAndSwapInt(this, LOCKSTATE, n, 1)) continue;
                    if (this.waiter == thread) {
                        U.compareAndSwapObject(this, WAITERTHREAD, thread, null);
                    }
                    return;
                }
                if ((n & 2) == 0) {
                    U.compareAndSwapInt(this, LOCKSTATE, n, n | 2);
                    continue;
                }
                Thread thread2 = this.waiter;
                if (thread2 == null) {
                    U.compareAndSwapObject(this, WAITERTHREAD, null, thread);
                    continue;
                }
                if (thread2 != thread) continue;
                LockSupport.park(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final Node<K, V> find(int n, Object object) {
            if (object != null) {
                Node node = this.first;
                while (node != null) {
                    TreeNode<K, V> treeNode;
                    int n2 = this.lockState;
                    if ((n2 & 3) != 0) {
                        Object k;
                        if (node.hash == n && ((k = node.key) == object || k != null && object.equals(k))) {
                            return node;
                        }
                        node = node.next;
                        continue;
                    }
                    if (!U.compareAndSwapInt(this, LOCKSTATE, n2, n2 + 4)) continue;
                    try {
                        TreeNode<K, V> treeNode2 = this.root;
                        treeNode = treeNode2 == null ? null : treeNode2.findTreeNode(n, object, null);
                    }
                    finally {
                        Thread thread;
                        if (U.getAndAddInt(this, LOCKSTATE, -4) == 6 && (thread = this.waiter) != null) {
                            LockSupport.unpark(thread);
                        }
                    }
                    return treeNode;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final TreeNode<K, V> putTreeVal(int n, K k, V v) {
            block19: {
                TreeNode<K, V> treeNode;
                TreeNode<K, V> treeNode2;
                int n2;
                Class<?> clazz = null;
                boolean bl = false;
                TreeNode<K, V> treeNode3 = this.root;
                do {
                    if (treeNode3 == null) {
                        this.root = new TreeNode<K, V>(n, k, v, null, null);
                        this.first = this.root;
                        break block19;
                    }
                    int n3 = treeNode3.hash;
                    if (n3 > n) {
                        n2 = -1;
                    } else if (n3 < n) {
                        n2 = 1;
                    } else {
                        Object object = treeNode3.key;
                        if (object == k || object != null && k.equals(object)) {
                            return treeNode3;
                        }
                        if (clazz == null && (clazz = ConcurrentHashMap.comparableClassFor(k)) == null || (n2 = ConcurrentHashMap.compareComparables(clazz, k, object)) == 0) {
                            if (!bl) {
                                bl = true;
                                treeNode2 = treeNode3.left;
                                if (treeNode2 != null && (treeNode = treeNode2.findTreeNode(n, k, clazz)) != null || (treeNode2 = treeNode3.right) != null && (treeNode = treeNode2.findTreeNode(n, k, clazz)) != null) {
                                    return treeNode;
                                }
                            }
                            n2 = TreeBin.tieBreakOrder(k, object);
                        }
                    }
                    treeNode = treeNode3;
                } while ((treeNode3 = n2 <= 0 ? treeNode3.left : treeNode3.right) != null);
                TreeNode<K, V> treeNode4 = this.first;
                treeNode2 = new TreeNode<K, V>(n, k, v, treeNode4, treeNode);
                this.first = treeNode2;
                if (treeNode4 != null) {
                    treeNode4.prev = treeNode2;
                }
                if (n2 <= 0) {
                    treeNode.left = treeNode2;
                } else {
                    treeNode.right = treeNode2;
                }
                if (!treeNode.red) {
                    treeNode2.red = true;
                } else {
                    this.lockRoot();
                    try {
                        this.root = TreeBin.balanceInsertion(this.root, treeNode2);
                    }
                    finally {
                        this.unlockRoot();
                    }
                }
            }
            assert (TreeBin.checkInvariants(this.root));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean removeTreeNode(TreeNode<K, V> treeNode) {
            TreeNode treeNode2;
            TreeNode treeNode3 = (TreeNode)treeNode.next;
            TreeNode treeNode4 = treeNode.prev;
            if (treeNode4 == null) {
                this.first = treeNode3;
            } else {
                treeNode4.next = treeNode3;
            }
            if (treeNode3 != null) {
                treeNode3.prev = treeNode4;
            }
            if (this.first == null) {
                this.root = null;
                return true;
            }
            TreeNode<K, V> treeNode5 = this.root;
            if (treeNode5 == null || treeNode5.right == null || (treeNode2 = treeNode5.left) == null || treeNode2.left == null) {
                return true;
            }
            this.lockRoot();
            try {
                TreeNode treeNode6;
                TreeNode treeNode7;
                TreeNode treeNode8 = treeNode.left;
                TreeNode treeNode9 = treeNode.right;
                if (treeNode8 != null && treeNode9 != null) {
                    TreeNode treeNode10;
                    treeNode7 = treeNode9;
                    while ((treeNode10 = treeNode7.left) != null) {
                        treeNode7 = treeNode10;
                    }
                    boolean bl = treeNode7.red;
                    treeNode7.red = treeNode.red;
                    treeNode.red = bl;
                    TreeNode treeNode11 = treeNode7.right;
                    TreeNode treeNode12 = treeNode.parent;
                    if (treeNode7 == treeNode9) {
                        treeNode.parent = treeNode7;
                        treeNode7.right = treeNode;
                    } else {
                        TreeNode treeNode13 = treeNode7.parent;
                        treeNode.parent = treeNode13;
                        if (treeNode.parent != null) {
                            if (treeNode7 == treeNode13.left) {
                                treeNode13.left = treeNode;
                            } else {
                                treeNode13.right = treeNode;
                            }
                        }
                        if ((treeNode7.right = treeNode9) != null) {
                            treeNode9.parent = treeNode7;
                        }
                    }
                    treeNode.left = null;
                    treeNode.right = treeNode11;
                    if (treeNode.right != null) {
                        treeNode11.parent = treeNode;
                    }
                    if ((treeNode7.left = treeNode8) != null) {
                        treeNode8.parent = treeNode7;
                    }
                    if ((treeNode7.parent = treeNode12) == null) {
                        treeNode5 = treeNode7;
                    } else if (treeNode == treeNode12.left) {
                        treeNode12.left = treeNode7;
                    } else {
                        treeNode12.right = treeNode7;
                    }
                    treeNode6 = treeNode11 != null ? treeNode11 : treeNode;
                } else {
                    treeNode6 = treeNode8 != null ? treeNode8 : (treeNode9 != null ? treeNode9 : treeNode);
                }
                if (treeNode6 != treeNode) {
                    treeNode6.parent = treeNode.parent;
                    treeNode7 = treeNode6.parent;
                    if (treeNode7 == null) {
                        treeNode5 = treeNode6;
                    } else if (treeNode == treeNode7.left) {
                        treeNode7.left = treeNode6;
                    } else {
                        treeNode7.right = treeNode6;
                    }
                    treeNode.parent = null;
                    treeNode.right = null;
                    treeNode.left = null;
                }
                TreeNode<K, V> treeNode14 = this.root = treeNode.red ? treeNode5 : TreeBin.balanceDeletion(treeNode5, treeNode6);
                if (treeNode == treeNode6 && (treeNode7 = treeNode.parent) != null) {
                    if (treeNode == treeNode7.left) {
                        treeNode7.left = null;
                    } else if (treeNode == treeNode7.right) {
                        treeNode7.right = null;
                    }
                    treeNode.parent = null;
                }
            }
            finally {
                this.unlockRoot();
            }
            assert (TreeBin.checkInvariants(this.root));
            return false;
        }

        static <K, V> TreeNode<K, V> rotateLeft(TreeNode<K, V> treeNode, TreeNode<K, V> treeNode2) {
            TreeNode treeNode3;
            if (treeNode2 != null && (treeNode3 = treeNode2.right) != null) {
                treeNode2.right = treeNode3.left;
                TreeNode treeNode4 = treeNode2.right;
                if (treeNode2.right != null) {
                    treeNode4.parent = treeNode2;
                }
                TreeNode treeNode5 = treeNode3.parent = treeNode2.parent;
                if (treeNode3.parent == null) {
                    treeNode = treeNode3;
                    treeNode3.red = false;
                } else if (treeNode5.left == treeNode2) {
                    treeNode5.left = treeNode3;
                } else {
                    treeNode5.right = treeNode3;
                }
                treeNode3.left = treeNode2;
                treeNode2.parent = treeNode3;
            }
            return treeNode;
        }

        static <K, V> TreeNode<K, V> rotateRight(TreeNode<K, V> treeNode, TreeNode<K, V> treeNode2) {
            TreeNode treeNode3;
            if (treeNode2 != null && (treeNode3 = treeNode2.left) != null) {
                treeNode2.left = treeNode3.right;
                TreeNode treeNode4 = treeNode2.left;
                if (treeNode2.left != null) {
                    treeNode4.parent = treeNode2;
                }
                TreeNode treeNode5 = treeNode3.parent = treeNode2.parent;
                if (treeNode3.parent == null) {
                    treeNode = treeNode3;
                    treeNode3.red = false;
                } else if (treeNode5.right == treeNode2) {
                    treeNode5.right = treeNode3;
                } else {
                    treeNode5.left = treeNode3;
                }
                treeNode3.right = treeNode2;
                treeNode2.parent = treeNode3;
            }
            return treeNode;
        }

        static <K, V> TreeNode<K, V> balanceInsertion(TreeNode<K, V> treeNode, TreeNode<K, V> treeNode2) {
            treeNode2.red = true;
            while (true) {
                TreeNode treeNode3;
                TreeNode treeNode4;
                if ((treeNode4 = treeNode2.parent) == null) {
                    treeNode2.red = false;
                    return treeNode2;
                }
                if (!treeNode4.red || (treeNode3 = treeNode4.parent) == null) {
                    return treeNode;
                }
                TreeNode treeNode5 = treeNode3.left;
                if (treeNode4 == treeNode5) {
                    TreeNode treeNode6 = treeNode3.right;
                    if (treeNode6 != null && treeNode6.red) {
                        treeNode6.red = false;
                        treeNode4.red = false;
                        treeNode3.red = true;
                        treeNode2 = treeNode3;
                        continue;
                    }
                    if (treeNode2 == treeNode4.right) {
                        treeNode2 = treeNode4;
                        treeNode = TreeBin.rotateLeft(treeNode, treeNode2);
                        treeNode4 = treeNode2.parent;
                        TreeNode treeNode7 = treeNode3 = treeNode4 == null ? null : treeNode4.parent;
                    }
                    if (treeNode4 == null) continue;
                    treeNode4.red = false;
                    if (treeNode3 == null) continue;
                    treeNode3.red = true;
                    treeNode = TreeBin.rotateRight(treeNode, treeNode3);
                    continue;
                }
                if (treeNode5 != null && treeNode5.red) {
                    treeNode5.red = false;
                    treeNode4.red = false;
                    treeNode3.red = true;
                    treeNode2 = treeNode3;
                    continue;
                }
                if (treeNode2 == treeNode4.left) {
                    treeNode2 = treeNode4;
                    treeNode = TreeBin.rotateRight(treeNode, treeNode2);
                    treeNode4 = treeNode2.parent;
                    TreeNode treeNode8 = treeNode3 = treeNode4 == null ? null : treeNode4.parent;
                }
                if (treeNode4 == null) continue;
                treeNode4.red = false;
                if (treeNode3 == null) continue;
                treeNode3.red = true;
                treeNode = TreeBin.rotateLeft(treeNode, treeNode3);
            }
        }

        static <K, V> TreeNode<K, V> balanceDeletion(TreeNode<K, V> treeNode, TreeNode<K, V> treeNode2) {
            while (treeNode2 != null && treeNode2 != treeNode) {
                TreeNode treeNode3;
                TreeNode treeNode4;
                TreeNode treeNode5 = treeNode2.parent;
                if (treeNode5 == null) {
                    treeNode2.red = false;
                    return treeNode2;
                }
                if (treeNode2.red) {
                    treeNode2.red = false;
                    return treeNode;
                }
                TreeNode treeNode6 = treeNode5.left;
                if (treeNode6 == treeNode2) {
                    TreeNode treeNode7 = treeNode5.right;
                    if (treeNode7 != null && treeNode7.red) {
                        treeNode7.red = false;
                        treeNode5.red = true;
                        treeNode = TreeBin.rotateLeft(treeNode, treeNode5);
                        treeNode5 = treeNode2.parent;
                        TreeNode treeNode8 = treeNode7 = treeNode5 == null ? null : treeNode5.right;
                    }
                    if (treeNode7 == null) {
                        treeNode2 = treeNode5;
                        continue;
                    }
                    treeNode4 = treeNode7.left;
                    treeNode3 = treeNode7.right;
                    if (!(treeNode3 != null && treeNode3.red || treeNode4 != null && treeNode4.red)) {
                        treeNode7.red = true;
                        treeNode2 = treeNode5;
                        continue;
                    }
                    if (treeNode3 == null || !treeNode3.red) {
                        if (treeNode4 != null) {
                            treeNode4.red = false;
                        }
                        treeNode7.red = true;
                        treeNode = TreeBin.rotateRight(treeNode, treeNode7);
                        treeNode5 = treeNode2.parent;
                        TreeNode treeNode9 = treeNode7 = treeNode5 == null ? null : treeNode5.right;
                    }
                    if (treeNode7 != null) {
                        treeNode7.red = treeNode5 == null ? false : treeNode5.red;
                        treeNode3 = treeNode7.right;
                        if (treeNode3 != null) {
                            treeNode3.red = false;
                        }
                    }
                    if (treeNode5 != null) {
                        treeNode5.red = false;
                        treeNode = TreeBin.rotateLeft(treeNode, treeNode5);
                    }
                    treeNode2 = treeNode;
                    continue;
                }
                if (treeNode6 != null && treeNode6.red) {
                    treeNode6.red = false;
                    treeNode5.red = true;
                    treeNode = TreeBin.rotateRight(treeNode, treeNode5);
                    treeNode5 = treeNode2.parent;
                    TreeNode treeNode10 = treeNode6 = treeNode5 == null ? null : treeNode5.left;
                }
                if (treeNode6 == null) {
                    treeNode2 = treeNode5;
                    continue;
                }
                treeNode4 = treeNode6.left;
                treeNode3 = treeNode6.right;
                if (!(treeNode4 != null && treeNode4.red || treeNode3 != null && treeNode3.red)) {
                    treeNode6.red = true;
                    treeNode2 = treeNode5;
                    continue;
                }
                if (treeNode4 == null || !treeNode4.red) {
                    if (treeNode3 != null) {
                        treeNode3.red = false;
                    }
                    treeNode6.red = true;
                    treeNode = TreeBin.rotateLeft(treeNode, treeNode6);
                    treeNode5 = treeNode2.parent;
                    TreeNode treeNode11 = treeNode6 = treeNode5 == null ? null : treeNode5.left;
                }
                if (treeNode6 != null) {
                    treeNode6.red = treeNode5 == null ? false : treeNode5.red;
                    treeNode4 = treeNode6.left;
                    if (treeNode4 != null) {
                        treeNode4.red = false;
                    }
                }
                if (treeNode5 != null) {
                    treeNode5.red = false;
                    treeNode = TreeBin.rotateRight(treeNode, treeNode5);
                }
                treeNode2 = treeNode;
            }
            return treeNode;
        }

        static <K, V> boolean checkInvariants(TreeNode<K, V> treeNode) {
            TreeNode treeNode2 = treeNode.parent;
            TreeNode treeNode3 = treeNode.left;
            TreeNode treeNode4 = treeNode.right;
            TreeNode treeNode5 = treeNode.prev;
            TreeNode treeNode6 = (TreeNode)treeNode.next;
            if (treeNode5 != null && treeNode5.next != treeNode) {
                return false;
            }
            if (treeNode6 != null && treeNode6.prev != treeNode) {
                return false;
            }
            if (treeNode2 != null && treeNode != treeNode2.left && treeNode != treeNode2.right) {
                return false;
            }
            if (treeNode3 != null && (treeNode3.parent != treeNode || treeNode3.hash > treeNode.hash)) {
                return false;
            }
            if (treeNode4 != null && (treeNode4.parent != treeNode || treeNode4.hash < treeNode.hash)) {
                return false;
            }
            if (treeNode.red && treeNode3 != null && treeNode3.red && treeNode4 != null && treeNode4.red) {
                return false;
            }
            if (treeNode3 != null && !TreeBin.checkInvariants(treeNode3)) {
                return false;
            }
            return treeNode4 == null || TreeBin.checkInvariants(treeNode4);
        }

        static {
            try {
                U = Unsafe.getUnsafe();
                Class<TreeBin> clazz = TreeBin.class;
                LOCKSTATE = U.objectFieldOffset(clazz.getDeclaredField("lockState"));
                WAITERTHREAD = U.objectFieldOffset(clazz.getDeclaredField("waiter"));
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
    }

    static final class TreeNode<K, V>
    extends Node<K, V> {
        TreeNode<K, V> parent;
        TreeNode<K, V> left;
        TreeNode<K, V> right;
        TreeNode<K, V> prev;
        boolean red;

        TreeNode(int n, K k, V v, Node<K, V> node, TreeNode<K, V> treeNode) {
            super(n, k, v, node);
            this.parent = treeNode;
        }

        @Override
        Node<K, V> find(int n, Object object) {
            return this.findTreeNode(n, object, null);
        }

        final TreeNode<K, V> findTreeNode(int n, Object object, Class<?> clazz) {
            if (object != null) {
                TreeNode<K, V> treeNode = this;
                do {
                    int n2;
                    TreeNode<K, V> treeNode2 = treeNode.left;
                    TreeNode<K, V> treeNode3 = treeNode.right;
                    int n3 = treeNode.hash;
                    if (n3 > n) {
                        treeNode = treeNode2;
                        continue;
                    }
                    if (n3 < n) {
                        treeNode = treeNode3;
                        continue;
                    }
                    Object object2 = treeNode.key;
                    if (object2 == object || object2 != null && object.equals(object2)) {
                        return treeNode;
                    }
                    if (treeNode2 == null) {
                        treeNode = treeNode3;
                        continue;
                    }
                    if (treeNode3 == null) {
                        treeNode = treeNode2;
                        continue;
                    }
                    if ((clazz != null || (clazz = ConcurrentHashMap.comparableClassFor(object)) != null) && (n2 = ConcurrentHashMap.compareComparables(clazz, object, object2)) != 0) {
                        treeNode = n2 < 0 ? treeNode2 : treeNode3;
                        continue;
                    }
                    TreeNode<K, V> treeNode4 = treeNode3.findTreeNode(n, object, clazz);
                    if (treeNode4 != null) {
                        return treeNode4;
                    }
                    treeNode = treeNode2;
                } while (treeNode != null);
            }
            return null;
        }
    }

    static final class ValueIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator(Node<K, V>[] nodeArray, int n, int n2, int n3, ConcurrentHashMap<K, V> concurrentHashMap) {
            super(nodeArray, n, n2, n3, concurrentHashMap);
        }

        @Override
        public final V next() {
            Node node = this.next;
            if (node == null) {
                throw new NoSuchElementException();
            }
            Object v = node.val;
            this.lastReturned = node;
            this.advance();
            return v;
        }

        @Override
        public final V nextElement() {
            return this.next();
        }
    }

    static final class ValueSpliterator<K, V>
    extends Traverser<K, V>
    implements Spliterator<V> {
        long est;

        ValueSpliterator(Node<K, V>[] nodeArray, int n, int n2, int n3, long l) {
            super(nodeArray, n, n2, n3);
            this.est = l;
        }

        @Override
        public Spliterator<V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            int n = this.baseIndex;
            int n2 = this.baseLimit;
            int n3 = n + n2 >>> 1;
            if (n3 <= n) {
                valueSpliterator = null;
            } else {
                this.baseLimit = n3;
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.tab, this.baseSize, this.baseLimit, n2, this.est >>>= 1);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> consumer) {
            Node node;
            if (consumer == null) {
                throw new NullPointerException();
            }
            while ((node = this.advance()) != null) {
                consumer.accept(node.val);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Node node = this.advance();
            if (node == null) {
                return false;
            }
            consumer.accept(node.val);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4352;
        }
    }

    static final class ValuesView<K, V>
    extends CollectionView<K, V, V>
    implements Collection<V>,
    Serializable {
        private static final long serialVersionUID = 2249069246763182397L;

        ValuesView(ConcurrentHashMap<K, V> concurrentHashMap) {
            super(concurrentHashMap);
        }

        @Override
        public final boolean contains(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public final boolean remove(Object object) {
            if (object != null) {
                Iterator<V> iterator = this.iterator();
                while (iterator.hasNext()) {
                    if (!object.equals(iterator.next())) continue;
                    iterator.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public final Iterator<V> iterator() {
            ConcurrentHashMap concurrentHashMap = this.map;
            Node<K, V>[] nodeArray = concurrentHashMap.table;
            int n = concurrentHashMap.table == null ? 0 : nodeArray.length;
            return new ValueIterator(nodeArray, n, 0, n, concurrentHashMap);
        }

        @Override
        public final boolean add(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Spliterator<V> spliterator() {
            ConcurrentHashMap concurrentHashMap = this.map;
            long l = concurrentHashMap.sumCount();
            Node<K, V>[] nodeArray = concurrentHashMap.table;
            int n = concurrentHashMap.table == null ? 0 : nodeArray.length;
            return new ValueSpliterator(nodeArray, n, 0, n, l < 0L ? 0L : l);
        }

        @Override
        public void forEach(Consumer<? super V> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] nodeArray = this.map.table;
            if (this.map.table != null) {
                Node node;
                Traverser traverser = new Traverser(nodeArray, nodeArray.length, 0, nodeArray.length);
                while ((node = traverser.advance()) != null) {
                    consumer.accept(node.val);
                }
            }
        }
    }
}

