/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.PatternSyntaxException;
import javax.crypto.spec.DHParameterSpec;
import sun.security.action.GetPropertyAction;
import sun.security.util.Debug;
import sun.security.util.KnownOIDs;
import sun.security.util.SafeDHParameterSpec;

public final class SecurityProviderConstants {
    private static final Debug debug;
    private static final ConcurrentHashMap<String, List<String>> aliasesMap;
    public static final int DEF_DSA_KEY_SIZE;
    public static final int DEF_RSA_KEY_SIZE;
    public static final int DEF_RSASSA_PSS_KEY_SIZE;
    public static final int DEF_DH_KEY_SIZE;
    public static final int DEF_EC_KEY_SIZE;
    private static final String KEY_LENGTH_PROP = "jdk.security.defaultKeySize";

    private SecurityProviderConstants() {
    }

    private static List<String> store(String string, KnownOIDs knownOIDs, String ... stringArray) {
        ArrayList<String> arrayList;
        if (knownOIDs == null && stringArray.length != 0) {
            arrayList = Arrays.asList(stringArray);
        } else {
            arrayList = new ArrayList();
            if (knownOIDs != null) {
                arrayList.add("OID." + knownOIDs.value());
                arrayList.add(knownOIDs.value());
                String[] stringArray2 = knownOIDs.aliases();
                if (stringArray2 != null) {
                    String[] stringArray3 = stringArray2;
                    int n = stringArray3.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray3[i];
                        arrayList.add(string2);
                    }
                }
            }
            for (String string3 : stringArray) {
                arrayList.add(string3);
            }
        }
        aliasesMap.put(string, arrayList);
        return arrayList;
    }

    public static List<String> getAliases(String string) {
        List<String> list = aliasesMap.get(string);
        if (list == null) {
            KnownOIDs knownOIDs = KnownOIDs.findMatch(string);
            if (knownOIDs != null) {
                return SecurityProviderConstants.store(string, knownOIDs, new String[0]);
            }
            ProviderException providerException = new ProviderException("Cannot find aliases for " + string);
            throw providerException;
        }
        return list;
    }

    public static final int getDefDSASubprimeSize(int n) {
        if (n <= 1024) {
            return 160;
        }
        if (n == 2048) {
            return 224;
        }
        if (n == 3072) {
            return 256;
        }
        throw new InvalidParameterException("Invalid DSA Prime Size: " + n);
    }

    public static final int getDefDHPrivateExpSize(DHParameterSpec dHParameterSpec) {
        int n = dHParameterSpec.getP().bitLength();
        if (dHParameterSpec instanceof SafeDHParameterSpec) {
            if (n >= 15360) {
                return 512;
            }
            if (n >= 8192) {
                return 400;
            }
            if (n >= 7680) {
                return 384;
            }
            if (n >= 6144) {
                return 352;
            }
            if (n >= 4096) {
                return 304;
            }
            if (n >= 3072) {
                return 256;
            }
            if (n >= 2048) {
                return 224;
            }
            return 160;
        }
        return Math.max(n >= 2048 ? 1024 : n >> 1, 384);
    }

    static {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        block17: {
            debug = Debug.getInstance("jca", "ProviderConfig");
            String string = GetPropertyAction.privilegedGetProperty(KEY_LENGTH_PROP);
            n5 = 2048;
            n3 = n4 = 2048;
            n2 = 2048;
            n = 256;
            if (string != null) {
                try {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split(",")) {
                        String[] stringArray2 = string2.split(":");
                        if (stringArray2.length != 2) {
                            if (debug == null) continue;
                            debug.println("Ignoring invalid pair in jdk.security.defaultKeySize property: " + string2);
                            continue;
                        }
                        String string3 = stringArray2[0].trim().toUpperCase();
                        int n6 = -1;
                        try {
                            n6 = Integer.parseInt(stringArray2[1].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (debug == null) continue;
                            debug.println("Ignoring invalid value in jdk.security.defaultKeySize property: " + string2);
                            continue;
                        }
                        if (string3.equals("DSA")) {
                            n5 = n6;
                        } else if (string3.equals("RSA")) {
                            n4 = n6;
                        } else if (string3.equals("RSASSA-PSS")) {
                            n3 = n6;
                        } else if (string3.equals("DH")) {
                            n2 = n6;
                        } else if (string3.equals("EC")) {
                            n = n6;
                        } else {
                            if (debug == null) continue;
                            debug.println("Ignoring unsupported algo in jdk.security.defaultKeySize property: " + string2);
                            continue;
                        }
                        if (debug == null) continue;
                        debug.println("Overriding default " + string3 + " keysize with value from " + KEY_LENGTH_PROP + " property: " + n6);
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    if (debug == null) break block17;
                    debug.println("Unexpected exception while parsing jdk.security.defaultKeySize property: " + patternSyntaxException);
                }
            }
        }
        DEF_DSA_KEY_SIZE = n5;
        DEF_RSA_KEY_SIZE = n4;
        DEF_RSASSA_PSS_KEY_SIZE = n3;
        DEF_DH_KEY_SIZE = n2;
        DEF_EC_KEY_SIZE = n;
        aliasesMap = new ConcurrentHashMap();
        SecurityProviderConstants.store("SHA1withDSA", KnownOIDs.SHA1withDSA, KnownOIDs.OIW_JDK_SHA1withDSA.value(), KnownOIDs.OIW_SHA1withDSA.value(), "DSA", "SHA/DSA", "SHA-1/DSA", "SHA1/DSA", "SHAwithDSA", "DSAWithSHA1");
        SecurityProviderConstants.store("DSA", KnownOIDs.DSA, KnownOIDs.OIW_DSA.value());
        SecurityProviderConstants.store("SHA1withRSA", KnownOIDs.SHA1withRSA, KnownOIDs.OIW_SHA1withRSA.value());
        SecurityProviderConstants.store("SHA-1", KnownOIDs.SHA_1, new String[0]);
        SecurityProviderConstants.store("PBEWithMD5AndDES", KnownOIDs.PBEWithMD5AndDES, "PBE");
        SecurityProviderConstants.store("DiffieHellman", KnownOIDs.DiffieHellman, new String[0]);
        SecurityProviderConstants.store("AES", KnownOIDs.AES, "Rijndael");
        SecurityProviderConstants.store("EC", KnownOIDs.EC, "EllipticCurve");
        SecurityProviderConstants.store("X.509", null, "X509");
        SecurityProviderConstants.store("NONEwithDSA", null, "RawDSA");
        SecurityProviderConstants.store("DESede", null, "TripleDES");
        SecurityProviderConstants.store("ARCFOUR", KnownOIDs.ARCFOUR, new String[0]);
        SecurityProviderConstants.store("PKCS1", KnownOIDs.PKCS1, KnownOIDs.RSA.value());
    }
}

