/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.JFRStackFrame;
import oracle.jvm.hotspot.jfr.JFRStreamWriter;
import oracle.jvm.hotspot.jfr.ThreadGroupIDs;
import sun.jvm.hotspot.memory.SymbolTable;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.MethodArray;

public final class JFRTypeIDs {
    private static AddressField threadGroupIDsField;
    private static ThreadGroupIDs threadGroupIDs;
    private static long classCount;
    private static long methodCount;
    private static long symbolCount;
    private static ArrayList usedSymbols;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JfrTypeIDs");
        threadGroupIDsField = type.getAddressField("_threadgroupids");
    }

    public static void jfrWriteThreadGroups(JFRStreamWriter writer) {
        ThreadGroupIDs threadgroups = JFRTypeIDs.threadGroupIDs();
        if (threadgroups != null) {
            threadgroups.writeThreadGroupEntries(writer);
        }
    }

    public static ThreadGroupIDs threadGroupIDs() {
        threadGroupIDs = null;
        if (threadGroupIDsField.getValue() != null) {
            threadGroupIDs = (ThreadGroupIDs)VMObjectFactory.newObject(ThreadGroupIDs.class, threadGroupIDsField.getValue());
        }
        return threadGroupIDs;
    }

    public static void jfrFlushClasses(final JFRStreamWriter writer) {
        long content_type_start_pos = writer.getCurrentPos();
        long classcount_pos = 0L;
        long methodcount_pos = 0L;
        long symbolcount_pos = 0L;
        int ANY_USED = 3;
        int METHOD_USED = 2;
        writer.write(10);
        classcount_pos = writer.getCurrentPos();
        writer.write(0);
        SystemDictionary.ClassAndLoaderVisitor visitor = new SystemDictionary.ClassAndLoaderVisitor(){

            @Override
            public void visit(Klass k, Oop loader) {
                if ((k.traceID() & 3L) != 0L) {
                    classCount++;
                    Symbol klassname = k.getName();
                    long classid = k.traceID();
                    long cl_classid = 0L;
                    if (loader != null) {
                        Klass class_loader_klass = loader.getKlass();
                        cl_classid = class_loader_klass.traceID();
                    }
                    writer.write(classid & 0xFFFFFFFFFFFFFFFCL);
                    writer.write(cl_classid & 0xFFFFFFFFFFFFFFFCL);
                    writer.write((long)klassname.getAddress().hashCode() & 0xFFFFFFFFFFFFFFFEL);
                    writer.write((short)k.getAccessFlags());
                    usedSymbols.add(klassname);
                }
            }
        };
        VM.getVM().getSystemDictionary().classesDo(visitor);
        if (classCount > 0L) {
            writer.write(32);
            methodcount_pos = writer.getCurrentPos();
            writer.write(0);
            SystemDictionary.ClassVisitor classvisitor = new SystemDictionary.ClassVisitor(){

                @Override
                public void visit(Klass k) {
                    if ((k.traceID() & 2L) != 0L && k.getLayoutHelper() > 0) {
                        InstanceKlass ik = (InstanceKlass)k;
                        MethodArray methods = ik.getMethods();
                        int length = methods.length();
                        for (int index = 0; index < length; ++index) {
                            Method m = methods.at(index);
                            Symbol name = m.getName();
                            Symbol signature = m.getSignature();
                            InstanceKlass method_holder = m.getMethodHolder();
                            long methodID = method_holder.traceID() & 0xFFFFFFFFFFFFFFFCL | m.getConstMethod().getIdNum();
                            if (!JFRStackFrame.methodIDs.contains(methodID)) continue;
                            methodCount++;
                            writer.write(methodID);
                            writer.write(method_holder.traceID() & 0xFFFFFFFFFFFFFFFCL);
                            writer.write((long)name.getAddress().hashCode() & 0xFFFFFFFFFFFFFFFEL);
                            writer.write((long)signature.getAddress().hashCode() & 0xFFFFFFFFFFFFFFFEL);
                            writer.write((short)m.getAccessFlags());
                            writer.write((byte)0);
                            usedSymbols.add(name);
                            usedSymbols.add(signature);
                        }
                    }
                }
            };
            VM.getVM().getSystemDictionary().classesDo(classvisitor);
            writer.write(33);
            symbolcount_pos = writer.getCurrentPos();
            writer.write(0);
            SymbolTable.SymbolVisitor symvisitor = new SymbolTable.SymbolVisitor(){

                @Override
                public void visit(Symbol sym) {
                    if (!usedSymbols.contains(sym)) {
                        return;
                    }
                    symbolCount++;
                    writer.write((long)sym.getAddress().hashCode() & 0xFFFFFFFFFFFFFFFEL);
                    writer.writeString(sym.asString());
                }
            };
            VM.getVM().getSymbolTable().symbolsDo(symvisitor);
            long end = writer.getCurrentPos();
            writer.seek(classcount_pos);
            writer.write((int)classCount);
            writer.seek(methodcount_pos);
            writer.write((int)methodCount);
            writer.seek(symbolcount_pos);
            writer.write((int)symbolCount);
            writer.seek(end);
        }
    }

    static {
        classCount = 0L;
        methodCount = 0L;
        symbolCount = 0L;
        usedSymbols = new ArrayList();
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JFRTypeIDs.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

